/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr;

import com.aspose.ocr.Defect;
import com.aspose.ocr.DefectAreas;
import com.aspose.ocr.DefectType;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DefectOutput {
    public String Source = "";
    public int Page = 0;
    public ArrayList<DefectAreas> defectAreas = new ArrayList();

    DefectOutput(String string, Defect[] defectArray, int n2) {
        this.Source = string;
        this.defectAreas = this.f(defectArray);
    }

    private ArrayList<DefectAreas> f(Defect[] defectArray) {
        Map<Integer, List<Defect>> map = Arrays.stream(defectArray).filter(defect -> defect.type > 0 && DefectOutput.c0ad(defect.type)).collect(Collectors.groupingBy(defect -> defect.type));
        ArrayList<DefectAreas> arrayList = new ArrayList<DefectAreas>();
        for (Map.Entry<Integer, List<Defect>> entry : map.entrySet()) {
            int n2 = entry.getKey();
            List<Rectangle> list = entry.getValue().stream().map(defect -> new Rectangle(defect.rect.x, defect.rect.y, defect.rect.width, defect.rect.height)).collect(Collectors.toList());
            DefectAreas defectAreas = new DefectAreas();
            defectAreas.defectType = this.f(n2);
            defectAreas.rectangles = list.toArray(new Rectangle[0]);
            arrayList.add(defectAreas);
        }
        return arrayList;
    }

    private static boolean c0ad(int n2) {
        for (DefectType defectType : DefectType.values()) {
            if (defectType.ordinal() != n2) continue;
            return true;
        }
        return false;
    }

    DefectType f(int n2) {
        DefectType defectType;
        switch (n2) {
            case 1: {
                defectType = DefectType.SALT_PEPPER_NOISE;
                break;
            }
            case 2: {
                defectType = DefectType.LOW_CONTRAST;
                break;
            }
            case 3: {
                defectType = DefectType.BLUR;
                break;
            }
            case 4: {
                defectType = DefectType.GLARE;
                break;
            }
            default: {
                defectType = DefectType.ALL;
            }
        }
        return defectType;
    }
}

