# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetExternalExadataStorageServerIormPlanResult',
    'AwaitableGetExternalExadataStorageServerIormPlanResult',
    'get_external_exadata_storage_server_iorm_plan',
    'get_external_exadata_storage_server_iorm_plan_output',
]

@pulumi.output_type
class GetExternalExadataStorageServerIormPlanResult:
    """
    A collection of values returned by getExternalExadataStorageServerIormPlan.
    """
    def __init__(__self__, db_plans=None, external_exadata_storage_server_id=None, id=None, plan_objective=None, plan_status=None):
        if db_plans and not isinstance(db_plans, list):
            raise TypeError("Expected argument 'db_plans' to be a list")
        pulumi.set(__self__, "db_plans", db_plans)
        if external_exadata_storage_server_id and not isinstance(external_exadata_storage_server_id, str):
            raise TypeError("Expected argument 'external_exadata_storage_server_id' to be a str")
        pulumi.set(__self__, "external_exadata_storage_server_id", external_exadata_storage_server_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if plan_objective and not isinstance(plan_objective, str):
            raise TypeError("Expected argument 'plan_objective' to be a str")
        pulumi.set(__self__, "plan_objective", plan_objective)
        if plan_status and not isinstance(plan_status, str):
            raise TypeError("Expected argument 'plan_status' to be a str")
        pulumi.set(__self__, "plan_status", plan_status)

    @property
    @pulumi.getter(name="dbPlans")
    def db_plans(self) -> Sequence['outputs.GetExternalExadataStorageServerIormPlanDbPlanResult']:
        """
        The resource allocation directives must all use the share attribute, or they must all use the level and allocation attributes. If you use the share attribute to allocate I/O resources, then the database plan can have a maximum of 1024 directives. If you use the level and allocation attributes to allocate I/O resources, then the database plan can have a maximum of 32 directives. Only one directive is allowed for each database name and each profile name.
        """
        return pulumi.get(self, "db_plans")

    @property
    @pulumi.getter(name="externalExadataStorageServerId")
    def external_exadata_storage_server_id(self) -> str:
        return pulumi.get(self, "external_exadata_storage_server_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="planObjective")
    def plan_objective(self) -> str:
        """
        The objective of the IORM plan.
        """
        return pulumi.get(self, "plan_objective")

    @property
    @pulumi.getter(name="planStatus")
    def plan_status(self) -> str:
        """
        The status of the IORM plan.
        """
        return pulumi.get(self, "plan_status")


class AwaitableGetExternalExadataStorageServerIormPlanResult(GetExternalExadataStorageServerIormPlanResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalExadataStorageServerIormPlanResult(
            db_plans=self.db_plans,
            external_exadata_storage_server_id=self.external_exadata_storage_server_id,
            id=self.id,
            plan_objective=self.plan_objective,
            plan_status=self.plan_status)


def get_external_exadata_storage_server_iorm_plan(external_exadata_storage_server_id: Optional[str] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalExadataStorageServerIormPlanResult:
    """
    This data source provides details about a specific External Exadata Storage Server Iorm Plan resource in Oracle Cloud Infrastructure Database Management service.

    Get the IORM plan from the specific Exadata storage server.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_exadata_storage_server_iorm_plan = oci.DatabaseManagement.get_external_exadata_storage_server_iorm_plan(external_exadata_storage_server_id=test_external_exadata_storage_server["id"])
    ```


    :param str external_exadata_storage_server_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server.
    """
    __args__ = dict()
    __args__['externalExadataStorageServerId'] = external_exadata_storage_server_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getExternalExadataStorageServerIormPlan:getExternalExadataStorageServerIormPlan', __args__, opts=opts, typ=GetExternalExadataStorageServerIormPlanResult).value

    return AwaitableGetExternalExadataStorageServerIormPlanResult(
        db_plans=pulumi.get(__ret__, 'db_plans'),
        external_exadata_storage_server_id=pulumi.get(__ret__, 'external_exadata_storage_server_id'),
        id=pulumi.get(__ret__, 'id'),
        plan_objective=pulumi.get(__ret__, 'plan_objective'),
        plan_status=pulumi.get(__ret__, 'plan_status'))
def get_external_exadata_storage_server_iorm_plan_output(external_exadata_storage_server_id: Optional[pulumi.Input[str]] = None,
                                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExternalExadataStorageServerIormPlanResult]:
    """
    This data source provides details about a specific External Exadata Storage Server Iorm Plan resource in Oracle Cloud Infrastructure Database Management service.

    Get the IORM plan from the specific Exadata storage server.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_external_exadata_storage_server_iorm_plan = oci.DatabaseManagement.get_external_exadata_storage_server_iorm_plan(external_exadata_storage_server_id=test_external_exadata_storage_server["id"])
    ```


    :param str external_exadata_storage_server_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata storage server.
    """
    __args__ = dict()
    __args__['externalExadataStorageServerId'] = external_exadata_storage_server_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DatabaseManagement/getExternalExadataStorageServerIormPlan:getExternalExadataStorageServerIormPlan', __args__, opts=opts, typ=GetExternalExadataStorageServerIormPlanResult)
    return __ret__.apply(lambda __response__: GetExternalExadataStorageServerIormPlanResult(
        db_plans=pulumi.get(__response__, 'db_plans'),
        external_exadata_storage_server_id=pulumi.get(__response__, 'external_exadata_storage_server_id'),
        id=pulumi.get(__response__, 'id'),
        plan_objective=pulumi.get(__response__, 'plan_objective'),
        plan_status=pulumi.get(__response__, 'plan_status')))
