# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAnnotationFormatsResult',
    'AwaitableGetAnnotationFormatsResult',
    'get_annotation_formats',
    'get_annotation_formats_output',
]

@pulumi.output_type
class GetAnnotationFormatsResult:
    """
    A collection of values returned by getAnnotationFormats.
    """
    def __init__(__self__, annotation_format_collections=None, compartment_id=None, filters=None, id=None):
        if annotation_format_collections and not isinstance(annotation_format_collections, list):
            raise TypeError("Expected argument 'annotation_format_collections' to be a list")
        pulumi.set(__self__, "annotation_format_collections", annotation_format_collections)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="annotationFormatCollections")
    def annotation_format_collections(self) -> Sequence['outputs.GetAnnotationFormatsAnnotationFormatCollectionResult']:
        """
        The list of annotation_format_collection.
        """
        return pulumi.get(self, "annotation_format_collections")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAnnotationFormatsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetAnnotationFormatsResult(GetAnnotationFormatsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAnnotationFormatsResult(
            annotation_format_collections=self.annotation_format_collections,
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id)


def get_annotation_formats(compartment_id: Optional[str] = None,
                           filters: Optional[Sequence[Union['GetAnnotationFormatsFilterArgs', 'GetAnnotationFormatsFilterArgsDict']]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAnnotationFormatsResult:
    """
    This data source provides the list of Annotation Formats in Oracle Cloud Infrastructure Data Labeling Service service.

    These are a static list in a given region.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_annotation_formats = oci.DataLabellingService.get_annotation_formats(compartment_id=compartment_id)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataLabellingService/getAnnotationFormats:getAnnotationFormats', __args__, opts=opts, typ=GetAnnotationFormatsResult).value

    return AwaitableGetAnnotationFormatsResult(
        annotation_format_collections=pulumi.get(__ret__, 'annotation_format_collections'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_annotation_formats_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAnnotationFormatsFilterArgs', 'GetAnnotationFormatsFilterArgsDict']]]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAnnotationFormatsResult]:
    """
    This data source provides the list of Annotation Formats in Oracle Cloud Infrastructure Data Labeling Service service.

    These are a static list in a given region.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_annotation_formats = oci.DataLabellingService.get_annotation_formats(compartment_id=compartment_id)
    ```


    :param str compartment_id: The ID of the compartment in which to list resources.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataLabellingService/getAnnotationFormats:getAnnotationFormats', __args__, opts=opts, typ=GetAnnotationFormatsResult)
    return __ret__.apply(lambda __response__: GetAnnotationFormatsResult(
        annotation_format_collections=pulumi.get(__response__, 'annotation_format_collections'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
