/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.log;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.log.MaxLevelFilter;
import org.openqa.selenium.server.log.ShortTermMemoryHandler;
import org.openqa.selenium.server.log.StdOutHandler;
import org.openqa.selenium.server.log.TerseFormatter;

public class LoggingManager {
    private static Handler[] originalHandlers;
    private static Map<Handler, Formatter> originalFormatters;
    private static Map<Handler, Level> originalLogLevels;
    private static Map<File, FileHandler> seleniumFileHandlers;
    private static ShortTermMemoryHandler shortTermMemoryHandler;

    public static synchronized Log configureLogging(RemoteControlConfiguration configuration, boolean debugMode) {
        if (configuration.dontTouchLogging()) {
            return LogFactory.getLog(SeleniumServer.class);
        }
        Logger currentLogger = Logger.getLogger("");
        LoggingManager.resetLoggerToOriginalState();
        LoggingManager.overrideSimpleFormatterWithTerseOneForConsoleHandler(currentLogger, debugMode);
        LoggingManager.addInMemoryLogger(currentLogger, configuration);
        if (debugMode) {
            currentLogger.setLevel(Level.FINE);
        }
        Log seleniumServerJettyLogger = LogFactory.getLog(SeleniumServer.class);
        if (null != configuration.getLogOutFile()) {
            LoggingManager.addNewSeleniumFileHandler(currentLogger, configuration);
            seleniumServerJettyLogger.info("Writing debug logs to " + configuration.getLogOutFile());
        }
        return seleniumServerJettyLogger;
    }

    public static synchronized ShortTermMemoryHandler shortTermMemoryHandler() {
        return shortTermMemoryHandler;
    }

    private static void addInMemoryLogger(Logger logger, RemoteControlConfiguration configuration) {
        shortTermMemoryHandler = new ShortTermMemoryHandler(configuration.shortTermMemoryLoggerCapacity(), Level.INFO, new TerseFormatter(true));
        logger.addHandler(shortTermMemoryHandler);
    }

    private static File addNewSeleniumFileHandler(Logger currentLogger, RemoteControlConfiguration configuration) {
        try {
            File logFile = configuration.getLogOutFile();
            FileHandler fileHandler = seleniumFileHandlers.get(logFile);
            if (fileHandler == null) {
                fileHandler = LoggingManager.registerNewSeleniumFileHandler(logFile);
            }
            fileHandler.setFormatter(new TerseFormatter(true));
            currentLogger.setLevel(Level.FINE);
            fileHandler.setLevel(Level.FINE);
            currentLogger.addHandler(fileHandler);
            return logFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static FileHandler registerNewSeleniumFileHandler(File logFile) throws IOException {
        FileHandler fileHandler = new FileHandler(logFile.getAbsolutePath());
        seleniumFileHandlers.put(logFile, fileHandler);
        return fileHandler;
    }

    public static void overrideSimpleFormatterWithTerseOneForConsoleHandler(Logger logger, boolean debugMode) {
        for (Handler handler : logger.getHandlers()) {
            Formatter formatter;
            if (!(handler instanceof ConsoleHandler) || !((formatter = handler.getFormatter()) instanceof SimpleFormatter)) continue;
            Level originalLevel = handler.getLevel();
            handler.setFormatter(new TerseFormatter(false));
            handler.setLevel(Level.WARNING);
            StdOutHandler stdOutHandler = new StdOutHandler();
            stdOutHandler.setFormatter(new TerseFormatter(false));
            stdOutHandler.setFilter(new MaxLevelFilter(Level.INFO));
            stdOutHandler.setLevel(originalLevel);
            logger.addHandler(stdOutHandler);
            if (!debugMode || originalLevel.intValue() <= Level.FINE.intValue()) continue;
            stdOutHandler.setLevel(Level.FINE);
        }
    }

    protected static void resetLoggerToOriginalState() {
        Logger logger = Logger.getLogger("");
        if (originalHandlers == null) {
            LoggingManager.saveOriginalHandlersFormattersAndLevels(logger);
        } else {
            LoggingManager.restoreOriginalHandlersFormattersAndLevels(logger);
        }
    }

    protected static void restoreOriginalHandlersFormattersAndLevels(Logger logger) {
        for (Handler handler : logger.getHandlers()) {
            logger.removeHandler(handler);
        }
        for (Handler handler : originalHandlers) {
            logger.addHandler(handler);
            if (originalFormatters.get(handler) != null) {
                handler.setFormatter(originalFormatters.get(handler));
            }
            handler.setLevel(originalLogLevels.get(handler));
        }
    }

    protected static void saveOriginalHandlersFormattersAndLevels(Logger logger) {
        originalHandlers = logger.getHandlers();
        originalFormatters = new HashMap<Handler, Formatter>();
        originalLogLevels = new HashMap<Handler, Level>();
        for (Handler handler : originalHandlers) {
            originalFormatters.put(handler, handler.getFormatter());
            originalLogLevels.put(handler, handler.getLevel());
        }
    }

    static {
        seleniumFileHandlers = new HashMap<File, FileHandler>();
    }
}

