/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.commands;

import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import junit.framework.TestCase;
import org.easymock.classextension.ConstructorArgs;
import org.easymock.classextension.EasyMock;
import org.openqa.selenium.server.commands.CaptureScreenshotCommand;

public class CaptureScreenshotCommandUnitTest
extends TestCase {
    private CaptureScreenshotCommand command;
    private String fileName = "test_screenshot.png";
    private File file = new File(this.fileName);
    private String tempDirName = System.getProperty("java.io.tmpdir");

    public void testDumbJUnit() {
    }

    public void disable_testExecuteReturnsOKWhencaptureSystemScreenshotSucceeds() throws Exception {
        ConstructorArgs args = new ConstructorArgs(CaptureScreenshotCommand.class.getConstructor(String.class), new Object[]{this.fileName});
        this.command = (CaptureScreenshotCommand)EasyMock.createMock(CaptureScreenshotCommand.class, (ConstructorArgs)args, (Method[])new Method[]{CaptureScreenshotCommand.class.getDeclaredMethod("captureSystemScreenshot", new Class[0])});
        this.command.captureSystemScreenshot();
        EasyMock.replay((Object[])new Object[]{this.command});
        CaptureScreenshotCommandUnitTest.assertEquals((String)"OK", (String)this.command.execute());
        EasyMock.verify((Object[])new Object[]{this.command});
    }

    public void disable_testExecuteReturnsAnErrorWhencaptureSystemScreenshotRaise() throws Exception {
        ConstructorArgs args = new ConstructorArgs(CaptureScreenshotCommand.class.getConstructor(String.class), new Object[]{this.fileName});
        this.command = (CaptureScreenshotCommand)EasyMock.createMock(CaptureScreenshotCommand.class, (ConstructorArgs)args, (Method[])new Method[]{CaptureScreenshotCommand.class.getDeclaredMethod("captureSystemScreenshot", new Class[0])});
        this.command.captureSystemScreenshot();
        EasyMock.expectLastCall().andThrow((Throwable)new RuntimeException("an error message"));
        EasyMock.replay((Object[])new Object[]{this.command});
        CaptureScreenshotCommandUnitTest.assertEquals((String)"ERROR: Problem capturing screenshot: an error message", (String)this.command.execute());
        EasyMock.verify((Object[])new Object[]{this.command});
    }

    public void disable_testTakingScreenshotToSingleFileNameCreatesScreenshotInWorkingDirectory() throws Exception {
        this.command = new CaptureScreenshotCommand(this.file);
        CaptureScreenshotCommandUnitTest.assertEquals((String)"OK", (String)this.command.execute());
        CaptureScreenshotCommandUnitTest.assertTrue((boolean)this.file.exists());
    }

    public void disable_testTakingScreenshotToAbsolutePathWithExistingComponentsCreatesScreenshot() throws Exception {
        this.file = new File(this.tempDirName + File.separator + this.fileName);
        this.command = new CaptureScreenshotCommand(this.file);
        CaptureScreenshotCommandUnitTest.assertEquals((String)"OK", (String)this.command.execute());
        CaptureScreenshotCommandUnitTest.assertTrue((boolean)this.file.exists());
    }

    public void disable_testTakingScreenshotToAbsolutePathWithPartiallyExistingComponentsCreatesNecessaryDirectories() throws Exception {
        this.file = new File(this.tempDirName + File.separator + "toBeCreated" + File.separator + this.fileName);
        this.command = new CaptureScreenshotCommand(this.file);
        CaptureScreenshotCommandUnitTest.assertEquals((String)"OK", (String)this.command.execute());
        CaptureScreenshotCommandUnitTest.assertTrue((boolean)this.file.exists());
    }

    public void disable_testScreenshotIsValidImage() throws Exception {
        this.disable_testTakingScreenshotToSingleFileNameCreatesScreenshotInWorkingDirectory();
        BufferedImage image = ImageIO.read(this.file);
        CaptureScreenshotCommandUnitTest.assertNotNull((Object)image);
    }

    public void tearDown() throws Exception {
        if (this.file.exists()) {
            this.file.delete();
        }
        if (this.file.getParentFile() != null && this.file.getParentFile().exists()) {
            this.file.getParentFile().delete();
        }
    }
}

