import { Stack } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface TargetResource {
    readonly tagKey: string;
    readonly tagValues: string[];
}
export interface Schedule {
    readonly timezone: string;
    readonly minute?: string;
    readonly hour?: string;
    readonly week?: string;
}
export interface Notifications {
    readonly emails?: string[];
}
export interface EC2InstanceRunningScheduleStackProps {
    readonly targetResource: TargetResource;
    readonly stopSchedule?: Schedule;
    readonly startSchedule?: Schedule;
    readonly notifications?: Notifications;
}
export declare class EC2InstanceRunningScheduleStack extends Stack {
    constructor(scope: Construct, id: string, props: EC2InstanceRunningScheduleStackProps);
}
