"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EC2InstanceRunningScheduleStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const iam = require("aws-cdk-lib/aws-iam");
const scheduler = require("aws-cdk-lib/aws-scheduler");
const sns = require("aws-cdk-lib/aws-sns");
const running_control_state_machine_1 = require("./resources/running-control-state-machine");
class EC2InstanceRunningScheduleStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id);
        const topic = new sns.Topic(this, 'NotificationTopic', {
        // topicName: names.notificationTopicName,
        // displayName: names.notificationTopicDisplayName,
        });
        const emails = props.notifications?.emails ?? [];
        for (const [index, value] of emails.entries()) {
            new sns.Subscription(this, `SubscriptionEmail${index.toString().padStart(3, '0')}`, {
                topic,
                protocol: sns.SubscriptionProtocol.EMAIL,
                endpoint: value,
            });
        }
        // 👇 StepFunctions State Machine
        const machine = new running_control_state_machine_1.RunningControlStateMachine(this, 'StateMachine', {
            stateMachineName: undefined,
            notificationTopic: topic,
        });
        // 👇 EventBridge Scheduler IAM Role
        const schedulerExecutionRole = new iam.Role(this, 'SchedulerExecutionRole', {
            roleName: undefined,
            assumedBy: new iam.ServicePrincipal('scheduler.amazonaws.com'),
            inlinePolicies: {
                'state-machine-exec-policy': new iam.PolicyDocument({
                    statements: [
                        new iam.PolicyStatement({
                            effect: iam.Effect.ALLOW,
                            actions: [
                                'states:StartExecution',
                            ],
                            resources: [
                                machine.stateMachineArn,
                            ],
                        }),
                    ],
                }),
            },
        });
        // 👇 Stop Schedule expression
        const stopScheduleExpression = (() => {
            // default: weekday 21:10
            const minute = props.stopSchedule?.minute ?? '10';
            const hour = props.stopSchedule?.hour ?? '21';
            const week = props.stopSchedule?.week ?? 'MON-FRI';
            return `cron(${minute} ${hour} ? * ${week} *)`;
        })();
        // 👇 Start Schedule expression
        const startScheduleExpression = (() => {
            // default: weekday 07:50
            const minute = props.startSchedule?.minute ?? '50';
            const hour = props.startSchedule?.hour ?? '7';
            const week = props.startSchedule?.week ?? 'MON-FRI';
            return `cron(${minute} ${hour} ? * ${week} *)`;
        })();
        // 👇 Stop EC2 instance schedule
        new InstanceRuningSchedule(this, 'StopDatabaseRunningSchedule', {
            name: undefined,
            description: 'stop database(instance/cluster) running stop schedule.',
            sheduleState: 'ENABLED',
            timezone: props.stopSchedule?.timezone ?? 'UTC',
            expression: stopScheduleExpression,
            target: {
                stateMachineArn: machine.stateMachineArn,
                roleArn: schedulerExecutionRole.roleArn,
                resourceTag: {
                    key: props.targetResource.tagKey,
                    values: props.targetResource.tagValues,
                },
                input: { mode: 'Stop' },
            },
        });
        // 👇 Start EC2 instance schedule
        new InstanceRuningSchedule(this, 'StartDatabaseRunningSchedule', {
            name: undefined,
            description: 'start db instance schedule.',
            sheduleState: 'ENABLED',
            timezone: props.startSchedule?.timezone ?? 'UTC',
            expression: startScheduleExpression,
            target: {
                stateMachineArn: machine.stateMachineArn,
                roleArn: schedulerExecutionRole.roleArn,
                resourceTag: {
                    key: props.targetResource.tagKey,
                    values: props.targetResource.tagValues,
                },
                input: { mode: 'Start' },
            },
        });
    }
}
exports.EC2InstanceRunningScheduleStack = EC2InstanceRunningScheduleStack;
_a = JSII_RTTI_SYMBOL_1;
EC2InstanceRunningScheduleStack[_a] = { fqn: "@gammarers/aws-ec2-instance-running-schedule-stack.EC2InstanceRunningScheduleStack", version: "2.1.1" };
class InstanceRuningSchedule extends scheduler.CfnSchedule {
    constructor(scope, id, props) {
        super(scope, id, {
            name: props.name,
            description: props.description,
            state: props.sheduleState,
            //groupName: scheduleGroup.name, // default
            flexibleTimeWindow: {
                mode: 'OFF',
            },
            scheduleExpressionTimezone: props.timezone,
            scheduleExpression: props.expression,
            target: {
                arn: props.target.stateMachineArn,
                roleArn: props.target.roleArn,
                input: JSON.stringify({
                    Params: {
                        TagKey: props.target.resourceTag.key,
                        TagValues: props.target.resourceTag.values,
                        Mode: props.target.input.mode,
                    },
                }),
                retryPolicy: {
                    maximumEventAgeInSeconds: 60,
                    maximumRetryAttempts: 0,
                },
            },
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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