"""Auto generated code by selector_schema_codegen

id: animego
name: animego
author: vypivshiy
description:
    animego schema extractors
headers required:
  "x-requested-with": "XMLHttpRequest
  "User-Agent": ...

source: https://animego.org
tags:
    anime, parser

WARNING: Any manual changes made to this file will be lost when this
is run again. Do not edit this file unless you know what you are doing.
"""

from __future__ import annotations  # python 3.7, 3.8 typing comp
from typing import Any
import re

from parsel import Selector, SelectorList


class __BaseViewModel:
    def __init__(self, document: str):
        self.__raw__ = document
        self.__selector__ = Selector(document)
        self._cached_result: list[dict[str, Any]] = []
        self._aliases: dict[str, str] = {}
        self._view_keys: list[str] = []

    def _pre_validate(self, doc):
        pass

    def _start_parse(self):
        pass

    def _part_document(self, part: Selector):
        pass

    def parse(self):
        self._pre_validate(self.__selector__)
        self._start_parse()
        return self

    def view(self) -> list[dict[str, list[str] | str]]:
        def map_fields(result):
            view_dict = {}
            for k in self._view_keys:
                v = result.get(k)
                if v != None:
                    k = self._aliases.get(k, k)
                    view_dict[k] = v
            return view_dict

        if len(self._cached_result) == 1:
            return [map_fields(self._cached_result[0])]
        return [map_fields(result) for result in self._cached_result]


class OngoingView(__BaseViewModel):
    """
        Get all available ongoings from main page
    Prepare:
      1. GET https://animego.org

        view() elements signature:

            url <TEXT> - anime page

            title <TEXT> - ongoing name

            thumbnail <TEXT> - ongoing thumbnail image

            episode <TEXT> - episode num

            dub <TEXT> - dubber name


    """

    def __init__(self, document: str):
        super().__init__(document)
        self._aliases = {}
        self._view_keys = ["url", "title", "thumbnail", "episode", "dub"]

    def _pre_validate(self, part: Selector):
        val_0 = part.css("title")
        val_1 = val_0.xpath("./text()").get()
        assert re.search(r"Смотреть Аниме онлайн", val_1)

    def _part_document(self, part: Selector):
        val_0 = part.css(".border-bottom-0.cursor-pointer")
        return val_0

    def _parse_url(self, part: Selector) -> str:
        # script signature:
        # attr "onclick"
        # lstrip "location.href="
        # strip "'"
        # format "https://animego.org{{}}"
        #
        val_0 = part.attrib["onclick"]
        val_1 = val_0.lstrip("location.href=")
        val_2 = val_1.strip("'")
        val_3 = "https://animego.org{}".format(val_2)
        return val_3

    def _parse_title(self, part: Selector) -> str:
        # script signature:
        # css ".last-update-title"
        # text
        #
        val_0 = part.css(".last-update-title")
        val_1 = val_0.xpath("./text()").get()
        return val_1

    def _parse_thumbnail(self, part: Selector) -> str:
        # script signature:
        # css ".lazy"
        # attr "style"
        # lstrip "background-image: url("
        # rstrip ");"
        #
        val_0 = part.css(".lazy")
        val_1 = val_0.attrib["style"]
        val_2 = val_1.lstrip("background-image: url(")
        val_3 = val_2.rstrip(");")
        return val_3

    def _parse_episode(self, part: Selector) -> str:
        # script signature:
        # css ".text-truncate"
        # text
        # re "(\d+)\s"
        #
        val_0 = part.css(".text-truncate")
        val_1 = val_0.xpath("./text()").get()
        val_2 = re.search(r"(\d+)\s", val_1)[1]
        return val_2

    def _parse_dub(self, part: Selector) -> str:
        # script signature:
        # css ".text-gray-dark-6"
        # text
        #
        val_0 = part.css(".text-gray-dark-6")
        val_1 = val_0.xpath("./text()").get()
        return val_1

    def _start_parse(self):
        # clear cache
        self._cached_result.clear()
        for part in self._part_document(self.__selector__):
            self._cached_result.append(
                {
                    "url": self._parse_url(part),
                    "title": self._parse_title(part),
                    "thumbnail": self._parse_thumbnail(part),
                    "episode": self._parse_episode(part),
                    "dub": self._parse_dub(part),
                }
            )


class SearchView(__BaseViewModel):
    """
        Get all search results by query
    Prepare:
      1. GET to https://animego.org/search/anime?q={QUERY}

        view() elements signature:

            title <TEXT> - title name

            thumbnail <TEXT> - thumbnail image

            url <TEXT> - anime page link


    """

    def __init__(self, document: str):
        super().__init__(document)
        self._aliases = {}
        self._view_keys = ["title", "thumbnail", "url"]

    def _pre_validate(self, part: Selector):
        pass

    def _part_document(self, part: Selector):
        val_0 = part.css(".row > .col-ul-2")
        return val_0

    def _parse_title(self, part: Selector) -> str:
        # script signature:
        # css ".text-truncate a"
        # attr "title"
        #
        val_0 = part.css(".text-truncate a")
        val_1 = val_0.attrib["title"]
        return val_1

    def _parse_thumbnail(self, part: Selector) -> str:
        # script signature:
        # css ".lazy"
        # attr "data-original"
        #
        val_0 = part.css(".lazy")
        val_1 = val_0.attrib["data-original"]
        return val_1

    def _parse_url(self, part: Selector) -> str:
        # script signature:
        # css ".text-truncate a"
        # attr "href"
        #
        val_0 = part.css(".text-truncate a")
        val_1 = val_0.attrib["href"]
        return val_1

    def _start_parse(self):
        # clear cache
        self._cached_result.clear()
        for part in self._part_document(self.__selector__):
            self._cached_result.append(
                {
                    "title": self._parse_title(part),
                    "thumbnail": self._parse_thumbnail(part),
                    "url": self._parse_url(part),
                }
            )


class AnimeView(__BaseViewModel):
    """
        Anime page information
    Prepare:
      1. GET to anime page EG: https://animego.org/anime/eksperimenty-leyn-1114

        view() elements signature:

            title <TEXT> - anime title

            description <TEXT> - anime description

            thumbnail <TEXT> -

            id <TEXT> - anime id required for next requests (for DubberView, Source schemas)

            raw_json <TEXT> - for parse extra metadata


    """

    def __init__(self, document: str):
        super().__init__(document)
        self._aliases = {}
        self._view_keys = ["title", "description", "thumbnail", "id", "raw_json"]

    def _pre_validate(self, part: Selector):
        val_0 = part.css("title")
        val_1 = val_0.xpath("./text()").get()
        assert re.search(r".* смотреть онлайн .*", val_1)

    def _part_document(self, part: Selector):
        return [part]

    def _parse_title(self, part: Selector) -> str:
        # script signature:
        # css ".anime-title h1"
        # text
        #
        val_0 = part.css(".anime-title h1")
        val_1 = val_0.xpath("./text()").get()
        return val_1

    def _parse_description(self, part: Selector) -> str:
        # script signature:
        # cssAll ".description"
        # text
        # join " "
        #
        val_0 = part.css(".description")
        val_1 = val_0.xpath("./text()").getall()
        val_2 = " ".join(val_1)
        return val_2

    def _parse_thumbnail(self, part: Selector) -> str:
        # script signature:
        # css "#content img"
        # attr "src"
        #
        val_0 = part.css("#content img")
        val_1 = val_0.attrib["src"]
        return val_1

    def _parse_id(self, part: Selector) -> str:
        # script signature:
        # css ".br-2 .my-list-anime"
        # attr "id"
        # lstrip "my-list-"
        #
        val_0 = part.css(".br-2 .my-list-anime")
        val_1 = val_0.attrib["id"]
        val_2 = val_1.lstrip("my-list-")
        return val_2

    def _parse_raw_json(self, part: Selector) -> str:
        # script signature:
        # // useful for parse extra metadata
        # css "script[type='application/ld+json']"
        # text
        #
        val_0 = part.css("script[type='application/ld+json']")
        val_1 = val_0.xpath("./text()").get()
        return val_1

    def _start_parse(self):
        # clear cache
        self._cached_result.clear()
        for part in self._part_document(self.__selector__):
            self._cached_result.append(
                {
                    "title": self._parse_title(part),
                    "description": self._parse_description(part),
                    "thumbnail": self._parse_thumbnail(part),
                    "id": self._parse_id(part),
                    "raw_json": self._parse_raw_json(part),
                }
            )


class DubbersView(__BaseViewModel):
    """
        Representation dubbers in {id: 'dubber_id', name: 'dubber_name'}

    Prepare:
      1. get id from Anime object
      2. GET 'https://animego.org/anime/{Anime.id}/player?_allow=true'
      3. extract html from json by ['content'] key
      4. OPTIONAL: unescape HTML

        view() elements signature:

            id <TEXT> - dubber_id

            name <TEXT> - dubber name


    """

    def __init__(self, document: str):
        super().__init__(document)
        self._aliases = {}
        self._view_keys = ["id", "name"]

    def _pre_validate(self, part: Selector):
        assert part.css("#video-dubbing .mb-1")

    def _part_document(self, part: Selector):
        val_0 = part.css("#video-dubbing .mb-1")
        return val_0

    def _parse_id(self, part: Selector) -> str:
        # script signature:
        # attr "data-dubbing"
        #
        val_0 = part.attrib["data-dubbing"]
        return val_0

    def _parse_name(self, part: Selector) -> str:
        # script signature:
        # css "span"
        # text
        # strip "\n"
        # strip " "
        #
        val_0 = part.css("span")
        val_1 = val_0.xpath("./text()").get()
        val_2 = val_1.strip("\n")
        val_3 = val_2.strip(" ")
        return val_3

    def _start_parse(self):
        # clear cache
        self._cached_result.clear()
        for part in self._part_document(self.__selector__):
            self._cached_result.append(
                {
                    "id": self._parse_id(part),
                    "name": self._parse_name(part),
                }
            )


class EpisodeView(__BaseViewModel):
    """
        Representation episodes

    Prepare:
      1. get id from Anime object
      2. GET 'https://animego.org/anime/{Anime.id}/player?_allow=true'
      3. extract html from json by ['content'] key
      4. OPTIONAL: unescape HTML

        view() elements signature:

            num <TEXT> - episode number

            title <TEXT> - episode name

            id <TEXT> - episode id REQUIRED for extract video


    """

    def __init__(self, document: str):
        super().__init__(document)
        self._aliases = {}
        self._view_keys = ["num", "title", "id"]

    def _pre_validate(self, part: Selector):
        assert part.css("#video-carousel .mb-0")

    def _part_document(self, part: Selector):
        val_0 = part.css("#video-carousel .mb-0")
        return val_0

    def _parse_num(self, part: Selector) -> str:
        # script signature:
        # attr "data-episode"
        #
        val_0 = part.attrib["data-episode"]
        return val_0

    def _parse_title(self, part: Selector) -> str:
        # script signature:
        # attr "data-episode-title"
        #
        val_0 = part.attrib["data-episode-title"]
        return val_0

    def _parse_id(self, part: Selector) -> str:
        # script signature:
        # attr "data-id"
        #
        val_0 = part.attrib["data-id"]
        return val_0

    def _start_parse(self):
        # clear cache
        self._cached_result.clear()
        for part in self._part_document(self.__selector__):
            self._cached_result.append(
                {
                    "num": self._parse_num(part),
                    "title": self._parse_title(part),
                    "id": self._parse_id(part),
                }
            )


class SourceView(__BaseViewModel):
    """
        representation videos

    Prepare:
      1. get num and id from Episode
      2. GET https://animego.org/anime/series with  params
        {"dubbing": 2, "provider": 24, "episode": Episode.num, "id": Episode.id}
      2. extract html from json by ["content"] key
      3. OPTIONAL: unescape

        view() elements signature:

            title <TEXT> - video name

            url <TEXT> -

            data_provider <TEXT> -

            data_provide_dubbing <TEXT> -


    """

    def __init__(self, document: str):
        super().__init__(document)
        self._aliases = {}
        self._view_keys = ["title", "url", "data_provider", "data_provide_dubbing"]

    def _pre_validate(self, part: Selector):
        pass

    def _part_document(self, part: Selector):
        val_0 = part.css("#video-players > span")
        return val_0

    def _parse_title(self, part: Selector) -> str:
        # script signature:
        # text
        #
        val_0 = part.xpath("./text()").get()
        return val_0

    def _parse_url(self, part: Selector) -> str:
        # script signature:
        # attr "data-player"
        # format "https:{{}}"
        #
        val_0 = part.attrib["data-player"]
        val_1 = "https:{}".format(val_0)
        return val_1

    def _parse_data_provider(self, part: Selector) -> str:
        # script signature:
        # attr "data-provider"
        #
        val_0 = part.attrib["data-provider"]
        return val_0

    def _parse_data_provide_dubbing(self, part: Selector) -> str:
        # script signature:
        # attr "data-provide-dubbing"
        #
        val_0 = part.attrib["data-provide-dubbing"]
        return val_0

    def _start_parse(self):
        # clear cache
        self._cached_result.clear()
        for part in self._part_document(self.__selector__):
            self._cached_result.append(
                {
                    "title": self._parse_title(part),
                    "url": self._parse_url(part),
                    "data_provider": self._parse_data_provider(part),
                    "data_provide_dubbing": self._parse_data_provide_dubbing(part),
                }
            )
