"""Auto generated code by selector_schema_codegen

id: animejoy
name: project name
author: username
description:
    animejoy.ru parser.

NOTE: this source have CLOUDFLARE sometimes maybe not works
  Usually adding a delay helps

source: animejoy.ru
tags:
    any

WARNING: Any manual changes made to this file will be lost when this
is run again. Do not edit this file unless you know what you are doing.
"""

from __future__ import annotations  # python 3.7, 3.8 typing comp
from typing import Any
import re

from parsel import Selector, SelectorList


class __BaseViewModel:
    def __init__(self, document: str):
        self.__raw__ = document
        self.__selector__ = Selector(document)
        self._cached_result: list[dict[str, Any]] = []
        self._aliases: dict[str, str] = {}
        self._view_keys: list[str] = []

    def _pre_validate(self, doc):
        pass

    def _start_parse(self):
        pass

    def _part_document(self, part: Selector):
        pass

    def parse(self):
        self._pre_validate(self.__selector__)
        self._start_parse()
        return self

    def view(self) -> list[dict[str, list[str] | str]]:
        def map_fields(result):
            view_dict = {}
            for k in self._view_keys:
                v = result.get(k)
                if v != None:
                    k = self._aliases.get(k, k)
                    view_dict[k] = v
            return view_dict

        if len(self._cached_result) == 1:
            return [map_fields(self._cached_result[0])]
        return [map_fields(result) for result in self._cached_result]


class OngoingView(__BaseViewModel):
    """
      Prepare:
    1. GET https://animejoy.ru

      view() elements signature:

          title <TEXT> - title name

          alt_title <TEXT> - alternative name

          url <TEXT> - url to anime page

          thumbnail <TEXT> - thumbnail image


    """

    def __init__(self, document: str):
        super().__init__(document)
        self._aliases = {}
        self._view_keys = ["title", "alt_title", "url", "thumbnail"]

    def _pre_validate(self, part: Selector):
        val_0 = part.css("title")
        val_1 = val_0.xpath("./text()").get()
        assert re.search(r"AnimeJoy.Ru аниме с субтитрами", val_1)

    def _part_document(self, part: Selector):
        val_0 = part.css(".shortstory")
        return val_0

    def _parse_title(self, part: Selector) -> str:
        # script signature:
        # css ".ntitle > a"
        # text
        #
        val_0 = part.css(".ntitle > a")
        val_1 = val_0.xpath("./text()").get()
        return val_1

    def _parse_alt_title(self, part: Selector) -> str:
        # script signature:
        # css ".romanji"
        # text
        #
        val_0 = part.css(".romanji")
        val_1 = val_0.xpath("./text()").get()
        return val_1

    def _parse_url(self, part: Selector) -> str:
        # script signature:
        # css ".ntitle > a"
        # attr "href"
        #
        val_0 = part.css(".ntitle > a")
        val_1 = val_0.attrib["href"]
        return val_1

    def _parse_thumbnail(self, part: Selector) -> str:
        # script signature:
        # css ".fr-fil"
        # attr "src"
        # format "https://animejoy.ru{{}}"
        #
        val_0 = part.css(".fr-fil")
        val_1 = val_0.attrib["src"]
        val_2 = "https://animejoy.ru{}".format(val_1)
        return val_2

    def _start_parse(self):
        # clear cache
        self._cached_result.clear()
        for part in self._part_document(self.__selector__):
            self._cached_result.append(
                {
                    "title": self._parse_title(part),
                    "alt_title": self._parse_alt_title(part),
                    "url": self._parse_url(part),
                    "thumbnail": self._parse_thumbnail(part),
                }
            )


class SearchView(__BaseViewModel):
    """
      Prepare:
    1. POST https://animejoy.ru/
    data payload:
      story: <QUERY>
      do: search
      subaction: search

      view() elements signature:

          title <TEXT> - title name

          alt_title <TEXT> - alternative title name

          url <TEXT> - anime url page

          thumbnail <TEXT> -


    """

    def __init__(self, document: str):
        super().__init__(document)
        self._aliases = {}
        self._view_keys = ["title", "alt_title", "url", "thumbnail"]

    def _pre_validate(self, part: Selector):
        val_0 = part.css("title")
        val_1 = val_0.xpath("./text()").get()
        assert re.search(r"Поиск по сайту", val_1)

    def _part_document(self, part: Selector):
        val_0 = part.css(".shortstory")
        return val_0

    def _parse_title(self, part: Selector) -> str:
        # script signature:
        # css ".ntitle > a"
        # text
        #
        val_0 = part.css(".ntitle > a")
        val_1 = val_0.xpath("./text()").get()
        return val_1

    def _parse_alt_title(self, part: Selector) -> str:
        # script signature:
        # css ".romanji"
        # text
        #
        val_0 = part.css(".romanji")
        val_1 = val_0.xpath("./text()").get()
        return val_1

    def _parse_url(self, part: Selector) -> str:
        # script signature:
        # css ".ntitle > a"
        # attr "href"
        #
        val_0 = part.css(".ntitle > a")
        val_1 = val_0.attrib["href"]
        return val_1

    def _parse_thumbnail(self, part: Selector) -> str:
        # script signature:
        # css ".fr-fil"
        # attr "src"
        # format "https://animejoy.ru{{}}"
        #
        val_0 = part.css(".fr-fil")
        val_1 = val_0.attrib["src"]
        val_2 = "https://animejoy.ru{}".format(val_1)
        return val_2

    def _start_parse(self):
        # clear cache
        self._cached_result.clear()
        for part in self._part_document(self.__selector__):
            self._cached_result.append(
                {
                    "title": self._parse_title(part),
                    "alt_title": self._parse_alt_title(part),
                    "url": self._parse_url(part),
                    "thumbnail": self._parse_thumbnail(part),
                }
            )


class AnimeView(__BaseViewModel):
    """
      Prepare:
    1. GET to anime page

      view() elements signature:

          title <TEXT> - title name

          alt_title <TEXT> - alternative title name

          thumbnail <TEXT> - thumbnail image

          description <TEXT> - anime description

          news_id <TEXT> - anime id for payload requests (PlayerView, PlayerUrlsView)


    """

    def __init__(self, document: str):
        super().__init__(document)
        self._aliases = {}
        self._view_keys = ["title", "alt_title", "thumbnail", "description", "news_id"]

    def _pre_validate(self, part: Selector):
        val_0 = part.css(".logotype > img")
        val_1 = val_0.attrib["src"]
        assert re.search(r"AnimeJoy", val_1)

    def _part_document(self, part: Selector):
        return [part]

    def _parse_title(self, part: Selector) -> str:
        # script signature:
        # css ".ntitle"
        # text
        #
        val_0 = part.css(".ntitle")
        val_1 = val_0.xpath("./text()").get()
        return val_1

    def _parse_alt_title(self, part: Selector) -> str:
        # script signature:
        # css ".romanji"
        # text
        #
        val_0 = part.css(".romanji")
        val_1 = val_0.xpath("./text()").get()
        return val_1

    def _parse_thumbnail(self, part: Selector) -> str:
        # script signature:
        # css ".fr-fil"
        # attr "src"
        # format "https://animejoy.ru{{}}"
        #
        val_0 = part.css(".fr-fil")
        val_1 = val_0.attrib["src"]
        val_2 = "https://animejoy.ru{}".format(val_1)
        return val_2

    def _parse_description(self, part: Selector) -> str:
        # script signature:
        # css ".pcdescrf p"
        # text
        #
        val_0 = part.css(".pcdescrf p")
        val_1 = val_0.xpath("./text()").get()
        return val_1

    def _parse_news_id(self, part: Selector) -> str:
        # script signature:
        # css "div.playlists-ajax"
        # attr "data-news_id"
        #
        val_0 = part.css("div.playlists-ajax")
        val_1 = val_0.attrib["data-news_id"]
        return val_1

    def _start_parse(self):
        # clear cache
        self._cached_result.clear()
        for part in self._part_document(self.__selector__):
            self._cached_result.append(
                {
                    "title": self._parse_title(part),
                    "alt_title": self._parse_alt_title(part),
                    "thumbnail": self._parse_thumbnail(part),
                    "description": self._parse_description(part),
                    "news_id": self._parse_news_id(part),
                }
            )


class PlayerView(__BaseViewModel):
    """
        Represent player name and player id
    Prepare:
      1. get news_id from Anime
      2. GET https://animejoy.ru/engine/ajax/playlists.php?news_id={Anime.news_id}&xfield=playlist
      3. deserialize json, get HTML by "response" key
      4. OPTIONAL: Unescape document

        view() elements signature:

            id <TEXT> - player id

            name <TEXT> - player name


    """

    def __init__(self, document: str):
        super().__init__(document)
        self._aliases = {}
        self._view_keys = ["id", "name"]

    def _pre_validate(self, part: Selector):
        assert part.css(".playlists-player > .playlists-lists ul > li")

    def _part_document(self, part: Selector):
        val_0 = part.css(".playlists-player > .playlists-lists ul > li")
        return val_0

    def _parse_id(self, part: Selector) -> str:
        # script signature:
        # attr "data-id"
        #
        val_0 = part.attrib["data-id"]
        return val_0

    def _parse_name(self, part: Selector) -> str:
        # script signature:
        # text
        #
        val_0 = part.xpath("./text()").get()
        return val_0

    def _start_parse(self):
        # clear cache
        self._cached_result.clear()
        for part in self._part_document(self.__selector__):
            self._cached_result.append(
                {
                    "id": self._parse_id(part),
                    "name": self._parse_name(part),
                }
            )


class PlayerUrlsView(__BaseViewModel):
    """
        Represent player url and player id

    Prepare:
      1. get news_id from Anime
      2. GET https://animejoy.ru/engine/ajax/playlists.php?news_id={Anime.news_id}&xfield=playlist
      3. get json, get HTML by "response" key
      4. OPTIONAL: Unescape document

        view() elements signature:

            id <TEXT> - player id

            url <TEXT> - player url. WARNING! maybe `https:` prefix exclude!


    """

    def __init__(self, document: str):
        super().__init__(document)
        self._aliases = {}
        self._view_keys = ["id", "url"]

    def _pre_validate(self, part: Selector):
        assert part.css(".playlists-videos > .playlists-items ul > li")

    def _part_document(self, part: Selector):
        val_0 = part.css(".playlists-videos > .playlists-items ul > li")
        return val_0

    def _parse_id(self, part: Selector) -> str:
        # script signature:
        # attr "data-id"
        #
        val_0 = part.attrib["data-id"]
        return val_0

    def _parse_url(self, part: Selector) -> str:
        # script signature:
        # attr "data-file"
        #
        val_0 = part.attrib["data-file"]
        return val_0

    def _start_parse(self):
        # clear cache
        self._cached_result.clear()
        for part in self._part_document(self.__selector__):
            self._cached_result.append(
                {
                    "id": self._parse_id(part),
                    "url": self._parse_url(part),
                }
            )
