"""Auto generated code by selector_schema_codegen

id: sovetromantica
name: sovetromantica
author: vypivshiy
description:
    sovetromantica parser
source: https://sovetromantica.com
tags:
    any

WARNING: Any manual changes made to this file will be lost when this
is run again. Do not edit this file unless you know what you are doing.
"""

from __future__ import annotations  # python 3.7, 3.8 typing comp
from typing import Any
import re

from parsel import Selector, SelectorList


class __BaseViewModel:
    def __init__(self, document: str):
        self.__raw__ = document
        self.__selector__ = Selector(document)
        self._cached_result: list[dict[str, Any]] = []
        self._aliases: dict[str, str] = {}
        self._view_keys: list[str] = []

    def _pre_validate(self, doc):
        pass

    def _start_parse(self):
        pass

    def _part_document(self, part: Selector):
        pass

    def parse(self):
        self._pre_validate(self.__selector__)
        self._start_parse()
        return self

    def view(self) -> list[dict[str, list[str] | str]]:
        def map_fields(result):
            view_dict = {}
            for k in self._view_keys:
                v = result.get(k)
                if v != None:
                    k = self._aliases.get(k, k)
                    view_dict[k] = v
            return view_dict

        if len(self._cached_result) == 1:
            return [map_fields(self._cached_result[0])]
        return [map_fields(result) for result in self._cached_result]


class OngoingView(__BaseViewModel):
    """
      Prepare:
    1. GET https://sovetromantica.com/anime

      view() elements signature:

          thumbnail <TEXT> -

          title <TEXT> -

          alt_title <TEXT> -

          url <TEXT> -


    """

    def __init__(self, document: str):
        super().__init__(document)
        self._aliases = {}
        self._view_keys = ["thumbnail", "title", "alt_title", "url"]

    def _pre_validate(self, part: Selector):
        val_0 = part.css("title")
        val_1 = val_0.xpath("./text()").get()
        assert re.search(r"Аниме / SovetRomantica", val_1)

    def _part_document(self, part: Selector):
        val_0 = part.css(".anime--block__desu")
        return val_0

    def _parse_thumbnail(self, part: Selector) -> str:
        # script signature:
        # css ".anime--poster--loading > img"
        # attr "src"
        #
        val_0 = part.css(".anime--poster--loading > img")
        val_1 = val_0.attrib["src"]
        return val_1

    def _parse_title(self, part: Selector) -> str:
        # script signature:
        # css ".anime--block__name > span + span"
        # text
        #
        val_0 = part.css(".anime--block__name > span + span")
        val_1 = val_0.xpath("./text()").get()
        return val_1

    def _parse_alt_title(self, part: Selector) -> str:
        # script signature:
        # css ".anime--block__name > span"
        # text
        #
        val_0 = part.css(".anime--block__name > span")
        val_1 = val_0.xpath("./text()").get()
        return val_1

    def _parse_url(self, part: Selector) -> str:
        # script signature:
        # css ".anime--block__desu a"
        # attr "href"
        #
        val_0 = part.css(".anime--block__desu a")
        val_1 = val_0.attrib["href"]
        return val_1

    def _start_parse(self):
        # clear cache
        self._cached_result.clear()
        for part in self._part_document(self.__selector__):
            self._cached_result.append(
                {
                    "thumbnail": self._parse_thumbnail(part),
                    "title": self._parse_title(part),
                    "alt_title": self._parse_alt_title(part),
                    "url": self._parse_url(part),
                }
            )


class SearchView(__BaseViewModel):
    """
      Prepare:
    1. GET https://sovetromantica.com/anime?query=<QUERY>

      view() elements signature:

          thumbnail <TEXT> -

          title <TEXT> -

          alt_title <TEXT> -

          url <TEXT> -


    """

    def __init__(self, document: str):
        super().__init__(document)
        self._aliases = {}
        self._view_keys = ["thumbnail", "title", "alt_title", "url"]

    def _pre_validate(self, part: Selector):
        val_0 = part.css("title")
        val_1 = val_0.xpath("./text()").get()
        assert re.search(r"\w+ / SovetRomantica", val_1)

    def _part_document(self, part: Selector):
        val_0 = part.css(".anime--block__desu")
        return val_0

    def _parse_thumbnail(self, part: Selector) -> str:
        # script signature:
        # css ".anime--poster--loading > img"
        # attr "src"
        #
        val_0 = part.css(".anime--poster--loading > img")
        val_1 = val_0.attrib["src"]
        return val_1

    def _parse_title(self, part: Selector) -> str:
        # script signature:
        # css ".anime--block__name > span + span"
        # text
        #
        val_0 = part.css(".anime--block__name > span + span")
        val_1 = val_0.xpath("./text()").get()
        return val_1

    def _parse_alt_title(self, part: Selector) -> str:
        # script signature:
        # css ".anime--block__name > span"
        # text
        #
        val_0 = part.css(".anime--block__name > span")
        val_1 = val_0.xpath("./text()").get()
        return val_1

    def _parse_url(self, part: Selector) -> str:
        # script signature:
        # css ".anime--block__desu a"
        # attr "href"
        #
        val_0 = part.css(".anime--block__desu a")
        val_1 = val_0.attrib["href"]
        return val_1

    def _start_parse(self):
        # clear cache
        self._cached_result.clear()
        for part in self._part_document(self.__selector__):
            self._cached_result.append(
                {
                    "thumbnail": self._parse_thumbnail(part),
                    "title": self._parse_title(part),
                    "alt_title": self._parse_alt_title(part),
                    "url": self._parse_url(part),
                }
            )


class AnimeView(__BaseViewModel):
    """
      Prepare:
    1. GET to anime URL page

      view() elements signature:

          thumbnail <TEXT> -

          title <TEXT> -

          description <TEXT> -

          video <TEXT> -


    """

    def __init__(self, document: str):
        super().__init__(document)
        self._aliases = {}
        self._view_keys = ["thumbnail", "title", "description", "video"]

    def _pre_validate(self, part: Selector):
        val_0 = part.css("title")
        val_1 = val_0.xpath("./text()").get()
        assert re.search(r"/ SovetRomantica", val_1)

    def _part_document(self, part: Selector):
        return [part]

    def _parse_thumbnail(self, part: Selector) -> str:
        # script signature:
        # css "#poster"
        # attr "src"
        # format "https://sovetromantica.com{{}}"
        #
        val_0 = part.css("#poster")
        val_1 = val_0.attrib["src"]
        val_2 = "https://sovetromantica.com{}".format(val_1)
        return val_2

    def _parse_title(self, part: Selector) -> str:
        # script signature:
        # css ".anime-name .block--container"
        # text
        #
        val_0 = part.css(".anime-name .block--container")
        val_1 = val_0.xpath("./text()").get()
        return val_1

    def _parse_description(self, part: Selector) -> str:
        # script signature:
        # css ".block--full .anime-description"
        # text
        #
        val_0 = part.css(".block--full .anime-description")
        val_1 = val_0.xpath("./text()").get()
        return val_1

    def _parse_video(self, part: Selector) -> str:
        # script signature:
        # default ""
        # raw
        # re "<meta property=\".*\" content=\"(https://.*?\.m3u8)\""
        #
        try:
            val_1 = part.get()
            val_2 = re.search(r"<meta property=\".*\" content=\"(https://.*?\.m3u8)\"", val_1)[1]
            return val_2

        except Exception:
            return ""

    def _start_parse(self):
        # clear cache
        self._cached_result.clear()
        for part in self._part_document(self.__selector__):
            self._cached_result.append(
                {
                    "thumbnail": self._parse_thumbnail(part),
                    "title": self._parse_title(part),
                    "description": self._parse_description(part),
                    "video": self._parse_video(part),
                }
            )


class EpisodeView(__BaseViewModel):
    """
        WARNING! target page maybe does not contains video!
    Prepare:
      1. GET to anime page

        view() elements signature:

            url <TEXT> -

            thumbnail <TEXT> -

            title <TEXT> -


    """

    def __init__(self, document: str):
        super().__init__(document)
        self._aliases = {}
        self._view_keys = ["url", "thumbnail", "title"]

    def _pre_validate(self, part: Selector):
        val_0 = part.css("title")
        val_1 = val_0.xpath("./text()").get()
        assert re.search(r"/ SovetRomantica", val_1)

    def _part_document(self, part: Selector):
        val_0 = part.css(".episodes-slick_item")
        return val_0

    def _parse_url(self, part: Selector) -> str:
        # script signature:
        # css "a"
        # attr "href"
        # format "https://sovetromantica.com{{}}"
        #
        val_0 = part.css("a")
        val_1 = val_0.attrib["href"]
        val_2 = "https://sovetromantica.com{}".format(val_1)
        return val_2

    def _parse_thumbnail(self, part: Selector) -> str:
        # script signature:
        # css "img"
        # attr "src"
        # format "https://sovetromantica.com{{}}"
        #
        val_0 = part.css("img")
        val_1 = val_0.attrib["src"]
        val_2 = "https://sovetromantica.com{}".format(val_1)
        return val_2

    def _parse_title(self, part: Selector) -> str:
        # script signature:
        # css "img"
        # attr "alt"
        val_0 = part.css("img")
        val_1 = val_0.attrib["alt"]
        return val_1

    def _start_parse(self):
        # clear cache
        self._cached_result.clear()
        for part in self._part_document(self.__selector__):
            self._cached_result.append(
                {
                    "url": self._parse_url(part),
                    "thumbnail": self._parse_thumbnail(part),
                    "title": self._parse_title(part),
                }
            )
