# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ..core.serialization import FieldMetadata
from .cost_amount import CostAmount


class CostTrace(UniversalBaseModel):
    """
    A single cost trace record
    """

    name: str = pydantic.Field()
    """
    The name/type of the operation (e.g., "trace.openai.agents.on_agent")
    """

    vendor: str = pydantic.Field()
    """
    The vendor/provider (e.g., "openai", "anthropic", "mistral")
    """

    cost: CostAmount
    start_time_unix_nano: typing_extensions.Annotated[str, FieldMetadata(alias="startTimeUnixNano")] = pydantic.Field()
    """
    Unix timestamp in nanoseconds when the operation started
    """

    end_time_unix_nano: typing_extensions.Annotated[str, FieldMetadata(alias="endTimeUnixNano")] = pydantic.Field()
    """
    Unix timestamp in nanoseconds when the operation completed
    """

    attributes: typing.Dict[str, typing.Optional[typing.Any]] = pydantic.Field()
    """
    Additional metadata about the trace (e.g., model, tokens, etc.)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
