# coding: utf-8

"""
    NiFi Rest Api

    The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.4.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class RemoteProcessGroupPortDTO(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'group_id': 'str',
        'name': 'str',
        'comments': 'str',
        'concurrently_schedulable_task_count': 'int',
        'transmitting': 'bool',
        'use_compression': 'bool',
        'exists': 'bool',
        'target_running': 'bool',
        'connected': 'bool',
        'batch_settings': 'BatchSettingsDTO'
    }

    attribute_map = {
        'id': 'id',
        'group_id': 'groupId',
        'name': 'name',
        'comments': 'comments',
        'concurrently_schedulable_task_count': 'concurrentlySchedulableTaskCount',
        'transmitting': 'transmitting',
        'use_compression': 'useCompression',
        'exists': 'exists',
        'target_running': 'targetRunning',
        'connected': 'connected',
        'batch_settings': 'batchSettings'
    }

    def __init__(self, id=None, group_id=None, name=None, comments=None, concurrently_schedulable_task_count=None, transmitting=False, use_compression=False, exists=False, target_running=False, connected=False, batch_settings=None):
        """
        RemoteProcessGroupPortDTO - a model defined in Swagger
        """

        self._id = None
        self._group_id = None
        self._name = None
        self._comments = None
        self._concurrently_schedulable_task_count = None
        self._transmitting = None
        self._use_compression = None
        self._exists = None
        self._target_running = None
        self._connected = None
        self._batch_settings = None

        if id is not None:
          self.id = id
        if group_id is not None:
          self.group_id = group_id
        if name is not None:
          self.name = name
        if comments is not None:
          self.comments = comments
        if concurrently_schedulable_task_count is not None:
          self.concurrently_schedulable_task_count = concurrently_schedulable_task_count
        if transmitting is not None:
          self.transmitting = transmitting
        if use_compression is not None:
          self.use_compression = use_compression
        if exists is not None:
          self.exists = exists
        if target_running is not None:
          self.target_running = target_running
        if connected is not None:
          self.connected = connected
        if batch_settings is not None:
          self.batch_settings = batch_settings

    @property
    def id(self):
        """
        Gets the id of this RemoteProcessGroupPortDTO.
        The id of the target port.

        :return: The id of this RemoteProcessGroupPortDTO.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this RemoteProcessGroupPortDTO.
        The id of the target port.

        :param id: The id of this RemoteProcessGroupPortDTO.
        :type: str
        """

        self._id = id

    @property
    def group_id(self):
        """
        Gets the group_id of this RemoteProcessGroupPortDTO.
        The id of the remote process group that the port resides in.

        :return: The group_id of this RemoteProcessGroupPortDTO.
        :rtype: str
        """
        return self._group_id

    @group_id.setter
    def group_id(self, group_id):
        """
        Sets the group_id of this RemoteProcessGroupPortDTO.
        The id of the remote process group that the port resides in.

        :param group_id: The group_id of this RemoteProcessGroupPortDTO.
        :type: str
        """

        self._group_id = group_id

    @property
    def name(self):
        """
        Gets the name of this RemoteProcessGroupPortDTO.
        The name of the target port.

        :return: The name of this RemoteProcessGroupPortDTO.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this RemoteProcessGroupPortDTO.
        The name of the target port.

        :param name: The name of this RemoteProcessGroupPortDTO.
        :type: str
        """

        self._name = name

    @property
    def comments(self):
        """
        Gets the comments of this RemoteProcessGroupPortDTO.
        The comments as configured on the target port.

        :return: The comments of this RemoteProcessGroupPortDTO.
        :rtype: str
        """
        return self._comments

    @comments.setter
    def comments(self, comments):
        """
        Sets the comments of this RemoteProcessGroupPortDTO.
        The comments as configured on the target port.

        :param comments: The comments of this RemoteProcessGroupPortDTO.
        :type: str
        """

        self._comments = comments

    @property
    def concurrently_schedulable_task_count(self):
        """
        Gets the concurrently_schedulable_task_count of this RemoteProcessGroupPortDTO.
        The number of task that may transmit flowfiles to the target port concurrently.

        :return: The concurrently_schedulable_task_count of this RemoteProcessGroupPortDTO.
        :rtype: int
        """
        return self._concurrently_schedulable_task_count

    @concurrently_schedulable_task_count.setter
    def concurrently_schedulable_task_count(self, concurrently_schedulable_task_count):
        """
        Sets the concurrently_schedulable_task_count of this RemoteProcessGroupPortDTO.
        The number of task that may transmit flowfiles to the target port concurrently.

        :param concurrently_schedulable_task_count: The concurrently_schedulable_task_count of this RemoteProcessGroupPortDTO.
        :type: int
        """

        self._concurrently_schedulable_task_count = concurrently_schedulable_task_count

    @property
    def transmitting(self):
        """
        Gets the transmitting of this RemoteProcessGroupPortDTO.
        Whether the remote port is configured for transmission.

        :return: The transmitting of this RemoteProcessGroupPortDTO.
        :rtype: bool
        """
        return self._transmitting

    @transmitting.setter
    def transmitting(self, transmitting):
        """
        Sets the transmitting of this RemoteProcessGroupPortDTO.
        Whether the remote port is configured for transmission.

        :param transmitting: The transmitting of this RemoteProcessGroupPortDTO.
        :type: bool
        """

        self._transmitting = transmitting

    @property
    def use_compression(self):
        """
        Gets the use_compression of this RemoteProcessGroupPortDTO.
        Whether the flowfiles are compressed when sent to the target port.

        :return: The use_compression of this RemoteProcessGroupPortDTO.
        :rtype: bool
        """
        return self._use_compression

    @use_compression.setter
    def use_compression(self, use_compression):
        """
        Sets the use_compression of this RemoteProcessGroupPortDTO.
        Whether the flowfiles are compressed when sent to the target port.

        :param use_compression: The use_compression of this RemoteProcessGroupPortDTO.
        :type: bool
        """

        self._use_compression = use_compression

    @property
    def exists(self):
        """
        Gets the exists of this RemoteProcessGroupPortDTO.
        Whether the target port exists.

        :return: The exists of this RemoteProcessGroupPortDTO.
        :rtype: bool
        """
        return self._exists

    @exists.setter
    def exists(self, exists):
        """
        Sets the exists of this RemoteProcessGroupPortDTO.
        Whether the target port exists.

        :param exists: The exists of this RemoteProcessGroupPortDTO.
        :type: bool
        """

        self._exists = exists

    @property
    def target_running(self):
        """
        Gets the target_running of this RemoteProcessGroupPortDTO.
        Whether the target port is running.

        :return: The target_running of this RemoteProcessGroupPortDTO.
        :rtype: bool
        """
        return self._target_running

    @target_running.setter
    def target_running(self, target_running):
        """
        Sets the target_running of this RemoteProcessGroupPortDTO.
        Whether the target port is running.

        :param target_running: The target_running of this RemoteProcessGroupPortDTO.
        :type: bool
        """

        self._target_running = target_running

    @property
    def connected(self):
        """
        Gets the connected of this RemoteProcessGroupPortDTO.
        Whether the port has either an incoming or outgoing connection.

        :return: The connected of this RemoteProcessGroupPortDTO.
        :rtype: bool
        """
        return self._connected

    @connected.setter
    def connected(self, connected):
        """
        Sets the connected of this RemoteProcessGroupPortDTO.
        Whether the port has either an incoming or outgoing connection.

        :param connected: The connected of this RemoteProcessGroupPortDTO.
        :type: bool
        """

        self._connected = connected

    @property
    def batch_settings(self):
        """
        Gets the batch_settings of this RemoteProcessGroupPortDTO.
        The batch settings for data transmission.

        :return: The batch_settings of this RemoteProcessGroupPortDTO.
        :rtype: BatchSettingsDTO
        """
        return self._batch_settings

    @batch_settings.setter
    def batch_settings(self, batch_settings):
        """
        Sets the batch_settings of this RemoteProcessGroupPortDTO.
        The batch settings for data transmission.

        :param batch_settings: The batch_settings of this RemoteProcessGroupPortDTO.
        :type: BatchSettingsDTO
        """

        self._batch_settings = batch_settings

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, RemoteProcessGroupPortDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
