"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from speakeasy_client_sdk_python.models.errors import error as errors_error
from speakeasy_client_sdk_python.models.shared import manifest as shared_manifest
from speakeasy_client_sdk_python.types import BaseModel
from speakeasy_client_sdk_python.utils import FieldMetadata, PathParamMetadata
from typing import Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class GetManifestRequestTypedDict(TypedDict):
    namespace_name: str
    organization_slug: str
    revision_reference: str
    r"""Tag or digest"""
    workspace_slug: str
    

class GetManifestRequest(BaseModel):
    namespace_name: Annotated[str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))]
    organization_slug: Annotated[str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))]
    revision_reference: Annotated[str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))]
    r"""Tag or digest"""
    workspace_slug: Annotated[str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))]
    

class GetManifestResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    error: NotRequired[errors_error.Error]
    r"""Default error response"""
    manifest: NotRequired[shared_manifest.ManifestTypedDict]
    r"""OK"""
    

class GetManifestResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    error: Optional[errors_error.Error] = None
    r"""Default error response"""
    manifest: Optional[shared_manifest.Manifest] = None
    r"""OK"""
    
