"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
import pydantic
from speakeasy_client_sdk_python.models.errors import error as errors_error
from speakeasy_client_sdk_python.models.shared import versionmetadata as shared_versionmetadata, versionmetadata_input as shared_versionmetadata_input
from speakeasy_client_sdk_python.types import BaseModel
from speakeasy_client_sdk_python.utils import FieldMetadata, PathParamMetadata, RequestMetadata
from typing import Optional, TypedDict
from typing_extensions import Annotated, NotRequired


class InsertVersionMetadataRequestTypedDict(TypedDict):
    version_metadata: shared_versionmetadata_input.VersionMetadataInputTypedDict
    r"""A JSON representation of the metadata to insert."""
    api_id: str
    r"""The ID of the Api to insert metadata for."""
    version_id: str
    r"""The version ID of the Api to insert metadata for."""
    

class InsertVersionMetadataRequest(BaseModel):
    version_metadata: Annotated[shared_versionmetadata_input.VersionMetadataInput, FieldMetadata(request=RequestMetadata(media_type="application/json"))]
    r"""A JSON representation of the metadata to insert."""
    api_id: Annotated[str, pydantic.Field(alias="apiID"), FieldMetadata(path=PathParamMetadata(style="simple", explode=False))]
    r"""The ID of the Api to insert metadata for."""
    version_id: Annotated[str, pydantic.Field(alias="versionID"), FieldMetadata(path=PathParamMetadata(style="simple", explode=False))]
    r"""The version ID of the Api to insert metadata for."""
    

class InsertVersionMetadataResponseTypedDict(TypedDict):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    error: NotRequired[errors_error.Error]
    r"""Default error response"""
    version_metadata: NotRequired[shared_versionmetadata.VersionMetadataTypedDict]
    r"""OK"""
    

class InsertVersionMetadataResponse(BaseModel):
    content_type: str
    r"""HTTP response content type for this operation"""
    status_code: int
    r"""HTTP response status code for this operation"""
    raw_response: httpx.Response
    r"""Raw HTTP response; suitable for custom response parsing"""
    error: Optional[errors_error.Error] = None
    r"""Default error response"""
    version_metadata: Optional[shared_versionmetadata.VersionMetadata] = None
    r"""OK"""
    
