"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing_extensions import Annotated, NotRequired, TypedDict


class DeletePaymentLinkRequestTypedDict(TypedDict):
    payment_link_id: str
    r"""Provide the ID of the related payment link."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class DeletePaymentLinkRequest(BaseModel):
    payment_link_id: Annotated[
        str,
        pydantic.Field(alias="paymentLinkId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related payment link."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class DeletePaymentLinkPaymentLinksDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class DeletePaymentLinkPaymentLinksDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class DeletePaymentLinkPaymentLinksLinksTypedDict(TypedDict):
    documentation: DeletePaymentLinkPaymentLinksDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class DeletePaymentLinkPaymentLinksLinks(BaseModel):
    documentation: DeletePaymentLinkPaymentLinksDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class DeletePaymentLinkPaymentLinksResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    field: str
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[DeletePaymentLinkPaymentLinksLinks, pydantic.Field(alias="_links")]


class DeletePaymentLinkPaymentLinksResponseBody(Exception):
    r"""An error response object."""

    data: DeletePaymentLinkPaymentLinksResponseBodyData

    def __init__(self, data: DeletePaymentLinkPaymentLinksResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, DeletePaymentLinkPaymentLinksResponseBodyData
        )


class DeletePaymentLinkDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class DeletePaymentLinkDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class DeletePaymentLinkLinksTypedDict(TypedDict):
    documentation: DeletePaymentLinkDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class DeletePaymentLinkLinks(BaseModel):
    documentation: DeletePaymentLinkDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class DeletePaymentLinkResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[DeletePaymentLinkLinks, pydantic.Field(alias="_links")]


class DeletePaymentLinkResponseBody(Exception):
    r"""An error response object."""

    data: DeletePaymentLinkResponseBodyData

    def __init__(self, data: DeletePaymentLinkResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, DeletePaymentLinkResponseBodyData)
