"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class GetSettlementCapturesQueryParamEmbed(str, Enum):
    r"""This endpoint allows you to embed additional resources via the `embed` query string parameter."""

    PAYMENT = "payment"


class GetSettlementCapturesRequestTypedDict(TypedDict):
    settlement_id: str
    r"""Provide the ID of the related settlement."""
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    embed: NotRequired[GetSettlementCapturesQueryParamEmbed]
    r"""This endpoint allows you to embed additional resources via the `embed` query string parameter."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetSettlementCapturesRequest(BaseModel):
    settlement_id: Annotated[
        str,
        pydantic.Field(alias="settlementId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related settlement."""

    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of items to return. Defaults to 50 items."""

    embed: Annotated[
        Optional[GetSettlementCapturesQueryParamEmbed],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""This endpoint allows you to embed additional resources via the `embed` query string parameter."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "embed", "testmode"]
        nullable_fields = ["limit", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetSettlementCapturesSettlementsResponseDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetSettlementCapturesSettlementsResponseDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetSettlementCapturesSettlementsResponseLinksTypedDict(TypedDict):
    documentation: GetSettlementCapturesSettlementsResponseDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementCapturesSettlementsResponseLinks(BaseModel):
    documentation: GetSettlementCapturesSettlementsResponseDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementCapturesSettlementsResponseResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        GetSettlementCapturesSettlementsResponseLinks, pydantic.Field(alias="_links")
    ]


class GetSettlementCapturesSettlementsResponseResponseBody(Exception):
    r"""An error response object."""

    data: GetSettlementCapturesSettlementsResponseResponseBodyData

    def __init__(self, data: GetSettlementCapturesSettlementsResponseResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, GetSettlementCapturesSettlementsResponseResponseBodyData
        )


class GetSettlementCapturesSettlementsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetSettlementCapturesSettlementsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetSettlementCapturesSettlementsLinksTypedDict(TypedDict):
    documentation: GetSettlementCapturesSettlementsDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementCapturesSettlementsLinks(BaseModel):
    documentation: GetSettlementCapturesSettlementsDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetSettlementCapturesSettlementsResponseBodyData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    field: str
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        GetSettlementCapturesSettlementsLinks, pydantic.Field(alias="_links")
    ]


class GetSettlementCapturesSettlementsResponseBody(Exception):
    r"""An error response object."""

    data: GetSettlementCapturesSettlementsResponseBodyData

    def __init__(self, data: GetSettlementCapturesSettlementsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, GetSettlementCapturesSettlementsResponseBodyData
        )


class GetSettlementCapturesAmountTypedDict(TypedDict):
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementCapturesAmount(BaseModel):
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementCapturesSettlementAmountTypedDict(TypedDict):
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementCapturesSettlementAmount(BaseModel):
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetSettlementCapturesMetadata2TypedDict(TypedDict):
    pass


class GetSettlementCapturesMetadata2(BaseModel):
    pass


GetSettlementCapturesMetadataTypedDict = TypeAliasType(
    "GetSettlementCapturesMetadataTypedDict",
    Union[GetSettlementCapturesMetadata2TypedDict, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


GetSettlementCapturesMetadata = TypeAliasType(
    "GetSettlementCapturesMetadata",
    Union[GetSettlementCapturesMetadata2, str, List[str]],
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""


class GetSettlementCapturesSettlementsSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesSettlementsSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesPaymentTypedDict(TypedDict):
    r"""The API resource URL of the [payment](get-payment) that this capture belongs to."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesPayment(BaseModel):
    r"""The API resource URL of the [payment](get-payment) that this capture belongs to."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesSettlementTypedDict(TypedDict):
    r"""The API resource URL of the [settlement](get-settlement) this capture has been settled with. Not present if not yet settled."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesSettlement(BaseModel):
    r"""The API resource URL of the [settlement](get-settlement) this capture has been settled with. Not present if not yet settled."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesShipmentTypedDict(TypedDict):
    r"""The API resource URL of the [shipment](get-shipment) this capture is associated with. Not present if it isn't associated with a shipment."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesShipment(BaseModel):
    r"""The API resource URL of the [shipment](get-shipment) this capture is associated with. Not present if it isn't associated with a shipment."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesSettlementsResponse200DocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesSettlementsResponse200Documentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesSettlementsResponse200LinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetSettlementCapturesSettlementsSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: NotRequired[GetSettlementCapturesPaymentTypedDict]
    r"""The API resource URL of the [payment](get-payment) that this capture belongs to."""
    settlement: NotRequired[Nullable[GetSettlementCapturesSettlementTypedDict]]
    r"""The API resource URL of the [settlement](get-settlement) this capture has been settled with. Not present if not yet settled."""
    shipment: NotRequired[Nullable[GetSettlementCapturesShipmentTypedDict]]
    r"""The API resource URL of the [shipment](get-shipment) this capture is associated with. Not present if it isn't associated with a shipment."""
    documentation: NotRequired[
        GetSettlementCapturesSettlementsResponse200DocumentationTypedDict
    ]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetSettlementCapturesSettlementsResponse200Links(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[GetSettlementCapturesSettlementsSelf], pydantic.Field(alias="self")
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: Optional[GetSettlementCapturesPayment] = None
    r"""The API resource URL of the [payment](get-payment) that this capture belongs to."""

    settlement: OptionalNullable[GetSettlementCapturesSettlement] = UNSET
    r"""The API resource URL of the [settlement](get-settlement) this capture has been settled with. Not present if not yet settled."""

    shipment: OptionalNullable[GetSettlementCapturesShipment] = UNSET
    r"""The API resource URL of the [shipment](get-shipment) this capture is associated with. Not present if it isn't associated with a shipment."""

    documentation: Optional[
        GetSettlementCapturesSettlementsResponse200Documentation
    ] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "payment", "settlement", "shipment", "documentation"]
        nullable_fields = ["settlement", "shipment"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetSettlementCapturesCapturesTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a capture object. Will always contain the string `capture` for this endpoint."""
    id: NotRequired[str]
    r"""The identifier uniquely referring to this capture. Example: `cpt_mNepDkEtco6ah3QNPUGYH`."""
    mode: NotRequired[str]
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """
    description: NotRequired[str]
    r"""The description of the capture."""
    amount: NotRequired[Nullable[GetSettlementCapturesAmountTypedDict]]
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""
    settlement_amount: NotRequired[
        Nullable[GetSettlementCapturesSettlementAmountTypedDict]
    ]
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """
    status: NotRequired[str]
    r"""The capture's status.

    Possible values: `pending` `succeeded` `failed`
    """
    metadata: NotRequired[Nullable[GetSettlementCapturesMetadataTypedDict]]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""
    payment_id: NotRequired[str]
    r"""The unique identifier of the payment this capture was created for. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`. The full payment object can be retrieved via the payment URL in the `_links` object."""
    shipment_id: NotRequired[Nullable[str]]
    r"""The unique identifier of the shipment that triggered the creation of this capture, if applicable. For example: `shp_gNapNy9qQTUFZYnCrCF7J`."""
    settlement_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the settlement this capture was settled with. For example, `stl_BkEjN2eBb`. This field is omitted if the capture is not settled (yet)."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: NotRequired[GetSettlementCapturesSettlementsResponse200LinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetSettlementCapturesCaptures(BaseModel):
    resource: Optional[str] = "capture"
    r"""Indicates the response contains a capture object. Will always contain the string `capture` for this endpoint."""

    id: Optional[str] = None
    r"""The identifier uniquely referring to this capture. Example: `cpt_mNepDkEtco6ah3QNPUGYH`."""

    mode: Optional[str] = None
    r"""Whether this entity was created in live mode or in test mode.

    Possible values: `live` `test`
    """

    description: Optional[str] = None
    r"""The description of the capture."""

    amount: OptionalNullable[GetSettlementCapturesAmount] = UNSET
    r"""The amount captured. If no amount is provided, the full authorized amount is captured."""

    settlement_amount: Annotated[
        OptionalNullable[GetSettlementCapturesSettlementAmount],
        pydantic.Field(alias="settlementAmount"),
    ] = UNSET
    r"""This optional field will contain the approximate amount that will be settled to your account, converted to the currency your account is settled in.

    Since the field contains an estimated amount during capture processing, it may change over time. To retrieve accurate settlement amounts we recommend using the [List balance transactions endpoint](list-balance-transactions) instead.
    """

    status: Optional[str] = None
    r"""The capture's status.

    Possible values: `pending` `succeeded` `failed`
    """

    metadata: OptionalNullable[GetSettlementCapturesMetadata] = UNSET
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB."""

    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None
    r"""The unique identifier of the payment this capture was created for. For example: `tr_5B8cwPMGnU6qLbRvo7qEZo`. The full payment object can be retrieved via the payment URL in the `_links` object."""

    shipment_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="shipmentId")
    ] = UNSET
    r"""The unique identifier of the shipment that triggered the creation of this capture, if applicable. For example: `shp_gNapNy9qQTUFZYnCrCF7J`."""

    settlement_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="settlementId")
    ] = UNSET
    r"""The identifier referring to the settlement this capture was settled with. For example, `stl_BkEjN2eBb`. This field is omitted if the capture is not settled (yet)."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[
        Optional[GetSettlementCapturesSettlementsResponse200Links],
        pydantic.Field(alias="_links"),
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "mode",
            "description",
            "amount",
            "settlementAmount",
            "status",
            "metadata",
            "paymentId",
            "shipmentId",
            "settlementId",
            "createdAt",
            "_links",
        ]
        nullable_fields = [
            "amount",
            "settlementAmount",
            "metadata",
            "shipmentId",
            "settlementId",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetSettlementCapturesEmbeddedTypedDict(TypedDict):
    captures: NotRequired[List[GetSettlementCapturesCapturesTypedDict]]
    r"""An array of capture objects."""


class GetSettlementCapturesEmbedded(BaseModel):
    captures: Optional[List[GetSettlementCapturesCaptures]] = None
    r"""An array of capture objects."""


class GetSettlementCapturesSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetSettlementCapturesLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetSettlementCapturesSelfTypedDict]
    r"""The URL to the current set of items."""
    previous: NotRequired[Nullable[GetSettlementCapturesPreviousTypedDict]]
    r"""The previous set of items, if available."""
    next: NotRequired[Nullable[GetSettlementCapturesNextTypedDict]]
    r"""The next set of items, if available."""
    documentation: NotRequired[GetSettlementCapturesDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetSettlementCapturesLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[
        Optional[GetSettlementCapturesSelf], pydantic.Field(alias="self")
    ] = None
    r"""The URL to the current set of items."""

    previous: OptionalNullable[GetSettlementCapturesPrevious] = UNSET
    r"""The previous set of items, if available."""

    next: OptionalNullable[GetSettlementCapturesNext] = UNSET
    r"""The next set of items, if available."""

    documentation: Optional[GetSettlementCapturesDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "previous", "next", "documentation"]
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetSettlementCapturesResponseBodyTypedDict(TypedDict):
    r"""A list of capture objects."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """
    embedded: NotRequired[GetSettlementCapturesEmbeddedTypedDict]
    links: NotRequired[GetSettlementCapturesLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class GetSettlementCapturesResponseBody(BaseModel):
    r"""A list of capture objects."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """

    embedded: Annotated[
        Optional[GetSettlementCapturesEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[
        Optional[GetSettlementCapturesLinks], pydantic.Field(alias="_links")
    ] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
