""" DHL Native Types """

from purplship.core.utils import Enum, Flag
from purplship.core.units import PackagePreset

PRESET_DEFAULTS = dict(dimension_unit="IN", weight_unit="LB")


class PackagePresets(Flag):
    dhl_express_envelope = PackagePreset(
        **dict(weight=0.5, width=35.0, height=27.5, length=1.0, packaging_type="envelope"),
        **PRESET_DEFAULTS
    )
    dhl_express_standard_flyer = PackagePreset(
        **dict(weight=2.0, width=40.0, height=30.0, length=1.5, packaging_type="pak"),
        **PRESET_DEFAULTS
    )
    dhl_express_large_flyer = PackagePreset(
        **dict(weight=3.0, width=47.5, height=37.5, length=1.5, packaging_type="pak"),
        **PRESET_DEFAULTS
    )
    dhl_express_box_2 = PackagePreset(
        **dict(weight=1.0, width=33.7, height=18.2, length=10.0, packaging_type="medium_box"),
        **PRESET_DEFAULTS
    )
    dhl_express_box_3 = PackagePreset(
        **dict(weight=2.0, width=33.6, height=32.0, length=5.2, packaging_type="medium_box"),
        **PRESET_DEFAULTS
    )
    dhl_express_box_4 = PackagePreset(
        **dict(weight=5.0, width=33.7, height=32.2, length=18.0, packaging_type="medium_box"),
        **PRESET_DEFAULTS
    )
    dhl_express_box_5 = PackagePreset(
        **dict(weight=10.0, width=33.7, height=32.2, length=34.5, packaging_type="medium_box"),
        **PRESET_DEFAULTS
    )
    dhl_express_box_6 = PackagePreset(
        **dict(weight=15.0, width=41.7, height=35.9, length=36.9, packaging_type="large_box"),
        **PRESET_DEFAULTS
    )
    dhl_express_box_7 = PackagePreset(
        **dict(weight=20.0, width=48.1, height=40.4, length=38.9, packaging_type="large_box"),
        **PRESET_DEFAULTS
    )
    dhl_express_box_8 = PackagePreset(
        **dict(weight=25.0, width=54.2, height=44.4, length=40.9, packaging_type="large_box"),
        **PRESET_DEFAULTS
    )
    dhl_express_tube = PackagePreset(
        **dict(weight=5.0, width=96.0, height=15.0, length=15.0, packaging_type="tube"),
        **PRESET_DEFAULTS
    )
    dhl_didgeridoo_box = PackagePreset(
        **dict(weight=10.0, width=13.0, height=13.0, length=162.0, packaging_type="medium_box"),
        **PRESET_DEFAULTS
    )
    dhl_jumbo_box = PackagePreset(
        **dict(weight=30.0, width=45.0, height=42.7, length=33.0, packaging_type="medium_box"),
        **PRESET_DEFAULTS
    )
    dhl_jumbo_box_junior = PackagePreset(
        **dict(weight=20.0, width=39.9, height=34.0, length=24.1, packaging_type="medium_box"),
        **PRESET_DEFAULTS
    )


class LabelType(Flag):
    PDF_6x4 = ('PDF', '6X4_PDF')
    PDF_8x4 = ('PDF', '8X4_PDF')
    PDF_8x4_A4 = ('PDF', '8X4_A4_PDF')
    PDF_6x4_A4 = ('PDF', '6X4_A4_PDF')
    PDF_8x4_CI = ('PDF', '8X4_CI_PDF')
    PDF_8x4_RU_A4 = ('PDF', '8X4_RU_A4_PDF')
    ZPL_8x4 = ('ZPL2', '8X4_thermal')
    ZPL_6x4 = ('ZPL2', '6X4_thermal')
    ZPL_8x4_CI = ('ZPL2', '8X4_CI_thermal')

    """ Unified Label type mapping """
    PDF = PDF_6x4
    ZPL = ZPL_6x4


class Incoterm(Enum):
    EXW = "Ex Works"
    FCA = "Free Carrier"
    CPT = "Carriage Paid To"
    CFR = "CFR Cost and Freight"
    CIP = "Carriage and Insurance Paid To"
    CIF = "CIF Cost, Insurance and Freight"
    DAT = "Delivered At Terminal"
    DAP = "Delivered At Place"
    DDP = "Delivered Duty Paid"
    FAS = "FAS Free Alongside Ship"
    FOB = "FOB Free On Board"


class Dimension(Enum):
    CM = "C"
    IN = "I"


class WeightUnit(Enum):
    KG = "K"
    LB = "L"


class DeliveryType(Enum):
    door_to_door = "DD"
    door_to_airport = "DA"
    airport_to_airport = "AA"
    door_to_door_c = "DC"


class DCTPackageType(Enum):
    dhl_flyer_smalls = "FLY"
    dhl_parcels_conveyables = "COY"
    dhl_non_conveyables = "NCY"
    dhl_pallets = "PAL"
    dhl_double_pallets = "DBL"
    dhl_box = "BOX"

    """ Unified Packaging type mapping """
    envelope = dhl_flyer_smalls
    pak = dhl_flyer_smalls
    tube = dhl_parcels_conveyables
    pallet = dhl_pallets
    small_box = dhl_box
    medium_box = dhl_box
    large_box = dhl_box
    your_packaging = dhl_box


class NetworkType(Enum):
    both_time_and_day_definite = "AL"
    day_definite = "DD"
    time_definite = "TD"


class PackageType(Flag):
    dhl_jumbo_document = "BD"
    dhl_jumbo_parcel = "BP"
    dhl_customer_provided = "CP"
    dhl_document = "DC"
    dhl_flyer = "DF"
    dhl_domestic = "DM"
    dhl_express_document = "ED"
    dhl_express_envelope = "EE"
    dhl_freight = "FR"
    dhl_jumbo_box = "JB"
    dhl_jumbo_junior_document = "JD"
    dhl_junior_jumbo_box = "JJ"
    dhl_jumbo_junior_parcel = "JP"
    dhl_other_dhl_packaging = "OD"
    dhl_parcel = "PA"
    dhl_your_packaging = "YP"

    """ Unified Packaging type mapping """
    envelope = dhl_express_envelope
    pak = dhl_flyer
    tube = dhl_other_dhl_packaging
    pallet = dhl_freight
    small_box = dhl_junior_jumbo_box
    medium_box = dhl_jumbo_box
    large_box = dhl_jumbo_parcel
    your_packaging = dhl_your_packaging


class Product(Enum):
    dhl_logistics_services = "LOGISTICS SERVICES"
    dhl_domestic_express_12_00_doc = "DOMESTIC EXPRESS 12:00 DOC"
    dhl_b2_c_doc = "B2C DOC"
    dhl_b2_c_nondoc = "B2C NONDOC"
    dhl_jetline = "JETLINE"
    dhl_sprintline = "SPRINTLINE"
    dhl_express_easy_doc = "EXPRESS EASY DOC"
    dhl_express_easy_nondoc = "EXPRESS EASY NONDOC"
    dhl_europack_doc = "EUROPACK DOC"
    dhl_auto_reversals = "AUTO REVERSALS"
    dhl_breakbulk_express_doc = "BREAKBULK EXPRESS DOC"
    dhl_medical_express_doc = "MEDICAL EXPRESS DOC"
    dhl_express_worldwide_doc = "EXPRESS WORLDWIDE DOC"
    dhl_express_9_00_nondoc = "EXPRESS 9:00 NONDOC"
    dhl_freight_worldwide_nondoc = "FREIGHT WORLDWIDE NONDOC"
    dhl_domestic_economy_select_doc = "DOMESTIC ECONOMY SELECT DOC"
    dhl_economy_select_nondoc = "ECONOMY SELECT NONDOC"
    dhl_domestic_express_9_00_doc = "DOMESTIC EXPRESS 9:00 DOC"
    dhl_jumbo_box_nondoc = "JUMBO BOX NONDOC"
    dhl_express_9_00_doc = "EXPRESS 9:00 DOC"
    dhl_express_10_30_doc = "EXPRESS 10:30 DOC"
    dhl_express_10_30_nondoc = "EXPRESS 10:30 NONDOC"
    dhl_domestic_express_doc = "DOMESTIC EXPRESS DOC"
    dhl_domestic_express_10_30_doc = "DOMESTIC EXPRESS 10:30 DOC"
    dhl_express_worldwide_nondoc = "EXPRESS WORLDWIDE NONDOC"
    dhl_medical_express_nondoc = "MEDICAL EXPRESS NONDOC"
    dhl_globalmail_business_doc = "GLOBALMAIL BUSINESS DOC"
    dhl_same_day_doc = "SAME DAY DOC"
    dhl_express_12_00_doc = "EXPRESS 12:00 DOC"
    dhl_express_worldwide_ecx_doc = "EXPRESS WORLDWIDE DOC"
    dhl_europack_nondoc = "EUROPACK NONDOC"
    dhl_economy_select_doc = "ECONOMY SELECT DOC"
    dhl_express_envelope_doc = "EXPRESS ENVELOPE DOC"
    dhl_express_12_00_nondoc = "EXPRESS 12:00 NONDOC"
    dhl_destination_charges = "Destination Charges"


class ProductCode(Enum):
    dhl_logistics_services = "0"
    dhl_domestic_express_12_00_doc = "1"
    dhl_b2_c_doc = "2"
    dhl_b2_c_nondoc = "3"
    dhl_jetline = "4"
    dhl_sprintline = "5"
    dhl_express_easy_doc = "7"
    dhl_express_easy_nondoc = "8"
    dhl_europack_doc = "9"
    dhl_auto_reversals = "A"
    dhl_breakbulk_express_doc = "B"
    dhl_medical_express_doc = "C"
    dhl_express_worldwide_doc = "D"
    dhl_express_9_00_nondoc = "E"
    dhl_freight_worldwide_nondoc = "F"
    dhl_domestic_economy_select_doc = "G"
    dhl_economy_select_nondoc = "H"
    dhl_domestic_express_9_00_doc = "I"
    dhl_jumbo_box_nondoc = "J"
    dhl_express_9_00_doc = "K"
    dhl_express_10_30_doc = "L"
    dhl_express_10_30_nondoc = "M"
    dhl_domestic_express_doc = "N"
    dhl_domestic_express_10_30_doc = "O"
    dhl_express_worldwide_nondoc = "P"
    dhl_medical_express_nondoc = "Q"
    dhl_globalmail_business_doc = "R"
    dhl_same_day_doc = "S"
    dhl_express_12_00_doc = "T"
    dhl_express_worldwide_ecx_doc = "U"
    dhl_europack_nondoc = "V"
    dhl_economy_select_doc = "W"
    dhl_express_envelope_doc = "X"
    dhl_express_12_00_nondoc = "Y"
    dhl_destination_charges = "Z"


class PaymentType(Enum):
    sender = "S"
    recipient = "R"
    third_party = "T"


class SpecialServiceCode(Flag):
    dhl_logistics_services = "0A"
    dhl_mailroom_management = "0B"
    dhl_pallet_administration = "0C"
    dhl_warehousing = "0D"
    dhl_express_logistics_centre = "0E"
    dhl_strategic_parts_centre = "0F"
    dhl_local_distribution_centre = "0G"
    dhl_terminal_handling = "0H"
    dhl_cross_docking = "0I"
    dhl_inventory_management = "0J"
    dhl_loading_unloading = "0K"
    dhl_product_kitting = "0L"
    dhl_priority_account_desk = "0M"
    dhl_document_archiving = "0N"
    dhl_saturday_delivery = "AA"
    dhl_saturday_pickup = "AB"
    dhl_holiday_delivery = "AC"
    dhl_holiday_pickup = "AD"
    dhl_domestic_saturday_delivery = "AG"
    dhl_standard = "BA"
    dhl_globalmail_item = "BB"
    dhl_letter = "BC"
    dhl_packet = "BD"
    dhl_letter_plus = "BE"
    dhl_packet_plus = "BF"
    dhl_elevated_risk = "CA"
    dhl_restricted_destination = "CB"
    dhl_security_validation = "CC"
    dhl_secure_protection = "CD"
    dhl_proof_of_identity = "CE"
    dhl_secure_storage = "CF"
    dhl_diplomatic_material = "CG"
    dhl_smart_sensor = "CH"
    dhl_visa_program = "CI"
    dhl_onboard_courier = "CJ"
    dhl_secure_safebox = "CK"
    dhl_smart_sentry = "CL"
    dhl_split_duties_and_tax = "DC"
    dhl_duties_and_taxes_paid = "DD"
    dhl_receiver_paid = "DE"
    dhl_duties_and_taxes_unpaid = "DS"
    dhl_import_billing = "DT"
    dhl_importer_of_record = "DU"
    dhl_go_green_carbon_neutral = "EA"
    dhl_go_green_carbon_footprint = "EB"
    dhl_go_green_carbon_estimate = "EC"
    dhl_fuel_surcharge_b = "FB"
    dhl_fuel_surcharge_c = "FC"
    dhl_fuel_surcharge_f = "FF"
    dhl_smartphone_box = "GA"
    dhl_laptop_box = "GB"
    dhl_bottle_box = "GC"
    dhl_repacking = "GD"
    dhl_tablet_box = "GE"
    dhl_filler_material = "GF"
    dhl_packaging = "GG"
    dhl_diplomatic_bag = "GH"
    dhl_pallet_box = "GI"
    dhl_lock_box = "GJ"
    dhl_lithium_ion_pi965_section_ii = "HB"
    dhl_dry_ice_un1845 = "HC"
    dhl_lithium_ion_pi965_966_section_ii = "HD"
    dhl_dangerous_goods = "HE"
    dhl_perishable_cargo = "HG"
    dhl_excepted_quantity = "HH"
    dhl_spill_cleaning = "HI"
    dhl_consumer_commodities = "HK"
    dhl_limited_quantities_adr = "HL"
    dhl_lithium_metal_pi969_section_ii = "HM"
    dhl_adr_load_exemption = "HN"
    dhl_lithium_ion_pi967_section_ii = "HV"
    dhl_lithium_metal_pi970_section_ii = "HW"
    dhl_biological_un3373 = "HY"
    dhl_extended_liability = "IB"
    dhl_contract_insurance = "IC"
    dhl_shipment_insurance = "II"
    dhl_delivery_notification = "JA"
    dhl_pickup_notification = "JC"
    dhl_proactive_tracking = "JD"
    dhl_performance_reporting = "JE"
    dhl_prealert_notification = "JY"
    dhl_change_of_billing = "KA"
    dhl_cash_on_delivery = "KB"
    dhl_printed_invoice = "KD"
    dhl_waybill_copy = "KE"
    dhl_import_paperwork = "KF"
    dhl_payment_on_pickup = "KY"
    dhl_shipment_intercept = "LA"
    dhl_shipment_redirect = "LC"
    dhl_storage_at_facility = "LE"
    dhl_cold_storage = "LG"
    dhl_specific_routing = "LH"
    dhl_service_recovery = "LV"
    dhl_alternative_address = "LW"
    dhl_hold_for_collection = "LX"
    dhl_address_correction_a = "MA"
    dhl_address_correction_b = "MB"
    dhl_neutral_delivery = "NN"
    dhl_remote_area_pickup = "OB"
    dhl_remote_area_delivery_c = "OC"
    dhl_out_of_service_area = "OE"
    dhl_remote_area_delivery_o = "OO"
    dhl_shipment_preparation = "PA"
    dhl_shipment_labeling = "PB"
    dhl_shipment_consolidation = "PC"
    dhl_relabeling_data_entry = "PD"
    dhl_preprinted_waybill = "PE"
    dhl_piece_labelling = "PS"
    dhl_data_staging_03 = "PT"
    dhl_data_staging_06 = "PU"
    dhl_data_staging_12 = "PV"
    dhl_data_staging_24 = "PW"
    dhl_standard_pickup = "PX"
    dhl_scheduled_pickup = "PY"
    dhl_dedicated_pickup = "QA"
    dhl_early_pickup = "QB"
    dhl_late_pickup = "QD"
    dhl_residential_pickup = "QE"
    dhl_loading_waiting = "QF"
    dhl_bypass_injection = "QH"
    dhl_direct_injection = "QI"
    dhl_drop_off_at_facility = "QY"
    dhl_delivery_signature = "SA"
    dhl_content_signature = "SB"
    dhl_named_signature = "SC"
    dhl_adult_signature = "SD"
    dhl_contract_signature = "SE"
    dhl_alternative_signature = "SW"
    dhl_no_signature_required = "SX"
    dhl_dedicated_delivery = "TA"
    dhl_early_delivery = "TB"
    dhl_time_window_delivery = "TC"
    dhl_evening_delivery = "TD"
    dhl_delivery_on_appointment = "TE"
    dhl_return_undeliverable = "TG"
    dhl_swap_delivery = "TH"
    dhl_unloading_waiting = "TJ"
    dhl_residential_delivery = "TK"
    dhl_repeat_delivery = "TN"
    dhl_alternative_date = "TT"
    dhl_no_partial_delivery = "TU"
    dhl_service_point_24_7 = "TV"
    dhl_pre_9_00 = "TW"
    dhl_pre_10_30 = "TX"
    dhl_pre_12_00 = "TY"
    dhl_thermo_packaging = "UA"
    dhl_ambient_vialsafe = "UB"
    dhl_ambient_non_insulated = "UC"
    dhl_ambient_insulated = "UD"
    dhl_ambient_extreme = "UE"
    dhl_chilled_box_s = "UF"
    dhl_chilled_box_m = "UG"
    dhl_chilled_box_l = "UH"
    dhl_frozen_no_ice_s = "UI"
    dhl_frozen_no_ice_m = "UJ"
    dhl_frozen_no_ice_l = "UK"
    dhl_frozen_ice_sticks_s = "UL"
    dhl_frozen_ice_sticks_m = "UM"
    dhl_frozen_ice_sticks_l = "UN"
    dhl_frozen_ice_plates_s = "UO"
    dhl_frozen_ice_plates_m = "UP"
    dhl_frozen_ice_plates_l = "UQ"
    dhl_combination_no_ice = "UR"
    dhl_combination_dry_ice = "US"
    dhl_frozen_ice_sticks_e = "UT"
    dhl_frozen_ice_plates_e = "UV"
    dhl_customer_tcp_1 = "UW"
    dhl_thermo_accessories = "VA"
    dhl_absorbent_sleeve = "VB"
    dhl_cooland_wrap = "VC"
    dhl_dry_ice_supplies = "VD"
    dhl_pressure_bag_s = "VE"
    dhl_pressure_bag_m = "VF"
    dhl_pressure_bag_l = "VG"
    dhl_informal_clearance = "WA"
    dhl_formal_clearance = "WB"
    dhl_payment_deferment = "WC"
    dhl_clearance_authorization = "WD"
    dhl_multiline_entry = "WE"
    dhl_post_clearance_modification = "WF"
    dhl_handover_to_broker = "WG"
    dhl_physical_intervention = "WH"
    dhl_bio_phyto_veterinary_controls = "WI"
    dhl_obtaining_permits_and_licences = "WJ"
    dhl_bonded_storage = "WK"
    dhl_bonded_transit_documents = "WL"
    dhl_temporary_import_export = "WM"
    dhl_under_bond_guarantee = "WN"
    dhl_export_declaration = "WO"
    dhl_exporter_validation = "WP"
    dhl_certificate_of_origin = "WQ"
    dhl_document_translation = "WR"
    dhl_personal_effects = "WS"
    dhl_paperless_trade = "WY"
    dhl_import_export_taxes = "XB"
    dhl_unrecoverable_origin_tax = "XC"
    dhl_quarantine_inspection = "XD"
    dhl_merchandise_process = "XE"
    dhl_domestic_postal_tax = "XF"
    dhl_tier_two_tax = "XG"
    dhl_tier_three_tax = "XH"
    dhl_import_penalty = "XI"
    dhl_cargo_zone_process = "XJ"
    dhl_import_export_duties = "XX"
    dhl_premium_09_00 = "Y1"
    dhl_premium_10_30 = "Y2"
    dhl_premium_12_00 = "Y3"
    dhl_over_sized_piece_b = "YB"
    dhl_over_handled_piece_c = "YC"
    dhl_multipiece_shipment = "YE"
    dhl_over_weight_piece_f = "YF"
    dhl_over_sized_piece_g = "YG"
    dhl_over_handled_piece_h = "YH"
    dhl_premium_9_00_i = "YI"
    dhl_premium_10_30_j = "YJ"
    dhl_premium_12_00_k = "YK"
    dhl_paket_shipment = "YV"
    dhl_breakbulk_mother = "YW"
    dhl_breakbulk_baby = "YX"
    dhl_over_weight_piece_y = "YY"
    dhl_customer_claim = "ZA"
    dhl_damage_compensation = "ZB"
    dhl_loss_compensation = "ZC"
    dhl_customer_rebate = "ZD"
    dhl_e_com_discount = "ZE"

    """ Unified Option type mapping """
    insurance = dhl_shipment_insurance


class CountryRegion(Enum):
    AD = "EU"
    AE = "AP"
    AF = "AP"
    AG = "AM"
    AI = "AM"
    AL = "AP"
    AM = "AP"
    AN = "AM"
    AO = "AP"
    AR = "AM"
    AS = "AM"
    AT = "EU"
    AU = "AP"
    AW = "AM"
    AZ = "AM"
    BA = "AP"
    BB = "AM"
    BD = "AP"
    BE = "EU"
    BF = "AP"
    BG = "EU"
    BH = "AP"
    BI = "AP"
    BJ = "AP"
    BM = "AM"
    BN = "AP"
    BO = "AM"
    BR = "AM"
    BS = "AM"
    BT = "AP"
    BW = "AP"
    BY = "AP"
    BZ = "AM"
    CA = "AM"
    CD = "AP"
    CF = "AP"
    CG = "AP"
    CH = "EU"
    CI = "AP"
    CK = "AP"
    CL = "AM"
    CM = "AP"
    CN = "AP"
    CO = "AM"
    CR = "AM"
    CU = "AM"
    CV = "AP"
    CY = "AP"
    CZ = "EU"
    DE = "EU"
    DJ = "AP"
    DK = "EU"
    DM = "AM"
    DO = "AM"
    DZ = "AP"
    EC = "AM"
    EE = "EU"
    EG = "AP"
    ER = "AP"
    ES = "EU"
    ET = "AP"
    FI = "EU"
    FJ = "AP"
    FK = "EU"
    FM = "AM"
    FO = "AM"
    FR = "EU"
    GA = "AP"
    GB = "EU"
    GD = "AM"
    GE = "AM"
    GF = "AM"
    GG = "EU"
    GH = "AP"
    GI = "EU"
    GL = "AM"
    GM = "AP"
    GN = "AP"
    GP = "AM"
    GQ = "AP"
    GR = "EU"
    GT = "AM"
    GU = "AM"
    GW = "AP"
    GY = "AP"
    HK = "AP"
    HN = "AM"
    HR = "AP"
    HT = "AM"
    HU = "EU"
    IC = "EU"
    ID = "AP"
    IE = "EU"
    IL = "AP"
    IN = "AP"
    IQ = "AP"
    IR = "AP"
    IS = "EU"
    IT = "EU"
    JE = "EU"
    JM = "AM"
    JO = "AP"
    JP = "AP"
    KE = "AP"
    KG = "AP"
    KH = "AP"
    KI = "AP"
    KM = "AP"
    KN = "AM"
    KP = "AP"
    KR = "AP"
    KV = "AM"
    KW = "AP"
    KY = "AM"
    KZ = "AP"
    LA = "AP"
    LB = "AP"
    LC = "AM"
    LI = "AM"
    LK = "AP"
    LR = "AP"
    LS = "AP"
    LT = "EU"
    LU = "EU"
    LV = "EU"
    LY = "AP"
    MA = "AP"
    MC = "AM"
    MD = "AP"
    ME = "AM"
    MG = "AP"
    MH = "AM"
    MK = "AP"
    ML = "AP"
    MM = "AP"
    MN = "AP"
    MO = "AP"
    MP = "AM"
    MQ = "AM"
    MR = "AP"
    MS = "AM"
    MT = "AP"
    MU = "AP"
    MV = "AP"
    MW = "AP"
    MX = "AM"
    MY = "AP"
    MZ = "AP"
    NA = "AP"
    NC = "AP"
    NE = "AP"
    NG = "AP"
    NI = "AM"
    NL = "EU"
    NO = "EU"
    NP = "AP"
    NR = "AP"
    NU = "AP"
    NZ = "AP"
    OM = "AP"
    PA = "AM"
    PE = "AM"
    PF = "AP"
    PG = "AP"
    PH = "AP"
    PK = "AP"
    PL = "EU"
    PR = "AM"
    PT = "EU"
    PW = "AM"
    PY = "AM"
    QA = "AP"
    RE = "AP"
    RO = "EU"
    RS = "AP"
    RU = "AP"
    RW = "AP"
    SA = "AP"
    SB = "AP"
    SC = "AP"
    SD = "AP"
    SE = "EU"
    SG = "AP"
    SH = "AP"
    SI = "EU"
    SK = "EU"
    SL = "AP"
    SM = "EU"
    SN = "AP"
    SO = "AM"
    SR = "AM"
    SS = "AP"
    ST = "AP"
    SV = "AM"
    SY = "AP"
    SZ = "AP"
    TC = "AM"
    TD = "AP"
    TG = "AP"
    TH = "AP"
    TJ = "AP"
    TL = "AP"
    TN = "AP"
    TO = "AP"
    TR = "AP"
    TT = "AM"
    TV = "AP"
    TW = "AP"
    TZ = "AP"
    UA = "AP"
    UG = "AP"
    US = "AM"
    UY = "AM"
    UZ = "AP"
    VA = ""
    VC = "AM"
    VE = "AM"
    VG = "AM"
    VI = "AM"
    VN = "AP"
    VU = "AP"
    WS = "AP"
    XB = "AM"
    XC = "AM"
    XE = "AM"
    XM = "AM"
    XN = "AM"
    XS = "AP"
    XY = "AM"
    YE = "AP"
    YT = "AP"
    ZA = "AP"
    ZM = "AP"
    ZW = "AP"
