(self["webpackChunk_elyra_metadata_extension"] = self["webpackChunk_elyra_metadata_extension"] || []).push([["vendors-node_modules_rjsf_core_lib_index_js-node_modules_rjsf_validator-ajv8_lib_index_js-nod-882a64"],{

/***/ "../../node_modules/@rjsf/core/lib/components/Form.js":
/*!************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/Form.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Form)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");
/* harmony import */ var lodash_forEach__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/forEach */ "../../node_modules/lodash/forEach.js");
/* harmony import */ var lodash_forEach__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_forEach__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash/isEmpty */ "../../node_modules/lodash/isEmpty.js");
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var lodash_pick__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash/pick */ "../../node_modules/lodash/pick.js");
/* harmony import */ var lodash_pick__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash_pick__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var lodash_toPath__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lodash/toPath */ "../../node_modules/lodash/toPath.js");
/* harmony import */ var lodash_toPath__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(lodash_toPath__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _getDefaultRegistry__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../getDefaultRegistry */ "../../node_modules/@rjsf/core/lib/getDefaultRegistry.js");









/** The `Form` component renders the outer form and all the fields defined in the `schema` */
class Form extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    /** Constructs the `Form` from the `props`. Will setup the initial state from the props. It will also call the
     * `onChange` handler if the initially provided `formData` is modified to add missing default values as part of the
     * state construction.
     *
     * @param props - The initial props for the `Form`
     */
    constructor(props) {
        super(props);
        /** Returns the `formData` with only the elements specified in the `fields` list
         *
         * @param formData - The data for the `Form`
         * @param fields - The fields to keep while filtering
         */
        this.getUsedFormData = (formData, fields) => {
            // For the case of a single input form
            if (fields.length === 0 && typeof formData !== 'object') {
                return formData;
            }
            // _pick has incorrect type definition, it works with string[][], because lodash/hasIn supports it
            const data = lodash_pick__WEBPACK_IMPORTED_MODULE_6___default()(formData, fields);
            if (Array.isArray(formData)) {
                return Object.keys(data).map((key) => data[key]);
            }
            return data;
        };
        /** Returns the list of field names from inspecting the `pathSchema` as well as using the `formData`
         *
         * @param pathSchema - The `PathSchema` object for the form
         * @param [formData] - The form data to use while checking for empty objects/arrays
         */
        this.getFieldNames = (pathSchema, formData) => {
            const getAllPaths = (_obj, acc = [], paths = [[]]) => {
                Object.keys(_obj).forEach((key) => {
                    if (typeof _obj[key] === 'object') {
                        const newPaths = paths.map((path) => [...path, key]);
                        // If an object is marked with additionalProperties, all its keys are valid
                        if (_obj[key][_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.RJSF_ADDITIONAL_PROPERTIES_FLAG] && _obj[key][_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.NAME_KEY] !== '') {
                            acc.push(_obj[key][_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.NAME_KEY]);
                        }
                        else {
                            getAllPaths(_obj[key], acc, newPaths);
                        }
                    }
                    else if (key === _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.NAME_KEY && _obj[key] !== '') {
                        paths.forEach((path) => {
                            const formValue = lodash_get__WEBPACK_IMPORTED_MODULE_4___default()(formData, path);
                            // adds path to fieldNames if it points to a value
                            // or an empty object/array
                            if (typeof formValue !== 'object' ||
                                lodash_isEmpty__WEBPACK_IMPORTED_MODULE_5___default()(formValue) ||
                                (Array.isArray(formValue) && formValue.every((val) => typeof val !== 'object'))) {
                                acc.push(path);
                            }
                        });
                    }
                });
                return acc;
            };
            return getAllPaths(pathSchema);
        };
        /** Returns the `formData` after filtering to remove any extra data not in a form field
         *
         * @param formData - The data for the `Form`
         * @returns The `formData` after omitting extra data
         */
        this.omitExtraData = (formData) => {
            const { schema, schemaUtils } = this.state;
            const retrievedSchema = schemaUtils.retrieveSchema(schema, formData);
            const pathSchema = schemaUtils.toPathSchema(retrievedSchema, '', formData);
            const fieldNames = this.getFieldNames(pathSchema, formData);
            const newFormData = this.getUsedFormData(formData, fieldNames);
            return newFormData;
        };
        /** Function to handle changes made to a field in the `Form`. This handler receives an entirely new copy of the
         * `formData` along with a new `ErrorSchema`. It will first update the `formData` with any missing default fields and
         * then, if `omitExtraData` and `liveOmit` are turned on, the `formData` will be filtered to remove any extra data not
         * in a form field. Then, the resulting formData will be validated if required. The state will be updated with the new
         * updated (potentially filtered) `formData`, any errors that resulted from validation. Finally the `onChange`
         * callback will be called if specified with the updated state.
         *
         * @param formData - The new form data from a change to a field
         * @param newErrorSchema - The new `ErrorSchema` based on the field change
         * @param id - The id of the field that caused the change
         */
        this.onChange = (formData, newErrorSchema, id) => {
            const { extraErrors, omitExtraData, liveOmit, noValidate, liveValidate, onChange } = this.props;
            const { schemaUtils, schema, retrievedSchema } = this.state;
            if ((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.isObject)(formData) || Array.isArray(formData)) {
                const newState = this.getStateFromProps(this.props, formData, retrievedSchema);
                formData = newState.formData;
            }
            const mustValidate = !noValidate && liveValidate;
            let state = { formData, schema };
            let newFormData = formData;
            let _retrievedSchema;
            if (omitExtraData === true && liveOmit === true) {
                newFormData = this.omitExtraData(formData);
                state = {
                    formData: newFormData,
                };
            }
            if (mustValidate) {
                const schemaValidation = this.validate(newFormData, schema, schemaUtils, retrievedSchema);
                let errors = schemaValidation.errors;
                let errorSchema = schemaValidation.errorSchema;
                const schemaValidationErrors = errors;
                const schemaValidationErrorSchema = errorSchema;
                if (extraErrors) {
                    const merged = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.validationDataMerge)(schemaValidation, extraErrors);
                    errorSchema = merged.errorSchema;
                    errors = merged.errors;
                }
                // Merging 'newErrorSchema' into 'errorSchema' to display the custom raised errors.
                if (newErrorSchema) {
                    const filteredErrors = this.filterErrorsBasedOnSchema(newErrorSchema, retrievedSchema, newFormData);
                    errorSchema = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.mergeObjects)(errorSchema, filteredErrors, 'preventDuplicates');
                }
                state = {
                    formData: newFormData,
                    errors,
                    errorSchema,
                    schemaValidationErrors,
                    schemaValidationErrorSchema,
                };
            }
            else if (!noValidate && newErrorSchema) {
                const errorSchema = extraErrors
                    ? (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.mergeObjects)(newErrorSchema, extraErrors, 'preventDuplicates')
                    : newErrorSchema;
                state = {
                    formData: newFormData,
                    errorSchema: errorSchema,
                    errors: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.toErrorList)(errorSchema),
                };
            }
            if (_retrievedSchema) {
                state.retrievedSchema = _retrievedSchema;
            }
            this.setState(state, () => onChange && onChange({ ...this.state, ...state }, id));
        };
        /**
         * Callback function to handle reset form data.
         * - Reset all fields with default values.
         * - Reset validations and errors
         *
         */
        this.reset = () => {
            const { onChange } = this.props;
            const newState = this.getStateFromProps(this.props, undefined);
            const newFormData = newState.formData;
            const state = {
                formData: newFormData,
                errorSchema: {},
                errors: [],
                schemaValidationErrors: [],
                schemaValidationErrorSchema: {},
            };
            this.setState(state, () => onChange && onChange({ ...this.state, ...state }));
        };
        /** Callback function to handle when a field on the form is blurred. Calls the `onBlur` callback for the `Form` if it
         * was provided.
         *
         * @param id - The unique `id` of the field that was blurred
         * @param data - The data associated with the field that was blurred
         */
        this.onBlur = (id, data) => {
            const { onBlur } = this.props;
            if (onBlur) {
                onBlur(id, data);
            }
        };
        /** Callback function to handle when a field on the form is focused. Calls the `onFocus` callback for the `Form` if it
         * was provided.
         *
         * @param id - The unique `id` of the field that was focused
         * @param data - The data associated with the field that was focused
         */
        this.onFocus = (id, data) => {
            const { onFocus } = this.props;
            if (onFocus) {
                onFocus(id, data);
            }
        };
        /** Callback function to handle when the form is submitted. First, it prevents the default event behavior. Nothing
         * happens if the target and currentTarget of the event are not the same. It will omit any extra data in the
         * `formData` in the state if `omitExtraData` is true. It will validate the resulting `formData`, reporting errors
         * via the `onError()` callback unless validation is disabled. Finally, it will add in any `extraErrors` and then call
         * back the `onSubmit` callback if it was provided.
         *
         * @param event - The submit HTML form event
         */
        this.onSubmit = (event) => {
            event.preventDefault();
            if (event.target !== event.currentTarget) {
                return;
            }
            event.persist();
            const { omitExtraData, extraErrors, noValidate, onSubmit } = this.props;
            let { formData: newFormData } = this.state;
            if (omitExtraData === true) {
                newFormData = this.omitExtraData(newFormData);
            }
            if (noValidate || this.validateFormWithFormData(newFormData)) {
                // There are no errors generated through schema validation.
                // Check for user provided errors and update state accordingly.
                const errorSchema = extraErrors || {};
                const errors = extraErrors ? (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.toErrorList)(extraErrors) : [];
                this.setState({
                    formData: newFormData,
                    errors,
                    errorSchema,
                    schemaValidationErrors: [],
                    schemaValidationErrorSchema: {},
                }, () => {
                    if (onSubmit) {
                        onSubmit({ ...this.state, formData: newFormData, status: 'submitted' }, event);
                    }
                });
            }
        };
        /** Provides a function that can be used to programmatically submit the `Form` */
        this.submit = () => {
            if (this.formElement.current) {
                const submitCustomEvent = new CustomEvent('submit', {
                    cancelable: true,
                });
                submitCustomEvent.preventDefault();
                this.formElement.current.dispatchEvent(submitCustomEvent);
                this.formElement.current.requestSubmit();
            }
        };
        /** Validates the form using the given `formData`. For use on form submission or on programmatic validation.
         * If `onError` is provided, then it will be called with the list of errors.
         *
         * @param formData - The form data to validate
         * @returns - True if the form is valid, false otherwise.
         */
        this.validateFormWithFormData = (formData) => {
            const { extraErrors, extraErrorsBlockSubmit, focusOnFirstError, onError } = this.props;
            const { errors: prevErrors } = this.state;
            const schemaValidation = this.validate(formData);
            let errors = schemaValidation.errors;
            let errorSchema = schemaValidation.errorSchema;
            const schemaValidationErrors = errors;
            const schemaValidationErrorSchema = errorSchema;
            const hasError = errors.length > 0 || (extraErrors && extraErrorsBlockSubmit);
            if (hasError) {
                if (extraErrors) {
                    const merged = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.validationDataMerge)(schemaValidation, extraErrors);
                    errorSchema = merged.errorSchema;
                    errors = merged.errors;
                }
                if (focusOnFirstError) {
                    if (typeof focusOnFirstError === 'function') {
                        focusOnFirstError(errors[0]);
                    }
                    else {
                        this.focusOnError(errors[0]);
                    }
                }
                this.setState({
                    errors,
                    errorSchema,
                    schemaValidationErrors,
                    schemaValidationErrorSchema,
                }, () => {
                    if (onError) {
                        onError(errors);
                    }
                    else {
                        console.error('Form validation failed', errors);
                    }
                });
            }
            else if (prevErrors.length > 0) {
                this.setState({
                    errors: [],
                    errorSchema: {},
                    schemaValidationErrors: [],
                    schemaValidationErrorSchema: {},
                });
            }
            return !hasError;
        };
        if (!props.validator) {
            throw new Error('A validator is required for Form functionality to work');
        }
        this.state = this.getStateFromProps(props, props.formData);
        if (this.props.onChange && !(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.deepEquals)(this.state.formData, this.props.formData)) {
            this.props.onChange(this.state);
        }
        this.formElement = (0,react__WEBPACK_IMPORTED_MODULE_1__.createRef)();
    }
    /**
     * `getSnapshotBeforeUpdate` is a React lifecycle method that is invoked right before the most recently rendered
     * output is committed to the DOM. It enables your component to capture current values (e.g., scroll position) before
     * they are potentially changed.
     *
     * In this case, it checks if the props have changed since the last render. If they have, it computes the next state
     * of the component using `getStateFromProps` method and returns it along with a `shouldUpdate` flag set to `true` IF
     * the `nextState` and `prevState` are different, otherwise `false`. This ensures that we have the most up-to-date
     * state ready to be applied in `componentDidUpdate`.
     *
     * If `formData` hasn't changed, it simply returns an object with `shouldUpdate` set to `false`, indicating that a
     * state update is not necessary.
     *
     * @param prevProps - The previous set of props before the update.
     * @param prevState - The previous state before the update.
     * @returns Either an object containing the next state and a flag indicating that an update should occur, or an object
     *        with a flag indicating that an update is not necessary.
     */
    getSnapshotBeforeUpdate(prevProps, prevState) {
        if (!(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.deepEquals)(this.props, prevProps)) {
            const isSchemaChanged = !(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.deepEquals)(prevProps.schema, this.props.schema);
            const isFormDataChanged = !(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.deepEquals)(prevProps.formData, this.props.formData);
            const nextState = this.getStateFromProps(this.props, this.props.formData, 
            // If the `schema` has changed, we need to update the retrieved schema.
            // Or if the `formData` changes, for example in the case of a schema with dependencies that need to
            //  match one of the subSchemas, the retrieved schema must be updated.
            isSchemaChanged || isFormDataChanged ? undefined : this.state.retrievedSchema, isSchemaChanged);
            const shouldUpdate = !(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.deepEquals)(nextState, prevState);
            return { nextState, shouldUpdate };
        }
        return { shouldUpdate: false };
    }
    /**
     * `componentDidUpdate` is a React lifecycle method that is invoked immediately after updating occurs. This method is
     * not called for the initial render.
     *
     * Here, it checks if an update is necessary based on the `shouldUpdate` flag received from `getSnapshotBeforeUpdate`.
     * If an update is required, it applies the next state and, if needed, triggers the `onChange` handler to inform about
     * changes.
     *
     * This method effectively replaces the deprecated `UNSAFE_componentWillReceiveProps`, providing a safer alternative
     * to handle prop changes and state updates.
     *
     * @param _ - The previous set of props.
     * @param prevState - The previous state of the component before the update.
     * @param snapshot - The value returned from `getSnapshotBeforeUpdate`.
     */
    componentDidUpdate(_, prevState, snapshot) {
        if (snapshot.shouldUpdate) {
            const { nextState } = snapshot;
            if (!(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.deepEquals)(nextState.formData, this.props.formData) &&
                !(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.deepEquals)(nextState.formData, prevState.formData) &&
                this.props.onChange) {
                this.props.onChange(nextState);
            }
            this.setState(nextState);
        }
    }
    /** Extracts the updated state from the given `props` and `inputFormData`. As part of this process, the
     * `inputFormData` is first processed to add any missing required defaults. After that, the data is run through the
     * validation process IF required by the `props`.
     *
     * @param props - The props passed to the `Form`
     * @param inputFormData - The new or current data for the `Form`
     * @param retrievedSchema - An expanded schema, if not provided, it will be retrieved from the `schema` and `formData`.
     * @param isSchemaChanged - A flag indicating whether the schema has changed.
     * @returns - The new state for the `Form`
     */
    getStateFromProps(props, inputFormData, retrievedSchema, isSchemaChanged = false) {
        var _a;
        const state = this.state || {};
        const schema = 'schema' in props ? props.schema : this.props.schema;
        const uiSchema = ('uiSchema' in props ? props.uiSchema : this.props.uiSchema) || {};
        const edit = typeof inputFormData !== 'undefined';
        const liveValidate = 'liveValidate' in props ? props.liveValidate : this.props.liveValidate;
        const mustValidate = edit && !props.noValidate && liveValidate;
        const rootSchema = schema;
        const experimental_defaultFormStateBehavior = 'experimental_defaultFormStateBehavior' in props
            ? props.experimental_defaultFormStateBehavior
            : this.props.experimental_defaultFormStateBehavior;
        let schemaUtils = state.schemaUtils;
        if (!schemaUtils ||
            schemaUtils.doesSchemaUtilsDiffer(props.validator, rootSchema, experimental_defaultFormStateBehavior)) {
            schemaUtils = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.createSchemaUtils)(props.validator, rootSchema, experimental_defaultFormStateBehavior);
        }
        const formData = schemaUtils.getDefaultFormState(schema, inputFormData);
        const _retrievedSchema = retrievedSchema !== null && retrievedSchema !== void 0 ? retrievedSchema : schemaUtils.retrieveSchema(schema, formData);
        const getCurrentErrors = () => {
            // If the `props.noValidate` option is set or the schema has changed, we reset the error state.
            if (props.noValidate || isSchemaChanged) {
                return { errors: [], errorSchema: {} };
            }
            else if (!props.liveValidate) {
                return {
                    errors: state.schemaValidationErrors || [],
                    errorSchema: state.schemaValidationErrorSchema || {},
                };
            }
            return {
                errors: state.errors || [],
                errorSchema: state.errorSchema || {},
            };
        };
        let errors;
        let errorSchema;
        let schemaValidationErrors = state.schemaValidationErrors;
        let schemaValidationErrorSchema = state.schemaValidationErrorSchema;
        if (mustValidate) {
            const schemaValidation = this.validate(formData, schema, schemaUtils, _retrievedSchema);
            errors = schemaValidation.errors;
            // If the schema has changed, we do not merge state.errorSchema.
            // Else in the case where it hasn't changed, we merge 'state.errorSchema' with 'schemaValidation.errorSchema.' This done to display the raised field error.
            if (isSchemaChanged) {
                errorSchema = schemaValidation.errorSchema;
            }
            else {
                errorSchema = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.mergeObjects)((_a = this.state) === null || _a === void 0 ? void 0 : _a.errorSchema, schemaValidation.errorSchema, 'preventDuplicates');
            }
            schemaValidationErrors = errors;
            schemaValidationErrorSchema = errorSchema;
        }
        else {
            const currentErrors = getCurrentErrors();
            errors = currentErrors.errors;
            errorSchema = currentErrors.errorSchema;
        }
        if (props.extraErrors) {
            const merged = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.validationDataMerge)({ errorSchema, errors }, props.extraErrors);
            errorSchema = merged.errorSchema;
            errors = merged.errors;
        }
        const idSchema = schemaUtils.toIdSchema(_retrievedSchema, uiSchema['ui:rootFieldId'], formData, props.idPrefix, props.idSeparator);
        const nextState = {
            schemaUtils,
            schema,
            uiSchema,
            idSchema,
            formData,
            edit,
            errors,
            errorSchema,
            schemaValidationErrors,
            schemaValidationErrorSchema,
            retrievedSchema: _retrievedSchema,
        };
        return nextState;
    }
    /** React lifecycle method that is used to determine whether component should be updated.
     *
     * @param nextProps - The next version of the props
     * @param nextState - The next version of the state
     * @returns - True if the component should be updated, false otherwise
     */
    shouldComponentUpdate(nextProps, nextState) {
        return (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.shouldRender)(this, nextProps, nextState);
    }
    /** Validates the `formData` against the `schema` using the `altSchemaUtils` (if provided otherwise it uses the
     * `schemaUtils` in the state), returning the results.
     *
     * @param formData - The new form data to validate
     * @param schema - The schema used to validate against
     * @param altSchemaUtils - The alternate schemaUtils to use for validation
     */
    validate(formData, schema = this.props.schema, altSchemaUtils, retrievedSchema) {
        const schemaUtils = altSchemaUtils ? altSchemaUtils : this.state.schemaUtils;
        const { customValidate, transformErrors, uiSchema } = this.props;
        const resolvedSchema = retrievedSchema !== null && retrievedSchema !== void 0 ? retrievedSchema : schemaUtils.retrieveSchema(schema, formData);
        return schemaUtils
            .getValidator()
            .validateFormData(formData, resolvedSchema, customValidate, transformErrors, uiSchema);
    }
    /** Renders any errors contained in the `state` in using the `ErrorList`, if not disabled by `showErrorList`. */
    renderErrors(registry) {
        const { errors, errorSchema, schema, uiSchema } = this.state;
        const { formContext } = this.props;
        const options = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema);
        const ErrorListTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('ErrorListTemplate', registry, options);
        if (errors && errors.length) {
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ErrorListTemplate, { errors: errors, errorSchema: errorSchema || {}, schema: schema, uiSchema: uiSchema, formContext: formContext, registry: registry }));
        }
        return null;
    }
    // Filtering errors based on your retrieved schema to only show errors for properties in the selected branch.
    filterErrorsBasedOnSchema(schemaErrors, resolvedSchema, formData) {
        const { retrievedSchema, schemaUtils } = this.state;
        const _retrievedSchema = resolvedSchema !== null && resolvedSchema !== void 0 ? resolvedSchema : retrievedSchema;
        const pathSchema = schemaUtils.toPathSchema(_retrievedSchema, '', formData);
        const fieldNames = this.getFieldNames(pathSchema, formData);
        const filteredErrors = lodash_pick__WEBPACK_IMPORTED_MODULE_6___default()(schemaErrors, fieldNames);
        // If the root schema is of a primitive type, do not filter out the __errors
        if ((resolvedSchema === null || resolvedSchema === void 0 ? void 0 : resolvedSchema.type) !== 'object' && (resolvedSchema === null || resolvedSchema === void 0 ? void 0 : resolvedSchema.type) !== 'array') {
            filteredErrors.__errors = schemaErrors.__errors;
        }
        // Removing undefined and empty errors.
        const filterUndefinedErrors = (errors) => {
            lodash_forEach__WEBPACK_IMPORTED_MODULE_3___default()(errors, (errorAtKey, errorKey) => {
                if (errorAtKey === undefined) {
                    delete errors[errorKey];
                }
                else if (typeof errorAtKey === 'object' && !Array.isArray(errorAtKey.__errors)) {
                    filterUndefinedErrors(errorAtKey);
                }
            });
            return errors;
        };
        return filterUndefinedErrors(filteredErrors);
    }
    /** Returns the registry for the form */
    getRegistry() {
        var _a;
        const { translateString: customTranslateString, uiSchema = {} } = this.props;
        const { schemaUtils } = this.state;
        const { fields, templates, widgets, formContext, translateString } = (0,_getDefaultRegistry__WEBPACK_IMPORTED_MODULE_8__["default"])();
        return {
            fields: { ...fields, ...this.props.fields },
            templates: {
                ...templates,
                ...this.props.templates,
                ButtonTemplates: {
                    ...templates.ButtonTemplates,
                    ...(_a = this.props.templates) === null || _a === void 0 ? void 0 : _a.ButtonTemplates,
                },
            },
            widgets: { ...widgets, ...this.props.widgets },
            rootSchema: this.props.schema,
            formContext: this.props.formContext || formContext,
            schemaUtils,
            translateString: customTranslateString || translateString,
            globalUiOptions: uiSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.UI_GLOBAL_OPTIONS_KEY],
        };
    }
    /** Attempts to focus on the field associated with the `error`. Uses the `property` field to compute path of the error
     * field, then, using the `idPrefix` and `idSeparator` converts that path into an id. Then the input element with that
     * id is attempted to be found using the `formElement` ref. If it is located, then it is focused.
     *
     * @param error - The error on which to focus
     */
    focusOnError(error) {
        const { idPrefix = 'root', idSeparator = '_' } = this.props;
        const { property } = error;
        const path = lodash_toPath__WEBPACK_IMPORTED_MODULE_7___default()(property);
        if (path[0] === '') {
            // Most of the time the `.foo` property results in the first element being empty, so replace it with the idPrefix
            path[0] = idPrefix;
        }
        else {
            // Otherwise insert the idPrefix into the first location using unshift
            path.unshift(idPrefix);
        }
        const elementId = path.join(idSeparator);
        let field = this.formElement.current.elements[elementId];
        if (!field) {
            // if not an exact match, try finding an input starting with the element id (like radio buttons or checkboxes)
            field = this.formElement.current.querySelector(`input[id^="${elementId}"`);
        }
        if (field && field.length) {
            // If we got a list with length > 0
            field = field[0];
        }
        if (field) {
            field.focus();
        }
    }
    /** Programmatically validate the form.  If `omitExtraData` is true, the `formData` will first be filtered to remove
     * any extra data not in a form field. If `onError` is provided, then it will be called with the list of errors the
     * same way as would happen on form submission.
     *
     * @returns - True if the form is valid, false otherwise.
     */
    validateForm() {
        const { omitExtraData } = this.props;
        let { formData: newFormData } = this.state;
        if (omitExtraData === true) {
            newFormData = this.omitExtraData(newFormData);
        }
        return this.validateFormWithFormData(newFormData);
    }
    /** Renders the `Form` fields inside the <form> | `tagName` or `_internalFormWrapper`, rendering any errors if
     * needed along with the submit button or any children of the form.
     */
    render() {
        const { children, id, idPrefix, idSeparator, className = '', tagName, name, method, target, action, autoComplete, enctype, acceptcharset, acceptCharset, noHtml5Validate = false, disabled, readonly, formContext, showErrorList = 'top', _internalFormWrapper, } = this.props;
        const { schema, uiSchema, formData, errorSchema, idSchema } = this.state;
        const registry = this.getRegistry();
        const { SchemaField: _SchemaField } = registry.fields;
        const { SubmitButton } = registry.templates.ButtonTemplates;
        // The `semantic-ui` and `material-ui` themes have `_internalFormWrapper`s that take an `as` prop that is the
        // PropTypes.elementType to use for the inner tag, so we'll need to pass `tagName` along if it is provided.
        // NOTE, the `as` prop is native to `semantic-ui` and is emulated in the `material-ui` theme
        const as = _internalFormWrapper ? tagName : undefined;
        const FormTag = _internalFormWrapper || tagName || 'form';
        let { [_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.SUBMIT_BTN_OPTIONS_KEY]: submitOptions = {} } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema);
        if (disabled) {
            submitOptions = { ...submitOptions, props: { ...submitOptions.props, disabled: true } };
        }
        const submitUiSchema = { [_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.UI_OPTIONS_KEY]: { [_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.SUBMIT_BTN_OPTIONS_KEY]: submitOptions } };
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(FormTag, { className: className ? className : 'rjsf', id: id, name: name, method: method, target: target, action: action, autoComplete: autoComplete, encType: enctype, acceptCharset: acceptCharset || acceptcharset, noValidate: noHtml5Validate, onSubmit: this.onSubmit, as: as, ref: this.formElement, children: [showErrorList === 'top' && this.renderErrors(registry), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SchemaField, { name: '', schema: schema, uiSchema: uiSchema, errorSchema: errorSchema, idSchema: idSchema, idPrefix: idPrefix, idSeparator: idSeparator, formContext: formContext, formData: formData, onChange: this.onChange, onBlur: this.onBlur, onFocus: this.onFocus, registry: registry, disabled: disabled, readonly: readonly }), children ? children : (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(SubmitButton, { uiSchema: submitUiSchema, registry: registry }), showErrorList === 'bottom' && this.renderErrors(registry)] }));
    }
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/fields/ArrayField.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/fields/ArrayField.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");
/* harmony import */ var lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/cloneDeep */ "../../node_modules/lodash/cloneDeep.js");
/* harmony import */ var lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash/isObject */ "../../node_modules/lodash/isObject.js");
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash_isObject__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash/set */ "../../node_modules/lodash/set.js");
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash_set__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var nanoid__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! nanoid */ "../../node_modules/nanoid/index.browser.js");








/** Used to generate a unique ID for an element in a row */
function generateRowId() {
    return (0,nanoid__WEBPACK_IMPORTED_MODULE_7__.nanoid)();
}
/** Converts the `formData` into `KeyedFormDataType` data, using the `generateRowId()` function to create the key
 *
 * @param formData - The data for the form
 * @returns - The `formData` converted into a `KeyedFormDataType` element
 */
function generateKeyedFormData(formData) {
    return !Array.isArray(formData)
        ? []
        : formData.map((item) => {
            return {
                key: generateRowId(),
                item,
            };
        });
}
/** Converts `KeyedFormDataType` data into the inner `formData`
 *
 * @param keyedFormData - The `KeyedFormDataType` to be converted
 * @returns - The inner `formData` item(s) in the `keyedFormData`
 */
function keyedToPlainFormData(keyedFormData) {
    if (Array.isArray(keyedFormData)) {
        return keyedFormData.map((keyedItem) => keyedItem.item);
    }
    return [];
}
/** The `ArrayField` component is used to render a field in the schema that is of type `array`. It supports both normal
 * and fixed array, allowing user to add and remove elements from the array data.
 */
class ArrayField extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    /** Constructs an `ArrayField` from the `props`, generating the initial keyed data from the `formData`
     *
     * @param props - The `FieldProps` for this template
     */
    constructor(props) {
        super(props);
        /** Returns the default form information for an item based on the schema for that item. Deals with the possibility
         * that the schema is fixed and allows additional items.
         */
        this._getNewFormDataRow = () => {
            const { schema, registry } = this.props;
            const { schemaUtils } = registry;
            let itemSchema = schema.items;
            if ((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.isFixedItems)(schema) && (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.allowAdditionalItems)(schema)) {
                itemSchema = schema.additionalItems;
            }
            // Cast this as a T to work around schema utils being for T[] caused by the FieldProps<T[], S, F> call on the class
            return schemaUtils.getDefaultFormState(itemSchema);
        };
        /** Callback handler for when the user clicks on the add button. Creates a new row of keyed form data at the end of
         * the list, adding it into the state, and then returning `onChange()` with the plain form data converted from the
         * keyed data
         *
         * @param event - The event for the click
         */
        this.onAddClick = (event) => {
            this._handleAddClick(event);
        };
        /** Callback handler for when the user clicks on the add button on an existing array element. Creates a new row of
         * keyed form data inserted at the `index`, adding it into the state, and then returning `onChange()` with the plain
         * form data converted from the keyed data
         *
         * @param index - The index at which the add button is clicked
         */
        this.onAddIndexClick = (index) => {
            return (event) => {
                this._handleAddClick(event, index);
            };
        };
        /** Callback handler for when the user clicks on the copy button on an existing array element. Clones the row of
         * keyed form data at the `index` into the next position in the state, and then returning `onChange()` with the plain
         * form data converted from the keyed data
         *
         * @param index - The index at which the copy button is clicked
         */
        this.onCopyIndexClick = (index) => {
            return (event) => {
                if (event) {
                    event.preventDefault();
                }
                const { onChange, errorSchema } = this.props;
                const { keyedFormData } = this.state;
                // refs #195: revalidate to ensure properly reindexing errors
                let newErrorSchema;
                if (errorSchema) {
                    newErrorSchema = {};
                    for (const idx in errorSchema) {
                        const i = parseInt(idx);
                        if (i <= index) {
                            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [i], errorSchema[idx]);
                        }
                        else if (i > index) {
                            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [i + 1], errorSchema[idx]);
                        }
                    }
                }
                const newKeyedFormDataRow = {
                    key: generateRowId(),
                    item: lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_3___default()(keyedFormData[index].item),
                };
                const newKeyedFormData = [...keyedFormData];
                if (index !== undefined) {
                    newKeyedFormData.splice(index + 1, 0, newKeyedFormDataRow);
                }
                else {
                    newKeyedFormData.push(newKeyedFormDataRow);
                }
                this.setState({
                    keyedFormData: newKeyedFormData,
                    updatedKeyedFormData: true,
                }, () => onChange(keyedToPlainFormData(newKeyedFormData), newErrorSchema));
            };
        };
        /** Callback handler for when the user clicks on the remove button on an existing array element. Removes the row of
         * keyed form data at the `index` in the state, and then returning `onChange()` with the plain form data converted
         * from the keyed data
         *
         * @param index - The index at which the remove button is clicked
         */
        this.onDropIndexClick = (index) => {
            return (event) => {
                if (event) {
                    event.preventDefault();
                }
                const { onChange, errorSchema } = this.props;
                const { keyedFormData } = this.state;
                // refs #195: revalidate to ensure properly reindexing errors
                let newErrorSchema;
                if (errorSchema) {
                    newErrorSchema = {};
                    for (const idx in errorSchema) {
                        const i = parseInt(idx);
                        if (i < index) {
                            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [i], errorSchema[idx]);
                        }
                        else if (i > index) {
                            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [i - 1], errorSchema[idx]);
                        }
                    }
                }
                const newKeyedFormData = keyedFormData.filter((_, i) => i !== index);
                this.setState({
                    keyedFormData: newKeyedFormData,
                    updatedKeyedFormData: true,
                }, () => onChange(keyedToPlainFormData(newKeyedFormData), newErrorSchema));
            };
        };
        /** Callback handler for when the user clicks on one of the move item buttons on an existing array element. Moves the
         * row of keyed form data at the `index` to the `newIndex` in the state, and then returning `onChange()` with the
         * plain form data converted from the keyed data
         *
         * @param index - The index of the item to move
         * @param newIndex - The index to where the item is to be moved
         */
        this.onReorderClick = (index, newIndex) => {
            return (event) => {
                if (event) {
                    event.preventDefault();
                    event.currentTarget.blur();
                }
                const { onChange, errorSchema } = this.props;
                let newErrorSchema;
                if (errorSchema) {
                    newErrorSchema = {};
                    for (const idx in errorSchema) {
                        const i = parseInt(idx);
                        if (i == index) {
                            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [newIndex], errorSchema[index]);
                        }
                        else if (i == newIndex) {
                            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [index], errorSchema[newIndex]);
                        }
                        else {
                            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [idx], errorSchema[i]);
                        }
                    }
                }
                const { keyedFormData } = this.state;
                function reOrderArray() {
                    // Copy item
                    const _newKeyedFormData = keyedFormData.slice();
                    // Moves item from index to newIndex
                    _newKeyedFormData.splice(index, 1);
                    _newKeyedFormData.splice(newIndex, 0, keyedFormData[index]);
                    return _newKeyedFormData;
                }
                const newKeyedFormData = reOrderArray();
                this.setState({
                    keyedFormData: newKeyedFormData,
                }, () => onChange(keyedToPlainFormData(newKeyedFormData), newErrorSchema));
            };
        };
        /** Callback handler used to deal with changing the value of the data in the array at the `index`. Calls the
         * `onChange` callback with the updated form data
         *
         * @param index - The index of the item being changed
         */
        this.onChangeForIndex = (index) => {
            return (value, newErrorSchema, id) => {
                const { formData, onChange, errorSchema } = this.props;
                const arrayData = Array.isArray(formData) ? formData : [];
                const newFormData = arrayData.map((item, i) => {
                    // We need to treat undefined items as nulls to have validation.
                    // See https://github.com/tdegrunt/jsonschema/issues/206
                    const jsonValue = typeof value === 'undefined' ? null : value;
                    return index === i ? jsonValue : item;
                });
                onChange(newFormData, errorSchema &&
                    errorSchema && {
                    ...errorSchema,
                    [index]: newErrorSchema,
                }, id);
            };
        };
        /** Callback handler used to change the value for a checkbox */
        this.onSelectChange = (value) => {
            const { onChange, idSchema } = this.props;
            onChange(value, undefined, idSchema && idSchema.$id);
        };
        const { formData = [] } = props;
        const keyedFormData = generateKeyedFormData(formData);
        this.state = {
            keyedFormData,
            updatedKeyedFormData: false,
        };
    }
    /** React lifecycle method that is called when the props are about to change allowing the state to be updated. It
     * regenerates the keyed form data and returns it
     *
     * @param nextProps - The next set of props data
     * @param prevState - The previous set of state data
     */
    static getDerivedStateFromProps(nextProps, prevState) {
        // Don't call getDerivedStateFromProps if keyed formdata was just updated.
        if (prevState.updatedKeyedFormData) {
            return {
                updatedKeyedFormData: false,
            };
        }
        const nextFormData = Array.isArray(nextProps.formData) ? nextProps.formData : [];
        const previousKeyedFormData = prevState.keyedFormData || [];
        const newKeyedFormData = nextFormData.length === previousKeyedFormData.length
            ? previousKeyedFormData.map((previousKeyedFormDatum, index) => {
                return {
                    key: previousKeyedFormDatum.key,
                    item: nextFormData[index],
                };
            })
            : generateKeyedFormData(nextFormData);
        return {
            keyedFormData: newKeyedFormData,
        };
    }
    /** Returns the appropriate title for an item by getting first the title from the schema.items, then falling back to
     * the description from the schema.items, and finally the string "Item"
     */
    get itemTitle() {
        const { schema, registry } = this.props;
        const { translateString } = registry;
        return lodash_get__WEBPACK_IMPORTED_MODULE_4___default()(schema, [_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ITEMS_KEY, 'title'], lodash_get__WEBPACK_IMPORTED_MODULE_4___default()(schema, [_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ITEMS_KEY, 'description'], translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.ArrayItemTitle)));
    }
    /** Determines whether the item described in the schema is always required, which is determined by whether any item
     * may be null.
     *
     * @param itemSchema - The schema for the item
     * @return - True if the item schema type does not contain the "null" type
     */
    isItemRequired(itemSchema) {
        if (Array.isArray(itemSchema.type)) {
            // While we don't yet support composite/nullable jsonschema types, it's
            // future-proof to check for requirement against these.
            return !itemSchema.type.includes('null');
        }
        // All non-null array item types are inherently required by design
        return itemSchema.type !== 'null';
    }
    /** Determines whether more items can be added to the array. If the uiSchema indicates the array doesn't allow adding
     * then false is returned. Otherwise, if the schema indicates that there are a maximum number of items and the
     * `formData` matches that value, then false is returned, otherwise true is returned.
     *
     * @param formItems - The list of items in the form
     * @returns - True if the item is addable otherwise false
     */
    canAddItem(formItems) {
        const { schema, uiSchema, registry } = this.props;
        let { addable } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, registry.globalUiOptions);
        if (addable !== false) {
            // if ui:options.addable was not explicitly set to false, we can add
            // another item if we have not exceeded maxItems yet
            if (schema.maxItems !== undefined) {
                addable = formItems.length < schema.maxItems;
            }
            else {
                addable = true;
            }
        }
        return addable;
    }
    /** Callback handler for when the user clicks on the add or add at index buttons. Creates a new row of keyed form data
     * either at the end of the list (when index is not specified) or inserted at the `index` when it is, adding it into
     * the state, and then returning `onChange()` with the plain form data converted from the keyed data
     *
     * @param event - The event for the click
     * @param [index] - The optional index at which to add the new data
     */
    _handleAddClick(event, index) {
        if (event) {
            event.preventDefault();
        }
        const { onChange, errorSchema } = this.props;
        const { keyedFormData } = this.state;
        // refs #195: revalidate to ensure properly reindexing errors
        let newErrorSchema;
        if (errorSchema) {
            newErrorSchema = {};
            for (const idx in errorSchema) {
                const i = parseInt(idx);
                if (index === undefined || i < index) {
                    lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [i], errorSchema[idx]);
                }
                else if (i >= index) {
                    lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newErrorSchema, [i + 1], errorSchema[idx]);
                }
            }
        }
        const newKeyedFormDataRow = {
            key: generateRowId(),
            item: this._getNewFormDataRow(),
        };
        const newKeyedFormData = [...keyedFormData];
        if (index !== undefined) {
            newKeyedFormData.splice(index, 0, newKeyedFormDataRow);
        }
        else {
            newKeyedFormData.push(newKeyedFormDataRow);
        }
        this.setState({
            keyedFormData: newKeyedFormData,
            updatedKeyedFormData: true,
        }, () => onChange(keyedToPlainFormData(newKeyedFormData), newErrorSchema));
    }
    /** Renders the `ArrayField` depending on the specific needs of the schema and uischema elements
     */
    render() {
        const { schema, uiSchema, idSchema, registry } = this.props;
        const { schemaUtils, translateString } = registry;
        if (!(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ITEMS_KEY in schema)) {
            const uiOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema);
            const UnsupportedFieldTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('UnsupportedFieldTemplate', registry, uiOptions);
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(UnsupportedFieldTemplate, { schema: schema, idSchema: idSchema, reason: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.MissingItems), registry: registry }));
        }
        if (schemaUtils.isMultiSelect(schema)) {
            // If array has enum or uniqueItems set to true, call renderMultiSelect() to render the default multiselect widget or a custom widget, if specified.
            return this.renderMultiSelect();
        }
        if ((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.isCustomWidget)(uiSchema)) {
            return this.renderCustomWidget();
        }
        if ((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.isFixedItems)(schema)) {
            return this.renderFixedArray();
        }
        if (schemaUtils.isFilesArray(schema, uiSchema)) {
            return this.renderFiles();
        }
        return this.renderNormalArray();
    }
    /** Renders a normal array without any limitations of length
     */
    renderNormalArray() {
        const { schema, uiSchema = {}, errorSchema, idSchema, name, title, disabled = false, readonly = false, autofocus = false, required = false, registry, onBlur, onFocus, idPrefix, idSeparator = '_', rawErrors, } = this.props;
        const { keyedFormData } = this.state;
        const fieldTitle = schema.title || title || name;
        const { schemaUtils, formContext } = registry;
        const uiOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema);
        const _schemaItems = lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default()(schema.items) ? schema.items : {};
        const itemsSchema = schemaUtils.retrieveSchema(_schemaItems);
        const formData = keyedToPlainFormData(this.state.keyedFormData);
        const canAdd = this.canAddItem(formData);
        const arrayProps = {
            canAdd,
            items: keyedFormData.map((keyedItem, index) => {
                const { key, item } = keyedItem;
                // While we are actually dealing with a single item of type T, the types require a T[], so cast
                const itemCast = item;
                const itemSchema = schemaUtils.retrieveSchema(_schemaItems, itemCast);
                const itemErrorSchema = errorSchema ? errorSchema[index] : undefined;
                const itemIdPrefix = idSchema.$id + idSeparator + index;
                const itemIdSchema = schemaUtils.toIdSchema(itemSchema, itemIdPrefix, itemCast, idPrefix, idSeparator);
                return this.renderArrayFieldItem({
                    key,
                    index,
                    name: name && `${name}-${index}`,
                    title: fieldTitle ? `${fieldTitle}-${index + 1}` : undefined,
                    canAdd,
                    canMoveUp: index > 0,
                    canMoveDown: index < formData.length - 1,
                    itemSchema,
                    itemIdSchema,
                    itemErrorSchema,
                    itemData: itemCast,
                    itemUiSchema: uiSchema.items,
                    autofocus: autofocus && index === 0,
                    onBlur,
                    onFocus,
                    rawErrors,
                    totalItems: keyedFormData.length,
                });
            }),
            className: `field field-array field-array-of-${itemsSchema.type}`,
            disabled,
            idSchema,
            uiSchema,
            onAddClick: this.onAddClick,
            readonly,
            required,
            schema,
            title: fieldTitle,
            formContext,
            formData,
            rawErrors,
            registry,
        };
        const Template = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('ArrayFieldTemplate', registry, uiOptions);
        return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Template, { ...arrayProps });
    }
    /** Renders an array using the custom widget provided by the user in the `uiSchema`
     */
    renderCustomWidget() {
        var _a;
        const { schema, idSchema, uiSchema, disabled = false, readonly = false, autofocus = false, required = false, hideError, placeholder, onBlur, onFocus, formData: items = [], registry, rawErrors, name, } = this.props;
        const { widgets, formContext, globalUiOptions, schemaUtils } = registry;
        const { widget, title: uiTitle, ...options } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, globalUiOptions);
        const Widget = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getWidget)(schema, widget, widgets);
        const label = (_a = uiTitle !== null && uiTitle !== void 0 ? uiTitle : schema.title) !== null && _a !== void 0 ? _a : name;
        const displayLabel = schemaUtils.getDisplayLabel(schema, uiSchema, globalUiOptions);
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Widget, { id: idSchema.$id, name: name, multiple: true, onChange: this.onSelectChange, onBlur: onBlur, onFocus: onFocus, options: options, schema: schema, uiSchema: uiSchema, registry: registry, value: items, disabled: disabled, readonly: readonly, hideError: hideError, required: required, label: label, hideLabel: !displayLabel, placeholder: placeholder, formContext: formContext, autofocus: autofocus, rawErrors: rawErrors }));
    }
    /** Renders an array as a set of checkboxes
     */
    renderMultiSelect() {
        var _a;
        const { schema, idSchema, uiSchema, formData: items = [], disabled = false, readonly = false, autofocus = false, required = false, placeholder, onBlur, onFocus, registry, rawErrors, name, } = this.props;
        const { widgets, schemaUtils, formContext, globalUiOptions } = registry;
        const itemsSchema = schemaUtils.retrieveSchema(schema.items, items);
        const enumOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.optionsList)(itemsSchema, uiSchema);
        const { widget = 'select', title: uiTitle, ...options } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, globalUiOptions);
        const Widget = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getWidget)(schema, widget, widgets);
        const label = (_a = uiTitle !== null && uiTitle !== void 0 ? uiTitle : schema.title) !== null && _a !== void 0 ? _a : name;
        const displayLabel = schemaUtils.getDisplayLabel(schema, uiSchema, globalUiOptions);
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Widget, { id: idSchema.$id, name: name, multiple: true, onChange: this.onSelectChange, onBlur: onBlur, onFocus: onFocus, options: { ...options, enumOptions }, schema: schema, uiSchema: uiSchema, registry: registry, value: items, disabled: disabled, readonly: readonly, required: required, label: label, hideLabel: !displayLabel, placeholder: placeholder, formContext: formContext, autofocus: autofocus, rawErrors: rawErrors }));
    }
    /** Renders an array of files using the `FileWidget`
     */
    renderFiles() {
        var _a;
        const { schema, uiSchema, idSchema, name, disabled = false, readonly = false, autofocus = false, required = false, onBlur, onFocus, registry, formData: items = [], rawErrors, } = this.props;
        const { widgets, formContext, globalUiOptions, schemaUtils } = registry;
        const { widget = 'files', title: uiTitle, ...options } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, globalUiOptions);
        const Widget = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getWidget)(schema, widget, widgets);
        const label = (_a = uiTitle !== null && uiTitle !== void 0 ? uiTitle : schema.title) !== null && _a !== void 0 ? _a : name;
        const displayLabel = schemaUtils.getDisplayLabel(schema, uiSchema, globalUiOptions);
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Widget, { options: options, id: idSchema.$id, name: name, multiple: true, onChange: this.onSelectChange, onBlur: onBlur, onFocus: onFocus, schema: schema, uiSchema: uiSchema, value: items, disabled: disabled, readonly: readonly, required: required, registry: registry, formContext: formContext, autofocus: autofocus, rawErrors: rawErrors, label: label, hideLabel: !displayLabel }));
    }
    /** Renders an array that has a maximum limit of items
     */
    renderFixedArray() {
        const { schema, uiSchema = {}, formData = [], errorSchema, idPrefix, idSeparator = '_', idSchema, name, title, disabled = false, readonly = false, autofocus = false, required = false, registry, onBlur, onFocus, rawErrors, } = this.props;
        const { keyedFormData } = this.state;
        let { formData: items = [] } = this.props;
        const fieldTitle = schema.title || title || name;
        const uiOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema);
        const { schemaUtils, formContext } = registry;
        const _schemaItems = lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default()(schema.items) ? schema.items : [];
        const itemSchemas = _schemaItems.map((item, index) => schemaUtils.retrieveSchema(item, formData[index]));
        const additionalSchema = lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default()(schema.additionalItems)
            ? schemaUtils.retrieveSchema(schema.additionalItems, formData)
            : null;
        if (!items || items.length < itemSchemas.length) {
            // to make sure at least all fixed items are generated
            items = items || [];
            items = items.concat(new Array(itemSchemas.length - items.length));
        }
        // These are the props passed into the render function
        const canAdd = this.canAddItem(items) && !!additionalSchema;
        const arrayProps = {
            canAdd,
            className: 'field field-array field-array-fixed-items',
            disabled,
            idSchema,
            formData,
            items: keyedFormData.map((keyedItem, index) => {
                const { key, item } = keyedItem;
                // While we are actually dealing with a single item of type T, the types require a T[], so cast
                const itemCast = item;
                const additional = index >= itemSchemas.length;
                const itemSchema = (additional && lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default()(schema.additionalItems)
                    ? schemaUtils.retrieveSchema(schema.additionalItems, itemCast)
                    : itemSchemas[index]) || {};
                const itemIdPrefix = idSchema.$id + idSeparator + index;
                const itemIdSchema = schemaUtils.toIdSchema(itemSchema, itemIdPrefix, itemCast, idPrefix, idSeparator);
                const itemUiSchema = additional
                    ? uiSchema.additionalItems || {}
                    : Array.isArray(uiSchema.items)
                        ? uiSchema.items[index]
                        : uiSchema.items || {};
                const itemErrorSchema = errorSchema ? errorSchema[index] : undefined;
                return this.renderArrayFieldItem({
                    key,
                    index,
                    name: name && `${name}-${index}`,
                    title: fieldTitle ? `${fieldTitle}-${index + 1}` : undefined,
                    canAdd,
                    canRemove: additional,
                    canMoveUp: index >= itemSchemas.length + 1,
                    canMoveDown: additional && index < items.length - 1,
                    itemSchema,
                    itemData: itemCast,
                    itemUiSchema,
                    itemIdSchema,
                    itemErrorSchema,
                    autofocus: autofocus && index === 0,
                    onBlur,
                    onFocus,
                    rawErrors,
                    totalItems: keyedFormData.length,
                });
            }),
            onAddClick: this.onAddClick,
            readonly,
            required,
            registry,
            schema,
            uiSchema,
            title: fieldTitle,
            formContext,
            errorSchema,
            rawErrors,
        };
        const Template = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('ArrayFieldTemplate', registry, uiOptions);
        return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Template, { ...arrayProps });
    }
    /** Renders the individual array item using a `SchemaField` along with the additional properties required to be send
     * back to the `ArrayFieldItemTemplate`.
     *
     * @param props - The props for the individual array item to be rendered
     */
    renderArrayFieldItem(props) {
        const { key, index, name, canAdd, canRemove = true, canMoveUp, canMoveDown, itemSchema, itemData, itemUiSchema, itemIdSchema, itemErrorSchema, autofocus, onBlur, onFocus, rawErrors, totalItems, title, } = props;
        const { disabled, hideError, idPrefix, idSeparator, readonly, uiSchema, registry, formContext } = this.props;
        const { fields: { ArraySchemaField, SchemaField }, globalUiOptions, } = registry;
        const ItemSchemaField = ArraySchemaField || SchemaField;
        const { orderable = true, removable = true, copyable = false } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, globalUiOptions);
        const has = {
            moveUp: orderable && canMoveUp,
            moveDown: orderable && canMoveDown,
            copy: copyable && canAdd,
            remove: removable && canRemove,
            toolbar: false,
        };
        has.toolbar = Object.keys(has).some((key) => has[key]);
        return {
            children: ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ItemSchemaField, { name: name, title: title, index: index, schema: itemSchema, uiSchema: itemUiSchema, formData: itemData, formContext: formContext, errorSchema: itemErrorSchema, idPrefix: idPrefix, idSeparator: idSeparator, idSchema: itemIdSchema, required: this.isItemRequired(itemSchema), onChange: this.onChangeForIndex(index), onBlur: onBlur, onFocus: onFocus, registry: registry, disabled: disabled, readonly: readonly, hideError: hideError, autofocus: autofocus, rawErrors: rawErrors })),
            className: 'array-item',
            disabled,
            canAdd,
            hasCopy: has.copy,
            hasToolbar: has.toolbar,
            hasMoveUp: has.moveUp,
            hasMoveDown: has.moveDown,
            hasRemove: has.remove,
            index,
            totalItems,
            key,
            onAddIndexClick: this.onAddIndexClick,
            onCopyIndexClick: this.onCopyIndexClick,
            onDropIndexClick: this.onDropIndexClick,
            onReorderClick: this.onReorderClick,
            readonly,
            registry,
            schema: itemSchema,
            uiSchema: itemUiSchema,
        };
    }
}
/** `ArrayField` is `React.ComponentType<FieldProps<T[], S, F>>` (necessarily) but the `registry` requires things to be a
 * `Field` which is defined as `React.ComponentType<FieldProps<T, S, F>>`, so cast it to make `registry` happy.
 */
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ArrayField);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/fields/BooleanField.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/fields/BooleanField.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/isObject */ "../../node_modules/lodash/isObject.js");
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_isObject__WEBPACK_IMPORTED_MODULE_2__);



/** The `BooleanField` component is used to render a field in the schema is boolean. It constructs `enumOptions` for the
 * two boolean values based on the various alternatives in the schema.
 *
 * @param props - The `FieldProps` for this template
 */
function BooleanField(props) {
    var _a, _b, _c;
    const { schema, name, uiSchema, idSchema, formData, registry, required, disabled, readonly, hideError, autofocus, title, onChange, onFocus, onBlur, rawErrors, } = props;
    const { title: schemaTitle } = schema;
    const { widgets, formContext, translateString, globalUiOptions } = registry;
    const { widget = 'checkbox', title: uiTitle, 
    // Unlike the other fields, don't use `getDisplayLabel()` since it always returns false for the boolean type
    label: displayLabel = true, ...options } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getUiOptions)(uiSchema, globalUiOptions);
    const Widget = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getWidget)(schema, widget, widgets);
    const yes = translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.YesLabel);
    const no = translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.NoLabel);
    let enumOptions;
    const label = (_b = (_a = uiTitle !== null && uiTitle !== void 0 ? uiTitle : schemaTitle) !== null && _a !== void 0 ? _a : title) !== null && _b !== void 0 ? _b : name;
    if (Array.isArray(schema.oneOf)) {
        enumOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.optionsList)({
            oneOf: schema.oneOf
                .map((option) => {
                if (lodash_isObject__WEBPACK_IMPORTED_MODULE_2___default()(option)) {
                    return {
                        ...option,
                        title: option.title || (option.const === true ? yes : no),
                    };
                }
                return undefined;
            })
                .filter((o) => o), // cast away the error that typescript can't grok is fixed
        }, uiSchema);
    }
    else {
        // We deprecated enumNames in v5. It's intentionally omitted from RSJFSchema type, so we need to cast here.
        const schemaWithEnumNames = schema;
        const enums = (_c = schema.enum) !== null && _c !== void 0 ? _c : [true, false];
        if (!schemaWithEnumNames.enumNames && enums.length === 2 && enums.every((v) => typeof v === 'boolean')) {
            enumOptions = [
                {
                    value: enums[0],
                    label: enums[0] ? yes : no,
                },
                {
                    value: enums[1],
                    label: enums[1] ? yes : no,
                },
            ];
        }
        else {
            enumOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.optionsList)({
                enum: enums,
                // NOTE: enumNames is deprecated, but still supported for now.
                enumNames: schemaWithEnumNames.enumNames,
            }, uiSchema);
        }
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Widget, { options: { ...options, enumOptions }, schema: schema, uiSchema: uiSchema, id: idSchema.$id, name: name, onChange: onChange, onFocus: onFocus, onBlur: onBlur, label: label, hideLabel: !displayLabel, value: formData, required: required, disabled: disabled, readonly: readonly, hideError: hideError, registry: registry, formContext: formContext, autofocus: autofocus, rawErrors: rawErrors }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BooleanField);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/fields/MultiSchemaField.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/fields/MultiSchemaField.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/isEmpty */ "../../node_modules/lodash/isEmpty.js");
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/omit */ "../../node_modules/lodash/omit.js");
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_omit__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");






/** The `AnyOfField` component is used to render a field in the schema that is an `anyOf`, `allOf` or `oneOf`. It tracks
 * the currently selected option and cleans up any irrelevant data in `formData`.
 *
 * @param props - The `FieldProps` for this template
 */
class AnyOfField extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    /** Constructs an `AnyOfField` with the given `props` to initialize the initially selected option in state
     *
     * @param props - The `FieldProps` for this template
     */
    constructor(props) {
        super(props);
        /** Callback handler to remember what the currently selected option is. In addition to that the `formData` is updated
         * to remove properties that are not part of the newly selected option schema, and then the updated data is passed to
         * the `onChange` handler.
         *
         * @param option - The new option value being selected
         */
        this.onOptionChange = (option) => {
            const { selectedOption, retrievedOptions } = this.state;
            const { formData, onChange, registry } = this.props;
            const { schemaUtils } = registry;
            const intOption = option !== undefined ? parseInt(option, 10) : -1;
            if (intOption === selectedOption) {
                return;
            }
            const newOption = intOption >= 0 ? retrievedOptions[intOption] : undefined;
            const oldOption = selectedOption >= 0 ? retrievedOptions[selectedOption] : undefined;
            let newFormData = schemaUtils.sanitizeDataForNewSchema(newOption, oldOption, formData);
            if (newFormData && newOption) {
                // Call getDefaultFormState to make sure defaults are populated on change. Pass "excludeObjectChildren"
                // so that only the root objects themselves are created without adding undefined children properties
                newFormData = schemaUtils.getDefaultFormState(newOption, newFormData, 'excludeObjectChildren');
            }
            onChange(newFormData, undefined, this.getFieldId());
            this.setState({ selectedOption: intOption });
        };
        const { formData, options, registry: { schemaUtils }, } = this.props;
        // cache the retrieved options in state in case they have $refs to save doing it later
        const retrievedOptions = options.map((opt) => schemaUtils.retrieveSchema(opt, formData));
        this.state = {
            retrievedOptions,
            selectedOption: this.getMatchingOption(0, formData, retrievedOptions),
        };
    }
    /** React lifecycle method that is called when the props and/or state for this component is updated. It recomputes the
     * currently selected option based on the overall `formData`
     *
     * @param prevProps - The previous `FieldProps` for this template
     * @param prevState - The previous `AnyOfFieldState` for this template
     */
    componentDidUpdate(prevProps, prevState) {
        const { formData, options, idSchema } = this.props;
        const { selectedOption } = this.state;
        let newState = this.state;
        if (!(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.deepEquals)(prevProps.options, options)) {
            const { registry: { schemaUtils }, } = this.props;
            // re-cache the retrieved options in state in case they have $refs to save doing it later
            const retrievedOptions = options.map((opt) => schemaUtils.retrieveSchema(opt, formData));
            newState = { selectedOption, retrievedOptions };
        }
        if (!(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.deepEquals)(formData, prevProps.formData) && idSchema.$id === prevProps.idSchema.$id) {
            const { retrievedOptions } = newState;
            const matchingOption = this.getMatchingOption(selectedOption, formData, retrievedOptions);
            if (prevState && matchingOption !== selectedOption) {
                newState = { selectedOption: matchingOption, retrievedOptions };
            }
        }
        if (newState !== this.state) {
            this.setState(newState);
        }
    }
    /** Determines the best matching option for the given `formData` and `options`.
     *
     * @param formData - The new formData
     * @param options - The list of options to choose from
     * @return - The index of the `option` that best matches the `formData`
     */
    getMatchingOption(selectedOption, formData, options) {
        const { schema, registry: { schemaUtils }, } = this.props;
        const discriminator = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.getDiscriminatorFieldFromSchema)(schema);
        const option = schemaUtils.getClosestMatchingOption(formData, options, selectedOption, discriminator);
        return option;
    }
    getFieldId() {
        const { idSchema, schema } = this.props;
        return `${idSchema.$id}${schema.oneOf ? '__oneof_select' : '__anyof_select'}`;
    }
    /** Renders the `AnyOfField` selector along with a `SchemaField` for the value of the `formData`
     */
    render() {
        const { name, disabled = false, errorSchema = {}, formContext, onBlur, onFocus, registry, schema, uiSchema, } = this.props;
        const { widgets, fields, translateString, globalUiOptions, schemaUtils } = registry;
        const { SchemaField: _SchemaField } = fields;
        const { selectedOption, retrievedOptions } = this.state;
        const { widget = 'select', placeholder, autofocus, autocomplete, title = schema.title, ...uiOptions } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.getUiOptions)(uiSchema, globalUiOptions);
        const Widget = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.getWidget)({ type: 'number' }, widget, widgets);
        const rawErrors = lodash_get__WEBPACK_IMPORTED_MODULE_2___default()(errorSchema, _rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ERRORS_KEY, []);
        const fieldErrorSchema = lodash_omit__WEBPACK_IMPORTED_MODULE_4___default()(errorSchema, [_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ERRORS_KEY]);
        const displayLabel = schemaUtils.getDisplayLabel(schema, uiSchema, globalUiOptions);
        const option = selectedOption >= 0 ? retrievedOptions[selectedOption] || null : null;
        let optionSchema;
        if (option) {
            // merge top level required field
            const { required } = schema;
            // Merge in all the non-oneOf/anyOf properties and also skip the special ADDITIONAL_PROPERTY_FLAG property
            optionSchema = required ? (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.mergeSchemas)({ required }, option) : option;
        }
        // First we will check to see if there is an anyOf/oneOf override for the UI schema
        let optionsUiSchema = [];
        if (_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ONE_OF_KEY in schema && uiSchema && _rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ONE_OF_KEY in uiSchema) {
            if (Array.isArray(uiSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ONE_OF_KEY])) {
                optionsUiSchema = uiSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ONE_OF_KEY];
            }
            else {
                console.warn(`uiSchema.oneOf is not an array for "${title || name}"`);
            }
        }
        else if (_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ANY_OF_KEY in schema && uiSchema && _rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ANY_OF_KEY in uiSchema) {
            if (Array.isArray(uiSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ANY_OF_KEY])) {
                optionsUiSchema = uiSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.ANY_OF_KEY];
            }
            else {
                console.warn(`uiSchema.anyOf is not an array for "${title || name}"`);
            }
        }
        // Then we pick the one that matches the selected option index, if one exists otherwise default to the main uiSchema
        let optionUiSchema = uiSchema;
        if (selectedOption >= 0 && optionsUiSchema.length > selectedOption) {
            optionUiSchema = optionsUiSchema[selectedOption];
        }
        const translateEnum = title
            ? _rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.TranslatableString.TitleOptionPrefix
            : _rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.TranslatableString.OptionPrefix;
        const translateParams = title ? [title] : [];
        const enumOptions = retrievedOptions.map((opt, index) => {
            // Also see if there is an override title in the uiSchema for each option, otherwise use the title from the option
            const { title: uiTitle = opt.title } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_5__.getUiOptions)(optionsUiSchema[index]);
            return {
                label: uiTitle || translateString(translateEnum, translateParams.concat(String(index + 1))),
                value: index,
            };
        });
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'panel panel-default panel-body', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'form-group', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Widget, { id: this.getFieldId(), name: `${name}${schema.oneOf ? '__oneof_select' : '__anyof_select'}`, schema: { type: 'number', default: 0 }, onChange: this.onOptionChange, onBlur: onBlur, onFocus: onFocus, disabled: disabled || lodash_isEmpty__WEBPACK_IMPORTED_MODULE_3___default()(enumOptions), multiple: false, rawErrors: rawErrors, errorSchema: fieldErrorSchema, value: selectedOption >= 0 ? selectedOption : undefined, options: { enumOptions, ...uiOptions }, registry: registry, formContext: formContext, placeholder: placeholder, autocomplete: autocomplete, autofocus: autofocus, label: title !== null && title !== void 0 ? title : name, hideLabel: !displayLabel }) }), optionSchema && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_SchemaField, { ...this.props, schema: optionSchema, uiSchema: optionUiSchema })] }));
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AnyOfField);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/fields/NullField.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/fields/NullField.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

/** The `NullField` component is used to render a field in the schema is null. It also ensures that the `formData` is
 * also set to null if it has no value.
 *
 * @param props - The `FieldProps` for this template
 */
function NullField(props) {
    const { formData, onChange } = props;
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        if (formData === undefined) {
            onChange(null);
        }
    }, [formData, onChange]);
    return null;
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NullField);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/fields/NumberField.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/fields/NumberField.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");



// Matches a string that ends in a . character, optionally followed by a sequence of
// digits followed by any number of 0 characters up until the end of the line.
// Ensuring that there is at least one prefixed character is important so that
// you don't incorrectly match against "0".
const trailingCharMatcherWithPrefix = /\.([0-9]*0)*$/;
// This is used for trimming the trailing 0 and . characters without affecting
// the rest of the string. Its possible to use one RegEx with groups for this
// functionality, but it is fairly complex compared to simply defining two
// different matchers.
const trailingCharMatcher = /[0.]0*$/;
/**
 * The NumberField class has some special handling for dealing with trailing
 * decimal points and/or zeroes. This logic is designed to allow trailing values
 * to be visible in the input element, but not be represented in the
 * corresponding form data.
 *
 * The algorithm is as follows:
 *
 * 1. When the input value changes the value is cached in the component state
 *
 * 2. The value is then normalized, removing trailing decimal points and zeros,
 *    then passed to the "onChange" callback
 *
 * 3. When the component is rendered, the formData value is checked against the
 *    value cached in the state. If it matches the cached value, the cached
 *    value is passed to the input instead of the formData value
 */
function NumberField(props) {
    const { registry, onChange, formData, value: initialValue } = props;
    const [lastValue, setLastValue] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(initialValue);
    const { StringField } = registry.fields;
    let value = formData;
    /** Handle the change from the `StringField` to properly convert to a number
     *
     * @param value - The current value for the change occurring
     */
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((value) => {
        // Cache the original value in component state
        setLastValue(value);
        // Normalize decimals that don't start with a zero character in advance so
        // that the rest of the normalization logic is simpler
        if (`${value}`.charAt(0) === '.') {
            value = `0${value}`;
        }
        // Check that the value is a string (this can happen if the widget used is a
        // <select>, due to an enum declaration etc) then, if the value ends in a
        // trailing decimal point or multiple zeroes, strip the trailing values
        const processed = typeof value === 'string' && value.match(trailingCharMatcherWithPrefix)
            ? (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.asNumber)(value.replace(trailingCharMatcher, ''))
            : (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.asNumber)(value);
        onChange(processed);
    }, [onChange]);
    if (typeof lastValue === 'string' && typeof value === 'number') {
        // Construct a regular expression that checks for a string that consists
        // of the formData value suffixed with zero or one '.' characters and zero
        // or more '0' characters
        const re = new RegExp(`^(${String(value).replace('.', '\\.')})?\\.?0*$`);
        // If the cached "lastValue" is a match, use that instead of the formData
        // value to prevent the input value from changing in the UI
        if (lastValue.match(re)) {
            value = lastValue;
        }
    }
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(StringField, { ...props, formData: value, onChange: handleChange });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (NumberField);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/fields/ObjectField.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/fields/ObjectField.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");
/* harmony import */ var markdown_to_jsx__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! markdown-to-jsx */ "../../node_modules/markdown-to-jsx/dist/index.modern.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_has__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/has */ "../../node_modules/lodash/has.js");
/* harmony import */ var lodash_has__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_has__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash/isObject */ "../../node_modules/lodash/isObject.js");
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash_isObject__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash/set */ "../../node_modules/lodash/set.js");
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash_set__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var lodash_unset__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! lodash/unset */ "../../node_modules/lodash/unset.js");
/* harmony import */ var lodash_unset__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(lodash_unset__WEBPACK_IMPORTED_MODULE_7__);









/** The `ObjectField` component is used to render a field in the schema that is of type `object`. It tracks whether an
 * additional property key was modified and what it was modified to
 *
 * @param props - The `FieldProps` for this template
 */
class ObjectField extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    constructor() {
        super(...arguments);
        /** Set up the initial state */
        this.state = {
            wasPropertyKeyModified: false,
            additionalProperties: {},
        };
        /** Returns the `onPropertyChange` handler for the `name` field. Handles the special case where a user is attempting
         * to clear the data for a field added as an additional property. Calls the `onChange()` handler with the updated
         * formData.
         *
         * @param name - The name of the property
         * @param addedByAdditionalProperties - Flag indicating whether this property is an additional property
         * @returns - The onPropertyChange callback for the `name` property
         */
        this.onPropertyChange = (name, addedByAdditionalProperties = false) => {
            return (value, newErrorSchema, id) => {
                const { formData, onChange, errorSchema } = this.props;
                if (value === undefined && addedByAdditionalProperties) {
                    // Don't set value = undefined for fields added by
                    // additionalProperties. Doing so removes them from the
                    // formData, which causes them to completely disappear
                    // (including the input field for the property name). Unlike
                    // fields which are "mandated" by the schema, these fields can
                    // be set to undefined by clicking a "delete field" button, so
                    // set empty values to the empty string.
                    value = '';
                }
                const newFormData = { ...formData, [name]: value };
                onChange(newFormData, errorSchema &&
                    errorSchema && {
                    ...errorSchema,
                    [name]: newErrorSchema,
                }, id);
            };
        };
        /** Returns a callback to handle the onDropPropertyClick event for the given `key` which removes the old `key` data
         * and calls the `onChange` callback with it
         *
         * @param key - The key for which the drop callback is desired
         * @returns - The drop property click callback
         */
        this.onDropPropertyClick = (key) => {
            return (event) => {
                event.preventDefault();
                const { onChange, formData } = this.props;
                const copiedFormData = { ...formData };
                lodash_unset__WEBPACK_IMPORTED_MODULE_7___default()(copiedFormData, key);
                onChange(copiedFormData);
            };
        };
        /** Computes the next available key name from the `preferredKey`, indexing through the already existing keys until one
         * that is already not assigned is found.
         *
         * @param preferredKey - The preferred name of a new key
         * @param [formData] - The form data in which to check if the desired key already exists
         * @returns - The name of the next available key from `preferredKey`
         */
        this.getAvailableKey = (preferredKey, formData) => {
            const { uiSchema, registry } = this.props;
            const { duplicateKeySuffixSeparator = '-' } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, registry.globalUiOptions);
            let index = 0;
            let newKey = preferredKey;
            while (lodash_has__WEBPACK_IMPORTED_MODULE_4___default()(formData, newKey)) {
                newKey = `${preferredKey}${duplicateKeySuffixSeparator}${++index}`;
            }
            return newKey;
        };
        /** Returns a callback function that deals with the rename of a key for an additional property for a schema. That
         * callback will attempt to rename the key and move the existing data to that key, calling `onChange` when it does.
         *
         * @param oldValue - The old value of a field
         * @returns - The key change callback function
         */
        this.onKeyChange = (oldValue) => {
            return (value, newErrorSchema) => {
                if (oldValue === value) {
                    return;
                }
                const { formData, onChange, errorSchema } = this.props;
                value = this.getAvailableKey(value, formData);
                const newFormData = {
                    ...formData,
                };
                const newKeys = { [oldValue]: value };
                const keyValues = Object.keys(newFormData).map((key) => {
                    const newKey = newKeys[key] || key;
                    return { [newKey]: newFormData[key] };
                });
                const renamedObj = Object.assign({}, ...keyValues);
                this.setState({ wasPropertyKeyModified: true });
                onChange(renamedObj, errorSchema &&
                    errorSchema && {
                    ...errorSchema,
                    [value]: newErrorSchema,
                });
            };
        };
        /** Handles the adding of a new additional property on the given `schema`. Calls the `onChange` callback once the new
         * default data for that field has been added to the formData.
         *
         * @param schema - The schema element to which the new property is being added
         */
        this.handleAddClick = (schema) => () => {
            if (!schema.additionalProperties) {
                return;
            }
            const { formData, onChange, registry } = this.props;
            const newFormData = { ...formData };
            let type = undefined;
            let defaultValue = undefined;
            if (lodash_isObject__WEBPACK_IMPORTED_MODULE_5___default()(schema.additionalProperties)) {
                type = schema.additionalProperties.type;
                defaultValue = schema.additionalProperties.default;
                let apSchema = schema.additionalProperties;
                if (_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.REF_KEY in apSchema) {
                    const { schemaUtils } = registry;
                    apSchema = schemaUtils.retrieveSchema({ $ref: apSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.REF_KEY] }, formData);
                    type = apSchema.type;
                    defaultValue = apSchema.default;
                }
                if (!type && (_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ANY_OF_KEY in apSchema || _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ONE_OF_KEY in apSchema)) {
                    type = 'object';
                }
            }
            const newKey = this.getAvailableKey('newKey', newFormData);
            // Cast this to make the `set` work properly
            lodash_set__WEBPACK_IMPORTED_MODULE_6___default()(newFormData, newKey, defaultValue !== null && defaultValue !== void 0 ? defaultValue : this.getDefaultValue(type));
            onChange(newFormData);
        };
    }
    /** Returns a flag indicating whether the `name` field is required in the object schema
     *
     * @param name - The name of the field to check for required-ness
     * @returns - True if the field `name` is required, false otherwise
     */
    isRequired(name) {
        const { schema } = this.props;
        return Array.isArray(schema.required) && schema.required.indexOf(name) !== -1;
    }
    /** Returns a default value to be used for a new additional schema property of the given `type`
     *
     * @param type - The type of the new additional schema property
     */
    getDefaultValue(type) {
        const { registry: { translateString }, } = this.props;
        switch (type) {
            case 'array':
                return [];
            case 'boolean':
                return false;
            case 'null':
                return null;
            case 'number':
                return 0;
            case 'object':
                return {};
            case 'string':
            default:
                // We don't have a datatype for some reason (perhaps additionalProperties was true)
                return translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.NewStringDefault);
        }
    }
    /** Renders the `ObjectField` from the given props
     */
    render() {
        var _a, _b, _c, _d;
        const { schema: rawSchema, uiSchema = {}, formData, errorSchema, idSchema, name, required = false, disabled, readonly, hideError, idPrefix, idSeparator, onBlur, onFocus, registry, title, } = this.props;
        const { fields, formContext, schemaUtils, translateString, globalUiOptions } = registry;
        const { SchemaField } = fields;
        const schema = schemaUtils.retrieveSchema(rawSchema, formData);
        const uiOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, globalUiOptions);
        const { properties: schemaProperties = {} } = schema;
        const templateTitle = (_c = (_b = (_a = uiOptions.title) !== null && _a !== void 0 ? _a : schema.title) !== null && _b !== void 0 ? _b : title) !== null && _c !== void 0 ? _c : name;
        const description = (_d = uiOptions.description) !== null && _d !== void 0 ? _d : schema.description;
        let orderedProperties;
        try {
            const properties = Object.keys(schemaProperties);
            orderedProperties = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.orderProperties)(properties, uiOptions.order);
        }
        catch (err) {
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", { className: 'config-error', style: { color: 'red' }, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(markdown_to_jsx__WEBPACK_IMPORTED_MODULE_8__["default"], { options: { disableParsingRawHTML: true }, children: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.InvalidObjectField, [name || 'root', err.message]) }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("pre", { children: JSON.stringify(schema) })] }));
        }
        const Template = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('ObjectFieldTemplate', registry, uiOptions);
        const templateProps = {
            // getDisplayLabel() always returns false for object types, so just check the `uiOptions.label`
            title: uiOptions.label === false ? '' : templateTitle,
            description: uiOptions.label === false ? undefined : description,
            properties: orderedProperties.map((name) => {
                const addedByAdditionalProperties = lodash_has__WEBPACK_IMPORTED_MODULE_4___default()(schema, [_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY, name, _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ADDITIONAL_PROPERTY_FLAG]);
                const fieldUiSchema = addedByAdditionalProperties ? uiSchema.additionalProperties : uiSchema[name];
                const hidden = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(fieldUiSchema).widget === 'hidden';
                const fieldIdSchema = lodash_get__WEBPACK_IMPORTED_MODULE_3___default()(idSchema, [name], {});
                return {
                    content: ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(SchemaField, { name: name, required: this.isRequired(name), schema: lodash_get__WEBPACK_IMPORTED_MODULE_3___default()(schema, [_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY, name], {}), uiSchema: fieldUiSchema, errorSchema: lodash_get__WEBPACK_IMPORTED_MODULE_3___default()(errorSchema, name), idSchema: fieldIdSchema, idPrefix: idPrefix, idSeparator: idSeparator, formData: lodash_get__WEBPACK_IMPORTED_MODULE_3___default()(formData, name), formContext: formContext, wasPropertyKeyModified: this.state.wasPropertyKeyModified, onKeyChange: this.onKeyChange(name), onChange: this.onPropertyChange(name, addedByAdditionalProperties), onBlur: onBlur, onFocus: onFocus, registry: registry, disabled: disabled, readonly: readonly, hideError: hideError, onDropPropertyClick: this.onDropPropertyClick }, name)),
                    name,
                    readonly,
                    disabled,
                    required,
                    hidden,
                };
            }),
            readonly,
            disabled,
            required,
            idSchema,
            uiSchema,
            errorSchema,
            schema,
            formData,
            formContext,
            registry,
        };
        return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Template, { ...templateProps, onAddClick: this.handleAddClick });
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ObjectField);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/fields/SchemaField.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/fields/SchemaField.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/isObject */ "../../node_modules/lodash/isObject.js");
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_isObject__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/omit */ "../../node_modules/lodash/omit.js");
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_omit__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var markdown_to_jsx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! markdown-to-jsx */ "../../node_modules/markdown-to-jsx/dist/index.modern.js");






/** The map of component type to FieldName */
const COMPONENT_TYPES = {
    array: 'ArrayField',
    boolean: 'BooleanField',
    integer: 'NumberField',
    number: 'NumberField',
    object: 'ObjectField',
    string: 'StringField',
    null: 'NullField',
};
/** Computes and returns which `Field` implementation to return in order to render the field represented by the
 * `schema`. The `uiOptions` are used to alter what potential `Field` implementation is actually returned. If no
 * appropriate `Field` implementation can be found then a wrapper around `UnsupportedFieldTemplate` is used.
 *
 * @param schema - The schema from which to obtain the type
 * @param uiOptions - The UI Options that may affect the component decision
 * @param idSchema - The id that is passed to the `UnsupportedFieldTemplate`
 * @param registry - The registry from which fields and templates are obtained
 * @returns - The `Field` component that is used to render the actual field data
 */
function getFieldComponent(schema, uiOptions, idSchema, registry) {
    const field = uiOptions.field;
    const { fields, translateString } = registry;
    if (typeof field === 'function') {
        return field;
    }
    if (typeof field === 'string' && field in fields) {
        return fields[field];
    }
    const schemaType = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getSchemaType)(schema);
    const type = Array.isArray(schemaType) ? schemaType[0] : schemaType || '';
    const schemaId = schema.$id;
    let componentName = COMPONENT_TYPES[type];
    if (schemaId && schemaId in fields) {
        componentName = schemaId;
    }
    // If the type is not defined and the schema uses 'anyOf' or 'oneOf', don't
    // render a field and let the MultiSchemaField component handle the form display
    if (!componentName && (schema.anyOf || schema.oneOf)) {
        return () => null;
    }
    return componentName in fields
        ? fields[componentName]
        : () => {
            const UnsupportedFieldTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('UnsupportedFieldTemplate', registry, uiOptions);
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(UnsupportedFieldTemplate, { schema: schema, idSchema: idSchema, reason: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.UnknownFieldType, [String(schema.type)]), registry: registry }));
        };
}
/** The `SchemaFieldRender` component is the work-horse of react-jsonschema-form, determining what kind of real field to
 * render based on the `schema`, `uiSchema` and all the other props. It also deals with rendering the `anyOf` and
 * `oneOf` fields.
 *
 * @param props - The `FieldProps` for this component
 */
function SchemaFieldRender(props) {
    var _a, _b, _c;
    const { schema: _schema, idSchema: _idSchema, uiSchema, formData, errorSchema, idPrefix, idSeparator, name, onChange, onKeyChange, onDropPropertyClick, required, registry, wasPropertyKeyModified = false, } = props;
    const { formContext, schemaUtils, globalUiOptions } = registry;
    const uiOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getUiOptions)(uiSchema, globalUiOptions);
    const FieldTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('FieldTemplate', registry, uiOptions);
    const DescriptionFieldTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('DescriptionFieldTemplate', registry, uiOptions);
    const FieldHelpTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('FieldHelpTemplate', registry, uiOptions);
    const FieldErrorTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('FieldErrorTemplate', registry, uiOptions);
    const schema = schemaUtils.retrieveSchema(_schema, formData);
    const fieldId = _idSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ID_KEY];
    const idSchema = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.mergeObjects)(schemaUtils.toIdSchema(schema, fieldId, formData, idPrefix, idSeparator), _idSchema);
    /** Intermediary `onChange` handler for field components that will inject the `id` of the current field into the
     * `onChange` chain if it is not already being provided from a deeper level in the hierarchy
     */
    const handleFieldComponentChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((formData, newErrorSchema, id) => {
        const theId = id || fieldId;
        return onChange(formData, newErrorSchema, theId);
    }, [fieldId, onChange]);
    const FieldComponent = getFieldComponent(schema, uiOptions, idSchema, registry);
    const disabled = Boolean((_a = uiOptions.disabled) !== null && _a !== void 0 ? _a : props.disabled);
    const readonly = Boolean((_b = uiOptions.readonly) !== null && _b !== void 0 ? _b : (props.readonly || props.schema.readOnly || schema.readOnly));
    const uiSchemaHideError = uiOptions.hideError;
    // Set hideError to the value provided in the uiSchema, otherwise stick with the prop to propagate to children
    const hideError = uiSchemaHideError === undefined ? props.hideError : Boolean(uiSchemaHideError);
    const autofocus = Boolean((_c = uiOptions.autofocus) !== null && _c !== void 0 ? _c : props.autofocus);
    if (Object.keys(schema).length === 0) {
        return null;
    }
    const displayLabel = schemaUtils.getDisplayLabel(schema, uiSchema, globalUiOptions);
    const { __errors, ...fieldErrorSchema } = errorSchema || {};
    // See #439: uiSchema: Don't pass consumed class names or style to child components
    const fieldUiSchema = lodash_omit__WEBPACK_IMPORTED_MODULE_4___default()(uiSchema, ['ui:classNames', 'classNames', 'ui:style']);
    if (_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.UI_OPTIONS_KEY in fieldUiSchema) {
        fieldUiSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.UI_OPTIONS_KEY] = lodash_omit__WEBPACK_IMPORTED_MODULE_4___default()(fieldUiSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.UI_OPTIONS_KEY], ['classNames', 'style']);
    }
    const field = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(FieldComponent, { ...props, onChange: handleFieldComponentChange, idSchema: idSchema, schema: schema, uiSchema: fieldUiSchema, disabled: disabled, readonly: readonly, hideError: hideError, autofocus: autofocus, errorSchema: fieldErrorSchema, formContext: formContext, rawErrors: __errors }));
    const id = idSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ID_KEY];
    // If this schema has a title defined, but the user has set a new key/label, retain their input.
    let label;
    if (wasPropertyKeyModified) {
        label = name;
    }
    else {
        label =
            _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ADDITIONAL_PROPERTY_FLAG in schema
                ? name
                : uiOptions.title || props.schema.title || schema.title || props.title || name;
    }
    const description = uiOptions.description || props.schema.description || schema.description || '';
    const richDescription = uiOptions.enableMarkdownInDescription ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(markdown_to_jsx__WEBPACK_IMPORTED_MODULE_5__["default"], { options: { disableParsingRawHTML: true }, children: description })) : (description);
    const help = uiOptions.help;
    const hidden = uiOptions.widget === 'hidden';
    const classNames = ['form-group', 'field', `field-${(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getSchemaType)(schema)}`];
    if (!hideError && __errors && __errors.length > 0) {
        classNames.push('field-error has-error has-danger');
    }
    if (uiSchema === null || uiSchema === void 0 ? void 0 : uiSchema.classNames) {
        if (true) {
            console.warn("'uiSchema.classNames' is deprecated and may be removed in a major release; Use 'ui:classNames' instead.");
        }
        classNames.push(uiSchema.classNames);
    }
    if (uiOptions.classNames) {
        classNames.push(uiOptions.classNames);
    }
    const helpComponent = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(FieldHelpTemplate, { help: help, idSchema: idSchema, schema: schema, uiSchema: uiSchema, hasErrors: !hideError && __errors && __errors.length > 0, registry: registry }));
    /*
     * AnyOf/OneOf errors handled by child schema
     * unless it can be rendered as select control
     */
    const errorsComponent = hideError || ((schema.anyOf || schema.oneOf) && !schemaUtils.isSelect(schema)) ? undefined : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(FieldErrorTemplate, { errors: __errors, errorSchema: errorSchema, idSchema: idSchema, schema: schema, uiSchema: uiSchema, registry: registry }));
    const fieldProps = {
        description: ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DescriptionFieldTemplate, { id: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.descriptionId)(id), description: richDescription, schema: schema, uiSchema: uiSchema, registry: registry })),
        rawDescription: description,
        help: helpComponent,
        rawHelp: typeof help === 'string' ? help : undefined,
        errors: errorsComponent,
        rawErrors: hideError ? undefined : __errors,
        id,
        label,
        hidden,
        onChange,
        onKeyChange,
        onDropPropertyClick,
        required,
        disabled,
        readonly,
        hideError,
        displayLabel,
        classNames: classNames.join(' ').trim(),
        style: uiOptions.style,
        formContext,
        formData,
        schema,
        uiSchema,
        registry,
    };
    const _AnyOfField = registry.fields.AnyOfField;
    const _OneOfField = registry.fields.OneOfField;
    const isReplacingAnyOrOneOf = (uiSchema === null || uiSchema === void 0 ? void 0 : uiSchema['ui:field']) && (uiSchema === null || uiSchema === void 0 ? void 0 : uiSchema['ui:fieldReplacesAnyOrOneOf']) === true;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(FieldTemplate, { ...fieldProps, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [field, schema.anyOf && !isReplacingAnyOrOneOf && !schemaUtils.isSelect(schema) && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_AnyOfField, { name: name, disabled: disabled, readonly: readonly, hideError: hideError, errorSchema: errorSchema, formData: formData, formContext: formContext, idPrefix: idPrefix, idSchema: idSchema, idSeparator: idSeparator, onBlur: props.onBlur, onChange: props.onChange, onFocus: props.onFocus, options: schema.anyOf.map((_schema) => schemaUtils.retrieveSchema(lodash_isObject__WEBPACK_IMPORTED_MODULE_3___default()(_schema) ? _schema : {}, formData)), registry: registry, schema: schema, uiSchema: uiSchema })), schema.oneOf && !isReplacingAnyOrOneOf && !schemaUtils.isSelect(schema) && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_OneOfField, { name: name, disabled: disabled, readonly: readonly, hideError: hideError, errorSchema: errorSchema, formData: formData, formContext: formContext, idPrefix: idPrefix, idSchema: idSchema, idSeparator: idSeparator, onBlur: props.onBlur, onChange: props.onChange, onFocus: props.onFocus, options: schema.oneOf.map((_schema) => schemaUtils.retrieveSchema(lodash_isObject__WEBPACK_IMPORTED_MODULE_3___default()(_schema) ? _schema : {}, formData)), registry: registry, schema: schema, uiSchema: uiSchema }))] }) }));
}
/** The `SchemaField` component determines whether it is necessary to rerender the component based on any props changes
 * and if so, calls the `SchemaFieldRender` component with the props.
 */
class SchemaField extends react__WEBPACK_IMPORTED_MODULE_1__.Component {
    shouldComponentUpdate(nextProps) {
        return !(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.deepEquals)(this.props, nextProps);
    }
    render() {
        return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(SchemaFieldRender, { ...this.props });
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SchemaField);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/fields/StringField.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/fields/StringField.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");


/** The `StringField` component is used to render a schema field that represents a string type
 *
 * @param props - The `FieldProps` for this template
 */
function StringField(props) {
    var _a;
    const { schema, name, uiSchema, idSchema, formData, required, disabled = false, readonly = false, autofocus = false, onChange, onBlur, onFocus, registry, rawErrors, hideError, } = props;
    const { title, format } = schema;
    const { widgets, formContext, schemaUtils, globalUiOptions } = registry;
    const enumOptions = schemaUtils.isSelect(schema) ? (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.optionsList)(schema, uiSchema) : undefined;
    let defaultWidget = enumOptions ? 'select' : 'text';
    if (format && (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.hasWidget)(schema, format, widgets)) {
        defaultWidget = format;
    }
    const { widget = defaultWidget, placeholder = '', title: uiTitle, ...options } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getUiOptions)(uiSchema);
    const displayLabel = schemaUtils.getDisplayLabel(schema, uiSchema, globalUiOptions);
    const label = (_a = uiTitle !== null && uiTitle !== void 0 ? uiTitle : title) !== null && _a !== void 0 ? _a : name;
    const Widget = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getWidget)(schema, widget, widgets);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(Widget, { options: { ...options, enumOptions }, schema: schema, uiSchema: uiSchema, id: idSchema.$id, name: name, label: label, hideLabel: !displayLabel, hideError: hideError, value: formData, onChange: onChange, onBlur: onBlur, onFocus: onFocus, required: required, disabled: disabled, readonly: readonly, formContext: formContext, autofocus: autofocus, registry: registry, placeholder: placeholder, rawErrors: rawErrors }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StringField);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/fields/index.js":
/*!********************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/fields/index.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ArrayField__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ArrayField */ "../../node_modules/@rjsf/core/lib/components/fields/ArrayField.js");
/* harmony import */ var _BooleanField__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BooleanField */ "../../node_modules/@rjsf/core/lib/components/fields/BooleanField.js");
/* harmony import */ var _MultiSchemaField__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./MultiSchemaField */ "../../node_modules/@rjsf/core/lib/components/fields/MultiSchemaField.js");
/* harmony import */ var _NumberField__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./NumberField */ "../../node_modules/@rjsf/core/lib/components/fields/NumberField.js");
/* harmony import */ var _ObjectField__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ObjectField */ "../../node_modules/@rjsf/core/lib/components/fields/ObjectField.js");
/* harmony import */ var _SchemaField__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SchemaField */ "../../node_modules/@rjsf/core/lib/components/fields/SchemaField.js");
/* harmony import */ var _StringField__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./StringField */ "../../node_modules/@rjsf/core/lib/components/fields/StringField.js");
/* harmony import */ var _NullField__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./NullField */ "../../node_modules/@rjsf/core/lib/components/fields/NullField.js");








function fields() {
    return {
        AnyOfField: _MultiSchemaField__WEBPACK_IMPORTED_MODULE_2__["default"],
        ArrayField: _ArrayField__WEBPACK_IMPORTED_MODULE_0__["default"],
        // ArrayField falls back to SchemaField if ArraySchemaField is not defined, which it isn't by default
        BooleanField: _BooleanField__WEBPACK_IMPORTED_MODULE_1__["default"],
        NumberField: _NumberField__WEBPACK_IMPORTED_MODULE_3__["default"],
        ObjectField: _ObjectField__WEBPACK_IMPORTED_MODULE_4__["default"],
        OneOfField: _MultiSchemaField__WEBPACK_IMPORTED_MODULE_2__["default"],
        SchemaField: _SchemaField__WEBPACK_IMPORTED_MODULE_5__["default"],
        StringField: _StringField__WEBPACK_IMPORTED_MODULE_6__["default"],
        NullField: _NullField__WEBPACK_IMPORTED_MODULE_7__["default"],
    };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (fields);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldDescriptionTemplate.js":
/*!***********************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldDescriptionTemplate.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ArrayFieldDescriptionTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");


/** The `ArrayFieldDescriptionTemplate` component renders a `DescriptionFieldTemplate` with an `id` derived from
 * the `idSchema`.
 *
 * @param props - The `ArrayFieldDescriptionProps` for the component
 */
function ArrayFieldDescriptionTemplate(props) {
    const { idSchema, description, registry, schema, uiSchema } = props;
    const options = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getUiOptions)(uiSchema, registry.globalUiOptions);
    const { label: displayLabel = true } = options;
    if (!description || !displayLabel) {
        return null;
    }
    const DescriptionFieldTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('DescriptionFieldTemplate', registry, options);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DescriptionFieldTemplate, { id: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.descriptionId)(idSchema), description: description, schema: schema, uiSchema: uiSchema, registry: registry }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldItemTemplate.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldItemTemplate.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ArrayFieldItemTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");

/** The `ArrayFieldItemTemplate` component is the template used to render an items of an array.
 *
 * @param props - The `ArrayFieldTemplateItemType` props for the component
 */
function ArrayFieldItemTemplate(props) {
    const { children, className, disabled, hasToolbar, hasMoveDown, hasMoveUp, hasRemove, hasCopy, index, onCopyIndexClick, onDropIndexClick, onReorderClick, readonly, registry, uiSchema, } = props;
    const { CopyButton, MoveDownButton, MoveUpButton, RemoveButton } = registry.templates.ButtonTemplates;
    const btnStyle = {
        flex: 1,
        paddingLeft: 6,
        paddingRight: 6,
        fontWeight: 'bold',
    };
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: className, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: hasToolbar ? 'col-xs-9' : 'col-xs-12', children: children }), hasToolbar && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs-3 array-item-toolbox', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'btn-group', style: {
                        display: 'flex',
                        justifyContent: 'space-around',
                    }, children: [(hasMoveUp || hasMoveDown) && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(MoveUpButton, { style: btnStyle, disabled: disabled || readonly || !hasMoveUp, onClick: onReorderClick(index, index - 1), uiSchema: uiSchema, registry: registry })), (hasMoveUp || hasMoveDown) && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(MoveDownButton, { style: btnStyle, disabled: disabled || readonly || !hasMoveDown, onClick: onReorderClick(index, index + 1), uiSchema: uiSchema, registry: registry })), hasCopy && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(CopyButton, { style: btnStyle, disabled: disabled || readonly, onClick: onCopyIndexClick(index), uiSchema: uiSchema, registry: registry })), hasRemove && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(RemoveButton, { style: btnStyle, disabled: disabled || readonly, onClick: onDropIndexClick(index), uiSchema: uiSchema, registry: registry }))] }) }))] }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldTemplate.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldTemplate.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ArrayFieldTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");


/** The `ArrayFieldTemplate` component is the template used to render all items in an array.
 *
 * @param props - The `ArrayFieldTemplateItemType` props for the component
 */
function ArrayFieldTemplate(props) {
    const { canAdd, className, disabled, idSchema, uiSchema, items, onAddClick, readonly, registry, required, schema, title, } = props;
    const uiOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getUiOptions)(uiSchema);
    const ArrayFieldDescriptionTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('ArrayFieldDescriptionTemplate', registry, uiOptions);
    const ArrayFieldItemTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('ArrayFieldItemTemplate', registry, uiOptions);
    const ArrayFieldTitleTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('ArrayFieldTitleTemplate', registry, uiOptions);
    // Button templates are not overridden in the uiSchema
    const { ButtonTemplates: { AddButton }, } = registry.templates;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("fieldset", { className: className, id: idSchema.$id, children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ArrayFieldTitleTemplate, { idSchema: idSchema, title: uiOptions.title || title, required: required, schema: schema, uiSchema: uiSchema, registry: registry }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ArrayFieldDescriptionTemplate, { idSchema: idSchema, description: uiOptions.description || schema.description, schema: schema, uiSchema: uiSchema, registry: registry }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'row array-item-list', children: items &&
                    items.map(({ key, ...itemProps }) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(ArrayFieldItemTemplate, { ...itemProps }, key))) }), canAdd && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(AddButton, { className: 'array-item-add', onClick: onAddClick, disabled: disabled || readonly, uiSchema: uiSchema, registry: registry }))] }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldTitleTemplate.js":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldTitleTemplate.js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ArrayFieldTitleTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");


/** The `ArrayFieldTitleTemplate` component renders a `TitleFieldTemplate` with an `id` derived from
 * the `idSchema`.
 *
 * @param props - The `ArrayFieldTitleProps` for the component
 */
function ArrayFieldTitleTemplate(props) {
    const { idSchema, title, schema, uiSchema, required, registry } = props;
    const options = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getUiOptions)(uiSchema, registry.globalUiOptions);
    const { label: displayLabel = true } = options;
    if (!title || !displayLabel) {
        return null;
    }
    const TitleFieldTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('TitleFieldTemplate', registry, options);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(TitleFieldTemplate, { id: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.titleId)(idSchema), title: title, required: required, schema: schema, uiSchema: uiSchema, registry: registry }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/BaseInputTemplate.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/BaseInputTemplate.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ BaseInputTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");



/** The `BaseInputTemplate` is the template to use to render the basic `<input>` component for the `core` theme.
 * It is used as the template for rendering many of the <input> based widgets that differ by `type` and callbacks only.
 * It can be customized/overridden for other themes or individual implementations as needed.
 *
 * @param props - The `WidgetProps` for this template
 */
function BaseInputTemplate(props) {
    const { id, name, // remove this from ...rest
    value, readonly, disabled, autofocus, onBlur, onFocus, onChange, onChangeOverride, options, schema, uiSchema, formContext, registry, rawErrors, type, hideLabel, // remove this from ...rest
    hideError, // remove this from ...rest
    ...rest } = props;
    // Note: since React 15.2.0 we can't forward unknown element attributes, so we
    // exclude the "options" and "schema" ones here.
    if (!id) {
        console.log('No id for', props);
        throw new Error(`no id for props ${JSON.stringify(props)}`);
    }
    const inputProps = {
        ...rest,
        ...(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getInputProps)(schema, type, options),
    };
    let inputValue;
    if (inputProps.type === 'number' || inputProps.type === 'integer') {
        inputValue = value || value === 0 ? value : '';
    }
    else {
        inputValue = value == null ? '' : value;
    }
    const _onChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target: { value } }) => onChange(value === '' ? options.emptyValue : value), [onChange, options]);
    const _onBlur = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target }) => onBlur(id, target && target.value), [onBlur, id]);
    const _onFocus = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target }) => onFocus(id, target && target.value), [onFocus, id]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", { id: id, name: id, className: 'form-control', readOnly: readonly, disabled: disabled, autoFocus: autofocus, value: inputValue, ...inputProps, list: schema.examples ? (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.examplesId)(id) : undefined, onChange: onChangeOverride || _onChange, onBlur: _onBlur, onFocus: _onFocus, "aria-describedby": (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ariaDescribedByIds)(id, !!schema.examples) }), Array.isArray(schema.examples) && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("datalist", { id: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.examplesId)(id), children: schema.examples
                    .concat(schema.default && !schema.examples.includes(schema.default) ? [schema.default] : [])
                    .map((example) => {
                    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("option", { value: example }, example);
                }) }, `datalist_${id}`))] }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/AddButton.js":
/*!*******************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/AddButton.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AddButton)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");
/* harmony import */ var _IconButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./IconButton */ "../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/IconButton.js");



/** The `AddButton` renders a button that represent the `Add` action on a form
 */
function AddButton({ className, onClick, disabled, registry, }) {
    const { translateString } = registry;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'row', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", { className: `col-xs-3 col-xs-offset-9 text-right ${className}`, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_IconButton__WEBPACK_IMPORTED_MODULE_2__["default"], { iconType: 'info', icon: 'plus', className: 'btn-add col-xs-12', title: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.AddButton), onClick: onClick, disabled: disabled, registry: registry }) }) }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/IconButton.js":
/*!********************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/IconButton.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CopyButton: () => (/* binding */ CopyButton),
/* harmony export */   MoveDownButton: () => (/* binding */ MoveDownButton),
/* harmony export */   MoveUpButton: () => (/* binding */ MoveUpButton),
/* harmony export */   RemoveButton: () => (/* binding */ RemoveButton),
/* harmony export */   "default": () => (/* binding */ IconButton)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");


function IconButton(props) {
    const { iconType = 'default', icon, className, uiSchema, registry, ...otherProps } = props;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("button", { type: 'button', className: `btn btn-${iconType} ${className}`, ...otherProps, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("i", { className: `glyphicon glyphicon-${icon}` }) }));
}
function CopyButton(props) {
    const { registry: { translateString }, } = props;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(IconButton, { title: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.CopyButton), className: 'array-item-copy', ...props, icon: 'copy' }));
}
function MoveDownButton(props) {
    const { registry: { translateString }, } = props;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(IconButton, { title: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.MoveDownButton), className: 'array-item-move-down', ...props, icon: 'arrow-down' }));
}
function MoveUpButton(props) {
    const { registry: { translateString }, } = props;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(IconButton, { title: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.MoveUpButton), className: 'array-item-move-up', ...props, icon: 'arrow-up' }));
}
function RemoveButton(props) {
    const { registry: { translateString }, } = props;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(IconButton, { title: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.RemoveButton), className: 'array-item-remove', ...props, iconType: 'danger', icon: 'remove' }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/SubmitButton.js":
/*!**********************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/SubmitButton.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SubmitButton)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");


/** The `SubmitButton` renders a button that represent the `Submit` action on a form
 */
function SubmitButton({ uiSchema }) {
    const { submitText, norender, props: submitButtonProps = {} } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getSubmitButtonOptions)(uiSchema);
    if (norender) {
        return null;
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("button", { type: 'submit', ...submitButtonProps, className: `btn btn-info ${submitButtonProps.className || ''}`, children: submitText }) }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/index.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/index.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _SubmitButton__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SubmitButton */ "../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/SubmitButton.js");
/* harmony import */ var _AddButton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AddButton */ "../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/AddButton.js");
/* harmony import */ var _IconButton__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./IconButton */ "../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/IconButton.js");



function buttonTemplates() {
    return {
        SubmitButton: _SubmitButton__WEBPACK_IMPORTED_MODULE_0__["default"],
        AddButton: _AddButton__WEBPACK_IMPORTED_MODULE_1__["default"],
        CopyButton: _IconButton__WEBPACK_IMPORTED_MODULE_2__.CopyButton,
        MoveDownButton: _IconButton__WEBPACK_IMPORTED_MODULE_2__.MoveDownButton,
        MoveUpButton: _IconButton__WEBPACK_IMPORTED_MODULE_2__.MoveUpButton,
        RemoveButton: _IconButton__WEBPACK_IMPORTED_MODULE_2__.RemoveButton,
    };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (buttonTemplates);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/DescriptionField.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/DescriptionField.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DescriptionField)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");

/** The `DescriptionField` is the template to use to render the description of a field
 *
 * @param props - The `DescriptionFieldProps` for this component
 */
function DescriptionField(props) {
    const { id, description } = props;
    if (!description) {
        return null;
    }
    if (typeof description === 'string') {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", { id: id, className: 'field-description', children: description }));
    }
    else {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { id: id, className: 'field-description', children: description }));
    }
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ErrorList.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ErrorList.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ErrorList)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");


/** The `ErrorList` component is the template that renders the all the errors associated with the fields in the `Form`
 *
 * @param props - The `ErrorListProps` for this component
 */
function ErrorList({ errors, registry, }) {
    const { translateString } = registry;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'panel panel-danger errors', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'panel-heading', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h3", { className: 'panel-title', children: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.ErrorsLabel) }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("ul", { className: 'list-group', children: errors.map((error, i) => {
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { className: 'list-group-item text-danger', children: error.stack }, i));
                }) })] }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/FieldErrorTemplate.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/FieldErrorTemplate.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FieldErrorTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");


/** The `FieldErrorTemplate` component renders the errors local to the particular field
 *
 * @param props - The `FieldErrorProps` for the errors being rendered
 */
function FieldErrorTemplate(props) {
    const { errors = [], idSchema } = props;
    if (errors.length === 0) {
        return null;
    }
    const id = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.errorId)(idSchema);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("ul", { id: id, className: 'error-detail bs-callout bs-callout-info', children: errors
                .filter((elem) => !!elem)
                .map((error, index) => {
                return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { className: 'text-danger', children: error }, index));
            }) }) }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/FieldHelpTemplate.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/FieldHelpTemplate.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FieldHelpTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");


/** The `FieldHelpTemplate` component renders any help desired for a field
 *
 * @param props - The `FieldHelpProps` to be rendered
 */
function FieldHelpTemplate(props) {
    const { idSchema, help } = props;
    if (!help) {
        return null;
    }
    const id = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.helpId)(idSchema);
    if (typeof help === 'string') {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", { id: id, className: 'help-block', children: help }));
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { id: id, className: 'help-block', children: help }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/FieldTemplate.js":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/FieldTemplate.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FieldTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");
/* harmony import */ var _Label__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Label */ "../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/Label.js");



/** The `FieldTemplate` component is the template used by `SchemaField` to render any field. It renders the field
 * content, (label, description, children, errors and help) inside of a `WrapIfAdditional` component.
 *
 * @param props - The `FieldTemplateProps` for this component
 */
function FieldTemplate(props) {
    const { id, label, children, errors, help, description, hidden, required, displayLabel, registry, uiSchema } = props;
    const uiOptions = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getUiOptions)(uiSchema);
    const WrapIfAdditionalTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('WrapIfAdditionalTemplate', registry, uiOptions);
    if (hidden) {
        return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'hidden', children: children });
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(WrapIfAdditionalTemplate, { ...props, children: [displayLabel && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_Label__WEBPACK_IMPORTED_MODULE_2__["default"], { label: label, required: required, id: id }), displayLabel && description ? description : null, children, errors, help] }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/Label.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/Label.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Label)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");

const REQUIRED_FIELD_SYMBOL = '*';
/** Renders a label for a field
 *
 * @param props - The `LabelProps` for this component
 */
function Label(props) {
    const { label, required, id } = props;
    if (!label) {
        return null;
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("label", { className: 'control-label', htmlFor: id, children: [label, required && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'required', children: REQUIRED_FIELD_SYMBOL })] }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/index.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/index.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _FieldTemplate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FieldTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/FieldTemplate.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_FieldTemplate__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/ObjectFieldTemplate.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/ObjectFieldTemplate.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ObjectFieldTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");


/** The `ObjectFieldTemplate` is the template to use to render all the inner properties of an object along with the
 * title and description if available. If the object is expandable, then an `AddButton` is also rendered after all
 * the properties.
 *
 * @param props - The `ObjectFieldTemplateProps` for this component
 */
function ObjectFieldTemplate(props) {
    const { description, disabled, formData, idSchema, onAddClick, properties, readonly, registry, required, schema, title, uiSchema, } = props;
    const options = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getUiOptions)(uiSchema);
    const TitleFieldTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('TitleFieldTemplate', registry, options);
    const DescriptionFieldTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('DescriptionFieldTemplate', registry, options);
    // Button templates are not overridden in the uiSchema
    const { ButtonTemplates: { AddButton }, } = registry.templates;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("fieldset", { id: idSchema.$id, children: [title && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(TitleFieldTemplate, { id: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.titleId)(idSchema), title: title, required: required, schema: schema, uiSchema: uiSchema, registry: registry })), description && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DescriptionFieldTemplate, { id: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.descriptionId)(idSchema), description: description, schema: schema, uiSchema: uiSchema, registry: registry })), properties.map((prop) => prop.content), (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.canExpand)(schema, uiSchema, formData) && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(AddButton, { className: 'object-property-expand', onClick: onAddClick(schema), disabled: disabled || readonly, uiSchema: uiSchema, registry: registry }))] }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/TitleField.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/TitleField.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TitleField)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");

const REQUIRED_FIELD_SYMBOL = '*';
/** The `TitleField` is the template to use to render the title of a field
 *
 * @param props - The `TitleFieldProps` for this component
 */
function TitleField(props) {
    const { id, title, required } = props;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("legend", { id: id, children: [title, required && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'required', children: REQUIRED_FIELD_SYMBOL })] }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/UnsupportedField.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/UnsupportedField.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");
/* harmony import */ var markdown_to_jsx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! markdown-to-jsx */ "../../node_modules/markdown-to-jsx/dist/index.modern.js");



/** The `UnsupportedField` component is used to render a field in the schema is one that is not supported by
 * react-jsonschema-form.
 *
 * @param props - The `FieldProps` for this template
 */
function UnsupportedField(props) {
    const { schema, idSchema, reason, registry } = props;
    const { translateString } = registry;
    let translateEnum = _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.UnsupportedField;
    const translateParams = [];
    if (idSchema && idSchema.$id) {
        translateEnum = _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.UnsupportedFieldWithId;
        translateParams.push(idSchema.$id);
    }
    if (reason) {
        translateEnum =
            translateEnum === _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.UnsupportedField
                ? _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.UnsupportedFieldWithReason
                : _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.UnsupportedFieldWithIdAndReason;
        translateParams.push(reason);
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'unsupported-field', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("p", { children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(markdown_to_jsx__WEBPACK_IMPORTED_MODULE_2__["default"], { options: { disableParsingRawHTML: true }, children: translateString(translateEnum, translateParams) }) }), schema && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("pre", { children: JSON.stringify(schema, null, 2) })] }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UnsupportedField);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/WrapIfAdditionalTemplate.js":
/*!******************************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/WrapIfAdditionalTemplate.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ WrapIfAdditionalTemplate)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");
/* harmony import */ var _FieldTemplate_Label__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FieldTemplate/Label */ "../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/Label.js");



/** The `WrapIfAdditional` component is used by the `FieldTemplate` to rename, or remove properties that are
 * part of an `additionalProperties` part of a schema.
 *
 * @param props - The `WrapIfAdditionalProps` for this component
 */
function WrapIfAdditionalTemplate(props) {
    const { id, classNames, style, disabled, label, onKeyChange, onDropPropertyClick, readonly, required, schema, children, uiSchema, registry, } = props;
    const { templates, translateString } = registry;
    // Button templates are not overridden in the uiSchema
    const { RemoveButton } = templates.ButtonTemplates;
    const keyLabel = translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.TranslatableString.KeyLabel, [label]);
    const additional = _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.ADDITIONAL_PROPERTY_FLAG in schema;
    if (!additional) {
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classNames, style: style, children: children }));
    }
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: classNames, style: style, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'row', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs-5 form-additional', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'form-group', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_FieldTemplate_Label__WEBPACK_IMPORTED_MODULE_2__["default"], { label: keyLabel, required: required, id: `${id}-key` }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", { className: 'form-control', type: 'text', id: `${id}-key`, onBlur: ({ target }) => onKeyChange(target && target.value), defaultValue: label })] }) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'form-additional form-group col-xs-5', children: children }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'col-xs-2', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(RemoveButton, { className: 'array-item-remove btn-block', style: { border: '0' }, disabled: disabled || readonly, onClick: onDropPropertyClick(label), uiSchema: uiSchema, registry: registry }) })] }) }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/templates/index.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/templates/index.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ArrayFieldDescriptionTemplate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ArrayFieldDescriptionTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldDescriptionTemplate.js");
/* harmony import */ var _ArrayFieldItemTemplate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ArrayFieldItemTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldItemTemplate.js");
/* harmony import */ var _ArrayFieldTemplate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ArrayFieldTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldTemplate.js");
/* harmony import */ var _ArrayFieldTitleTemplate__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ArrayFieldTitleTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/ArrayFieldTitleTemplate.js");
/* harmony import */ var _BaseInputTemplate__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./BaseInputTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/BaseInputTemplate.js");
/* harmony import */ var _ButtonTemplates__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ButtonTemplates */ "../../node_modules/@rjsf/core/lib/components/templates/ButtonTemplates/index.js");
/* harmony import */ var _DescriptionField__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./DescriptionField */ "../../node_modules/@rjsf/core/lib/components/templates/DescriptionField.js");
/* harmony import */ var _ErrorList__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./ErrorList */ "../../node_modules/@rjsf/core/lib/components/templates/ErrorList.js");
/* harmony import */ var _FieldTemplate__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./FieldTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/FieldTemplate/index.js");
/* harmony import */ var _FieldErrorTemplate__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./FieldErrorTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/FieldErrorTemplate.js");
/* harmony import */ var _FieldHelpTemplate__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./FieldHelpTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/FieldHelpTemplate.js");
/* harmony import */ var _ObjectFieldTemplate__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./ObjectFieldTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/ObjectFieldTemplate.js");
/* harmony import */ var _TitleField__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./TitleField */ "../../node_modules/@rjsf/core/lib/components/templates/TitleField.js");
/* harmony import */ var _UnsupportedField__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./UnsupportedField */ "../../node_modules/@rjsf/core/lib/components/templates/UnsupportedField.js");
/* harmony import */ var _WrapIfAdditionalTemplate__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./WrapIfAdditionalTemplate */ "../../node_modules/@rjsf/core/lib/components/templates/WrapIfAdditionalTemplate.js");















function templates() {
    return {
        ArrayFieldDescriptionTemplate: _ArrayFieldDescriptionTemplate__WEBPACK_IMPORTED_MODULE_0__["default"],
        ArrayFieldItemTemplate: _ArrayFieldItemTemplate__WEBPACK_IMPORTED_MODULE_1__["default"],
        ArrayFieldTemplate: _ArrayFieldTemplate__WEBPACK_IMPORTED_MODULE_2__["default"],
        ArrayFieldTitleTemplate: _ArrayFieldTitleTemplate__WEBPACK_IMPORTED_MODULE_3__["default"],
        ButtonTemplates: (0,_ButtonTemplates__WEBPACK_IMPORTED_MODULE_5__["default"])(),
        BaseInputTemplate: _BaseInputTemplate__WEBPACK_IMPORTED_MODULE_4__["default"],
        DescriptionFieldTemplate: _DescriptionField__WEBPACK_IMPORTED_MODULE_6__["default"],
        ErrorListTemplate: _ErrorList__WEBPACK_IMPORTED_MODULE_7__["default"],
        FieldTemplate: _FieldTemplate__WEBPACK_IMPORTED_MODULE_8__["default"],
        FieldErrorTemplate: _FieldErrorTemplate__WEBPACK_IMPORTED_MODULE_9__["default"],
        FieldHelpTemplate: _FieldHelpTemplate__WEBPACK_IMPORTED_MODULE_10__["default"],
        ObjectFieldTemplate: _ObjectFieldTemplate__WEBPACK_IMPORTED_MODULE_11__["default"],
        TitleFieldTemplate: _TitleField__WEBPACK_IMPORTED_MODULE_12__["default"],
        UnsupportedFieldTemplate: _UnsupportedField__WEBPACK_IMPORTED_MODULE_13__["default"],
        WrapIfAdditionalTemplate: _WrapIfAdditionalTemplate__WEBPACK_IMPORTED_MODULE_14__["default"],
    };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (templates);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/AltDateTimeWidget.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/AltDateTimeWidget.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");

/** The `AltDateTimeWidget` is an alternative widget for rendering datetime properties.
 *  It uses the AltDateWidget for rendering, with the `time` prop set to true by default.
 *
 * @param props - The `WidgetProps` for this component
 */
function AltDateTimeWidget({ time = true, ...props }) {
    const { AltDateWidget } = props.registry.widgets;
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(AltDateWidget, { time: time, ...props });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AltDateTimeWidget);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/AltDateWidget.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/AltDateWidget.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");



function readyForChange(state) {
    return Object.values(state).every((value) => value !== -1);
}
function DateElement({ type, range, value, select, rootId, name, disabled, readonly, autofocus, registry, onBlur, onFocus, }) {
    const id = rootId + '_' + type;
    const { SelectWidget } = registry.widgets;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(SelectWidget, { schema: { type: 'integer' }, id: id, name: name, className: 'form-control', options: { enumOptions: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.dateRangeOptions)(range[0], range[1]) }, placeholder: type, value: value, disabled: disabled, readonly: readonly, autofocus: autofocus, onChange: (value) => select(type, value), onBlur: onBlur, onFocus: onFocus, registry: registry, label: '', "aria-describedby": (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ariaDescribedByIds)(rootId) }));
}
/** The `AltDateWidget` is an alternative widget for rendering date properties.
 * @param props - The `WidgetProps` for this component
 */
function AltDateWidget({ time = false, disabled = false, readonly = false, autofocus = false, options, id, name, registry, onBlur, onFocus, onChange, value, }) {
    const { translateString } = registry;
    const [lastValue, setLastValue] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useState)(value);
    const [state, setState] = (0,react__WEBPACK_IMPORTED_MODULE_1__.useReducer)((state, action) => {
        return { ...state, ...action };
    }, (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.parseDateString)(value, time));
    (0,react__WEBPACK_IMPORTED_MODULE_1__.useEffect)(() => {
        const stateValue = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.toDateString)(state, time);
        if (readyForChange(state) && stateValue !== value) {
            // The user changed the date to a new valid data via the comboboxes, so call onChange
            onChange(stateValue);
        }
        else if (lastValue !== value) {
            // We got a new value in the props
            setLastValue(value);
            setState((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.parseDateString)(value, time));
        }
    }, [time, value, onChange, state, lastValue]);
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((property, value) => {
        setState({ [property]: value });
    }, []);
    const handleSetNow = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => {
        event.preventDefault();
        if (disabled || readonly) {
            return;
        }
        const nextState = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.parseDateString)(new Date().toJSON(), time);
        onChange((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.toDateString)(nextState, time));
    }, [disabled, readonly, time]);
    const handleClear = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => {
        event.preventDefault();
        if (disabled || readonly) {
            return;
        }
        onChange(undefined);
    }, [disabled, readonly, onChange]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("ul", { className: 'list-inline', children: [(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getDateElementProps)(state, time, options.yearsRange, options.format).map((elemProps, i) => ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { className: 'list-inline-item', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DateElement, { rootId: id, name: name, select: handleChange, ...elemProps, disabled: disabled, readonly: readonly, registry: registry, onBlur: onBlur, onFocus: onFocus, autofocus: autofocus && i === 0 }) }, i))), (options.hideNowButton !== 'undefined' ? !options.hideNowButton : true) && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { className: 'list-inline-item', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { href: '#', className: 'btn btn-info btn-now', onClick: handleSetNow, children: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.NowLabel) }) })), (options.hideClearButton !== 'undefined' ? !options.hideClearButton : true) && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("li", { className: 'list-inline-item', children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { href: '#', className: 'btn btn-warning btn-clear', onClick: handleClear, children: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.ClearLabel) }) }))] }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AltDateWidget);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/CheckboxWidget.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/CheckboxWidget.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");



/** The `CheckBoxWidget` is a widget for rendering boolean properties.
 *  It is typically used to represent a boolean.
 *
 * @param props - The `WidgetProps` for this component
 */
function CheckboxWidget({ schema, uiSchema, options, id, value, disabled, readonly, label, hideLabel, autofocus = false, onBlur, onFocus, onChange, registry, }) {
    var _a;
    const DescriptionFieldTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('DescriptionFieldTemplate', registry, options);
    // Because an unchecked checkbox will cause html5 validation to fail, only add
    // the "required" attribute if the field value must be "true", due to the
    // "const" or "enum" keywords
    const required = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.schemaRequiresTrueValue)(schema);
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => onChange(event.target.checked), [onChange]);
    const handleBlur = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => onBlur(id, event.target.checked), [onBlur, id]);
    const handleFocus = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => onFocus(id, event.target.checked), [onFocus, id]);
    const description = (_a = options.description) !== null && _a !== void 0 ? _a : schema.description;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: `checkbox ${disabled || readonly ? 'disabled' : ''}`, children: [!hideLabel && !!description && ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(DescriptionFieldTemplate, { id: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.descriptionId)(id), description: description, schema: schema, uiSchema: uiSchema, registry: registry })), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("label", { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", { type: 'checkbox', id: id, name: id, checked: typeof value === 'undefined' ? false : value, required: required, disabled: disabled || readonly, autoFocus: autofocus, onChange: handleChange, onBlur: handleBlur, onFocus: handleFocus, "aria-describedby": (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ariaDescribedByIds)(id) }), (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.labelValue)((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { children: label }), hideLabel)] })] }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CheckboxWidget);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/CheckboxesWidget.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/CheckboxesWidget.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");



/** The `CheckboxesWidget` is a widget for rendering checkbox groups.
 *  It is typically used to represent an array of enums.
 *
 * @param props - The `WidgetProps` for this component
 */
function CheckboxesWidget({ id, disabled, options: { inline = false, enumOptions, enumDisabled, emptyValue }, value, autofocus = false, readonly, onChange, onBlur, onFocus, }) {
    const checkboxesValues = Array.isArray(value) ? value : [value];
    const handleBlur = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target }) => onBlur(id, (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsValueForIndex)(target && target.value, enumOptions, emptyValue)), [onBlur, id]);
    const handleFocus = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target }) => onFocus(id, (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsValueForIndex)(target && target.value, enumOptions, emptyValue)), [onFocus, id]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'checkboxes', id: id, children: Array.isArray(enumOptions) &&
            enumOptions.map((option, index) => {
                const checked = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsIsSelected)(option.value, checkboxesValues);
                const itemDisabled = Array.isArray(enumDisabled) && enumDisabled.indexOf(option.value) !== -1;
                const disabledCls = disabled || itemDisabled || readonly ? 'disabled' : '';
                const handleChange = (event) => {
                    if (event.target.checked) {
                        onChange((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsSelectValue)(index, checkboxesValues, enumOptions));
                    }
                    else {
                        onChange((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsDeselectValue)(index, checkboxesValues, enumOptions));
                    }
                };
                const checkbox = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", { type: 'checkbox', id: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.optionId)(id, index), name: id, checked: checked, value: String(index), disabled: disabled || itemDisabled || readonly, autoFocus: autofocus && index === 0, onChange: handleChange, onBlur: handleBlur, onFocus: handleFocus, "aria-describedby": (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ariaDescribedByIds)(id) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { children: option.label })] }));
                return inline ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("label", { className: `checkbox-inline ${disabledCls}`, children: checkbox }, index)) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: `checkbox ${disabledCls}`, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("label", { children: checkbox }) }, index));
            }) }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CheckboxesWidget);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/ColorWidget.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/ColorWidget.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ColorWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");


/** The `ColorWidget` component uses the `BaseInputTemplate` changing the type to `color` and disables it when it is
 * either disabled or readonly.
 *
 * @param props - The `WidgetProps` for this component
 */
function ColorWidget(props) {
    const { disabled, readonly, options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('BaseInputTemplate', registry, options);
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { type: 'color', ...props, disabled: disabled || readonly });
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/DateTimeWidget.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/DateTimeWidget.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DateTimeWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");


/** The `DateTimeWidget` component uses the `BaseInputTemplate` changing the type to `datetime-local` and transforms
 * the value to/from utc using the appropriate utility functions.
 *
 * @param props - The `WidgetProps` for this component
 */
function DateTimeWidget(props) {
    const { onChange, value, options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('BaseInputTemplate', registry, options);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { type: 'datetime-local', ...props, value: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.utcToLocal)(value), onChange: (value) => onChange((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.localToUTC)(value)) }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/DateWidget.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/DateWidget.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ DateWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");



/** The `DateWidget` component uses the `BaseInputTemplate` changing the type to `date` and transforms
 * the value to undefined when it is falsy during the `onChange` handling.
 *
 * @param props - The `WidgetProps` for this component
 */
function DateWidget(props) {
    const { onChange, options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('BaseInputTemplate', registry, options);
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((value) => onChange(value || undefined), [onChange]);
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { type: 'date', ...props, onChange: handleChange });
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/EmailWidget.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/EmailWidget.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ EmailWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");


/** The `EmailWidget` component uses the `BaseInputTemplate` changing the type to `email`.
 *
 * @param props - The `WidgetProps` for this component
 */
function EmailWidget(props) {
    const { options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('BaseInputTemplate', registry, options);
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { type: 'email', ...props });
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/FileWidget.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/FileWidget.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");
/* harmony import */ var markdown_to_jsx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! markdown-to-jsx */ "../../node_modules/markdown-to-jsx/dist/index.modern.js");




function addNameToDataURL(dataURL, name) {
    if (dataURL === null) {
        return null;
    }
    return dataURL.replace(';base64', `;name=${encodeURIComponent(name)};base64`);
}
function processFile(file) {
    const { name, size, type } = file;
    return new Promise((resolve, reject) => {
        const reader = new window.FileReader();
        reader.onerror = reject;
        reader.onload = (event) => {
            var _a;
            if (typeof ((_a = event.target) === null || _a === void 0 ? void 0 : _a.result) === 'string') {
                resolve({
                    dataURL: addNameToDataURL(event.target.result, name),
                    name,
                    size,
                    type,
                });
            }
            else {
                resolve({
                    dataURL: null,
                    name,
                    size,
                    type,
                });
            }
        };
        reader.readAsDataURL(file);
    });
}
function processFiles(files) {
    return Promise.all(Array.from(files).map(processFile));
}
function FileInfoPreview({ fileInfo, registry, }) {
    const { translateString } = registry;
    const { dataURL, type, name } = fileInfo;
    if (!dataURL) {
        return null;
    }
    // If type is JPEG or PNG then show image preview.
    // Originally, any type of image was supported, but this was changed into a whitelist
    // since SVGs and animated GIFs are also images, which are generally considered a security risk.
    if (['image/jpeg', 'image/png'].includes(type)) {
        return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("img", { src: dataURL, style: { maxWidth: '100%' }, className: 'file-preview' });
    }
    // otherwise, let users download file
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [' ', (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("a", { download: `preview-${name}`, href: dataURL, className: 'file-download', children: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.PreviewLabel) })] }));
}
function FilesInfo({ filesInfo, registry, preview, onRemove, options, }) {
    if (filesInfo.length === 0) {
        return null;
    }
    const { translateString } = registry;
    const { RemoveButton } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('ButtonTemplates', registry, options);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("ul", { className: 'file-info', children: filesInfo.map((fileInfo, key) => {
            const { name, size, type } = fileInfo;
            const handleRemove = () => onRemove(key);
            return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("li", { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(markdown_to_jsx__WEBPACK_IMPORTED_MODULE_3__["default"], { children: translateString(_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.TranslatableString.FilesInfo, [name, type, String(size)]) }), preview && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(FileInfoPreview, { fileInfo: fileInfo, registry: registry }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(RemoveButton, { onClick: handleRemove, registry: registry })] }, key));
        }) }));
}
function extractFileInfo(dataURLs) {
    return dataURLs.reduce((acc, dataURL) => {
        if (!dataURL) {
            return acc;
        }
        try {
            const { blob, name } = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.dataURItoBlob)(dataURL);
            return [
                ...acc,
                {
                    dataURL,
                    name: name,
                    size: blob.size,
                    type: blob.type,
                },
            ];
        }
        catch (e) {
            // Invalid dataURI, so just ignore it.
            return acc;
        }
    }, []);
}
/**
 *  The `FileWidget` is a widget for rendering file upload fields.
 *  It is typically used with a string property with data-url format.
 */
function FileWidget(props) {
    const { disabled, readonly, required, multiple, onChange, value, options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('BaseInputTemplate', registry, options);
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => {
        if (!event.target.files) {
            return;
        }
        // Due to variances in themes, dealing with multiple files for the array case now happens one file at a time.
        // This is because we don't pass `multiple` into the `BaseInputTemplate` anymore. Instead, we deal with the single
        // file in each event and concatenate them together ourselves
        processFiles(event.target.files).then((filesInfoEvent) => {
            const newValue = filesInfoEvent.map((fileInfo) => fileInfo.dataURL);
            if (multiple) {
                onChange(value.concat(newValue[0]));
            }
            else {
                onChange(newValue[0]);
            }
        });
    }, [multiple, value, onChange]);
    const filesInfo = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => extractFileInfo(Array.isArray(value) ? value : [value]), [value]);
    const rmFile = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((index) => {
        if (multiple) {
            const newValue = value.filter((_, i) => i !== index);
            onChange(newValue);
        }
        else {
            onChange(undefined);
        }
    }, [multiple, value, onChange]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { ...props, disabled: disabled || readonly, type: 'file', required: value ? false : required, onChangeOverride: handleChange, value: '', accept: options.accept ? String(options.accept) : undefined }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(FilesInfo, { filesInfo: filesInfo, onRemove: rmFile, registry: registry, preview: options.filePreview, options: options })] }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FileWidget);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/HiddenWidget.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/HiddenWidget.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");

/** The `HiddenWidget` is a widget for rendering a hidden input field.
 *  It is typically used by setting type to "hidden".
 *
 * @param props - The `WidgetProps` for this component
 */
function HiddenWidget({ id, value, }) {
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", { type: 'hidden', id: id, name: id, value: typeof value === 'undefined' ? '' : value });
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (HiddenWidget);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/PasswordWidget.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/PasswordWidget.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ PasswordWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");


/** The `PasswordWidget` component uses the `BaseInputTemplate` changing the type to `password`.
 *
 * @param props - The `WidgetProps` for this component
 */
function PasswordWidget(props) {
    const { options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('BaseInputTemplate', registry, options);
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { type: 'password', ...props });
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/RadioWidget.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/RadioWidget.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");



/** The `RadioWidget` is a widget for rendering a radio group.
 *  It is typically used with a string property constrained with enum options.
 *
 * @param props - The `WidgetProps` for this component
 */
function RadioWidget({ options, value, required, disabled, readonly, autofocus = false, onBlur, onFocus, onChange, id, }) {
    const { enumOptions, enumDisabled, inline, emptyValue } = options;
    const handleBlur = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target }) => onBlur(id, (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsValueForIndex)(target && target.value, enumOptions, emptyValue)), [onBlur, id]);
    const handleFocus = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target }) => onFocus(id, (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsValueForIndex)(target && target.value, enumOptions, emptyValue)), [onFocus, id]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: 'field-radio-group', id: id, children: Array.isArray(enumOptions) &&
            enumOptions.map((option, i) => {
                const checked = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsIsSelected)(option.value, value);
                const itemDisabled = Array.isArray(enumDisabled) && enumDisabled.indexOf(option.value) !== -1;
                const disabledCls = disabled || itemDisabled || readonly ? 'disabled' : '';
                const handleChange = () => onChange(option.value);
                const radio = ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("span", { children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("input", { type: 'radio', id: (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.optionId)(id, i), checked: checked, name: id, required: required, value: String(i), disabled: disabled || itemDisabled || readonly, autoFocus: autofocus && i === 0, onChange: handleChange, onBlur: handleBlur, onFocus: handleFocus, "aria-describedby": (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ariaDescribedByIds)(id) }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { children: option.label })] }));
                return inline ? ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("label", { className: `radio-inline ${disabledCls}`, children: radio }, i)) : ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { className: `radio ${disabledCls}`, children: (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("label", { children: radio }) }, i));
            }) }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RadioWidget);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/RangeWidget.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/RangeWidget.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ RangeWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");

/** The `RangeWidget` component uses the `BaseInputTemplate` changing the type to `range` and wrapping the result
 * in a div, with the value along side it.
 *
 * @param props - The `WidgetProps` for this component
 */
function RangeWidget(props) {
    const { value, registry: { templates: { BaseInputTemplate }, }, } = props;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: 'field-range-wrapper', children: [(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { type: 'range', ...props }), (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: 'range-view', children: value })] }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/SelectWidget.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/SelectWidget.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");



function getValue(event, multiple) {
    if (multiple) {
        return Array.from(event.target.options)
            .slice()
            .filter((o) => o.selected)
            .map((o) => o.value);
    }
    return event.target.value;
}
/** The `SelectWidget` is a widget for rendering dropdowns.
 *  It is typically used with string properties constrained with enum options.
 *
 * @param props - The `WidgetProps` for this component
 */
function SelectWidget({ schema, id, options, value, required, disabled, readonly, multiple = false, autofocus = false, onChange, onBlur, onFocus, placeholder, }) {
    const { enumOptions, enumDisabled, emptyValue: optEmptyVal } = options;
    const emptyValue = multiple ? [] : '';
    const handleFocus = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => {
        const newValue = getValue(event, multiple);
        return onFocus(id, (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsValueForIndex)(newValue, enumOptions, optEmptyVal));
    }, [onFocus, id, schema, multiple, enumOptions, optEmptyVal]);
    const handleBlur = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => {
        const newValue = getValue(event, multiple);
        return onBlur(id, (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsValueForIndex)(newValue, enumOptions, optEmptyVal));
    }, [onBlur, id, schema, multiple, enumOptions, optEmptyVal]);
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((event) => {
        const newValue = getValue(event, multiple);
        return onChange((0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsValueForIndex)(newValue, enumOptions, optEmptyVal));
    }, [onChange, schema, multiple, enumOptions, optEmptyVal]);
    const selectedIndexes = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.enumOptionsIndexForValue)(value, enumOptions, multiple);
    const showPlaceholderOption = !multiple && schema.default === undefined;
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("select", { id: id, name: id, multiple: multiple, className: 'form-control', value: typeof selectedIndexes === 'undefined' ? emptyValue : selectedIndexes, required: required, disabled: disabled || readonly, autoFocus: autofocus, onBlur: handleBlur, onFocus: handleFocus, onChange: handleChange, "aria-describedby": (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ariaDescribedByIds)(id), children: [showPlaceholderOption && (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("option", { value: '', children: placeholder }), Array.isArray(enumOptions) &&
                enumOptions.map(({ value, label }, i) => {
                    const disabled = enumDisabled && enumDisabled.indexOf(value) !== -1;
                    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("option", { value: String(i), disabled: disabled, children: label }, i));
                })] }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SelectWidget);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/TextWidget.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/TextWidget.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TextWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");


/** The `TextWidget` component uses the `BaseInputTemplate`.
 *
 * @param props - The `WidgetProps` for this component
 */
function TextWidget(props) {
    const { options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('BaseInputTemplate', registry, options);
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { ...props });
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/TextareaWidget.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/TextareaWidget.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");



/** The `TextareaWidget` is a widget for rendering input fields as textarea.
 *
 * @param props - The `WidgetProps` for this component
 */
function TextareaWidget({ id, options = {}, placeholder, value, required, disabled, readonly, autofocus = false, onChange, onBlur, onFocus, }) {
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target: { value } }) => onChange(value === '' ? options.emptyValue : value), [onChange, options.emptyValue]);
    const handleBlur = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target }) => onBlur(id, target && target.value), [onBlur, id]);
    const handleFocus = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)(({ target }) => onFocus(id, target && target.value), [id, onFocus]);
    return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("textarea", { id: id, name: id, className: 'form-control', value: value ? value : '', placeholder: placeholder, required: required, disabled: disabled, readOnly: readonly, autoFocus: autofocus, rows: options.rows, onBlur: handleBlur, onFocus: handleFocus, onChange: handleChange, "aria-describedby": (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.ariaDescribedByIds)(id) }));
}
TextareaWidget.defaultProps = {
    autofocus: false,
    options: {},
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TextareaWidget);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/TimeWidget.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/TimeWidget.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ TimeWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");



/** The `TimeWidget` component uses the `BaseInputTemplate` changing the type to `time` and transforms
 * the value to undefined when it is falsy during the `onChange` handling.
 *
 * @param props - The `WidgetProps` for this component
 */
function TimeWidget(props) {
    const { onChange, options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_2__.getTemplate)('BaseInputTemplate', registry, options);
    const handleChange = (0,react__WEBPACK_IMPORTED_MODULE_1__.useCallback)((value) => onChange(value ? `${value}:00` : undefined), [onChange]);
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { type: 'time', ...props, onChange: handleChange });
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/URLWidget.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/URLWidget.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ URLWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");


/** The `URLWidget` component uses the `BaseInputTemplate` changing the type to `url`.
 *
 * @param props - The `WidgetProps` for this component
 */
function URLWidget(props) {
    const { options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('BaseInputTemplate', registry, options);
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { type: 'url', ...props });
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/UpDownWidget.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/UpDownWidget.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UpDownWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");


/** The `UpDownWidget` component uses the `BaseInputTemplate` changing the type to `number`.
 *
 * @param props - The `WidgetProps` for this component
 */
function UpDownWidget(props) {
    const { options, registry } = props;
    const BaseInputTemplate = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getTemplate)('BaseInputTemplate', registry, options);
    return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(BaseInputTemplate, { type: 'number', ...props });
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/components/widgets/index.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/components/widgets/index.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _AltDateWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AltDateWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/AltDateWidget.js");
/* harmony import */ var _AltDateTimeWidget__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AltDateTimeWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/AltDateTimeWidget.js");
/* harmony import */ var _CheckboxWidget__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CheckboxWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/CheckboxWidget.js");
/* harmony import */ var _CheckboxesWidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CheckboxesWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/CheckboxesWidget.js");
/* harmony import */ var _ColorWidget__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ColorWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/ColorWidget.js");
/* harmony import */ var _DateWidget__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./DateWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/DateWidget.js");
/* harmony import */ var _DateTimeWidget__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./DateTimeWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/DateTimeWidget.js");
/* harmony import */ var _EmailWidget__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./EmailWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/EmailWidget.js");
/* harmony import */ var _FileWidget__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./FileWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/FileWidget.js");
/* harmony import */ var _HiddenWidget__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./HiddenWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/HiddenWidget.js");
/* harmony import */ var _PasswordWidget__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./PasswordWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/PasswordWidget.js");
/* harmony import */ var _RadioWidget__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./RadioWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/RadioWidget.js");
/* harmony import */ var _RangeWidget__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./RangeWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/RangeWidget.js");
/* harmony import */ var _SelectWidget__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./SelectWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/SelectWidget.js");
/* harmony import */ var _TextareaWidget__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./TextareaWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/TextareaWidget.js");
/* harmony import */ var _TextWidget__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./TextWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/TextWidget.js");
/* harmony import */ var _TimeWidget__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./TimeWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/TimeWidget.js");
/* harmony import */ var _URLWidget__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./URLWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/URLWidget.js");
/* harmony import */ var _UpDownWidget__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./UpDownWidget */ "../../node_modules/@rjsf/core/lib/components/widgets/UpDownWidget.js");



















function widgets() {
    return {
        AltDateWidget: _AltDateWidget__WEBPACK_IMPORTED_MODULE_0__["default"],
        AltDateTimeWidget: _AltDateTimeWidget__WEBPACK_IMPORTED_MODULE_1__["default"],
        CheckboxWidget: _CheckboxWidget__WEBPACK_IMPORTED_MODULE_2__["default"],
        CheckboxesWidget: _CheckboxesWidget__WEBPACK_IMPORTED_MODULE_3__["default"],
        ColorWidget: _ColorWidget__WEBPACK_IMPORTED_MODULE_4__["default"],
        DateWidget: _DateWidget__WEBPACK_IMPORTED_MODULE_5__["default"],
        DateTimeWidget: _DateTimeWidget__WEBPACK_IMPORTED_MODULE_6__["default"],
        EmailWidget: _EmailWidget__WEBPACK_IMPORTED_MODULE_7__["default"],
        FileWidget: _FileWidget__WEBPACK_IMPORTED_MODULE_8__["default"],
        HiddenWidget: _HiddenWidget__WEBPACK_IMPORTED_MODULE_9__["default"],
        PasswordWidget: _PasswordWidget__WEBPACK_IMPORTED_MODULE_10__["default"],
        RadioWidget: _RadioWidget__WEBPACK_IMPORTED_MODULE_11__["default"],
        RangeWidget: _RangeWidget__WEBPACK_IMPORTED_MODULE_12__["default"],
        SelectWidget: _SelectWidget__WEBPACK_IMPORTED_MODULE_13__["default"],
        TextWidget: _TextWidget__WEBPACK_IMPORTED_MODULE_15__["default"],
        TextareaWidget: _TextareaWidget__WEBPACK_IMPORTED_MODULE_14__["default"],
        TimeWidget: _TimeWidget__WEBPACK_IMPORTED_MODULE_16__["default"],
        UpDownWidget: _UpDownWidget__WEBPACK_IMPORTED_MODULE_18__["default"],
        URLWidget: _URLWidget__WEBPACK_IMPORTED_MODULE_17__["default"],
    };
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (widgets);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/getDefaultRegistry.js":
/*!***************************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/getDefaultRegistry.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getDefaultRegistry)
/* harmony export */ });
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");
/* harmony import */ var _components_fields__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./components/fields */ "../../node_modules/@rjsf/core/lib/components/fields/index.js");
/* harmony import */ var _components_templates__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./components/templates */ "../../node_modules/@rjsf/core/lib/components/templates/index.js");
/* harmony import */ var _components_widgets__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/widgets */ "../../node_modules/@rjsf/core/lib/components/widgets/index.js");




/** The default registry consists of all the fields, templates and widgets provided in the core implementation,
 * plus an empty `rootSchema` and `formContext. We omit schemaUtils here because it cannot be defaulted without a
 * rootSchema and validator. It will be added into the computed registry later in the Form.
 */
function getDefaultRegistry() {
    return {
        fields: (0,_components_fields__WEBPACK_IMPORTED_MODULE_1__["default"])(),
        templates: (0,_components_templates__WEBPACK_IMPORTED_MODULE_2__["default"])(),
        widgets: (0,_components_widgets__WEBPACK_IMPORTED_MODULE_3__["default"])(),
        rootSchema: {},
        formContext: {},
        translateString: _rjsf_utils__WEBPACK_IMPORTED_MODULE_0__.englishStringTranslator,
    };
}


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/index.js":
/*!**************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   getDefaultRegistry: () => (/* reexport safe */ _getDefaultRegistry__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   withTheme: () => (/* reexport safe */ _withTheme__WEBPACK_IMPORTED_MODULE_1__["default"])
/* harmony export */ });
/* harmony import */ var _components_Form__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components/Form */ "../../node_modules/@rjsf/core/lib/components/Form.js");
/* harmony import */ var _withTheme__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./withTheme */ "../../node_modules/@rjsf/core/lib/withTheme.js");
/* harmony import */ var _getDefaultRegistry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getDefaultRegistry */ "../../node_modules/@rjsf/core/lib/getDefaultRegistry.js");




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_components_Form__WEBPACK_IMPORTED_MODULE_0__["default"]);


/***/ }),

/***/ "../../node_modules/@rjsf/core/lib/withTheme.js":
/*!******************************************************!*\
  !*** ../../node_modules/@rjsf/core/lib/withTheme.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ withTheme)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_Form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./components/Form */ "../../node_modules/@rjsf/core/lib/components/Form.js");



/** A Higher-Order component that creates a wrapper around a `Form` with the overrides from the `WithThemeProps` */
function withTheme(themeProps) {
    return (0,react__WEBPACK_IMPORTED_MODULE_1__.forwardRef)(({ fields, widgets, templates, ...directProps }, ref) => {
        var _a;
        fields = { ...themeProps === null || themeProps === void 0 ? void 0 : themeProps.fields, ...fields };
        widgets = { ...themeProps === null || themeProps === void 0 ? void 0 : themeProps.widgets, ...widgets };
        templates = {
            ...themeProps === null || themeProps === void 0 ? void 0 : themeProps.templates,
            ...templates,
            ButtonTemplates: {
                ...(_a = themeProps === null || themeProps === void 0 ? void 0 : themeProps.templates) === null || _a === void 0 ? void 0 : _a.ButtonTemplates,
                ...templates === null || templates === void 0 ? void 0 : templates.ButtonTemplates,
            },
        };
        return ((0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_Form__WEBPACK_IMPORTED_MODULE_2__["default"], { ...themeProps, ...directProps, fields: fields, widgets: widgets, templates: templates, ref: ref }));
    });
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/ErrorSchemaBuilder.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/ErrorSchemaBuilder.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ErrorSchemaBuilder)
/* harmony export */ });
/* harmony import */ var lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/cloneDeep */ "../../node_modules/lodash/cloneDeep.js");
/* harmony import */ var lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/set */ "../../node_modules/lodash/set.js");
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_set__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");




/** The `ErrorSchemaBuilder<T>` is used to build an `ErrorSchema<T>` since the definition of the `ErrorSchema` type is
 * designed for reading information rather than writing it. Use this class to add, replace or clear errors in an error
 * schema by using either dotted path or an array of path names. Once you are done building the `ErrorSchema`, you can
 * get the result and/or reset all the errors back to an initial set and start again.
 */
class ErrorSchemaBuilder {
    /** Construct an `ErrorSchemaBuilder` with an optional initial set of errors in an `ErrorSchema`.
     *
     * @param [initialSchema] - The optional set of initial errors, that will be cloned into the class
     */
    constructor(initialSchema) {
        /** The error schema being built
         *
         * @private
         */
        this.errorSchema = {};
        this.resetAllErrors(initialSchema);
    }
    /** Returns the `ErrorSchema` that has been updated by the methods of the `ErrorSchemaBuilder`
     */
    get ErrorSchema() {
        return this.errorSchema;
    }
    /** Will get an existing `ErrorSchema` at the specified `pathOfError` or create and return one.
     *
     * @param [pathOfError] - The optional path into the `ErrorSchema` at which to add the error(s)
     * @returns - The error block for the given `pathOfError` or the root if not provided
     * @private
     */
    getOrCreateErrorBlock(pathOfError) {
        const hasPath = (Array.isArray(pathOfError) && pathOfError.length > 0) || typeof pathOfError === 'string';
        let errorBlock = hasPath ? lodash_get__WEBPACK_IMPORTED_MODULE_1___default()(this.errorSchema, pathOfError) : this.errorSchema;
        if (!errorBlock && pathOfError) {
            errorBlock = {};
            lodash_set__WEBPACK_IMPORTED_MODULE_2___default()(this.errorSchema, pathOfError, errorBlock);
        }
        return errorBlock;
    }
    /** Resets all errors in the `ErrorSchemaBuilder` back to the `initialSchema` if provided, otherwise an empty set.
     *
     * @param [initialSchema] - The optional set of initial errors, that will be cloned into the class
     * @returns - The `ErrorSchemaBuilder` object for chaining purposes
     */
    resetAllErrors(initialSchema) {
        this.errorSchema = initialSchema ? lodash_cloneDeep__WEBPACK_IMPORTED_MODULE_0___default()(initialSchema) : {};
        return this;
    }
    /** Adds the `errorOrList` to the list of errors in the `ErrorSchema` at either the root level or the location within
     * the schema described by the `pathOfError`. For more information about how to specify the path see the
     * [eslint lodash plugin docs](https://github.com/wix/eslint-plugin-lodash/blob/master/docs/rules/path-style.md).
     *
     * @param errorOrList - The error or list of errors to add into the `ErrorSchema`
     * @param [pathOfError] - The optional path into the `ErrorSchema` at which to add the error(s)
     * @returns - The `ErrorSchemaBuilder` object for chaining purposes
     */
    addErrors(errorOrList, pathOfError) {
        const errorBlock = this.getOrCreateErrorBlock(pathOfError);
        let errorsList = lodash_get__WEBPACK_IMPORTED_MODULE_1___default()(errorBlock, _constants__WEBPACK_IMPORTED_MODULE_3__.ERRORS_KEY);
        if (!Array.isArray(errorsList)) {
            errorsList = [];
            errorBlock[_constants__WEBPACK_IMPORTED_MODULE_3__.ERRORS_KEY] = errorsList;
        }
        if (Array.isArray(errorOrList)) {
            errorsList.push(...errorOrList);
        }
        else {
            errorsList.push(errorOrList);
        }
        return this;
    }
    /** Sets/replaces the `errorOrList` as the error(s) in the `ErrorSchema` at either the root level or the location
     * within the schema described by the `pathOfError`. For more information about how to specify the path see the
     * [eslint lodash plugin docs](https://github.com/wix/eslint-plugin-lodash/blob/master/docs/rules/path-style.md).
     *
     * @param errorOrList - The error or list of errors to set into the `ErrorSchema`
     * @param [pathOfError] - The optional path into the `ErrorSchema` at which to set the error(s)
     * @returns - The `ErrorSchemaBuilder` object for chaining purposes
     */
    setErrors(errorOrList, pathOfError) {
        const errorBlock = this.getOrCreateErrorBlock(pathOfError);
        // Effectively clone the array being given to prevent accidental outside manipulation of the given list
        const listToAdd = Array.isArray(errorOrList) ? [...errorOrList] : [errorOrList];
        lodash_set__WEBPACK_IMPORTED_MODULE_2___default()(errorBlock, _constants__WEBPACK_IMPORTED_MODULE_3__.ERRORS_KEY, listToAdd);
        return this;
    }
    /** Clears the error(s) in the `ErrorSchema` at either the root level or the location within the schema described by
     * the `pathOfError`. For more information about how to specify the path see the
     * [eslint lodash plugin docs](https://github.com/wix/eslint-plugin-lodash/blob/master/docs/rules/path-style.md).
     *
     * @param [pathOfError] - The optional path into the `ErrorSchema` at which to clear the error(s)
     * @returns - The `ErrorSchemaBuilder` object for chaining purposes
     */
    clearErrors(pathOfError) {
        const errorBlock = this.getOrCreateErrorBlock(pathOfError);
        lodash_set__WEBPACK_IMPORTED_MODULE_2___default()(errorBlock, _constants__WEBPACK_IMPORTED_MODULE_3__.ERRORS_KEY, []);
        return this;
    }
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/allowAdditionalItems.js":
/*!******************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/allowAdditionalItems.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ allowAdditionalItems)
/* harmony export */ });
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");

/** Checks the schema to see if it is allowing additional items, by verifying that `schema.additionalItems` is an
 * object. The user is warned in the console if `schema.additionalItems` has the value `true`.
 *
 * @param schema - The schema object to check
 * @returns - True if additional items is allowed, otherwise false
 */
function allowAdditionalItems(schema) {
    if (schema.additionalItems === true) {
        console.warn('additionalItems=true is currently not supported');
    }
    return (0,_isObject__WEBPACK_IMPORTED_MODULE_0__["default"])(schema.additionalItems);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/asNumber.js":
/*!******************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/asNumber.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ asNumber)
/* harmony export */ });
/** Attempts to convert the string into a number. If an empty string is provided, then `undefined` is returned. If a
 * `null` is provided, it is returned. If the string ends in a `.` then the string is returned because the user may be
 * in the middle of typing a float number. If a number ends in a pattern like `.0`, `.20`, `.030`, string is returned
 * because the user may be typing number that will end in a non-zero digit. Otherwise, the string is wrapped by
 * `Number()` and if that result is not `NaN`, that number will be returned, otherwise the string `value` will be.
 *
 * @param value - The string or null value to convert to a number
 * @returns - The `value` converted to a number when appropriate, otherwise the `value`
 */
function asNumber(value) {
    if (value === '') {
        return undefined;
    }
    if (value === null) {
        return null;
    }
    if (/\.$/.test(value)) {
        // '3.' can't really be considered a number even if it parses in js. The
        // user is most likely entering a float.
        return value;
    }
    if (/\.0$/.test(value)) {
        // we need to return this as a string here, to allow for input like 3.07
        return value;
    }
    if (/\.\d*0$/.test(value)) {
        // It's a number, that's cool - but we need it as a string so it doesn't screw
        // with the user when entering dollar amounts or other values (such as those with
        // specific precision or number of significant digits)
        return value;
    }
    const n = Number(value);
    const valid = typeof n === 'number' && !Number.isNaN(n);
    return valid ? n : value;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/canExpand.js":
/*!*******************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/canExpand.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ canExpand)
/* harmony export */ });
/* harmony import */ var _getUiOptions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getUiOptions */ "../../node_modules/@rjsf/utils/lib/getUiOptions.js");

/** Checks whether the field described by `schema`, having the `uiSchema` and `formData` supports expanding. The UI for
 * the field can expand if it has additional properties, is not forced as non-expandable by the `uiSchema` and the
 * `formData` object doesn't already have `schema.maxProperties` elements.
 *
 * @param schema - The schema for the field that is being checked
 * @param [uiSchema={}] - The uiSchema for the field
 * @param [formData] - The formData for the field
 * @returns - True if the schema element has additionalProperties, is expandable, and not at the maxProperties limit
 */
function canExpand(schema, uiSchema = {}, formData) {
    if (!schema.additionalProperties) {
        return false;
    }
    const { expandable = true } = (0,_getUiOptions__WEBPACK_IMPORTED_MODULE_0__["default"])(uiSchema);
    if (expandable === false) {
        return expandable;
    }
    // if ui:options.expandable was not explicitly set to false, we can add
    // another property if we have not exceeded maxProperties yet
    if (schema.maxProperties !== undefined && formData) {
        return Object.keys(formData).length < schema.maxProperties;
    }
    return true;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/constants.js":
/*!*******************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/constants.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ADDITIONAL_PROPERTIES_KEY: () => (/* binding */ ADDITIONAL_PROPERTIES_KEY),
/* harmony export */   ADDITIONAL_PROPERTY_FLAG: () => (/* binding */ ADDITIONAL_PROPERTY_FLAG),
/* harmony export */   ALL_OF_KEY: () => (/* binding */ ALL_OF_KEY),
/* harmony export */   ANY_OF_KEY: () => (/* binding */ ANY_OF_KEY),
/* harmony export */   CONST_KEY: () => (/* binding */ CONST_KEY),
/* harmony export */   DEFAULT_KEY: () => (/* binding */ DEFAULT_KEY),
/* harmony export */   DEFINITIONS_KEY: () => (/* binding */ DEFINITIONS_KEY),
/* harmony export */   DEPENDENCIES_KEY: () => (/* binding */ DEPENDENCIES_KEY),
/* harmony export */   ENUM_KEY: () => (/* binding */ ENUM_KEY),
/* harmony export */   ERRORS_KEY: () => (/* binding */ ERRORS_KEY),
/* harmony export */   ID_KEY: () => (/* binding */ ID_KEY),
/* harmony export */   IF_KEY: () => (/* binding */ IF_KEY),
/* harmony export */   ITEMS_KEY: () => (/* binding */ ITEMS_KEY),
/* harmony export */   JUNK_OPTION_ID: () => (/* binding */ JUNK_OPTION_ID),
/* harmony export */   NAME_KEY: () => (/* binding */ NAME_KEY),
/* harmony export */   ONE_OF_KEY: () => (/* binding */ ONE_OF_KEY),
/* harmony export */   PROPERTIES_KEY: () => (/* binding */ PROPERTIES_KEY),
/* harmony export */   REF_KEY: () => (/* binding */ REF_KEY),
/* harmony export */   REQUIRED_KEY: () => (/* binding */ REQUIRED_KEY),
/* harmony export */   RJSF_ADDITIONAL_PROPERTIES_FLAG: () => (/* binding */ RJSF_ADDITIONAL_PROPERTIES_FLAG),
/* harmony export */   RJSF_ADDITONAL_PROPERTIES_FLAG: () => (/* binding */ RJSF_ADDITONAL_PROPERTIES_FLAG),
/* harmony export */   ROOT_SCHEMA_PREFIX: () => (/* binding */ ROOT_SCHEMA_PREFIX),
/* harmony export */   SUBMIT_BTN_OPTIONS_KEY: () => (/* binding */ SUBMIT_BTN_OPTIONS_KEY),
/* harmony export */   UI_FIELD_KEY: () => (/* binding */ UI_FIELD_KEY),
/* harmony export */   UI_GLOBAL_OPTIONS_KEY: () => (/* binding */ UI_GLOBAL_OPTIONS_KEY),
/* harmony export */   UI_OPTIONS_KEY: () => (/* binding */ UI_OPTIONS_KEY),
/* harmony export */   UI_WIDGET_KEY: () => (/* binding */ UI_WIDGET_KEY)
/* harmony export */ });
/** Below are the list of all the keys into various elements of a RJSFSchema or UiSchema that are used by the various
 * utility functions. In addition to those keys, there are the special `ADDITIONAL_PROPERTY_FLAG` and
 * `RJSF_ADDITIONAL_PROPERTIES_FLAG` flags that is added to a schema under certain conditions by the `retrieveSchema()`
 * utility.
 */
const ADDITIONAL_PROPERTY_FLAG = '__additional_property';
const ADDITIONAL_PROPERTIES_KEY = 'additionalProperties';
const ALL_OF_KEY = 'allOf';
const ANY_OF_KEY = 'anyOf';
const CONST_KEY = 'const';
const DEFAULT_KEY = 'default';
const DEFINITIONS_KEY = 'definitions';
const DEPENDENCIES_KEY = 'dependencies';
const ENUM_KEY = 'enum';
const ERRORS_KEY = '__errors';
const ID_KEY = '$id';
const IF_KEY = 'if';
const ITEMS_KEY = 'items';
const JUNK_OPTION_ID = '_$junk_option_schema_id$_';
const NAME_KEY = '$name';
const ONE_OF_KEY = 'oneOf';
const PROPERTIES_KEY = 'properties';
const REQUIRED_KEY = 'required';
const SUBMIT_BTN_OPTIONS_KEY = 'submitButtonOptions';
const REF_KEY = '$ref';
/**
 * @deprecated Replace with correctly spelled constant `RJSF_ADDITIONAL_PROPERTIES_FLAG`
 */
const RJSF_ADDITONAL_PROPERTIES_FLAG = '__rjsf_additionalProperties';
const RJSF_ADDITIONAL_PROPERTIES_FLAG = '__rjsf_additionalProperties';
const ROOT_SCHEMA_PREFIX = '__rjsf_rootSchema';
const UI_FIELD_KEY = 'ui:field';
const UI_WIDGET_KEY = 'ui:widget';
const UI_OPTIONS_KEY = 'ui:options';
const UI_GLOBAL_OPTIONS_KEY = 'ui:globalOptions';


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/createErrorHandler.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/createErrorHandler.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createErrorHandler)
/* harmony export */ });
/* harmony import */ var lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/isPlainObject */ "../../node_modules/lodash/isPlainObject.js");
/* harmony import */ var lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");


/** Given a `formData` object, recursively creates a `FormValidation` error handling structure around it
 *
 * @param formData - The form data around which the error handler is created
 * @returns - A `FormValidation` object based on the `formData` structure
 */
function createErrorHandler(formData) {
    const handler = {
        // We store the list of errors for this node in a property named __errors
        // to avoid name collision with a possible sub schema field named
        // 'errors' (see `utils.toErrorSchema`).
        [_constants__WEBPACK_IMPORTED_MODULE_1__.ERRORS_KEY]: [],
        addError(message) {
            this[_constants__WEBPACK_IMPORTED_MODULE_1__.ERRORS_KEY].push(message);
        },
    };
    if (Array.isArray(formData)) {
        return formData.reduce((acc, value, key) => {
            return { ...acc, [key]: createErrorHandler(value) };
        }, handler);
    }
    if (lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0___default()(formData)) {
        const formObject = formData;
        return Object.keys(formObject).reduce((acc, key) => {
            return { ...acc, [key]: createErrorHandler(formObject[key]) };
        }, handler);
    }
    return handler;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/createSchemaUtils.js":
/*!***************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/createSchemaUtils.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createSchemaUtils)
/* harmony export */ });
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");
/* harmony import */ var _schema__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./schema */ "../../node_modules/@rjsf/utils/lib/schema/index.js");


/** The `SchemaUtils` class provides a wrapper around the publicly exported APIs in the `utils/schema` directory such
 * that one does not have to explicitly pass the `validator`, `rootSchema`, or `experimental_defaultFormStateBehavior` to each method.
 * Since these generally do not change across a `Form`, this allows for providing a simplified set of APIs to the
 * `@rjsf/core` components and the various themes as well. This class implements the `SchemaUtilsType` interface.
 */
class SchemaUtils {
    /** Constructs the `SchemaUtils` instance with the given `validator` and `rootSchema` stored as instance variables
     *
     * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
     * @param rootSchema - The root schema that will be forwarded to all the APIs
     * @param experimental_defaultFormStateBehavior - Configuration flags to allow users to override default form state behavior
     */
    constructor(validator, rootSchema, experimental_defaultFormStateBehavior) {
        this.rootSchema = rootSchema;
        this.validator = validator;
        this.experimental_defaultFormStateBehavior = experimental_defaultFormStateBehavior;
    }
    /** Returns the `ValidatorType` in the `SchemaUtilsType`
     *
     * @returns - The `ValidatorType`
     */
    getValidator() {
        return this.validator;
    }
    /** Determines whether either the `validator` and `rootSchema` differ from the ones associated with this instance of
     * the `SchemaUtilsType`. If either `validator` or `rootSchema` are falsy, then return false to prevent the creation
     * of a new `SchemaUtilsType` with incomplete properties.
     *
     * @param validator - An implementation of the `ValidatorType` interface that will be compared against the current one
     * @param rootSchema - The root schema that will be compared against the current one
     * @param [experimental_defaultFormStateBehavior] Optional configuration object, if provided, allows users to override default form state behavior
     * @returns - True if the `SchemaUtilsType` differs from the given `validator` or `rootSchema`
     */
    doesSchemaUtilsDiffer(validator, rootSchema, experimental_defaultFormStateBehavior = {}) {
        if (!validator || !rootSchema) {
            return false;
        }
        return (this.validator !== validator ||
            !(0,_deepEquals__WEBPACK_IMPORTED_MODULE_0__["default"])(this.rootSchema, rootSchema) ||
            !(0,_deepEquals__WEBPACK_IMPORTED_MODULE_0__["default"])(this.experimental_defaultFormStateBehavior, experimental_defaultFormStateBehavior));
    }
    /** Returns the superset of `formData` that includes the given set updated to include any missing fields that have
     * computed to have defaults provided in the `schema`.
     *
     * @param schema - The schema for which the default state is desired
     * @param [formData] - The current formData, if any, onto which to provide any missing defaults
     * @param [includeUndefinedValues=false] - Optional flag, if true, cause undefined values to be added as defaults.
     *          If "excludeObjectChildren", pass `includeUndefinedValues` as false when computing defaults for any nested
     *          object properties.
     * @returns - The resulting `formData` with all the defaults provided
     */
    getDefaultFormState(schema, formData, includeUndefinedValues = false) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.getDefaultFormState)(this.validator, schema, formData, this.rootSchema, includeUndefinedValues, this.experimental_defaultFormStateBehavior);
    }
    /** Determines whether the combination of `schema` and `uiSchema` properties indicates that the label for the `schema`
     * should be displayed in a UI.
     *
     * @param schema - The schema for which the display label flag is desired
     * @param [uiSchema] - The UI schema from which to derive potentially displayable information
     * @param [globalOptions={}] - The optional Global UI Schema from which to get any fallback `xxx` options
     * @returns - True if the label should be displayed or false if it should not
     */
    getDisplayLabel(schema, uiSchema, globalOptions) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.getDisplayLabel)(this.validator, schema, uiSchema, this.rootSchema, globalOptions);
    }
    /** Determines which of the given `options` provided most closely matches the `formData`.
     * Returns the index of the option that is valid and is the closest match, or 0 if there is no match.
     *
     * The closest match is determined using the number of matching properties, and more heavily favors options with
     * matching readOnly, default, or const values.
     *
     * @param formData - The form data associated with the schema
     * @param options - The list of options that can be selected from
     * @param [selectedOption] - The index of the currently selected option, defaulted to -1 if not specified
     * @param [discriminatorField] - The optional name of the field within the options object whose value is used to
     *          determine which option is selected
     * @returns - The index of the option that is the closest match to the `formData` or the `selectedOption` if no match
     */
    getClosestMatchingOption(formData, options, selectedOption, discriminatorField) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.getClosestMatchingOption)(this.validator, this.rootSchema, formData, options, selectedOption, discriminatorField);
    }
    /** Given the `formData` and list of `options`, attempts to find the index of the first option that matches the data.
     * Always returns the first option if there is nothing that matches.
     *
     * @param formData - The current formData, if any, used to figure out a match
     * @param options - The list of options to find a matching options from
     * @param [discriminatorField] - The optional name of the field within the options object whose value is used to
     *          determine which option is selected
     * @returns - The firstindex of the matched option or 0 if none is available
     */
    getFirstMatchingOption(formData, options, discriminatorField) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.getFirstMatchingOption)(this.validator, formData, options, this.rootSchema, discriminatorField);
    }
    /** Given the `formData` and list of `options`, attempts to find the index of the option that best matches the data.
     * Deprecated, use `getFirstMatchingOption()` instead.
     *
     * @param formData - The current formData, if any, onto which to provide any missing defaults
     * @param options - The list of options to find a matching options from
     * @param [discriminatorField] - The optional name of the field within the options object whose value is used to
     *          determine which option is selected
     * @returns - The index of the matched option or 0 if none is available
     * @deprecated
     */
    getMatchingOption(formData, options, discriminatorField) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.getMatchingOption)(this.validator, formData, options, this.rootSchema, discriminatorField);
    }
    /** Checks to see if the `schema` and `uiSchema` combination represents an array of files
     *
     * @param schema - The schema for which check for array of files flag is desired
     * @param [uiSchema] - The UI schema from which to check the widget
     * @returns - True if schema/uiSchema contains an array of files, otherwise false
     */
    isFilesArray(schema, uiSchema) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.isFilesArray)(this.validator, schema, uiSchema, this.rootSchema);
    }
    /** Checks to see if the `schema` combination represents a multi-select
     *
     * @param schema - The schema for which check for a multi-select flag is desired
     * @returns - True if schema contains a multi-select, otherwise false
     */
    isMultiSelect(schema) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.isMultiSelect)(this.validator, schema, this.rootSchema);
    }
    /** Checks to see if the `schema` combination represents a select
     *
     * @param schema - The schema for which check for a select flag is desired
     * @returns - True if schema contains a select, otherwise false
     */
    isSelect(schema) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.isSelect)(this.validator, schema, this.rootSchema);
    }
    /** Merges the errors in `additionalErrorSchema` into the existing `validationData` by combining the hierarchies in
     * the two `ErrorSchema`s and then appending the error list from the `additionalErrorSchema` obtained by calling
     * `getValidator().toErrorList()` onto the `errors` in the `validationData`. If no `additionalErrorSchema` is passed,
     * then `validationData` is returned.
     *
     * @param validationData - The current `ValidationData` into which to merge the additional errors
     * @param [additionalErrorSchema] - The additional set of errors
     * @returns - The `validationData` with the additional errors from `additionalErrorSchema` merged into it, if provided.
     * @deprecated - Use the `validationDataMerge()` function exported from `@rjsf/utils` instead. This function will be
     *        removed in the next major release.
     */
    mergeValidationData(validationData, additionalErrorSchema) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.mergeValidationData)(this.validator, validationData, additionalErrorSchema);
    }
    /** Retrieves an expanded schema that has had all of its conditions, additional properties, references and
     * dependencies resolved and merged into the `schema` given a `rawFormData` that is used to do the potentially
     * recursive resolution.
     *
     * @param schema - The schema for which retrieving a schema is desired
     * @param [rawFormData] - The current formData, if any, to assist retrieving a schema
     * @returns - The schema having its conditions, additional properties, references and dependencies resolved
     */
    retrieveSchema(schema, rawFormData) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.retrieveSchema)(this.validator, schema, this.rootSchema, rawFormData);
    }
    /** Sanitize the `data` associated with the `oldSchema` so it is considered appropriate for the `newSchema`. If the
     * new schema does not contain any properties, then `undefined` is returned to clear all the form data. Due to the
     * nature of schemas, this sanitization happens recursively for nested objects of data. Also, any properties in the
     * old schemas that are non-existent in the new schema are set to `undefined`.
     *
     * @param [newSchema] - The new schema for which the data is being sanitized
     * @param [oldSchema] - The old schema from which the data originated
     * @param [data={}] - The form data associated with the schema, defaulting to an empty object when undefined
     * @returns - The new form data, with all the fields uniquely associated with the old schema set
     *      to `undefined`. Will return `undefined` if the new schema is not an object containing properties.
     */
    sanitizeDataForNewSchema(newSchema, oldSchema, data) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.sanitizeDataForNewSchema)(this.validator, this.rootSchema, newSchema, oldSchema, data);
    }
    /** Generates an `IdSchema` object for the `schema`, recursively
     *
     * @param schema - The schema for which the display label flag is desired
     * @param [id] - The base id for the schema
     * @param [formData] - The current formData, if any, onto which to provide any missing defaults
     * @param [idPrefix='root'] - The prefix to use for the id
     * @param [idSeparator='_'] - The separator to use for the path segments in the id
     * @returns - The `IdSchema` object for the `schema`
     */
    toIdSchema(schema, id, formData, idPrefix = 'root', idSeparator = '_') {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.toIdSchema)(this.validator, schema, id, this.rootSchema, formData, idPrefix, idSeparator);
    }
    /** Generates an `PathSchema` object for the `schema`, recursively
     *
     * @param schema - The schema for which the display label flag is desired
     * @param [name] - The base name for the schema
     * @param [formData] - The current formData, if any, onto which to provide any missing defaults
     * @returns - The `PathSchema` object for the `schema`
     */
    toPathSchema(schema, name, formData) {
        return (0,_schema__WEBPACK_IMPORTED_MODULE_1__.toPathSchema)(this.validator, schema, name, this.rootSchema, formData);
    }
}
/** Creates a `SchemaUtilsType` interface that is based around the given `validator` and `rootSchema` parameters. The
 * resulting interface implementation will forward the `validator` and `rootSchema` to all the wrapped APIs.
 *
 * @param validator - an implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param [experimental_defaultFormStateBehavior] Optional configuration object, if provided, allows users to override default form state behavior
 * @returns - An implementation of a `SchemaUtilsType` interface
 */
function createSchemaUtils(validator, rootSchema, experimental_defaultFormStateBehavior = {}) {
    return new SchemaUtils(validator, rootSchema, experimental_defaultFormStateBehavior);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/dataURItoBlob.js":
/*!***********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/dataURItoBlob.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ dataURItoBlob)
/* harmony export */ });
/** Given the `FileReader.readAsDataURL()` based `dataURI` extracts that data into an actual Blob along with the name
 * of that Blob if provided in the URL. If no name is provided, then the name falls back to `unknown`.
 *
 * @param dataURI - The `DataUrl` potentially containing name and raw data to be converted to a Blob
 * @returns - an object containing a Blob and its name, extracted from the URI
 */
function dataURItoBlob(dataURILike) {
    var _a;
    // check if is dataURI
    if (dataURILike.indexOf('data:') === -1) {
        throw new Error('File is invalid: URI must be a dataURI');
    }
    const dataURI = dataURILike.slice(5);
    // split the dataURI into media and base64, with the base64 signature
    const splitted = dataURI.split(';base64,');
    // if the base64 signature is not present, the latter part will become empty
    if (splitted.length !== 2) {
        throw new Error('File is invalid: dataURI must be base64');
    }
    // extract the mime type, media parameters including the name, and the base64 string
    const [media, base64] = splitted;
    const [mime, ...mediaparams] = media.split(';');
    const type = mime || '';
    // extract the name from the parameters
    const name = decodeURI(
    // parse the parameters into key-value pairs, find a key, and extract a value
    // if no key is found, then the name is unknown
    ((_a = mediaparams.map((param) => param.split('=')).find(([key]) => key === 'name')) === null || _a === void 0 ? void 0 : _a[1]) || 'unknown');
    // Built the Uint8Array Blob parameter from the base64 string.
    try {
        const binary = atob(base64);
        const array = new Array(binary.length);
        for (let i = 0; i < binary.length; i++) {
            array[i] = binary.charCodeAt(i);
        }
        // Create the blob object
        const blob = new window.Blob([new Uint8Array(array)], { type });
        return { blob, name };
    }
    catch (error) {
        throw new Error('File is invalid: ' + error.message);
    }
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/dateRangeOptions.js":
/*!**************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/dateRangeOptions.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ dateRangeOptions)
/* harmony export */ });
/* harmony import */ var _pad__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./pad */ "../../node_modules/@rjsf/utils/lib/pad.js");

/** Returns a list of options for a date range between `start` and `stop`. If the start date is greater than the end
 * date, then the date range is reversed. If `start` and `stop` are negative numbers (or zero), then they will be
 * treated as relative to the current year.
 *
 * @param start - The starting point of the date range
 * @param stop - The ending point of the date range
 * @returns - The list of EnumOptionsType for the date range between `start` and `stop`
 * @throws - Error when `start` and `stop` aren't both <= 0 or > 0
 */
function dateRangeOptions(start, stop) {
    if (start <= 0 && stop <= 0) {
        start = new Date().getFullYear() + start;
        stop = new Date().getFullYear() + stop;
    }
    else if (start < 0 || stop < 0) {
        throw new Error(`Both start (${start}) and stop (${stop}) must both be <= 0 or > 0, got one of each`);
    }
    if (start > stop) {
        return dateRangeOptions(stop, start).reverse();
    }
    const options = [];
    for (let i = start; i <= stop; i++) {
        options.push({ value: i, label: (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(i, 2) });
    }
    return options;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/deepEquals.js":
/*!********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/deepEquals.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ deepEquals)
/* harmony export */ });
/* harmony import */ var fast_equals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! fast-equals */ "../../node_modules/fast-equals/dist/esm/index.mjs");

/** Check if all parameters are typeof function.
 *
 * @param a - The first element to check typeof
 * @param b - The second element to check typeof
 * @returns - if typeof a and b are equal to function return true, otherwise false
 */
function isFunctions(a, b) {
    return typeof a === 'function' && typeof b === 'function';
}
/** Implements a deep equals using the `fast-equal.createCustomEqual` function, that provides a customized comparator that
 * assumes all functions in objects are equivalent.
 *
 * @param a - The first element to compare
 * @param b - The second element to compare
 * @returns - True if the `a` and `b` are deeply equal, false otherwise
 */
const customDeepEqual = (0,fast_equals__WEBPACK_IMPORTED_MODULE_0__.createCustomEqual)({
    createInternalComparator: (comparator) => {
        return (a, b, _idxA, _idxB, _parentA, _parentB, state) => {
            if (isFunctions(a, b)) {
                // Assume all functions are equivalent
                // see https://github.com/rjsf-team/react-jsonschema-form/issues/255
                return true;
            }
            return comparator(a, b, state);
        };
    },
});
/** Implements a deep equals using the `fast-equal.createCustomEqual` function, that provides a customized comparator that
 * assumes all functions are equivalent.
 *
 * @param a - The first element to compare
 * @param b - The second element to compare
 * @returns - True if the `a` and `b` are deeply equal, false otherwise
 */
function deepEquals(a, b) {
    if (isFunctions(a, b)) {
        return true;
    }
    return customDeepEqual(a, b);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/englishStringTranslator.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/englishStringTranslator.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ englishStringTranslator)
/* harmony export */ });
/* harmony import */ var _replaceStringParameters__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./replaceStringParameters */ "../../node_modules/@rjsf/utils/lib/replaceStringParameters.js");

/** Translates a `TranslatableString` value `stringToTranslate` into english. When a `params` array is provided, each
 * value in the array is used to replace any of the replaceable parameters in the `stringToTranslate` using the `%1`,
 * `%2`, etc. replacement specifiers.
 *
 * @param stringToTranslate - The `TranslatableString` value to convert to english
 * @param params - The optional list of replaceable parameter values to substitute into the english string
 * @returns - The `stringToTranslate` itself with any replaceable parameter values substituted
 */
function englishStringTranslator(stringToTranslate, params) {
    return (0,_replaceStringParameters__WEBPACK_IMPORTED_MODULE_0__["default"])(stringToTranslate, params);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/enumOptionsDeselectValue.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/enumOptionsDeselectValue.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ enumOptionsDeselectValue)
/* harmony export */ });
/* harmony import */ var _enumOptionsValueForIndex__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./enumOptionsValueForIndex */ "../../node_modules/@rjsf/utils/lib/enumOptionsValueForIndex.js");
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");


/** Removes the enum option value at the `valueIndex` from the currently `selected` (list of) value(s). If `selected` is
 * a list, then that list is updated to remove the enum option value with the `valueIndex` in `allEnumOptions`. If it is
 * a single value, then if the enum option value with the `valueIndex` in `allEnumOptions` matches `selected`, undefined
 * is returned, otherwise the `selected` value is returned.
 *
 * @param valueIndex - The index of the value to be removed from the selected list or single value
 * @param selected - The current (list of) selected value(s)
 * @param [allEnumOptions=[]] - The list of all the known enumOptions
 * @returns - The updated `selected` with the enum option value at `valueIndex` in `allEnumOptions` removed from it,
 *        unless `selected` is a single value. In that case, if the `valueIndex` value matches `selected`, returns
 *        undefined, otherwise `selected`.
 */
function enumOptionsDeselectValue(valueIndex, selected, allEnumOptions = []) {
    const value = (0,_enumOptionsValueForIndex__WEBPACK_IMPORTED_MODULE_0__["default"])(valueIndex, allEnumOptions);
    if (Array.isArray(selected)) {
        return selected.filter((v) => !(0,_deepEquals__WEBPACK_IMPORTED_MODULE_1__["default"])(v, value));
    }
    return (0,_deepEquals__WEBPACK_IMPORTED_MODULE_1__["default"])(value, selected) ? undefined : selected;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/enumOptionsIndexForValue.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/enumOptionsIndexForValue.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ enumOptionsIndexForValue)
/* harmony export */ });
/* harmony import */ var _enumOptionsIsSelected__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./enumOptionsIsSelected */ "../../node_modules/@rjsf/utils/lib/enumOptionsIsSelected.js");

/** Returns the index(es) of the options in `allEnumOptions` whose value(s) match the ones in `value`. All the
 * `enumOptions` are filtered based on whether they are a "selected" `value` and the index of each selected one is then
 * stored in an array. If `multiple` is true, that array is returned, otherwise the first element in the array is
 * returned.
 *
 * @param value - The single value or list of values for which indexes are desired
 * @param [allEnumOptions=[]] - The list of all the known enumOptions
 * @param [multiple=false] - Optional flag, if true will return a list of index, otherwise a single one
 * @returns - A single string index for the first `value` in `allEnumOptions`, if not `multiple`. Otherwise, the list
 *        of indexes for (each of) the value(s) in `value`.
 */
function enumOptionsIndexForValue(value, allEnumOptions = [], multiple = false) {
    const selectedIndexes = allEnumOptions
        .map((opt, index) => ((0,_enumOptionsIsSelected__WEBPACK_IMPORTED_MODULE_0__["default"])(opt.value, value) ? String(index) : undefined))
        .filter((opt) => typeof opt !== 'undefined');
    if (!multiple) {
        return selectedIndexes[0];
    }
    return selectedIndexes;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/enumOptionsIsSelected.js":
/*!*******************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/enumOptionsIsSelected.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ enumOptionsIsSelected)
/* harmony export */ });
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");

/** Determines whether the given `value` is (one of) the `selected` value(s).
 *
 * @param value - The value being checked to see if it is selected
 * @param selected - The current selected value or list of values
 * @returns - true if the `value` is one of the `selected` ones, false otherwise
 */
function enumOptionsIsSelected(value, selected) {
    if (Array.isArray(selected)) {
        return selected.some((sel) => (0,_deepEquals__WEBPACK_IMPORTED_MODULE_0__["default"])(sel, value));
    }
    return (0,_deepEquals__WEBPACK_IMPORTED_MODULE_0__["default"])(selected, value);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/enumOptionsSelectValue.js":
/*!********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/enumOptionsSelectValue.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ enumOptionsSelectValue)
/* harmony export */ });
/* harmony import */ var _enumOptionsValueForIndex__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./enumOptionsValueForIndex */ "../../node_modules/@rjsf/utils/lib/enumOptionsValueForIndex.js");
/* harmony import */ var lodash_isNil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/isNil */ "../../node_modules/lodash/isNil.js");
/* harmony import */ var lodash_isNil__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_isNil__WEBPACK_IMPORTED_MODULE_1__);


/** Add the enum option value at the `valueIndex` to the list of `selected` values in the proper order as defined by
 * `allEnumOptions`
 *
 * @param valueIndex - The index of the value that should be selected
 * @param selected - The current list of selected values
 * @param [allEnumOptions=[]] - The list of all the known enumOptions
 * @returns - The updated list of selected enum values with enum value at the `valueIndex` added to it
 */
function enumOptionsSelectValue(valueIndex, selected, allEnumOptions = []) {
    const value = (0,_enumOptionsValueForIndex__WEBPACK_IMPORTED_MODULE_0__["default"])(valueIndex, allEnumOptions);
    if (!lodash_isNil__WEBPACK_IMPORTED_MODULE_1___default()(value)) {
        const index = allEnumOptions.findIndex((opt) => value === opt.value);
        const all = allEnumOptions.map(({ value: val }) => val);
        const updated = selected.slice(0, index).concat(value, selected.slice(index));
        // As inserting values at predefined index positions doesn't work with empty
        // arrays, we need to reorder the updated selection to match the initial order
        return updated.sort((a, b) => Number(all.indexOf(a) > all.indexOf(b)));
    }
    return selected;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/enumOptionsValueForIndex.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/enumOptionsValueForIndex.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ enumOptionsValueForIndex)
/* harmony export */ });
/** Returns the value(s) from `allEnumOptions` at the index(es) provided by `valueIndex`. If `valueIndex` is not an
 * array AND the index is not valid for `allEnumOptions`, `emptyValue` is returned. If `valueIndex` is an array, AND it
 * contains an invalid index, the returned array will have the resulting undefined values filtered out, leaving only
 * valid values or in the worst case, an empty array.
 *
 * @param valueIndex - The index(es) of the value(s) that should be returned
 * @param [allEnumOptions=[]] - The list of all the known enumOptions
 * @param [emptyValue] - The value to return when the non-array `valueIndex` does not refer to a real option
 * @returns - The single or list of values specified by the single or list of indexes if they are valid. Otherwise,
 *        `emptyValue` or an empty list.
 */
function enumOptionsValueForIndex(valueIndex, allEnumOptions = [], emptyValue) {
    if (Array.isArray(valueIndex)) {
        return (valueIndex
            .map((index) => enumOptionsValueForIndex(index, allEnumOptions))
            // Since the recursive call returns `emptyValue` when we get a bad option, only filter those out
            .filter((val) => val !== emptyValue));
    }
    // So Number(null) and Number('') both return 0, so use emptyValue for those two values
    const index = valueIndex === '' || valueIndex === null ? -1 : Number(valueIndex);
    const option = allEnumOptions[index];
    return option ? option.value : emptyValue;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/enums.js":
/*!***************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/enums.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   TranslatableString: () => (/* binding */ TranslatableString)
/* harmony export */ });
/** An enumeration of all the translatable strings used by `@rjsf/core` and its themes. The value of each of the
 * enumeration keys is expected to be the actual english string. Some strings contain replaceable parameter values
 * as indicated by `%1`, `%2`, etc. The number after the `%` indicates the order of the parameter. The ordering of
 * parameters is important because some languages may choose to put the second parameter before the first in its
 * translation. Also, some strings are rendered using `markdown-to-jsx` and thus support markdown and inline html.
 */
var TranslatableString;
(function (TranslatableString) {
    /** Fallback title of an array item, used by ArrayField */
    TranslatableString["ArrayItemTitle"] = "Item";
    /** Missing items reason, used by ArrayField */
    TranslatableString["MissingItems"] = "Missing items definition";
    /** Yes label, used by BooleanField */
    TranslatableString["YesLabel"] = "Yes";
    /** No label, used by BooleanField */
    TranslatableString["NoLabel"] = "No";
    /** Close label, used by ErrorList */
    TranslatableString["CloseLabel"] = "Close";
    /** Errors label, used by ErrorList */
    TranslatableString["ErrorsLabel"] = "Errors";
    /** New additionalProperties string default value, used by ObjectField */
    TranslatableString["NewStringDefault"] = "New Value";
    /** Add button title, used by AddButton */
    TranslatableString["AddButton"] = "Add";
    /** Add button title, used by AddButton */
    TranslatableString["AddItemButton"] = "Add Item";
    /** Copy button title, used by IconButton */
    TranslatableString["CopyButton"] = "Copy";
    /** Move down button title, used by IconButton */
    TranslatableString["MoveDownButton"] = "Move down";
    /** Move up button title, used by IconButton */
    TranslatableString["MoveUpButton"] = "Move up";
    /** Remove button title, used by IconButton */
    TranslatableString["RemoveButton"] = "Remove";
    /** Now label, used by AltDateWidget */
    TranslatableString["NowLabel"] = "Now";
    /** Clear label, used by AltDateWidget */
    TranslatableString["ClearLabel"] = "Clear";
    /** Aria date label, used by DateWidget */
    TranslatableString["AriaDateLabel"] = "Select a date";
    /** File preview label, used by FileWidget */
    TranslatableString["PreviewLabel"] = "Preview";
    /** Decrement button aria label, used by UpDownWidget */
    TranslatableString["DecrementAriaLabel"] = "Decrease value by 1";
    /** Increment button aria label, used by UpDownWidget */
    TranslatableString["IncrementAriaLabel"] = "Increase value by 1";
    // Strings with replaceable parameters
    /** Unknown field type reason, where %1 will be replaced with the type as provided by SchemaField */
    TranslatableString["UnknownFieldType"] = "Unknown field type %1";
    /** Option prefix, where %1 will be replaced with the option index as provided by MultiSchemaField */
    TranslatableString["OptionPrefix"] = "Option %1";
    /** Option prefix, where %1 and %2 will be replaced by the schema title and option index, respectively as provided by
     * MultiSchemaField
     */
    TranslatableString["TitleOptionPrefix"] = "%1 option %2";
    /** Key label, where %1 will be replaced by the label as provided by WrapIfAdditionalTemplate */
    TranslatableString["KeyLabel"] = "%1 Key";
    // Strings with replaceable parameters AND/OR that support markdown and html
    /** Invalid object field configuration as provided by the ObjectField.
     * NOTE: Use markdown notation rather than html tags.
     */
    TranslatableString["InvalidObjectField"] = "Invalid \"%1\" object field configuration: _%2_.";
    /** Unsupported field schema, used by UnsupportedField */
    TranslatableString["UnsupportedField"] = "Unsupported field schema.";
    /** Unsupported field schema, where %1 will be replaced by the idSchema.$id as provided by UnsupportedField.
     * NOTE: Use markdown notation rather than html tags.
     */
    TranslatableString["UnsupportedFieldWithId"] = "Unsupported field schema for field `%1`.";
    /** Unsupported field schema, where %1 will be replaced by the reason string as provided by UnsupportedField.
     * NOTE: Use markdown notation rather than html tags.
     */
    TranslatableString["UnsupportedFieldWithReason"] = "Unsupported field schema: _%1_.";
    /** Unsupported field schema, where %1 and %2 will be replaced by the idSchema.$id and reason strings, respectively,
     * as provided by UnsupportedField.
     * NOTE: Use markdown notation rather than html tags.
     */
    TranslatableString["UnsupportedFieldWithIdAndReason"] = "Unsupported field schema for field `%1`: _%2_.";
    /** File name, type and size info, where %1, %2 and %3 will be replaced by the file name, file type and file size as
     * provided by FileWidget
     */
    TranslatableString["FilesInfo"] = "**%1** (%2, %3 bytes)";
})(TranslatableString || (TranslatableString = {}));


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/findSchemaDefinition.js":
/*!******************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/findSchemaDefinition.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ findSchemaDefinition),
/* harmony export */   findSchemaDefinitionRecursive: () => (/* binding */ findSchemaDefinitionRecursive),
/* harmony export */   splitKeyElementFromObject: () => (/* binding */ splitKeyElementFromObject)
/* harmony export */ });
/* harmony import */ var jsonpointer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! jsonpointer */ "../../node_modules/jsonpointer/jsonpointer.js");
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/omit */ "../../node_modules/lodash/omit.js");
/* harmony import */ var lodash_omit__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_omit__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");



/** Splits out the value at the `key` in `object` from the `object`, returning an array that contains in the first
 * location, the `object` minus the `key: value` and in the second location the `value`.
 *
 * @param key - The key from the object to extract
 * @param object - The object from which to extract the element
 * @returns - An array with the first value being the object minus the `key` element and the second element being the
 *      value from `object[key]`
 */
function splitKeyElementFromObject(key, object) {
    const value = object[key];
    const remaining = lodash_omit__WEBPACK_IMPORTED_MODULE_1___default()(object, [key]);
    return [remaining, value];
}
/** Given the name of a `$ref` from within a schema, using the `rootSchema`, recursively look up and return the
 * sub-schema using the path provided by that reference. If `#` is not the first character of the reference, the path
 * does not exist in the schema, or the reference resolves circularly back to itself, then throw an Error.
 * Otherwise return the sub-schema. Also deals with nested `$ref`s in the sub-schema.
 *
 * @param $ref - The ref string for which the schema definition is desired
 * @param [rootSchema={}] - The root schema in which to search for the definition
 * @param recurseList - List of $refs already resolved to prevent recursion
 * @returns - The sub-schema within the `rootSchema` which matches the `$ref` if it exists
 * @throws - Error indicating that no schema for that reference could be resolved
 */
function findSchemaDefinitionRecursive($ref, rootSchema = {}, recurseList = []) {
    const ref = $ref || '';
    let decodedRef;
    if (ref.startsWith('#')) {
        // Decode URI fragment representation.
        decodedRef = decodeURIComponent(ref.substring(1));
    }
    else {
        throw new Error(`Could not find a definition for ${$ref}.`);
    }
    const current = jsonpointer__WEBPACK_IMPORTED_MODULE_0__.get(rootSchema, decodedRef);
    if (current === undefined) {
        throw new Error(`Could not find a definition for ${$ref}.`);
    }
    const nextRef = current[_constants__WEBPACK_IMPORTED_MODULE_2__.REF_KEY];
    if (nextRef) {
        // Check for circular references.
        if (recurseList.includes(nextRef)) {
            if (recurseList.length === 1) {
                throw new Error(`Definition for ${$ref} is a circular reference`);
            }
            const [firstRef, ...restRefs] = recurseList;
            const circularPath = [...restRefs, ref, firstRef].join(' -> ');
            throw new Error(`Definition for ${firstRef} contains a circular reference through ${circularPath}`);
        }
        const [remaining, theRef] = splitKeyElementFromObject(_constants__WEBPACK_IMPORTED_MODULE_2__.REF_KEY, current);
        const subSchema = findSchemaDefinitionRecursive(theRef, rootSchema, [...recurseList, ref]);
        if (Object.keys(remaining).length > 0) {
            return { ...remaining, ...subSchema };
        }
        return subSchema;
    }
    return current;
}
/** Given the name of a `$ref` from within a schema, using the `rootSchema`, look up and return the sub-schema using the
 * path provided by that reference. If `#` is not the first character of the reference, the path does not exist in
 * the schema, or the reference resolves circularly back to itself, then throw an Error. Otherwise return the
 * sub-schema. Also deals with nested `$ref`s in the sub-schema.
 *
 * @param $ref - The ref string for which the schema definition is desired
 * @param [rootSchema={}] - The root schema in which to search for the definition
 * @returns - The sub-schema within the `rootSchema` which matches the `$ref` if it exists
 * @throws - Error indicating that no schema for that reference could be resolved
 */
function findSchemaDefinition($ref, rootSchema = {}) {
    const recurseList = [];
    return findSchemaDefinitionRecursive($ref, rootSchema, recurseList);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/getDateElementProps.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/getDateElementProps.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getDateElementProps)
/* harmony export */ });
/** Given date & time information with optional yearRange & format, returns props for DateElement
 *
 * @param date - Object containing date with optional time information
 * @param time - Determines whether to include time or not
 * @param [yearRange=[1900, new Date().getFullYear() + 2]] - Controls the list of years to be displayed
 * @param [format='YMD'] - Controls the order in which day, month and year input element will be displayed
 * @returns Array of props for DateElement
 */
function getDateElementProps(date, time, yearRange = [1900, new Date().getFullYear() + 2], format = 'YMD') {
    const { day, month, year, hour, minute, second } = date;
    const dayObj = { type: 'day', range: [1, 31], value: day };
    const monthObj = { type: 'month', range: [1, 12], value: month };
    const yearObj = { type: 'year', range: yearRange, value: year };
    const dateElementProp = [];
    switch (format) {
        case 'MDY':
            dateElementProp.push(monthObj, dayObj, yearObj);
            break;
        case 'DMY':
            dateElementProp.push(dayObj, monthObj, yearObj);
            break;
        case 'YMD':
        default:
            dateElementProp.push(yearObj, monthObj, dayObj);
    }
    if (time) {
        dateElementProp.push({ type: 'hour', range: [0, 23], value: hour }, { type: 'minute', range: [0, 59], value: minute }, { type: 'second', range: [0, 59], value: second });
    }
    return dateElementProp;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/getDiscriminatorFieldFromSchema.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/getDiscriminatorFieldFromSchema.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getDiscriminatorFieldFromSchema)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_isString__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/isString */ "../../node_modules/lodash/isString.js");
/* harmony import */ var lodash_isString__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_isString__WEBPACK_IMPORTED_MODULE_1__);


/** Returns the `discriminator.propertyName` when defined in the `schema` if it is a string. A warning is generated when
 * it is not a string. Returns `undefined` when a valid discriminator is not present.
 *
 * @param schema - The schema from which the discriminator is potentially obtained
 * @returns - The `discriminator.propertyName` if it exists in the schema, otherwise `undefined`
 */
function getDiscriminatorFieldFromSchema(schema) {
    let discriminator;
    const maybeString = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(schema, 'discriminator.propertyName', undefined);
    if (lodash_isString__WEBPACK_IMPORTED_MODULE_1___default()(maybeString)) {
        discriminator = maybeString;
    }
    else if (maybeString !== undefined) {
        console.warn(`Expecting discriminator to be a string, got "${typeof maybeString}" instead`);
    }
    return discriminator;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/getInputProps.js":
/*!***********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/getInputProps.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getInputProps)
/* harmony export */ });
/* harmony import */ var _rangeSpec__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./rangeSpec */ "../../node_modules/@rjsf/utils/lib/rangeSpec.js");

/** Using the `schema`, `defaultType` and `options`, extract out the props for the <input> element that make sense.
 *
 * @param schema - The schema for the field provided by the widget
 * @param [defaultType] - The default type, if any, for the field provided by the widget
 * @param [options={}] - The UI Options for the field provided by the widget
 * @param [autoDefaultStepAny=true] - Determines whether to auto-default step=any when the type is number and no step
 * @returns - The extracted `InputPropsType` object
 */
function getInputProps(schema, defaultType, options = {}, autoDefaultStepAny = true) {
    const inputProps = {
        type: defaultType || 'text',
        ...(0,_rangeSpec__WEBPACK_IMPORTED_MODULE_0__["default"])(schema),
    };
    // If options.inputType is set use that as the input type
    if (options.inputType) {
        inputProps.type = options.inputType;
    }
    else if (!defaultType) {
        // If the schema is of type number or integer, set the input type to number
        if (schema.type === 'number') {
            inputProps.type = 'number';
            // Only add step if one isn't already defined and we are auto-defaulting the "any" step
            if (autoDefaultStepAny && inputProps.step === undefined) {
                // Setting step to 'any' fixes a bug in Safari where decimals are not
                // allowed in number inputs
                inputProps.step = 'any';
            }
        }
        else if (schema.type === 'integer') {
            inputProps.type = 'number';
            // Only add step if one isn't already defined
            if (inputProps.step === undefined) {
                // Since this is integer, you always want to step up or down in multiples of 1
                inputProps.step = 1;
            }
        }
    }
    if (options.autocomplete) {
        inputProps.autoComplete = options.autocomplete;
    }
    return inputProps;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/getOptionMatchingSimpleDiscriminator.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/getOptionMatchingSimpleDiscriminator.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getOptionMatchingSimpleDiscriminator)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");


/** Compares the value of `discriminatorField` within `formData` against the value of `discriminatorField` within schema for each `option`.
 * Returns index of first `option` whose discriminator matches formData. Returns `undefined` if there is no match.
 * This function does not work with discriminators of `"type": "object"` and `"type": "array"`
 *
 * @param formData - The current formData, if any, used to figure out a match
 * @param options - The list of options to find a matching options from
 * @param [discriminatorField] - The optional name of the field within the options object whose value is used to
 *          determine which option is selected
 * @returns - The index of the matched option or undefined if there is no match
 */
function getOptionMatchingSimpleDiscriminator(formData, options, discriminatorField) {
    var _a;
    if (formData && discriminatorField) {
        const value = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, discriminatorField);
        if (value === undefined) {
            return;
        }
        for (let i = 0; i < options.length; i++) {
            const option = options[i];
            const discriminator = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(option, [_constants__WEBPACK_IMPORTED_MODULE_1__.PROPERTIES_KEY, discriminatorField], {});
            if (discriminator.type === 'object' || discriminator.type === 'array') {
                continue;
            }
            if (discriminator.const === value) {
                return i;
            }
            if ((_a = discriminator.enum) === null || _a === void 0 ? void 0 : _a.includes(value)) {
                return i;
            }
        }
    }
    return;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/getSchemaType.js":
/*!***********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/getSchemaType.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getSchemaType)
/* harmony export */ });
/* harmony import */ var _guessType__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./guessType */ "../../node_modules/@rjsf/utils/lib/guessType.js");

/** Gets the type of a given `schema`. If the type is not explicitly defined, then an attempt is made to infer it from
 * other elements of the schema as follows:
 * - schema.const: Returns the `guessType()` of that value
 * - schema.enum: Returns `string`
 * - schema.properties: Returns `object`
 * - schema.additionalProperties: Returns `object`
 * - type is an array with a length of 2 and one type is 'null': Returns the other type
 *
 * @param schema - The schema for which to get the type
 * @returns - The type of the schema
 */
function getSchemaType(schema) {
    let { type } = schema;
    if (!type && schema.const) {
        return (0,_guessType__WEBPACK_IMPORTED_MODULE_0__["default"])(schema.const);
    }
    if (!type && schema.enum) {
        return 'string';
    }
    if (!type && (schema.properties || schema.additionalProperties)) {
        return 'object';
    }
    if (Array.isArray(type)) {
        if (type.length === 2 && type.includes('null')) {
            type = type.find((type) => type !== 'null');
        }
        else {
            type = type[0];
        }
    }
    return type;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/getSubmitButtonOptions.js":
/*!********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/getSubmitButtonOptions.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DEFAULT_OPTIONS: () => (/* binding */ DEFAULT_OPTIONS),
/* harmony export */   "default": () => (/* binding */ getSubmitButtonOptions)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _getUiOptions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getUiOptions */ "../../node_modules/@rjsf/utils/lib/getUiOptions.js");


/** The default submit button options, exported for testing purposes
 */
const DEFAULT_OPTIONS = {
    props: {
        disabled: false,
    },
    submitText: 'Submit',
    norender: false,
};
/** Extracts any `ui:submitButtonOptions` from the `uiSchema` and merges them onto the `DEFAULT_OPTIONS`
 *
 * @param [uiSchema={}] - the UI Schema from which to extract submit button props
 * @returns - The merging of the `DEFAULT_OPTIONS` with any custom ones
 */
function getSubmitButtonOptions(uiSchema = {}) {
    const uiOptions = (0,_getUiOptions__WEBPACK_IMPORTED_MODULE_1__["default"])(uiSchema);
    if (uiOptions && uiOptions[_constants__WEBPACK_IMPORTED_MODULE_0__.SUBMIT_BTN_OPTIONS_KEY]) {
        const options = uiOptions[_constants__WEBPACK_IMPORTED_MODULE_0__.SUBMIT_BTN_OPTIONS_KEY];
        return { ...DEFAULT_OPTIONS, ...options };
    }
    return DEFAULT_OPTIONS;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/getTemplate.js":
/*!*********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/getTemplate.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getTemplate)
/* harmony export */ });
/** Returns the template with the given `name` from either the `uiSchema` if it is defined or from the `registry`
 * otherwise. NOTE, since `ButtonTemplates` are not overridden in `uiSchema` only those in the `registry` are returned.
 *
 * @param name - The name of the template to fetch, restricted to the keys of `TemplatesType`
 * @param registry - The `Registry` from which to read the template
 * @param [uiOptions={}] - The `UIOptionsType` from which to read an alternate template
 * @returns - The template from either the `uiSchema` or `registry` for the `name`
 */
function getTemplate(name, registry, uiOptions = {}) {
    const { templates } = registry;
    if (name === 'ButtonTemplates') {
        return templates[name];
    }
    return (
    // Evaluating uiOptions[name] results in TS2590: Expression produces a union type that is too complex to represent
    // To avoid that, we cast uiOptions to `any` before accessing the name field
    uiOptions[name] || templates[name]);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/getUiOptions.js":
/*!**********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/getUiOptions.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getUiOptions)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");


/** Get all passed options from ui:options, and ui:<optionName>, returning them in an object with the `ui:`
 * stripped off. Any `globalOptions` will always be returned, unless they are overridden by options in the `uiSchema`.
 *
 * @param [uiSchema={}] - The UI Schema from which to get any `ui:xxx` options
 * @param [globalOptions={}] - The optional Global UI Schema from which to get any fallback `xxx` options
 * @returns - An object containing all the `ui:xxx` options with the `ui:` stripped off along with all `globalOptions`
 */
function getUiOptions(uiSchema = {}, globalOptions = {}) {
    return Object.keys(uiSchema)
        .filter((key) => key.indexOf('ui:') === 0)
        .reduce((options, key) => {
        const value = uiSchema[key];
        if (key === _constants__WEBPACK_IMPORTED_MODULE_0__.UI_WIDGET_KEY && (0,_isObject__WEBPACK_IMPORTED_MODULE_1__["default"])(value)) {
            console.error('Setting options via ui:widget object is no longer supported, use ui:options instead');
            return options;
        }
        if (key === _constants__WEBPACK_IMPORTED_MODULE_0__.UI_OPTIONS_KEY && (0,_isObject__WEBPACK_IMPORTED_MODULE_1__["default"])(value)) {
            return { ...options, ...value };
        }
        return { ...options, [key.substring(3)]: value };
    }, { ...globalOptions });
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/getWidget.js":
/*!*******************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/getWidget.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getWidget)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react/jsx-runtime */ "../../node_modules/react/jsx-runtime.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react_is__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react-is */ "../../node_modules/@rjsf/utils/node_modules/react-is/index.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/set */ "../../node_modules/lodash/set.js");
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_set__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _getSchemaType__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./getSchemaType */ "../../node_modules/@rjsf/utils/lib/getSchemaType.js");






/** The map of schema types to widget type to widget name
 */
const widgetMap = {
    boolean: {
        checkbox: 'CheckboxWidget',
        radio: 'RadioWidget',
        select: 'SelectWidget',
        hidden: 'HiddenWidget',
    },
    string: {
        text: 'TextWidget',
        password: 'PasswordWidget',
        email: 'EmailWidget',
        hostname: 'TextWidget',
        ipv4: 'TextWidget',
        ipv6: 'TextWidget',
        uri: 'URLWidget',
        'data-url': 'FileWidget',
        radio: 'RadioWidget',
        select: 'SelectWidget',
        textarea: 'TextareaWidget',
        hidden: 'HiddenWidget',
        date: 'DateWidget',
        datetime: 'DateTimeWidget',
        'date-time': 'DateTimeWidget',
        'alt-date': 'AltDateWidget',
        'alt-datetime': 'AltDateTimeWidget',
        time: 'TimeWidget',
        color: 'ColorWidget',
        file: 'FileWidget',
    },
    number: {
        text: 'TextWidget',
        select: 'SelectWidget',
        updown: 'UpDownWidget',
        range: 'RangeWidget',
        radio: 'RadioWidget',
        hidden: 'HiddenWidget',
    },
    integer: {
        text: 'TextWidget',
        select: 'SelectWidget',
        updown: 'UpDownWidget',
        range: 'RangeWidget',
        radio: 'RadioWidget',
        hidden: 'HiddenWidget',
    },
    array: {
        select: 'SelectWidget',
        checkboxes: 'CheckboxesWidget',
        files: 'FileWidget',
        hidden: 'HiddenWidget',
    },
};
/** Wraps the given widget with stateless functional component that will merge any `defaultProps.options` with the
 * `options` that are provided in the props. It will add the wrapper component as a `MergedWidget` property onto the
 * `Widget` so that future attempts to wrap `AWidget` will return the already existing wrapper.
 *
 * @param AWidget - A widget that will be wrapped or one that is already wrapped
 * @returns - The wrapper widget
 */
function mergeWidgetOptions(AWidget) {
    let MergedWidget = lodash_get__WEBPACK_IMPORTED_MODULE_3___default()(AWidget, 'MergedWidget');
    // cache return value as property of widget for proper react reconciliation
    if (!MergedWidget) {
        const defaultOptions = (AWidget.defaultProps && AWidget.defaultProps.options) || {};
        MergedWidget = ({ options, ...props }) => {
            return (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(AWidget, { options: { ...defaultOptions, ...options }, ...props });
        };
        lodash_set__WEBPACK_IMPORTED_MODULE_4___default()(AWidget, 'MergedWidget', MergedWidget);
    }
    return MergedWidget;
}
/** Given a schema representing a field to render and either the name or actual `Widget` implementation, returns the
 * React component that is used to render the widget. If the `widget` is already a React component, then it is wrapped
 * with a `MergedWidget`. Otherwise an attempt is made to look up the widget inside of the `registeredWidgets` map based
 * on the schema type and `widget` name. If no widget component can be found an `Error` is thrown.
 *
 * @param schema - The schema for the field
 * @param [widget] - Either the name of the widget OR a `Widget` implementation to use
 * @param [registeredWidgets={}] - A registry of widget name to `Widget` implementation
 * @returns - The `Widget` component to use
 * @throws - An error if there is no `Widget` component that can be returned
 */
function getWidget(schema, widget, registeredWidgets = {}) {
    const type = (0,_getSchemaType__WEBPACK_IMPORTED_MODULE_5__["default"])(schema);
    if (typeof widget === 'function' ||
        (widget && react_is__WEBPACK_IMPORTED_MODULE_2__.isForwardRef((0,react__WEBPACK_IMPORTED_MODULE_1__.createElement)(widget))) ||
        react_is__WEBPACK_IMPORTED_MODULE_2__.isMemo(widget)) {
        return mergeWidgetOptions(widget);
    }
    if (typeof widget !== 'string') {
        throw new Error(`Unsupported widget definition: ${typeof widget}`);
    }
    if (widget in registeredWidgets) {
        const registeredWidget = registeredWidgets[widget];
        return getWidget(schema, registeredWidget, registeredWidgets);
    }
    if (typeof type === 'string') {
        if (!(type in widgetMap)) {
            throw new Error(`No widget for type '${type}'`);
        }
        if (widget in widgetMap[type]) {
            const registeredWidget = registeredWidgets[widgetMap[type][widget]];
            return getWidget(schema, registeredWidget, registeredWidgets);
        }
    }
    throw new Error(`No widget '${widget}' for type '${type}'`);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/guessType.js":
/*!*******************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/guessType.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ guessType)
/* harmony export */ });
/** Given a specific `value` attempts to guess the type of a schema element. In the case where we have to implicitly
 *  create a schema, it is useful to know what type to use based on the data we are defining.
 *
 * @param value - The value from which to guess the type
 * @returns - The best guess for the object type
 */
function guessType(value) {
    if (Array.isArray(value)) {
        return 'array';
    }
    if (typeof value === 'string') {
        return 'string';
    }
    if (value == null) {
        return 'null';
    }
    if (typeof value === 'boolean') {
        return 'boolean';
    }
    if (!isNaN(value)) {
        return 'number';
    }
    if (typeof value === 'object') {
        return 'object';
    }
    // Default to string if we can't figure it out
    return 'string';
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/hasWidget.js":
/*!*******************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/hasWidget.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ hasWidget)
/* harmony export */ });
/* harmony import */ var _getWidget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWidget */ "../../node_modules/@rjsf/utils/lib/getWidget.js");

/** Detects whether the `widget` exists for the `schema` with the associated `registryWidgets` and returns true if it
 * does, or false if it doesn't.
 *
 * @param schema - The schema for the field
 * @param widget - Either the name of the widget OR a `Widget` implementation to use
 * @param [registeredWidgets={}] - A registry of widget name to `Widget` implementation
 * @returns - True if the widget exists, false otherwise
 */
function hasWidget(schema, widget, registeredWidgets = {}) {
    try {
        (0,_getWidget__WEBPACK_IMPORTED_MODULE_0__["default"])(schema, widget, registeredWidgets);
        return true;
    }
    catch (e) {
        const err = e;
        if (err.message && (err.message.startsWith('No widget') || err.message.startsWith('Unsupported widget'))) {
            return false;
        }
        throw e;
    }
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/hashForSchema.js":
/*!***********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/hashForSchema.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ hashForSchema)
/* harmony export */ });
/** JS has no built-in hashing function, so rolling our own
 *  based on Java's hashing fn:
 *  http://www.java2s.com/example/nodejs-utility-method/string-hash/hashcode-4dc2b.html
 *
 * @param string - The string for which to get the hash
 * @returns - The resulting hash of the string in hex format
 */
function hashString(string) {
    let hash = 0;
    for (let i = 0; i < string.length; i += 1) {
        const chr = string.charCodeAt(i);
        hash = (hash << 5) - hash + chr;
        hash = hash & hash; // Convert to 32bit integer
    }
    return hash.toString(16);
}
/** Stringifies the schema and returns the hash of the resulting string. Sorts schema fields
 * in consistent order before stringify to prevent different hash ids for the same schema.
 *
 * @param schema - The schema for which the hash is desired
 * @returns - The string obtained from the hash of the stringified schema
 */
function hashForSchema(schema) {
    const allKeys = new Set();
    // solution source: https://stackoverflow.com/questions/16167581/sort-object-properties-and-json-stringify/53593328#53593328
    JSON.stringify(schema, (key, value) => (allKeys.add(key), value));
    return hashString(JSON.stringify(schema, Array.from(allKeys).sort()));
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/idGenerators.js":
/*!**********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/idGenerators.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ariaDescribedByIds: () => (/* binding */ ariaDescribedByIds),
/* harmony export */   descriptionId: () => (/* binding */ descriptionId),
/* harmony export */   errorId: () => (/* binding */ errorId),
/* harmony export */   examplesId: () => (/* binding */ examplesId),
/* harmony export */   helpId: () => (/* binding */ helpId),
/* harmony export */   optionId: () => (/* binding */ optionId),
/* harmony export */   titleId: () => (/* binding */ titleId)
/* harmony export */ });
/* harmony import */ var lodash_isString__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/isString */ "../../node_modules/lodash/isString.js");
/* harmony import */ var lodash_isString__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_isString__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");


/** Generates a consistent `id` pattern for a given `id` and a `suffix`
 *
 * @param id - Either simple string id or an IdSchema from which to extract it
 * @param suffix - The suffix to append to the id
 */
function idGenerator(id, suffix) {
    const theId = lodash_isString__WEBPACK_IMPORTED_MODULE_0___default()(id) ? id : id[_constants__WEBPACK_IMPORTED_MODULE_1__.ID_KEY];
    return `${theId}__${suffix}`;
}
/** Return a consistent `id` for the field description element
 *
 * @param id - Either simple string id or an IdSchema from which to extract it
 * @returns - The consistent id for the field description element from the given `id`
 */
function descriptionId(id) {
    return idGenerator(id, 'description');
}
/** Return a consistent `id` for the field error element
 *
 * @param id - Either simple string id or an IdSchema from which to extract it
 * @returns - The consistent id for the field error element from the given `id`
 */
function errorId(id) {
    return idGenerator(id, 'error');
}
/** Return a consistent `id` for the field examples element
 *
 * @param id - Either simple string id or an IdSchema from which to extract it
 * @returns - The consistent id for the field examples element from the given `id`
 */
function examplesId(id) {
    return idGenerator(id, 'examples');
}
/** Return a consistent `id` for the field help element
 *
 * @param id - Either simple string id or an IdSchema from which to extract it
 * @returns - The consistent id for the field help element from the given `id`
 */
function helpId(id) {
    return idGenerator(id, 'help');
}
/** Return a consistent `id` for the field title element
 *
 * @param id - Either simple string id or an IdSchema from which to extract it
 * @returns - The consistent id for the field title element from the given `id`
 */
function titleId(id) {
    return idGenerator(id, 'title');
}
/** Return a list of element ids that contain additional information about the field that can be used to as the aria
 * description of the field. This is correctly omitting `titleId` which would be "labeling" rather than "describing" the
 * element.
 *
 * @param id - Either simple string id or an IdSchema from which to extract it
 * @param [includeExamples=false] - Optional flag, if true, will add the `examplesId` into the list
 * @returns - The string containing the list of ids for use in an `aria-describedBy` attribute
 */
function ariaDescribedByIds(id, includeExamples = false) {
    const examples = includeExamples ? ` ${examplesId(id)}` : '';
    return `${errorId(id)} ${descriptionId(id)} ${helpId(id)}${examples}`;
}
/** Return a consistent `id` for the `optionIndex`s of a `Radio` or `Checkboxes` widget
 *
 * @param id - The id of the parent component for the option
 * @param optionIndex - The index of the option for which the id is desired
 * @returns - An id for the option index based on the parent `id`
 */
function optionId(id, optionIndex) {
    return `${id}-${optionIndex}`;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/index.js":
/*!***************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ADDITIONAL_PROPERTIES_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ADDITIONAL_PROPERTIES_KEY),
/* harmony export */   ADDITIONAL_PROPERTY_FLAG: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ADDITIONAL_PROPERTY_FLAG),
/* harmony export */   ALL_OF_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ALL_OF_KEY),
/* harmony export */   ANY_OF_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ANY_OF_KEY),
/* harmony export */   CONST_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.CONST_KEY),
/* harmony export */   DEFAULT_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.DEFAULT_KEY),
/* harmony export */   DEFINITIONS_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.DEFINITIONS_KEY),
/* harmony export */   DEPENDENCIES_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.DEPENDENCIES_KEY),
/* harmony export */   ENUM_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ENUM_KEY),
/* harmony export */   ERRORS_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ERRORS_KEY),
/* harmony export */   ErrorSchemaBuilder: () => (/* reexport safe */ _ErrorSchemaBuilder__WEBPACK_IMPORTED_MODULE_14__["default"]),
/* harmony export */   ID_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ID_KEY),
/* harmony export */   IF_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.IF_KEY),
/* harmony export */   ITEMS_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ITEMS_KEY),
/* harmony export */   JUNK_OPTION_ID: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.JUNK_OPTION_ID),
/* harmony export */   NAME_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.NAME_KEY),
/* harmony export */   ONE_OF_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ONE_OF_KEY),
/* harmony export */   PROPERTIES_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.PROPERTIES_KEY),
/* harmony export */   REF_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.REF_KEY),
/* harmony export */   REQUIRED_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.REQUIRED_KEY),
/* harmony export */   RJSF_ADDITIONAL_PROPERTIES_FLAG: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.RJSF_ADDITIONAL_PROPERTIES_FLAG),
/* harmony export */   RJSF_ADDITONAL_PROPERTIES_FLAG: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.RJSF_ADDITONAL_PROPERTIES_FLAG),
/* harmony export */   ROOT_SCHEMA_PREFIX: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.ROOT_SCHEMA_PREFIX),
/* harmony export */   SUBMIT_BTN_OPTIONS_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.SUBMIT_BTN_OPTIONS_KEY),
/* harmony export */   TranslatableString: () => (/* reexport safe */ _enums__WEBPACK_IMPORTED_MODULE_55__.TranslatableString),
/* harmony export */   UI_FIELD_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.UI_FIELD_KEY),
/* harmony export */   UI_GLOBAL_OPTIONS_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.UI_GLOBAL_OPTIONS_KEY),
/* harmony export */   UI_OPTIONS_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.UI_OPTIONS_KEY),
/* harmony export */   UI_WIDGET_KEY: () => (/* reexport safe */ _constants__WEBPACK_IMPORTED_MODULE_56__.UI_WIDGET_KEY),
/* harmony export */   allowAdditionalItems: () => (/* reexport safe */ _allowAdditionalItems__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   ariaDescribedByIds: () => (/* reexport safe */ _idGenerators__WEBPACK_IMPORTED_MODULE_27__.ariaDescribedByIds),
/* harmony export */   asNumber: () => (/* reexport safe */ _asNumber__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   canExpand: () => (/* reexport safe */ _canExpand__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   createErrorHandler: () => (/* reexport safe */ _createErrorHandler__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   createSchemaUtils: () => (/* reexport safe */ _createSchemaUtils__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   dataURItoBlob: () => (/* reexport safe */ _dataURItoBlob__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   dateRangeOptions: () => (/* reexport safe */ _dateRangeOptions__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   deepEquals: () => (/* reexport safe */ _deepEquals__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   descriptionId: () => (/* reexport safe */ _idGenerators__WEBPACK_IMPORTED_MODULE_27__.descriptionId),
/* harmony export */   englishStringTranslator: () => (/* reexport safe */ _englishStringTranslator__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   enumOptionsDeselectValue: () => (/* reexport safe */ _enumOptionsDeselectValue__WEBPACK_IMPORTED_MODULE_9__["default"]),
/* harmony export */   enumOptionsIndexForValue: () => (/* reexport safe */ _enumOptionsIndexForValue__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   enumOptionsIsSelected: () => (/* reexport safe */ _enumOptionsIsSelected__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   enumOptionsSelectValue: () => (/* reexport safe */ _enumOptionsSelectValue__WEBPACK_IMPORTED_MODULE_12__["default"]),
/* harmony export */   enumOptionsValueForIndex: () => (/* reexport safe */ _enumOptionsValueForIndex__WEBPACK_IMPORTED_MODULE_13__["default"]),
/* harmony export */   errorId: () => (/* reexport safe */ _idGenerators__WEBPACK_IMPORTED_MODULE_27__.errorId),
/* harmony export */   examplesId: () => (/* reexport safe */ _idGenerators__WEBPACK_IMPORTED_MODULE_27__.examplesId),
/* harmony export */   findSchemaDefinition: () => (/* reexport safe */ _findSchemaDefinition__WEBPACK_IMPORTED_MODULE_15__["default"]),
/* harmony export */   getClosestMatchingOption: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.getClosestMatchingOption),
/* harmony export */   getDateElementProps: () => (/* reexport safe */ _getDateElementProps__WEBPACK_IMPORTED_MODULE_16__["default"]),
/* harmony export */   getDefaultFormState: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.getDefaultFormState),
/* harmony export */   getDiscriminatorFieldFromSchema: () => (/* reexport safe */ _getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_17__["default"]),
/* harmony export */   getDisplayLabel: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.getDisplayLabel),
/* harmony export */   getFirstMatchingOption: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.getFirstMatchingOption),
/* harmony export */   getInputProps: () => (/* reexport safe */ _getInputProps__WEBPACK_IMPORTED_MODULE_18__["default"]),
/* harmony export */   getMatchingOption: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.getMatchingOption),
/* harmony export */   getOptionMatchingSimpleDiscriminator: () => (/* reexport safe */ _getOptionMatchingSimpleDiscriminator__WEBPACK_IMPORTED_MODULE_53__["default"]),
/* harmony export */   getSchemaType: () => (/* reexport safe */ _getSchemaType__WEBPACK_IMPORTED_MODULE_19__["default"]),
/* harmony export */   getSubmitButtonOptions: () => (/* reexport safe */ _getSubmitButtonOptions__WEBPACK_IMPORTED_MODULE_20__["default"]),
/* harmony export */   getTemplate: () => (/* reexport safe */ _getTemplate__WEBPACK_IMPORTED_MODULE_21__["default"]),
/* harmony export */   getUiOptions: () => (/* reexport safe */ _getUiOptions__WEBPACK_IMPORTED_MODULE_22__["default"]),
/* harmony export */   getWidget: () => (/* reexport safe */ _getWidget__WEBPACK_IMPORTED_MODULE_23__["default"]),
/* harmony export */   guessType: () => (/* reexport safe */ _guessType__WEBPACK_IMPORTED_MODULE_24__["default"]),
/* harmony export */   hasWidget: () => (/* reexport safe */ _hasWidget__WEBPACK_IMPORTED_MODULE_26__["default"]),
/* harmony export */   hashForSchema: () => (/* reexport safe */ _hashForSchema__WEBPACK_IMPORTED_MODULE_25__["default"]),
/* harmony export */   helpId: () => (/* reexport safe */ _idGenerators__WEBPACK_IMPORTED_MODULE_27__.helpId),
/* harmony export */   isConstant: () => (/* reexport safe */ _isConstant__WEBPACK_IMPORTED_MODULE_28__["default"]),
/* harmony export */   isCustomWidget: () => (/* reexport safe */ _isCustomWidget__WEBPACK_IMPORTED_MODULE_29__["default"]),
/* harmony export */   isFilesArray: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.isFilesArray),
/* harmony export */   isFixedItems: () => (/* reexport safe */ _isFixedItems__WEBPACK_IMPORTED_MODULE_30__["default"]),
/* harmony export */   isMultiSelect: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.isMultiSelect),
/* harmony export */   isObject: () => (/* reexport safe */ _isObject__WEBPACK_IMPORTED_MODULE_31__["default"]),
/* harmony export */   isSelect: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.isSelect),
/* harmony export */   labelValue: () => (/* reexport safe */ _labelValue__WEBPACK_IMPORTED_MODULE_32__["default"]),
/* harmony export */   localToUTC: () => (/* reexport safe */ _localToUTC__WEBPACK_IMPORTED_MODULE_33__["default"]),
/* harmony export */   mergeDefaultsWithFormData: () => (/* reexport safe */ _mergeDefaultsWithFormData__WEBPACK_IMPORTED_MODULE_34__["default"]),
/* harmony export */   mergeObjects: () => (/* reexport safe */ _mergeObjects__WEBPACK_IMPORTED_MODULE_35__["default"]),
/* harmony export */   mergeSchemas: () => (/* reexport safe */ _mergeSchemas__WEBPACK_IMPORTED_MODULE_36__["default"]),
/* harmony export */   mergeValidationData: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.mergeValidationData),
/* harmony export */   optionId: () => (/* reexport safe */ _idGenerators__WEBPACK_IMPORTED_MODULE_27__.optionId),
/* harmony export */   optionsList: () => (/* reexport safe */ _optionsList__WEBPACK_IMPORTED_MODULE_37__["default"]),
/* harmony export */   orderProperties: () => (/* reexport safe */ _orderProperties__WEBPACK_IMPORTED_MODULE_38__["default"]),
/* harmony export */   pad: () => (/* reexport safe */ _pad__WEBPACK_IMPORTED_MODULE_39__["default"]),
/* harmony export */   parseDateString: () => (/* reexport safe */ _parseDateString__WEBPACK_IMPORTED_MODULE_40__["default"]),
/* harmony export */   rangeSpec: () => (/* reexport safe */ _rangeSpec__WEBPACK_IMPORTED_MODULE_41__["default"]),
/* harmony export */   replaceStringParameters: () => (/* reexport safe */ _replaceStringParameters__WEBPACK_IMPORTED_MODULE_42__["default"]),
/* harmony export */   retrieveSchema: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.retrieveSchema),
/* harmony export */   sanitizeDataForNewSchema: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.sanitizeDataForNewSchema),
/* harmony export */   schemaParser: () => (/* reexport safe */ _parser__WEBPACK_IMPORTED_MODULE_57__.schemaParser),
/* harmony export */   schemaRequiresTrueValue: () => (/* reexport safe */ _schemaRequiresTrueValue__WEBPACK_IMPORTED_MODULE_43__["default"]),
/* harmony export */   shouldRender: () => (/* reexport safe */ _shouldRender__WEBPACK_IMPORTED_MODULE_44__["default"]),
/* harmony export */   titleId: () => (/* reexport safe */ _idGenerators__WEBPACK_IMPORTED_MODULE_27__.titleId),
/* harmony export */   toConstant: () => (/* reexport safe */ _toConstant__WEBPACK_IMPORTED_MODULE_45__["default"]),
/* harmony export */   toDateString: () => (/* reexport safe */ _toDateString__WEBPACK_IMPORTED_MODULE_46__["default"]),
/* harmony export */   toErrorList: () => (/* reexport safe */ _toErrorList__WEBPACK_IMPORTED_MODULE_47__["default"]),
/* harmony export */   toErrorSchema: () => (/* reexport safe */ _toErrorSchema__WEBPACK_IMPORTED_MODULE_48__["default"]),
/* harmony export */   toIdSchema: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.toIdSchema),
/* harmony export */   toPathSchema: () => (/* reexport safe */ _schema__WEBPACK_IMPORTED_MODULE_58__.toPathSchema),
/* harmony export */   unwrapErrorHandler: () => (/* reexport safe */ _unwrapErrorHandler__WEBPACK_IMPORTED_MODULE_49__["default"]),
/* harmony export */   utcToLocal: () => (/* reexport safe */ _utcToLocal__WEBPACK_IMPORTED_MODULE_50__["default"]),
/* harmony export */   validationDataMerge: () => (/* reexport safe */ _validationDataMerge__WEBPACK_IMPORTED_MODULE_51__["default"]),
/* harmony export */   withIdRefPrefix: () => (/* reexport safe */ _withIdRefPrefix__WEBPACK_IMPORTED_MODULE_52__["default"])
/* harmony export */ });
/* harmony import */ var _allowAdditionalItems__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./allowAdditionalItems */ "../../node_modules/@rjsf/utils/lib/allowAdditionalItems.js");
/* harmony import */ var _asNumber__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./asNumber */ "../../node_modules/@rjsf/utils/lib/asNumber.js");
/* harmony import */ var _canExpand__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./canExpand */ "../../node_modules/@rjsf/utils/lib/canExpand.js");
/* harmony import */ var _createErrorHandler__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./createErrorHandler */ "../../node_modules/@rjsf/utils/lib/createErrorHandler.js");
/* harmony import */ var _createSchemaUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./createSchemaUtils */ "../../node_modules/@rjsf/utils/lib/createSchemaUtils.js");
/* harmony import */ var _dataURItoBlob__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./dataURItoBlob */ "../../node_modules/@rjsf/utils/lib/dataURItoBlob.js");
/* harmony import */ var _dateRangeOptions__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./dateRangeOptions */ "../../node_modules/@rjsf/utils/lib/dateRangeOptions.js");
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");
/* harmony import */ var _englishStringTranslator__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./englishStringTranslator */ "../../node_modules/@rjsf/utils/lib/englishStringTranslator.js");
/* harmony import */ var _enumOptionsDeselectValue__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./enumOptionsDeselectValue */ "../../node_modules/@rjsf/utils/lib/enumOptionsDeselectValue.js");
/* harmony import */ var _enumOptionsIndexForValue__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./enumOptionsIndexForValue */ "../../node_modules/@rjsf/utils/lib/enumOptionsIndexForValue.js");
/* harmony import */ var _enumOptionsIsSelected__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./enumOptionsIsSelected */ "../../node_modules/@rjsf/utils/lib/enumOptionsIsSelected.js");
/* harmony import */ var _enumOptionsSelectValue__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./enumOptionsSelectValue */ "../../node_modules/@rjsf/utils/lib/enumOptionsSelectValue.js");
/* harmony import */ var _enumOptionsValueForIndex__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./enumOptionsValueForIndex */ "../../node_modules/@rjsf/utils/lib/enumOptionsValueForIndex.js");
/* harmony import */ var _ErrorSchemaBuilder__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./ErrorSchemaBuilder */ "../../node_modules/@rjsf/utils/lib/ErrorSchemaBuilder.js");
/* harmony import */ var _findSchemaDefinition__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./findSchemaDefinition */ "../../node_modules/@rjsf/utils/lib/findSchemaDefinition.js");
/* harmony import */ var _getDateElementProps__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./getDateElementProps */ "../../node_modules/@rjsf/utils/lib/getDateElementProps.js");
/* harmony import */ var _getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./getDiscriminatorFieldFromSchema */ "../../node_modules/@rjsf/utils/lib/getDiscriminatorFieldFromSchema.js");
/* harmony import */ var _getInputProps__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./getInputProps */ "../../node_modules/@rjsf/utils/lib/getInputProps.js");
/* harmony import */ var _getSchemaType__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./getSchemaType */ "../../node_modules/@rjsf/utils/lib/getSchemaType.js");
/* harmony import */ var _getSubmitButtonOptions__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./getSubmitButtonOptions */ "../../node_modules/@rjsf/utils/lib/getSubmitButtonOptions.js");
/* harmony import */ var _getTemplate__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./getTemplate */ "../../node_modules/@rjsf/utils/lib/getTemplate.js");
/* harmony import */ var _getUiOptions__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./getUiOptions */ "../../node_modules/@rjsf/utils/lib/getUiOptions.js");
/* harmony import */ var _getWidget__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./getWidget */ "../../node_modules/@rjsf/utils/lib/getWidget.js");
/* harmony import */ var _guessType__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./guessType */ "../../node_modules/@rjsf/utils/lib/guessType.js");
/* harmony import */ var _hashForSchema__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./hashForSchema */ "../../node_modules/@rjsf/utils/lib/hashForSchema.js");
/* harmony import */ var _hasWidget__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./hasWidget */ "../../node_modules/@rjsf/utils/lib/hasWidget.js");
/* harmony import */ var _idGenerators__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./idGenerators */ "../../node_modules/@rjsf/utils/lib/idGenerators.js");
/* harmony import */ var _isConstant__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./isConstant */ "../../node_modules/@rjsf/utils/lib/isConstant.js");
/* harmony import */ var _isCustomWidget__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./isCustomWidget */ "../../node_modules/@rjsf/utils/lib/isCustomWidget.js");
/* harmony import */ var _isFixedItems__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./isFixedItems */ "../../node_modules/@rjsf/utils/lib/isFixedItems.js");
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");
/* harmony import */ var _labelValue__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./labelValue */ "../../node_modules/@rjsf/utils/lib/labelValue.js");
/* harmony import */ var _localToUTC__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./localToUTC */ "../../node_modules/@rjsf/utils/lib/localToUTC.js");
/* harmony import */ var _mergeDefaultsWithFormData__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./mergeDefaultsWithFormData */ "../../node_modules/@rjsf/utils/lib/mergeDefaultsWithFormData.js");
/* harmony import */ var _mergeObjects__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./mergeObjects */ "../../node_modules/@rjsf/utils/lib/mergeObjects.js");
/* harmony import */ var _mergeSchemas__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./mergeSchemas */ "../../node_modules/@rjsf/utils/lib/mergeSchemas.js");
/* harmony import */ var _optionsList__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./optionsList */ "../../node_modules/@rjsf/utils/lib/optionsList.js");
/* harmony import */ var _orderProperties__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./orderProperties */ "../../node_modules/@rjsf/utils/lib/orderProperties.js");
/* harmony import */ var _pad__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./pad */ "../../node_modules/@rjsf/utils/lib/pad.js");
/* harmony import */ var _parseDateString__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./parseDateString */ "../../node_modules/@rjsf/utils/lib/parseDateString.js");
/* harmony import */ var _rangeSpec__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./rangeSpec */ "../../node_modules/@rjsf/utils/lib/rangeSpec.js");
/* harmony import */ var _replaceStringParameters__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./replaceStringParameters */ "../../node_modules/@rjsf/utils/lib/replaceStringParameters.js");
/* harmony import */ var _schemaRequiresTrueValue__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./schemaRequiresTrueValue */ "../../node_modules/@rjsf/utils/lib/schemaRequiresTrueValue.js");
/* harmony import */ var _shouldRender__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ./shouldRender */ "../../node_modules/@rjsf/utils/lib/shouldRender.js");
/* harmony import */ var _toConstant__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ./toConstant */ "../../node_modules/@rjsf/utils/lib/toConstant.js");
/* harmony import */ var _toDateString__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ./toDateString */ "../../node_modules/@rjsf/utils/lib/toDateString.js");
/* harmony import */ var _toErrorList__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ./toErrorList */ "../../node_modules/@rjsf/utils/lib/toErrorList.js");
/* harmony import */ var _toErrorSchema__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ./toErrorSchema */ "../../node_modules/@rjsf/utils/lib/toErrorSchema.js");
/* harmony import */ var _unwrapErrorHandler__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ./unwrapErrorHandler */ "../../node_modules/@rjsf/utils/lib/unwrapErrorHandler.js");
/* harmony import */ var _utcToLocal__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ./utcToLocal */ "../../node_modules/@rjsf/utils/lib/utcToLocal.js");
/* harmony import */ var _validationDataMerge__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ./validationDataMerge */ "../../node_modules/@rjsf/utils/lib/validationDataMerge.js");
/* harmony import */ var _withIdRefPrefix__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! ./withIdRefPrefix */ "../../node_modules/@rjsf/utils/lib/withIdRefPrefix.js");
/* harmony import */ var _getOptionMatchingSimpleDiscriminator__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! ./getOptionMatchingSimpleDiscriminator */ "../../node_modules/@rjsf/utils/lib/getOptionMatchingSimpleDiscriminator.js");
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! ./types */ "../../node_modules/@rjsf/utils/lib/types.js");
/* harmony import */ var _enums__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! ./enums */ "../../node_modules/@rjsf/utils/lib/enums.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _parser__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! ./parser */ "../../node_modules/@rjsf/utils/lib/parser/index.js");
/* harmony import */ var _schema__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(/*! ./schema */ "../../node_modules/@rjsf/utils/lib/schema/index.js");






























































/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/isConstant.js":
/*!********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/isConstant.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isConstant)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");

/** This function checks if the given `schema` matches a single constant value. This happens when either the schema has
 * an `enum` array with a single value or there is a `const` defined.
 *
 * @param schema - The schema for a field
 * @returns - True if the `schema` has a single constant value, false otherwise
 */
function isConstant(schema) {
    return (Array.isArray(schema.enum) && schema.enum.length === 1) || _constants__WEBPACK_IMPORTED_MODULE_0__.CONST_KEY in schema;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/isCustomWidget.js":
/*!************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/isCustomWidget.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isCustomWidget)
/* harmony export */ });
/* harmony import */ var _getUiOptions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getUiOptions */ "../../node_modules/@rjsf/utils/lib/getUiOptions.js");

/** Checks to see if the `uiSchema` contains the `widget` field and that the widget is not `hidden`
 *
 * @param uiSchema - The UI Schema from which to detect if it is customized
 * @returns - True if the `uiSchema` describes a custom widget, false otherwise
 */
function isCustomWidget(uiSchema = {}) {
    return (
    // TODO: Remove the `&& uiSchema['ui:widget'] !== 'hidden'` once we support hidden widgets for arrays.
    // https://rjsf-team.github.io/react-jsonschema-form/docs/usage/widgets/#hidden-widgets
    'widget' in (0,_getUiOptions__WEBPACK_IMPORTED_MODULE_0__["default"])(uiSchema) && (0,_getUiOptions__WEBPACK_IMPORTED_MODULE_0__["default"])(uiSchema)['widget'] !== 'hidden');
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/isFixedItems.js":
/*!**********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/isFixedItems.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isFixedItems)
/* harmony export */ });
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");

/** Detects whether the given `schema` contains fixed items. This is the case when `schema.items` is a non-empty array
 * that only contains objects.
 *
 * @param schema - The schema in which to check for fixed items
 * @returns - True if there are fixed items in the schema, false otherwise
 */
function isFixedItems(schema) {
    return Array.isArray(schema.items) && schema.items.length > 0 && schema.items.every((item) => (0,_isObject__WEBPACK_IMPORTED_MODULE_0__["default"])(item));
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/isObject.js":
/*!******************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/isObject.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isObject)
/* harmony export */ });
/** Determines whether a `thing` is an object for the purposes of RSJF. In this case, `thing` is an object if it has
 * the type `object` but is NOT null, an array or a File.
 *
 * @param thing - The thing to check to see whether it is an object
 * @returns - True if it is a non-null, non-array, non-File object
 */
function isObject(thing) {
    if (typeof File !== 'undefined' && thing instanceof File) {
        return false;
    }
    if (typeof Date !== 'undefined' && thing instanceof Date) {
        return false;
    }
    return typeof thing === 'object' && thing !== null && !Array.isArray(thing);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/labelValue.js":
/*!********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/labelValue.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ labelValue)
/* harmony export */ });
function labelValue(label, hideLabel, fallback) {
    return hideLabel ? fallback : label;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/localToUTC.js":
/*!********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/localToUTC.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ localToUTC)
/* harmony export */ });
/** Converts a local Date string into a UTC date string
 *
 * @param dateString - The string representation of a date as accepted by the `Date()` constructor
 * @returns - A UTC date string if `dateString` is truthy, otherwise undefined
 */
function localToUTC(dateString) {
    return dateString ? new Date(dateString).toJSON() : undefined;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/mergeDefaultsWithFormData.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/mergeDefaultsWithFormData.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ mergeDefaultsWithFormData)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");


/** Merges the `defaults` object of type `T` into the `formData` of type `T`
 *
 * When merging defaults and form data, we want to merge in this specific way:
 * - objects are deeply merged
 * - arrays are merged in such a way that:
 *   - when the array is set in form data, only array entries set in form data
 *     are deeply merged; additional entries from the defaults are ignored unless `mergeExtraArrayDefaults` is true, in
 *     which case the extras are appended onto the end of the form data
 *   - when the array is not set in form data, the default is copied over
 * - scalars are overwritten/set by form data
 *
 * @param [defaults] - The defaults to merge
 * @param [formData] - The form data into which the defaults will be merged
 * @param [mergeExtraArrayDefaults=false] - If true, any additional default array entries are appended onto the formData
 * @returns - The resulting merged form data with defaults
 */
function mergeDefaultsWithFormData(defaults, formData, mergeExtraArrayDefaults = false) {
    if (Array.isArray(formData)) {
        const defaultsArray = Array.isArray(defaults) ? defaults : [];
        const mapped = formData.map((value, idx) => {
            if (defaultsArray[idx]) {
                return mergeDefaultsWithFormData(defaultsArray[idx], value, mergeExtraArrayDefaults);
            }
            return value;
        });
        // Merge any extra defaults when mergeExtraArrayDefaults is true
        if (mergeExtraArrayDefaults && mapped.length < defaultsArray.length) {
            mapped.push(...defaultsArray.slice(mapped.length));
        }
        return mapped;
    }
    if ((0,_isObject__WEBPACK_IMPORTED_MODULE_1__["default"])(formData)) {
        const acc = Object.assign({}, defaults); // Prevent mutation of source object.
        return Object.keys(formData).reduce((acc, key) => {
            acc[key] = mergeDefaultsWithFormData(defaults ? lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(defaults, key) : {}, lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, key), mergeExtraArrayDefaults);
            return acc;
        }, acc);
    }
    return formData;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/mergeObjects.js":
/*!**********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/mergeObjects.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ mergeObjects)
/* harmony export */ });
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");

/** Recursively merge deeply nested objects.
 *
 * @param obj1 - The first object to merge
 * @param obj2 - The second object to merge
 * @param [concatArrays=false] - Optional flag that, when true, will cause arrays to be concatenated. Use
 *          "preventDuplicates" to merge arrays in a manner that prevents any duplicate entries from being merged.
 *          NOTE: Uses shallow comparison for the duplicate checking.
 * @returns - A new object that is the merge of the two given objects
 */
function mergeObjects(obj1, obj2, concatArrays = false) {
    return Object.keys(obj2).reduce((acc, key) => {
        const left = obj1 ? obj1[key] : {}, right = obj2[key];
        if (obj1 && key in obj1 && (0,_isObject__WEBPACK_IMPORTED_MODULE_0__["default"])(right)) {
            acc[key] = mergeObjects(left, right, concatArrays);
        }
        else if (concatArrays && Array.isArray(left) && Array.isArray(right)) {
            let toMerge = right;
            if (concatArrays === 'preventDuplicates') {
                toMerge = right.reduce((result, value) => {
                    if (!left.includes(value)) {
                        result.push(value);
                    }
                    return result;
                }, []);
            }
            acc[key] = left.concat(toMerge);
        }
        else {
            acc[key] = right;
        }
        return acc;
    }, Object.assign({}, obj1)); // Prevent mutation of source object.
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/mergeSchemas.js":
/*!**********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/mergeSchemas.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ mergeSchemas)
/* harmony export */ });
/* harmony import */ var lodash_union__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/union */ "../../node_modules/lodash/union.js");
/* harmony import */ var lodash_union__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_union__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _getSchemaType__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getSchemaType */ "../../node_modules/@rjsf/utils/lib/getSchemaType.js");
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");




/** Recursively merge deeply nested schemas. The difference between `mergeSchemas` and `mergeObjects` is that
 * `mergeSchemas` only concats arrays for values under the 'required' keyword, and when it does, it doesn't include
 * duplicate values.
 *
 * @param obj1 - The first schema object to merge
 * @param obj2 - The second schema object to merge
 * @returns - The merged schema object
 */
function mergeSchemas(obj1, obj2) {
    const acc = Object.assign({}, obj1); // Prevent mutation of source object.
    return Object.keys(obj2).reduce((acc, key) => {
        const left = obj1 ? obj1[key] : {}, right = obj2[key];
        if (obj1 && key in obj1 && (0,_isObject__WEBPACK_IMPORTED_MODULE_3__["default"])(right)) {
            acc[key] = mergeSchemas(left, right);
        }
        else if (obj1 &&
            obj2 &&
            ((0,_getSchemaType__WEBPACK_IMPORTED_MODULE_2__["default"])(obj1) === 'object' || (0,_getSchemaType__WEBPACK_IMPORTED_MODULE_2__["default"])(obj2) === 'object') &&
            key === _constants__WEBPACK_IMPORTED_MODULE_1__.REQUIRED_KEY &&
            Array.isArray(left) &&
            Array.isArray(right)) {
            // Don't include duplicate values when merging 'required' fields.
            acc[key] = lodash_union__WEBPACK_IMPORTED_MODULE_0___default()(left, right);
        }
        else {
            acc[key] = right;
        }
        return acc;
    }, acc);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/optionsList.js":
/*!*********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/optionsList.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ optionsList)
/* harmony export */ });
/* harmony import */ var _toConstant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./toConstant */ "../../node_modules/@rjsf/utils/lib/toConstant.js");
/* harmony import */ var _getUiOptions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getUiOptions */ "../../node_modules/@rjsf/utils/lib/getUiOptions.js");


/** Gets the list of options from the `schema`. If the schema has an enum list, then those enum values are returned. The
 * labels for the options will be extracted from the non-standard, RJSF-deprecated `enumNames` if it exists, otherwise
 * the label will be the same as the `value`. If the schema has a `oneOf` or `anyOf`, then the value is the list of
 * `const` values from the schema and the label is either the `schema.title` or the value. If a `uiSchema` is provided
 * and it has the `ui:enumNames` matched with `enum` or it has an associated `oneOf` or `anyOf` with a list of objects
 * containing `ui:title` then the UI schema values will replace the values from the schema.
 *
 * @param schema - The schema from which to extract the options list
 * @param [uiSchema] - The optional uiSchema from which to get alternate labels for the options
 * @returns - The list of options from the schema
 */
function optionsList(schema, uiSchema) {
    // TODO flip generics to move T first in v6
    const schemaWithEnumNames = schema;
    if (schema.enum) {
        let enumNames;
        if (uiSchema) {
            const { enumNames: uiEnumNames } = (0,_getUiOptions__WEBPACK_IMPORTED_MODULE_1__["default"])(uiSchema);
            enumNames = uiEnumNames;
        }
        if (!enumNames && schemaWithEnumNames.enumNames) {
            // enumNames was deprecated in v5 and is intentionally omitted from the RJSFSchema type.
            // Cast the type to include enumNames so the feature still works.
            if (true) {
                console.warn('The "enumNames" property in the schema is deprecated and will be removed in a future major release. Use the "ui:enumNames" property in the uiSchema instead.');
            }
            enumNames = schemaWithEnumNames.enumNames;
        }
        return schema.enum.map((value, i) => {
            const label = (enumNames === null || enumNames === void 0 ? void 0 : enumNames[i]) || String(value);
            return { label, value };
        });
    }
    let altSchemas = undefined;
    let altUiSchemas = undefined;
    if (schema.anyOf) {
        altSchemas = schema.anyOf;
        altUiSchemas = uiSchema === null || uiSchema === void 0 ? void 0 : uiSchema.anyOf;
    }
    else if (schema.oneOf) {
        altSchemas = schema.oneOf;
        altUiSchemas = uiSchema === null || uiSchema === void 0 ? void 0 : uiSchema.oneOf;
    }
    return (altSchemas &&
        altSchemas.map((aSchemaDef, index) => {
            const { title } = (0,_getUiOptions__WEBPACK_IMPORTED_MODULE_1__["default"])(altUiSchemas === null || altUiSchemas === void 0 ? void 0 : altUiSchemas[index]);
            const aSchema = aSchemaDef;
            const value = (0,_toConstant__WEBPACK_IMPORTED_MODULE_0__["default"])(aSchema);
            const label = title || aSchema.title || String(value);
            return {
                schema: aSchema,
                label,
                value,
            };
        }));
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/orderProperties.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/orderProperties.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ orderProperties)
/* harmony export */ });
/** Given a list of `properties` and an `order` list, returns a list that contains the `properties` ordered correctly.
 * If `order` is not an array, then the untouched `properties` list is returned. Otherwise `properties` is ordered per
 * the `order` list. If `order` contains a '*' then any `properties` that are not mentioned explicity in `order` will be
 * places in the location of the `*`.
 *
 * @param properties - The list of property keys to be ordered
 * @param order - An array of property keys to be ordered first, with an optional '*' property
 * @returns - A list with the `properties` ordered
 * @throws - Error when the properties cannot be ordered correctly
 */
function orderProperties(properties, order) {
    if (!Array.isArray(order)) {
        return properties;
    }
    const arrayToHash = (arr) => arr.reduce((prev, curr) => {
        prev[curr] = true;
        return prev;
    }, {});
    const errorPropList = (arr) => arr.length > 1 ? `properties '${arr.join("', '")}'` : `property '${arr[0]}'`;
    const propertyHash = arrayToHash(properties);
    const orderFiltered = order.filter((prop) => prop === '*' || propertyHash[prop]);
    const orderHash = arrayToHash(orderFiltered);
    const rest = properties.filter((prop) => !orderHash[prop]);
    const restIndex = orderFiltered.indexOf('*');
    if (restIndex === -1) {
        if (rest.length) {
            throw new Error(`uiSchema order list does not contain ${errorPropList(rest)}`);
        }
        return orderFiltered;
    }
    if (restIndex !== orderFiltered.lastIndexOf('*')) {
        throw new Error('uiSchema order list contains more than one wildcard item');
    }
    const complete = [...orderFiltered];
    complete.splice(restIndex, 1, ...rest);
    return complete;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/pad.js":
/*!*************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/pad.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ pad)
/* harmony export */ });
/** Returns a string representation of the `num` that is padded with leading "0"s if necessary
 *
 * @param num - The number to pad
 * @param width - The width of the string at which no lead padding is necessary
 * @returns - The number converted to a string with leading zero padding if the number of digits is less than `width`
 */
function pad(num, width) {
    let s = String(num);
    while (s.length < width) {
        s = '0' + s;
    }
    return s;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/parseDateString.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/parseDateString.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ parseDateString)
/* harmony export */ });
/** Parses the `dateString` into a `DateObject`, including the time information when `includeTime` is true
 *
 * @param dateString - The date string to parse into a DateObject
 * @param [includeTime=true] - Optional flag, if false, will not include the time data into the object
 * @returns - The date string converted to a `DateObject`
 * @throws - Error when the date cannot be parsed from the string
 */
function parseDateString(dateString, includeTime = true) {
    if (!dateString) {
        return {
            year: -1,
            month: -1,
            day: -1,
            hour: includeTime ? -1 : 0,
            minute: includeTime ? -1 : 0,
            second: includeTime ? -1 : 0,
        };
    }
    const date = new Date(dateString);
    if (Number.isNaN(date.getTime())) {
        throw new Error('Unable to parse date ' + dateString);
    }
    return {
        year: date.getUTCFullYear(),
        month: date.getUTCMonth() + 1,
        day: date.getUTCDate(),
        hour: includeTime ? date.getUTCHours() : 0,
        minute: includeTime ? date.getUTCMinutes() : 0,
        second: includeTime ? date.getUTCSeconds() : 0,
    };
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/parser/ParserValidator.js":
/*!********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/parser/ParserValidator.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ParserValidator)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _hashForSchema__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../hashForSchema */ "../../node_modules/@rjsf/utils/lib/hashForSchema.js");
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");




/** An implementation of the `ValidatorType` interface that is designed for use in capturing schemas used by the
 * `isValid()` function. The rest of the implementation of the interface throws errors when it is attempted to be used.
 * An instance of the object allows the caller to capture the schemas used in calls to the `isValid()` function. These
 * captured schema, along with the root schema used to construct the object are stored in the map of schemas keyed by
 * the hashed value of the schema. NOTE: After hashing the schema, an $id with the hash value is added to the
 * schema IF that schema doesn't already have an $id, prior to putting the schema into the map.
 */
class ParserValidator {
    /** Construct the ParserValidator for the given `rootSchema`. This `rootSchema` will be stashed in the `schemaMap`
     * first.
     *
     * @param rootSchema - The root schema against which this validator will be executed
     */
    constructor(rootSchema) {
        /** The map of schemas encountered by the ParserValidator */
        this.schemaMap = {};
        this.rootSchema = rootSchema;
        this.addSchema(rootSchema, (0,_hashForSchema__WEBPACK_IMPORTED_MODULE_2__["default"])(rootSchema));
    }
    /** Resets the internal AJV validator to clear schemas from it. Can be helpful for resetting the validator for tests.
     */
    reset() {
        this.schemaMap = {};
    }
    /** Adds the given `schema` to the `schemaMap` keyed by the `hash` or `ID_KEY` if present on the `schema`. If the
     * schema does not have an `ID_KEY`, then the `hash` will be added as the `ID_KEY` to allow the schema to be
     * associated with it's `hash` for future use (by a schema compiler).
     *
     * @param schema - The schema which is to be added to the map
     * @param hash - The hash value at which to map the schema
     */
    addSchema(schema, hash) {
        const key = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(schema, _constants__WEBPACK_IMPORTED_MODULE_1__.ID_KEY, hash);
        const identifiedSchema = { ...schema, [_constants__WEBPACK_IMPORTED_MODULE_1__.ID_KEY]: key };
        const existing = this.schemaMap[key];
        if (!existing) {
            this.schemaMap[key] = identifiedSchema;
        }
        else if (!(0,_deepEquals__WEBPACK_IMPORTED_MODULE_3__["default"])(existing, identifiedSchema)) {
            console.error('existing schema:', JSON.stringify(existing, null, 2));
            console.error('new schema:', JSON.stringify(identifiedSchema, null, 2));
            throw new Error(`Two different schemas exist with the same key ${key}! What a bad coincidence. If possible, try adding an $id to one of the schemas`);
        }
    }
    /** Returns the current `schemaMap` to the caller
     */
    getSchemaMap() {
        return this.schemaMap;
    }
    /** Implements the `ValidatorType` `isValid()` method to capture the `schema` in the `schemaMap`. Throws an error when
     * the `rootSchema` is not the same as the root schema provided during construction.
     *
     * @param schema - The schema to record in the `schemaMap`
     * @param _formData - The formData parameter that is ignored
     * @param rootSchema - The root schema associated with the schema
     * @throws - Error when the given `rootSchema` differs from the root schema provided during construction
     */
    isValid(schema, _formData, rootSchema) {
        if (!(0,_deepEquals__WEBPACK_IMPORTED_MODULE_3__["default"])(rootSchema, this.rootSchema)) {
            throw new Error('Unexpectedly calling isValid() with a rootSchema that differs from the construction rootSchema');
        }
        this.addSchema(schema, (0,_hashForSchema__WEBPACK_IMPORTED_MODULE_2__["default"])(schema));
        return false;
    }
    /** Implements the `ValidatorType` `rawValidation()` method to throw an error since it is never supposed to be called
     *
     * @param _schema - The schema parameter that is ignored
     * @param _formData - The formData parameter that is ignored
     */
    rawValidation(_schema, _formData) {
        throw new Error('Unexpectedly calling the `rawValidation()` method during schema parsing');
    }
    /** Implements the `ValidatorType` `toErrorList()` method to throw an error since it is never supposed to be called
     *
     * @param _errorSchema - The error schema parameter that is ignored
     * @param _fieldPath - The field path parameter that is ignored
     */
    toErrorList(_errorSchema, _fieldPath) {
        throw new Error('Unexpectedly calling the `toErrorList()` method during schema parsing');
    }
    /** Implements the `ValidatorType` `validateFormData()` method to throw an error since it is never supposed to be
     * called
     *
     * @param _formData - The formData parameter that is ignored
     * @param _schema - The schema parameter that is ignored
     * @param _customValidate - The customValidate parameter that is ignored
     * @param _transformErrors - The transformErrors parameter that is ignored
     * @param _uiSchema - The uiSchema parameter that is ignored
     */
    validateFormData(_formData, _schema, _customValidate, _transformErrors, _uiSchema) {
        throw new Error('Unexpectedly calling the `validateFormData()` method during schema parsing');
    }
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/parser/index.js":
/*!**********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/parser/index.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   schemaParser: () => (/* reexport safe */ _schemaParser__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _schemaParser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./schemaParser */ "../../node_modules/@rjsf/utils/lib/parser/schemaParser.js");




/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/parser/schemaParser.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/parser/schemaParser.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ schemaParser)
/* harmony export */ });
/* harmony import */ var lodash_forEach__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/forEach */ "../../node_modules/lodash/forEach.js");
/* harmony import */ var lodash_forEach__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_forEach__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _ParserValidator__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ParserValidator */ "../../node_modules/@rjsf/utils/lib/parser/ParserValidator.js");
/* harmony import */ var _schema_retrieveSchema__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../schema/retrieveSchema */ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js");
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");





/** Recursive function used to parse the given `schema` belonging to the `rootSchema`. The `validator` is used to
 * capture the sub-schemas that the `isValid()` function is called with. For each schema returned by the
 * `retrieveSchemaInternal()`, the `resolveAnyOrOneOfSchemas()` function is called. For each of the schemas returned
 * from THAT call have `properties`, then each of the sub-schema property objects are then recursively parsed.
 *
 * @param validator - The `ParserValidator` implementation used to capture `isValid()` calls during parsing
 * @param recurseList - The list of schemas returned from the `retrieveSchemaInternal`, preventing infinite recursion
 * @param rootSchema - The root schema from which the schema parsing began
 * @param schema - The current schema element being parsed
 */
function parseSchema(validator, recurseList, rootSchema, schema) {
    const schemas = (0,_schema_retrieveSchema__WEBPACK_IMPORTED_MODULE_3__.retrieveSchemaInternal)(validator, schema, rootSchema, undefined, true);
    schemas.forEach((schema) => {
        const sameSchemaIndex = recurseList.findIndex((item) => (0,_deepEquals__WEBPACK_IMPORTED_MODULE_4__["default"])(item, schema));
        if (sameSchemaIndex === -1) {
            recurseList.push(schema);
            const allOptions = (0,_schema_retrieveSchema__WEBPACK_IMPORTED_MODULE_3__.resolveAnyOrOneOfSchemas)(validator, schema, rootSchema, true);
            allOptions.forEach((s) => {
                if (_constants__WEBPACK_IMPORTED_MODULE_1__.PROPERTIES_KEY in s && s[_constants__WEBPACK_IMPORTED_MODULE_1__.PROPERTIES_KEY]) {
                    lodash_forEach__WEBPACK_IMPORTED_MODULE_0___default()(schema[_constants__WEBPACK_IMPORTED_MODULE_1__.PROPERTIES_KEY], (value) => {
                        parseSchema(validator, recurseList, rootSchema, value);
                    });
                }
            });
            if (_constants__WEBPACK_IMPORTED_MODULE_1__.ITEMS_KEY in schema && !Array.isArray(schema.items) && typeof schema.items !== 'boolean') {
                parseSchema(validator, recurseList, rootSchema, schema.items);
            }
        }
    });
}
/** Parses the given `rootSchema` to extract out all the sub-schemas that maybe contained within it. Returns a map of
 * the hash of the schema to schema/sub-schema.
 *
 * @param rootSchema - The root schema to parse for sub-schemas used by `isValid()` calls
 * @returns - The `SchemaMap` of all schemas that were parsed
 */
function schemaParser(rootSchema) {
    const validator = new _ParserValidator__WEBPACK_IMPORTED_MODULE_2__["default"](rootSchema);
    const recurseList = [];
    parseSchema(validator, recurseList, rootSchema, rootSchema);
    return validator.getSchemaMap();
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/rangeSpec.js":
/*!*******************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/rangeSpec.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ rangeSpec)
/* harmony export */ });
/** Extracts the range spec information `{ step?: number, min?: number, max?: number }` that can be spread onto an HTML
 * input from the range analog in the schema `{ multipleOf?: number, minimum?: number, maximum?: number }`.
 *
 * @param schema - The schema from which to extract the range spec
 * @returns - A range specification from the schema
 */
function rangeSpec(schema) {
    const spec = {};
    if (schema.multipleOf) {
        spec.step = schema.multipleOf;
    }
    if (schema.minimum || schema.minimum === 0) {
        spec.min = schema.minimum;
    }
    if (schema.maximum || schema.maximum === 0) {
        spec.max = schema.maximum;
    }
    return spec;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/replaceStringParameters.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/replaceStringParameters.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ replaceStringParameters)
/* harmony export */ });
/** Potentially substitutes all replaceable parameters with the associated value(s) from the `params` if available. When
 * a `params` array is provided, each value in the array is used to replace any of the replaceable parameters in the
 * `inputString` using the `%1`, `%2`, etc. replacement specifiers.
 *
 * @param inputString - The string which will be potentially updated with replacement parameters
 * @param params - The optional list of replaceable parameter values to substitute into the english string
 * @returns - The updated string with any replacement specifiers replaced
 */
function replaceStringParameters(inputString, params) {
    let output = inputString;
    if (Array.isArray(params)) {
        const parts = output.split(/(%\d)/);
        params.forEach((param, index) => {
            const partIndex = parts.findIndex((part) => part === `%${index + 1}`);
            if (partIndex >= 0) {
                parts[partIndex] = param;
            }
        });
        output = parts.join('');
    }
    return output;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/getClosestMatchingOption.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/getClosestMatchingOption.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   JUNK_OPTION: () => (/* binding */ JUNK_OPTION),
/* harmony export */   calculateIndexScore: () => (/* binding */ calculateIndexScore),
/* harmony export */   "default": () => (/* binding */ getClosestMatchingOption)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_has__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/has */ "../../node_modules/lodash/has.js");
/* harmony import */ var lodash_has__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_has__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_isNumber__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/isNumber */ "../../node_modules/lodash/isNumber.js");
/* harmony import */ var lodash_isNumber__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_isNumber__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/isObject */ "../../node_modules/lodash/isObject.js");
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_isObject__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_isString__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/isString */ "../../node_modules/lodash/isString.js");
/* harmony import */ var lodash_isString__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_isString__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var lodash_reduce__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash/reduce */ "../../node_modules/lodash/reduce.js");
/* harmony import */ var lodash_reduce__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash_reduce__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var lodash_times__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash/times */ "../../node_modules/lodash/times.js");
/* harmony import */ var lodash_times__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash_times__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _getFirstMatchingOption__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./getFirstMatchingOption */ "../../node_modules/@rjsf/utils/lib/schema/getFirstMatchingOption.js");
/* harmony import */ var _retrieveSchema__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./retrieveSchema */ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js");
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _guessType__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../guessType */ "../../node_modules/@rjsf/utils/lib/guessType.js");
/* harmony import */ var _getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../getDiscriminatorFieldFromSchema */ "../../node_modules/@rjsf/utils/lib/getDiscriminatorFieldFromSchema.js");
/* harmony import */ var _getOptionMatchingSimpleDiscriminator__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../getOptionMatchingSimpleDiscriminator */ "../../node_modules/@rjsf/utils/lib/getOptionMatchingSimpleDiscriminator.js");













/** A junk option used to determine when the getFirstMatchingOption call really matches an option rather than returning
 * the first item
 */
const JUNK_OPTION = {
    type: 'object',
    $id: _constants__WEBPACK_IMPORTED_MODULE_9__.JUNK_OPTION_ID,
    properties: {
        __not_really_there__: {
            type: 'number',
        },
    },
};
/** Recursive function that calculates the score of a `formData` against the given `schema`. The computation is fairly
 * simple. Initially the total score is 0. When `schema.properties` object exists, then all the `key/value` pairs within
 * the object are processed as follows after obtaining the formValue from `formData` using the `key`:
 * - If the `value` contains a `$ref`, `calculateIndexScore()` is called recursively with the formValue and the new
 *   schema that is the result of the ref in the schema being resolved and that sub-schema's resulting score is added to
 *   the total.
 * - If the `value` contains a `oneOf` and there is a formValue, then score based on the index returned from calling
 *   `getClosestMatchingOption()` of that oneOf.
 * - If the type of the `value` is 'object', `calculateIndexScore()` is called recursively with the formValue and the
 *   `value` itself as the sub-schema, and the score is added to the total.
 * - If the type of the `value` matches the guessed-type of the `formValue`, the score is incremented by 1, UNLESS the
 *   value has a `default` or `const`. In those case, if the `default` or `const` and the `formValue` match, the score
 *   is incremented by another 1 otherwise it is decremented by 1.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param rootSchema - The root JSON schema of the entire form
 * @param schema - The schema for which the score is being calculated
 * @param formData - The form data associated with the schema, used to calculate the score
 * @returns - The score a schema against the formData
 */
function calculateIndexScore(validator, rootSchema, schema, formData = {}) {
    let totalScore = 0;
    if (schema) {
        if (lodash_isObject__WEBPACK_IMPORTED_MODULE_3___default()(schema.properties)) {
            totalScore += lodash_reduce__WEBPACK_IMPORTED_MODULE_5___default()(schema.properties, (score, value, key) => {
                const formValue = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, key);
                if (typeof value === 'boolean') {
                    return score;
                }
                if (lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(value, _constants__WEBPACK_IMPORTED_MODULE_9__.REF_KEY)) {
                    const newSchema = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_8__["default"])(validator, value, rootSchema, formValue);
                    return score + calculateIndexScore(validator, rootSchema, newSchema, formValue || {});
                }
                if ((lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(value, _constants__WEBPACK_IMPORTED_MODULE_9__.ONE_OF_KEY) || lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(value, _constants__WEBPACK_IMPORTED_MODULE_9__.ANY_OF_KEY)) && formValue) {
                    const key = lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(value, _constants__WEBPACK_IMPORTED_MODULE_9__.ONE_OF_KEY) ? _constants__WEBPACK_IMPORTED_MODULE_9__.ONE_OF_KEY : _constants__WEBPACK_IMPORTED_MODULE_9__.ANY_OF_KEY;
                    const discriminator = (0,_getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_11__["default"])(value);
                    return (score +
                        getClosestMatchingOption(validator, rootSchema, formValue, lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(value, key), -1, discriminator));
                }
                if (value.type === 'object') {
                    return score + calculateIndexScore(validator, rootSchema, value, formValue || {});
                }
                if (value.type === (0,_guessType__WEBPACK_IMPORTED_MODULE_10__["default"])(formValue)) {
                    // If the types match, then we bump the score by one
                    let newScore = score + 1;
                    if (value.default) {
                        // If the schema contains a readonly default value score the value that matches the default higher and
                        // any non-matching value lower
                        newScore += formValue === value.default ? 1 : -1;
                    }
                    else if (value.const) {
                        // If the schema contains a const value score the value that matches the default higher and
                        // any non-matching value lower
                        newScore += formValue === value.const ? 1 : -1;
                    }
                    // TODO eventually, deal with enums/arrays
                    return newScore;
                }
                return score;
            }, 0);
        }
        else if (lodash_isString__WEBPACK_IMPORTED_MODULE_4___default()(schema.type) && schema.type === (0,_guessType__WEBPACK_IMPORTED_MODULE_10__["default"])(formData)) {
            totalScore += 1;
        }
    }
    return totalScore;
}
/** Determines which of the given `options` provided most closely matches the `formData`. Using
 * `getFirstMatchingOption()` to match two schemas that differ only by the readOnly, default or const value of a field
 * based on the `formData` and returns 0 when there is no match. Rather than passing in all the `options` at once to
 * this utility, instead an array of valid option indexes is created by iterating over the list of options, call
 * `getFirstMatchingOptions` with a list of one junk option and one good option, seeing if the good option is considered
 * matched.
 *
 * Once the list of valid indexes is created, if there is only one valid index, just return it. Otherwise, if there are
 * no valid indexes, then fill the valid indexes array with the indexes of all the options. Next, the index of the
 * option with the highest score is determined by iterating over the list of valid options, calling
 * `calculateIndexScore()` on each, comparing it against the current best score, and returning the index of the one that
 * eventually has the best score.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param rootSchema - The root JSON schema of the entire form
 * @param formData - The form data associated with the schema
 * @param options - The list of options that can be selected from
 * @param [selectedOption=-1] - The index of the currently selected option, defaulted to -1 if not specified
 * @param [discriminatorField] - The optional name of the field within the options object whose value is used to
 *          determine which option is selected
 * @returns - The index of the option that is the closest match to the `formData` or the `selectedOption` if no match
 */
function getClosestMatchingOption(validator, rootSchema, formData, options, selectedOption = -1, discriminatorField) {
    // First resolve any refs in the options
    const resolvedOptions = options.map((option) => {
        return (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_8__.resolveAllReferences)(option, rootSchema, []);
    });
    const simpleDiscriminatorMatch = (0,_getOptionMatchingSimpleDiscriminator__WEBPACK_IMPORTED_MODULE_12__["default"])(formData, options, discriminatorField);
    if (lodash_isNumber__WEBPACK_IMPORTED_MODULE_2___default()(simpleDiscriminatorMatch)) {
        return simpleDiscriminatorMatch;
    }
    // Reduce the array of options down to a list of the indexes that are considered matching options
    const allValidIndexes = resolvedOptions.reduce((validList, option, index) => {
        const testOptions = [JUNK_OPTION, option];
        const match = (0,_getFirstMatchingOption__WEBPACK_IMPORTED_MODULE_7__["default"])(validator, formData, testOptions, rootSchema, discriminatorField);
        // The match is the real option, so add its index to list of valid indexes
        if (match === 1) {
            validList.push(index);
        }
        return validList;
    }, []);
    // There is only one valid index, so return it!
    if (allValidIndexes.length === 1) {
        return allValidIndexes[0];
    }
    if (!allValidIndexes.length) {
        // No indexes were valid, so we'll score all the options, add all the indexes
        lodash_times__WEBPACK_IMPORTED_MODULE_6___default()(resolvedOptions.length, (i) => allValidIndexes.push(i));
    }
    const scoreCount = new Set();
    // Score all the options in the list of valid indexes and return the index with the best score
    const { bestIndex } = allValidIndexes.reduce((scoreData, index) => {
        const { bestScore } = scoreData;
        const option = resolvedOptions[index];
        const score = calculateIndexScore(validator, rootSchema, option, formData);
        scoreCount.add(score);
        if (score > bestScore) {
            return { bestIndex: index, bestScore: score };
        }
        return scoreData;
    }, { bestIndex: selectedOption, bestScore: 0 });
    // if all scores are the same go with selectedOption
    if (scoreCount.size === 1 && selectedOption >= 0) {
        return selectedOption;
    }
    return bestIndex;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/getDefaultFormState.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/getDefaultFormState.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AdditionalItemsHandling: () => (/* binding */ AdditionalItemsHandling),
/* harmony export */   computeDefaults: () => (/* binding */ computeDefaults),
/* harmony export */   "default": () => (/* binding */ getDefaultFormState),
/* harmony export */   getArrayDefaults: () => (/* binding */ getArrayDefaults),
/* harmony export */   getDefaultBasedOnSchemaType: () => (/* binding */ getDefaultBasedOnSchemaType),
/* harmony export */   getInnerSchemaForArrayItem: () => (/* binding */ getInnerSchemaForArrayItem),
/* harmony export */   getObjectDefaults: () => (/* binding */ getObjectDefaults)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/isEmpty */ "../../node_modules/lodash/isEmpty.js");
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _findSchemaDefinition__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../findSchemaDefinition */ "../../node_modules/@rjsf/utils/lib/findSchemaDefinition.js");
/* harmony import */ var _getClosestMatchingOption__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getClosestMatchingOption */ "../../node_modules/@rjsf/utils/lib/schema/getClosestMatchingOption.js");
/* harmony import */ var _getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../getDiscriminatorFieldFromSchema */ "../../node_modules/@rjsf/utils/lib/getDiscriminatorFieldFromSchema.js");
/* harmony import */ var _getSchemaType__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../getSchemaType */ "../../node_modules/@rjsf/utils/lib/getSchemaType.js");
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");
/* harmony import */ var _isFixedItems__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../isFixedItems */ "../../node_modules/@rjsf/utils/lib/isFixedItems.js");
/* harmony import */ var _mergeDefaultsWithFormData__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../mergeDefaultsWithFormData */ "../../node_modules/@rjsf/utils/lib/mergeDefaultsWithFormData.js");
/* harmony import */ var _mergeObjects__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../mergeObjects */ "../../node_modules/@rjsf/utils/lib/mergeObjects.js");
/* harmony import */ var _mergeSchemas__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../mergeSchemas */ "../../node_modules/@rjsf/utils/lib/mergeSchemas.js");
/* harmony import */ var _isMultiSelect__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./isMultiSelect */ "../../node_modules/@rjsf/utils/lib/schema/isMultiSelect.js");
/* harmony import */ var _retrieveSchema__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./retrieveSchema */ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js");














/** Enum that indicates how `schema.additionalItems` should be handled by the `getInnerSchemaForArrayItem()` function.
 */
var AdditionalItemsHandling;
(function (AdditionalItemsHandling) {
    AdditionalItemsHandling[AdditionalItemsHandling["Ignore"] = 0] = "Ignore";
    AdditionalItemsHandling[AdditionalItemsHandling["Invert"] = 1] = "Invert";
    AdditionalItemsHandling[AdditionalItemsHandling["Fallback"] = 2] = "Fallback";
})(AdditionalItemsHandling || (AdditionalItemsHandling = {}));
/** Given a `schema` will return an inner schema that for an array item. This is computed differently based on the
 * `additionalItems` enum and the value of `idx`. There are four possible returns:
 * 1. If `idx` is >= 0, then if `schema.items` is an array the `idx`th element of the array is returned if it is a valid
 *    index and not a boolean, otherwise it falls through to 3.
 * 2. If `schema.items` is not an array AND truthy and not a boolean, then `schema.items` is returned since it actually
 *    is a schema, otherwise it falls through to 3.
 * 3. If `additionalItems` is not `AdditionalItemsHandling.Ignore` and `schema.additionalItems` is an object, then
 *    `schema.additionalItems` is returned since it actually is a schema, otherwise it falls through to 4.
 * 4. {} is returned representing an empty schema
 *
 * @param schema - The schema from which to get the particular item
 * @param [additionalItems=AdditionalItemsHandling.Ignore] - How do we want to handle additional items?
 * @param [idx=-1] - Index, if non-negative, will be used to return the idx-th element in a `schema.items` array
 * @returns - The best fit schema object from the `schema` given the `additionalItems` and `idx` modifiers
 */
function getInnerSchemaForArrayItem(schema, additionalItems = AdditionalItemsHandling.Ignore, idx = -1) {
    if (idx >= 0) {
        if (Array.isArray(schema.items) && idx < schema.items.length) {
            const item = schema.items[idx];
            if (typeof item !== 'boolean') {
                return item;
            }
        }
    }
    else if (schema.items && !Array.isArray(schema.items) && typeof schema.items !== 'boolean') {
        return schema.items;
    }
    if (additionalItems !== AdditionalItemsHandling.Ignore && (0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(schema.additionalItems)) {
        return schema.additionalItems;
    }
    return {};
}
/** Either add `computedDefault` at `key` into `obj` or not add it based on its value, the value of
 * `includeUndefinedValues`, the value of `emptyObjectFields` and if its parent field is required. Generally undefined
 * `computedDefault` values are added only when `includeUndefinedValues` is either true/"excludeObjectChildren". If `
 * includeUndefinedValues` is false and `emptyObjectFields` is not "skipDefaults", then non-undefined and non-empty-object
 * values will be added based on certain conditions.
 *
 * @param obj - The object into which the computed default may be added
 * @param key - The key into the object at which the computed default may be added
 * @param computedDefault - The computed default value that maybe should be added to the obj
 * @param includeUndefinedValues - Optional flag, if true, cause undefined values to be added as defaults.
 *          If "excludeObjectChildren", cause undefined values for this object and pass `includeUndefinedValues` as
 *          false when computing defaults for any nested object properties. If "allowEmptyObject", prevents undefined
 *          values in this object while allow the object itself to be empty and passing `includeUndefinedValues` as
 *          false when computing defaults for any nested object properties.
 * @param isParentRequired - The optional boolean that indicates whether the parent field is required
 * @param requiredFields - The list of fields that are required
 * @param experimental_defaultFormStateBehavior - Optional configuration object, if provided, allows users to override
 *        default form state behavior
 */
function maybeAddDefaultToObject(obj, key, computedDefault, includeUndefinedValues, isParentRequired, requiredFields = [], experimental_defaultFormStateBehavior = {}) {
    const { emptyObjectFields = 'populateAllDefaults' } = experimental_defaultFormStateBehavior;
    if (includeUndefinedValues) {
        obj[key] = computedDefault;
    }
    else if (emptyObjectFields !== 'skipDefaults') {
        if ((0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(computedDefault)) {
            // If isParentRequired is undefined, then we are at the root level of the schema so defer to the requiredness of
            // the field key itself in the `requiredField` list
            const isSelfOrParentRequired = isParentRequired === undefined ? requiredFields.includes(key) : isParentRequired;
            // If emptyObjectFields 'skipEmptyDefaults' store computedDefault if it's a non-empty object(e.g. not {})
            if (emptyObjectFields === 'skipEmptyDefaults') {
                if (!lodash_isEmpty__WEBPACK_IMPORTED_MODULE_1___default()(computedDefault)) {
                    obj[key] = computedDefault;
                }
            }
            // Else store computedDefault if it's a non-empty object(e.g. not {}) and satisfies certain conditions
            // Condition 1: If computedDefault is not empty or if the key is a required field
            // Condition 2: If the parent object is required or emptyObjectFields is not 'populateRequiredDefaults'
            else if ((!lodash_isEmpty__WEBPACK_IMPORTED_MODULE_1___default()(computedDefault) || requiredFields.includes(key)) &&
                (isSelfOrParentRequired || emptyObjectFields !== 'populateRequiredDefaults')) {
                obj[key] = computedDefault;
            }
        }
        else if (
        // Store computedDefault if it's a defined primitive (e.g., true) and satisfies certain conditions
        // Condition 1: computedDefault is not undefined
        // Condition 2: If emptyObjectFields is 'populateAllDefaults' or 'skipEmptyDefaults) or if the key is a required field
        computedDefault !== undefined &&
            (emptyObjectFields === 'populateAllDefaults' ||
                emptyObjectFields === 'skipEmptyDefaults' ||
                requiredFields.includes(key))) {
            obj[key] = computedDefault;
        }
    }
}
/** Computes the defaults for the current `schema` given the `rawFormData` and `parentDefaults` if any. This drills into
 * each level of the schema, recursively, to fill out every level of defaults provided by the schema.
 *
 * @param validator - an implementation of the `ValidatorType` interface that will be used when necessary
 * @param rawSchema - The schema for which the default state is desired
 * @param {ComputeDefaultsProps} computeDefaultsProps - Optional props for this function
 * @returns - The resulting `formData` with all the defaults provided
 */
function computeDefaults(validator, rawSchema, computeDefaultsProps = {}) {
    const { parentDefaults, rawFormData, rootSchema = {}, includeUndefinedValues = false, _recurseList = [], experimental_defaultFormStateBehavior = undefined, required, } = computeDefaultsProps;
    const formData = ((0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(rawFormData) ? rawFormData : {});
    const schema = (0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(rawSchema) ? rawSchema : {};
    // Compute the defaults recursively: give highest priority to deepest nodes.
    let defaults = parentDefaults;
    // If we get a new schema, then we need to recompute defaults again for the new schema found.
    let schemaToCompute = null;
    let updatedRecurseList = _recurseList;
    if ((0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(defaults) && (0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(schema.default)) {
        // For object defaults, only override parent defaults that are defined in
        // schema.default.
        defaults = (0,_mergeObjects__WEBPACK_IMPORTED_MODULE_10__["default"])(defaults, schema.default);
    }
    else if (_constants__WEBPACK_IMPORTED_MODULE_2__.DEFAULT_KEY in schema) {
        defaults = schema.default;
    }
    else if (_constants__WEBPACK_IMPORTED_MODULE_2__.REF_KEY in schema) {
        const refName = schema[_constants__WEBPACK_IMPORTED_MODULE_2__.REF_KEY];
        // Use referenced schema defaults for this node.
        if (!_recurseList.includes(refName)) {
            updatedRecurseList = _recurseList.concat(refName);
            schemaToCompute = (0,_findSchemaDefinition__WEBPACK_IMPORTED_MODULE_3__["default"])(refName, rootSchema);
        }
    }
    else if (_constants__WEBPACK_IMPORTED_MODULE_2__.DEPENDENCIES_KEY in schema) {
        // Get the default if set from properties to ensure the dependencies conditions are resolved based on it
        const defaultFormData = {
            ...formData,
            ...getDefaultBasedOnSchemaType(validator, schema, computeDefaultsProps, defaults),
        };
        const resolvedSchema = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_13__.resolveDependencies)(validator, schema, rootSchema, false, [], defaultFormData);
        schemaToCompute = resolvedSchema[0]; // pick the first element from resolve dependencies
    }
    else if ((0,_isFixedItems__WEBPACK_IMPORTED_MODULE_8__["default"])(schema)) {
        defaults = schema.items.map((itemSchema, idx) => computeDefaults(validator, itemSchema, {
            rootSchema,
            includeUndefinedValues,
            _recurseList,
            experimental_defaultFormStateBehavior,
            parentDefaults: Array.isArray(parentDefaults) ? parentDefaults[idx] : undefined,
            rawFormData: formData,
            required,
        }));
    }
    else if (_constants__WEBPACK_IMPORTED_MODULE_2__.ONE_OF_KEY in schema) {
        const { oneOf, ...remaining } = schema;
        if (oneOf.length === 0) {
            return undefined;
        }
        const discriminator = (0,_getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_5__["default"])(schema);
        schemaToCompute = oneOf[(0,_getClosestMatchingOption__WEBPACK_IMPORTED_MODULE_4__["default"])(validator, rootSchema, lodash_isEmpty__WEBPACK_IMPORTED_MODULE_1___default()(formData) ? undefined : formData, oneOf, 0, discriminator)];
        schemaToCompute = (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_11__["default"])(remaining, schemaToCompute);
    }
    else if (_constants__WEBPACK_IMPORTED_MODULE_2__.ANY_OF_KEY in schema) {
        const { anyOf, ...remaining } = schema;
        if (anyOf.length === 0) {
            return undefined;
        }
        const discriminator = (0,_getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_5__["default"])(schema);
        schemaToCompute = anyOf[(0,_getClosestMatchingOption__WEBPACK_IMPORTED_MODULE_4__["default"])(validator, rootSchema, lodash_isEmpty__WEBPACK_IMPORTED_MODULE_1___default()(formData) ? undefined : formData, anyOf, 0, discriminator)];
        schemaToCompute = (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_11__["default"])(remaining, schemaToCompute);
    }
    if (schemaToCompute) {
        return computeDefaults(validator, schemaToCompute, {
            rootSchema,
            includeUndefinedValues,
            _recurseList: updatedRecurseList,
            experimental_defaultFormStateBehavior,
            parentDefaults: defaults,
            rawFormData: formData,
            required,
        });
    }
    // No defaults defined for this node, fallback to generic typed ones.
    if (defaults === undefined) {
        defaults = schema.default;
    }
    const defaultBasedOnSchemaType = getDefaultBasedOnSchemaType(validator, schema, computeDefaultsProps, defaults);
    return defaultBasedOnSchemaType !== null && defaultBasedOnSchemaType !== void 0 ? defaultBasedOnSchemaType : defaults;
}
/** Computes the default value for objects.
 *
 * @param validator - an implementation of the `ValidatorType` interface that will be used when necessary
 * @param rawSchema - The schema for which the default state is desired
 * @param {ComputeDefaultsProps} computeDefaultsProps - Optional props for this function
 * @param defaults - Optional props for this function
 * @returns - The default value based on the schema type if they are defined for object or array schemas.
 */
function getObjectDefaults(validator, rawSchema, { rawFormData, rootSchema = {}, includeUndefinedValues = false, _recurseList = [], experimental_defaultFormStateBehavior = undefined, required, } = {}, defaults) {
    {
        const formData = ((0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(rawFormData) ? rawFormData : {});
        const schema = rawSchema;
        // This is a custom addition that fixes this issue:
        // https://github.com/rjsf-team/react-jsonschema-form/issues/3832
        const retrievedSchema = (experimental_defaultFormStateBehavior === null || experimental_defaultFormStateBehavior === void 0 ? void 0 : experimental_defaultFormStateBehavior.allOf) === 'populateDefaults' && _constants__WEBPACK_IMPORTED_MODULE_2__.ALL_OF_KEY in schema
            ? (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_13__["default"])(validator, schema, rootSchema, formData)
            : schema;
        const objectDefaults = Object.keys(retrievedSchema.properties || {}).reduce((acc, key) => {
            var _a;
            // Compute the defaults for this node, with the parent defaults we might
            // have from a previous run: defaults[key].
            const computedDefault = computeDefaults(validator, lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(retrievedSchema, [_constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY, key]), {
                rootSchema,
                _recurseList,
                experimental_defaultFormStateBehavior,
                includeUndefinedValues: includeUndefinedValues === true,
                parentDefaults: lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(defaults, [key]),
                rawFormData: lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [key]),
                required: (_a = retrievedSchema.required) === null || _a === void 0 ? void 0 : _a.includes(key),
            });
            maybeAddDefaultToObject(acc, key, computedDefault, includeUndefinedValues, required, retrievedSchema.required, experimental_defaultFormStateBehavior);
            return acc;
        }, {});
        if (retrievedSchema.additionalProperties) {
            // as per spec additionalProperties may be either schema or boolean
            const additionalPropertiesSchema = (0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(retrievedSchema.additionalProperties)
                ? retrievedSchema.additionalProperties
                : {};
            const keys = new Set();
            if ((0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(defaults)) {
                Object.keys(defaults)
                    .filter((key) => !retrievedSchema.properties || !retrievedSchema.properties[key])
                    .forEach((key) => keys.add(key));
            }
            const formDataRequired = [];
            Object.keys(formData)
                .filter((key) => !retrievedSchema.properties || !retrievedSchema.properties[key])
                .forEach((key) => {
                keys.add(key);
                formDataRequired.push(key);
            });
            keys.forEach((key) => {
                var _a;
                const computedDefault = computeDefaults(validator, additionalPropertiesSchema, {
                    rootSchema,
                    _recurseList,
                    experimental_defaultFormStateBehavior,
                    includeUndefinedValues: includeUndefinedValues === true,
                    parentDefaults: lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(defaults, [key]),
                    rawFormData: lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [key]),
                    required: (_a = retrievedSchema.required) === null || _a === void 0 ? void 0 : _a.includes(key),
                });
                // Since these are additional properties we don't need to add the `experimental_defaultFormStateBehavior` prop
                maybeAddDefaultToObject(objectDefaults, key, computedDefault, includeUndefinedValues, required, formDataRequired);
            });
        }
        return objectDefaults;
    }
}
/** Computes the default value for arrays.
 *
 * @param validator - an implementation of the `ValidatorType` interface that will be used when necessary
 * @param rawSchema - The schema for which the default state is desired
 * @param {ComputeDefaultsProps} computeDefaultsProps - Optional props for this function
 * @param defaults - Optional props for this function
 * @returns - The default value based on the schema type if they are defined for object or array schemas.
 */
function getArrayDefaults(validator, rawSchema, { rawFormData, rootSchema = {}, _recurseList = [], experimental_defaultFormStateBehavior = undefined, required, } = {}, defaults) {
    var _a, _b, _c, _d;
    const schema = rawSchema;
    const neverPopulate = ((_a = experimental_defaultFormStateBehavior === null || experimental_defaultFormStateBehavior === void 0 ? void 0 : experimental_defaultFormStateBehavior.arrayMinItems) === null || _a === void 0 ? void 0 : _a.populate) === 'never';
    const ignoreMinItemsFlagSet = ((_b = experimental_defaultFormStateBehavior === null || experimental_defaultFormStateBehavior === void 0 ? void 0 : experimental_defaultFormStateBehavior.arrayMinItems) === null || _b === void 0 ? void 0 : _b.populate) === 'requiredOnly';
    const isSkipEmptyDefaults = (experimental_defaultFormStateBehavior === null || experimental_defaultFormStateBehavior === void 0 ? void 0 : experimental_defaultFormStateBehavior.emptyObjectFields) === 'skipEmptyDefaults';
    const computeSkipPopulate = (_d = (_c = experimental_defaultFormStateBehavior === null || experimental_defaultFormStateBehavior === void 0 ? void 0 : experimental_defaultFormStateBehavior.arrayMinItems) === null || _c === void 0 ? void 0 : _c.computeSkipPopulate) !== null && _d !== void 0 ? _d : (() => false);
    const emptyDefault = isSkipEmptyDefaults ? undefined : [];
    // Inject defaults into existing array defaults
    if (Array.isArray(defaults)) {
        defaults = defaults.map((item, idx) => {
            const schemaItem = getInnerSchemaForArrayItem(schema, AdditionalItemsHandling.Fallback, idx);
            return computeDefaults(validator, schemaItem, {
                rootSchema,
                _recurseList,
                experimental_defaultFormStateBehavior,
                parentDefaults: item,
                required,
            });
        });
    }
    // Deeply inject defaults into already existing form data
    if (Array.isArray(rawFormData)) {
        const schemaItem = getInnerSchemaForArrayItem(schema);
        if (neverPopulate) {
            defaults = rawFormData;
        }
        else {
            defaults = rawFormData.map((item, idx) => {
                return computeDefaults(validator, schemaItem, {
                    rootSchema,
                    _recurseList,
                    experimental_defaultFormStateBehavior,
                    rawFormData: item,
                    parentDefaults: lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(defaults, [idx]),
                    required,
                });
            });
        }
    }
    if (neverPopulate) {
        return defaults !== null && defaults !== void 0 ? defaults : emptyDefault;
    }
    if (ignoreMinItemsFlagSet && !required) {
        // If no form data exists or defaults are set leave the field empty/non-existent, otherwise
        // return form data/defaults
        return defaults ? defaults : undefined;
    }
    const defaultsLength = Array.isArray(defaults) ? defaults.length : 0;
    if (!schema.minItems ||
        (0,_isMultiSelect__WEBPACK_IMPORTED_MODULE_12__["default"])(validator, schema, rootSchema) ||
        computeSkipPopulate(validator, schema, rootSchema) ||
        schema.minItems <= defaultsLength) {
        return defaults ? defaults : emptyDefault;
    }
    const defaultEntries = (defaults || []);
    const fillerSchema = getInnerSchemaForArrayItem(schema, AdditionalItemsHandling.Invert);
    const fillerDefault = fillerSchema.default;
    // Calculate filler entries for remaining items (minItems - existing raw data/defaults)
    const fillerEntries = new Array(schema.minItems - defaultsLength).fill(computeDefaults(validator, fillerSchema, {
        parentDefaults: fillerDefault,
        rootSchema,
        _recurseList,
        experimental_defaultFormStateBehavior,
        required,
    }));
    // then fill up the rest with either the item default or empty, up to minItems
    return defaultEntries.concat(fillerEntries);
}
/** Computes the default value based on the schema type.
 *
 * @param validator - an implementation of the `ValidatorType` interface that will be used when necessary
 * @param rawSchema - The schema for which the default state is desired
 * @param {ComputeDefaultsProps} computeDefaultsProps - Optional props for this function
 * @param defaults - Optional props for this function
 * @returns - The default value based on the schema type if they are defined for object or array schemas.
 */
function getDefaultBasedOnSchemaType(validator, rawSchema, computeDefaultsProps = {}, defaults) {
    switch ((0,_getSchemaType__WEBPACK_IMPORTED_MODULE_6__["default"])(rawSchema)) {
        // We need to recurse for object schema inner default values.
        case 'object': {
            return getObjectDefaults(validator, rawSchema, computeDefaultsProps, defaults);
        }
        case 'array': {
            return getArrayDefaults(validator, rawSchema, computeDefaultsProps, defaults);
        }
    }
}
/** Returns the superset of `formData` that includes the given set updated to include any missing fields that have
 * computed to have defaults provided in the `schema`.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param theSchema - The schema for which the default state is desired
 * @param [formData] - The current formData, if any, onto which to provide any missing defaults
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s
 * @param [includeUndefinedValues=false] - Optional flag, if true, cause undefined values to be added as defaults.
 *          If "excludeObjectChildren", cause undefined values for this object and pass `includeUndefinedValues` as
 *          false when computing defaults for any nested object properties.
 * @param [experimental_defaultFormStateBehavior] Optional configuration object, if provided, allows users to override default form state behavior
 * @returns - The resulting `formData` with all the defaults provided
 */
function getDefaultFormState(validator, theSchema, formData, rootSchema, includeUndefinedValues = false, experimental_defaultFormStateBehavior) {
    if (!(0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(theSchema)) {
        throw new Error('Invalid schema: ' + theSchema);
    }
    const schema = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_13__["default"])(validator, theSchema, rootSchema, formData);
    const defaults = computeDefaults(validator, schema, {
        rootSchema,
        includeUndefinedValues,
        experimental_defaultFormStateBehavior,
        rawFormData: formData,
    });
    if (formData === undefined || formData === null || (typeof formData === 'number' && isNaN(formData))) {
        // No form data? Use schema defaults.
        return defaults;
    }
    const { mergeExtraDefaults } = (experimental_defaultFormStateBehavior === null || experimental_defaultFormStateBehavior === void 0 ? void 0 : experimental_defaultFormStateBehavior.arrayMinItems) || {};
    if ((0,_isObject__WEBPACK_IMPORTED_MODULE_7__["default"])(formData)) {
        return (0,_mergeDefaultsWithFormData__WEBPACK_IMPORTED_MODULE_9__["default"])(defaults, formData, mergeExtraDefaults);
    }
    if (Array.isArray(formData)) {
        return (0,_mergeDefaultsWithFormData__WEBPACK_IMPORTED_MODULE_9__["default"])(defaults, formData, mergeExtraDefaults);
    }
    return formData;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/getDisplayLabel.js":
/*!********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/getDisplayLabel.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getDisplayLabel)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _getSchemaType__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../getSchemaType */ "../../node_modules/@rjsf/utils/lib/getSchemaType.js");
/* harmony import */ var _getUiOptions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../getUiOptions */ "../../node_modules/@rjsf/utils/lib/getUiOptions.js");
/* harmony import */ var _isCustomWidget__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../isCustomWidget */ "../../node_modules/@rjsf/utils/lib/isCustomWidget.js");
/* harmony import */ var _isFilesArray__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./isFilesArray */ "../../node_modules/@rjsf/utils/lib/schema/isFilesArray.js");
/* harmony import */ var _isMultiSelect__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./isMultiSelect */ "../../node_modules/@rjsf/utils/lib/schema/isMultiSelect.js");






/** Determines whether the combination of `schema` and `uiSchema` properties indicates that the label for the `schema`
 * should be displayed in a UI.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param schema - The schema for which the display label flag is desired
 * @param [uiSchema={}] - The UI schema from which to derive potentially displayable information
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s
 * @param [globalOptions={}] - The optional Global UI Schema from which to get any fallback `xxx` options
 * @returns - True if the label should be displayed or false if it should not
 */
function getDisplayLabel(validator, schema, uiSchema = {}, rootSchema, globalOptions) {
    const uiOptions = (0,_getUiOptions__WEBPACK_IMPORTED_MODULE_2__["default"])(uiSchema, globalOptions);
    const { label = true } = uiOptions;
    let displayLabel = !!label;
    const schemaType = (0,_getSchemaType__WEBPACK_IMPORTED_MODULE_1__["default"])(schema);
    if (schemaType === 'array') {
        displayLabel =
            (0,_isMultiSelect__WEBPACK_IMPORTED_MODULE_5__["default"])(validator, schema, rootSchema) ||
                (0,_isFilesArray__WEBPACK_IMPORTED_MODULE_4__["default"])(validator, schema, uiSchema, rootSchema) ||
                (0,_isCustomWidget__WEBPACK_IMPORTED_MODULE_3__["default"])(uiSchema);
    }
    if (schemaType === 'object') {
        displayLabel = false;
    }
    if (schemaType === 'boolean' && !uiSchema[_constants__WEBPACK_IMPORTED_MODULE_0__.UI_WIDGET_KEY]) {
        displayLabel = false;
    }
    if (uiSchema[_constants__WEBPACK_IMPORTED_MODULE_0__.UI_FIELD_KEY]) {
        displayLabel = false;
    }
    return displayLabel;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/getFirstMatchingOption.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/getFirstMatchingOption.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getFirstMatchingOption)
/* harmony export */ });
/* harmony import */ var _getMatchingOption__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getMatchingOption */ "../../node_modules/@rjsf/utils/lib/schema/getMatchingOption.js");

/** Given the `formData` and list of `options`, attempts to find the index of the first option that matches the data.
 * Always returns the first option if there is nothing that matches.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param formData - The current formData, if any, used to figure out a match
 * @param options - The list of options to find a matching options from
 * @param rootSchema - The root schema, used to primarily to look up `$ref`s
 * @param [discriminatorField] - The optional name of the field within the options object whose value is used to
 *          determine which option is selected
 * @returns - The index of the first matched option or 0 if none is available
 */
function getFirstMatchingOption(validator, formData, options, rootSchema, discriminatorField) {
    return (0,_getMatchingOption__WEBPACK_IMPORTED_MODULE_0__["default"])(validator, formData, options, rootSchema, discriminatorField);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/getMatchingOption.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/getMatchingOption.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getMatchingOption)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_has__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/has */ "../../node_modules/lodash/has.js");
/* harmony import */ var lodash_has__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_has__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_isNumber__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/isNumber */ "../../node_modules/lodash/isNumber.js");
/* harmony import */ var lodash_isNumber__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_isNumber__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _getOptionMatchingSimpleDiscriminator__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../getOptionMatchingSimpleDiscriminator */ "../../node_modules/@rjsf/utils/lib/getOptionMatchingSimpleDiscriminator.js");





/** Given the `formData` and list of `options`, attempts to find the index of the option that best matches the data.
 * Deprecated, use `getFirstMatchingOption()` instead.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param formData - The current formData, if any, used to figure out a match
 * @param options - The list of options to find a matching options from
 * @param rootSchema - The root schema, used to primarily to look up `$ref`s
 * @param [discriminatorField] - The optional name of the field within the options object whose value is used to
 *          determine which option is selected
 * @returns - The index of the matched option or 0 if none is available
 * @deprecated
 */
function getMatchingOption(validator, formData, options, rootSchema, discriminatorField) {
    // For performance, skip validating subschemas if formData is undefined. We just
    // want to get the first option in that case.
    if (formData === undefined) {
        return 0;
    }
    const simpleDiscriminatorMatch = (0,_getOptionMatchingSimpleDiscriminator__WEBPACK_IMPORTED_MODULE_4__["default"])(formData, options, discriminatorField);
    if (lodash_isNumber__WEBPACK_IMPORTED_MODULE_2___default()(simpleDiscriminatorMatch)) {
        return simpleDiscriminatorMatch;
    }
    for (let i = 0; i < options.length; i++) {
        const option = options[i];
        // If we have a discriminator field, then we will use this to make the determination
        if (discriminatorField && lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(option, [_constants__WEBPACK_IMPORTED_MODULE_3__.PROPERTIES_KEY, discriminatorField])) {
            const value = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, discriminatorField);
            const discriminator = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(option, [_constants__WEBPACK_IMPORTED_MODULE_3__.PROPERTIES_KEY, discriminatorField], {});
            if (validator.isValid(discriminator, value, rootSchema)) {
                return i;
            }
        }
        else if (option[_constants__WEBPACK_IMPORTED_MODULE_3__.PROPERTIES_KEY]) {
            // If the schema describes an object then we need to add slightly more
            // strict matching to the schema, because unless the schema uses the
            // "requires" keyword, an object will match the schema as long as it
            // doesn't have matching keys with a conflicting type. To do this we use an
            // "anyOf" with an array of requires. This augmentation expresses that the
            // schema should match if any of the keys in the schema are present on the
            // object and pass validation.
            //
            // Create an "anyOf" schema that requires at least one of the keys in the
            // "properties" object
            const requiresAnyOf = {
                anyOf: Object.keys(option[_constants__WEBPACK_IMPORTED_MODULE_3__.PROPERTIES_KEY]).map((key) => ({
                    required: [key],
                })),
            };
            let augmentedSchema;
            // If the "anyOf" keyword already exists, wrap the augmentation in an "allOf"
            if (option.anyOf) {
                // Create a shallow clone of the option
                const { ...shallowClone } = option;
                if (!shallowClone.allOf) {
                    shallowClone.allOf = [];
                }
                else {
                    // If "allOf" already exists, shallow clone the array
                    shallowClone.allOf = shallowClone.allOf.slice();
                }
                shallowClone.allOf.push(requiresAnyOf);
                augmentedSchema = shallowClone;
            }
            else {
                augmentedSchema = Object.assign({}, option, requiresAnyOf);
            }
            // Remove the "required" field as it's likely that not all fields have
            // been filled in yet, which will mean that the schema is not valid
            delete augmentedSchema.required;
            if (validator.isValid(augmentedSchema, formData, rootSchema)) {
                return i;
            }
        }
        else if (validator.isValid(option, formData, rootSchema)) {
            return i;
        }
    }
    return 0;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/index.js":
/*!**********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/index.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getClosestMatchingOption: () => (/* reexport safe */ _getClosestMatchingOption__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   getDefaultFormState: () => (/* reexport safe */ _getDefaultFormState__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   getDisplayLabel: () => (/* reexport safe */ _getDisplayLabel__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   getFirstMatchingOption: () => (/* reexport safe */ _getFirstMatchingOption__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   getMatchingOption: () => (/* reexport safe */ _getMatchingOption__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   isFilesArray: () => (/* reexport safe */ _isFilesArray__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   isMultiSelect: () => (/* reexport safe */ _isMultiSelect__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   isSelect: () => (/* reexport safe */ _isSelect__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   mergeValidationData: () => (/* reexport safe */ _mergeValidationData__WEBPACK_IMPORTED_MODULE_8__["default"]),
/* harmony export */   retrieveSchema: () => (/* reexport safe */ _retrieveSchema__WEBPACK_IMPORTED_MODULE_9__["default"]),
/* harmony export */   sanitizeDataForNewSchema: () => (/* reexport safe */ _sanitizeDataForNewSchema__WEBPACK_IMPORTED_MODULE_10__["default"]),
/* harmony export */   toIdSchema: () => (/* reexport safe */ _toIdSchema__WEBPACK_IMPORTED_MODULE_11__["default"]),
/* harmony export */   toPathSchema: () => (/* reexport safe */ _toPathSchema__WEBPACK_IMPORTED_MODULE_12__["default"])
/* harmony export */ });
/* harmony import */ var _getDefaultFormState__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getDefaultFormState */ "../../node_modules/@rjsf/utils/lib/schema/getDefaultFormState.js");
/* harmony import */ var _getDisplayLabel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getDisplayLabel */ "../../node_modules/@rjsf/utils/lib/schema/getDisplayLabel.js");
/* harmony import */ var _getClosestMatchingOption__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getClosestMatchingOption */ "../../node_modules/@rjsf/utils/lib/schema/getClosestMatchingOption.js");
/* harmony import */ var _getFirstMatchingOption__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getFirstMatchingOption */ "../../node_modules/@rjsf/utils/lib/schema/getFirstMatchingOption.js");
/* harmony import */ var _getMatchingOption__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getMatchingOption */ "../../node_modules/@rjsf/utils/lib/schema/getMatchingOption.js");
/* harmony import */ var _isFilesArray__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./isFilesArray */ "../../node_modules/@rjsf/utils/lib/schema/isFilesArray.js");
/* harmony import */ var _isMultiSelect__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./isMultiSelect */ "../../node_modules/@rjsf/utils/lib/schema/isMultiSelect.js");
/* harmony import */ var _isSelect__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./isSelect */ "../../node_modules/@rjsf/utils/lib/schema/isSelect.js");
/* harmony import */ var _mergeValidationData__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./mergeValidationData */ "../../node_modules/@rjsf/utils/lib/schema/mergeValidationData.js");
/* harmony import */ var _retrieveSchema__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./retrieveSchema */ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js");
/* harmony import */ var _sanitizeDataForNewSchema__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./sanitizeDataForNewSchema */ "../../node_modules/@rjsf/utils/lib/schema/sanitizeDataForNewSchema.js");
/* harmony import */ var _toIdSchema__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./toIdSchema */ "../../node_modules/@rjsf/utils/lib/schema/toIdSchema.js");
/* harmony import */ var _toPathSchema__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./toPathSchema */ "../../node_modules/@rjsf/utils/lib/schema/toPathSchema.js");
















/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/isFilesArray.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/isFilesArray.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isFilesArray)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _retrieveSchema__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./retrieveSchema */ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js");


/** Checks to see if the `schema` and `uiSchema` combination represents an array of files
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param schema - The schema for which check for array of files flag is desired
 * @param [uiSchema={}] - The UI schema from which to check the widget
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s
 * @returns - True if schema/uiSchema contains an array of files, otherwise false
 */
function isFilesArray(validator, schema, uiSchema = {}, rootSchema) {
    if (uiSchema[_constants__WEBPACK_IMPORTED_MODULE_0__.UI_WIDGET_KEY] === 'files') {
        return true;
    }
    if (schema.items) {
        const itemsSchema = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_1__["default"])(validator, schema.items, rootSchema);
        return itemsSchema.type === 'string' && itemsSchema.format === 'data-url';
    }
    return false;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/isMultiSelect.js":
/*!******************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/isMultiSelect.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isMultiSelect)
/* harmony export */ });
/* harmony import */ var _isSelect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isSelect */ "../../node_modules/@rjsf/utils/lib/schema/isSelect.js");

/** Checks to see if the `schema` combination represents a multi-select
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param schema - The schema for which check for a multi-select flag is desired
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s
 * @returns - True if schema contains a multi-select, otherwise false
 */
function isMultiSelect(validator, schema, rootSchema) {
    if (!schema.uniqueItems || !schema.items || typeof schema.items === 'boolean') {
        return false;
    }
    return (0,_isSelect__WEBPACK_IMPORTED_MODULE_0__["default"])(validator, schema.items, rootSchema);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/isSelect.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/isSelect.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isSelect)
/* harmony export */ });
/* harmony import */ var _isConstant__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../isConstant */ "../../node_modules/@rjsf/utils/lib/isConstant.js");
/* harmony import */ var _retrieveSchema__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./retrieveSchema */ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js");


/** Checks to see if the `schema` combination represents a select
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param theSchema - The schema for which check for a select flag is desired
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s
 * @returns - True if schema contains a select, otherwise false
 */
function isSelect(validator, theSchema, rootSchema = {}) {
    const schema = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_1__["default"])(validator, theSchema, rootSchema, undefined);
    const altSchemas = schema.oneOf || schema.anyOf;
    if (Array.isArray(schema.enum)) {
        return true;
    }
    if (Array.isArray(altSchemas)) {
        return altSchemas.every((altSchemas) => typeof altSchemas !== 'boolean' && (0,_isConstant__WEBPACK_IMPORTED_MODULE_0__["default"])(altSchemas));
    }
    return false;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/mergeValidationData.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/mergeValidationData.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ mergeValidationData)
/* harmony export */ });
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/isEmpty */ "../../node_modules/lodash/isEmpty.js");
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mergeObjects__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../mergeObjects */ "../../node_modules/@rjsf/utils/lib/mergeObjects.js");


/** Merges the errors in `additionalErrorSchema` into the existing `validationData` by combining the hierarchies in the
 * two `ErrorSchema`s and then appending the error list from the `additionalErrorSchema` obtained by calling
 * `validator.toErrorList()` onto the `errors` in the `validationData`. If no `additionalErrorSchema` is passed, then
 * `validationData` is returned.
 *
 * @param validator - The validator used to convert an ErrorSchema to a list of errors
 * @param validationData - The current `ValidationData` into which to merge the additional errors
 * @param [additionalErrorSchema] - The additional set of errors in an `ErrorSchema`
 * @returns - The `validationData` with the additional errors from `additionalErrorSchema` merged into it, if provided.
 * @deprecated - Use the `validationDataMerge()` function exported from `@rjsf/utils` instead. This function will be
 *        removed in the next major release.
 */
function mergeValidationData(validator, validationData, additionalErrorSchema) {
    if (!additionalErrorSchema) {
        return validationData;
    }
    const { errors: oldErrors, errorSchema: oldErrorSchema } = validationData;
    let errors = validator.toErrorList(additionalErrorSchema);
    let errorSchema = additionalErrorSchema;
    if (!lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0___default()(oldErrorSchema)) {
        errorSchema = (0,_mergeObjects__WEBPACK_IMPORTED_MODULE_1__["default"])(oldErrorSchema, additionalErrorSchema, true);
        errors = [...oldErrors].concat(errors);
    }
    return { errorSchema, errors };
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js":
/*!*******************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ retrieveSchema),
/* harmony export */   getAllPermutationsOfXxxOf: () => (/* binding */ getAllPermutationsOfXxxOf),
/* harmony export */   processDependencies: () => (/* binding */ processDependencies),
/* harmony export */   resolveAllReferences: () => (/* binding */ resolveAllReferences),
/* harmony export */   resolveAnyOrOneOfSchemas: () => (/* binding */ resolveAnyOrOneOfSchemas),
/* harmony export */   resolveCondition: () => (/* binding */ resolveCondition),
/* harmony export */   resolveDependencies: () => (/* binding */ resolveDependencies),
/* harmony export */   resolveReference: () => (/* binding */ resolveReference),
/* harmony export */   resolveSchema: () => (/* binding */ resolveSchema),
/* harmony export */   retrieveSchemaInternal: () => (/* binding */ retrieveSchemaInternal),
/* harmony export */   stubExistingAdditionalProperties: () => (/* binding */ stubExistingAdditionalProperties),
/* harmony export */   withDependentProperties: () => (/* binding */ withDependentProperties),
/* harmony export */   withDependentSchema: () => (/* binding */ withDependentSchema),
/* harmony export */   withExactlyOneSubschema: () => (/* binding */ withExactlyOneSubschema)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/set */ "../../node_modules/lodash/set.js");
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_set__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_times__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/times */ "../../node_modules/lodash/times.js");
/* harmony import */ var lodash_times__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_times__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var lodash_transform__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash/transform */ "../../node_modules/lodash/transform.js");
/* harmony import */ var lodash_transform__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(lodash_transform__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var lodash_merge__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash/merge */ "../../node_modules/lodash/merge.js");
/* harmony import */ var lodash_merge__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(lodash_merge__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var lodash_flattenDeep__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash/flattenDeep */ "../../node_modules/lodash/flattenDeep.js");
/* harmony import */ var lodash_flattenDeep__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(lodash_flattenDeep__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var lodash_uniq__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash/uniq */ "../../node_modules/lodash/uniq.js");
/* harmony import */ var lodash_uniq__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(lodash_uniq__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var json_schema_merge_allof__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! json-schema-merge-allof */ "../../node_modules/json-schema-merge-allof/src/index.js");
/* harmony import */ var json_schema_merge_allof__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(json_schema_merge_allof__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _findSchemaDefinition__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../findSchemaDefinition */ "../../node_modules/@rjsf/utils/lib/findSchemaDefinition.js");
/* harmony import */ var _getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../getDiscriminatorFieldFromSchema */ "../../node_modules/@rjsf/utils/lib/getDiscriminatorFieldFromSchema.js");
/* harmony import */ var _guessType__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../guessType */ "../../node_modules/@rjsf/utils/lib/guessType.js");
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");
/* harmony import */ var _mergeSchemas__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../mergeSchemas */ "../../node_modules/@rjsf/utils/lib/mergeSchemas.js");
/* harmony import */ var _getFirstMatchingOption__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./getFirstMatchingOption */ "../../node_modules/@rjsf/utils/lib/schema/getFirstMatchingOption.js");
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");
















/** Retrieves an expanded schema that has had all of its conditions, additional properties, references and dependencies
 * resolved and merged into the `schema` given a `validator`, `rootSchema` and `rawFormData` that is used to do the
 * potentially recursive resolution.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which retrieving a schema is desired
 * @param [rootSchema={}] - The root schema that will be forwarded to all the APIs
 * @param [rawFormData] - The current formData, if any, to assist retrieving a schema
 * @returns - The schema having its conditions, additional properties, references and dependencies resolved
 */
function retrieveSchema(validator, schema, rootSchema = {}, rawFormData) {
    return retrieveSchemaInternal(validator, schema, rootSchema, rawFormData)[0];
}
/** Resolves a conditional block (if/else/then) by removing the condition and merging the appropriate conditional branch
 * with the rest of the schema. If `expandAllBranches` is true, then the `retrieveSchemaInteral()` results for both
 * conditions will be returned.
 *
 * @param validator - An implementation of the `ValidatorType` interface that is used to detect valid schema conditions
 * @param schema - The schema for which resolving a condition is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and
 *          dependencies as a list of schemas
 * @param recurseList - The list of recursive references already processed
 * @param [formData] - The current formData to assist retrieving a schema
 * @returns - A list of schemas with the appropriate conditions resolved, possibly with all branches expanded
 */
function resolveCondition(validator, schema, rootSchema, expandAllBranches, recurseList, formData) {
    const { if: expression, then, else: otherwise, ...resolvedSchemaLessConditional } = schema;
    const conditionValue = validator.isValid(expression, formData || {}, rootSchema);
    let resolvedSchemas = [resolvedSchemaLessConditional];
    let schemas = [];
    if (expandAllBranches) {
        if (then && typeof then !== 'boolean') {
            schemas = schemas.concat(retrieveSchemaInternal(validator, then, rootSchema, formData, expandAllBranches, recurseList));
        }
        if (otherwise && typeof otherwise !== 'boolean') {
            schemas = schemas.concat(retrieveSchemaInternal(validator, otherwise, rootSchema, formData, expandAllBranches, recurseList));
        }
    }
    else {
        const conditionalSchema = conditionValue ? then : otherwise;
        if (conditionalSchema && typeof conditionalSchema !== 'boolean') {
            schemas = schemas.concat(retrieveSchemaInternal(validator, conditionalSchema, rootSchema, formData, expandAllBranches, recurseList));
        }
    }
    if (schemas.length) {
        resolvedSchemas = schemas.map((s) => (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_13__["default"])(resolvedSchemaLessConditional, s));
    }
    return resolvedSchemas.flatMap((s) => retrieveSchemaInternal(validator, s, rootSchema, formData, expandAllBranches, recurseList));
}
/** Given a list of lists of allOf, anyOf or oneOf values, create a list of lists of all permutations of the values. The
 * `listOfLists` is expected to be all resolved values of the 1st...nth schemas within an `allOf`, `anyOf` or `oneOf`.
 * From those lists, build a matrix for each `xxxOf` where there is more than one schema for a row in the list of lists.
 *
 * For example:
 * - If there are three xxxOf rows (A, B, C) and they have been resolved such that there is only one A, two B and three
 *   C schemas then:
 *   - The permutation for the first row is `[[A]]`
 *   - The permutations for the second row are `[[A,B1], [A,B2]]`
 *   - The permutations for the third row are `[[A,B1,C1], [A,B1,C2], [A,B1,C3], [A,B2,C1], [A,B2,C2], [A,B2,C3]]`
 *
 * @param listOfLists - The list of lists of elements that represent the allOf, anyOf or oneOf resolved values in order
 * @returns - The list of all permutations of schemas for a set of `xxxOf`s
 */
function getAllPermutationsOfXxxOf(listOfLists) {
    const allPermutations = listOfLists.reduce((permutations, list) => {
        // When there are more than one set of schemas for a row, duplicate the set of permutations and add in the values
        if (list.length > 1) {
            return list.flatMap((element) => lodash_times__WEBPACK_IMPORTED_MODULE_2___default()(permutations.length, (i) => [...permutations[i]].concat(element)));
        }
        // Otherwise just push in the single value into the current set of permutations
        permutations.forEach((permutation) => permutation.push(list[0]));
        return permutations;
    }, [[]] // Start with an empty list
    );
    return allPermutations;
}
/** Resolves references and dependencies within a schema and its 'allOf' children. Passes the `expandAllBranches` flag
 * down to the `retrieveSchemaInternal()`, `resolveReference()` and `resolveDependencies()` helper calls. If
 * `expandAllBranches` is true, then all possible dependencies and/or allOf branches are returned.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which resolving a schema is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param recurseList - The list of recursive references already processed
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @returns - The list of schemas having its references, dependencies and allOf schemas resolved
 */
function resolveSchema(validator, schema, rootSchema, expandAllBranches, recurseList, formData) {
    const updatedSchemas = resolveReference(validator, schema, rootSchema, expandAllBranches, recurseList, formData);
    if (updatedSchemas.length > 1 || updatedSchemas[0] !== schema) {
        // return the updatedSchemas array if it has either multiple schemas within it
        // OR the first schema is not the same as the original schema
        return updatedSchemas;
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_8__.DEPENDENCIES_KEY in schema) {
        const resolvedSchemas = resolveDependencies(validator, schema, rootSchema, expandAllBranches, recurseList, formData);
        return resolvedSchemas.flatMap((s) => {
            return retrieveSchemaInternal(validator, s, rootSchema, formData, expandAllBranches, recurseList);
        });
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_8__.ALL_OF_KEY in schema && Array.isArray(schema.allOf)) {
        const allOfSchemaElements = schema.allOf.map((allOfSubschema) => retrieveSchemaInternal(validator, allOfSubschema, rootSchema, formData, expandAllBranches, recurseList));
        const allPermutations = getAllPermutationsOfXxxOf(allOfSchemaElements);
        return allPermutations.map((permutation) => ({
            ...schema,
            allOf: permutation,
        }));
    }
    // No $ref or dependencies or allOf attribute was found, returning the original schema.
    return [schema];
}
/** Resolves all references within a schema and then returns the `retrieveSchemaInternal()` if the resolved schema is
 * actually different than the original. Passes the `expandAllBranches` flag down to the `retrieveSchemaInternal()`
 * helper call.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which resolving a reference is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param recurseList - The list of recursive references already processed
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @returns - The list schemas retrieved after having all references resolved
 */
function resolveReference(validator, schema, rootSchema, expandAllBranches, recurseList, formData) {
    const updatedSchema = resolveAllReferences(schema, rootSchema, recurseList);
    if (updatedSchema !== schema) {
        // Only call this if the schema was actually changed by the `resolveAllReferences()` function
        return retrieveSchemaInternal(validator, updatedSchema, rootSchema, formData, expandAllBranches, recurseList);
    }
    return [schema];
}
/** Resolves all references within the schema itself as well as any of its properties and array items.
 *
 * @param schema - The schema for which resolving all references is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param recurseList - List of $refs already resolved to prevent recursion
 * @returns - given schema will all references resolved or the original schema if no internal `$refs` were resolved
 */
function resolveAllReferences(schema, rootSchema, recurseList) {
    if (!(0,_isObject__WEBPACK_IMPORTED_MODULE_12__["default"])(schema)) {
        return schema;
    }
    let resolvedSchema = schema;
    // resolve top level ref
    if (_constants__WEBPACK_IMPORTED_MODULE_8__.REF_KEY in resolvedSchema) {
        const { $ref, ...localSchema } = resolvedSchema;
        // Check for a recursive reference and stop the loop
        if (recurseList.includes($ref)) {
            return resolvedSchema;
        }
        recurseList.push($ref);
        // Retrieve the referenced schema definition.
        const refSchema = (0,_findSchemaDefinition__WEBPACK_IMPORTED_MODULE_9__["default"])($ref, rootSchema);
        resolvedSchema = { ...refSchema, ...localSchema };
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_8__.PROPERTIES_KEY in resolvedSchema) {
        const childrenLists = [];
        const updatedProps = lodash_transform__WEBPACK_IMPORTED_MODULE_3___default()(resolvedSchema[_constants__WEBPACK_IMPORTED_MODULE_8__.PROPERTIES_KEY], (result, value, key) => {
            const childList = [...recurseList];
            result[key] = resolveAllReferences(value, rootSchema, childList);
            childrenLists.push(childList);
        }, {});
        lodash_merge__WEBPACK_IMPORTED_MODULE_4___default()(recurseList, lodash_uniq__WEBPACK_IMPORTED_MODULE_6___default()(lodash_flattenDeep__WEBPACK_IMPORTED_MODULE_5___default()(childrenLists)));
        resolvedSchema = { ...resolvedSchema, [_constants__WEBPACK_IMPORTED_MODULE_8__.PROPERTIES_KEY]: updatedProps };
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_8__.ITEMS_KEY in resolvedSchema &&
        !Array.isArray(resolvedSchema.items) &&
        typeof resolvedSchema.items !== 'boolean') {
        resolvedSchema = {
            ...resolvedSchema,
            items: resolveAllReferences(resolvedSchema.items, rootSchema, recurseList),
        };
    }
    return (0,_deepEquals__WEBPACK_IMPORTED_MODULE_15__["default"])(schema, resolvedSchema) ? schema : resolvedSchema;
}
/** Creates new 'properties' items for each key in the `formData`
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param theSchema - The schema for which the existing additional properties is desired
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s * @param validator
 * @param [aFormData] - The current formData, if any, to assist retrieving a schema
 * @returns - The updated schema with additional properties stubbed
 */
function stubExistingAdditionalProperties(validator, theSchema, rootSchema, aFormData) {
    // Clone the schema so that we don't ruin the consumer's original
    const schema = {
        ...theSchema,
        properties: { ...theSchema.properties },
    };
    // make sure formData is an object
    const formData = aFormData && (0,_isObject__WEBPACK_IMPORTED_MODULE_12__["default"])(aFormData) ? aFormData : {};
    Object.keys(formData).forEach((key) => {
        if (key in schema.properties) {
            // No need to stub, our schema already has the property
            return;
        }
        let additionalProperties = {};
        if (typeof schema.additionalProperties !== 'boolean') {
            if (_constants__WEBPACK_IMPORTED_MODULE_8__.REF_KEY in schema.additionalProperties) {
                additionalProperties = retrieveSchema(validator, { $ref: lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(schema.additionalProperties, [_constants__WEBPACK_IMPORTED_MODULE_8__.REF_KEY]) }, rootSchema, formData);
            }
            else if ('type' in schema.additionalProperties) {
                additionalProperties = { ...schema.additionalProperties };
            }
            else if (_constants__WEBPACK_IMPORTED_MODULE_8__.ANY_OF_KEY in schema.additionalProperties || _constants__WEBPACK_IMPORTED_MODULE_8__.ONE_OF_KEY in schema.additionalProperties) {
                additionalProperties = {
                    type: 'object',
                    ...schema.additionalProperties,
                };
            }
            else {
                additionalProperties = { type: (0,_guessType__WEBPACK_IMPORTED_MODULE_11__["default"])(lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [key])) };
            }
        }
        else {
            additionalProperties = { type: (0,_guessType__WEBPACK_IMPORTED_MODULE_11__["default"])(lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [key])) };
        }
        // The type of our new key should match the additionalProperties value;
        schema.properties[key] = additionalProperties;
        // Set our additional property flag so we know it was dynamically added
        lodash_set__WEBPACK_IMPORTED_MODULE_1___default()(schema.properties, [key, _constants__WEBPACK_IMPORTED_MODULE_8__.ADDITIONAL_PROPERTY_FLAG], true);
    });
    return schema;
}
/** Internal handler that retrieves an expanded schema that has had all of its conditions, additional properties,
 * references and dependencies resolved and merged into the `schema` given a `validator`, `rootSchema` and `rawFormData`
 * that is used to do the potentially recursive resolution. If `expandAllBranches` is true, then all possible branches
 * of the schema and its references, conditions and dependencies are returned.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which retrieving a schema is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param [rawFormData] - The current formData, if any, to assist retrieving a schema
 * @param [expandAllBranches=false] - Flag, if true, will return all possible branches of conditions, any/oneOf and
 *          dependencies as a list of schemas
 * @param [recurseList=[]] - The optional, list of recursive references already processed
 * @returns - The schema(s) resulting from having its conditions, additional properties, references and dependencies
 *          resolved. Multiple schemas may be returned if `expandAllBranches` is true.
 */
function retrieveSchemaInternal(validator, schema, rootSchema, rawFormData, expandAllBranches = false, recurseList = []) {
    if (!(0,_isObject__WEBPACK_IMPORTED_MODULE_12__["default"])(schema)) {
        return [{}];
    }
    const resolvedSchemas = resolveSchema(validator, schema, rootSchema, expandAllBranches, recurseList, rawFormData);
    return resolvedSchemas.flatMap((s) => {
        let resolvedSchema = s;
        if (_constants__WEBPACK_IMPORTED_MODULE_8__.IF_KEY in resolvedSchema) {
            return resolveCondition(validator, resolvedSchema, rootSchema, expandAllBranches, recurseList, rawFormData);
        }
        if (_constants__WEBPACK_IMPORTED_MODULE_8__.ALL_OF_KEY in resolvedSchema) {
            // resolve allOf schemas
            if (expandAllBranches) {
                const { allOf, ...restOfSchema } = resolvedSchema;
                return [...allOf, restOfSchema];
            }
            try {
                resolvedSchema = json_schema_merge_allof__WEBPACK_IMPORTED_MODULE_7___default()(resolvedSchema, {
                    deep: false,
                });
            }
            catch (e) {
                console.warn('could not merge subschemas in allOf:\n', e);
                const { allOf, ...resolvedSchemaWithoutAllOf } = resolvedSchema;
                return resolvedSchemaWithoutAllOf;
            }
        }
        const hasAdditionalProperties = _constants__WEBPACK_IMPORTED_MODULE_8__.ADDITIONAL_PROPERTIES_KEY in resolvedSchema && resolvedSchema.additionalProperties !== false;
        if (hasAdditionalProperties) {
            return stubExistingAdditionalProperties(validator, resolvedSchema, rootSchema, rawFormData);
        }
        return resolvedSchema;
    });
}
/** Resolves an `anyOf` or `oneOf` within a schema (if present) to the list of schemas returned from
 * `retrieveSchemaInternal()` for the best matching option. If `expandAllBranches` is true, then a list of schemas for ALL
 * options are retrieved and returned.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which retrieving a schema is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param [rawFormData] - The current formData, if any, to assist retrieving a schema, defaults to an empty object
 * @returns - Either an array containing the best matching option or all options if `expandAllBranches` is true
 */
function resolveAnyOrOneOfSchemas(validator, schema, rootSchema, expandAllBranches, rawFormData) {
    let anyOrOneOf;
    const { oneOf, anyOf, ...remaining } = schema;
    if (Array.isArray(oneOf)) {
        anyOrOneOf = oneOf;
    }
    else if (Array.isArray(anyOf)) {
        anyOrOneOf = anyOf;
    }
    if (anyOrOneOf) {
        // Ensure that during expand all branches we pass an object rather than undefined so that all options are interrogated
        const formData = rawFormData === undefined && expandAllBranches ? {} : rawFormData;
        const discriminator = (0,_getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_10__["default"])(schema);
        anyOrOneOf = anyOrOneOf.map((s) => {
            // Due to anyOf/oneOf possibly using the same $ref we always pass a fresh recurse list array so that each option
            // can resolve recursive references independently
            return resolveAllReferences(s, rootSchema, []);
        });
        // Call this to trigger the set of isValid() calls that the schema parser will need
        const option = (0,_getFirstMatchingOption__WEBPACK_IMPORTED_MODULE_14__["default"])(validator, formData, anyOrOneOf, rootSchema, discriminator);
        if (expandAllBranches) {
            return anyOrOneOf.map((item) => (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_13__["default"])(remaining, item));
        }
        schema = (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_13__["default"])(remaining, anyOrOneOf[option]);
    }
    return [schema];
}
/** Resolves dependencies within a schema and its 'anyOf/oneOf' children. Passes the `expandAllBranches` flag down to
 * the `resolveAnyOrOneOfSchema()` and `processDependencies()` helper calls.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which resolving a dependency is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param recurseList - The list of recursive references already processed
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @returns - The list of schemas with their dependencies resolved
 */
function resolveDependencies(validator, schema, rootSchema, expandAllBranches, recurseList, formData) {
    // Drop the dependencies from the source schema.
    const { dependencies, ...remainingSchema } = schema;
    const resolvedSchemas = resolveAnyOrOneOfSchemas(validator, remainingSchema, rootSchema, expandAllBranches, formData);
    return resolvedSchemas.flatMap((resolvedSchema) => processDependencies(validator, dependencies, resolvedSchema, rootSchema, expandAllBranches, recurseList, formData));
}
/** Processes all the `dependencies` recursively into the list of `resolvedSchema`s as needed. Passes the
 * `expandAllBranches` flag down to the `withDependentSchema()` and the recursive `processDependencies()` helper calls.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param dependencies - The set of dependencies that needs to be processed
 * @param resolvedSchema - The schema for which processing dependencies is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param recurseList - The list of recursive references already processed
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @returns - The schema with the `dependencies` resolved into it
 */
function processDependencies(validator, dependencies, resolvedSchema, rootSchema, expandAllBranches, recurseList, formData) {
    let schemas = [resolvedSchema];
    // Process dependencies updating the local schema properties as appropriate.
    for (const dependencyKey in dependencies) {
        // Skip this dependency if its trigger property is not present.
        if (!expandAllBranches && lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [dependencyKey]) === undefined) {
            continue;
        }
        // Skip this dependency if it is not included in the schema (such as when dependencyKey is itself a hidden dependency.)
        if (resolvedSchema.properties && !(dependencyKey in resolvedSchema.properties)) {
            continue;
        }
        const [remainingDependencies, dependencyValue] = (0,_findSchemaDefinition__WEBPACK_IMPORTED_MODULE_9__.splitKeyElementFromObject)(dependencyKey, dependencies);
        if (Array.isArray(dependencyValue)) {
            schemas[0] = withDependentProperties(resolvedSchema, dependencyValue);
        }
        else if ((0,_isObject__WEBPACK_IMPORTED_MODULE_12__["default"])(dependencyValue)) {
            schemas = withDependentSchema(validator, resolvedSchema, rootSchema, dependencyKey, dependencyValue, expandAllBranches, recurseList, formData);
        }
        return schemas.flatMap((schema) => processDependencies(validator, remainingDependencies, schema, rootSchema, expandAllBranches, recurseList, formData));
    }
    return schemas;
}
/** Updates a schema with additionally required properties added
 *
 * @param schema - The schema for which resolving a dependent properties is desired
 * @param [additionallyRequired] - An optional array of additionally required names
 * @returns - The schema with the additional required values merged in
 */
function withDependentProperties(schema, additionallyRequired) {
    if (!additionallyRequired) {
        return schema;
    }
    const required = Array.isArray(schema.required)
        ? Array.from(new Set([...schema.required, ...additionallyRequired]))
        : additionallyRequired;
    return { ...schema, required: required };
}
/** Merges a dependent schema into the `schema` dealing with oneOfs and references. Passes the `expandAllBranches` flag
 * down to the `retrieveSchemaInternal()`, `resolveReference()` and `withExactlyOneSubschema()` helper calls.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be forwarded to all the APIs
 * @param schema - The schema for which resolving a dependent schema is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param dependencyKey - The key name of the dependency
 * @param dependencyValue - The potentially dependent schema
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param recurseList - The list of recursive references already processed
 * @param [formData]- The current formData to assist retrieving a schema
 * @returns - The list of schemas with the dependent schema resolved into them
 */
function withDependentSchema(validator, schema, rootSchema, dependencyKey, dependencyValue, expandAllBranches, recurseList, formData) {
    const dependentSchemas = retrieveSchemaInternal(validator, dependencyValue, rootSchema, formData, expandAllBranches, recurseList);
    return dependentSchemas.flatMap((dependent) => {
        const { oneOf, ...dependentSchema } = dependent;
        schema = (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_13__["default"])(schema, dependentSchema);
        // Since it does not contain oneOf, we return the original schema.
        if (oneOf === undefined) {
            return schema;
        }
        // Resolve $refs inside oneOf.
        const resolvedOneOfs = oneOf.map((subschema) => {
            if (typeof subschema === 'boolean' || !(_constants__WEBPACK_IMPORTED_MODULE_8__.REF_KEY in subschema)) {
                return [subschema];
            }
            return resolveReference(validator, subschema, rootSchema, expandAllBranches, recurseList, formData);
        });
        const allPermutations = getAllPermutationsOfXxxOf(resolvedOneOfs);
        return allPermutations.flatMap((resolvedOneOf) => withExactlyOneSubschema(validator, schema, rootSchema, dependencyKey, resolvedOneOf, expandAllBranches, recurseList, formData));
    });
}
/** Returns a list of `schema`s with the best choice from the `oneOf` options merged into it. If `expandAllBranches` is
 * true, then a list of schemas for ALL options are retrieved and returned. Passes the `expandAllBranches` flag down to
 * the `retrieveSchemaInternal()` helper call.
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used to validate oneOf options
 * @param schema - The schema for which resolving a oneOf subschema is desired
 * @param rootSchema - The root schema that will be forwarded to all the APIs
 * @param dependencyKey - The key name of the oneOf dependency
 * @param oneOf - The list of schemas representing the oneOf options
 * @param expandAllBranches - Flag, if true, will return all possible branches of conditions, any/oneOf and dependencies
 *          as a list of schemas
 * @param recurseList - The list of recursive references already processed
 * @param [formData] - The current formData to assist retrieving a schema
 * @returns - Either an array containing the best matching option or all options if `expandAllBranches` is true
 */
function withExactlyOneSubschema(validator, schema, rootSchema, dependencyKey, oneOf, expandAllBranches, recurseList, formData) {
    const validSubschemas = oneOf.filter((subschema) => {
        if (typeof subschema === 'boolean' || !subschema || !subschema.properties) {
            return false;
        }
        const { [dependencyKey]: conditionPropertySchema } = subschema.properties;
        if (conditionPropertySchema) {
            const conditionSchema = {
                type: 'object',
                properties: {
                    [dependencyKey]: conditionPropertySchema,
                },
            };
            return validator.isValid(conditionSchema, formData, rootSchema) || expandAllBranches;
        }
        return false;
    });
    if (!expandAllBranches && validSubschemas.length !== 1) {
        console.warn("ignoring oneOf in dependencies because there isn't exactly one subschema that is valid");
        return [schema];
    }
    return validSubschemas.flatMap((s) => {
        const subschema = s;
        const [dependentSubschema] = (0,_findSchemaDefinition__WEBPACK_IMPORTED_MODULE_9__.splitKeyElementFromObject)(dependencyKey, subschema.properties);
        const dependentSchema = { ...subschema, properties: dependentSubschema };
        const schemas = retrieveSchemaInternal(validator, dependentSchema, rootSchema, formData, expandAllBranches, recurseList);
        return schemas.map((s) => (0,_mergeSchemas__WEBPACK_IMPORTED_MODULE_13__["default"])(schema, s));
    });
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/sanitizeDataForNewSchema.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/sanitizeDataForNewSchema.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ sanitizeDataForNewSchema)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_has__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/has */ "../../node_modules/lodash/has.js");
/* harmony import */ var lodash_has__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_has__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _retrieveSchema__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./retrieveSchema */ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js");




const NO_VALUE = Symbol('no Value');
/** Sanitize the `data` associated with the `oldSchema` so it is considered appropriate for the `newSchema`. If the new
 * schema does not contain any properties, then `undefined` is returned to clear all the form data. Due to the nature
 * of schemas, this sanitization happens recursively for nested objects of data. Also, any properties in the old schema
 * that are non-existent in the new schema are set to `undefined`. The data sanitization process has the following flow:
 *
 * - If the new schema is an object that contains a `properties` object then:
 *   - Create a `removeOldSchemaData` object, setting each key in the `oldSchema.properties` having `data` to undefined
 *   - Create an empty `nestedData` object for use in the key filtering below:
 *   - Iterate over each key in the `newSchema.properties` as follows:
 *     - Get the `formValue` of the key from the `data`
 *     - Get the `oldKeySchema` and `newKeyedSchema` for the key, defaulting to `{}` when it doesn't exist
 *     - Retrieve the schema for any refs within each `oldKeySchema` and/or `newKeySchema`
 *     - Get the types of the old and new keyed schemas and if the old doesn't exist or the old & new are the same then:
 *       - If `removeOldSchemaData` has an entry for the key, delete it since the new schema has the same property
 *       - If type of the key in the new schema is `object`:
 *         - Store the value from the recursive `sanitizeDataForNewSchema` call in `nestedData[key]`
 *       - Otherwise, check for default or const values:
 *         - Get the old and new `default` values from the schema and check:
 *           - If the new `default` value does not match the form value:
 *             - If the old `default` value DOES match the form value, then:
 *               - Replace `removeOldSchemaData[key]` with the new `default`
 *               - Otherwise, if the new schema is `readOnly` then replace `removeOldSchemaData[key]` with undefined
 *         - Get the old and new `const` values from the schema and check:
 *           - If the new `const` value does not match the form value:
 *           - If the old `const` value DOES match the form value, then:
 *             - Replace `removeOldSchemaData[key]` with the new `const`
 *             - Otherwise, replace `removeOldSchemaData[key]` with undefined
 *   - Once all keys have been processed, return an object built as follows:
 *     - `{ ...removeOldSchemaData, ...nestedData, ...pick(data, keysToKeep) }`
 * - If the new and old schema types are array and the `data` is an array then:
 *   - If the type of the old and new schema `items` are a non-array objects:
 *     - Retrieve the schema for any refs within each `oldKeySchema.items` and/or `newKeySchema.items`
 *     - If the `type`s of both items are the same (or the old does not have a type):
 *       - If the type is "object", then:
 *         - For each element in the `data` recursively sanitize the data, stopping at `maxItems` if specified
 *       - Otherwise, just return the `data` removing any values after `maxItems` if it is set
 *   - If the type of the old and new schema `items` are booleans of the same value, return `data` as is
 * - Otherwise return `undefined`
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param rootSchema - The root JSON schema of the entire form
 * @param [newSchema] - The new schema for which the data is being sanitized
 * @param [oldSchema] - The old schema from which the data originated
 * @param [data={}] - The form data associated with the schema, defaulting to an empty object when undefined
 * @returns - The new form data, with all the fields uniquely associated with the old schema set
 *      to `undefined`. Will return `undefined` if the new schema is not an object containing properties.
 */
function sanitizeDataForNewSchema(validator, rootSchema, newSchema, oldSchema, data = {}) {
    // By default, we will clear the form data
    let newFormData;
    // If the new schema is of type object and that object contains a list of properties
    if (lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(newSchema, _constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY)) {
        // Create an object containing root-level keys in the old schema, setting each key to undefined to remove the data
        const removeOldSchemaData = {};
        if (lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(oldSchema, _constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY)) {
            const properties = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(oldSchema, _constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY, {});
            Object.keys(properties).forEach((key) => {
                if (lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(data, key)) {
                    removeOldSchemaData[key] = undefined;
                }
            });
        }
        const keys = Object.keys(lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newSchema, _constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY, {}));
        // Create a place to store nested data that will be a side-effect of the filter
        const nestedData = {};
        keys.forEach((key) => {
            const formValue = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(data, key);
            let oldKeyedSchema = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(oldSchema, [_constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY, key], {});
            let newKeyedSchema = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newSchema, [_constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY, key], {});
            // Resolve the refs if they exist
            if (lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(oldKeyedSchema, _constants__WEBPACK_IMPORTED_MODULE_2__.REF_KEY)) {
                oldKeyedSchema = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_3__["default"])(validator, oldKeyedSchema, rootSchema, formValue);
            }
            if (lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(newKeyedSchema, _constants__WEBPACK_IMPORTED_MODULE_2__.REF_KEY)) {
                newKeyedSchema = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_3__["default"])(validator, newKeyedSchema, rootSchema, formValue);
            }
            // Now get types and see if they are the same
            const oldSchemaTypeForKey = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(oldKeyedSchema, 'type');
            const newSchemaTypeForKey = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newKeyedSchema, 'type');
            // Check if the old option has the same key with the same type
            if (!oldSchemaTypeForKey || oldSchemaTypeForKey === newSchemaTypeForKey) {
                if (lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(removeOldSchemaData, key)) {
                    // SIDE-EFFECT: remove the undefined value for a key that has the same type between the old and new schemas
                    delete removeOldSchemaData[key];
                }
                // If it is an object, we'll recurse and store the resulting sanitized data for the key
                if (newSchemaTypeForKey === 'object' || (newSchemaTypeForKey === 'array' && Array.isArray(formValue))) {
                    // SIDE-EFFECT: process the new schema type of object recursively to save iterations
                    const itemData = sanitizeDataForNewSchema(validator, rootSchema, newKeyedSchema, oldKeyedSchema, formValue);
                    if (itemData !== undefined || newSchemaTypeForKey === 'array') {
                        // only put undefined values for the array type and not the object type
                        nestedData[key] = itemData;
                    }
                }
                else {
                    // Ok, the non-object types match, let's make sure that a default or a const of a different value is replaced
                    // with the new default or const. This allows the case where two schemas differ that only by the default/const
                    // value to be properly selected
                    const newOptionDefault = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newKeyedSchema, 'default', NO_VALUE);
                    const oldOptionDefault = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(oldKeyedSchema, 'default', NO_VALUE);
                    if (newOptionDefault !== NO_VALUE && newOptionDefault !== formValue) {
                        if (oldOptionDefault === formValue) {
                            // If the old default matches the formValue, we'll update the new value to match the new default
                            removeOldSchemaData[key] = newOptionDefault;
                        }
                        else if (lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newKeyedSchema, 'readOnly') === true) {
                            // If the new schema has the default set to read-only, treat it like a const and remove the value
                            removeOldSchemaData[key] = undefined;
                        }
                    }
                    const newOptionConst = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newKeyedSchema, 'const', NO_VALUE);
                    const oldOptionConst = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(oldKeyedSchema, 'const', NO_VALUE);
                    if (newOptionConst !== NO_VALUE && newOptionConst !== formValue) {
                        // Since this is a const, if the old value matches, replace the value with the new const otherwise clear it
                        removeOldSchemaData[key] = oldOptionConst === formValue ? newOptionConst : undefined;
                    }
                }
            }
        });
        newFormData = {
            ...(typeof data == 'string' || Array.isArray(data) ? undefined : data),
            ...removeOldSchemaData,
            ...nestedData,
        };
        // First apply removing the old schema data, then apply the nested data, then apply the old data keys to keep
    }
    else if (lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(oldSchema, 'type') === 'array' && lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newSchema, 'type') === 'array' && Array.isArray(data)) {
        let oldSchemaItems = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(oldSchema, 'items');
        let newSchemaItems = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newSchema, 'items');
        // If any of the array types `items` are arrays (remember arrays are objects) then we'll just drop the data
        // Eventually, we may want to deal with when either of the `items` are arrays since those tuple validations
        if (typeof oldSchemaItems === 'object' &&
            typeof newSchemaItems === 'object' &&
            !Array.isArray(oldSchemaItems) &&
            !Array.isArray(newSchemaItems)) {
            if (lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(oldSchemaItems, _constants__WEBPACK_IMPORTED_MODULE_2__.REF_KEY)) {
                oldSchemaItems = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_3__["default"])(validator, oldSchemaItems, rootSchema, data);
            }
            if (lodash_has__WEBPACK_IMPORTED_MODULE_1___default()(newSchemaItems, _constants__WEBPACK_IMPORTED_MODULE_2__.REF_KEY)) {
                newSchemaItems = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_3__["default"])(validator, newSchemaItems, rootSchema, data);
            }
            // Now get types and see if they are the same
            const oldSchemaType = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(oldSchemaItems, 'type');
            const newSchemaType = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newSchemaItems, 'type');
            // Check if the old option has the same key with the same type
            if (!oldSchemaType || oldSchemaType === newSchemaType) {
                const maxItems = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(newSchema, 'maxItems', -1);
                if (newSchemaType === 'object') {
                    newFormData = data.reduce((newValue, aValue) => {
                        const itemValue = sanitizeDataForNewSchema(validator, rootSchema, newSchemaItems, oldSchemaItems, aValue);
                        if (itemValue !== undefined && (maxItems < 0 || newValue.length < maxItems)) {
                            newValue.push(itemValue);
                        }
                        return newValue;
                    }, []);
                }
                else {
                    newFormData = maxItems > 0 && data.length > maxItems ? data.slice(0, maxItems) : data;
                }
            }
        }
        else if (typeof oldSchemaItems === 'boolean' &&
            typeof newSchemaItems === 'boolean' &&
            oldSchemaItems === newSchemaItems) {
            // If they are both booleans and have the same value just return the data as is otherwise fall-thru to undefined
            newFormData = data;
        }
        // Also probably want to deal with `prefixItems` as tuples with the latest 2020 draft
    }
    return newFormData;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/toIdSchema.js":
/*!***************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/toIdSchema.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ toIdSchema)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _isObject__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../isObject */ "../../node_modules/@rjsf/utils/lib/isObject.js");
/* harmony import */ var _retrieveSchema__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./retrieveSchema */ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js");
/* harmony import */ var _getSchemaType__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../getSchemaType */ "../../node_modules/@rjsf/utils/lib/getSchemaType.js");
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");






/** An internal helper that generates an `IdSchema` object for the `schema`, recursively with protection against
 * infinite recursion
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param schema - The schema for which the `IdSchema` is desired
 * @param idPrefix - The prefix to use for the id
 * @param idSeparator - The separator to use for the path segments in the id
 * @param [id] - The base id for the schema
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @param [_recurseList=[]] - The list of retrieved schemas currently being recursed, used to prevent infinite recursion
 * @returns - The `IdSchema` object for the `schema`
 */
function toIdSchemaInternal(validator, schema, idPrefix, idSeparator, id, rootSchema, formData, _recurseList = []) {
    if (_constants__WEBPACK_IMPORTED_MODULE_1__.REF_KEY in schema || _constants__WEBPACK_IMPORTED_MODULE_1__.DEPENDENCIES_KEY in schema || _constants__WEBPACK_IMPORTED_MODULE_1__.ALL_OF_KEY in schema) {
        const _schema = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_3__["default"])(validator, schema, rootSchema, formData);
        const sameSchemaIndex = _recurseList.findIndex((item) => (0,_deepEquals__WEBPACK_IMPORTED_MODULE_5__["default"])(item, _schema));
        if (sameSchemaIndex === -1) {
            return toIdSchemaInternal(validator, _schema, idPrefix, idSeparator, id, rootSchema, formData, _recurseList.concat(_schema));
        }
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_1__.ITEMS_KEY in schema && !lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(schema, [_constants__WEBPACK_IMPORTED_MODULE_1__.ITEMS_KEY, _constants__WEBPACK_IMPORTED_MODULE_1__.REF_KEY])) {
        return toIdSchemaInternal(validator, lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(schema, _constants__WEBPACK_IMPORTED_MODULE_1__.ITEMS_KEY), idPrefix, idSeparator, id, rootSchema, formData, _recurseList);
    }
    const $id = id || idPrefix;
    const idSchema = { $id };
    if ((0,_getSchemaType__WEBPACK_IMPORTED_MODULE_4__["default"])(schema) === 'object' && _constants__WEBPACK_IMPORTED_MODULE_1__.PROPERTIES_KEY in schema) {
        for (const name in schema.properties) {
            const field = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(schema, [_constants__WEBPACK_IMPORTED_MODULE_1__.PROPERTIES_KEY, name]);
            const fieldId = idSchema[_constants__WEBPACK_IMPORTED_MODULE_1__.ID_KEY] + idSeparator + name;
            idSchema[name] = toIdSchemaInternal(validator, (0,_isObject__WEBPACK_IMPORTED_MODULE_2__["default"])(field) ? field : {}, idPrefix, idSeparator, fieldId, rootSchema, 
            // It's possible that formData is not an object -- this can happen if an
            // array item has just been added, but not populated with data yet
            lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [name]), _recurseList);
        }
    }
    return idSchema;
}
/** Generates an `IdSchema` object for the `schema`, recursively
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param schema - The schema for which the `IdSchema` is desired
 * @param [id] - The base id for the schema
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @param [idPrefix='root'] - The prefix to use for the id
 * @param [idSeparator='_'] - The separator to use for the path segments in the id
 * @returns - The `IdSchema` object for the `schema`
 */
function toIdSchema(validator, schema, id, rootSchema, formData, idPrefix = 'root', idSeparator = '_') {
    return toIdSchemaInternal(validator, schema, idPrefix, idSeparator, id, rootSchema, formData);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schema/toPathSchema.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schema/toPathSchema.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ toPathSchema)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/set */ "../../node_modules/lodash/set.js");
/* harmony import */ var lodash_set__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_set__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var _getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../getDiscriminatorFieldFromSchema */ "../../node_modules/@rjsf/utils/lib/getDiscriminatorFieldFromSchema.js");
/* harmony import */ var _getClosestMatchingOption__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getClosestMatchingOption */ "../../node_modules/@rjsf/utils/lib/schema/getClosestMatchingOption.js");
/* harmony import */ var _retrieveSchema__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./retrieveSchema */ "../../node_modules/@rjsf/utils/lib/schema/retrieveSchema.js");
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");







/** An internal helper that generates an `PathSchema` object for the `schema`, recursively with protection against
 * infinite recursion
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param schema - The schema for which the `PathSchema` is desired
 * @param [name=''] - The base name for the schema
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @param [_recurseList=[]] - The list of retrieved schemas currently being recursed, used to prevent infinite recursion
 * @returns - The `PathSchema` object for the `schema`
 */
function toPathSchemaInternal(validator, schema, name, rootSchema, formData, _recurseList = []) {
    if (_constants__WEBPACK_IMPORTED_MODULE_2__.REF_KEY in schema || _constants__WEBPACK_IMPORTED_MODULE_2__.DEPENDENCIES_KEY in schema || _constants__WEBPACK_IMPORTED_MODULE_2__.ALL_OF_KEY in schema) {
        const _schema = (0,_retrieveSchema__WEBPACK_IMPORTED_MODULE_5__["default"])(validator, schema, rootSchema, formData);
        const sameSchemaIndex = _recurseList.findIndex((item) => (0,_deepEquals__WEBPACK_IMPORTED_MODULE_6__["default"])(item, _schema));
        if (sameSchemaIndex === -1) {
            return toPathSchemaInternal(validator, _schema, name, rootSchema, formData, _recurseList.concat(_schema));
        }
    }
    let pathSchema = {
        [_constants__WEBPACK_IMPORTED_MODULE_2__.NAME_KEY]: name.replace(/^\./, ''),
    };
    if (_constants__WEBPACK_IMPORTED_MODULE_2__.ONE_OF_KEY in schema || _constants__WEBPACK_IMPORTED_MODULE_2__.ANY_OF_KEY in schema) {
        const xxxOf = _constants__WEBPACK_IMPORTED_MODULE_2__.ONE_OF_KEY in schema ? schema.oneOf : schema.anyOf;
        const discriminator = (0,_getDiscriminatorFieldFromSchema__WEBPACK_IMPORTED_MODULE_3__["default"])(schema);
        const index = (0,_getClosestMatchingOption__WEBPACK_IMPORTED_MODULE_4__["default"])(validator, rootSchema, formData, xxxOf, 0, discriminator);
        const _schema = xxxOf[index];
        pathSchema = {
            ...pathSchema,
            ...toPathSchemaInternal(validator, _schema, name, rootSchema, formData, _recurseList),
        };
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_2__.ADDITIONAL_PROPERTIES_KEY in schema && schema[_constants__WEBPACK_IMPORTED_MODULE_2__.ADDITIONAL_PROPERTIES_KEY] !== false) {
        lodash_set__WEBPACK_IMPORTED_MODULE_1___default()(pathSchema, _constants__WEBPACK_IMPORTED_MODULE_2__.RJSF_ADDITIONAL_PROPERTIES_FLAG, true);
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_2__.ITEMS_KEY in schema && Array.isArray(formData)) {
        const { items: schemaItems, additionalItems: schemaAdditionalItems } = schema;
        if (Array.isArray(schemaItems)) {
            formData.forEach((element, i) => {
                if (schemaItems[i]) {
                    pathSchema[i] = toPathSchemaInternal(validator, schemaItems[i], `${name}.${i}`, rootSchema, element, _recurseList);
                }
                else if (schemaAdditionalItems) {
                    pathSchema[i] = toPathSchemaInternal(validator, schemaAdditionalItems, `${name}.${i}`, rootSchema, element, _recurseList);
                }
                else {
                    console.warn(`Unable to generate path schema for "${name}.${i}". No schema defined for it`);
                }
            });
        }
        else {
            formData.forEach((element, i) => {
                pathSchema[i] = toPathSchemaInternal(validator, schemaItems, `${name}.${i}`, rootSchema, element, _recurseList);
            });
        }
    }
    else if (_constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY in schema) {
        for (const property in schema.properties) {
            const field = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(schema, [_constants__WEBPACK_IMPORTED_MODULE_2__.PROPERTIES_KEY, property]);
            pathSchema[property] = toPathSchemaInternal(validator, field, `${name}.${property}`, rootSchema, 
            // It's possible that formData is not an object -- this can happen if an
            // array item has just been added, but not populated with data yet
            lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(formData, [property]), _recurseList);
        }
    }
    return pathSchema;
}
/** Generates an `PathSchema` object for the `schema`, recursively
 *
 * @param validator - An implementation of the `ValidatorType` interface that will be used when necessary
 * @param schema - The schema for which the `PathSchema` is desired
 * @param [name=''] - The base name for the schema
 * @param [rootSchema] - The root schema, used to primarily to look up `$ref`s
 * @param [formData] - The current formData, if any, to assist retrieving a schema
 * @returns - The `PathSchema` object for the `schema`
 */
function toPathSchema(validator, schema, name = '', rootSchema, formData) {
    return toPathSchemaInternal(validator, schema, name, rootSchema, formData);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/schemaRequiresTrueValue.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/schemaRequiresTrueValue.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ schemaRequiresTrueValue)
/* harmony export */ });
/** Check to see if a `schema` specifies that a value must be true. This happens when:
 * - `schema.const` is truthy
 * - `schema.enum` == `[true]`
 * - `schema.anyOf` or `schema.oneOf` has a single value which recursively returns true
 * - `schema.allOf` has at least one value which recursively returns true
 *
 * @param schema - The schema to check
 * @returns - True if the schema specifies a value that must be true, false otherwise
 */
function schemaRequiresTrueValue(schema) {
    // Check if const is a truthy value
    if (schema.const) {
        return true;
    }
    // Check if an enum has a single value of true
    if (schema.enum && schema.enum.length === 1 && schema.enum[0] === true) {
        return true;
    }
    // If anyOf has a single value, evaluate the subschema
    if (schema.anyOf && schema.anyOf.length === 1) {
        return schemaRequiresTrueValue(schema.anyOf[0]);
    }
    // If oneOf has a single value, evaluate the subschema
    if (schema.oneOf && schema.oneOf.length === 1) {
        return schemaRequiresTrueValue(schema.oneOf[0]);
    }
    // Evaluate each subschema in allOf, to see if one of them requires a true value
    if (schema.allOf) {
        const schemaSome = (subSchema) => schemaRequiresTrueValue(subSchema);
        return schema.allOf.some(schemaSome);
    }
    return false;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/shouldRender.js":
/*!**********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/shouldRender.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ shouldRender)
/* harmony export */ });
/* harmony import */ var _deepEquals__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./deepEquals */ "../../node_modules/@rjsf/utils/lib/deepEquals.js");

/** Determines whether the given `component` should be rerendered by comparing its current set of props and state
 * against the next set. If either of those two sets are not the same, then the component should be rerendered.
 *
 * @param component - A React component being checked
 * @param nextProps - The next set of props against which to check
 * @param nextState - The next set of state against which to check
 * @returns - True if the component should be re-rendered, false otherwise
 */
function shouldRender(component, nextProps, nextState) {
    const { props, state } = component;
    return !(0,_deepEquals__WEBPACK_IMPORTED_MODULE_0__["default"])(props, nextProps) || !(0,_deepEquals__WEBPACK_IMPORTED_MODULE_0__["default"])(state, nextState);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/toConstant.js":
/*!********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/toConstant.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ toConstant)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");

/** Returns the constant value from the schema when it is either a single value enum or has a const key. Otherwise
 * throws an error.
 *
 * @param schema - The schema from which to obtain the constant value
 * @returns - The constant value for the schema
 * @throws - Error when the schema does not have a constant value
 */
function toConstant(schema) {
    if (_constants__WEBPACK_IMPORTED_MODULE_0__.ENUM_KEY in schema && Array.isArray(schema.enum) && schema.enum.length === 1) {
        return schema.enum[0];
    }
    if (_constants__WEBPACK_IMPORTED_MODULE_0__.CONST_KEY in schema) {
        return schema.const;
    }
    throw new Error('schema cannot be inferred as a constant');
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/toDateString.js":
/*!**********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/toDateString.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ toDateString)
/* harmony export */ });
/** Returns a UTC date string for the given `dateObject`. If `time` is false, then the time portion of the string is
 * removed.
 *
 * @param dateObject - The `DateObject` to convert to a date string
 * @param [time=true] - Optional flag used to remove the time portion of the date string if false
 * @returns - The UTC date string
 */
function toDateString(dateObject, time = true) {
    const { year, month, day, hour = 0, minute = 0, second = 0 } = dateObject;
    const utcTime = Date.UTC(year, month - 1, day, hour, minute, second);
    const datetime = new Date(utcTime).toJSON();
    return time ? datetime : datetime.slice(0, 10);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/toErrorList.js":
/*!*********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/toErrorList.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ toErrorList)
/* harmony export */ });
/* harmony import */ var lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/isPlainObject */ "../../node_modules/lodash/isPlainObject.js");
/* harmony import */ var lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");


/** Converts an `errorSchema` into a list of `RJSFValidationErrors`
 *
 * @param errorSchema - The `ErrorSchema` instance to convert
 * @param [fieldPath=[]] - The current field path, defaults to [] if not specified
 * @returns - The list of `RJSFValidationErrors` extracted from the `errorSchema`
 */
function toErrorList(errorSchema, fieldPath = []) {
    if (!errorSchema) {
        return [];
    }
    let errorList = [];
    if (_constants__WEBPACK_IMPORTED_MODULE_1__.ERRORS_KEY in errorSchema) {
        errorList = errorList.concat(errorSchema[_constants__WEBPACK_IMPORTED_MODULE_1__.ERRORS_KEY].map((message) => {
            const property = `.${fieldPath.join('.')}`;
            return {
                property,
                message,
                stack: `${property} ${message}`,
            };
        }));
    }
    return Object.keys(errorSchema).reduce((acc, key) => {
        if (key !== _constants__WEBPACK_IMPORTED_MODULE_1__.ERRORS_KEY) {
            const childSchema = errorSchema[key];
            if (lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0___default()(childSchema)) {
                acc = acc.concat(toErrorList(childSchema, [...fieldPath, key]));
            }
        }
        return acc;
    }, errorList);
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/toErrorSchema.js":
/*!***********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/toErrorSchema.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ toErrorSchema)
/* harmony export */ });
/* harmony import */ var lodash_toPath__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/toPath */ "../../node_modules/lodash/toPath.js");
/* harmony import */ var lodash_toPath__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_toPath__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _ErrorSchemaBuilder__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ErrorSchemaBuilder */ "../../node_modules/@rjsf/utils/lib/ErrorSchemaBuilder.js");


/** Transforms a rjsf validation errors list:
 * [
 *   {property: '.level1.level2[2].level3', message: 'err a'},
 *   {property: '.level1.level2[2].level3', message: 'err b'},
 *   {property: '.level1.level2[4].level3', message: 'err b'},
 * ]
 * Into an error tree:
 * {
 *   level1: {
 *     level2: {
 *       2: {level3: {errors: ['err a', 'err b']}},
 *       4: {level3: {errors: ['err b']}},
 *     }
 *   }
 * };
 *
 * @param errors - The list of RJSFValidationError objects
 * @returns - The `ErrorSchema` built from the list of `RJSFValidationErrors`
 */
function toErrorSchema(errors) {
    const builder = new _ErrorSchemaBuilder__WEBPACK_IMPORTED_MODULE_1__["default"]();
    if (errors.length) {
        errors.forEach((error) => {
            const { property, message } = error;
            // When the property is the root element, just use an empty array for the path
            const path = property === '.' ? [] : lodash_toPath__WEBPACK_IMPORTED_MODULE_0___default()(property);
            // If the property is at the root (.level1) then toPath creates
            // an empty array element at the first index. Remove it.
            if (path.length > 0 && path[0] === '') {
                path.splice(0, 1);
            }
            if (message) {
                builder.addErrors(message, path);
            }
        });
    }
    return builder.ErrorSchema;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/types.js":
/*!***************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/types.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);



/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/unwrapErrorHandler.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/unwrapErrorHandler.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ unwrapErrorHandler)
/* harmony export */ });
/* harmony import */ var lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/isPlainObject */ "../../node_modules/lodash/isPlainObject.js");
/* harmony import */ var lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0__);

/** Unwraps the `errorHandler` structure into the associated `ErrorSchema`, stripping the `addError()` functions from it
 *
 * @param errorHandler - The `FormValidation` error handling structure
 * @returns - The `ErrorSchema` resulting from the stripping of the `addError()` function
 */
function unwrapErrorHandler(errorHandler) {
    return Object.keys(errorHandler).reduce((acc, key) => {
        if (key === 'addError') {
            return acc;
        }
        else {
            const childSchema = errorHandler[key];
            if (lodash_isPlainObject__WEBPACK_IMPORTED_MODULE_0___default()(childSchema)) {
                return {
                    ...acc,
                    [key]: unwrapErrorHandler(childSchema),
                };
            }
            return { ...acc, [key]: childSchema };
        }
    }, {});
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/utcToLocal.js":
/*!********************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/utcToLocal.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ utcToLocal)
/* harmony export */ });
/* harmony import */ var _pad__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./pad */ "../../node_modules/@rjsf/utils/lib/pad.js");

/** Converts a UTC date string into a local Date format
 *
 * @param jsonDate - A UTC date string
 * @returns - An empty string when `jsonDate` is falsey, otherwise a date string in local format
 */
function utcToLocal(jsonDate) {
    if (!jsonDate) {
        return '';
    }
    // required format of `'yyyy-MM-ddThh:mm' followed by optional ':ss' or ':ss.SSS'
    // https://html.spec.whatwg.org/multipage/input.html#local-date-and-time-state-(type%3Ddatetime-local)
    // > should be a _valid local date and time string_ (not GMT)
    // Note - date constructor passed local ISO-8601 does not correctly
    // change time to UTC in node pre-8
    const date = new Date(jsonDate);
    const yyyy = (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(date.getFullYear(), 4);
    const MM = (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(date.getMonth() + 1, 2);
    const dd = (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(date.getDate(), 2);
    const hh = (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(date.getHours(), 2);
    const mm = (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(date.getMinutes(), 2);
    const ss = (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(date.getSeconds(), 2);
    const SSS = (0,_pad__WEBPACK_IMPORTED_MODULE_0__["default"])(date.getMilliseconds(), 3);
    return `${yyyy}-${MM}-${dd}T${hh}:${mm}:${ss}.${SSS}`;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/validationDataMerge.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/validationDataMerge.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ validationDataMerge)
/* harmony export */ });
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/isEmpty */ "../../node_modules/lodash/isEmpty.js");
/* harmony import */ var lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mergeObjects__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./mergeObjects */ "../../node_modules/@rjsf/utils/lib/mergeObjects.js");
/* harmony import */ var _toErrorList__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./toErrorList */ "../../node_modules/@rjsf/utils/lib/toErrorList.js");



/** Merges the errors in `additionalErrorSchema` into the existing `validationData` by combining the hierarchies in the
 * two `ErrorSchema`s and then appending the error list from the `additionalErrorSchema` obtained by calling
 * `toErrorList()` on the `errors` in the `validationData`. If no `additionalErrorSchema` is passed, then
 * `validationData` is returned.
 *
 * @param validationData - The current `ValidationData` into which to merge the additional errors
 * @param [additionalErrorSchema] - The optional additional set of errors in an `ErrorSchema`
 * @returns - The `validationData` with the additional errors from `additionalErrorSchema` merged into it, if provided.
 */
function validationDataMerge(validationData, additionalErrorSchema) {
    if (!additionalErrorSchema) {
        return validationData;
    }
    const { errors: oldErrors, errorSchema: oldErrorSchema } = validationData;
    let errors = (0,_toErrorList__WEBPACK_IMPORTED_MODULE_2__["default"])(additionalErrorSchema);
    let errorSchema = additionalErrorSchema;
    if (!lodash_isEmpty__WEBPACK_IMPORTED_MODULE_0___default()(oldErrorSchema)) {
        errorSchema = (0,_mergeObjects__WEBPACK_IMPORTED_MODULE_1__["default"])(oldErrorSchema, additionalErrorSchema, true);
        errors = [...oldErrors].concat(errors);
    }
    return { errorSchema, errors };
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/lib/withIdRefPrefix.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/lib/withIdRefPrefix.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ withIdRefPrefix)
/* harmony export */ });
/* harmony import */ var _constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants */ "../../node_modules/@rjsf/utils/lib/constants.js");
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash/isObject */ "../../node_modules/lodash/isObject.js");
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash_isObject__WEBPACK_IMPORTED_MODULE_1__);


/** Takes a `node` object and transforms any contained `$ref` node variables with a prefix, recursively calling
 * `withIdRefPrefix` for any other elements.
 *
 * @param node - The object node to which a ROOT_SCHEMA_PREFIX is added when a REF_KEY is part of it
 */
function withIdRefPrefixObject(node) {
    for (const key in node) {
        const realObj = node;
        const value = realObj[key];
        if (key === _constants__WEBPACK_IMPORTED_MODULE_0__.REF_KEY && typeof value === 'string' && value.startsWith('#')) {
            realObj[key] = _constants__WEBPACK_IMPORTED_MODULE_0__.ROOT_SCHEMA_PREFIX + value;
        }
        else {
            realObj[key] = withIdRefPrefix(value);
        }
    }
    return node;
}
/** Takes a `node` object list and transforms any contained `$ref` node variables with a prefix, recursively calling
 * `withIdRefPrefix` for any other elements.
 *
 * @param node - The list of object nodes to which a ROOT_SCHEMA_PREFIX is added when a REF_KEY is part of it
 */
function withIdRefPrefixArray(node) {
    for (let i = 0; i < node.length; i++) {
        node[i] = withIdRefPrefix(node[i]);
    }
    return node;
}
/** Recursively prefixes all `$ref`s in a schema with the value of the `ROOT_SCHEMA_PREFIX` constant.
 * This is used in isValid to make references to the rootSchema
 *
 * @param schemaNode - The object node to which a ROOT_SCHEMA_PREFIX is added when a REF_KEY is part of it
 * @returns - A copy of the `schemaNode` with updated `$ref`s
 */
function withIdRefPrefix(schemaNode) {
    if (Array.isArray(schemaNode)) {
        return withIdRefPrefixArray([...schemaNode]);
    }
    if (lodash_isObject__WEBPACK_IMPORTED_MODULE_1___default()(schemaNode)) {
        return withIdRefPrefixObject({ ...schemaNode });
    }
    return schemaNode;
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/node_modules/react-is/cjs/react-is.development.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/node_modules/react-is/cjs/react-is.development.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";
/**
 * @license React
 * react-is.development.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



if (true) {
  (function() {
'use strict';

// ATTENTION
// When adding new symbols to this file,
// Please consider also adding to 'react-devtools-shared/src/backend/ReactSymbols'
// The Symbol used to tag the ReactElement-like types.
var REACT_ELEMENT_TYPE = Symbol.for('react.element');
var REACT_PORTAL_TYPE = Symbol.for('react.portal');
var REACT_FRAGMENT_TYPE = Symbol.for('react.fragment');
var REACT_STRICT_MODE_TYPE = Symbol.for('react.strict_mode');
var REACT_PROFILER_TYPE = Symbol.for('react.profiler');
var REACT_PROVIDER_TYPE = Symbol.for('react.provider');
var REACT_CONTEXT_TYPE = Symbol.for('react.context');
var REACT_SERVER_CONTEXT_TYPE = Symbol.for('react.server_context');
var REACT_FORWARD_REF_TYPE = Symbol.for('react.forward_ref');
var REACT_SUSPENSE_TYPE = Symbol.for('react.suspense');
var REACT_SUSPENSE_LIST_TYPE = Symbol.for('react.suspense_list');
var REACT_MEMO_TYPE = Symbol.for('react.memo');
var REACT_LAZY_TYPE = Symbol.for('react.lazy');
var REACT_OFFSCREEN_TYPE = Symbol.for('react.offscreen');

// -----------------------------------------------------------------------------

var enableScopeAPI = false; // Experimental Create Event Handle API.
var enableCacheElement = false;
var enableTransitionTracing = false; // No known bugs, but needs performance testing

var enableLegacyHidden = false; // Enables unstable_avoidThisFallback feature in Fiber
// stuff. Intended to enable React core members to more easily debug scheduling
// issues in DEV builds.

var enableDebugTracing = false; // Track which Fiber(s) schedule render work.

var REACT_MODULE_REFERENCE;

{
  REACT_MODULE_REFERENCE = Symbol.for('react.module.reference');
}

function isValidElementType(type) {
  if (typeof type === 'string' || typeof type === 'function') {
    return true;
  } // Note: typeof might be other than 'symbol' or 'number' (e.g. if it's a polyfill).


  if (type === REACT_FRAGMENT_TYPE || type === REACT_PROFILER_TYPE || enableDebugTracing  || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || enableLegacyHidden  || type === REACT_OFFSCREEN_TYPE || enableScopeAPI  || enableCacheElement  || enableTransitionTracing ) {
    return true;
  }

  if (typeof type === 'object' && type !== null) {
    if (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || // This needs to include all possible module reference object
    // types supported by any Flight configuration anywhere since
    // we don't know which Flight build this will end up being used
    // with.
    type.$$typeof === REACT_MODULE_REFERENCE || type.getModuleId !== undefined) {
      return true;
    }
  }

  return false;
}

function typeOf(object) {
  if (typeof object === 'object' && object !== null) {
    var $$typeof = object.$$typeof;

    switch ($$typeof) {
      case REACT_ELEMENT_TYPE:
        var type = object.type;

        switch (type) {
          case REACT_FRAGMENT_TYPE:
          case REACT_PROFILER_TYPE:
          case REACT_STRICT_MODE_TYPE:
          case REACT_SUSPENSE_TYPE:
          case REACT_SUSPENSE_LIST_TYPE:
            return type;

          default:
            var $$typeofType = type && type.$$typeof;

            switch ($$typeofType) {
              case REACT_SERVER_CONTEXT_TYPE:
              case REACT_CONTEXT_TYPE:
              case REACT_FORWARD_REF_TYPE:
              case REACT_LAZY_TYPE:
              case REACT_MEMO_TYPE:
              case REACT_PROVIDER_TYPE:
                return $$typeofType;

              default:
                return $$typeof;
            }

        }

      case REACT_PORTAL_TYPE:
        return $$typeof;
    }
  }

  return undefined;
}
var ContextConsumer = REACT_CONTEXT_TYPE;
var ContextProvider = REACT_PROVIDER_TYPE;
var Element = REACT_ELEMENT_TYPE;
var ForwardRef = REACT_FORWARD_REF_TYPE;
var Fragment = REACT_FRAGMENT_TYPE;
var Lazy = REACT_LAZY_TYPE;
var Memo = REACT_MEMO_TYPE;
var Portal = REACT_PORTAL_TYPE;
var Profiler = REACT_PROFILER_TYPE;
var StrictMode = REACT_STRICT_MODE_TYPE;
var Suspense = REACT_SUSPENSE_TYPE;
var SuspenseList = REACT_SUSPENSE_LIST_TYPE;
var hasWarnedAboutDeprecatedIsAsyncMode = false;
var hasWarnedAboutDeprecatedIsConcurrentMode = false; // AsyncMode should be deprecated

function isAsyncMode(object) {
  {
    if (!hasWarnedAboutDeprecatedIsAsyncMode) {
      hasWarnedAboutDeprecatedIsAsyncMode = true; // Using console['warn'] to evade Babel and ESLint

      console['warn']('The ReactIs.isAsyncMode() alias has been deprecated, ' + 'and will be removed in React 18+.');
    }
  }

  return false;
}
function isConcurrentMode(object) {
  {
    if (!hasWarnedAboutDeprecatedIsConcurrentMode) {
      hasWarnedAboutDeprecatedIsConcurrentMode = true; // Using console['warn'] to evade Babel and ESLint

      console['warn']('The ReactIs.isConcurrentMode() alias has been deprecated, ' + 'and will be removed in React 18+.');
    }
  }

  return false;
}
function isContextConsumer(object) {
  return typeOf(object) === REACT_CONTEXT_TYPE;
}
function isContextProvider(object) {
  return typeOf(object) === REACT_PROVIDER_TYPE;
}
function isElement(object) {
  return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;
}
function isForwardRef(object) {
  return typeOf(object) === REACT_FORWARD_REF_TYPE;
}
function isFragment(object) {
  return typeOf(object) === REACT_FRAGMENT_TYPE;
}
function isLazy(object) {
  return typeOf(object) === REACT_LAZY_TYPE;
}
function isMemo(object) {
  return typeOf(object) === REACT_MEMO_TYPE;
}
function isPortal(object) {
  return typeOf(object) === REACT_PORTAL_TYPE;
}
function isProfiler(object) {
  return typeOf(object) === REACT_PROFILER_TYPE;
}
function isStrictMode(object) {
  return typeOf(object) === REACT_STRICT_MODE_TYPE;
}
function isSuspense(object) {
  return typeOf(object) === REACT_SUSPENSE_TYPE;
}
function isSuspenseList(object) {
  return typeOf(object) === REACT_SUSPENSE_LIST_TYPE;
}

exports.ContextConsumer = ContextConsumer;
exports.ContextProvider = ContextProvider;
exports.Element = Element;
exports.ForwardRef = ForwardRef;
exports.Fragment = Fragment;
exports.Lazy = Lazy;
exports.Memo = Memo;
exports.Portal = Portal;
exports.Profiler = Profiler;
exports.StrictMode = StrictMode;
exports.Suspense = Suspense;
exports.SuspenseList = SuspenseList;
exports.isAsyncMode = isAsyncMode;
exports.isConcurrentMode = isConcurrentMode;
exports.isContextConsumer = isContextConsumer;
exports.isContextProvider = isContextProvider;
exports.isElement = isElement;
exports.isForwardRef = isForwardRef;
exports.isFragment = isFragment;
exports.isLazy = isLazy;
exports.isMemo = isMemo;
exports.isPortal = isPortal;
exports.isProfiler = isProfiler;
exports.isStrictMode = isStrictMode;
exports.isSuspense = isSuspense;
exports.isSuspenseList = isSuspenseList;
exports.isValidElementType = isValidElementType;
exports.typeOf = typeOf;
  })();
}


/***/ }),

/***/ "../../node_modules/@rjsf/utils/node_modules/react-is/index.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@rjsf/utils/node_modules/react-is/index.js ***!
  \*********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


if (false) {} else {
  module.exports = __webpack_require__(/*! ./cjs/react-is.development.js */ "../../node_modules/@rjsf/utils/node_modules/react-is/cjs/react-is.development.js");
}


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/lib/createAjvInstance.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/lib/createAjvInstance.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   AJV_CONFIG: () => (/* binding */ AJV_CONFIG),
/* harmony export */   COLOR_FORMAT_REGEX: () => (/* binding */ COLOR_FORMAT_REGEX),
/* harmony export */   DATA_URL_FORMAT_REGEX: () => (/* binding */ DATA_URL_FORMAT_REGEX),
/* harmony export */   "default": () => (/* binding */ createAjvInstance)
/* harmony export */ });
/* harmony import */ var ajv__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ajv */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/ajv.js");
/* harmony import */ var ajv__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(ajv__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ajv_formats__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ajv-formats */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv-formats/dist/index.js");
/* harmony import */ var ajv_formats__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(ajv_formats__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lodash/isObject */ "../../node_modules/lodash/isObject.js");
/* harmony import */ var lodash_isObject__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash_isObject__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");




const AJV_CONFIG = {
    allErrors: true,
    multipleOfPrecision: 8,
    strict: false,
    verbose: true,
    discriminator: false, // TODO enable this in V6
};
const COLOR_FORMAT_REGEX = /^(#?([0-9A-Fa-f]{3}){1,2}\b|aqua|black|blue|fuchsia|gray|green|lime|maroon|navy|olive|orange|purple|red|silver|teal|white|yellow|(rgb\(\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*,\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*,\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*\))|(rgb\(\s*(\d?\d%|100%)+\s*,\s*(\d?\d%|100%)+\s*,\s*(\d?\d%|100%)+\s*\)))$/;
const DATA_URL_FORMAT_REGEX = /^data:([a-z]+\/[a-z0-9-+.]+)?;(?:name=(.*);)?base64,(.*)$/;
/** Creates an Ajv version 8 implementation object with standard support for the 'color` and `data-url` custom formats.
 * If `additionalMetaSchemas` are provided then the Ajv instance is modified to add each of the meta schemas in the
 * list. If `customFormats` are provided then those additional formats are added to the list of supported formats. If
 * `ajvOptionsOverrides` are provided then they are spread on top of the default `AJV_CONFIG` options when constructing
 * the `Ajv` instance. With Ajv v8, the JSON Schema formats are not provided by default, but can be plugged in. By
 * default, all formats from the `ajv-formats` library are added. To disable this capability, set the `ajvFormatOptions`
 * parameter to `false`. Additionally, you can configure the `ajv-formats` by providing a custom set of
 * [format options](https://github.com/ajv-validator/ajv-formats) to the `ajvFormatOptions` parameter.
 *
 * @param [additionalMetaSchemas] - The list of additional meta schemas that the validator can access
 * @param [customFormats] - The set of additional custom formats that the validator will support
 * @param [ajvOptionsOverrides={}] - The set of validator config override options
 * @param [ajvFormatOptions] - The `ajv-format` options to use when adding formats to `ajv`; pass `false` to disable it
 * @param [AjvClass] - The `Ajv` class to use when creating the validator instance
 */
function createAjvInstance(additionalMetaSchemas, customFormats, ajvOptionsOverrides = {}, ajvFormatOptions, AjvClass = (ajv__WEBPACK_IMPORTED_MODULE_0___default())) {
    const ajv = new AjvClass({ ...AJV_CONFIG, ...ajvOptionsOverrides });
    if (ajvFormatOptions) {
        ajv_formats__WEBPACK_IMPORTED_MODULE_1___default()(ajv, ajvFormatOptions);
    }
    else if (ajvFormatOptions !== false) {
        ajv_formats__WEBPACK_IMPORTED_MODULE_1___default()(ajv);
    }
    // add custom formats
    ajv.addFormat('data-url', DATA_URL_FORMAT_REGEX);
    ajv.addFormat('color', COLOR_FORMAT_REGEX);
    // Add RJSF-specific additional properties keywords so Ajv doesn't report errors if strict is enabled.
    ajv.addKeyword(_rjsf_utils__WEBPACK_IMPORTED_MODULE_3__.ADDITIONAL_PROPERTY_FLAG);
    ajv.addKeyword(_rjsf_utils__WEBPACK_IMPORTED_MODULE_3__.RJSF_ADDITIONAL_PROPERTIES_FLAG);
    // add more schemas to validate against
    if (Array.isArray(additionalMetaSchemas)) {
        ajv.addMetaSchema(additionalMetaSchemas);
    }
    // add more custom formats to validate against
    if (lodash_isObject__WEBPACK_IMPORTED_MODULE_2___default()(customFormats)) {
        Object.keys(customFormats).forEach((formatName) => {
            ajv.addFormat(formatName, customFormats[formatName]);
        });
    }
    return ajv;
}


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/lib/createPrecompiledValidator.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/lib/createPrecompiledValidator.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ createPrecompiledValidator)
/* harmony export */ });
/* harmony import */ var _precompiledValidator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./precompiledValidator */ "../../node_modules/@rjsf/validator-ajv8/lib/precompiledValidator.js");

/** Creates and returns a `ValidatorType` interface that is implemented with a precompiled validator. If a `localizer`
 * is provided, it is used to translate the messages generated by the underlying AJV validation.
 *
 * NOTE: The `validateFns` parameter is an object obtained by importing from a precompiled validation file created via
 * the `compileSchemaValidators()` function.
 *
 * @param validateFns - The map of the validation functions that are created by the `compileSchemaValidators()` function
 * @param rootSchema - The root schema that was used with the `compileSchemaValidators()` function
 * @param [localizer] - If provided, is used to localize a list of Ajv `ErrorObject`s
 * @returns - The precompiled validator implementation resulting from the set of parameters provided
 */
function createPrecompiledValidator(validateFns, rootSchema, localizer) {
    return new _precompiledValidator__WEBPACK_IMPORTED_MODULE_0__["default"](validateFns, rootSchema, localizer);
}


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/lib/customizeValidator.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/lib/customizeValidator.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ customizeValidator)
/* harmony export */ });
/* harmony import */ var _validator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./validator */ "../../node_modules/@rjsf/validator-ajv8/lib/validator.js");

/** Creates and returns a customized implementation of the `ValidatorType` with the given customization `options` if
 * provided. If a `localizer` is provided, it is used to translate the messages generated by the underlying AJV
 * validation.
 *
 * @param [options={}] - The `CustomValidatorOptionsType` options that are used to create the `ValidatorType` instance
 * @param [localizer] - If provided, is used to localize a list of Ajv `ErrorObject`s
 * @returns - The custom validator implementation resulting from the set of parameters provided
 */
function customizeValidator(options = {}, localizer) {
    return new _validator__WEBPACK_IMPORTED_MODULE_0__["default"](options, localizer);
}


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/lib/index.js":
/*!************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/lib/index.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createPrecompiledValidator: () => (/* reexport safe */ _createPrecompiledValidator__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   customizeValidator: () => (/* reexport safe */ _customizeValidator__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _customizeValidator__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./customizeValidator */ "../../node_modules/@rjsf/validator-ajv8/lib/customizeValidator.js");
/* harmony import */ var _createPrecompiledValidator__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./createPrecompiledValidator */ "../../node_modules/@rjsf/validator-ajv8/lib/createPrecompiledValidator.js");
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./types */ "../../node_modules/@rjsf/validator-ajv8/lib/types.js");




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_customizeValidator__WEBPACK_IMPORTED_MODULE_0__["default"])());


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/lib/precompiledValidator.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/lib/precompiledValidator.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AJV8PrecompiledValidator)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");
/* harmony import */ var _processRawValidationErrors__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./processRawValidationErrors */ "../../node_modules/@rjsf/validator-ajv8/lib/processRawValidationErrors.js");



/** `ValidatorType` implementation that uses an AJV 8 precompiled validator as created by the
 * `compileSchemaValidators()` function provided by the `@rjsf/validator-ajv8` library.
 */
class AJV8PrecompiledValidator {
    /** Constructs an `AJV8PrecompiledValidator` instance using the `validateFns` and `rootSchema`
     *
     * @param validateFns - The map of the validation functions that are generated by the `schemaCompile()` function
     * @param rootSchema - The root schema that was used with the `compileSchema()` function
     * @param [localizer] - If provided, is used to localize a list of Ajv `ErrorObject`s
     * @throws - Error when the base schema of the precompiled validator does not have a matching validator function
     */
    constructor(validateFns, rootSchema, localizer) {
        this.rootSchema = rootSchema;
        this.validateFns = validateFns;
        this.localizer = localizer;
        this.mainValidator = this.getValidator(rootSchema);
    }
    /** Returns the precompiled validator associated with the given `schema` from the map of precompiled validator
     * functions.
     *
     * @param schema - The schema for which a precompiled validator function is desired
     * @returns - The precompiled validator function associated with this schema
     */
    getValidator(schema) {
        const key = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(schema, _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.ID_KEY) || (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.hashForSchema)(schema);
        const validator = this.validateFns[key];
        if (!validator) {
            throw new Error(`No precompiled validator function was found for the given schema for "${key}"`);
        }
        return validator;
    }
    /** Ensures that the validator is using the same schema as the root schema used to construct the precompiled
     * validator. It first compares the given `schema` against the root schema and if they aren't the same, then it
     * checks against the resolved root schema, on the chance that a resolved version of the root schema was passed in
     * instead of the raw root schema.
     *
     * @param schema - The schema against which to validate the form data
     * @param [formData] - The form data to validate if any
     */
    ensureSameRootSchema(schema, formData) {
        if (!(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.deepEquals)(schema, this.rootSchema)) {
            // Resolve the root schema with the passed in form data since that may affect the resolution
            const resolvedRootSchema = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.retrieveSchema)(this, this.rootSchema, this.rootSchema, formData);
            if (!(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.deepEquals)(schema, resolvedRootSchema)) {
                throw new Error('The schema associated with the precompiled validator differs from the rootSchema provided for validation');
            }
        }
        return true;
    }
    /** Converts an `errorSchema` into a list of `RJSFValidationErrors`
     *
     * @param errorSchema - The `ErrorSchema` instance to convert
     * @param [fieldPath=[]] - The current field path, defaults to [] if not specified
     * @deprecated - Use the `toErrorList()` function provided by `@rjsf/utils` instead. This function will be removed in
     *        the next major release.
     */
    toErrorList(errorSchema, fieldPath = []) {
        return (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.toErrorList)(errorSchema, fieldPath);
    }
    /** Runs the pure validation of the `schema` and `formData` without any of the RJSF functionality. Provided for use
     * by the playground. Returns the `errors` from the validation
     *
     * @param schema - The schema against which to validate the form data
     * @param [formData] - The form data to validate, if any
     * @throws - Error when the schema provided does not match the base schema of the precompiled validator
     */
    rawValidation(schema, formData) {
        this.ensureSameRootSchema(schema, formData);
        this.mainValidator(formData);
        if (typeof this.localizer === 'function') {
            this.localizer(this.mainValidator.errors);
        }
        const errors = this.mainValidator.errors || undefined;
        // Clear errors to prevent persistent errors, see #1104
        this.mainValidator.errors = null;
        return { errors: errors };
    }
    /** This function processes the `formData` with an optional user contributed `customValidate` function, which receives
     * the form data and a `errorHandler` function that will be used to add custom validation errors for each field. Also
     * supports a `transformErrors` function that will take the raw AJV validation errors, prior to custom validation and
     * transform them in what ever way it chooses.
     *
     * @param formData - The form data to validate
     * @param schema - The schema against which to validate the form data
     * @param [customValidate] - An optional function that is used to perform custom validation
     * @param [transformErrors] - An optional function that is used to transform errors after AJV validation
     * @param [uiSchema] - An optional uiSchema that is passed to `transformErrors` and `customValidate`
     */
    validateFormData(formData, schema, customValidate, transformErrors, uiSchema) {
        const rawErrors = this.rawValidation(schema, formData);
        return (0,_processRawValidationErrors__WEBPACK_IMPORTED_MODULE_2__["default"])(this, rawErrors, formData, schema, customValidate, transformErrors, uiSchema);
    }
    /** Validates data against a schema, returning true if the data is valid, or false otherwise. If the schema is
     * invalid, then this function will return false.
     *
     * @param schema - The schema against which to validate the form data
     * @param formData - The form data to validate
     * @param rootSchema - The root schema used to provide $ref resolutions
     * @returns - true if the formData validates against the schema, false otherwise
     * @throws - Error when the schema provided does not match the base schema of the precompiled validator OR if there
     *        isn't a precompiled validator function associated with the schema
     */
    isValid(schema, formData, rootSchema) {
        this.ensureSameRootSchema(rootSchema, formData);
        if (lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(schema, _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.ID_KEY) === _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.JUNK_OPTION_ID) {
            return false;
        }
        const validator = this.getValidator(schema);
        return validator(formData);
    }
}


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/lib/processRawValidationErrors.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/lib/processRawValidationErrors.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ processRawValidationErrors),
/* harmony export */   transformRJSFValidationErrors: () => (/* binding */ transformRJSFValidationErrors)
/* harmony export */ });
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lodash/get */ "../../node_modules/lodash/get.js");
/* harmony import */ var lodash_get__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash_get__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");


/** Transforming the error output from ajv to format used by @rjsf/utils.
 * At some point, components should be updated to support ajv.
 *
 * @param errors - The list of AJV errors to convert to `RJSFValidationErrors`
 * @param [uiSchema] - An optional uiSchema that is passed to `transformErrors` and `customValidate`
 */
function transformRJSFValidationErrors(errors = [], uiSchema) {
    return errors.map((e) => {
        const { instancePath, keyword, params, schemaPath, parentSchema, ...rest } = e;
        let { message = '' } = rest;
        let property = instancePath.replace(/\//g, '.');
        let stack = `${property} ${message}`.trim();
        if ('missingProperty' in params) {
            property = property ? `${property}.${params.missingProperty}` : params.missingProperty;
            const currentProperty = params.missingProperty;
            const uiSchemaTitle = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getUiOptions)(lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(uiSchema, `${property.replace(/^\./, '')}`)).title;
            if (uiSchemaTitle) {
                message = message.replace(currentProperty, uiSchemaTitle);
            }
            else {
                const parentSchemaTitle = lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(parentSchema, [_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.PROPERTIES_KEY, currentProperty, 'title']);
                if (parentSchemaTitle) {
                    message = message.replace(currentProperty, parentSchemaTitle);
                }
            }
            stack = message;
        }
        else {
            const uiSchemaTitle = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getUiOptions)(lodash_get__WEBPACK_IMPORTED_MODULE_0___default()(uiSchema, `${property.replace(/^\./, '')}`)).title;
            if (uiSchemaTitle) {
                stack = `'${uiSchemaTitle}' ${message}`.trim();
            }
            else {
                const parentSchemaTitle = parentSchema === null || parentSchema === void 0 ? void 0 : parentSchema.title;
                if (parentSchemaTitle) {
                    stack = `'${parentSchemaTitle}' ${message}`.trim();
                }
            }
        }
        // put data in expected format
        return {
            name: keyword,
            property,
            message,
            params,
            stack,
            schemaPath,
        };
    });
}
/** This function processes the `formData` with an optional user contributed `customValidate` function, which receives
 * the form data and a `errorHandler` function that will be used to add custom validation errors for each field. Also
 * supports a `transformErrors` function that will take the raw AJV validation errors, prior to custom validation and
 * transform them in what ever way it chooses.
 *
 * @param validator - The `ValidatorType` implementation used for the `getDefaultFormState()` call
 * @param rawErrors - The list of raw `ErrorObject`s to process
 * @param formData - The form data to validate
 * @param schema - The schema against which to validate the form data
 * @param [customValidate] - An optional function that is used to perform custom validation
 * @param [transformErrors] - An optional function that is used to transform errors after AJV validation
 * @param [uiSchema] - An optional uiSchema that is passed to `transformErrors` and `customValidate`
 */
function processRawValidationErrors(validator, rawErrors, formData, schema, customValidate, transformErrors, uiSchema) {
    const { validationError: invalidSchemaError } = rawErrors;
    let errors = transformRJSFValidationErrors(rawErrors.errors, uiSchema);
    if (invalidSchemaError) {
        errors = [...errors, { stack: invalidSchemaError.message }];
    }
    if (typeof transformErrors === 'function') {
        errors = transformErrors(errors, uiSchema);
    }
    let errorSchema = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.toErrorSchema)(errors);
    if (invalidSchemaError) {
        errorSchema = {
            ...errorSchema,
            $schema: {
                __errors: [invalidSchemaError.message],
            },
        };
    }
    if (typeof customValidate !== 'function') {
        return { errors, errorSchema };
    }
    // Include form data with undefined values, which is required for custom validation.
    const newFormData = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.getDefaultFormState)(validator, schema, formData, schema, true);
    const errorHandler = customValidate(newFormData, (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.createErrorHandler)(newFormData), uiSchema);
    const userErrorSchema = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.unwrapErrorHandler)(errorHandler);
    return (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_1__.validationDataMerge)({ errors, errorSchema }, userErrorSchema);
}


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/lib/types.js":
/*!************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/lib/types.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);



/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/lib/validator.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/lib/validator.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ AJV8Validator)
/* harmony export */ });
/* harmony import */ var _rjsf_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @rjsf/utils */ "../../node_modules/@rjsf/utils/lib/index.js");
/* harmony import */ var _createAjvInstance__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./createAjvInstance */ "../../node_modules/@rjsf/validator-ajv8/lib/createAjvInstance.js");
/* harmony import */ var _processRawValidationErrors__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./processRawValidationErrors */ "../../node_modules/@rjsf/validator-ajv8/lib/processRawValidationErrors.js");



/** `ValidatorType` implementation that uses the AJV 8 validation mechanism.
 */
class AJV8Validator {
    /** Constructs an `AJV8Validator` instance using the `options`
     *
     * @param options - The `CustomValidatorOptionsType` options that are used to create the AJV instance
     * @param [localizer] - If provided, is used to localize a list of Ajv `ErrorObject`s
     */
    constructor(options, localizer) {
        const { additionalMetaSchemas, customFormats, ajvOptionsOverrides, ajvFormatOptions, AjvClass } = options;
        this.ajv = (0,_createAjvInstance__WEBPACK_IMPORTED_MODULE_1__["default"])(additionalMetaSchemas, customFormats, ajvOptionsOverrides, ajvFormatOptions, AjvClass);
        this.localizer = localizer;
    }
    /** Resets the internal AJV validator to clear schemas from it. Can be helpful for resetting the validator for tests.
     */
    reset() {
        this.ajv.removeSchema();
    }
    /** Converts an `errorSchema` into a list of `RJSFValidationErrors`
     *
     * @param errorSchema - The `ErrorSchema` instance to convert
     * @param [fieldPath=[]] - The current field path, defaults to [] if not specified
     * @deprecated - Use the `toErrorList()` function provided by `@rjsf/utils` instead. This function will be removed in
     *        the next major release.
     */
    toErrorList(errorSchema, fieldPath = []) {
        return (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_0__.toErrorList)(errorSchema, fieldPath);
    }
    /** Runs the pure validation of the `schema` and `formData` without any of the RJSF functionality. Provided for use
     * by the playground. Returns the `errors` from the validation
     *
     * @param schema - The schema against which to validate the form data   * @param schema
     * @param formData - The form data to validate
     */
    rawValidation(schema, formData) {
        let compilationError = undefined;
        let compiledValidator;
        if (schema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_0__.ID_KEY]) {
            compiledValidator = this.ajv.getSchema(schema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_0__.ID_KEY]);
        }
        try {
            if (compiledValidator === undefined) {
                compiledValidator = this.ajv.compile(schema);
            }
            compiledValidator(formData);
        }
        catch (err) {
            compilationError = err;
        }
        let errors;
        if (compiledValidator) {
            if (typeof this.localizer === 'function') {
                this.localizer(compiledValidator.errors);
            }
            errors = compiledValidator.errors || undefined;
            // Clear errors to prevent persistent errors, see #1104
            compiledValidator.errors = null;
        }
        return {
            errors: errors,
            validationError: compilationError,
        };
    }
    /** This function processes the `formData` with an optional user contributed `customValidate` function, which receives
     * the form data and a `errorHandler` function that will be used to add custom validation errors for each field. Also
     * supports a `transformErrors` function that will take the raw AJV validation errors, prior to custom validation and
     * transform them in what ever way it chooses.
     *
     * @param formData - The form data to validate
     * @param schema - The schema against which to validate the form data
     * @param [customValidate] - An optional function that is used to perform custom validation
     * @param [transformErrors] - An optional function that is used to transform errors after AJV validation
     * @param [uiSchema] - An optional uiSchema that is passed to `transformErrors` and `customValidate`
     */
    validateFormData(formData, schema, customValidate, transformErrors, uiSchema) {
        const rawErrors = this.rawValidation(schema, formData);
        return (0,_processRawValidationErrors__WEBPACK_IMPORTED_MODULE_2__["default"])(this, rawErrors, formData, schema, customValidate, transformErrors, uiSchema);
    }
    /**
     * This function checks if a schema needs to be added and if the root schemas don't match it removes the old root schema from the ajv instance and adds the new one.
     * @param rootSchema - The root schema used to provide $ref resolutions
     */
    handleSchemaUpdate(rootSchema) {
        var _a, _b;
        const rootSchemaId = (_a = rootSchema[_rjsf_utils__WEBPACK_IMPORTED_MODULE_0__.ID_KEY]) !== null && _a !== void 0 ? _a : _rjsf_utils__WEBPACK_IMPORTED_MODULE_0__.ROOT_SCHEMA_PREFIX;
        // add the rootSchema ROOT_SCHEMA_PREFIX as id.
        // if schema validator instance doesn't exist, add it.
        // else if the root schemas don't match, we should remove and add the root schema so we don't have to remove and recompile the schema every run.
        if (this.ajv.getSchema(rootSchemaId) === undefined) {
            this.ajv.addSchema(rootSchema, rootSchemaId);
        }
        else if (!(0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_0__.deepEquals)(rootSchema, (_b = this.ajv.getSchema(rootSchemaId)) === null || _b === void 0 ? void 0 : _b.schema)) {
            this.ajv.removeSchema(rootSchemaId);
            this.ajv.addSchema(rootSchema, rootSchemaId);
        }
    }
    /** Validates data against a schema, returning true if the data is valid, or
     * false otherwise. If the schema is invalid, then this function will return
     * false.
     *
     * @param schema - The schema against which to validate the form data
     * @param formData - The form data to validate
     * @param rootSchema - The root schema used to provide $ref resolutions
     */
    isValid(schema, formData, rootSchema) {
        var _a;
        try {
            this.handleSchemaUpdate(rootSchema);
            // then rewrite the schema ref's to point to the rootSchema
            // this accounts for the case where schema have references to models
            // that lives in the rootSchema but not in the schema in question.
            const schemaWithIdRefPrefix = (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_0__.withIdRefPrefix)(schema);
            const schemaId = (_a = schemaWithIdRefPrefix[_rjsf_utils__WEBPACK_IMPORTED_MODULE_0__.ID_KEY]) !== null && _a !== void 0 ? _a : (0,_rjsf_utils__WEBPACK_IMPORTED_MODULE_0__.hashForSchema)(schemaWithIdRefPrefix);
            let compiledValidator;
            compiledValidator = this.ajv.getSchema(schemaId);
            if (compiledValidator === undefined) {
                // Add schema by an explicit ID so it can be fetched later
                // Fall back to using compile if necessary
                // https://ajv.js.org/guide/managing-schemas.html#pre-adding-all-schemas-vs-adding-on-demand
                compiledValidator =
                    this.ajv.addSchema(schemaWithIdRefPrefix, schemaId).getSchema(schemaId) ||
                        this.ajv.compile(schemaWithIdRefPrefix);
            }
            const result = compiledValidator(formData);
            return result;
        }
        catch (e) {
            console.warn('Error encountered compiling schema:', e);
            return false;
        }
    }
}


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv-formats/dist/formats.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv-formats/dist/formats.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.formatNames = exports.fastFormats = exports.fullFormats = void 0;
function fmtDef(validate, compare) {
    return { validate, compare };
}
exports.fullFormats = {
    // date: http://tools.ietf.org/html/rfc3339#section-5.6
    date: fmtDef(date, compareDate),
    // date-time: http://tools.ietf.org/html/rfc3339#section-5.6
    time: fmtDef(time, compareTime),
    "date-time": fmtDef(date_time, compareDateTime),
    // duration: https://tools.ietf.org/html/rfc3339#appendix-A
    duration: /^P(?!$)((\d+Y)?(\d+M)?(\d+D)?(T(?=\d)(\d+H)?(\d+M)?(\d+S)?)?|(\d+W)?)$/,
    uri,
    "uri-reference": /^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,
    // uri-template: https://tools.ietf.org/html/rfc6570
    "uri-template": /^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i,
    // For the source: https://gist.github.com/dperini/729294
    // For test cases: https://mathiasbynens.be/demo/url-regex
    url: /^(?:https?|ftp):\/\/(?:\S+(?::\S*)?@)?(?:(?!(?:10|127)(?:\.\d{1,3}){3})(?!(?:169\.254|192\.168)(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z0-9\u{00a1}-\u{ffff}]+-)*[a-z0-9\u{00a1}-\u{ffff}]+)(?:\.(?:[a-z0-9\u{00a1}-\u{ffff}]+-)*[a-z0-9\u{00a1}-\u{ffff}]+)*(?:\.(?:[a-z\u{00a1}-\u{ffff}]{2,})))(?::\d{2,5})?(?:\/[^\s]*)?$/iu,
    email: /^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,
    hostname: /^(?=.{1,253}\.?$)[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*\.?$/i,
    // optimized https://www.safaribooksonline.com/library/view/regular-expressions-cookbook/9780596802837/ch07s16.html
    ipv4: /^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,
    ipv6: /^((([0-9a-f]{1,4}:){7}([0-9a-f]{1,4}|:))|(([0-9a-f]{1,4}:){6}(:[0-9a-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9a-f]{1,4}:){5}(((:[0-9a-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9a-f]{1,4}:){4}(((:[0-9a-f]{1,4}){1,3})|((:[0-9a-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9a-f]{1,4}:){3}(((:[0-9a-f]{1,4}){1,4})|((:[0-9a-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9a-f]{1,4}:){2}(((:[0-9a-f]{1,4}){1,5})|((:[0-9a-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9a-f]{1,4}:){1}(((:[0-9a-f]{1,4}){1,6})|((:[0-9a-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9a-f]{1,4}){1,7})|((:[0-9a-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))$/i,
    regex,
    // uuid: http://tools.ietf.org/html/rfc4122
    uuid: /^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i,
    // JSON-pointer: https://tools.ietf.org/html/rfc6901
    // uri fragment: https://tools.ietf.org/html/rfc3986#appendix-A
    "json-pointer": /^(?:\/(?:[^~/]|~0|~1)*)*$/,
    "json-pointer-uri-fragment": /^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i,
    // relative JSON-pointer: http://tools.ietf.org/html/draft-luff-relative-json-pointer-00
    "relative-json-pointer": /^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/,
    // the following formats are used by the openapi specification: https://spec.openapis.org/oas/v3.0.0#data-types
    // byte: https://github.com/miguelmota/is-base64
    byte,
    // signed 32 bit integer
    int32: { type: "number", validate: validateInt32 },
    // signed 64 bit integer
    int64: { type: "number", validate: validateInt64 },
    // C-type float
    float: { type: "number", validate: validateNumber },
    // C-type double
    double: { type: "number", validate: validateNumber },
    // hint to the UI to hide input strings
    password: true,
    // unchecked string payload
    binary: true,
};
exports.fastFormats = {
    ...exports.fullFormats,
    date: fmtDef(/^\d\d\d\d-[0-1]\d-[0-3]\d$/, compareDate),
    time: fmtDef(/^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)?$/i, compareTime),
    "date-time": fmtDef(/^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)$/i, compareDateTime),
    // uri: https://github.com/mafintosh/is-my-json-valid/blob/master/formats.js
    uri: /^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/)?[^\s]*$/i,
    "uri-reference": /^(?:(?:[a-z][a-z0-9+\-.]*:)?\/?\/)?(?:[^\\\s#][^\s#]*)?(?:#[^\\\s]*)?$/i,
    // email (sources from jsen validator):
    // http://stackoverflow.com/questions/201323/using-a-regular-expression-to-validate-an-email-address#answer-8829363
    // http://www.w3.org/TR/html5/forms.html#valid-e-mail-address (search for 'wilful violation')
    email: /^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i,
};
exports.formatNames = Object.keys(exports.fullFormats);
function isLeapYear(year) {
    // https://tools.ietf.org/html/rfc3339#appendix-C
    return year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
}
const DATE = /^(\d\d\d\d)-(\d\d)-(\d\d)$/;
const DAYS = [0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
function date(str) {
    // full-date from http://tools.ietf.org/html/rfc3339#section-5.6
    const matches = DATE.exec(str);
    if (!matches)
        return false;
    const year = +matches[1];
    const month = +matches[2];
    const day = +matches[3];
    return (month >= 1 &&
        month <= 12 &&
        day >= 1 &&
        day <= (month === 2 && isLeapYear(year) ? 29 : DAYS[month]));
}
function compareDate(d1, d2) {
    if (!(d1 && d2))
        return undefined;
    if (d1 > d2)
        return 1;
    if (d1 < d2)
        return -1;
    return 0;
}
const TIME = /^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d(?::?\d\d)?)?$/i;
function time(str, withTimeZone) {
    const matches = TIME.exec(str);
    if (!matches)
        return false;
    const hour = +matches[1];
    const minute = +matches[2];
    const second = +matches[3];
    const timeZone = matches[5];
    return (((hour <= 23 && minute <= 59 && second <= 59) ||
        (hour === 23 && minute === 59 && second === 60)) &&
        (!withTimeZone || timeZone !== ""));
}
function compareTime(t1, t2) {
    if (!(t1 && t2))
        return undefined;
    const a1 = TIME.exec(t1);
    const a2 = TIME.exec(t2);
    if (!(a1 && a2))
        return undefined;
    t1 = a1[1] + a1[2] + a1[3] + (a1[4] || "");
    t2 = a2[1] + a2[2] + a2[3] + (a2[4] || "");
    if (t1 > t2)
        return 1;
    if (t1 < t2)
        return -1;
    return 0;
}
const DATE_TIME_SEPARATOR = /t|\s/i;
function date_time(str) {
    // http://tools.ietf.org/html/rfc3339#section-5.6
    const dateTime = str.split(DATE_TIME_SEPARATOR);
    return dateTime.length === 2 && date(dateTime[0]) && time(dateTime[1], true);
}
function compareDateTime(dt1, dt2) {
    if (!(dt1 && dt2))
        return undefined;
    const [d1, t1] = dt1.split(DATE_TIME_SEPARATOR);
    const [d2, t2] = dt2.split(DATE_TIME_SEPARATOR);
    const res = compareDate(d1, d2);
    if (res === undefined)
        return undefined;
    return res || compareTime(t1, t2);
}
const NOT_URI_FRAGMENT = /\/|:/;
const URI = /^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;
function uri(str) {
    // http://jmrware.com/articles/2009/uri_regexp/URI_regex.html + optional protocol + required "."
    return NOT_URI_FRAGMENT.test(str) && URI.test(str);
}
const BYTE = /^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/gm;
function byte(str) {
    BYTE.lastIndex = 0;
    return BYTE.test(str);
}
const MIN_INT32 = -(2 ** 31);
const MAX_INT32 = 2 ** 31 - 1;
function validateInt32(value) {
    return Number.isInteger(value) && value <= MAX_INT32 && value >= MIN_INT32;
}
function validateInt64(value) {
    // JSON and javascript max Int is 2**53, so any int that passes isInteger is valid for Int64
    return Number.isInteger(value);
}
function validateNumber() {
    return true;
}
const Z_ANCHOR = /[^\\]\\Z/;
function regex(str) {
    if (Z_ANCHOR.test(str))
        return false;
    try {
        new RegExp(str);
        return true;
    }
    catch (e) {
        return false;
    }
}


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv-formats/dist/index.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv-formats/dist/index.js ***!
  \**************************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const formats_1 = __webpack_require__(/*! ./formats */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv-formats/dist/formats.js");
const limit_1 = __webpack_require__(/*! ./limit */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv-formats/dist/limit.js");
const codegen_1 = __webpack_require__(/*! ajv/dist/compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const fullName = new codegen_1.Name("fullFormats");
const fastName = new codegen_1.Name("fastFormats");
const formatsPlugin = (ajv, opts = { keywords: true }) => {
    if (Array.isArray(opts)) {
        addFormats(ajv, opts, formats_1.fullFormats, fullName);
        return ajv;
    }
    const [formats, exportName] = opts.mode === "fast" ? [formats_1.fastFormats, fastName] : [formats_1.fullFormats, fullName];
    const list = opts.formats || formats_1.formatNames;
    addFormats(ajv, list, formats, exportName);
    if (opts.keywords)
        limit_1.default(ajv);
    return ajv;
};
formatsPlugin.get = (name, mode = "full") => {
    const formats = mode === "fast" ? formats_1.fastFormats : formats_1.fullFormats;
    const f = formats[name];
    if (!f)
        throw new Error(`Unknown format "${name}"`);
    return f;
};
function addFormats(ajv, list, fs, exportName) {
    var _a;
    var _b;
    (_a = (_b = ajv.opts.code).formats) !== null && _a !== void 0 ? _a : (_b.formats = codegen_1._ `require("ajv-formats/dist/formats").${exportName}`);
    for (const f of list)
        ajv.addFormat(f, fs[f]);
}
module.exports = exports = formatsPlugin;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports["default"] = formatsPlugin;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv-formats/dist/limit.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv-formats/dist/limit.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.formatLimitDefinition = void 0;
const ajv_1 = __webpack_require__(/*! ajv */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/ajv.js");
const codegen_1 = __webpack_require__(/*! ajv/dist/compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const ops = codegen_1.operators;
const KWDs = {
    formatMaximum: { okStr: "<=", ok: ops.LTE, fail: ops.GT },
    formatMinimum: { okStr: ">=", ok: ops.GTE, fail: ops.LT },
    formatExclusiveMaximum: { okStr: "<", ok: ops.LT, fail: ops.GTE },
    formatExclusiveMinimum: { okStr: ">", ok: ops.GT, fail: ops.LTE },
};
const error = {
    message: ({ keyword, schemaCode }) => codegen_1.str `should be ${KWDs[keyword].okStr} ${schemaCode}`,
    params: ({ keyword, schemaCode }) => codegen_1._ `{comparison: ${KWDs[keyword].okStr}, limit: ${schemaCode}}`,
};
exports.formatLimitDefinition = {
    keyword: Object.keys(KWDs),
    type: "string",
    schemaType: "string",
    $data: true,
    error,
    code(cxt) {
        const { gen, data, schemaCode, keyword, it } = cxt;
        const { opts, self } = it;
        if (!opts.validateFormats)
            return;
        const fCxt = new ajv_1.KeywordCxt(it, self.RULES.all.format.definition, "format");
        if (fCxt.$data)
            validate$DataFormat();
        else
            validateFormat();
        function validate$DataFormat() {
            const fmts = gen.scopeValue("formats", {
                ref: self.formats,
                code: opts.code.formats,
            });
            const fmt = gen.const("fmt", codegen_1._ `${fmts}[${fCxt.schemaCode}]`);
            cxt.fail$data(codegen_1.or(codegen_1._ `typeof ${fmt} != "object"`, codegen_1._ `${fmt} instanceof RegExp`, codegen_1._ `typeof ${fmt}.compare != "function"`, compareCode(fmt)));
        }
        function validateFormat() {
            const format = fCxt.schema;
            const fmtDef = self.formats[format];
            if (!fmtDef || fmtDef === true)
                return;
            if (typeof fmtDef != "object" ||
                fmtDef instanceof RegExp ||
                typeof fmtDef.compare != "function") {
                throw new Error(`"${keyword}": format "${format}" does not define "compare" function`);
            }
            const fmt = gen.scopeValue("formats", {
                key: format,
                ref: fmtDef,
                code: opts.code.formats ? codegen_1._ `${opts.code.formats}${codegen_1.getProperty(format)}` : undefined,
            });
            cxt.fail$data(compareCode(fmt));
        }
        function compareCode(fmt) {
            return codegen_1._ `${fmt}.compare(${data}, ${schemaCode}) ${KWDs[keyword].fail} 0`;
        }
    },
    dependencies: ["format"],
};
const formatLimitPlugin = (ajv) => {
    ajv.addKeyword(exports.formatLimitDefinition);
    return ajv;
};
exports["default"] = formatLimitPlugin;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/ajv.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/ajv.js ***!
  \****************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MissingRefError = exports.ValidationError = exports.CodeGen = exports.Name = exports.nil = exports.stringify = exports.str = exports._ = exports.KeywordCxt = exports.Ajv = void 0;
const core_1 = __webpack_require__(/*! ./core */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/core.js");
const draft7_1 = __webpack_require__(/*! ./vocabularies/draft7 */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/draft7.js");
const discriminator_1 = __webpack_require__(/*! ./vocabularies/discriminator */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/discriminator/index.js");
const draft7MetaSchema = __webpack_require__(/*! ./refs/json-schema-draft-07.json */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/refs/json-schema-draft-07.json");
const META_SUPPORT_DATA = ["/properties"];
const META_SCHEMA_ID = "http://json-schema.org/draft-07/schema";
class Ajv extends core_1.default {
    _addVocabularies() {
        super._addVocabularies();
        draft7_1.default.forEach((v) => this.addVocabulary(v));
        if (this.opts.discriminator)
            this.addKeyword(discriminator_1.default);
    }
    _addDefaultMetaSchema() {
        super._addDefaultMetaSchema();
        if (!this.opts.meta)
            return;
        const metaSchema = this.opts.$data
            ? this.$dataMetaSchema(draft7MetaSchema, META_SUPPORT_DATA)
            : draft7MetaSchema;
        this.addMetaSchema(metaSchema, META_SCHEMA_ID, false);
        this.refs["http://json-schema.org/schema"] = META_SCHEMA_ID;
    }
    defaultMeta() {
        return (this.opts.defaultMeta =
            super.defaultMeta() || (this.getSchema(META_SCHEMA_ID) ? META_SCHEMA_ID : undefined));
    }
}
exports.Ajv = Ajv;
module.exports = exports = Ajv;
module.exports.Ajv = Ajv;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports["default"] = Ajv;
var validate_1 = __webpack_require__(/*! ./compile/validate */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/index.js");
Object.defineProperty(exports, "KeywordCxt", ({ enumerable: true, get: function () { return validate_1.KeywordCxt; } }));
var codegen_1 = __webpack_require__(/*! ./compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
Object.defineProperty(exports, "_", ({ enumerable: true, get: function () { return codegen_1._; } }));
Object.defineProperty(exports, "str", ({ enumerable: true, get: function () { return codegen_1.str; } }));
Object.defineProperty(exports, "stringify", ({ enumerable: true, get: function () { return codegen_1.stringify; } }));
Object.defineProperty(exports, "nil", ({ enumerable: true, get: function () { return codegen_1.nil; } }));
Object.defineProperty(exports, "Name", ({ enumerable: true, get: function () { return codegen_1.Name; } }));
Object.defineProperty(exports, "CodeGen", ({ enumerable: true, get: function () { return codegen_1.CodeGen; } }));
var validation_error_1 = __webpack_require__(/*! ./runtime/validation_error */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/runtime/validation_error.js");
Object.defineProperty(exports, "ValidationError", ({ enumerable: true, get: function () { return validation_error_1.default; } }));
var ref_error_1 = __webpack_require__(/*! ./compile/ref_error */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/ref_error.js");
Object.defineProperty(exports, "MissingRefError", ({ enumerable: true, get: function () { return ref_error_1.default; } }));


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/code.js":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/code.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.regexpCode = exports.getEsmExportName = exports.getProperty = exports.safeStringify = exports.stringify = exports.strConcat = exports.addCodeArg = exports.str = exports._ = exports.nil = exports._Code = exports.Name = exports.IDENTIFIER = exports._CodeOrName = void 0;
// eslint-disable-next-line @typescript-eslint/no-extraneous-class
class _CodeOrName {
}
exports._CodeOrName = _CodeOrName;
exports.IDENTIFIER = /^[a-z$_][a-z$_0-9]*$/i;
class Name extends _CodeOrName {
    constructor(s) {
        super();
        if (!exports.IDENTIFIER.test(s))
            throw new Error("CodeGen: name must be a valid identifier");
        this.str = s;
    }
    toString() {
        return this.str;
    }
    emptyStr() {
        return false;
    }
    get names() {
        return { [this.str]: 1 };
    }
}
exports.Name = Name;
class _Code extends _CodeOrName {
    constructor(code) {
        super();
        this._items = typeof code === "string" ? [code] : code;
    }
    toString() {
        return this.str;
    }
    emptyStr() {
        if (this._items.length > 1)
            return false;
        const item = this._items[0];
        return item === "" || item === '""';
    }
    get str() {
        var _a;
        return ((_a = this._str) !== null && _a !== void 0 ? _a : (this._str = this._items.reduce((s, c) => `${s}${c}`, "")));
    }
    get names() {
        var _a;
        return ((_a = this._names) !== null && _a !== void 0 ? _a : (this._names = this._items.reduce((names, c) => {
            if (c instanceof Name)
                names[c.str] = (names[c.str] || 0) + 1;
            return names;
        }, {})));
    }
}
exports._Code = _Code;
exports.nil = new _Code("");
function _(strs, ...args) {
    const code = [strs[0]];
    let i = 0;
    while (i < args.length) {
        addCodeArg(code, args[i]);
        code.push(strs[++i]);
    }
    return new _Code(code);
}
exports._ = _;
const plus = new _Code("+");
function str(strs, ...args) {
    const expr = [safeStringify(strs[0])];
    let i = 0;
    while (i < args.length) {
        expr.push(plus);
        addCodeArg(expr, args[i]);
        expr.push(plus, safeStringify(strs[++i]));
    }
    optimize(expr);
    return new _Code(expr);
}
exports.str = str;
function addCodeArg(code, arg) {
    if (arg instanceof _Code)
        code.push(...arg._items);
    else if (arg instanceof Name)
        code.push(arg);
    else
        code.push(interpolate(arg));
}
exports.addCodeArg = addCodeArg;
function optimize(expr) {
    let i = 1;
    while (i < expr.length - 1) {
        if (expr[i] === plus) {
            const res = mergeExprItems(expr[i - 1], expr[i + 1]);
            if (res !== undefined) {
                expr.splice(i - 1, 3, res);
                continue;
            }
            expr[i++] = "+";
        }
        i++;
    }
}
function mergeExprItems(a, b) {
    if (b === '""')
        return a;
    if (a === '""')
        return b;
    if (typeof a == "string") {
        if (b instanceof Name || a[a.length - 1] !== '"')
            return;
        if (typeof b != "string")
            return `${a.slice(0, -1)}${b}"`;
        if (b[0] === '"')
            return a.slice(0, -1) + b.slice(1);
        return;
    }
    if (typeof b == "string" && b[0] === '"' && !(a instanceof Name))
        return `"${a}${b.slice(1)}`;
    return;
}
function strConcat(c1, c2) {
    return c2.emptyStr() ? c1 : c1.emptyStr() ? c2 : str `${c1}${c2}`;
}
exports.strConcat = strConcat;
// TODO do not allow arrays here
function interpolate(x) {
    return typeof x == "number" || typeof x == "boolean" || x === null
        ? x
        : safeStringify(Array.isArray(x) ? x.join(",") : x);
}
function stringify(x) {
    return new _Code(safeStringify(x));
}
exports.stringify = stringify;
function safeStringify(x) {
    return JSON.stringify(x)
        .replace(/\u2028/g, "\\u2028")
        .replace(/\u2029/g, "\\u2029");
}
exports.safeStringify = safeStringify;
function getProperty(key) {
    return typeof key == "string" && exports.IDENTIFIER.test(key) ? new _Code(`.${key}`) : _ `[${key}]`;
}
exports.getProperty = getProperty;
//Does best effort to format the name properly
function getEsmExportName(key) {
    if (typeof key == "string" && exports.IDENTIFIER.test(key)) {
        return new _Code(`${key}`);
    }
    throw new Error(`CodeGen: invalid export name: ${key}, use explicit $id name mapping`);
}
exports.getEsmExportName = getEsmExportName;
function regexpCode(rx) {
    return new _Code(rx.toString());
}
exports.regexpCode = regexpCode;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js":
/*!**********************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.or = exports.and = exports.not = exports.CodeGen = exports.operators = exports.varKinds = exports.ValueScopeName = exports.ValueScope = exports.Scope = exports.Name = exports.regexpCode = exports.stringify = exports.getProperty = exports.nil = exports.strConcat = exports.str = exports._ = void 0;
const code_1 = __webpack_require__(/*! ./code */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/code.js");
const scope_1 = __webpack_require__(/*! ./scope */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/scope.js");
var code_2 = __webpack_require__(/*! ./code */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/code.js");
Object.defineProperty(exports, "_", ({ enumerable: true, get: function () { return code_2._; } }));
Object.defineProperty(exports, "str", ({ enumerable: true, get: function () { return code_2.str; } }));
Object.defineProperty(exports, "strConcat", ({ enumerable: true, get: function () { return code_2.strConcat; } }));
Object.defineProperty(exports, "nil", ({ enumerable: true, get: function () { return code_2.nil; } }));
Object.defineProperty(exports, "getProperty", ({ enumerable: true, get: function () { return code_2.getProperty; } }));
Object.defineProperty(exports, "stringify", ({ enumerable: true, get: function () { return code_2.stringify; } }));
Object.defineProperty(exports, "regexpCode", ({ enumerable: true, get: function () { return code_2.regexpCode; } }));
Object.defineProperty(exports, "Name", ({ enumerable: true, get: function () { return code_2.Name; } }));
var scope_2 = __webpack_require__(/*! ./scope */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/scope.js");
Object.defineProperty(exports, "Scope", ({ enumerable: true, get: function () { return scope_2.Scope; } }));
Object.defineProperty(exports, "ValueScope", ({ enumerable: true, get: function () { return scope_2.ValueScope; } }));
Object.defineProperty(exports, "ValueScopeName", ({ enumerable: true, get: function () { return scope_2.ValueScopeName; } }));
Object.defineProperty(exports, "varKinds", ({ enumerable: true, get: function () { return scope_2.varKinds; } }));
exports.operators = {
    GT: new code_1._Code(">"),
    GTE: new code_1._Code(">="),
    LT: new code_1._Code("<"),
    LTE: new code_1._Code("<="),
    EQ: new code_1._Code("==="),
    NEQ: new code_1._Code("!=="),
    NOT: new code_1._Code("!"),
    OR: new code_1._Code("||"),
    AND: new code_1._Code("&&"),
    ADD: new code_1._Code("+"),
};
class Node {
    optimizeNodes() {
        return this;
    }
    optimizeNames(_names, _constants) {
        return this;
    }
}
class Def extends Node {
    constructor(varKind, name, rhs) {
        super();
        this.varKind = varKind;
        this.name = name;
        this.rhs = rhs;
    }
    render({ es5, _n }) {
        const varKind = es5 ? scope_1.varKinds.var : this.varKind;
        const rhs = this.rhs === undefined ? "" : ` = ${this.rhs}`;
        return `${varKind} ${this.name}${rhs};` + _n;
    }
    optimizeNames(names, constants) {
        if (!names[this.name.str])
            return;
        if (this.rhs)
            this.rhs = optimizeExpr(this.rhs, names, constants);
        return this;
    }
    get names() {
        return this.rhs instanceof code_1._CodeOrName ? this.rhs.names : {};
    }
}
class Assign extends Node {
    constructor(lhs, rhs, sideEffects) {
        super();
        this.lhs = lhs;
        this.rhs = rhs;
        this.sideEffects = sideEffects;
    }
    render({ _n }) {
        return `${this.lhs} = ${this.rhs};` + _n;
    }
    optimizeNames(names, constants) {
        if (this.lhs instanceof code_1.Name && !names[this.lhs.str] && !this.sideEffects)
            return;
        this.rhs = optimizeExpr(this.rhs, names, constants);
        return this;
    }
    get names() {
        const names = this.lhs instanceof code_1.Name ? {} : { ...this.lhs.names };
        return addExprNames(names, this.rhs);
    }
}
class AssignOp extends Assign {
    constructor(lhs, op, rhs, sideEffects) {
        super(lhs, rhs, sideEffects);
        this.op = op;
    }
    render({ _n }) {
        return `${this.lhs} ${this.op}= ${this.rhs};` + _n;
    }
}
class Label extends Node {
    constructor(label) {
        super();
        this.label = label;
        this.names = {};
    }
    render({ _n }) {
        return `${this.label}:` + _n;
    }
}
class Break extends Node {
    constructor(label) {
        super();
        this.label = label;
        this.names = {};
    }
    render({ _n }) {
        const label = this.label ? ` ${this.label}` : "";
        return `break${label};` + _n;
    }
}
class Throw extends Node {
    constructor(error) {
        super();
        this.error = error;
    }
    render({ _n }) {
        return `throw ${this.error};` + _n;
    }
    get names() {
        return this.error.names;
    }
}
class AnyCode extends Node {
    constructor(code) {
        super();
        this.code = code;
    }
    render({ _n }) {
        return `${this.code};` + _n;
    }
    optimizeNodes() {
        return `${this.code}` ? this : undefined;
    }
    optimizeNames(names, constants) {
        this.code = optimizeExpr(this.code, names, constants);
        return this;
    }
    get names() {
        return this.code instanceof code_1._CodeOrName ? this.code.names : {};
    }
}
class ParentNode extends Node {
    constructor(nodes = []) {
        super();
        this.nodes = nodes;
    }
    render(opts) {
        return this.nodes.reduce((code, n) => code + n.render(opts), "");
    }
    optimizeNodes() {
        const { nodes } = this;
        let i = nodes.length;
        while (i--) {
            const n = nodes[i].optimizeNodes();
            if (Array.isArray(n))
                nodes.splice(i, 1, ...n);
            else if (n)
                nodes[i] = n;
            else
                nodes.splice(i, 1);
        }
        return nodes.length > 0 ? this : undefined;
    }
    optimizeNames(names, constants) {
        const { nodes } = this;
        let i = nodes.length;
        while (i--) {
            // iterating backwards improves 1-pass optimization
            const n = nodes[i];
            if (n.optimizeNames(names, constants))
                continue;
            subtractNames(names, n.names);
            nodes.splice(i, 1);
        }
        return nodes.length > 0 ? this : undefined;
    }
    get names() {
        return this.nodes.reduce((names, n) => addNames(names, n.names), {});
    }
}
class BlockNode extends ParentNode {
    render(opts) {
        return "{" + opts._n + super.render(opts) + "}" + opts._n;
    }
}
class Root extends ParentNode {
}
class Else extends BlockNode {
}
Else.kind = "else";
class If extends BlockNode {
    constructor(condition, nodes) {
        super(nodes);
        this.condition = condition;
    }
    render(opts) {
        let code = `if(${this.condition})` + super.render(opts);
        if (this.else)
            code += "else " + this.else.render(opts);
        return code;
    }
    optimizeNodes() {
        super.optimizeNodes();
        const cond = this.condition;
        if (cond === true)
            return this.nodes; // else is ignored here
        let e = this.else;
        if (e) {
            const ns = e.optimizeNodes();
            e = this.else = Array.isArray(ns) ? new Else(ns) : ns;
        }
        if (e) {
            if (cond === false)
                return e instanceof If ? e : e.nodes;
            if (this.nodes.length)
                return this;
            return new If(not(cond), e instanceof If ? [e] : e.nodes);
        }
        if (cond === false || !this.nodes.length)
            return undefined;
        return this;
    }
    optimizeNames(names, constants) {
        var _a;
        this.else = (_a = this.else) === null || _a === void 0 ? void 0 : _a.optimizeNames(names, constants);
        if (!(super.optimizeNames(names, constants) || this.else))
            return;
        this.condition = optimizeExpr(this.condition, names, constants);
        return this;
    }
    get names() {
        const names = super.names;
        addExprNames(names, this.condition);
        if (this.else)
            addNames(names, this.else.names);
        return names;
    }
}
If.kind = "if";
class For extends BlockNode {
}
For.kind = "for";
class ForLoop extends For {
    constructor(iteration) {
        super();
        this.iteration = iteration;
    }
    render(opts) {
        return `for(${this.iteration})` + super.render(opts);
    }
    optimizeNames(names, constants) {
        if (!super.optimizeNames(names, constants))
            return;
        this.iteration = optimizeExpr(this.iteration, names, constants);
        return this;
    }
    get names() {
        return addNames(super.names, this.iteration.names);
    }
}
class ForRange extends For {
    constructor(varKind, name, from, to) {
        super();
        this.varKind = varKind;
        this.name = name;
        this.from = from;
        this.to = to;
    }
    render(opts) {
        const varKind = opts.es5 ? scope_1.varKinds.var : this.varKind;
        const { name, from, to } = this;
        return `for(${varKind} ${name}=${from}; ${name}<${to}; ${name}++)` + super.render(opts);
    }
    get names() {
        const names = addExprNames(super.names, this.from);
        return addExprNames(names, this.to);
    }
}
class ForIter extends For {
    constructor(loop, varKind, name, iterable) {
        super();
        this.loop = loop;
        this.varKind = varKind;
        this.name = name;
        this.iterable = iterable;
    }
    render(opts) {
        return `for(${this.varKind} ${this.name} ${this.loop} ${this.iterable})` + super.render(opts);
    }
    optimizeNames(names, constants) {
        if (!super.optimizeNames(names, constants))
            return;
        this.iterable = optimizeExpr(this.iterable, names, constants);
        return this;
    }
    get names() {
        return addNames(super.names, this.iterable.names);
    }
}
class Func extends BlockNode {
    constructor(name, args, async) {
        super();
        this.name = name;
        this.args = args;
        this.async = async;
    }
    render(opts) {
        const _async = this.async ? "async " : "";
        return `${_async}function ${this.name}(${this.args})` + super.render(opts);
    }
}
Func.kind = "func";
class Return extends ParentNode {
    render(opts) {
        return "return " + super.render(opts);
    }
}
Return.kind = "return";
class Try extends BlockNode {
    render(opts) {
        let code = "try" + super.render(opts);
        if (this.catch)
            code += this.catch.render(opts);
        if (this.finally)
            code += this.finally.render(opts);
        return code;
    }
    optimizeNodes() {
        var _a, _b;
        super.optimizeNodes();
        (_a = this.catch) === null || _a === void 0 ? void 0 : _a.optimizeNodes();
        (_b = this.finally) === null || _b === void 0 ? void 0 : _b.optimizeNodes();
        return this;
    }
    optimizeNames(names, constants) {
        var _a, _b;
        super.optimizeNames(names, constants);
        (_a = this.catch) === null || _a === void 0 ? void 0 : _a.optimizeNames(names, constants);
        (_b = this.finally) === null || _b === void 0 ? void 0 : _b.optimizeNames(names, constants);
        return this;
    }
    get names() {
        const names = super.names;
        if (this.catch)
            addNames(names, this.catch.names);
        if (this.finally)
            addNames(names, this.finally.names);
        return names;
    }
}
class Catch extends BlockNode {
    constructor(error) {
        super();
        this.error = error;
    }
    render(opts) {
        return `catch(${this.error})` + super.render(opts);
    }
}
Catch.kind = "catch";
class Finally extends BlockNode {
    render(opts) {
        return "finally" + super.render(opts);
    }
}
Finally.kind = "finally";
class CodeGen {
    constructor(extScope, opts = {}) {
        this._values = {};
        this._blockStarts = [];
        this._constants = {};
        this.opts = { ...opts, _n: opts.lines ? "\n" : "" };
        this._extScope = extScope;
        this._scope = new scope_1.Scope({ parent: extScope });
        this._nodes = [new Root()];
    }
    toString() {
        return this._root.render(this.opts);
    }
    // returns unique name in the internal scope
    name(prefix) {
        return this._scope.name(prefix);
    }
    // reserves unique name in the external scope
    scopeName(prefix) {
        return this._extScope.name(prefix);
    }
    // reserves unique name in the external scope and assigns value to it
    scopeValue(prefixOrName, value) {
        const name = this._extScope.value(prefixOrName, value);
        const vs = this._values[name.prefix] || (this._values[name.prefix] = new Set());
        vs.add(name);
        return name;
    }
    getScopeValue(prefix, keyOrRef) {
        return this._extScope.getValue(prefix, keyOrRef);
    }
    // return code that assigns values in the external scope to the names that are used internally
    // (same names that were returned by gen.scopeName or gen.scopeValue)
    scopeRefs(scopeName) {
        return this._extScope.scopeRefs(scopeName, this._values);
    }
    scopeCode() {
        return this._extScope.scopeCode(this._values);
    }
    _def(varKind, nameOrPrefix, rhs, constant) {
        const name = this._scope.toName(nameOrPrefix);
        if (rhs !== undefined && constant)
            this._constants[name.str] = rhs;
        this._leafNode(new Def(varKind, name, rhs));
        return name;
    }
    // `const` declaration (`var` in es5 mode)
    const(nameOrPrefix, rhs, _constant) {
        return this._def(scope_1.varKinds.const, nameOrPrefix, rhs, _constant);
    }
    // `let` declaration with optional assignment (`var` in es5 mode)
    let(nameOrPrefix, rhs, _constant) {
        return this._def(scope_1.varKinds.let, nameOrPrefix, rhs, _constant);
    }
    // `var` declaration with optional assignment
    var(nameOrPrefix, rhs, _constant) {
        return this._def(scope_1.varKinds.var, nameOrPrefix, rhs, _constant);
    }
    // assignment code
    assign(lhs, rhs, sideEffects) {
        return this._leafNode(new Assign(lhs, rhs, sideEffects));
    }
    // `+=` code
    add(lhs, rhs) {
        return this._leafNode(new AssignOp(lhs, exports.operators.ADD, rhs));
    }
    // appends passed SafeExpr to code or executes Block
    code(c) {
        if (typeof c == "function")
            c();
        else if (c !== code_1.nil)
            this._leafNode(new AnyCode(c));
        return this;
    }
    // returns code for object literal for the passed argument list of key-value pairs
    object(...keyValues) {
        const code = ["{"];
        for (const [key, value] of keyValues) {
            if (code.length > 1)
                code.push(",");
            code.push(key);
            if (key !== value || this.opts.es5) {
                code.push(":");
                (0, code_1.addCodeArg)(code, value);
            }
        }
        code.push("}");
        return new code_1._Code(code);
    }
    // `if` clause (or statement if `thenBody` and, optionally, `elseBody` are passed)
    if(condition, thenBody, elseBody) {
        this._blockNode(new If(condition));
        if (thenBody && elseBody) {
            this.code(thenBody).else().code(elseBody).endIf();
        }
        else if (thenBody) {
            this.code(thenBody).endIf();
        }
        else if (elseBody) {
            throw new Error('CodeGen: "else" body without "then" body');
        }
        return this;
    }
    // `else if` clause - invalid without `if` or after `else` clauses
    elseIf(condition) {
        return this._elseNode(new If(condition));
    }
    // `else` clause - only valid after `if` or `else if` clauses
    else() {
        return this._elseNode(new Else());
    }
    // end `if` statement (needed if gen.if was used only with condition)
    endIf() {
        return this._endBlockNode(If, Else);
    }
    _for(node, forBody) {
        this._blockNode(node);
        if (forBody)
            this.code(forBody).endFor();
        return this;
    }
    // a generic `for` clause (or statement if `forBody` is passed)
    for(iteration, forBody) {
        return this._for(new ForLoop(iteration), forBody);
    }
    // `for` statement for a range of values
    forRange(nameOrPrefix, from, to, forBody, varKind = this.opts.es5 ? scope_1.varKinds.var : scope_1.varKinds.let) {
        const name = this._scope.toName(nameOrPrefix);
        return this._for(new ForRange(varKind, name, from, to), () => forBody(name));
    }
    // `for-of` statement (in es5 mode replace with a normal for loop)
    forOf(nameOrPrefix, iterable, forBody, varKind = scope_1.varKinds.const) {
        const name = this._scope.toName(nameOrPrefix);
        if (this.opts.es5) {
            const arr = iterable instanceof code_1.Name ? iterable : this.var("_arr", iterable);
            return this.forRange("_i", 0, (0, code_1._) `${arr}.length`, (i) => {
                this.var(name, (0, code_1._) `${arr}[${i}]`);
                forBody(name);
            });
        }
        return this._for(new ForIter("of", varKind, name, iterable), () => forBody(name));
    }
    // `for-in` statement.
    // With option `ownProperties` replaced with a `for-of` loop for object keys
    forIn(nameOrPrefix, obj, forBody, varKind = this.opts.es5 ? scope_1.varKinds.var : scope_1.varKinds.const) {
        if (this.opts.ownProperties) {
            return this.forOf(nameOrPrefix, (0, code_1._) `Object.keys(${obj})`, forBody);
        }
        const name = this._scope.toName(nameOrPrefix);
        return this._for(new ForIter("in", varKind, name, obj), () => forBody(name));
    }
    // end `for` loop
    endFor() {
        return this._endBlockNode(For);
    }
    // `label` statement
    label(label) {
        return this._leafNode(new Label(label));
    }
    // `break` statement
    break(label) {
        return this._leafNode(new Break(label));
    }
    // `return` statement
    return(value) {
        const node = new Return();
        this._blockNode(node);
        this.code(value);
        if (node.nodes.length !== 1)
            throw new Error('CodeGen: "return" should have one node');
        return this._endBlockNode(Return);
    }
    // `try` statement
    try(tryBody, catchCode, finallyCode) {
        if (!catchCode && !finallyCode)
            throw new Error('CodeGen: "try" without "catch" and "finally"');
        const node = new Try();
        this._blockNode(node);
        this.code(tryBody);
        if (catchCode) {
            const error = this.name("e");
            this._currNode = node.catch = new Catch(error);
            catchCode(error);
        }
        if (finallyCode) {
            this._currNode = node.finally = new Finally();
            this.code(finallyCode);
        }
        return this._endBlockNode(Catch, Finally);
    }
    // `throw` statement
    throw(error) {
        return this._leafNode(new Throw(error));
    }
    // start self-balancing block
    block(body, nodeCount) {
        this._blockStarts.push(this._nodes.length);
        if (body)
            this.code(body).endBlock(nodeCount);
        return this;
    }
    // end the current self-balancing block
    endBlock(nodeCount) {
        const len = this._blockStarts.pop();
        if (len === undefined)
            throw new Error("CodeGen: not in self-balancing block");
        const toClose = this._nodes.length - len;
        if (toClose < 0 || (nodeCount !== undefined && toClose !== nodeCount)) {
            throw new Error(`CodeGen: wrong number of nodes: ${toClose} vs ${nodeCount} expected`);
        }
        this._nodes.length = len;
        return this;
    }
    // `function` heading (or definition if funcBody is passed)
    func(name, args = code_1.nil, async, funcBody) {
        this._blockNode(new Func(name, args, async));
        if (funcBody)
            this.code(funcBody).endFunc();
        return this;
    }
    // end function definition
    endFunc() {
        return this._endBlockNode(Func);
    }
    optimize(n = 1) {
        while (n-- > 0) {
            this._root.optimizeNodes();
            this._root.optimizeNames(this._root.names, this._constants);
        }
    }
    _leafNode(node) {
        this._currNode.nodes.push(node);
        return this;
    }
    _blockNode(node) {
        this._currNode.nodes.push(node);
        this._nodes.push(node);
    }
    _endBlockNode(N1, N2) {
        const n = this._currNode;
        if (n instanceof N1 || (N2 && n instanceof N2)) {
            this._nodes.pop();
            return this;
        }
        throw new Error(`CodeGen: not in block "${N2 ? `${N1.kind}/${N2.kind}` : N1.kind}"`);
    }
    _elseNode(node) {
        const n = this._currNode;
        if (!(n instanceof If)) {
            throw new Error('CodeGen: "else" without "if"');
        }
        this._currNode = n.else = node;
        return this;
    }
    get _root() {
        return this._nodes[0];
    }
    get _currNode() {
        const ns = this._nodes;
        return ns[ns.length - 1];
    }
    set _currNode(node) {
        const ns = this._nodes;
        ns[ns.length - 1] = node;
    }
}
exports.CodeGen = CodeGen;
function addNames(names, from) {
    for (const n in from)
        names[n] = (names[n] || 0) + (from[n] || 0);
    return names;
}
function addExprNames(names, from) {
    return from instanceof code_1._CodeOrName ? addNames(names, from.names) : names;
}
function optimizeExpr(expr, names, constants) {
    if (expr instanceof code_1.Name)
        return replaceName(expr);
    if (!canOptimize(expr))
        return expr;
    return new code_1._Code(expr._items.reduce((items, c) => {
        if (c instanceof code_1.Name)
            c = replaceName(c);
        if (c instanceof code_1._Code)
            items.push(...c._items);
        else
            items.push(c);
        return items;
    }, []));
    function replaceName(n) {
        const c = constants[n.str];
        if (c === undefined || names[n.str] !== 1)
            return n;
        delete names[n.str];
        return c;
    }
    function canOptimize(e) {
        return (e instanceof code_1._Code &&
            e._items.some((c) => c instanceof code_1.Name && names[c.str] === 1 && constants[c.str] !== undefined));
    }
}
function subtractNames(names, from) {
    for (const n in from)
        names[n] = (names[n] || 0) - (from[n] || 0);
}
function not(x) {
    return typeof x == "boolean" || typeof x == "number" || x === null ? !x : (0, code_1._) `!${par(x)}`;
}
exports.not = not;
const andCode = mappend(exports.operators.AND);
// boolean AND (&&) expression with the passed arguments
function and(...args) {
    return args.reduce(andCode);
}
exports.and = and;
const orCode = mappend(exports.operators.OR);
// boolean OR (||) expression with the passed arguments
function or(...args) {
    return args.reduce(orCode);
}
exports.or = or;
function mappend(op) {
    return (x, y) => (x === code_1.nil ? y : y === code_1.nil ? x : (0, code_1._) `${par(x)} ${op} ${par(y)}`);
}
function par(x) {
    return x instanceof code_1.Name ? x : (0, code_1._) `(${x})`;
}


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/scope.js":
/*!**********************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/scope.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ValueScope = exports.ValueScopeName = exports.Scope = exports.varKinds = exports.UsedValueState = void 0;
const code_1 = __webpack_require__(/*! ./code */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/code.js");
class ValueError extends Error {
    constructor(name) {
        super(`CodeGen: "code" for ${name} not defined`);
        this.value = name.value;
    }
}
var UsedValueState;
(function (UsedValueState) {
    UsedValueState[UsedValueState["Started"] = 0] = "Started";
    UsedValueState[UsedValueState["Completed"] = 1] = "Completed";
})(UsedValueState || (exports.UsedValueState = UsedValueState = {}));
exports.varKinds = {
    const: new code_1.Name("const"),
    let: new code_1.Name("let"),
    var: new code_1.Name("var"),
};
class Scope {
    constructor({ prefixes, parent } = {}) {
        this._names = {};
        this._prefixes = prefixes;
        this._parent = parent;
    }
    toName(nameOrPrefix) {
        return nameOrPrefix instanceof code_1.Name ? nameOrPrefix : this.name(nameOrPrefix);
    }
    name(prefix) {
        return new code_1.Name(this._newName(prefix));
    }
    _newName(prefix) {
        const ng = this._names[prefix] || this._nameGroup(prefix);
        return `${prefix}${ng.index++}`;
    }
    _nameGroup(prefix) {
        var _a, _b;
        if (((_b = (_a = this._parent) === null || _a === void 0 ? void 0 : _a._prefixes) === null || _b === void 0 ? void 0 : _b.has(prefix)) || (this._prefixes && !this._prefixes.has(prefix))) {
            throw new Error(`CodeGen: prefix "${prefix}" is not allowed in this scope`);
        }
        return (this._names[prefix] = { prefix, index: 0 });
    }
}
exports.Scope = Scope;
class ValueScopeName extends code_1.Name {
    constructor(prefix, nameStr) {
        super(nameStr);
        this.prefix = prefix;
    }
    setValue(value, { property, itemIndex }) {
        this.value = value;
        this.scopePath = (0, code_1._) `.${new code_1.Name(property)}[${itemIndex}]`;
    }
}
exports.ValueScopeName = ValueScopeName;
const line = (0, code_1._) `\n`;
class ValueScope extends Scope {
    constructor(opts) {
        super(opts);
        this._values = {};
        this._scope = opts.scope;
        this.opts = { ...opts, _n: opts.lines ? line : code_1.nil };
    }
    get() {
        return this._scope;
    }
    name(prefix) {
        return new ValueScopeName(prefix, this._newName(prefix));
    }
    value(nameOrPrefix, value) {
        var _a;
        if (value.ref === undefined)
            throw new Error("CodeGen: ref must be passed in value");
        const name = this.toName(nameOrPrefix);
        const { prefix } = name;
        const valueKey = (_a = value.key) !== null && _a !== void 0 ? _a : value.ref;
        let vs = this._values[prefix];
        if (vs) {
            const _name = vs.get(valueKey);
            if (_name)
                return _name;
        }
        else {
            vs = this._values[prefix] = new Map();
        }
        vs.set(valueKey, name);
        const s = this._scope[prefix] || (this._scope[prefix] = []);
        const itemIndex = s.length;
        s[itemIndex] = value.ref;
        name.setValue(value, { property: prefix, itemIndex });
        return name;
    }
    getValue(prefix, keyOrRef) {
        const vs = this._values[prefix];
        if (!vs)
            return;
        return vs.get(keyOrRef);
    }
    scopeRefs(scopeName, values = this._values) {
        return this._reduceValues(values, (name) => {
            if (name.scopePath === undefined)
                throw new Error(`CodeGen: name "${name}" has no value`);
            return (0, code_1._) `${scopeName}${name.scopePath}`;
        });
    }
    scopeCode(values = this._values, usedValues, getCode) {
        return this._reduceValues(values, (name) => {
            if (name.value === undefined)
                throw new Error(`CodeGen: name "${name}" has no value`);
            return name.value.code;
        }, usedValues, getCode);
    }
    _reduceValues(values, valueCode, usedValues = {}, getCode) {
        let code = code_1.nil;
        for (const prefix in values) {
            const vs = values[prefix];
            if (!vs)
                continue;
            const nameSet = (usedValues[prefix] = usedValues[prefix] || new Map());
            vs.forEach((name) => {
                if (nameSet.has(name))
                    return;
                nameSet.set(name, UsedValueState.Started);
                let c = valueCode(name);
                if (c) {
                    const def = this.opts.es5 ? exports.varKinds.var : exports.varKinds.const;
                    code = (0, code_1._) `${code}${def} ${name} = ${c};${this.opts._n}`;
                }
                else if ((c = getCode === null || getCode === void 0 ? void 0 : getCode(name))) {
                    code = (0, code_1._) `${code}${c}${this.opts._n}`;
                }
                else {
                    throw new ValueError(name);
                }
                nameSet.set(name, UsedValueState.Completed);
            });
        }
        return code;
    }
}
exports.ValueScope = ValueScope;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/errors.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/errors.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.extendErrors = exports.resetErrorsCount = exports.reportExtraError = exports.reportError = exports.keyword$DataError = exports.keywordError = void 0;
const codegen_1 = __webpack_require__(/*! ./codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const util_1 = __webpack_require__(/*! ./util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const names_1 = __webpack_require__(/*! ./names */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/names.js");
exports.keywordError = {
    message: ({ keyword }) => (0, codegen_1.str) `must pass "${keyword}" keyword validation`,
};
exports.keyword$DataError = {
    message: ({ keyword, schemaType }) => schemaType
        ? (0, codegen_1.str) `"${keyword}" keyword must be ${schemaType} ($data)`
        : (0, codegen_1.str) `"${keyword}" keyword is invalid ($data)`,
};
function reportError(cxt, error = exports.keywordError, errorPaths, overrideAllErrors) {
    const { it } = cxt;
    const { gen, compositeRule, allErrors } = it;
    const errObj = errorObjectCode(cxt, error, errorPaths);
    if (overrideAllErrors !== null && overrideAllErrors !== void 0 ? overrideAllErrors : (compositeRule || allErrors)) {
        addError(gen, errObj);
    }
    else {
        returnErrors(it, (0, codegen_1._) `[${errObj}]`);
    }
}
exports.reportError = reportError;
function reportExtraError(cxt, error = exports.keywordError, errorPaths) {
    const { it } = cxt;
    const { gen, compositeRule, allErrors } = it;
    const errObj = errorObjectCode(cxt, error, errorPaths);
    addError(gen, errObj);
    if (!(compositeRule || allErrors)) {
        returnErrors(it, names_1.default.vErrors);
    }
}
exports.reportExtraError = reportExtraError;
function resetErrorsCount(gen, errsCount) {
    gen.assign(names_1.default.errors, errsCount);
    gen.if((0, codegen_1._) `${names_1.default.vErrors} !== null`, () => gen.if(errsCount, () => gen.assign((0, codegen_1._) `${names_1.default.vErrors}.length`, errsCount), () => gen.assign(names_1.default.vErrors, null)));
}
exports.resetErrorsCount = resetErrorsCount;
function extendErrors({ gen, keyword, schemaValue, data, errsCount, it, }) {
    /* istanbul ignore if */
    if (errsCount === undefined)
        throw new Error("ajv implementation error");
    const err = gen.name("err");
    gen.forRange("i", errsCount, names_1.default.errors, (i) => {
        gen.const(err, (0, codegen_1._) `${names_1.default.vErrors}[${i}]`);
        gen.if((0, codegen_1._) `${err}.instancePath === undefined`, () => gen.assign((0, codegen_1._) `${err}.instancePath`, (0, codegen_1.strConcat)(names_1.default.instancePath, it.errorPath)));
        gen.assign((0, codegen_1._) `${err}.schemaPath`, (0, codegen_1.str) `${it.errSchemaPath}/${keyword}`);
        if (it.opts.verbose) {
            gen.assign((0, codegen_1._) `${err}.schema`, schemaValue);
            gen.assign((0, codegen_1._) `${err}.data`, data);
        }
    });
}
exports.extendErrors = extendErrors;
function addError(gen, errObj) {
    const err = gen.const("err", errObj);
    gen.if((0, codegen_1._) `${names_1.default.vErrors} === null`, () => gen.assign(names_1.default.vErrors, (0, codegen_1._) `[${err}]`), (0, codegen_1._) `${names_1.default.vErrors}.push(${err})`);
    gen.code((0, codegen_1._) `${names_1.default.errors}++`);
}
function returnErrors(it, errs) {
    const { gen, validateName, schemaEnv } = it;
    if (schemaEnv.$async) {
        gen.throw((0, codegen_1._) `new ${it.ValidationError}(${errs})`);
    }
    else {
        gen.assign((0, codegen_1._) `${validateName}.errors`, errs);
        gen.return(false);
    }
}
const E = {
    keyword: new codegen_1.Name("keyword"),
    schemaPath: new codegen_1.Name("schemaPath"), // also used in JTD errors
    params: new codegen_1.Name("params"),
    propertyName: new codegen_1.Name("propertyName"),
    message: new codegen_1.Name("message"),
    schema: new codegen_1.Name("schema"),
    parentSchema: new codegen_1.Name("parentSchema"),
};
function errorObjectCode(cxt, error, errorPaths) {
    const { createErrors } = cxt.it;
    if (createErrors === false)
        return (0, codegen_1._) `{}`;
    return errorObject(cxt, error, errorPaths);
}
function errorObject(cxt, error, errorPaths = {}) {
    const { gen, it } = cxt;
    const keyValues = [
        errorInstancePath(it, errorPaths),
        errorSchemaPath(cxt, errorPaths),
    ];
    extraErrorProps(cxt, error, keyValues);
    return gen.object(...keyValues);
}
function errorInstancePath({ errorPath }, { instancePath }) {
    const instPath = instancePath
        ? (0, codegen_1.str) `${errorPath}${(0, util_1.getErrorPath)(instancePath, util_1.Type.Str)}`
        : errorPath;
    return [names_1.default.instancePath, (0, codegen_1.strConcat)(names_1.default.instancePath, instPath)];
}
function errorSchemaPath({ keyword, it: { errSchemaPath } }, { schemaPath, parentSchema }) {
    let schPath = parentSchema ? errSchemaPath : (0, codegen_1.str) `${errSchemaPath}/${keyword}`;
    if (schemaPath) {
        schPath = (0, codegen_1.str) `${schPath}${(0, util_1.getErrorPath)(schemaPath, util_1.Type.Str)}`;
    }
    return [E.schemaPath, schPath];
}
function extraErrorProps(cxt, { params, message }, keyValues) {
    const { keyword, data, schemaValue, it } = cxt;
    const { opts, propertyName, topSchemaRef, schemaPath } = it;
    keyValues.push([E.keyword, keyword], [E.params, typeof params == "function" ? params(cxt) : params || (0, codegen_1._) `{}`]);
    if (opts.messages) {
        keyValues.push([E.message, typeof message == "function" ? message(cxt) : message]);
    }
    if (opts.verbose) {
        keyValues.push([E.schema, schemaValue], [E.parentSchema, (0, codegen_1._) `${topSchemaRef}${schemaPath}`], [names_1.default.data, data]);
    }
    if (propertyName)
        keyValues.push([E.propertyName, propertyName]);
}


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/index.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/index.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.resolveSchema = exports.getCompilingSchema = exports.resolveRef = exports.compileSchema = exports.SchemaEnv = void 0;
const codegen_1 = __webpack_require__(/*! ./codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const validation_error_1 = __webpack_require__(/*! ../runtime/validation_error */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/runtime/validation_error.js");
const names_1 = __webpack_require__(/*! ./names */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/names.js");
const resolve_1 = __webpack_require__(/*! ./resolve */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/resolve.js");
const util_1 = __webpack_require__(/*! ./util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const validate_1 = __webpack_require__(/*! ./validate */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/index.js");
class SchemaEnv {
    constructor(env) {
        var _a;
        this.refs = {};
        this.dynamicAnchors = {};
        let schema;
        if (typeof env.schema == "object")
            schema = env.schema;
        this.schema = env.schema;
        this.schemaId = env.schemaId;
        this.root = env.root || this;
        this.baseId = (_a = env.baseId) !== null && _a !== void 0 ? _a : (0, resolve_1.normalizeId)(schema === null || schema === void 0 ? void 0 : schema[env.schemaId || "$id"]);
        this.schemaPath = env.schemaPath;
        this.localRefs = env.localRefs;
        this.meta = env.meta;
        this.$async = schema === null || schema === void 0 ? void 0 : schema.$async;
        this.refs = {};
    }
}
exports.SchemaEnv = SchemaEnv;
// let codeSize = 0
// let nodeCount = 0
// Compiles schema in SchemaEnv
function compileSchema(sch) {
    // TODO refactor - remove compilations
    const _sch = getCompilingSchema.call(this, sch);
    if (_sch)
        return _sch;
    const rootId = (0, resolve_1.getFullPath)(this.opts.uriResolver, sch.root.baseId); // TODO if getFullPath removed 1 tests fails
    const { es5, lines } = this.opts.code;
    const { ownProperties } = this.opts;
    const gen = new codegen_1.CodeGen(this.scope, { es5, lines, ownProperties });
    let _ValidationError;
    if (sch.$async) {
        _ValidationError = gen.scopeValue("Error", {
            ref: validation_error_1.default,
            code: (0, codegen_1._) `require("ajv/dist/runtime/validation_error").default`,
        });
    }
    const validateName = gen.scopeName("validate");
    sch.validateName = validateName;
    const schemaCxt = {
        gen,
        allErrors: this.opts.allErrors,
        data: names_1.default.data,
        parentData: names_1.default.parentData,
        parentDataProperty: names_1.default.parentDataProperty,
        dataNames: [names_1.default.data],
        dataPathArr: [codegen_1.nil], // TODO can its length be used as dataLevel if nil is removed?
        dataLevel: 0,
        dataTypes: [],
        definedProperties: new Set(),
        topSchemaRef: gen.scopeValue("schema", this.opts.code.source === true
            ? { ref: sch.schema, code: (0, codegen_1.stringify)(sch.schema) }
            : { ref: sch.schema }),
        validateName,
        ValidationError: _ValidationError,
        schema: sch.schema,
        schemaEnv: sch,
        rootId,
        baseId: sch.baseId || rootId,
        schemaPath: codegen_1.nil,
        errSchemaPath: sch.schemaPath || (this.opts.jtd ? "" : "#"),
        errorPath: (0, codegen_1._) `""`,
        opts: this.opts,
        self: this,
    };
    let sourceCode;
    try {
        this._compilations.add(sch);
        (0, validate_1.validateFunctionCode)(schemaCxt);
        gen.optimize(this.opts.code.optimize);
        // gen.optimize(1)
        const validateCode = gen.toString();
        sourceCode = `${gen.scopeRefs(names_1.default.scope)}return ${validateCode}`;
        // console.log((codeSize += sourceCode.length), (nodeCount += gen.nodeCount))
        if (this.opts.code.process)
            sourceCode = this.opts.code.process(sourceCode, sch);
        // console.log("\n\n\n *** \n", sourceCode)
        const makeValidate = new Function(`${names_1.default.self}`, `${names_1.default.scope}`, sourceCode);
        const validate = makeValidate(this, this.scope.get());
        this.scope.value(validateName, { ref: validate });
        validate.errors = null;
        validate.schema = sch.schema;
        validate.schemaEnv = sch;
        if (sch.$async)
            validate.$async = true;
        if (this.opts.code.source === true) {
            validate.source = { validateName, validateCode, scopeValues: gen._values };
        }
        if (this.opts.unevaluated) {
            const { props, items } = schemaCxt;
            validate.evaluated = {
                props: props instanceof codegen_1.Name ? undefined : props,
                items: items instanceof codegen_1.Name ? undefined : items,
                dynamicProps: props instanceof codegen_1.Name,
                dynamicItems: items instanceof codegen_1.Name,
            };
            if (validate.source)
                validate.source.evaluated = (0, codegen_1.stringify)(validate.evaluated);
        }
        sch.validate = validate;
        return sch;
    }
    catch (e) {
        delete sch.validate;
        delete sch.validateName;
        if (sourceCode)
            this.logger.error("Error compiling schema, function code:", sourceCode);
        // console.log("\n\n\n *** \n", sourceCode, this.opts)
        throw e;
    }
    finally {
        this._compilations.delete(sch);
    }
}
exports.compileSchema = compileSchema;
function resolveRef(root, baseId, ref) {
    var _a;
    ref = (0, resolve_1.resolveUrl)(this.opts.uriResolver, baseId, ref);
    const schOrFunc = root.refs[ref];
    if (schOrFunc)
        return schOrFunc;
    let _sch = resolve.call(this, root, ref);
    if (_sch === undefined) {
        const schema = (_a = root.localRefs) === null || _a === void 0 ? void 0 : _a[ref]; // TODO maybe localRefs should hold SchemaEnv
        const { schemaId } = this.opts;
        if (schema)
            _sch = new SchemaEnv({ schema, schemaId, root, baseId });
    }
    if (_sch === undefined)
        return;
    return (root.refs[ref] = inlineOrCompile.call(this, _sch));
}
exports.resolveRef = resolveRef;
function inlineOrCompile(sch) {
    if ((0, resolve_1.inlineRef)(sch.schema, this.opts.inlineRefs))
        return sch.schema;
    return sch.validate ? sch : compileSchema.call(this, sch);
}
// Index of schema compilation in the currently compiled list
function getCompilingSchema(schEnv) {
    for (const sch of this._compilations) {
        if (sameSchemaEnv(sch, schEnv))
            return sch;
    }
}
exports.getCompilingSchema = getCompilingSchema;
function sameSchemaEnv(s1, s2) {
    return s1.schema === s2.schema && s1.root === s2.root && s1.baseId === s2.baseId;
}
// resolve and compile the references ($ref)
// TODO returns AnySchemaObject (if the schema can be inlined) or validation function
function resolve(root, // information about the root schema for the current schema
ref // reference to resolve
) {
    let sch;
    while (typeof (sch = this.refs[ref]) == "string")
        ref = sch;
    return sch || this.schemas[ref] || resolveSchema.call(this, root, ref);
}
// Resolve schema, its root and baseId
function resolveSchema(root, // root object with properties schema, refs TODO below SchemaEnv is assigned to it
ref // reference to resolve
) {
    const p = this.opts.uriResolver.parse(ref);
    const refPath = (0, resolve_1._getFullPath)(this.opts.uriResolver, p);
    let baseId = (0, resolve_1.getFullPath)(this.opts.uriResolver, root.baseId, undefined);
    // TODO `Object.keys(root.schema).length > 0` should not be needed - but removing breaks 2 tests
    if (Object.keys(root.schema).length > 0 && refPath === baseId) {
        return getJsonPointer.call(this, p, root);
    }
    const id = (0, resolve_1.normalizeId)(refPath);
    const schOrRef = this.refs[id] || this.schemas[id];
    if (typeof schOrRef == "string") {
        const sch = resolveSchema.call(this, root, schOrRef);
        if (typeof (sch === null || sch === void 0 ? void 0 : sch.schema) !== "object")
            return;
        return getJsonPointer.call(this, p, sch);
    }
    if (typeof (schOrRef === null || schOrRef === void 0 ? void 0 : schOrRef.schema) !== "object")
        return;
    if (!schOrRef.validate)
        compileSchema.call(this, schOrRef);
    if (id === (0, resolve_1.normalizeId)(ref)) {
        const { schema } = schOrRef;
        const { schemaId } = this.opts;
        const schId = schema[schemaId];
        if (schId)
            baseId = (0, resolve_1.resolveUrl)(this.opts.uriResolver, baseId, schId);
        return new SchemaEnv({ schema, schemaId, root, baseId });
    }
    return getJsonPointer.call(this, p, schOrRef);
}
exports.resolveSchema = resolveSchema;
const PREVENT_SCOPE_CHANGE = new Set([
    "properties",
    "patternProperties",
    "enum",
    "dependencies",
    "definitions",
]);
function getJsonPointer(parsedRef, { baseId, schema, root }) {
    var _a;
    if (((_a = parsedRef.fragment) === null || _a === void 0 ? void 0 : _a[0]) !== "/")
        return;
    for (const part of parsedRef.fragment.slice(1).split("/")) {
        if (typeof schema === "boolean")
            return;
        const partSchema = schema[(0, util_1.unescapeFragment)(part)];
        if (partSchema === undefined)
            return;
        schema = partSchema;
        // TODO PREVENT_SCOPE_CHANGE could be defined in keyword def?
        const schId = typeof schema === "object" && schema[this.opts.schemaId];
        if (!PREVENT_SCOPE_CHANGE.has(part) && schId) {
            baseId = (0, resolve_1.resolveUrl)(this.opts.uriResolver, baseId, schId);
        }
    }
    let env;
    if (typeof schema != "boolean" && schema.$ref && !(0, util_1.schemaHasRulesButRef)(schema, this.RULES)) {
        const $ref = (0, resolve_1.resolveUrl)(this.opts.uriResolver, baseId, schema.$ref);
        env = resolveSchema.call(this, root, $ref);
    }
    // even though resolution failed we need to return SchemaEnv to throw exception
    // so that compileAsync loads missing schema.
    const { schemaId } = this.opts;
    env = env || new SchemaEnv({ schema, schemaId, root, baseId });
    if (env.schema !== env.root.schema)
        return env;
    return undefined;
}


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/names.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/names.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const codegen_1 = __webpack_require__(/*! ./codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const names = {
    // validation function arguments
    data: new codegen_1.Name("data"), // data passed to validation function
    // args passed from referencing schema
    valCxt: new codegen_1.Name("valCxt"), // validation/data context - should not be used directly, it is destructured to the names below
    instancePath: new codegen_1.Name("instancePath"),
    parentData: new codegen_1.Name("parentData"),
    parentDataProperty: new codegen_1.Name("parentDataProperty"),
    rootData: new codegen_1.Name("rootData"), // root data - same as the data passed to the first/top validation function
    dynamicAnchors: new codegen_1.Name("dynamicAnchors"), // used to support recursiveRef and dynamicRef
    // function scoped variables
    vErrors: new codegen_1.Name("vErrors"), // null or array of validation errors
    errors: new codegen_1.Name("errors"), // counter of validation errors
    this: new codegen_1.Name("this"),
    // "globals"
    self: new codegen_1.Name("self"),
    scope: new codegen_1.Name("scope"),
    // JTD serialize/parse name for JSON string and position
    json: new codegen_1.Name("json"),
    jsonPos: new codegen_1.Name("jsonPos"),
    jsonLen: new codegen_1.Name("jsonLen"),
    jsonPart: new codegen_1.Name("jsonPart"),
};
exports["default"] = names;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/ref_error.js":
/*!******************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/ref_error.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const resolve_1 = __webpack_require__(/*! ./resolve */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/resolve.js");
class MissingRefError extends Error {
    constructor(resolver, baseId, ref, msg) {
        super(msg || `can't resolve reference ${ref} from id ${baseId}`);
        this.missingRef = (0, resolve_1.resolveUrl)(resolver, baseId, ref);
        this.missingSchema = (0, resolve_1.normalizeId)((0, resolve_1.getFullPath)(resolver, this.missingRef));
    }
}
exports["default"] = MissingRefError;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/resolve.js":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/resolve.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getSchemaRefs = exports.resolveUrl = exports.normalizeId = exports._getFullPath = exports.getFullPath = exports.inlineRef = void 0;
const util_1 = __webpack_require__(/*! ./util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const equal = __webpack_require__(/*! fast-deep-equal */ "../../node_modules/fast-deep-equal/index.js");
const traverse = __webpack_require__(/*! json-schema-traverse */ "../../node_modules/json-schema-traverse/index.js");
// TODO refactor to use keyword definitions
const SIMPLE_INLINED = new Set([
    "type",
    "format",
    "pattern",
    "maxLength",
    "minLength",
    "maxProperties",
    "minProperties",
    "maxItems",
    "minItems",
    "maximum",
    "minimum",
    "uniqueItems",
    "multipleOf",
    "required",
    "enum",
    "const",
]);
function inlineRef(schema, limit = true) {
    if (typeof schema == "boolean")
        return true;
    if (limit === true)
        return !hasRef(schema);
    if (!limit)
        return false;
    return countKeys(schema) <= limit;
}
exports.inlineRef = inlineRef;
const REF_KEYWORDS = new Set([
    "$ref",
    "$recursiveRef",
    "$recursiveAnchor",
    "$dynamicRef",
    "$dynamicAnchor",
]);
function hasRef(schema) {
    for (const key in schema) {
        if (REF_KEYWORDS.has(key))
            return true;
        const sch = schema[key];
        if (Array.isArray(sch) && sch.some(hasRef))
            return true;
        if (typeof sch == "object" && hasRef(sch))
            return true;
    }
    return false;
}
function countKeys(schema) {
    let count = 0;
    for (const key in schema) {
        if (key === "$ref")
            return Infinity;
        count++;
        if (SIMPLE_INLINED.has(key))
            continue;
        if (typeof schema[key] == "object") {
            (0, util_1.eachItem)(schema[key], (sch) => (count += countKeys(sch)));
        }
        if (count === Infinity)
            return Infinity;
    }
    return count;
}
function getFullPath(resolver, id = "", normalize) {
    if (normalize !== false)
        id = normalizeId(id);
    const p = resolver.parse(id);
    return _getFullPath(resolver, p);
}
exports.getFullPath = getFullPath;
function _getFullPath(resolver, p) {
    const serialized = resolver.serialize(p);
    return serialized.split("#")[0] + "#";
}
exports._getFullPath = _getFullPath;
const TRAILING_SLASH_HASH = /#\/?$/;
function normalizeId(id) {
    return id ? id.replace(TRAILING_SLASH_HASH, "") : "";
}
exports.normalizeId = normalizeId;
function resolveUrl(resolver, baseId, id) {
    id = normalizeId(id);
    return resolver.resolve(baseId, id);
}
exports.resolveUrl = resolveUrl;
const ANCHOR = /^[a-z_][-a-z0-9._]*$/i;
function getSchemaRefs(schema, baseId) {
    if (typeof schema == "boolean")
        return {};
    const { schemaId, uriResolver } = this.opts;
    const schId = normalizeId(schema[schemaId] || baseId);
    const baseIds = { "": schId };
    const pathPrefix = getFullPath(uriResolver, schId, false);
    const localRefs = {};
    const schemaRefs = new Set();
    traverse(schema, { allKeys: true }, (sch, jsonPtr, _, parentJsonPtr) => {
        if (parentJsonPtr === undefined)
            return;
        const fullPath = pathPrefix + jsonPtr;
        let innerBaseId = baseIds[parentJsonPtr];
        if (typeof sch[schemaId] == "string")
            innerBaseId = addRef.call(this, sch[schemaId]);
        addAnchor.call(this, sch.$anchor);
        addAnchor.call(this, sch.$dynamicAnchor);
        baseIds[jsonPtr] = innerBaseId;
        function addRef(ref) {
            // eslint-disable-next-line @typescript-eslint/unbound-method
            const _resolve = this.opts.uriResolver.resolve;
            ref = normalizeId(innerBaseId ? _resolve(innerBaseId, ref) : ref);
            if (schemaRefs.has(ref))
                throw ambiguos(ref);
            schemaRefs.add(ref);
            let schOrRef = this.refs[ref];
            if (typeof schOrRef == "string")
                schOrRef = this.refs[schOrRef];
            if (typeof schOrRef == "object") {
                checkAmbiguosRef(sch, schOrRef.schema, ref);
            }
            else if (ref !== normalizeId(fullPath)) {
                if (ref[0] === "#") {
                    checkAmbiguosRef(sch, localRefs[ref], ref);
                    localRefs[ref] = sch;
                }
                else {
                    this.refs[ref] = fullPath;
                }
            }
            return ref;
        }
        function addAnchor(anchor) {
            if (typeof anchor == "string") {
                if (!ANCHOR.test(anchor))
                    throw new Error(`invalid anchor "${anchor}"`);
                addRef.call(this, `#${anchor}`);
            }
        }
    });
    return localRefs;
    function checkAmbiguosRef(sch1, sch2, ref) {
        if (sch2 !== undefined && !equal(sch1, sch2))
            throw ambiguos(ref);
    }
    function ambiguos(ref) {
        return new Error(`reference "${ref}" resolves to more than one schema`);
    }
}
exports.getSchemaRefs = getSchemaRefs;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/rules.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/rules.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getRules = exports.isJSONType = void 0;
const _jsonTypes = ["string", "number", "integer", "boolean", "null", "object", "array"];
const jsonTypes = new Set(_jsonTypes);
function isJSONType(x) {
    return typeof x == "string" && jsonTypes.has(x);
}
exports.isJSONType = isJSONType;
function getRules() {
    const groups = {
        number: { type: "number", rules: [] },
        string: { type: "string", rules: [] },
        array: { type: "array", rules: [] },
        object: { type: "object", rules: [] },
    };
    return {
        types: { ...groups, integer: true, boolean: true, null: true },
        rules: [{ rules: [] }, groups.number, groups.string, groups.array, groups.object],
        post: { rules: [] },
        all: {},
        keywords: {},
    };
}
exports.getRules = getRules;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.checkStrictMode = exports.getErrorPath = exports.Type = exports.useFunc = exports.setEvaluated = exports.evaluatedPropsToName = exports.mergeEvaluated = exports.eachItem = exports.unescapeJsonPointer = exports.escapeJsonPointer = exports.escapeFragment = exports.unescapeFragment = exports.schemaRefOrVal = exports.schemaHasRulesButRef = exports.schemaHasRules = exports.checkUnknownRules = exports.alwaysValidSchema = exports.toHash = void 0;
const codegen_1 = __webpack_require__(/*! ./codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const code_1 = __webpack_require__(/*! ./codegen/code */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/code.js");
// TODO refactor to use Set
function toHash(arr) {
    const hash = {};
    for (const item of arr)
        hash[item] = true;
    return hash;
}
exports.toHash = toHash;
function alwaysValidSchema(it, schema) {
    if (typeof schema == "boolean")
        return schema;
    if (Object.keys(schema).length === 0)
        return true;
    checkUnknownRules(it, schema);
    return !schemaHasRules(schema, it.self.RULES.all);
}
exports.alwaysValidSchema = alwaysValidSchema;
function checkUnknownRules(it, schema = it.schema) {
    const { opts, self } = it;
    if (!opts.strictSchema)
        return;
    if (typeof schema === "boolean")
        return;
    const rules = self.RULES.keywords;
    for (const key in schema) {
        if (!rules[key])
            checkStrictMode(it, `unknown keyword: "${key}"`);
    }
}
exports.checkUnknownRules = checkUnknownRules;
function schemaHasRules(schema, rules) {
    if (typeof schema == "boolean")
        return !schema;
    for (const key in schema)
        if (rules[key])
            return true;
    return false;
}
exports.schemaHasRules = schemaHasRules;
function schemaHasRulesButRef(schema, RULES) {
    if (typeof schema == "boolean")
        return !schema;
    for (const key in schema)
        if (key !== "$ref" && RULES.all[key])
            return true;
    return false;
}
exports.schemaHasRulesButRef = schemaHasRulesButRef;
function schemaRefOrVal({ topSchemaRef, schemaPath }, schema, keyword, $data) {
    if (!$data) {
        if (typeof schema == "number" || typeof schema == "boolean")
            return schema;
        if (typeof schema == "string")
            return (0, codegen_1._) `${schema}`;
    }
    return (0, codegen_1._) `${topSchemaRef}${schemaPath}${(0, codegen_1.getProperty)(keyword)}`;
}
exports.schemaRefOrVal = schemaRefOrVal;
function unescapeFragment(str) {
    return unescapeJsonPointer(decodeURIComponent(str));
}
exports.unescapeFragment = unescapeFragment;
function escapeFragment(str) {
    return encodeURIComponent(escapeJsonPointer(str));
}
exports.escapeFragment = escapeFragment;
function escapeJsonPointer(str) {
    if (typeof str == "number")
        return `${str}`;
    return str.replace(/~/g, "~0").replace(/\//g, "~1");
}
exports.escapeJsonPointer = escapeJsonPointer;
function unescapeJsonPointer(str) {
    return str.replace(/~1/g, "/").replace(/~0/g, "~");
}
exports.unescapeJsonPointer = unescapeJsonPointer;
function eachItem(xs, f) {
    if (Array.isArray(xs)) {
        for (const x of xs)
            f(x);
    }
    else {
        f(xs);
    }
}
exports.eachItem = eachItem;
function makeMergeEvaluated({ mergeNames, mergeToName, mergeValues, resultToName, }) {
    return (gen, from, to, toName) => {
        const res = to === undefined
            ? from
            : to instanceof codegen_1.Name
                ? (from instanceof codegen_1.Name ? mergeNames(gen, from, to) : mergeToName(gen, from, to), to)
                : from instanceof codegen_1.Name
                    ? (mergeToName(gen, to, from), from)
                    : mergeValues(from, to);
        return toName === codegen_1.Name && !(res instanceof codegen_1.Name) ? resultToName(gen, res) : res;
    };
}
exports.mergeEvaluated = {
    props: makeMergeEvaluated({
        mergeNames: (gen, from, to) => gen.if((0, codegen_1._) `${to} !== true && ${from} !== undefined`, () => {
            gen.if((0, codegen_1._) `${from} === true`, () => gen.assign(to, true), () => gen.assign(to, (0, codegen_1._) `${to} || {}`).code((0, codegen_1._) `Object.assign(${to}, ${from})`));
        }),
        mergeToName: (gen, from, to) => gen.if((0, codegen_1._) `${to} !== true`, () => {
            if (from === true) {
                gen.assign(to, true);
            }
            else {
                gen.assign(to, (0, codegen_1._) `${to} || {}`);
                setEvaluated(gen, to, from);
            }
        }),
        mergeValues: (from, to) => (from === true ? true : { ...from, ...to }),
        resultToName: evaluatedPropsToName,
    }),
    items: makeMergeEvaluated({
        mergeNames: (gen, from, to) => gen.if((0, codegen_1._) `${to} !== true && ${from} !== undefined`, () => gen.assign(to, (0, codegen_1._) `${from} === true ? true : ${to} > ${from} ? ${to} : ${from}`)),
        mergeToName: (gen, from, to) => gen.if((0, codegen_1._) `${to} !== true`, () => gen.assign(to, from === true ? true : (0, codegen_1._) `${to} > ${from} ? ${to} : ${from}`)),
        mergeValues: (from, to) => (from === true ? true : Math.max(from, to)),
        resultToName: (gen, items) => gen.var("items", items),
    }),
};
function evaluatedPropsToName(gen, ps) {
    if (ps === true)
        return gen.var("props", true);
    const props = gen.var("props", (0, codegen_1._) `{}`);
    if (ps !== undefined)
        setEvaluated(gen, props, ps);
    return props;
}
exports.evaluatedPropsToName = evaluatedPropsToName;
function setEvaluated(gen, props, ps) {
    Object.keys(ps).forEach((p) => gen.assign((0, codegen_1._) `${props}${(0, codegen_1.getProperty)(p)}`, true));
}
exports.setEvaluated = setEvaluated;
const snippets = {};
function useFunc(gen, f) {
    return gen.scopeValue("func", {
        ref: f,
        code: snippets[f.code] || (snippets[f.code] = new code_1._Code(f.code)),
    });
}
exports.useFunc = useFunc;
var Type;
(function (Type) {
    Type[Type["Num"] = 0] = "Num";
    Type[Type["Str"] = 1] = "Str";
})(Type || (exports.Type = Type = {}));
function getErrorPath(dataProp, dataPropType, jsPropertySyntax) {
    // let path
    if (dataProp instanceof codegen_1.Name) {
        const isNumber = dataPropType === Type.Num;
        return jsPropertySyntax
            ? isNumber
                ? (0, codegen_1._) `"[" + ${dataProp} + "]"`
                : (0, codegen_1._) `"['" + ${dataProp} + "']"`
            : isNumber
                ? (0, codegen_1._) `"/" + ${dataProp}`
                : (0, codegen_1._) `"/" + ${dataProp}.replace(/~/g, "~0").replace(/\\//g, "~1")`; // TODO maybe use global escapePointer
    }
    return jsPropertySyntax ? (0, codegen_1.getProperty)(dataProp).toString() : "/" + escapeJsonPointer(dataProp);
}
exports.getErrorPath = getErrorPath;
function checkStrictMode(it, msg, mode = it.opts.strictSchema) {
    if (!mode)
        return;
    msg = `strict mode: ${msg}`;
    if (mode === true)
        throw new Error(msg);
    it.self.logger.warn(msg);
}
exports.checkStrictMode = checkStrictMode;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/applicability.js":
/*!*******************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/applicability.js ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.shouldUseRule = exports.shouldUseGroup = exports.schemaHasRulesForType = void 0;
function schemaHasRulesForType({ schema, self }, type) {
    const group = self.RULES.types[type];
    return group && group !== true && shouldUseGroup(schema, group);
}
exports.schemaHasRulesForType = schemaHasRulesForType;
function shouldUseGroup(schema, group) {
    return group.rules.some((rule) => shouldUseRule(schema, rule));
}
exports.shouldUseGroup = shouldUseGroup;
function shouldUseRule(schema, rule) {
    var _a;
    return (schema[rule.keyword] !== undefined ||
        ((_a = rule.definition.implements) === null || _a === void 0 ? void 0 : _a.some((kwd) => schema[kwd] !== undefined)));
}
exports.shouldUseRule = shouldUseRule;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/boolSchema.js":
/*!****************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/boolSchema.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.boolOrEmptySchema = exports.topBoolOrEmptySchema = void 0;
const errors_1 = __webpack_require__(/*! ../errors */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/errors.js");
const codegen_1 = __webpack_require__(/*! ../codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const names_1 = __webpack_require__(/*! ../names */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/names.js");
const boolError = {
    message: "boolean schema is false",
};
function topBoolOrEmptySchema(it) {
    const { gen, schema, validateName } = it;
    if (schema === false) {
        falseSchemaError(it, false);
    }
    else if (typeof schema == "object" && schema.$async === true) {
        gen.return(names_1.default.data);
    }
    else {
        gen.assign((0, codegen_1._) `${validateName}.errors`, null);
        gen.return(true);
    }
}
exports.topBoolOrEmptySchema = topBoolOrEmptySchema;
function boolOrEmptySchema(it, valid) {
    const { gen, schema } = it;
    if (schema === false) {
        gen.var(valid, false); // TODO var
        falseSchemaError(it);
    }
    else {
        gen.var(valid, true); // TODO var
    }
}
exports.boolOrEmptySchema = boolOrEmptySchema;
function falseSchemaError(it, overrideAllErrors) {
    const { gen, data } = it;
    // TODO maybe some other interface should be used for non-keyword validation errors...
    const cxt = {
        gen,
        keyword: "false schema",
        data,
        schema: false,
        schemaCode: false,
        schemaValue: false,
        params: {},
        it,
    };
    (0, errors_1.reportError)(cxt, boolError, undefined, overrideAllErrors);
}


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/dataType.js":
/*!**************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/dataType.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.reportTypeError = exports.checkDataTypes = exports.checkDataType = exports.coerceAndCheckDataType = exports.getJSONTypes = exports.getSchemaTypes = exports.DataType = void 0;
const rules_1 = __webpack_require__(/*! ../rules */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/rules.js");
const applicability_1 = __webpack_require__(/*! ./applicability */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/applicability.js");
const errors_1 = __webpack_require__(/*! ../errors */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/errors.js");
const codegen_1 = __webpack_require__(/*! ../codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const util_1 = __webpack_require__(/*! ../util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
var DataType;
(function (DataType) {
    DataType[DataType["Correct"] = 0] = "Correct";
    DataType[DataType["Wrong"] = 1] = "Wrong";
})(DataType || (exports.DataType = DataType = {}));
function getSchemaTypes(schema) {
    const types = getJSONTypes(schema.type);
    const hasNull = types.includes("null");
    if (hasNull) {
        if (schema.nullable === false)
            throw new Error("type: null contradicts nullable: false");
    }
    else {
        if (!types.length && schema.nullable !== undefined) {
            throw new Error('"nullable" cannot be used without "type"');
        }
        if (schema.nullable === true)
            types.push("null");
    }
    return types;
}
exports.getSchemaTypes = getSchemaTypes;
// eslint-disable-next-line @typescript-eslint/no-redundant-type-constituents
function getJSONTypes(ts) {
    const types = Array.isArray(ts) ? ts : ts ? [ts] : [];
    if (types.every(rules_1.isJSONType))
        return types;
    throw new Error("type must be JSONType or JSONType[]: " + types.join(","));
}
exports.getJSONTypes = getJSONTypes;
function coerceAndCheckDataType(it, types) {
    const { gen, data, opts } = it;
    const coerceTo = coerceToTypes(types, opts.coerceTypes);
    const checkTypes = types.length > 0 &&
        !(coerceTo.length === 0 && types.length === 1 && (0, applicability_1.schemaHasRulesForType)(it, types[0]));
    if (checkTypes) {
        const wrongType = checkDataTypes(types, data, opts.strictNumbers, DataType.Wrong);
        gen.if(wrongType, () => {
            if (coerceTo.length)
                coerceData(it, types, coerceTo);
            else
                reportTypeError(it);
        });
    }
    return checkTypes;
}
exports.coerceAndCheckDataType = coerceAndCheckDataType;
const COERCIBLE = new Set(["string", "number", "integer", "boolean", "null"]);
function coerceToTypes(types, coerceTypes) {
    return coerceTypes
        ? types.filter((t) => COERCIBLE.has(t) || (coerceTypes === "array" && t === "array"))
        : [];
}
function coerceData(it, types, coerceTo) {
    const { gen, data, opts } = it;
    const dataType = gen.let("dataType", (0, codegen_1._) `typeof ${data}`);
    const coerced = gen.let("coerced", (0, codegen_1._) `undefined`);
    if (opts.coerceTypes === "array") {
        gen.if((0, codegen_1._) `${dataType} == 'object' && Array.isArray(${data}) && ${data}.length == 1`, () => gen
            .assign(data, (0, codegen_1._) `${data}[0]`)
            .assign(dataType, (0, codegen_1._) `typeof ${data}`)
            .if(checkDataTypes(types, data, opts.strictNumbers), () => gen.assign(coerced, data)));
    }
    gen.if((0, codegen_1._) `${coerced} !== undefined`);
    for (const t of coerceTo) {
        if (COERCIBLE.has(t) || (t === "array" && opts.coerceTypes === "array")) {
            coerceSpecificType(t);
        }
    }
    gen.else();
    reportTypeError(it);
    gen.endIf();
    gen.if((0, codegen_1._) `${coerced} !== undefined`, () => {
        gen.assign(data, coerced);
        assignParentData(it, coerced);
    });
    function coerceSpecificType(t) {
        switch (t) {
            case "string":
                gen
                    .elseIf((0, codegen_1._) `${dataType} == "number" || ${dataType} == "boolean"`)
                    .assign(coerced, (0, codegen_1._) `"" + ${data}`)
                    .elseIf((0, codegen_1._) `${data} === null`)
                    .assign(coerced, (0, codegen_1._) `""`);
                return;
            case "number":
                gen
                    .elseIf((0, codegen_1._) `${dataType} == "boolean" || ${data} === null
              || (${dataType} == "string" && ${data} && ${data} == +${data})`)
                    .assign(coerced, (0, codegen_1._) `+${data}`);
                return;
            case "integer":
                gen
                    .elseIf((0, codegen_1._) `${dataType} === "boolean" || ${data} === null
              || (${dataType} === "string" && ${data} && ${data} == +${data} && !(${data} % 1))`)
                    .assign(coerced, (0, codegen_1._) `+${data}`);
                return;
            case "boolean":
                gen
                    .elseIf((0, codegen_1._) `${data} === "false" || ${data} === 0 || ${data} === null`)
                    .assign(coerced, false)
                    .elseIf((0, codegen_1._) `${data} === "true" || ${data} === 1`)
                    .assign(coerced, true);
                return;
            case "null":
                gen.elseIf((0, codegen_1._) `${data} === "" || ${data} === 0 || ${data} === false`);
                gen.assign(coerced, null);
                return;
            case "array":
                gen
                    .elseIf((0, codegen_1._) `${dataType} === "string" || ${dataType} === "number"
              || ${dataType} === "boolean" || ${data} === null`)
                    .assign(coerced, (0, codegen_1._) `[${data}]`);
        }
    }
}
function assignParentData({ gen, parentData, parentDataProperty }, expr) {
    // TODO use gen.property
    gen.if((0, codegen_1._) `${parentData} !== undefined`, () => gen.assign((0, codegen_1._) `${parentData}[${parentDataProperty}]`, expr));
}
function checkDataType(dataType, data, strictNums, correct = DataType.Correct) {
    const EQ = correct === DataType.Correct ? codegen_1.operators.EQ : codegen_1.operators.NEQ;
    let cond;
    switch (dataType) {
        case "null":
            return (0, codegen_1._) `${data} ${EQ} null`;
        case "array":
            cond = (0, codegen_1._) `Array.isArray(${data})`;
            break;
        case "object":
            cond = (0, codegen_1._) `${data} && typeof ${data} == "object" && !Array.isArray(${data})`;
            break;
        case "integer":
            cond = numCond((0, codegen_1._) `!(${data} % 1) && !isNaN(${data})`);
            break;
        case "number":
            cond = numCond();
            break;
        default:
            return (0, codegen_1._) `typeof ${data} ${EQ} ${dataType}`;
    }
    return correct === DataType.Correct ? cond : (0, codegen_1.not)(cond);
    function numCond(_cond = codegen_1.nil) {
        return (0, codegen_1.and)((0, codegen_1._) `typeof ${data} == "number"`, _cond, strictNums ? (0, codegen_1._) `isFinite(${data})` : codegen_1.nil);
    }
}
exports.checkDataType = checkDataType;
function checkDataTypes(dataTypes, data, strictNums, correct) {
    if (dataTypes.length === 1) {
        return checkDataType(dataTypes[0], data, strictNums, correct);
    }
    let cond;
    const types = (0, util_1.toHash)(dataTypes);
    if (types.array && types.object) {
        const notObj = (0, codegen_1._) `typeof ${data} != "object"`;
        cond = types.null ? notObj : (0, codegen_1._) `!${data} || ${notObj}`;
        delete types.null;
        delete types.array;
        delete types.object;
    }
    else {
        cond = codegen_1.nil;
    }
    if (types.number)
        delete types.integer;
    for (const t in types)
        cond = (0, codegen_1.and)(cond, checkDataType(t, data, strictNums, correct));
    return cond;
}
exports.checkDataTypes = checkDataTypes;
const typeError = {
    message: ({ schema }) => `must be ${schema}`,
    params: ({ schema, schemaValue }) => typeof schema == "string" ? (0, codegen_1._) `{type: ${schema}}` : (0, codegen_1._) `{type: ${schemaValue}}`,
};
function reportTypeError(it) {
    const cxt = getTypeErrorContext(it);
    (0, errors_1.reportError)(cxt, typeError);
}
exports.reportTypeError = reportTypeError;
function getTypeErrorContext(it) {
    const { gen, data, schema } = it;
    const schemaCode = (0, util_1.schemaRefOrVal)(it, schema, "type");
    return {
        gen,
        keyword: "type",
        data,
        schema: schema.type,
        schemaCode,
        schemaValue: schemaCode,
        parentSchema: schema,
        params: {},
        it,
    };
}


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/defaults.js":
/*!**************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/defaults.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.assignDefaults = void 0;
const codegen_1 = __webpack_require__(/*! ../codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const util_1 = __webpack_require__(/*! ../util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
function assignDefaults(it, ty) {
    const { properties, items } = it.schema;
    if (ty === "object" && properties) {
        for (const key in properties) {
            assignDefault(it, key, properties[key].default);
        }
    }
    else if (ty === "array" && Array.isArray(items)) {
        items.forEach((sch, i) => assignDefault(it, i, sch.default));
    }
}
exports.assignDefaults = assignDefaults;
function assignDefault(it, prop, defaultValue) {
    const { gen, compositeRule, data, opts } = it;
    if (defaultValue === undefined)
        return;
    const childData = (0, codegen_1._) `${data}${(0, codegen_1.getProperty)(prop)}`;
    if (compositeRule) {
        (0, util_1.checkStrictMode)(it, `default is ignored for: ${childData}`);
        return;
    }
    let condition = (0, codegen_1._) `${childData} === undefined`;
    if (opts.useDefaults === "empty") {
        condition = (0, codegen_1._) `${condition} || ${childData} === null || ${childData} === ""`;
    }
    // `${childData} === undefined` +
    // (opts.useDefaults === "empty" ? ` || ${childData} === null || ${childData} === ""` : "")
    gen.if(condition, (0, codegen_1._) `${childData} = ${(0, codegen_1.stringify)(defaultValue)}`);
}


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/index.js":
/*!***********************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/index.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getData = exports.KeywordCxt = exports.validateFunctionCode = void 0;
const boolSchema_1 = __webpack_require__(/*! ./boolSchema */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/boolSchema.js");
const dataType_1 = __webpack_require__(/*! ./dataType */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/dataType.js");
const applicability_1 = __webpack_require__(/*! ./applicability */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/applicability.js");
const dataType_2 = __webpack_require__(/*! ./dataType */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/dataType.js");
const defaults_1 = __webpack_require__(/*! ./defaults */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/defaults.js");
const keyword_1 = __webpack_require__(/*! ./keyword */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/keyword.js");
const subschema_1 = __webpack_require__(/*! ./subschema */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/subschema.js");
const codegen_1 = __webpack_require__(/*! ../codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const names_1 = __webpack_require__(/*! ../names */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/names.js");
const resolve_1 = __webpack_require__(/*! ../resolve */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/resolve.js");
const util_1 = __webpack_require__(/*! ../util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const errors_1 = __webpack_require__(/*! ../errors */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/errors.js");
// schema compilation - generates validation function, subschemaCode (below) is used for subschemas
function validateFunctionCode(it) {
    if (isSchemaObj(it)) {
        checkKeywords(it);
        if (schemaCxtHasRules(it)) {
            topSchemaObjCode(it);
            return;
        }
    }
    validateFunction(it, () => (0, boolSchema_1.topBoolOrEmptySchema)(it));
}
exports.validateFunctionCode = validateFunctionCode;
function validateFunction({ gen, validateName, schema, schemaEnv, opts }, body) {
    if (opts.code.es5) {
        gen.func(validateName, (0, codegen_1._) `${names_1.default.data}, ${names_1.default.valCxt}`, schemaEnv.$async, () => {
            gen.code((0, codegen_1._) `"use strict"; ${funcSourceUrl(schema, opts)}`);
            destructureValCxtES5(gen, opts);
            gen.code(body);
        });
    }
    else {
        gen.func(validateName, (0, codegen_1._) `${names_1.default.data}, ${destructureValCxt(opts)}`, schemaEnv.$async, () => gen.code(funcSourceUrl(schema, opts)).code(body));
    }
}
function destructureValCxt(opts) {
    return (0, codegen_1._) `{${names_1.default.instancePath}="", ${names_1.default.parentData}, ${names_1.default.parentDataProperty}, ${names_1.default.rootData}=${names_1.default.data}${opts.dynamicRef ? (0, codegen_1._) `, ${names_1.default.dynamicAnchors}={}` : codegen_1.nil}}={}`;
}
function destructureValCxtES5(gen, opts) {
    gen.if(names_1.default.valCxt, () => {
        gen.var(names_1.default.instancePath, (0, codegen_1._) `${names_1.default.valCxt}.${names_1.default.instancePath}`);
        gen.var(names_1.default.parentData, (0, codegen_1._) `${names_1.default.valCxt}.${names_1.default.parentData}`);
        gen.var(names_1.default.parentDataProperty, (0, codegen_1._) `${names_1.default.valCxt}.${names_1.default.parentDataProperty}`);
        gen.var(names_1.default.rootData, (0, codegen_1._) `${names_1.default.valCxt}.${names_1.default.rootData}`);
        if (opts.dynamicRef)
            gen.var(names_1.default.dynamicAnchors, (0, codegen_1._) `${names_1.default.valCxt}.${names_1.default.dynamicAnchors}`);
    }, () => {
        gen.var(names_1.default.instancePath, (0, codegen_1._) `""`);
        gen.var(names_1.default.parentData, (0, codegen_1._) `undefined`);
        gen.var(names_1.default.parentDataProperty, (0, codegen_1._) `undefined`);
        gen.var(names_1.default.rootData, names_1.default.data);
        if (opts.dynamicRef)
            gen.var(names_1.default.dynamicAnchors, (0, codegen_1._) `{}`);
    });
}
function topSchemaObjCode(it) {
    const { schema, opts, gen } = it;
    validateFunction(it, () => {
        if (opts.$comment && schema.$comment)
            commentKeyword(it);
        checkNoDefault(it);
        gen.let(names_1.default.vErrors, null);
        gen.let(names_1.default.errors, 0);
        if (opts.unevaluated)
            resetEvaluated(it);
        typeAndKeywords(it);
        returnResults(it);
    });
    return;
}
function resetEvaluated(it) {
    // TODO maybe some hook to execute it in the end to check whether props/items are Name, as in assignEvaluated
    const { gen, validateName } = it;
    it.evaluated = gen.const("evaluated", (0, codegen_1._) `${validateName}.evaluated`);
    gen.if((0, codegen_1._) `${it.evaluated}.dynamicProps`, () => gen.assign((0, codegen_1._) `${it.evaluated}.props`, (0, codegen_1._) `undefined`));
    gen.if((0, codegen_1._) `${it.evaluated}.dynamicItems`, () => gen.assign((0, codegen_1._) `${it.evaluated}.items`, (0, codegen_1._) `undefined`));
}
function funcSourceUrl(schema, opts) {
    const schId = typeof schema == "object" && schema[opts.schemaId];
    return schId && (opts.code.source || opts.code.process) ? (0, codegen_1._) `/*# sourceURL=${schId} */` : codegen_1.nil;
}
// schema compilation - this function is used recursively to generate code for sub-schemas
function subschemaCode(it, valid) {
    if (isSchemaObj(it)) {
        checkKeywords(it);
        if (schemaCxtHasRules(it)) {
            subSchemaObjCode(it, valid);
            return;
        }
    }
    (0, boolSchema_1.boolOrEmptySchema)(it, valid);
}
function schemaCxtHasRules({ schema, self }) {
    if (typeof schema == "boolean")
        return !schema;
    for (const key in schema)
        if (self.RULES.all[key])
            return true;
    return false;
}
function isSchemaObj(it) {
    return typeof it.schema != "boolean";
}
function subSchemaObjCode(it, valid) {
    const { schema, gen, opts } = it;
    if (opts.$comment && schema.$comment)
        commentKeyword(it);
    updateContext(it);
    checkAsyncSchema(it);
    const errsCount = gen.const("_errs", names_1.default.errors);
    typeAndKeywords(it, errsCount);
    // TODO var
    gen.var(valid, (0, codegen_1._) `${errsCount} === ${names_1.default.errors}`);
}
function checkKeywords(it) {
    (0, util_1.checkUnknownRules)(it);
    checkRefsAndKeywords(it);
}
function typeAndKeywords(it, errsCount) {
    if (it.opts.jtd)
        return schemaKeywords(it, [], false, errsCount);
    const types = (0, dataType_1.getSchemaTypes)(it.schema);
    const checkedTypes = (0, dataType_1.coerceAndCheckDataType)(it, types);
    schemaKeywords(it, types, !checkedTypes, errsCount);
}
function checkRefsAndKeywords(it) {
    const { schema, errSchemaPath, opts, self } = it;
    if (schema.$ref && opts.ignoreKeywordsWithRef && (0, util_1.schemaHasRulesButRef)(schema, self.RULES)) {
        self.logger.warn(`$ref: keywords ignored in schema at path "${errSchemaPath}"`);
    }
}
function checkNoDefault(it) {
    const { schema, opts } = it;
    if (schema.default !== undefined && opts.useDefaults && opts.strictSchema) {
        (0, util_1.checkStrictMode)(it, "default is ignored in the schema root");
    }
}
function updateContext(it) {
    const schId = it.schema[it.opts.schemaId];
    if (schId)
        it.baseId = (0, resolve_1.resolveUrl)(it.opts.uriResolver, it.baseId, schId);
}
function checkAsyncSchema(it) {
    if (it.schema.$async && !it.schemaEnv.$async)
        throw new Error("async schema in sync schema");
}
function commentKeyword({ gen, schemaEnv, schema, errSchemaPath, opts }) {
    const msg = schema.$comment;
    if (opts.$comment === true) {
        gen.code((0, codegen_1._) `${names_1.default.self}.logger.log(${msg})`);
    }
    else if (typeof opts.$comment == "function") {
        const schemaPath = (0, codegen_1.str) `${errSchemaPath}/$comment`;
        const rootName = gen.scopeValue("root", { ref: schemaEnv.root });
        gen.code((0, codegen_1._) `${names_1.default.self}.opts.$comment(${msg}, ${schemaPath}, ${rootName}.schema)`);
    }
}
function returnResults(it) {
    const { gen, schemaEnv, validateName, ValidationError, opts } = it;
    if (schemaEnv.$async) {
        // TODO assign unevaluated
        gen.if((0, codegen_1._) `${names_1.default.errors} === 0`, () => gen.return(names_1.default.data), () => gen.throw((0, codegen_1._) `new ${ValidationError}(${names_1.default.vErrors})`));
    }
    else {
        gen.assign((0, codegen_1._) `${validateName}.errors`, names_1.default.vErrors);
        if (opts.unevaluated)
            assignEvaluated(it);
        gen.return((0, codegen_1._) `${names_1.default.errors} === 0`);
    }
}
function assignEvaluated({ gen, evaluated, props, items }) {
    if (props instanceof codegen_1.Name)
        gen.assign((0, codegen_1._) `${evaluated}.props`, props);
    if (items instanceof codegen_1.Name)
        gen.assign((0, codegen_1._) `${evaluated}.items`, items);
}
function schemaKeywords(it, types, typeErrors, errsCount) {
    const { gen, schema, data, allErrors, opts, self } = it;
    const { RULES } = self;
    if (schema.$ref && (opts.ignoreKeywordsWithRef || !(0, util_1.schemaHasRulesButRef)(schema, RULES))) {
        gen.block(() => keywordCode(it, "$ref", RULES.all.$ref.definition)); // TODO typecast
        return;
    }
    if (!opts.jtd)
        checkStrictTypes(it, types);
    gen.block(() => {
        for (const group of RULES.rules)
            groupKeywords(group);
        groupKeywords(RULES.post);
    });
    function groupKeywords(group) {
        if (!(0, applicability_1.shouldUseGroup)(schema, group))
            return;
        if (group.type) {
            gen.if((0, dataType_2.checkDataType)(group.type, data, opts.strictNumbers));
            iterateKeywords(it, group);
            if (types.length === 1 && types[0] === group.type && typeErrors) {
                gen.else();
                (0, dataType_2.reportTypeError)(it);
            }
            gen.endIf();
        }
        else {
            iterateKeywords(it, group);
        }
        // TODO make it "ok" call?
        if (!allErrors)
            gen.if((0, codegen_1._) `${names_1.default.errors} === ${errsCount || 0}`);
    }
}
function iterateKeywords(it, group) {
    const { gen, schema, opts: { useDefaults }, } = it;
    if (useDefaults)
        (0, defaults_1.assignDefaults)(it, group.type);
    gen.block(() => {
        for (const rule of group.rules) {
            if ((0, applicability_1.shouldUseRule)(schema, rule)) {
                keywordCode(it, rule.keyword, rule.definition, group.type);
            }
        }
    });
}
function checkStrictTypes(it, types) {
    if (it.schemaEnv.meta || !it.opts.strictTypes)
        return;
    checkContextTypes(it, types);
    if (!it.opts.allowUnionTypes)
        checkMultipleTypes(it, types);
    checkKeywordTypes(it, it.dataTypes);
}
function checkContextTypes(it, types) {
    if (!types.length)
        return;
    if (!it.dataTypes.length) {
        it.dataTypes = types;
        return;
    }
    types.forEach((t) => {
        if (!includesType(it.dataTypes, t)) {
            strictTypesError(it, `type "${t}" not allowed by context "${it.dataTypes.join(",")}"`);
        }
    });
    narrowSchemaTypes(it, types);
}
function checkMultipleTypes(it, ts) {
    if (ts.length > 1 && !(ts.length === 2 && ts.includes("null"))) {
        strictTypesError(it, "use allowUnionTypes to allow union type keyword");
    }
}
function checkKeywordTypes(it, ts) {
    const rules = it.self.RULES.all;
    for (const keyword in rules) {
        const rule = rules[keyword];
        if (typeof rule == "object" && (0, applicability_1.shouldUseRule)(it.schema, rule)) {
            const { type } = rule.definition;
            if (type.length && !type.some((t) => hasApplicableType(ts, t))) {
                strictTypesError(it, `missing type "${type.join(",")}" for keyword "${keyword}"`);
            }
        }
    }
}
function hasApplicableType(schTs, kwdT) {
    return schTs.includes(kwdT) || (kwdT === "number" && schTs.includes("integer"));
}
function includesType(ts, t) {
    return ts.includes(t) || (t === "integer" && ts.includes("number"));
}
function narrowSchemaTypes(it, withTypes) {
    const ts = [];
    for (const t of it.dataTypes) {
        if (includesType(withTypes, t))
            ts.push(t);
        else if (withTypes.includes("integer") && t === "number")
            ts.push("integer");
    }
    it.dataTypes = ts;
}
function strictTypesError(it, msg) {
    const schemaPath = it.schemaEnv.baseId + it.errSchemaPath;
    msg += ` at "${schemaPath}" (strictTypes)`;
    (0, util_1.checkStrictMode)(it, msg, it.opts.strictTypes);
}
class KeywordCxt {
    constructor(it, def, keyword) {
        (0, keyword_1.validateKeywordUsage)(it, def, keyword);
        this.gen = it.gen;
        this.allErrors = it.allErrors;
        this.keyword = keyword;
        this.data = it.data;
        this.schema = it.schema[keyword];
        this.$data = def.$data && it.opts.$data && this.schema && this.schema.$data;
        this.schemaValue = (0, util_1.schemaRefOrVal)(it, this.schema, keyword, this.$data);
        this.schemaType = def.schemaType;
        this.parentSchema = it.schema;
        this.params = {};
        this.it = it;
        this.def = def;
        if (this.$data) {
            this.schemaCode = it.gen.const("vSchema", getData(this.$data, it));
        }
        else {
            this.schemaCode = this.schemaValue;
            if (!(0, keyword_1.validSchemaType)(this.schema, def.schemaType, def.allowUndefined)) {
                throw new Error(`${keyword} value must be ${JSON.stringify(def.schemaType)}`);
            }
        }
        if ("code" in def ? def.trackErrors : def.errors !== false) {
            this.errsCount = it.gen.const("_errs", names_1.default.errors);
        }
    }
    result(condition, successAction, failAction) {
        this.failResult((0, codegen_1.not)(condition), successAction, failAction);
    }
    failResult(condition, successAction, failAction) {
        this.gen.if(condition);
        if (failAction)
            failAction();
        else
            this.error();
        if (successAction) {
            this.gen.else();
            successAction();
            if (this.allErrors)
                this.gen.endIf();
        }
        else {
            if (this.allErrors)
                this.gen.endIf();
            else
                this.gen.else();
        }
    }
    pass(condition, failAction) {
        this.failResult((0, codegen_1.not)(condition), undefined, failAction);
    }
    fail(condition) {
        if (condition === undefined) {
            this.error();
            if (!this.allErrors)
                this.gen.if(false); // this branch will be removed by gen.optimize
            return;
        }
        this.gen.if(condition);
        this.error();
        if (this.allErrors)
            this.gen.endIf();
        else
            this.gen.else();
    }
    fail$data(condition) {
        if (!this.$data)
            return this.fail(condition);
        const { schemaCode } = this;
        this.fail((0, codegen_1._) `${schemaCode} !== undefined && (${(0, codegen_1.or)(this.invalid$data(), condition)})`);
    }
    error(append, errorParams, errorPaths) {
        if (errorParams) {
            this.setParams(errorParams);
            this._error(append, errorPaths);
            this.setParams({});
            return;
        }
        this._error(append, errorPaths);
    }
    _error(append, errorPaths) {
        ;
        (append ? errors_1.reportExtraError : errors_1.reportError)(this, this.def.error, errorPaths);
    }
    $dataError() {
        (0, errors_1.reportError)(this, this.def.$dataError || errors_1.keyword$DataError);
    }
    reset() {
        if (this.errsCount === undefined)
            throw new Error('add "trackErrors" to keyword definition');
        (0, errors_1.resetErrorsCount)(this.gen, this.errsCount);
    }
    ok(cond) {
        if (!this.allErrors)
            this.gen.if(cond);
    }
    setParams(obj, assign) {
        if (assign)
            Object.assign(this.params, obj);
        else
            this.params = obj;
    }
    block$data(valid, codeBlock, $dataValid = codegen_1.nil) {
        this.gen.block(() => {
            this.check$data(valid, $dataValid);
            codeBlock();
        });
    }
    check$data(valid = codegen_1.nil, $dataValid = codegen_1.nil) {
        if (!this.$data)
            return;
        const { gen, schemaCode, schemaType, def } = this;
        gen.if((0, codegen_1.or)((0, codegen_1._) `${schemaCode} === undefined`, $dataValid));
        if (valid !== codegen_1.nil)
            gen.assign(valid, true);
        if (schemaType.length || def.validateSchema) {
            gen.elseIf(this.invalid$data());
            this.$dataError();
            if (valid !== codegen_1.nil)
                gen.assign(valid, false);
        }
        gen.else();
    }
    invalid$data() {
        const { gen, schemaCode, schemaType, def, it } = this;
        return (0, codegen_1.or)(wrong$DataType(), invalid$DataSchema());
        function wrong$DataType() {
            if (schemaType.length) {
                /* istanbul ignore if */
                if (!(schemaCode instanceof codegen_1.Name))
                    throw new Error("ajv implementation error");
                const st = Array.isArray(schemaType) ? schemaType : [schemaType];
                return (0, codegen_1._) `${(0, dataType_2.checkDataTypes)(st, schemaCode, it.opts.strictNumbers, dataType_2.DataType.Wrong)}`;
            }
            return codegen_1.nil;
        }
        function invalid$DataSchema() {
            if (def.validateSchema) {
                const validateSchemaRef = gen.scopeValue("validate$data", { ref: def.validateSchema }); // TODO value.code for standalone
                return (0, codegen_1._) `!${validateSchemaRef}(${schemaCode})`;
            }
            return codegen_1.nil;
        }
    }
    subschema(appl, valid) {
        const subschema = (0, subschema_1.getSubschema)(this.it, appl);
        (0, subschema_1.extendSubschemaData)(subschema, this.it, appl);
        (0, subschema_1.extendSubschemaMode)(subschema, appl);
        const nextContext = { ...this.it, ...subschema, items: undefined, props: undefined };
        subschemaCode(nextContext, valid);
        return nextContext;
    }
    mergeEvaluated(schemaCxt, toName) {
        const { it, gen } = this;
        if (!it.opts.unevaluated)
            return;
        if (it.props !== true && schemaCxt.props !== undefined) {
            it.props = util_1.mergeEvaluated.props(gen, schemaCxt.props, it.props, toName);
        }
        if (it.items !== true && schemaCxt.items !== undefined) {
            it.items = util_1.mergeEvaluated.items(gen, schemaCxt.items, it.items, toName);
        }
    }
    mergeValidEvaluated(schemaCxt, valid) {
        const { it, gen } = this;
        if (it.opts.unevaluated && (it.props !== true || it.items !== true)) {
            gen.if(valid, () => this.mergeEvaluated(schemaCxt, codegen_1.Name));
            return true;
        }
    }
}
exports.KeywordCxt = KeywordCxt;
function keywordCode(it, keyword, def, ruleType) {
    const cxt = new KeywordCxt(it, def, keyword);
    if ("code" in def) {
        def.code(cxt, ruleType);
    }
    else if (cxt.$data && def.validate) {
        (0, keyword_1.funcKeywordCode)(cxt, def);
    }
    else if ("macro" in def) {
        (0, keyword_1.macroKeywordCode)(cxt, def);
    }
    else if (def.compile || def.validate) {
        (0, keyword_1.funcKeywordCode)(cxt, def);
    }
}
const JSON_POINTER = /^\/(?:[^~]|~0|~1)*$/;
const RELATIVE_JSON_POINTER = /^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;
function getData($data, { dataLevel, dataNames, dataPathArr }) {
    let jsonPointer;
    let data;
    if ($data === "")
        return names_1.default.rootData;
    if ($data[0] === "/") {
        if (!JSON_POINTER.test($data))
            throw new Error(`Invalid JSON-pointer: ${$data}`);
        jsonPointer = $data;
        data = names_1.default.rootData;
    }
    else {
        const matches = RELATIVE_JSON_POINTER.exec($data);
        if (!matches)
            throw new Error(`Invalid JSON-pointer: ${$data}`);
        const up = +matches[1];
        jsonPointer = matches[2];
        if (jsonPointer === "#") {
            if (up >= dataLevel)
                throw new Error(errorMsg("property/index", up));
            return dataPathArr[dataLevel - up];
        }
        if (up > dataLevel)
            throw new Error(errorMsg("data", up));
        data = dataNames[dataLevel - up];
        if (!jsonPointer)
            return data;
    }
    let expr = data;
    const segments = jsonPointer.split("/");
    for (const segment of segments) {
        if (segment) {
            data = (0, codegen_1._) `${data}${(0, codegen_1.getProperty)((0, util_1.unescapeJsonPointer)(segment))}`;
            expr = (0, codegen_1._) `${expr} && ${data}`;
        }
    }
    return expr;
    function errorMsg(pointerType, up) {
        return `Cannot access ${pointerType} ${up} levels up, current level is ${dataLevel}`;
    }
}
exports.getData = getData;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/keyword.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/keyword.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.validateKeywordUsage = exports.validSchemaType = exports.funcKeywordCode = exports.macroKeywordCode = void 0;
const codegen_1 = __webpack_require__(/*! ../codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const names_1 = __webpack_require__(/*! ../names */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/names.js");
const code_1 = __webpack_require__(/*! ../../vocabularies/code */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/code.js");
const errors_1 = __webpack_require__(/*! ../errors */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/errors.js");
function macroKeywordCode(cxt, def) {
    const { gen, keyword, schema, parentSchema, it } = cxt;
    const macroSchema = def.macro.call(it.self, schema, parentSchema, it);
    const schemaRef = useKeyword(gen, keyword, macroSchema);
    if (it.opts.validateSchema !== false)
        it.self.validateSchema(macroSchema, true);
    const valid = gen.name("valid");
    cxt.subschema({
        schema: macroSchema,
        schemaPath: codegen_1.nil,
        errSchemaPath: `${it.errSchemaPath}/${keyword}`,
        topSchemaRef: schemaRef,
        compositeRule: true,
    }, valid);
    cxt.pass(valid, () => cxt.error(true));
}
exports.macroKeywordCode = macroKeywordCode;
function funcKeywordCode(cxt, def) {
    var _a;
    const { gen, keyword, schema, parentSchema, $data, it } = cxt;
    checkAsyncKeyword(it, def);
    const validate = !$data && def.compile ? def.compile.call(it.self, schema, parentSchema, it) : def.validate;
    const validateRef = useKeyword(gen, keyword, validate);
    const valid = gen.let("valid");
    cxt.block$data(valid, validateKeyword);
    cxt.ok((_a = def.valid) !== null && _a !== void 0 ? _a : valid);
    function validateKeyword() {
        if (def.errors === false) {
            assignValid();
            if (def.modifying)
                modifyData(cxt);
            reportErrs(() => cxt.error());
        }
        else {
            const ruleErrs = def.async ? validateAsync() : validateSync();
            if (def.modifying)
                modifyData(cxt);
            reportErrs(() => addErrs(cxt, ruleErrs));
        }
    }
    function validateAsync() {
        const ruleErrs = gen.let("ruleErrs", null);
        gen.try(() => assignValid((0, codegen_1._) `await `), (e) => gen.assign(valid, false).if((0, codegen_1._) `${e} instanceof ${it.ValidationError}`, () => gen.assign(ruleErrs, (0, codegen_1._) `${e}.errors`), () => gen.throw(e)));
        return ruleErrs;
    }
    function validateSync() {
        const validateErrs = (0, codegen_1._) `${validateRef}.errors`;
        gen.assign(validateErrs, null);
        assignValid(codegen_1.nil);
        return validateErrs;
    }
    function assignValid(_await = def.async ? (0, codegen_1._) `await ` : codegen_1.nil) {
        const passCxt = it.opts.passContext ? names_1.default.this : names_1.default.self;
        const passSchema = !(("compile" in def && !$data) || def.schema === false);
        gen.assign(valid, (0, codegen_1._) `${_await}${(0, code_1.callValidateCode)(cxt, validateRef, passCxt, passSchema)}`, def.modifying);
    }
    function reportErrs(errors) {
        var _a;
        gen.if((0, codegen_1.not)((_a = def.valid) !== null && _a !== void 0 ? _a : valid), errors);
    }
}
exports.funcKeywordCode = funcKeywordCode;
function modifyData(cxt) {
    const { gen, data, it } = cxt;
    gen.if(it.parentData, () => gen.assign(data, (0, codegen_1._) `${it.parentData}[${it.parentDataProperty}]`));
}
function addErrs(cxt, errs) {
    const { gen } = cxt;
    gen.if((0, codegen_1._) `Array.isArray(${errs})`, () => {
        gen
            .assign(names_1.default.vErrors, (0, codegen_1._) `${names_1.default.vErrors} === null ? ${errs} : ${names_1.default.vErrors}.concat(${errs})`)
            .assign(names_1.default.errors, (0, codegen_1._) `${names_1.default.vErrors}.length`);
        (0, errors_1.extendErrors)(cxt);
    }, () => cxt.error());
}
function checkAsyncKeyword({ schemaEnv }, def) {
    if (def.async && !schemaEnv.$async)
        throw new Error("async keyword in sync schema");
}
function useKeyword(gen, keyword, result) {
    if (result === undefined)
        throw new Error(`keyword "${keyword}" failed to compile`);
    return gen.scopeValue("keyword", typeof result == "function" ? { ref: result } : { ref: result, code: (0, codegen_1.stringify)(result) });
}
function validSchemaType(schema, schemaType, allowUndefined = false) {
    // TODO add tests
    return (!schemaType.length ||
        schemaType.some((st) => st === "array"
            ? Array.isArray(schema)
            : st === "object"
                ? schema && typeof schema == "object" && !Array.isArray(schema)
                : typeof schema == st || (allowUndefined && typeof schema == "undefined")));
}
exports.validSchemaType = validSchemaType;
function validateKeywordUsage({ schema, opts, self, errSchemaPath }, def, keyword) {
    /* istanbul ignore if */
    if (Array.isArray(def.keyword) ? !def.keyword.includes(keyword) : def.keyword !== keyword) {
        throw new Error("ajv implementation error");
    }
    const deps = def.dependencies;
    if (deps === null || deps === void 0 ? void 0 : deps.some((kwd) => !Object.prototype.hasOwnProperty.call(schema, kwd))) {
        throw new Error(`parent schema must have dependencies of ${keyword}: ${deps.join(",")}`);
    }
    if (def.validateSchema) {
        const valid = def.validateSchema(schema[keyword]);
        if (!valid) {
            const msg = `keyword "${keyword}" value is invalid at path "${errSchemaPath}": ` +
                self.errorsText(def.validateSchema.errors);
            if (opts.validateSchema === "log")
                self.logger.error(msg);
            else
                throw new Error(msg);
        }
    }
}
exports.validateKeywordUsage = validateKeywordUsage;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/subschema.js":
/*!***************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/subschema.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.extendSubschemaMode = exports.extendSubschemaData = exports.getSubschema = void 0;
const codegen_1 = __webpack_require__(/*! ../codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const util_1 = __webpack_require__(/*! ../util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
function getSubschema(it, { keyword, schemaProp, schema, schemaPath, errSchemaPath, topSchemaRef }) {
    if (keyword !== undefined && schema !== undefined) {
        throw new Error('both "keyword" and "schema" passed, only one allowed');
    }
    if (keyword !== undefined) {
        const sch = it.schema[keyword];
        return schemaProp === undefined
            ? {
                schema: sch,
                schemaPath: (0, codegen_1._) `${it.schemaPath}${(0, codegen_1.getProperty)(keyword)}`,
                errSchemaPath: `${it.errSchemaPath}/${keyword}`,
            }
            : {
                schema: sch[schemaProp],
                schemaPath: (0, codegen_1._) `${it.schemaPath}${(0, codegen_1.getProperty)(keyword)}${(0, codegen_1.getProperty)(schemaProp)}`,
                errSchemaPath: `${it.errSchemaPath}/${keyword}/${(0, util_1.escapeFragment)(schemaProp)}`,
            };
    }
    if (schema !== undefined) {
        if (schemaPath === undefined || errSchemaPath === undefined || topSchemaRef === undefined) {
            throw new Error('"schemaPath", "errSchemaPath" and "topSchemaRef" are required with "schema"');
        }
        return {
            schema,
            schemaPath,
            topSchemaRef,
            errSchemaPath,
        };
    }
    throw new Error('either "keyword" or "schema" must be passed');
}
exports.getSubschema = getSubschema;
function extendSubschemaData(subschema, it, { dataProp, dataPropType: dpType, data, dataTypes, propertyName }) {
    if (data !== undefined && dataProp !== undefined) {
        throw new Error('both "data" and "dataProp" passed, only one allowed');
    }
    const { gen } = it;
    if (dataProp !== undefined) {
        const { errorPath, dataPathArr, opts } = it;
        const nextData = gen.let("data", (0, codegen_1._) `${it.data}${(0, codegen_1.getProperty)(dataProp)}`, true);
        dataContextProps(nextData);
        subschema.errorPath = (0, codegen_1.str) `${errorPath}${(0, util_1.getErrorPath)(dataProp, dpType, opts.jsPropertySyntax)}`;
        subschema.parentDataProperty = (0, codegen_1._) `${dataProp}`;
        subschema.dataPathArr = [...dataPathArr, subschema.parentDataProperty];
    }
    if (data !== undefined) {
        const nextData = data instanceof codegen_1.Name ? data : gen.let("data", data, true); // replaceable if used once?
        dataContextProps(nextData);
        if (propertyName !== undefined)
            subschema.propertyName = propertyName;
        // TODO something is possibly wrong here with not changing parentDataProperty and not appending dataPathArr
    }
    if (dataTypes)
        subschema.dataTypes = dataTypes;
    function dataContextProps(_nextData) {
        subschema.data = _nextData;
        subschema.dataLevel = it.dataLevel + 1;
        subschema.dataTypes = [];
        it.definedProperties = new Set();
        subschema.parentData = it.data;
        subschema.dataNames = [...it.dataNames, _nextData];
    }
}
exports.extendSubschemaData = extendSubschemaData;
function extendSubschemaMode(subschema, { jtdDiscriminator, jtdMetadata, compositeRule, createErrors, allErrors }) {
    if (compositeRule !== undefined)
        subschema.compositeRule = compositeRule;
    if (createErrors !== undefined)
        subschema.createErrors = createErrors;
    if (allErrors !== undefined)
        subschema.allErrors = allErrors;
    subschema.jtdDiscriminator = jtdDiscriminator; // not inherited
    subschema.jtdMetadata = jtdMetadata; // not inherited
}
exports.extendSubschemaMode = extendSubschemaMode;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/core.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/core.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CodeGen = exports.Name = exports.nil = exports.stringify = exports.str = exports._ = exports.KeywordCxt = void 0;
var validate_1 = __webpack_require__(/*! ./compile/validate */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/index.js");
Object.defineProperty(exports, "KeywordCxt", ({ enumerable: true, get: function () { return validate_1.KeywordCxt; } }));
var codegen_1 = __webpack_require__(/*! ./compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
Object.defineProperty(exports, "_", ({ enumerable: true, get: function () { return codegen_1._; } }));
Object.defineProperty(exports, "str", ({ enumerable: true, get: function () { return codegen_1.str; } }));
Object.defineProperty(exports, "stringify", ({ enumerable: true, get: function () { return codegen_1.stringify; } }));
Object.defineProperty(exports, "nil", ({ enumerable: true, get: function () { return codegen_1.nil; } }));
Object.defineProperty(exports, "Name", ({ enumerable: true, get: function () { return codegen_1.Name; } }));
Object.defineProperty(exports, "CodeGen", ({ enumerable: true, get: function () { return codegen_1.CodeGen; } }));
const validation_error_1 = __webpack_require__(/*! ./runtime/validation_error */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/runtime/validation_error.js");
const ref_error_1 = __webpack_require__(/*! ./compile/ref_error */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/ref_error.js");
const rules_1 = __webpack_require__(/*! ./compile/rules */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/rules.js");
const compile_1 = __webpack_require__(/*! ./compile */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/index.js");
const codegen_2 = __webpack_require__(/*! ./compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const resolve_1 = __webpack_require__(/*! ./compile/resolve */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/resolve.js");
const dataType_1 = __webpack_require__(/*! ./compile/validate/dataType */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/dataType.js");
const util_1 = __webpack_require__(/*! ./compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const $dataRefSchema = __webpack_require__(/*! ./refs/data.json */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/refs/data.json");
const uri_1 = __webpack_require__(/*! ./runtime/uri */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/runtime/uri.js");
const defaultRegExp = (str, flags) => new RegExp(str, flags);
defaultRegExp.code = "new RegExp";
const META_IGNORE_OPTIONS = ["removeAdditional", "useDefaults", "coerceTypes"];
const EXT_SCOPE_NAMES = new Set([
    "validate",
    "serialize",
    "parse",
    "wrapper",
    "root",
    "schema",
    "keyword",
    "pattern",
    "formats",
    "validate$data",
    "func",
    "obj",
    "Error",
]);
const removedOptions = {
    errorDataPath: "",
    format: "`validateFormats: false` can be used instead.",
    nullable: '"nullable" keyword is supported by default.',
    jsonPointers: "Deprecated jsPropertySyntax can be used instead.",
    extendRefs: "Deprecated ignoreKeywordsWithRef can be used instead.",
    missingRefs: "Pass empty schema with $id that should be ignored to ajv.addSchema.",
    processCode: "Use option `code: {process: (code, schemaEnv: object) => string}`",
    sourceCode: "Use option `code: {source: true}`",
    strictDefaults: "It is default now, see option `strict`.",
    strictKeywords: "It is default now, see option `strict`.",
    uniqueItems: '"uniqueItems" keyword is always validated.',
    unknownFormats: "Disable strict mode or pass `true` to `ajv.addFormat` (or `formats` option).",
    cache: "Map is used as cache, schema object as key.",
    serialize: "Map is used as cache, schema object as key.",
    ajvErrors: "It is default now.",
};
const deprecatedOptions = {
    ignoreKeywordsWithRef: "",
    jsPropertySyntax: "",
    unicode: '"minLength"/"maxLength" account for unicode characters by default.',
};
const MAX_EXPRESSION = 200;
// eslint-disable-next-line complexity
function requiredOptions(o) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z, _0;
    const s = o.strict;
    const _optz = (_a = o.code) === null || _a === void 0 ? void 0 : _a.optimize;
    const optimize = _optz === true || _optz === undefined ? 1 : _optz || 0;
    const regExp = (_c = (_b = o.code) === null || _b === void 0 ? void 0 : _b.regExp) !== null && _c !== void 0 ? _c : defaultRegExp;
    const uriResolver = (_d = o.uriResolver) !== null && _d !== void 0 ? _d : uri_1.default;
    return {
        strictSchema: (_f = (_e = o.strictSchema) !== null && _e !== void 0 ? _e : s) !== null && _f !== void 0 ? _f : true,
        strictNumbers: (_h = (_g = o.strictNumbers) !== null && _g !== void 0 ? _g : s) !== null && _h !== void 0 ? _h : true,
        strictTypes: (_k = (_j = o.strictTypes) !== null && _j !== void 0 ? _j : s) !== null && _k !== void 0 ? _k : "log",
        strictTuples: (_m = (_l = o.strictTuples) !== null && _l !== void 0 ? _l : s) !== null && _m !== void 0 ? _m : "log",
        strictRequired: (_p = (_o = o.strictRequired) !== null && _o !== void 0 ? _o : s) !== null && _p !== void 0 ? _p : false,
        code: o.code ? { ...o.code, optimize, regExp } : { optimize, regExp },
        loopRequired: (_q = o.loopRequired) !== null && _q !== void 0 ? _q : MAX_EXPRESSION,
        loopEnum: (_r = o.loopEnum) !== null && _r !== void 0 ? _r : MAX_EXPRESSION,
        meta: (_s = o.meta) !== null && _s !== void 0 ? _s : true,
        messages: (_t = o.messages) !== null && _t !== void 0 ? _t : true,
        inlineRefs: (_u = o.inlineRefs) !== null && _u !== void 0 ? _u : true,
        schemaId: (_v = o.schemaId) !== null && _v !== void 0 ? _v : "$id",
        addUsedSchema: (_w = o.addUsedSchema) !== null && _w !== void 0 ? _w : true,
        validateSchema: (_x = o.validateSchema) !== null && _x !== void 0 ? _x : true,
        validateFormats: (_y = o.validateFormats) !== null && _y !== void 0 ? _y : true,
        unicodeRegExp: (_z = o.unicodeRegExp) !== null && _z !== void 0 ? _z : true,
        int32range: (_0 = o.int32range) !== null && _0 !== void 0 ? _0 : true,
        uriResolver: uriResolver,
    };
}
class Ajv {
    constructor(opts = {}) {
        this.schemas = {};
        this.refs = {};
        this.formats = {};
        this._compilations = new Set();
        this._loading = {};
        this._cache = new Map();
        opts = this.opts = { ...opts, ...requiredOptions(opts) };
        const { es5, lines } = this.opts.code;
        this.scope = new codegen_2.ValueScope({ scope: {}, prefixes: EXT_SCOPE_NAMES, es5, lines });
        this.logger = getLogger(opts.logger);
        const formatOpt = opts.validateFormats;
        opts.validateFormats = false;
        this.RULES = (0, rules_1.getRules)();
        checkOptions.call(this, removedOptions, opts, "NOT SUPPORTED");
        checkOptions.call(this, deprecatedOptions, opts, "DEPRECATED", "warn");
        this._metaOpts = getMetaSchemaOptions.call(this);
        if (opts.formats)
            addInitialFormats.call(this);
        this._addVocabularies();
        this._addDefaultMetaSchema();
        if (opts.keywords)
            addInitialKeywords.call(this, opts.keywords);
        if (typeof opts.meta == "object")
            this.addMetaSchema(opts.meta);
        addInitialSchemas.call(this);
        opts.validateFormats = formatOpt;
    }
    _addVocabularies() {
        this.addKeyword("$async");
    }
    _addDefaultMetaSchema() {
        const { $data, meta, schemaId } = this.opts;
        let _dataRefSchema = $dataRefSchema;
        if (schemaId === "id") {
            _dataRefSchema = { ...$dataRefSchema };
            _dataRefSchema.id = _dataRefSchema.$id;
            delete _dataRefSchema.$id;
        }
        if (meta && $data)
            this.addMetaSchema(_dataRefSchema, _dataRefSchema[schemaId], false);
    }
    defaultMeta() {
        const { meta, schemaId } = this.opts;
        return (this.opts.defaultMeta = typeof meta == "object" ? meta[schemaId] || meta : undefined);
    }
    validate(schemaKeyRef, // key, ref or schema object
    // eslint-disable-next-line @typescript-eslint/no-redundant-type-constituents
    data // to be validated
    ) {
        let v;
        if (typeof schemaKeyRef == "string") {
            v = this.getSchema(schemaKeyRef);
            if (!v)
                throw new Error(`no schema with key or ref "${schemaKeyRef}"`);
        }
        else {
            v = this.compile(schemaKeyRef);
        }
        const valid = v(data);
        if (!("$async" in v))
            this.errors = v.errors;
        return valid;
    }
    compile(schema, _meta) {
        const sch = this._addSchema(schema, _meta);
        return (sch.validate || this._compileSchemaEnv(sch));
    }
    compileAsync(schema, meta) {
        if (typeof this.opts.loadSchema != "function") {
            throw new Error("options.loadSchema should be a function");
        }
        const { loadSchema } = this.opts;
        return runCompileAsync.call(this, schema, meta);
        async function runCompileAsync(_schema, _meta) {
            await loadMetaSchema.call(this, _schema.$schema);
            const sch = this._addSchema(_schema, _meta);
            return sch.validate || _compileAsync.call(this, sch);
        }
        async function loadMetaSchema($ref) {
            if ($ref && !this.getSchema($ref)) {
                await runCompileAsync.call(this, { $ref }, true);
            }
        }
        async function _compileAsync(sch) {
            try {
                return this._compileSchemaEnv(sch);
            }
            catch (e) {
                if (!(e instanceof ref_error_1.default))
                    throw e;
                checkLoaded.call(this, e);
                await loadMissingSchema.call(this, e.missingSchema);
                return _compileAsync.call(this, sch);
            }
        }
        function checkLoaded({ missingSchema: ref, missingRef }) {
            if (this.refs[ref]) {
                throw new Error(`AnySchema ${ref} is loaded but ${missingRef} cannot be resolved`);
            }
        }
        async function loadMissingSchema(ref) {
            const _schema = await _loadSchema.call(this, ref);
            if (!this.refs[ref])
                await loadMetaSchema.call(this, _schema.$schema);
            if (!this.refs[ref])
                this.addSchema(_schema, ref, meta);
        }
        async function _loadSchema(ref) {
            const p = this._loading[ref];
            if (p)
                return p;
            try {
                return await (this._loading[ref] = loadSchema(ref));
            }
            finally {
                delete this._loading[ref];
            }
        }
    }
    // Adds schema to the instance
    addSchema(schema, // If array is passed, `key` will be ignored
    key, // Optional schema key. Can be passed to `validate` method instead of schema object or id/ref. One schema per instance can have empty `id` and `key`.
    _meta, // true if schema is a meta-schema. Used internally, addMetaSchema should be used instead.
    _validateSchema = this.opts.validateSchema // false to skip schema validation. Used internally, option validateSchema should be used instead.
    ) {
        if (Array.isArray(schema)) {
            for (const sch of schema)
                this.addSchema(sch, undefined, _meta, _validateSchema);
            return this;
        }
        let id;
        if (typeof schema === "object") {
            const { schemaId } = this.opts;
            id = schema[schemaId];
            if (id !== undefined && typeof id != "string") {
                throw new Error(`schema ${schemaId} must be string`);
            }
        }
        key = (0, resolve_1.normalizeId)(key || id);
        this._checkUnique(key);
        this.schemas[key] = this._addSchema(schema, _meta, key, _validateSchema, true);
        return this;
    }
    // Add schema that will be used to validate other schemas
    // options in META_IGNORE_OPTIONS are alway set to false
    addMetaSchema(schema, key, // schema key
    _validateSchema = this.opts.validateSchema // false to skip schema validation, can be used to override validateSchema option for meta-schema
    ) {
        this.addSchema(schema, key, true, _validateSchema);
        return this;
    }
    //  Validate schema against its meta-schema
    validateSchema(schema, throwOrLogError) {
        if (typeof schema == "boolean")
            return true;
        let $schema;
        $schema = schema.$schema;
        if ($schema !== undefined && typeof $schema != "string") {
            throw new Error("$schema must be a string");
        }
        $schema = $schema || this.opts.defaultMeta || this.defaultMeta();
        if (!$schema) {
            this.logger.warn("meta-schema not available");
            this.errors = null;
            return true;
        }
        const valid = this.validate($schema, schema);
        if (!valid && throwOrLogError) {
            const message = "schema is invalid: " + this.errorsText();
            if (this.opts.validateSchema === "log")
                this.logger.error(message);
            else
                throw new Error(message);
        }
        return valid;
    }
    // Get compiled schema by `key` or `ref`.
    // (`key` that was passed to `addSchema` or full schema reference - `schema.$id` or resolved id)
    getSchema(keyRef) {
        let sch;
        while (typeof (sch = getSchEnv.call(this, keyRef)) == "string")
            keyRef = sch;
        if (sch === undefined) {
            const { schemaId } = this.opts;
            const root = new compile_1.SchemaEnv({ schema: {}, schemaId });
            sch = compile_1.resolveSchema.call(this, root, keyRef);
            if (!sch)
                return;
            this.refs[keyRef] = sch;
        }
        return (sch.validate || this._compileSchemaEnv(sch));
    }
    // Remove cached schema(s).
    // If no parameter is passed all schemas but meta-schemas are removed.
    // If RegExp is passed all schemas with key/id matching pattern but meta-schemas are removed.
    // Even if schema is referenced by other schemas it still can be removed as other schemas have local references.
    removeSchema(schemaKeyRef) {
        if (schemaKeyRef instanceof RegExp) {
            this._removeAllSchemas(this.schemas, schemaKeyRef);
            this._removeAllSchemas(this.refs, schemaKeyRef);
            return this;
        }
        switch (typeof schemaKeyRef) {
            case "undefined":
                this._removeAllSchemas(this.schemas);
                this._removeAllSchemas(this.refs);
                this._cache.clear();
                return this;
            case "string": {
                const sch = getSchEnv.call(this, schemaKeyRef);
                if (typeof sch == "object")
                    this._cache.delete(sch.schema);
                delete this.schemas[schemaKeyRef];
                delete this.refs[schemaKeyRef];
                return this;
            }
            case "object": {
                const cacheKey = schemaKeyRef;
                this._cache.delete(cacheKey);
                let id = schemaKeyRef[this.opts.schemaId];
                if (id) {
                    id = (0, resolve_1.normalizeId)(id);
                    delete this.schemas[id];
                    delete this.refs[id];
                }
                return this;
            }
            default:
                throw new Error("ajv.removeSchema: invalid parameter");
        }
    }
    // add "vocabulary" - a collection of keywords
    addVocabulary(definitions) {
        for (const def of definitions)
            this.addKeyword(def);
        return this;
    }
    addKeyword(kwdOrDef, def // deprecated
    ) {
        let keyword;
        if (typeof kwdOrDef == "string") {
            keyword = kwdOrDef;
            if (typeof def == "object") {
                this.logger.warn("these parameters are deprecated, see docs for addKeyword");
                def.keyword = keyword;
            }
        }
        else if (typeof kwdOrDef == "object" && def === undefined) {
            def = kwdOrDef;
            keyword = def.keyword;
            if (Array.isArray(keyword) && !keyword.length) {
                throw new Error("addKeywords: keyword must be string or non-empty array");
            }
        }
        else {
            throw new Error("invalid addKeywords parameters");
        }
        checkKeyword.call(this, keyword, def);
        if (!def) {
            (0, util_1.eachItem)(keyword, (kwd) => addRule.call(this, kwd));
            return this;
        }
        keywordMetaschema.call(this, def);
        const definition = {
            ...def,
            type: (0, dataType_1.getJSONTypes)(def.type),
            schemaType: (0, dataType_1.getJSONTypes)(def.schemaType),
        };
        (0, util_1.eachItem)(keyword, definition.type.length === 0
            ? (k) => addRule.call(this, k, definition)
            : (k) => definition.type.forEach((t) => addRule.call(this, k, definition, t)));
        return this;
    }
    getKeyword(keyword) {
        const rule = this.RULES.all[keyword];
        return typeof rule == "object" ? rule.definition : !!rule;
    }
    // Remove keyword
    removeKeyword(keyword) {
        // TODO return type should be Ajv
        const { RULES } = this;
        delete RULES.keywords[keyword];
        delete RULES.all[keyword];
        for (const group of RULES.rules) {
            const i = group.rules.findIndex((rule) => rule.keyword === keyword);
            if (i >= 0)
                group.rules.splice(i, 1);
        }
        return this;
    }
    // Add format
    addFormat(name, format) {
        if (typeof format == "string")
            format = new RegExp(format);
        this.formats[name] = format;
        return this;
    }
    errorsText(errors = this.errors, // optional array of validation errors
    { separator = ", ", dataVar = "data" } = {} // optional options with properties `separator` and `dataVar`
    ) {
        if (!errors || errors.length === 0)
            return "No errors";
        return errors
            .map((e) => `${dataVar}${e.instancePath} ${e.message}`)
            .reduce((text, msg) => text + separator + msg);
    }
    $dataMetaSchema(metaSchema, keywordsJsonPointers) {
        const rules = this.RULES.all;
        metaSchema = JSON.parse(JSON.stringify(metaSchema));
        for (const jsonPointer of keywordsJsonPointers) {
            const segments = jsonPointer.split("/").slice(1); // first segment is an empty string
            let keywords = metaSchema;
            for (const seg of segments)
                keywords = keywords[seg];
            for (const key in rules) {
                const rule = rules[key];
                if (typeof rule != "object")
                    continue;
                const { $data } = rule.definition;
                const schema = keywords[key];
                if ($data && schema)
                    keywords[key] = schemaOrData(schema);
            }
        }
        return metaSchema;
    }
    _removeAllSchemas(schemas, regex) {
        for (const keyRef in schemas) {
            const sch = schemas[keyRef];
            if (!regex || regex.test(keyRef)) {
                if (typeof sch == "string") {
                    delete schemas[keyRef];
                }
                else if (sch && !sch.meta) {
                    this._cache.delete(sch.schema);
                    delete schemas[keyRef];
                }
            }
        }
    }
    _addSchema(schema, meta, baseId, validateSchema = this.opts.validateSchema, addSchema = this.opts.addUsedSchema) {
        let id;
        const { schemaId } = this.opts;
        if (typeof schema == "object") {
            id = schema[schemaId];
        }
        else {
            if (this.opts.jtd)
                throw new Error("schema must be object");
            else if (typeof schema != "boolean")
                throw new Error("schema must be object or boolean");
        }
        let sch = this._cache.get(schema);
        if (sch !== undefined)
            return sch;
        baseId = (0, resolve_1.normalizeId)(id || baseId);
        const localRefs = resolve_1.getSchemaRefs.call(this, schema, baseId);
        sch = new compile_1.SchemaEnv({ schema, schemaId, meta, baseId, localRefs });
        this._cache.set(sch.schema, sch);
        if (addSchema && !baseId.startsWith("#")) {
            // TODO atm it is allowed to overwrite schemas without id (instead of not adding them)
            if (baseId)
                this._checkUnique(baseId);
            this.refs[baseId] = sch;
        }
        if (validateSchema)
            this.validateSchema(schema, true);
        return sch;
    }
    _checkUnique(id) {
        if (this.schemas[id] || this.refs[id]) {
            throw new Error(`schema with key or id "${id}" already exists`);
        }
    }
    _compileSchemaEnv(sch) {
        if (sch.meta)
            this._compileMetaSchema(sch);
        else
            compile_1.compileSchema.call(this, sch);
        /* istanbul ignore if */
        if (!sch.validate)
            throw new Error("ajv implementation error");
        return sch.validate;
    }
    _compileMetaSchema(sch) {
        const currentOpts = this.opts;
        this.opts = this._metaOpts;
        try {
            compile_1.compileSchema.call(this, sch);
        }
        finally {
            this.opts = currentOpts;
        }
    }
}
Ajv.ValidationError = validation_error_1.default;
Ajv.MissingRefError = ref_error_1.default;
exports["default"] = Ajv;
function checkOptions(checkOpts, options, msg, log = "error") {
    for (const key in checkOpts) {
        const opt = key;
        if (opt in options)
            this.logger[log](`${msg}: option ${key}. ${checkOpts[opt]}`);
    }
}
function getSchEnv(keyRef) {
    keyRef = (0, resolve_1.normalizeId)(keyRef); // TODO tests fail without this line
    return this.schemas[keyRef] || this.refs[keyRef];
}
function addInitialSchemas() {
    const optsSchemas = this.opts.schemas;
    if (!optsSchemas)
        return;
    if (Array.isArray(optsSchemas))
        this.addSchema(optsSchemas);
    else
        for (const key in optsSchemas)
            this.addSchema(optsSchemas[key], key);
}
function addInitialFormats() {
    for (const name in this.opts.formats) {
        const format = this.opts.formats[name];
        if (format)
            this.addFormat(name, format);
    }
}
function addInitialKeywords(defs) {
    if (Array.isArray(defs)) {
        this.addVocabulary(defs);
        return;
    }
    this.logger.warn("keywords option as map is deprecated, pass array");
    for (const keyword in defs) {
        const def = defs[keyword];
        if (!def.keyword)
            def.keyword = keyword;
        this.addKeyword(def);
    }
}
function getMetaSchemaOptions() {
    const metaOpts = { ...this.opts };
    for (const opt of META_IGNORE_OPTIONS)
        delete metaOpts[opt];
    return metaOpts;
}
const noLogs = { log() { }, warn() { }, error() { } };
function getLogger(logger) {
    if (logger === false)
        return noLogs;
    if (logger === undefined)
        return console;
    if (logger.log && logger.warn && logger.error)
        return logger;
    throw new Error("logger must implement log, warn and error methods");
}
const KEYWORD_NAME = /^[a-z_$][a-z0-9_$:-]*$/i;
function checkKeyword(keyword, def) {
    const { RULES } = this;
    (0, util_1.eachItem)(keyword, (kwd) => {
        if (RULES.keywords[kwd])
            throw new Error(`Keyword ${kwd} is already defined`);
        if (!KEYWORD_NAME.test(kwd))
            throw new Error(`Keyword ${kwd} has invalid name`);
    });
    if (!def)
        return;
    if (def.$data && !("code" in def || "validate" in def)) {
        throw new Error('$data keyword must have "code" or "validate" function');
    }
}
function addRule(keyword, definition, dataType) {
    var _a;
    const post = definition === null || definition === void 0 ? void 0 : definition.post;
    if (dataType && post)
        throw new Error('keyword with "post" flag cannot have "type"');
    const { RULES } = this;
    let ruleGroup = post ? RULES.post : RULES.rules.find(({ type: t }) => t === dataType);
    if (!ruleGroup) {
        ruleGroup = { type: dataType, rules: [] };
        RULES.rules.push(ruleGroup);
    }
    RULES.keywords[keyword] = true;
    if (!definition)
        return;
    const rule = {
        keyword,
        definition: {
            ...definition,
            type: (0, dataType_1.getJSONTypes)(definition.type),
            schemaType: (0, dataType_1.getJSONTypes)(definition.schemaType),
        },
    };
    if (definition.before)
        addBeforeRule.call(this, ruleGroup, rule, definition.before);
    else
        ruleGroup.rules.push(rule);
    RULES.all[keyword] = rule;
    (_a = definition.implements) === null || _a === void 0 ? void 0 : _a.forEach((kwd) => this.addKeyword(kwd));
}
function addBeforeRule(ruleGroup, rule, before) {
    const i = ruleGroup.rules.findIndex((_rule) => _rule.keyword === before);
    if (i >= 0) {
        ruleGroup.rules.splice(i, 0, rule);
    }
    else {
        ruleGroup.rules.push(rule);
        this.logger.warn(`rule ${before} is not defined`);
    }
}
function keywordMetaschema(def) {
    let { metaSchema } = def;
    if (metaSchema === undefined)
        return;
    if (def.$data && this.opts.$data)
        metaSchema = schemaOrData(metaSchema);
    def.validateSchema = this.compile(metaSchema, true);
}
const $dataRef = {
    $ref: "https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#",
};
function schemaOrData(schema) {
    return { anyOf: [schema, $dataRef] };
}


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/runtime/equal.js":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/runtime/equal.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
// https://github.com/ajv-validator/ajv/issues/889
const equal = __webpack_require__(/*! fast-deep-equal */ "../../node_modules/fast-deep-equal/index.js");
equal.code = 'require("ajv/dist/runtime/equal").default';
exports["default"] = equal;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/runtime/ucs2length.js":
/*!*******************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/runtime/ucs2length.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
// https://mathiasbynens.be/notes/javascript-encoding
// https://github.com/bestiejs/punycode.js - punycode.ucs2.decode
function ucs2length(str) {
    const len = str.length;
    let length = 0;
    let pos = 0;
    let value;
    while (pos < len) {
        length++;
        value = str.charCodeAt(pos++);
        if (value >= 0xd800 && value <= 0xdbff && pos < len) {
            // high surrogate, and there is a next character
            value = str.charCodeAt(pos);
            if ((value & 0xfc00) === 0xdc00)
                pos++; // low surrogate
        }
    }
    return length;
}
exports["default"] = ucs2length;
ucs2length.code = 'require("ajv/dist/runtime/ucs2length").default';


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/runtime/uri.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/runtime/uri.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const uri = __webpack_require__(/*! fast-uri */ "../../node_modules/fast-uri/index.js");
uri.code = 'require("ajv/dist/runtime/uri").default';
exports["default"] = uri;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/runtime/validation_error.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/runtime/validation_error.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
class ValidationError extends Error {
    constructor(errors) {
        super("validation failed");
        this.errors = errors;
        this.ajv = this.validation = true;
    }
}
exports["default"] = ValidationError;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/additionalItems.js":
/*!****************************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/additionalItems.js ***!
  \****************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.validateAdditionalItems = void 0;
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const error = {
    message: ({ params: { len } }) => (0, codegen_1.str) `must NOT have more than ${len} items`,
    params: ({ params: { len } }) => (0, codegen_1._) `{limit: ${len}}`,
};
const def = {
    keyword: "additionalItems",
    type: "array",
    schemaType: ["boolean", "object"],
    before: "uniqueItems",
    error,
    code(cxt) {
        const { parentSchema, it } = cxt;
        const { items } = parentSchema;
        if (!Array.isArray(items)) {
            (0, util_1.checkStrictMode)(it, '"additionalItems" is ignored when "items" is not an array of schemas');
            return;
        }
        validateAdditionalItems(cxt, items);
    },
};
function validateAdditionalItems(cxt, items) {
    const { gen, schema, data, keyword, it } = cxt;
    it.items = true;
    const len = gen.const("len", (0, codegen_1._) `${data}.length`);
    if (schema === false) {
        cxt.setParams({ len: items.length });
        cxt.pass((0, codegen_1._) `${len} <= ${items.length}`);
    }
    else if (typeof schema == "object" && !(0, util_1.alwaysValidSchema)(it, schema)) {
        const valid = gen.var("valid", (0, codegen_1._) `${len} <= ${items.length}`); // TODO var
        gen.if((0, codegen_1.not)(valid), () => validateItems(valid));
        cxt.ok(valid);
    }
    function validateItems(valid) {
        gen.forRange("i", items.length, len, (i) => {
            cxt.subschema({ keyword, dataProp: i, dataPropType: util_1.Type.Num }, valid);
            if (!it.allErrors)
                gen.if((0, codegen_1.not)(valid), () => gen.break());
        });
    }
}
exports.validateAdditionalItems = validateAdditionalItems;
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/additionalProperties.js":
/*!*********************************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/additionalProperties.js ***!
  \*********************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const code_1 = __webpack_require__(/*! ../code */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/code.js");
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const names_1 = __webpack_require__(/*! ../../compile/names */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/names.js");
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const error = {
    message: "must NOT have additional properties",
    params: ({ params }) => (0, codegen_1._) `{additionalProperty: ${params.additionalProperty}}`,
};
const def = {
    keyword: "additionalProperties",
    type: ["object"],
    schemaType: ["boolean", "object"],
    allowUndefined: true,
    trackErrors: true,
    error,
    code(cxt) {
        const { gen, schema, parentSchema, data, errsCount, it } = cxt;
        /* istanbul ignore if */
        if (!errsCount)
            throw new Error("ajv implementation error");
        const { allErrors, opts } = it;
        it.props = true;
        if (opts.removeAdditional !== "all" && (0, util_1.alwaysValidSchema)(it, schema))
            return;
        const props = (0, code_1.allSchemaProperties)(parentSchema.properties);
        const patProps = (0, code_1.allSchemaProperties)(parentSchema.patternProperties);
        checkAdditionalProperties();
        cxt.ok((0, codegen_1._) `${errsCount} === ${names_1.default.errors}`);
        function checkAdditionalProperties() {
            gen.forIn("key", data, (key) => {
                if (!props.length && !patProps.length)
                    additionalPropertyCode(key);
                else
                    gen.if(isAdditional(key), () => additionalPropertyCode(key));
            });
        }
        function isAdditional(key) {
            let definedProp;
            if (props.length > 8) {
                // TODO maybe an option instead of hard-coded 8?
                const propsSchema = (0, util_1.schemaRefOrVal)(it, parentSchema.properties, "properties");
                definedProp = (0, code_1.isOwnProperty)(gen, propsSchema, key);
            }
            else if (props.length) {
                definedProp = (0, codegen_1.or)(...props.map((p) => (0, codegen_1._) `${key} === ${p}`));
            }
            else {
                definedProp = codegen_1.nil;
            }
            if (patProps.length) {
                definedProp = (0, codegen_1.or)(definedProp, ...patProps.map((p) => (0, codegen_1._) `${(0, code_1.usePattern)(cxt, p)}.test(${key})`));
            }
            return (0, codegen_1.not)(definedProp);
        }
        function deleteAdditional(key) {
            gen.code((0, codegen_1._) `delete ${data}[${key}]`);
        }
        function additionalPropertyCode(key) {
            if (opts.removeAdditional === "all" || (opts.removeAdditional && schema === false)) {
                deleteAdditional(key);
                return;
            }
            if (schema === false) {
                cxt.setParams({ additionalProperty: key });
                cxt.error();
                if (!allErrors)
                    gen.break();
                return;
            }
            if (typeof schema == "object" && !(0, util_1.alwaysValidSchema)(it, schema)) {
                const valid = gen.name("valid");
                if (opts.removeAdditional === "failing") {
                    applyAdditionalSchema(key, valid, false);
                    gen.if((0, codegen_1.not)(valid), () => {
                        cxt.reset();
                        deleteAdditional(key);
                    });
                }
                else {
                    applyAdditionalSchema(key, valid);
                    if (!allErrors)
                        gen.if((0, codegen_1.not)(valid), () => gen.break());
                }
            }
        }
        function applyAdditionalSchema(key, valid, errors) {
            const subschema = {
                keyword: "additionalProperties",
                dataProp: key,
                dataPropType: util_1.Type.Str,
            };
            if (errors === false) {
                Object.assign(subschema, {
                    compositeRule: true,
                    createErrors: false,
                    allErrors: false,
                });
            }
            cxt.subschema(subschema, valid);
        }
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/allOf.js":
/*!******************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/allOf.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const def = {
    keyword: "allOf",
    schemaType: "array",
    code(cxt) {
        const { gen, schema, it } = cxt;
        /* istanbul ignore if */
        if (!Array.isArray(schema))
            throw new Error("ajv implementation error");
        const valid = gen.name("valid");
        schema.forEach((sch, i) => {
            if ((0, util_1.alwaysValidSchema)(it, sch))
                return;
            const schCxt = cxt.subschema({ keyword: "allOf", schemaProp: i }, valid);
            cxt.ok(valid);
            cxt.mergeEvaluated(schCxt);
        });
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/anyOf.js":
/*!******************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/anyOf.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const code_1 = __webpack_require__(/*! ../code */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/code.js");
const def = {
    keyword: "anyOf",
    schemaType: "array",
    trackErrors: true,
    code: code_1.validateUnion,
    error: { message: "must match a schema in anyOf" },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/contains.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/contains.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const error = {
    message: ({ params: { min, max } }) => max === undefined
        ? (0, codegen_1.str) `must contain at least ${min} valid item(s)`
        : (0, codegen_1.str) `must contain at least ${min} and no more than ${max} valid item(s)`,
    params: ({ params: { min, max } }) => max === undefined ? (0, codegen_1._) `{minContains: ${min}}` : (0, codegen_1._) `{minContains: ${min}, maxContains: ${max}}`,
};
const def = {
    keyword: "contains",
    type: "array",
    schemaType: ["object", "boolean"],
    before: "uniqueItems",
    trackErrors: true,
    error,
    code(cxt) {
        const { gen, schema, parentSchema, data, it } = cxt;
        let min;
        let max;
        const { minContains, maxContains } = parentSchema;
        if (it.opts.next) {
            min = minContains === undefined ? 1 : minContains;
            max = maxContains;
        }
        else {
            min = 1;
        }
        const len = gen.const("len", (0, codegen_1._) `${data}.length`);
        cxt.setParams({ min, max });
        if (max === undefined && min === 0) {
            (0, util_1.checkStrictMode)(it, `"minContains" == 0 without "maxContains": "contains" keyword ignored`);
            return;
        }
        if (max !== undefined && min > max) {
            (0, util_1.checkStrictMode)(it, `"minContains" > "maxContains" is always invalid`);
            cxt.fail();
            return;
        }
        if ((0, util_1.alwaysValidSchema)(it, schema)) {
            let cond = (0, codegen_1._) `${len} >= ${min}`;
            if (max !== undefined)
                cond = (0, codegen_1._) `${cond} && ${len} <= ${max}`;
            cxt.pass(cond);
            return;
        }
        it.items = true;
        const valid = gen.name("valid");
        if (max === undefined && min === 1) {
            validateItems(valid, () => gen.if(valid, () => gen.break()));
        }
        else if (min === 0) {
            gen.let(valid, true);
            if (max !== undefined)
                gen.if((0, codegen_1._) `${data}.length > 0`, validateItemsWithCount);
        }
        else {
            gen.let(valid, false);
            validateItemsWithCount();
        }
        cxt.result(valid, () => cxt.reset());
        function validateItemsWithCount() {
            const schValid = gen.name("_valid");
            const count = gen.let("count", 0);
            validateItems(schValid, () => gen.if(schValid, () => checkLimits(count)));
        }
        function validateItems(_valid, block) {
            gen.forRange("i", 0, len, (i) => {
                cxt.subschema({
                    keyword: "contains",
                    dataProp: i,
                    dataPropType: util_1.Type.Num,
                    compositeRule: true,
                }, _valid);
                block();
            });
        }
        function checkLimits(count) {
            gen.code((0, codegen_1._) `${count}++`);
            if (max === undefined) {
                gen.if((0, codegen_1._) `${count} >= ${min}`, () => gen.assign(valid, true).break());
            }
            else {
                gen.if((0, codegen_1._) `${count} > ${max}`, () => gen.assign(valid, false).break());
                if (min === 1)
                    gen.assign(valid, true);
                else
                    gen.if((0, codegen_1._) `${count} >= ${min}`, () => gen.assign(valid, true));
            }
        }
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/dependencies.js":
/*!*************************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/dependencies.js ***!
  \*************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.validateSchemaDeps = exports.validatePropertyDeps = exports.error = void 0;
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const code_1 = __webpack_require__(/*! ../code */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/code.js");
exports.error = {
    message: ({ params: { property, depsCount, deps } }) => {
        const property_ies = depsCount === 1 ? "property" : "properties";
        return (0, codegen_1.str) `must have ${property_ies} ${deps} when property ${property} is present`;
    },
    params: ({ params: { property, depsCount, deps, missingProperty } }) => (0, codegen_1._) `{property: ${property},
    missingProperty: ${missingProperty},
    depsCount: ${depsCount},
    deps: ${deps}}`, // TODO change to reference
};
const def = {
    keyword: "dependencies",
    type: "object",
    schemaType: "object",
    error: exports.error,
    code(cxt) {
        const [propDeps, schDeps] = splitDependencies(cxt);
        validatePropertyDeps(cxt, propDeps);
        validateSchemaDeps(cxt, schDeps);
    },
};
function splitDependencies({ schema }) {
    const propertyDeps = {};
    const schemaDeps = {};
    for (const key in schema) {
        if (key === "__proto__")
            continue;
        const deps = Array.isArray(schema[key]) ? propertyDeps : schemaDeps;
        deps[key] = schema[key];
    }
    return [propertyDeps, schemaDeps];
}
function validatePropertyDeps(cxt, propertyDeps = cxt.schema) {
    const { gen, data, it } = cxt;
    if (Object.keys(propertyDeps).length === 0)
        return;
    const missing = gen.let("missing");
    for (const prop in propertyDeps) {
        const deps = propertyDeps[prop];
        if (deps.length === 0)
            continue;
        const hasProperty = (0, code_1.propertyInData)(gen, data, prop, it.opts.ownProperties);
        cxt.setParams({
            property: prop,
            depsCount: deps.length,
            deps: deps.join(", "),
        });
        if (it.allErrors) {
            gen.if(hasProperty, () => {
                for (const depProp of deps) {
                    (0, code_1.checkReportMissingProp)(cxt, depProp);
                }
            });
        }
        else {
            gen.if((0, codegen_1._) `${hasProperty} && (${(0, code_1.checkMissingProp)(cxt, deps, missing)})`);
            (0, code_1.reportMissingProp)(cxt, missing);
            gen.else();
        }
    }
}
exports.validatePropertyDeps = validatePropertyDeps;
function validateSchemaDeps(cxt, schemaDeps = cxt.schema) {
    const { gen, data, keyword, it } = cxt;
    const valid = gen.name("valid");
    for (const prop in schemaDeps) {
        if ((0, util_1.alwaysValidSchema)(it, schemaDeps[prop]))
            continue;
        gen.if((0, code_1.propertyInData)(gen, data, prop, it.opts.ownProperties), () => {
            const schCxt = cxt.subschema({ keyword, schemaProp: prop }, valid);
            cxt.mergeValidEvaluated(schCxt, valid);
        }, () => gen.var(valid, true) // TODO var
        );
        cxt.ok(valid);
    }
}
exports.validateSchemaDeps = validateSchemaDeps;
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/if.js":
/*!***************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/if.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const error = {
    message: ({ params }) => (0, codegen_1.str) `must match "${params.ifClause}" schema`,
    params: ({ params }) => (0, codegen_1._) `{failingKeyword: ${params.ifClause}}`,
};
const def = {
    keyword: "if",
    schemaType: ["object", "boolean"],
    trackErrors: true,
    error,
    code(cxt) {
        const { gen, parentSchema, it } = cxt;
        if (parentSchema.then === undefined && parentSchema.else === undefined) {
            (0, util_1.checkStrictMode)(it, '"if" without "then" and "else" is ignored');
        }
        const hasThen = hasSchema(it, "then");
        const hasElse = hasSchema(it, "else");
        if (!hasThen && !hasElse)
            return;
        const valid = gen.let("valid", true);
        const schValid = gen.name("_valid");
        validateIf();
        cxt.reset();
        if (hasThen && hasElse) {
            const ifClause = gen.let("ifClause");
            cxt.setParams({ ifClause });
            gen.if(schValid, validateClause("then", ifClause), validateClause("else", ifClause));
        }
        else if (hasThen) {
            gen.if(schValid, validateClause("then"));
        }
        else {
            gen.if((0, codegen_1.not)(schValid), validateClause("else"));
        }
        cxt.pass(valid, () => cxt.error(true));
        function validateIf() {
            const schCxt = cxt.subschema({
                keyword: "if",
                compositeRule: true,
                createErrors: false,
                allErrors: false,
            }, schValid);
            cxt.mergeEvaluated(schCxt);
        }
        function validateClause(keyword, ifClause) {
            return () => {
                const schCxt = cxt.subschema({ keyword }, schValid);
                gen.assign(valid, schValid);
                cxt.mergeValidEvaluated(schCxt, valid);
                if (ifClause)
                    gen.assign(ifClause, (0, codegen_1._) `${keyword}`);
                else
                    cxt.setParams({ ifClause: keyword });
            };
        }
    },
};
function hasSchema(it, keyword) {
    const schema = it.schema[keyword];
    return schema !== undefined && !(0, util_1.alwaysValidSchema)(it, schema);
}
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/index.js":
/*!******************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/index.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const additionalItems_1 = __webpack_require__(/*! ./additionalItems */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/additionalItems.js");
const prefixItems_1 = __webpack_require__(/*! ./prefixItems */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/prefixItems.js");
const items_1 = __webpack_require__(/*! ./items */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/items.js");
const items2020_1 = __webpack_require__(/*! ./items2020 */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/items2020.js");
const contains_1 = __webpack_require__(/*! ./contains */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/contains.js");
const dependencies_1 = __webpack_require__(/*! ./dependencies */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/dependencies.js");
const propertyNames_1 = __webpack_require__(/*! ./propertyNames */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/propertyNames.js");
const additionalProperties_1 = __webpack_require__(/*! ./additionalProperties */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/additionalProperties.js");
const properties_1 = __webpack_require__(/*! ./properties */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/properties.js");
const patternProperties_1 = __webpack_require__(/*! ./patternProperties */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/patternProperties.js");
const not_1 = __webpack_require__(/*! ./not */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/not.js");
const anyOf_1 = __webpack_require__(/*! ./anyOf */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/anyOf.js");
const oneOf_1 = __webpack_require__(/*! ./oneOf */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/oneOf.js");
const allOf_1 = __webpack_require__(/*! ./allOf */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/allOf.js");
const if_1 = __webpack_require__(/*! ./if */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/if.js");
const thenElse_1 = __webpack_require__(/*! ./thenElse */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/thenElse.js");
function getApplicator(draft2020 = false) {
    const applicator = [
        // any
        not_1.default,
        anyOf_1.default,
        oneOf_1.default,
        allOf_1.default,
        if_1.default,
        thenElse_1.default,
        // object
        propertyNames_1.default,
        additionalProperties_1.default,
        dependencies_1.default,
        properties_1.default,
        patternProperties_1.default,
    ];
    // array
    if (draft2020)
        applicator.push(prefixItems_1.default, items2020_1.default);
    else
        applicator.push(additionalItems_1.default, items_1.default);
    applicator.push(contains_1.default);
    return applicator;
}
exports["default"] = getApplicator;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/items.js":
/*!******************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/items.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.validateTuple = void 0;
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const code_1 = __webpack_require__(/*! ../code */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/code.js");
const def = {
    keyword: "items",
    type: "array",
    schemaType: ["object", "array", "boolean"],
    before: "uniqueItems",
    code(cxt) {
        const { schema, it } = cxt;
        if (Array.isArray(schema))
            return validateTuple(cxt, "additionalItems", schema);
        it.items = true;
        if ((0, util_1.alwaysValidSchema)(it, schema))
            return;
        cxt.ok((0, code_1.validateArray)(cxt));
    },
};
function validateTuple(cxt, extraItems, schArr = cxt.schema) {
    const { gen, parentSchema, data, keyword, it } = cxt;
    checkStrictTuple(parentSchema);
    if (it.opts.unevaluated && schArr.length && it.items !== true) {
        it.items = util_1.mergeEvaluated.items(gen, schArr.length, it.items);
    }
    const valid = gen.name("valid");
    const len = gen.const("len", (0, codegen_1._) `${data}.length`);
    schArr.forEach((sch, i) => {
        if ((0, util_1.alwaysValidSchema)(it, sch))
            return;
        gen.if((0, codegen_1._) `${len} > ${i}`, () => cxt.subschema({
            keyword,
            schemaProp: i,
            dataProp: i,
        }, valid));
        cxt.ok(valid);
    });
    function checkStrictTuple(sch) {
        const { opts, errSchemaPath } = it;
        const l = schArr.length;
        const fullTuple = l === sch.minItems && (l === sch.maxItems || sch[extraItems] === false);
        if (opts.strictTuples && !fullTuple) {
            const msg = `"${keyword}" is ${l}-tuple, but minItems or maxItems/${extraItems} are not specified or different at path "${errSchemaPath}"`;
            (0, util_1.checkStrictMode)(it, msg, opts.strictTuples);
        }
    }
}
exports.validateTuple = validateTuple;
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/items2020.js":
/*!**********************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/items2020.js ***!
  \**********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const code_1 = __webpack_require__(/*! ../code */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/code.js");
const additionalItems_1 = __webpack_require__(/*! ./additionalItems */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/additionalItems.js");
const error = {
    message: ({ params: { len } }) => (0, codegen_1.str) `must NOT have more than ${len} items`,
    params: ({ params: { len } }) => (0, codegen_1._) `{limit: ${len}}`,
};
const def = {
    keyword: "items",
    type: "array",
    schemaType: ["object", "boolean"],
    before: "uniqueItems",
    error,
    code(cxt) {
        const { schema, parentSchema, it } = cxt;
        const { prefixItems } = parentSchema;
        it.items = true;
        if ((0, util_1.alwaysValidSchema)(it, schema))
            return;
        if (prefixItems)
            (0, additionalItems_1.validateAdditionalItems)(cxt, prefixItems);
        else
            cxt.ok((0, code_1.validateArray)(cxt));
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/not.js":
/*!****************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/not.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const def = {
    keyword: "not",
    schemaType: ["object", "boolean"],
    trackErrors: true,
    code(cxt) {
        const { gen, schema, it } = cxt;
        if ((0, util_1.alwaysValidSchema)(it, schema)) {
            cxt.fail();
            return;
        }
        const valid = gen.name("valid");
        cxt.subschema({
            keyword: "not",
            compositeRule: true,
            createErrors: false,
            allErrors: false,
        }, valid);
        cxt.failResult(valid, () => cxt.reset(), () => cxt.error());
    },
    error: { message: "must NOT be valid" },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/oneOf.js":
/*!******************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/oneOf.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const error = {
    message: "must match exactly one schema in oneOf",
    params: ({ params }) => (0, codegen_1._) `{passingSchemas: ${params.passing}}`,
};
const def = {
    keyword: "oneOf",
    schemaType: "array",
    trackErrors: true,
    error,
    code(cxt) {
        const { gen, schema, parentSchema, it } = cxt;
        /* istanbul ignore if */
        if (!Array.isArray(schema))
            throw new Error("ajv implementation error");
        if (it.opts.discriminator && parentSchema.discriminator)
            return;
        const schArr = schema;
        const valid = gen.let("valid", false);
        const passing = gen.let("passing", null);
        const schValid = gen.name("_valid");
        cxt.setParams({ passing });
        // TODO possibly fail straight away (with warning or exception) if there are two empty always valid schemas
        gen.block(validateOneOf);
        cxt.result(valid, () => cxt.reset(), () => cxt.error(true));
        function validateOneOf() {
            schArr.forEach((sch, i) => {
                let schCxt;
                if ((0, util_1.alwaysValidSchema)(it, sch)) {
                    gen.var(schValid, true);
                }
                else {
                    schCxt = cxt.subschema({
                        keyword: "oneOf",
                        schemaProp: i,
                        compositeRule: true,
                    }, schValid);
                }
                if (i > 0) {
                    gen
                        .if((0, codegen_1._) `${schValid} && ${valid}`)
                        .assign(valid, false)
                        .assign(passing, (0, codegen_1._) `[${passing}, ${i}]`)
                        .else();
                }
                gen.if(schValid, () => {
                    gen.assign(valid, true);
                    gen.assign(passing, i);
                    if (schCxt)
                        cxt.mergeEvaluated(schCxt, codegen_1.Name);
                });
            });
        }
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/patternProperties.js":
/*!******************************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/patternProperties.js ***!
  \******************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const code_1 = __webpack_require__(/*! ../code */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/code.js");
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const util_2 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const def = {
    keyword: "patternProperties",
    type: "object",
    schemaType: "object",
    code(cxt) {
        const { gen, schema, data, parentSchema, it } = cxt;
        const { opts } = it;
        const patterns = (0, code_1.allSchemaProperties)(schema);
        const alwaysValidPatterns = patterns.filter((p) => (0, util_1.alwaysValidSchema)(it, schema[p]));
        if (patterns.length === 0 ||
            (alwaysValidPatterns.length === patterns.length &&
                (!it.opts.unevaluated || it.props === true))) {
            return;
        }
        const checkProperties = opts.strictSchema && !opts.allowMatchingProperties && parentSchema.properties;
        const valid = gen.name("valid");
        if (it.props !== true && !(it.props instanceof codegen_1.Name)) {
            it.props = (0, util_2.evaluatedPropsToName)(gen, it.props);
        }
        const { props } = it;
        validatePatternProperties();
        function validatePatternProperties() {
            for (const pat of patterns) {
                if (checkProperties)
                    checkMatchingProperties(pat);
                if (it.allErrors) {
                    validateProperties(pat);
                }
                else {
                    gen.var(valid, true); // TODO var
                    validateProperties(pat);
                    gen.if(valid);
                }
            }
        }
        function checkMatchingProperties(pat) {
            for (const prop in checkProperties) {
                if (new RegExp(pat).test(prop)) {
                    (0, util_1.checkStrictMode)(it, `property ${prop} matches pattern ${pat} (use allowMatchingProperties)`);
                }
            }
        }
        function validateProperties(pat) {
            gen.forIn("key", data, (key) => {
                gen.if((0, codegen_1._) `${(0, code_1.usePattern)(cxt, pat)}.test(${key})`, () => {
                    const alwaysValid = alwaysValidPatterns.includes(pat);
                    if (!alwaysValid) {
                        cxt.subschema({
                            keyword: "patternProperties",
                            schemaProp: pat,
                            dataProp: key,
                            dataPropType: util_2.Type.Str,
                        }, valid);
                    }
                    if (it.opts.unevaluated && props !== true) {
                        gen.assign((0, codegen_1._) `${props}[${key}]`, true);
                    }
                    else if (!alwaysValid && !it.allErrors) {
                        // can short-circuit if `unevaluatedProperties` is not supported (opts.next === false)
                        // or if all properties were evaluated (props === true)
                        gen.if((0, codegen_1.not)(valid), () => gen.break());
                    }
                });
            });
        }
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/prefixItems.js":
/*!************************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/prefixItems.js ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const items_1 = __webpack_require__(/*! ./items */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/items.js");
const def = {
    keyword: "prefixItems",
    type: "array",
    schemaType: ["array"],
    before: "uniqueItems",
    code: (cxt) => (0, items_1.validateTuple)(cxt, "items"),
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/properties.js":
/*!***********************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/properties.js ***!
  \***********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const validate_1 = __webpack_require__(/*! ../../compile/validate */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/index.js");
const code_1 = __webpack_require__(/*! ../code */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/code.js");
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const additionalProperties_1 = __webpack_require__(/*! ./additionalProperties */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/additionalProperties.js");
const def = {
    keyword: "properties",
    type: "object",
    schemaType: "object",
    code(cxt) {
        const { gen, schema, parentSchema, data, it } = cxt;
        if (it.opts.removeAdditional === "all" && parentSchema.additionalProperties === undefined) {
            additionalProperties_1.default.code(new validate_1.KeywordCxt(it, additionalProperties_1.default, "additionalProperties"));
        }
        const allProps = (0, code_1.allSchemaProperties)(schema);
        for (const prop of allProps) {
            it.definedProperties.add(prop);
        }
        if (it.opts.unevaluated && allProps.length && it.props !== true) {
            it.props = util_1.mergeEvaluated.props(gen, (0, util_1.toHash)(allProps), it.props);
        }
        const properties = allProps.filter((p) => !(0, util_1.alwaysValidSchema)(it, schema[p]));
        if (properties.length === 0)
            return;
        const valid = gen.name("valid");
        for (const prop of properties) {
            if (hasDefault(prop)) {
                applyPropertySchema(prop);
            }
            else {
                gen.if((0, code_1.propertyInData)(gen, data, prop, it.opts.ownProperties));
                applyPropertySchema(prop);
                if (!it.allErrors)
                    gen.else().var(valid, true);
                gen.endIf();
            }
            cxt.it.definedProperties.add(prop);
            cxt.ok(valid);
        }
        function hasDefault(prop) {
            return it.opts.useDefaults && !it.compositeRule && schema[prop].default !== undefined;
        }
        function applyPropertySchema(prop) {
            cxt.subschema({
                keyword: "properties",
                schemaProp: prop,
                dataProp: prop,
            }, valid);
        }
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/propertyNames.js":
/*!**************************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/propertyNames.js ***!
  \**************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const error = {
    message: "property name must be valid",
    params: ({ params }) => (0, codegen_1._) `{propertyName: ${params.propertyName}}`,
};
const def = {
    keyword: "propertyNames",
    type: "object",
    schemaType: ["object", "boolean"],
    error,
    code(cxt) {
        const { gen, schema, data, it } = cxt;
        if ((0, util_1.alwaysValidSchema)(it, schema))
            return;
        const valid = gen.name("valid");
        gen.forIn("key", data, (key) => {
            cxt.setParams({ propertyName: key });
            cxt.subschema({
                keyword: "propertyNames",
                data: key,
                dataTypes: ["string"],
                propertyName: key,
                compositeRule: true,
            }, valid);
            gen.if((0, codegen_1.not)(valid), () => {
                cxt.error(true);
                if (!it.allErrors)
                    gen.break();
            });
        });
        cxt.ok(valid);
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/thenElse.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/thenElse.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const def = {
    keyword: ["then", "else"],
    schemaType: ["object", "boolean"],
    code({ keyword, parentSchema, it }) {
        if (parentSchema.if === undefined)
            (0, util_1.checkStrictMode)(it, `"${keyword}" without "if" is ignored`);
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/code.js":
/*!******************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/code.js ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.validateUnion = exports.validateArray = exports.usePattern = exports.callValidateCode = exports.schemaProperties = exports.allSchemaProperties = exports.noPropertyInData = exports.propertyInData = exports.isOwnProperty = exports.hasPropFunc = exports.reportMissingProp = exports.checkMissingProp = exports.checkReportMissingProp = void 0;
const codegen_1 = __webpack_require__(/*! ../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const util_1 = __webpack_require__(/*! ../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const names_1 = __webpack_require__(/*! ../compile/names */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/names.js");
const util_2 = __webpack_require__(/*! ../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
function checkReportMissingProp(cxt, prop) {
    const { gen, data, it } = cxt;
    gen.if(noPropertyInData(gen, data, prop, it.opts.ownProperties), () => {
        cxt.setParams({ missingProperty: (0, codegen_1._) `${prop}` }, true);
        cxt.error();
    });
}
exports.checkReportMissingProp = checkReportMissingProp;
function checkMissingProp({ gen, data, it: { opts } }, properties, missing) {
    return (0, codegen_1.or)(...properties.map((prop) => (0, codegen_1.and)(noPropertyInData(gen, data, prop, opts.ownProperties), (0, codegen_1._) `${missing} = ${prop}`)));
}
exports.checkMissingProp = checkMissingProp;
function reportMissingProp(cxt, missing) {
    cxt.setParams({ missingProperty: missing }, true);
    cxt.error();
}
exports.reportMissingProp = reportMissingProp;
function hasPropFunc(gen) {
    return gen.scopeValue("func", {
        // eslint-disable-next-line @typescript-eslint/unbound-method
        ref: Object.prototype.hasOwnProperty,
        code: (0, codegen_1._) `Object.prototype.hasOwnProperty`,
    });
}
exports.hasPropFunc = hasPropFunc;
function isOwnProperty(gen, data, property) {
    return (0, codegen_1._) `${hasPropFunc(gen)}.call(${data}, ${property})`;
}
exports.isOwnProperty = isOwnProperty;
function propertyInData(gen, data, property, ownProperties) {
    const cond = (0, codegen_1._) `${data}${(0, codegen_1.getProperty)(property)} !== undefined`;
    return ownProperties ? (0, codegen_1._) `${cond} && ${isOwnProperty(gen, data, property)}` : cond;
}
exports.propertyInData = propertyInData;
function noPropertyInData(gen, data, property, ownProperties) {
    const cond = (0, codegen_1._) `${data}${(0, codegen_1.getProperty)(property)} === undefined`;
    return ownProperties ? (0, codegen_1.or)(cond, (0, codegen_1.not)(isOwnProperty(gen, data, property))) : cond;
}
exports.noPropertyInData = noPropertyInData;
function allSchemaProperties(schemaMap) {
    return schemaMap ? Object.keys(schemaMap).filter((p) => p !== "__proto__") : [];
}
exports.allSchemaProperties = allSchemaProperties;
function schemaProperties(it, schemaMap) {
    return allSchemaProperties(schemaMap).filter((p) => !(0, util_1.alwaysValidSchema)(it, schemaMap[p]));
}
exports.schemaProperties = schemaProperties;
function callValidateCode({ schemaCode, data, it: { gen, topSchemaRef, schemaPath, errorPath }, it }, func, context, passSchema) {
    const dataAndSchema = passSchema ? (0, codegen_1._) `${schemaCode}, ${data}, ${topSchemaRef}${schemaPath}` : data;
    const valCxt = [
        [names_1.default.instancePath, (0, codegen_1.strConcat)(names_1.default.instancePath, errorPath)],
        [names_1.default.parentData, it.parentData],
        [names_1.default.parentDataProperty, it.parentDataProperty],
        [names_1.default.rootData, names_1.default.rootData],
    ];
    if (it.opts.dynamicRef)
        valCxt.push([names_1.default.dynamicAnchors, names_1.default.dynamicAnchors]);
    const args = (0, codegen_1._) `${dataAndSchema}, ${gen.object(...valCxt)}`;
    return context !== codegen_1.nil ? (0, codegen_1._) `${func}.call(${context}, ${args})` : (0, codegen_1._) `${func}(${args})`;
}
exports.callValidateCode = callValidateCode;
const newRegExp = (0, codegen_1._) `new RegExp`;
function usePattern({ gen, it: { opts } }, pattern) {
    const u = opts.unicodeRegExp ? "u" : "";
    const { regExp } = opts.code;
    const rx = regExp(pattern, u);
    return gen.scopeValue("pattern", {
        key: rx.toString(),
        ref: rx,
        code: (0, codegen_1._) `${regExp.code === "new RegExp" ? newRegExp : (0, util_2.useFunc)(gen, regExp)}(${pattern}, ${u})`,
    });
}
exports.usePattern = usePattern;
function validateArray(cxt) {
    const { gen, data, keyword, it } = cxt;
    const valid = gen.name("valid");
    if (it.allErrors) {
        const validArr = gen.let("valid", true);
        validateItems(() => gen.assign(validArr, false));
        return validArr;
    }
    gen.var(valid, true);
    validateItems(() => gen.break());
    return valid;
    function validateItems(notValid) {
        const len = gen.const("len", (0, codegen_1._) `${data}.length`);
        gen.forRange("i", 0, len, (i) => {
            cxt.subschema({
                keyword,
                dataProp: i,
                dataPropType: util_1.Type.Num,
            }, valid);
            gen.if((0, codegen_1.not)(valid), notValid);
        });
    }
}
exports.validateArray = validateArray;
function validateUnion(cxt) {
    const { gen, schema, keyword, it } = cxt;
    /* istanbul ignore if */
    if (!Array.isArray(schema))
        throw new Error("ajv implementation error");
    const alwaysValid = schema.some((sch) => (0, util_1.alwaysValidSchema)(it, sch));
    if (alwaysValid && !it.opts.unevaluated)
        return;
    const valid = gen.let("valid", false);
    const schValid = gen.name("_valid");
    gen.block(() => schema.forEach((_sch, i) => {
        const schCxt = cxt.subschema({
            keyword,
            schemaProp: i,
            compositeRule: true,
        }, schValid);
        gen.assign(valid, (0, codegen_1._) `${valid} || ${schValid}`);
        const merged = cxt.mergeValidEvaluated(schCxt, schValid);
        // can short-circuit if `unevaluatedProperties/Items` not supported (opts.unevaluated !== true)
        // or if all properties and items were evaluated (it.props === true && it.items === true)
        if (!merged)
            gen.if((0, codegen_1.not)(valid));
    }));
    cxt.result(valid, () => cxt.reset(), () => cxt.error(true));
}
exports.validateUnion = validateUnion;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/core/id.js":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/core/id.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const def = {
    keyword: "id",
    code() {
        throw new Error('NOT SUPPORTED: keyword "id", use "$id" for schema ID');
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/core/index.js":
/*!************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/core/index.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const id_1 = __webpack_require__(/*! ./id */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/core/id.js");
const ref_1 = __webpack_require__(/*! ./ref */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/core/ref.js");
const core = [
    "$schema",
    "$id",
    "$defs",
    "$vocabulary",
    { keyword: "$comment" },
    "definitions",
    id_1.default,
    ref_1.default,
];
exports["default"] = core;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/core/ref.js":
/*!**********************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/core/ref.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.callRef = exports.getValidate = void 0;
const ref_error_1 = __webpack_require__(/*! ../../compile/ref_error */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/ref_error.js");
const code_1 = __webpack_require__(/*! ../code */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/code.js");
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const names_1 = __webpack_require__(/*! ../../compile/names */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/names.js");
const compile_1 = __webpack_require__(/*! ../../compile */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/index.js");
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const def = {
    keyword: "$ref",
    schemaType: "string",
    code(cxt) {
        const { gen, schema: $ref, it } = cxt;
        const { baseId, schemaEnv: env, validateName, opts, self } = it;
        const { root } = env;
        if (($ref === "#" || $ref === "#/") && baseId === root.baseId)
            return callRootRef();
        const schOrEnv = compile_1.resolveRef.call(self, root, baseId, $ref);
        if (schOrEnv === undefined)
            throw new ref_error_1.default(it.opts.uriResolver, baseId, $ref);
        if (schOrEnv instanceof compile_1.SchemaEnv)
            return callValidate(schOrEnv);
        return inlineRefSchema(schOrEnv);
        function callRootRef() {
            if (env === root)
                return callRef(cxt, validateName, env, env.$async);
            const rootName = gen.scopeValue("root", { ref: root });
            return callRef(cxt, (0, codegen_1._) `${rootName}.validate`, root, root.$async);
        }
        function callValidate(sch) {
            const v = getValidate(cxt, sch);
            callRef(cxt, v, sch, sch.$async);
        }
        function inlineRefSchema(sch) {
            const schName = gen.scopeValue("schema", opts.code.source === true ? { ref: sch, code: (0, codegen_1.stringify)(sch) } : { ref: sch });
            const valid = gen.name("valid");
            const schCxt = cxt.subschema({
                schema: sch,
                dataTypes: [],
                schemaPath: codegen_1.nil,
                topSchemaRef: schName,
                errSchemaPath: $ref,
            }, valid);
            cxt.mergeEvaluated(schCxt);
            cxt.ok(valid);
        }
    },
};
function getValidate(cxt, sch) {
    const { gen } = cxt;
    return sch.validate
        ? gen.scopeValue("validate", { ref: sch.validate })
        : (0, codegen_1._) `${gen.scopeValue("wrapper", { ref: sch })}.validate`;
}
exports.getValidate = getValidate;
function callRef(cxt, v, sch, $async) {
    const { gen, it } = cxt;
    const { allErrors, schemaEnv: env, opts } = it;
    const passCxt = opts.passContext ? names_1.default.this : codegen_1.nil;
    if ($async)
        callAsyncRef();
    else
        callSyncRef();
    function callAsyncRef() {
        if (!env.$async)
            throw new Error("async schema referenced by sync schema");
        const valid = gen.let("valid");
        gen.try(() => {
            gen.code((0, codegen_1._) `await ${(0, code_1.callValidateCode)(cxt, v, passCxt)}`);
            addEvaluatedFrom(v); // TODO will not work with async, it has to be returned with the result
            if (!allErrors)
                gen.assign(valid, true);
        }, (e) => {
            gen.if((0, codegen_1._) `!(${e} instanceof ${it.ValidationError})`, () => gen.throw(e));
            addErrorsFrom(e);
            if (!allErrors)
                gen.assign(valid, false);
        });
        cxt.ok(valid);
    }
    function callSyncRef() {
        cxt.result((0, code_1.callValidateCode)(cxt, v, passCxt), () => addEvaluatedFrom(v), () => addErrorsFrom(v));
    }
    function addErrorsFrom(source) {
        const errs = (0, codegen_1._) `${source}.errors`;
        gen.assign(names_1.default.vErrors, (0, codegen_1._) `${names_1.default.vErrors} === null ? ${errs} : ${names_1.default.vErrors}.concat(${errs})`); // TODO tagged
        gen.assign(names_1.default.errors, (0, codegen_1._) `${names_1.default.vErrors}.length`);
    }
    function addEvaluatedFrom(source) {
        var _a;
        if (!it.opts.unevaluated)
            return;
        const schEvaluated = (_a = sch === null || sch === void 0 ? void 0 : sch.validate) === null || _a === void 0 ? void 0 : _a.evaluated;
        // TODO refactor
        if (it.props !== true) {
            if (schEvaluated && !schEvaluated.dynamicProps) {
                if (schEvaluated.props !== undefined) {
                    it.props = util_1.mergeEvaluated.props(gen, schEvaluated.props, it.props);
                }
            }
            else {
                const props = gen.var("props", (0, codegen_1._) `${source}.evaluated.props`);
                it.props = util_1.mergeEvaluated.props(gen, props, it.props, codegen_1.Name);
            }
        }
        if (it.items !== true) {
            if (schEvaluated && !schEvaluated.dynamicItems) {
                if (schEvaluated.items !== undefined) {
                    it.items = util_1.mergeEvaluated.items(gen, schEvaluated.items, it.items);
                }
            }
            else {
                const items = gen.var("items", (0, codegen_1._) `${source}.evaluated.items`);
                it.items = util_1.mergeEvaluated.items(gen, items, it.items, codegen_1.Name);
            }
        }
    }
}
exports.callRef = callRef;
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/discriminator/index.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/discriminator/index.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const types_1 = __webpack_require__(/*! ../discriminator/types */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/discriminator/types.js");
const compile_1 = __webpack_require__(/*! ../../compile */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/index.js");
const ref_error_1 = __webpack_require__(/*! ../../compile/ref_error */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/ref_error.js");
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const error = {
    message: ({ params: { discrError, tagName } }) => discrError === types_1.DiscrError.Tag
        ? `tag "${tagName}" must be string`
        : `value of tag "${tagName}" must be in oneOf`,
    params: ({ params: { discrError, tag, tagName } }) => (0, codegen_1._) `{error: ${discrError}, tag: ${tagName}, tagValue: ${tag}}`,
};
const def = {
    keyword: "discriminator",
    type: "object",
    schemaType: "object",
    error,
    code(cxt) {
        const { gen, data, schema, parentSchema, it } = cxt;
        const { oneOf } = parentSchema;
        if (!it.opts.discriminator) {
            throw new Error("discriminator: requires discriminator option");
        }
        const tagName = schema.propertyName;
        if (typeof tagName != "string")
            throw new Error("discriminator: requires propertyName");
        if (schema.mapping)
            throw new Error("discriminator: mapping is not supported");
        if (!oneOf)
            throw new Error("discriminator: requires oneOf keyword");
        const valid = gen.let("valid", false);
        const tag = gen.const("tag", (0, codegen_1._) `${data}${(0, codegen_1.getProperty)(tagName)}`);
        gen.if((0, codegen_1._) `typeof ${tag} == "string"`, () => validateMapping(), () => cxt.error(false, { discrError: types_1.DiscrError.Tag, tag, tagName }));
        cxt.ok(valid);
        function validateMapping() {
            const mapping = getMapping();
            gen.if(false);
            for (const tagValue in mapping) {
                gen.elseIf((0, codegen_1._) `${tag} === ${tagValue}`);
                gen.assign(valid, applyTagSchema(mapping[tagValue]));
            }
            gen.else();
            cxt.error(false, { discrError: types_1.DiscrError.Mapping, tag, tagName });
            gen.endIf();
        }
        function applyTagSchema(schemaProp) {
            const _valid = gen.name("valid");
            const schCxt = cxt.subschema({ keyword: "oneOf", schemaProp }, _valid);
            cxt.mergeEvaluated(schCxt, codegen_1.Name);
            return _valid;
        }
        function getMapping() {
            var _a;
            const oneOfMapping = {};
            const topRequired = hasRequired(parentSchema);
            let tagRequired = true;
            for (let i = 0; i < oneOf.length; i++) {
                let sch = oneOf[i];
                if ((sch === null || sch === void 0 ? void 0 : sch.$ref) && !(0, util_1.schemaHasRulesButRef)(sch, it.self.RULES)) {
                    const ref = sch.$ref;
                    sch = compile_1.resolveRef.call(it.self, it.schemaEnv.root, it.baseId, ref);
                    if (sch instanceof compile_1.SchemaEnv)
                        sch = sch.schema;
                    if (sch === undefined)
                        throw new ref_error_1.default(it.opts.uriResolver, it.baseId, ref);
                }
                const propSch = (_a = sch === null || sch === void 0 ? void 0 : sch.properties) === null || _a === void 0 ? void 0 : _a[tagName];
                if (typeof propSch != "object") {
                    throw new Error(`discriminator: oneOf subschemas (or referenced schemas) must have "properties/${tagName}"`);
                }
                tagRequired = tagRequired && (topRequired || hasRequired(sch));
                addMappings(propSch, i);
            }
            if (!tagRequired)
                throw new Error(`discriminator: "${tagName}" must be required`);
            return oneOfMapping;
            function hasRequired({ required }) {
                return Array.isArray(required) && required.includes(tagName);
            }
            function addMappings(sch, i) {
                if (sch.const) {
                    addMapping(sch.const, i);
                }
                else if (sch.enum) {
                    for (const tagValue of sch.enum) {
                        addMapping(tagValue, i);
                    }
                }
                else {
                    throw new Error(`discriminator: "properties/${tagName}" must have "const" or "enum"`);
                }
            }
            function addMapping(tagValue, i) {
                if (typeof tagValue != "string" || tagValue in oneOfMapping) {
                    throw new Error(`discriminator: "${tagName}" values must be unique strings`);
                }
                oneOfMapping[tagValue] = i;
            }
        }
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/discriminator/types.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/discriminator/types.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DiscrError = void 0;
var DiscrError;
(function (DiscrError) {
    DiscrError["Tag"] = "tag";
    DiscrError["Mapping"] = "mapping";
})(DiscrError || (exports.DiscrError = DiscrError = {}));


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/draft7.js":
/*!********************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/draft7.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const core_1 = __webpack_require__(/*! ./core */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/core/index.js");
const validation_1 = __webpack_require__(/*! ./validation */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/index.js");
const applicator_1 = __webpack_require__(/*! ./applicator */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/applicator/index.js");
const format_1 = __webpack_require__(/*! ./format */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/format/index.js");
const metadata_1 = __webpack_require__(/*! ./metadata */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/metadata.js");
const draft7Vocabularies = [
    core_1.default,
    validation_1.default,
    (0, applicator_1.default)(),
    format_1.default,
    metadata_1.metadataVocabulary,
    metadata_1.contentVocabulary,
];
exports["default"] = draft7Vocabularies;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/format/format.js":
/*!***************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/format/format.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const error = {
    message: ({ schemaCode }) => (0, codegen_1.str) `must match format "${schemaCode}"`,
    params: ({ schemaCode }) => (0, codegen_1._) `{format: ${schemaCode}}`,
};
const def = {
    keyword: "format",
    type: ["number", "string"],
    schemaType: "string",
    $data: true,
    error,
    code(cxt, ruleType) {
        const { gen, data, $data, schema, schemaCode, it } = cxt;
        const { opts, errSchemaPath, schemaEnv, self } = it;
        if (!opts.validateFormats)
            return;
        if ($data)
            validate$DataFormat();
        else
            validateFormat();
        function validate$DataFormat() {
            const fmts = gen.scopeValue("formats", {
                ref: self.formats,
                code: opts.code.formats,
            });
            const fDef = gen.const("fDef", (0, codegen_1._) `${fmts}[${schemaCode}]`);
            const fType = gen.let("fType");
            const format = gen.let("format");
            // TODO simplify
            gen.if((0, codegen_1._) `typeof ${fDef} == "object" && !(${fDef} instanceof RegExp)`, () => gen.assign(fType, (0, codegen_1._) `${fDef}.type || "string"`).assign(format, (0, codegen_1._) `${fDef}.validate`), () => gen.assign(fType, (0, codegen_1._) `"string"`).assign(format, fDef));
            cxt.fail$data((0, codegen_1.or)(unknownFmt(), invalidFmt()));
            function unknownFmt() {
                if (opts.strictSchema === false)
                    return codegen_1.nil;
                return (0, codegen_1._) `${schemaCode} && !${format}`;
            }
            function invalidFmt() {
                const callFormat = schemaEnv.$async
                    ? (0, codegen_1._) `(${fDef}.async ? await ${format}(${data}) : ${format}(${data}))`
                    : (0, codegen_1._) `${format}(${data})`;
                const validData = (0, codegen_1._) `(typeof ${format} == "function" ? ${callFormat} : ${format}.test(${data}))`;
                return (0, codegen_1._) `${format} && ${format} !== true && ${fType} === ${ruleType} && !${validData}`;
            }
        }
        function validateFormat() {
            const formatDef = self.formats[schema];
            if (!formatDef) {
                unknownFormat();
                return;
            }
            if (formatDef === true)
                return;
            const [fmtType, format, fmtRef] = getFormat(formatDef);
            if (fmtType === ruleType)
                cxt.pass(validCondition());
            function unknownFormat() {
                if (opts.strictSchema === false) {
                    self.logger.warn(unknownMsg());
                    return;
                }
                throw new Error(unknownMsg());
                function unknownMsg() {
                    return `unknown format "${schema}" ignored in schema at path "${errSchemaPath}"`;
                }
            }
            function getFormat(fmtDef) {
                const code = fmtDef instanceof RegExp
                    ? (0, codegen_1.regexpCode)(fmtDef)
                    : opts.code.formats
                        ? (0, codegen_1._) `${opts.code.formats}${(0, codegen_1.getProperty)(schema)}`
                        : undefined;
                const fmt = gen.scopeValue("formats", { key: schema, ref: fmtDef, code });
                if (typeof fmtDef == "object" && !(fmtDef instanceof RegExp)) {
                    return [fmtDef.type || "string", fmtDef.validate, (0, codegen_1._) `${fmt}.validate`];
                }
                return ["string", fmtDef, fmt];
            }
            function validCondition() {
                if (typeof formatDef == "object" && !(formatDef instanceof RegExp) && formatDef.async) {
                    if (!schemaEnv.$async)
                        throw new Error("async format in sync schema");
                    return (0, codegen_1._) `await ${fmtRef}(${data})`;
                }
                return typeof format == "function" ? (0, codegen_1._) `${fmtRef}(${data})` : (0, codegen_1._) `${fmtRef}.test(${data})`;
            }
        }
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/format/index.js":
/*!**************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/format/index.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const format_1 = __webpack_require__(/*! ./format */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/format/format.js");
const format = [format_1.default];
exports["default"] = format;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/metadata.js":
/*!**********************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/metadata.js ***!
  \**********************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.contentVocabulary = exports.metadataVocabulary = void 0;
exports.metadataVocabulary = [
    "title",
    "description",
    "default",
    "deprecated",
    "readOnly",
    "writeOnly",
    "examples",
];
exports.contentVocabulary = [
    "contentMediaType",
    "contentEncoding",
    "contentSchema",
];


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/const.js":
/*!******************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/const.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const equal_1 = __webpack_require__(/*! ../../runtime/equal */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/runtime/equal.js");
const error = {
    message: "must be equal to constant",
    params: ({ schemaCode }) => (0, codegen_1._) `{allowedValue: ${schemaCode}}`,
};
const def = {
    keyword: "const",
    $data: true,
    error,
    code(cxt) {
        const { gen, data, $data, schemaCode, schema } = cxt;
        if ($data || (schema && typeof schema == "object")) {
            cxt.fail$data((0, codegen_1._) `!${(0, util_1.useFunc)(gen, equal_1.default)}(${data}, ${schemaCode})`);
        }
        else {
            cxt.fail((0, codegen_1._) `${schema} !== ${data}`);
        }
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/enum.js":
/*!*****************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/enum.js ***!
  \*****************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const equal_1 = __webpack_require__(/*! ../../runtime/equal */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/runtime/equal.js");
const error = {
    message: "must be equal to one of the allowed values",
    params: ({ schemaCode }) => (0, codegen_1._) `{allowedValues: ${schemaCode}}`,
};
const def = {
    keyword: "enum",
    schemaType: "array",
    $data: true,
    error,
    code(cxt) {
        const { gen, data, $data, schema, schemaCode, it } = cxt;
        if (!$data && schema.length === 0)
            throw new Error("enum must have non-empty array");
        const useLoop = schema.length >= it.opts.loopEnum;
        let eql;
        const getEql = () => (eql !== null && eql !== void 0 ? eql : (eql = (0, util_1.useFunc)(gen, equal_1.default)));
        let valid;
        if (useLoop || $data) {
            valid = gen.let("valid");
            cxt.block$data(valid, loopEnum);
        }
        else {
            /* istanbul ignore if */
            if (!Array.isArray(schema))
                throw new Error("ajv implementation error");
            const vSchema = gen.const("vSchema", schemaCode);
            valid = (0, codegen_1.or)(...schema.map((_x, i) => equalCode(vSchema, i)));
        }
        cxt.pass(valid);
        function loopEnum() {
            gen.assign(valid, false);
            gen.forOf("v", schemaCode, (v) => gen.if((0, codegen_1._) `${getEql()}(${data}, ${v})`, () => gen.assign(valid, true).break()));
        }
        function equalCode(vSchema, i) {
            const sch = schema[i];
            return typeof sch === "object" && sch !== null
                ? (0, codegen_1._) `${getEql()}(${data}, ${vSchema}[${i}])`
                : (0, codegen_1._) `${data} === ${sch}`;
        }
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/index.js":
/*!******************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/index.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const limitNumber_1 = __webpack_require__(/*! ./limitNumber */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/limitNumber.js");
const multipleOf_1 = __webpack_require__(/*! ./multipleOf */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/multipleOf.js");
const limitLength_1 = __webpack_require__(/*! ./limitLength */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/limitLength.js");
const pattern_1 = __webpack_require__(/*! ./pattern */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/pattern.js");
const limitProperties_1 = __webpack_require__(/*! ./limitProperties */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/limitProperties.js");
const required_1 = __webpack_require__(/*! ./required */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/required.js");
const limitItems_1 = __webpack_require__(/*! ./limitItems */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/limitItems.js");
const uniqueItems_1 = __webpack_require__(/*! ./uniqueItems */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/uniqueItems.js");
const const_1 = __webpack_require__(/*! ./const */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/const.js");
const enum_1 = __webpack_require__(/*! ./enum */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/enum.js");
const validation = [
    // number
    limitNumber_1.default,
    multipleOf_1.default,
    // string
    limitLength_1.default,
    pattern_1.default,
    // object
    limitProperties_1.default,
    required_1.default,
    // array
    limitItems_1.default,
    uniqueItems_1.default,
    // any
    { keyword: "type", schemaType: ["string", "array"] },
    { keyword: "nullable", schemaType: "boolean" },
    const_1.default,
    enum_1.default,
];
exports["default"] = validation;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/limitItems.js":
/*!***********************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/limitItems.js ***!
  \***********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const error = {
    message({ keyword, schemaCode }) {
        const comp = keyword === "maxItems" ? "more" : "fewer";
        return (0, codegen_1.str) `must NOT have ${comp} than ${schemaCode} items`;
    },
    params: ({ schemaCode }) => (0, codegen_1._) `{limit: ${schemaCode}}`,
};
const def = {
    keyword: ["maxItems", "minItems"],
    type: "array",
    schemaType: "number",
    $data: true,
    error,
    code(cxt) {
        const { keyword, data, schemaCode } = cxt;
        const op = keyword === "maxItems" ? codegen_1.operators.GT : codegen_1.operators.LT;
        cxt.fail$data((0, codegen_1._) `${data}.length ${op} ${schemaCode}`);
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/limitLength.js":
/*!************************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/limitLength.js ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const ucs2length_1 = __webpack_require__(/*! ../../runtime/ucs2length */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/runtime/ucs2length.js");
const error = {
    message({ keyword, schemaCode }) {
        const comp = keyword === "maxLength" ? "more" : "fewer";
        return (0, codegen_1.str) `must NOT have ${comp} than ${schemaCode} characters`;
    },
    params: ({ schemaCode }) => (0, codegen_1._) `{limit: ${schemaCode}}`,
};
const def = {
    keyword: ["maxLength", "minLength"],
    type: "string",
    schemaType: "number",
    $data: true,
    error,
    code(cxt) {
        const { keyword, data, schemaCode, it } = cxt;
        const op = keyword === "maxLength" ? codegen_1.operators.GT : codegen_1.operators.LT;
        const len = it.opts.unicode === false ? (0, codegen_1._) `${data}.length` : (0, codegen_1._) `${(0, util_1.useFunc)(cxt.gen, ucs2length_1.default)}(${data})`;
        cxt.fail$data((0, codegen_1._) `${len} ${op} ${schemaCode}`);
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/limitNumber.js":
/*!************************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/limitNumber.js ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const ops = codegen_1.operators;
const KWDs = {
    maximum: { okStr: "<=", ok: ops.LTE, fail: ops.GT },
    minimum: { okStr: ">=", ok: ops.GTE, fail: ops.LT },
    exclusiveMaximum: { okStr: "<", ok: ops.LT, fail: ops.GTE },
    exclusiveMinimum: { okStr: ">", ok: ops.GT, fail: ops.LTE },
};
const error = {
    message: ({ keyword, schemaCode }) => (0, codegen_1.str) `must be ${KWDs[keyword].okStr} ${schemaCode}`,
    params: ({ keyword, schemaCode }) => (0, codegen_1._) `{comparison: ${KWDs[keyword].okStr}, limit: ${schemaCode}}`,
};
const def = {
    keyword: Object.keys(KWDs),
    type: "number",
    schemaType: "number",
    $data: true,
    error,
    code(cxt) {
        const { keyword, data, schemaCode } = cxt;
        cxt.fail$data((0, codegen_1._) `${data} ${KWDs[keyword].fail} ${schemaCode} || isNaN(${data})`);
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/limitProperties.js":
/*!****************************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/limitProperties.js ***!
  \****************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const error = {
    message({ keyword, schemaCode }) {
        const comp = keyword === "maxProperties" ? "more" : "fewer";
        return (0, codegen_1.str) `must NOT have ${comp} than ${schemaCode} properties`;
    },
    params: ({ schemaCode }) => (0, codegen_1._) `{limit: ${schemaCode}}`,
};
const def = {
    keyword: ["maxProperties", "minProperties"],
    type: "object",
    schemaType: "number",
    $data: true,
    error,
    code(cxt) {
        const { keyword, data, schemaCode } = cxt;
        const op = keyword === "maxProperties" ? codegen_1.operators.GT : codegen_1.operators.LT;
        cxt.fail$data((0, codegen_1._) `Object.keys(${data}).length ${op} ${schemaCode}`);
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/multipleOf.js":
/*!***********************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/multipleOf.js ***!
  \***********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const error = {
    message: ({ schemaCode }) => (0, codegen_1.str) `must be multiple of ${schemaCode}`,
    params: ({ schemaCode }) => (0, codegen_1._) `{multipleOf: ${schemaCode}}`,
};
const def = {
    keyword: "multipleOf",
    type: "number",
    schemaType: "number",
    $data: true,
    error,
    code(cxt) {
        const { gen, data, schemaCode, it } = cxt;
        // const bdt = bad$DataType(schemaCode, <string>def.schemaType, $data)
        const prec = it.opts.multipleOfPrecision;
        const res = gen.let("res");
        const invalid = prec
            ? (0, codegen_1._) `Math.abs(Math.round(${res}) - ${res}) > 1e-${prec}`
            : (0, codegen_1._) `${res} !== parseInt(${res})`;
        cxt.fail$data((0, codegen_1._) `(${schemaCode} === 0 || (${res} = ${data}/${schemaCode}, ${invalid}))`);
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/pattern.js":
/*!********************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/pattern.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const code_1 = __webpack_require__(/*! ../code */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/code.js");
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const error = {
    message: ({ schemaCode }) => (0, codegen_1.str) `must match pattern "${schemaCode}"`,
    params: ({ schemaCode }) => (0, codegen_1._) `{pattern: ${schemaCode}}`,
};
const def = {
    keyword: "pattern",
    type: "string",
    schemaType: "string",
    $data: true,
    error,
    code(cxt) {
        const { data, $data, schema, schemaCode, it } = cxt;
        // TODO regexp should be wrapped in try/catchs
        const u = it.opts.unicodeRegExp ? "u" : "";
        const regExp = $data ? (0, codegen_1._) `(new RegExp(${schemaCode}, ${u}))` : (0, code_1.usePattern)(cxt, schema);
        cxt.fail$data((0, codegen_1._) `!${regExp}.test(${data})`);
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/required.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/required.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const code_1 = __webpack_require__(/*! ../code */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/code.js");
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const error = {
    message: ({ params: { missingProperty } }) => (0, codegen_1.str) `must have required property '${missingProperty}'`,
    params: ({ params: { missingProperty } }) => (0, codegen_1._) `{missingProperty: ${missingProperty}}`,
};
const def = {
    keyword: "required",
    type: "object",
    schemaType: "array",
    $data: true,
    error,
    code(cxt) {
        const { gen, schema, schemaCode, data, $data, it } = cxt;
        const { opts } = it;
        if (!$data && schema.length === 0)
            return;
        const useLoop = schema.length >= opts.loopRequired;
        if (it.allErrors)
            allErrorsMode();
        else
            exitOnErrorMode();
        if (opts.strictRequired) {
            const props = cxt.parentSchema.properties;
            const { definedProperties } = cxt.it;
            for (const requiredKey of schema) {
                if ((props === null || props === void 0 ? void 0 : props[requiredKey]) === undefined && !definedProperties.has(requiredKey)) {
                    const schemaPath = it.schemaEnv.baseId + it.errSchemaPath;
                    const msg = `required property "${requiredKey}" is not defined at "${schemaPath}" (strictRequired)`;
                    (0, util_1.checkStrictMode)(it, msg, it.opts.strictRequired);
                }
            }
        }
        function allErrorsMode() {
            if (useLoop || $data) {
                cxt.block$data(codegen_1.nil, loopAllRequired);
            }
            else {
                for (const prop of schema) {
                    (0, code_1.checkReportMissingProp)(cxt, prop);
                }
            }
        }
        function exitOnErrorMode() {
            const missing = gen.let("missing");
            if (useLoop || $data) {
                const valid = gen.let("valid", true);
                cxt.block$data(valid, () => loopUntilMissing(missing, valid));
                cxt.ok(valid);
            }
            else {
                gen.if((0, code_1.checkMissingProp)(cxt, schema, missing));
                (0, code_1.reportMissingProp)(cxt, missing);
                gen.else();
            }
        }
        function loopAllRequired() {
            gen.forOf("prop", schemaCode, (prop) => {
                cxt.setParams({ missingProperty: prop });
                gen.if((0, code_1.noPropertyInData)(gen, data, prop, opts.ownProperties), () => cxt.error());
            });
        }
        function loopUntilMissing(missing, valid) {
            cxt.setParams({ missingProperty: missing });
            gen.forOf(missing, schemaCode, () => {
                gen.assign(valid, (0, code_1.propertyInData)(gen, data, missing, opts.ownProperties));
                gen.if((0, codegen_1.not)(valid), () => {
                    cxt.error();
                    gen.break();
                });
            }, codegen_1.nil);
        }
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/uniqueItems.js":
/*!************************************************************************************************************!*\
  !*** ../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/vocabularies/validation/uniqueItems.js ***!
  \************************************************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
const dataType_1 = __webpack_require__(/*! ../../compile/validate/dataType */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/validate/dataType.js");
const codegen_1 = __webpack_require__(/*! ../../compile/codegen */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/codegen/index.js");
const util_1 = __webpack_require__(/*! ../../compile/util */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/compile/util.js");
const equal_1 = __webpack_require__(/*! ../../runtime/equal */ "../../node_modules/@rjsf/validator-ajv8/node_modules/ajv/dist/runtime/equal.js");
const error = {
    message: ({ params: { i, j } }) => (0, codegen_1.str) `must NOT have duplicate items (items ## ${j} and ${i} are identical)`,
    params: ({ params: { i, j } }) => (0, codegen_1._) `{i: ${i}, j: ${j}}`,
};
const def = {
    keyword: "uniqueItems",
    type: "array",
    schemaType: "boolean",
    $data: true,
    error,
    code(cxt) {
        const { gen, data, $data, schema, parentSchema, schemaCode, it } = cxt;
        if (!$data && !schema)
            return;
        const valid = gen.let("valid");
        const itemTypes = parentSchema.items ? (0, dataType_1.getSchemaTypes)(parentSchema.items) : [];
        cxt.block$data(valid, validateUniqueItems, (0, codegen_1._) `${schemaCode} === false`);
        cxt.ok(valid);
        function validateUniqueItems() {
            const i = gen.let("i", (0, codegen_1._) `${data}.length`);
            const j = gen.let("j");
            cxt.setParams({ i, j });
            gen.assign(valid, true);
            gen.if((0, codegen_1._) `${i} > 1`, () => (canOptimize() ? loopN : loopN2)(i, j));
        }
        function canOptimize() {
            return itemTypes.length > 0 && !itemTypes.some((t) => t === "object" || t === "array");
        }
        function loopN(i, j) {
            const item = gen.name("item");
            const wrongType = (0, dataType_1.checkDataTypes)(itemTypes, item, it.opts.strictNumbers, dataType_1.DataType.Wrong);
            const indices = gen.const("indices", (0, codegen_1._) `{}`);
            gen.for((0, codegen_1._) `;${i}--;`, () => {
                gen.let(item, (0, codegen_1._) `${data}[${i}]`);
                gen.if(wrongType, (0, codegen_1._) `continue`);
                if (itemTypes.length > 1)
                    gen.if((0, codegen_1._) `typeof ${item} == "string"`, (0, codegen_1._) `${item} += "_"`);
                gen
                    .if((0, codegen_1._) `typeof ${indices}[${item}] == "number"`, () => {
                    gen.assign(j, (0, codegen_1._) `${indices}[${item}]`);
                    cxt.error();
                    gen.assign(valid, false).break();
                })
                    .code((0, codegen_1._) `${indices}[${item}] = ${i}`);
            });
        }
        function loopN2(i, j) {
            const eql = (0, util_1.useFunc)(gen, equal_1.default);
            const outer = gen.name("outer");
            gen.label(outer).for((0, codegen_1._) `;${i}--;`, () => gen.for((0, codegen_1._) `${j} = ${i}; ${j}--;`, () => gen.if((0, codegen_1._) `${eql}(${data}[${i}], ${data}[${j}])`, () => {
                cxt.error();
                gen.assign(valid, false).break(outer);
            })));
        }
    },
};
exports["default"] = def;


/***/ }),

/***/ "../../node_modules/babel-runtime/core-js/get-iterator.js":
/*!****************************************************************!*\
  !*** ../../node_modules/babel-runtime/core-js/get-iterator.js ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/get-iterator */ "../../node_modules/core-js/library/fn/get-iterator.js"), __esModule: true };

/***/ }),

/***/ "../../node_modules/babel-runtime/core-js/is-iterable.js":
/*!***************************************************************!*\
  !*** ../../node_modules/babel-runtime/core-js/is-iterable.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/is-iterable */ "../../node_modules/core-js/library/fn/is-iterable.js"), __esModule: true };

/***/ }),

/***/ "../../node_modules/babel-runtime/core-js/number/is-safe-integer.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/babel-runtime/core-js/number/is-safe-integer.js ***!
  \**************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/number/is-safe-integer */ "../../node_modules/core-js/library/fn/number/is-safe-integer.js"), __esModule: true };

/***/ }),

/***/ "../../node_modules/babel-runtime/core-js/object/assign.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/babel-runtime/core-js/object/assign.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/object/assign */ "../../node_modules/core-js/library/fn/object/assign.js"), __esModule: true };

/***/ }),

/***/ "../../node_modules/babel-runtime/core-js/object/create.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/babel-runtime/core-js/object/create.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/object/create */ "../../node_modules/core-js/library/fn/object/create.js"), __esModule: true };

/***/ }),

/***/ "../../node_modules/babel-runtime/core-js/object/get-own-property-names.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/babel-runtime/core-js/object/get-own-property-names.js ***!
  \*********************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/object/get-own-property-names */ "../../node_modules/core-js/library/fn/object/get-own-property-names.js"), __esModule: true };

/***/ }),

/***/ "../../node_modules/babel-runtime/core-js/object/keys.js":
/*!***************************************************************!*\
  !*** ../../node_modules/babel-runtime/core-js/object/keys.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/object/keys */ "../../node_modules/core-js/library/fn/object/keys.js"), __esModule: true };

/***/ }),

/***/ "../../node_modules/babel-runtime/core-js/object/set-prototype-of.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/babel-runtime/core-js/object/set-prototype-of.js ***!
  \***************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/object/set-prototype-of */ "../../node_modules/core-js/library/fn/object/set-prototype-of.js"), __esModule: true };

/***/ }),

/***/ "../../node_modules/babel-runtime/core-js/symbol.js":
/*!**********************************************************!*\
  !*** ../../node_modules/babel-runtime/core-js/symbol.js ***!
  \**********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/symbol */ "../../node_modules/core-js/library/fn/symbol/index.js"), __esModule: true };

/***/ }),

/***/ "../../node_modules/babel-runtime/core-js/symbol/iterator.js":
/*!*******************************************************************!*\
  !*** ../../node_modules/babel-runtime/core-js/symbol/iterator.js ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = { "default": __webpack_require__(/*! core-js/library/fn/symbol/iterator */ "../../node_modules/core-js/library/fn/symbol/iterator.js"), __esModule: true };

/***/ }),

/***/ "../../node_modules/babel-runtime/helpers/classCallCheck.js":
/*!******************************************************************!*\
  !*** ../../node_modules/babel-runtime/helpers/classCallCheck.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


exports.__esModule = true;

exports["default"] = function (instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};

/***/ }),

/***/ "../../node_modules/babel-runtime/helpers/extends.js":
/*!***********************************************************!*\
  !*** ../../node_modules/babel-runtime/helpers/extends.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;

var _assign = __webpack_require__(/*! ../core-js/object/assign */ "../../node_modules/babel-runtime/core-js/object/assign.js");

var _assign2 = _interopRequireDefault(_assign);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports["default"] = _assign2.default || function (target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i];

    for (var key in source) {
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }

  return target;
};

/***/ }),

/***/ "../../node_modules/babel-runtime/helpers/inherits.js":
/*!************************************************************!*\
  !*** ../../node_modules/babel-runtime/helpers/inherits.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;

var _setPrototypeOf = __webpack_require__(/*! ../core-js/object/set-prototype-of */ "../../node_modules/babel-runtime/core-js/object/set-prototype-of.js");

var _setPrototypeOf2 = _interopRequireDefault(_setPrototypeOf);

var _create = __webpack_require__(/*! ../core-js/object/create */ "../../node_modules/babel-runtime/core-js/object/create.js");

var _create2 = _interopRequireDefault(_create);

var _typeof2 = __webpack_require__(/*! ../helpers/typeof */ "../../node_modules/babel-runtime/helpers/typeof.js");

var _typeof3 = _interopRequireDefault(_typeof2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports["default"] = function (subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + (typeof superClass === "undefined" ? "undefined" : (0, _typeof3.default)(superClass)));
  }

  subClass.prototype = (0, _create2.default)(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  if (superClass) _setPrototypeOf2.default ? (0, _setPrototypeOf2.default)(subClass, superClass) : subClass.__proto__ = superClass;
};

/***/ }),

/***/ "../../node_modules/babel-runtime/helpers/objectWithoutProperties.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/babel-runtime/helpers/objectWithoutProperties.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";


exports.__esModule = true;

exports["default"] = function (obj, keys) {
  var target = {};

  for (var i in obj) {
    if (keys.indexOf(i) >= 0) continue;
    if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;
    target[i] = obj[i];
  }

  return target;
};

/***/ }),

/***/ "../../node_modules/babel-runtime/helpers/possibleConstructorReturn.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/babel-runtime/helpers/possibleConstructorReturn.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;

var _typeof2 = __webpack_require__(/*! ../helpers/typeof */ "../../node_modules/babel-runtime/helpers/typeof.js");

var _typeof3 = _interopRequireDefault(_typeof2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports["default"] = function (self, call) {
  if (!self) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return call && ((typeof call === "undefined" ? "undefined" : (0, _typeof3.default)(call)) === "object" || typeof call === "function") ? call : self;
};

/***/ }),

/***/ "../../node_modules/babel-runtime/helpers/slicedToArray.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/babel-runtime/helpers/slicedToArray.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;

var _isIterable2 = __webpack_require__(/*! ../core-js/is-iterable */ "../../node_modules/babel-runtime/core-js/is-iterable.js");

var _isIterable3 = _interopRequireDefault(_isIterable2);

var _getIterator2 = __webpack_require__(/*! ../core-js/get-iterator */ "../../node_modules/babel-runtime/core-js/get-iterator.js");

var _getIterator3 = _interopRequireDefault(_getIterator2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports["default"] = function () {
  function sliceIterator(arr, i) {
    var _arr = [];
    var _n = true;
    var _d = false;
    var _e = undefined;

    try {
      for (var _i = (0, _getIterator3.default)(arr), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);

        if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;
      _e = err;
    } finally {
      try {
        if (!_n && _i["return"]) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }

    return _arr;
  }

  return function (arr, i) {
    if (Array.isArray(arr)) {
      return arr;
    } else if ((0, _isIterable3.default)(Object(arr))) {
      return sliceIterator(arr, i);
    } else {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }
  };
}();

/***/ }),

/***/ "../../node_modules/babel-runtime/helpers/typeof.js":
/*!**********************************************************!*\
  !*** ../../node_modules/babel-runtime/helpers/typeof.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;

var _iterator = __webpack_require__(/*! ../core-js/symbol/iterator */ "../../node_modules/babel-runtime/core-js/symbol/iterator.js");

var _iterator2 = _interopRequireDefault(_iterator);

var _symbol = __webpack_require__(/*! ../core-js/symbol */ "../../node_modules/babel-runtime/core-js/symbol.js");

var _symbol2 = _interopRequireDefault(_symbol);

var _typeof = typeof _symbol2.default === "function" && typeof _iterator2.default === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof _symbol2.default === "function" && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : typeof obj; };

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports["default"] = typeof _symbol2.default === "function" && _typeof(_iterator2.default) === "symbol" ? function (obj) {
  return typeof obj === "undefined" ? "undefined" : _typeof(obj);
} : function (obj) {
  return obj && typeof _symbol2.default === "function" && obj.constructor === _symbol2.default && obj !== _symbol2.default.prototype ? "symbol" : typeof obj === "undefined" ? "undefined" : _typeof(obj);
};

/***/ }),

/***/ "../../node_modules/base16/lib/apathy.js":
/*!***********************************************!*\
  !*** ../../node_modules/base16/lib/apathy.js ***!
  \***********************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'apathy',
  author: 'jannik siebert (https://github.com/janniks)',
  base00: '#031A16',
  base01: '#0B342D',
  base02: '#184E45',
  base03: '#2B685E',
  base04: '#5F9C92',
  base05: '#81B5AC',
  base06: '#A7CEC8',
  base07: '#D2E7E4',
  base08: '#3E9688',
  base09: '#3E7996',
  base0A: '#3E4C96',
  base0B: '#883E96',
  base0C: '#963E4C',
  base0D: '#96883E',
  base0E: '#4C963E',
  base0F: '#3E965B'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/ashes.js":
/*!**********************************************!*\
  !*** ../../node_modules/base16/lib/ashes.js ***!
  \**********************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'ashes',
  author: 'jannik siebert (https://github.com/janniks)',
  base00: '#1C2023',
  base01: '#393F45',
  base02: '#565E65',
  base03: '#747C84',
  base04: '#ADB3BA',
  base05: '#C7CCD1',
  base06: '#DFE2E5',
  base07: '#F3F4F5',
  base08: '#C7AE95',
  base09: '#C7C795',
  base0A: '#AEC795',
  base0B: '#95C7AE',
  base0C: '#95AEC7',
  base0D: '#AE95C7',
  base0E: '#C795AE',
  base0F: '#C79595'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/atelier-dune.js":
/*!*****************************************************!*\
  !*** ../../node_modules/base16/lib/atelier-dune.js ***!
  \*****************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'atelier dune',
  author: 'bram de haan (http://atelierbram.github.io/syntax-highlighting/atelier-schemes/dune)',
  base00: '#20201d',
  base01: '#292824',
  base02: '#6e6b5e',
  base03: '#7d7a68',
  base04: '#999580',
  base05: '#a6a28c',
  base06: '#e8e4cf',
  base07: '#fefbec',
  base08: '#d73737',
  base09: '#b65611',
  base0A: '#cfb017',
  base0B: '#60ac39',
  base0C: '#1fad83',
  base0D: '#6684e1',
  base0E: '#b854d4',
  base0F: '#d43552'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/atelier-forest.js":
/*!*******************************************************!*\
  !*** ../../node_modules/base16/lib/atelier-forest.js ***!
  \*******************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'atelier forest',
  author: 'bram de haan (http://atelierbram.github.io/syntax-highlighting/atelier-schemes/forest)',
  base00: '#1b1918',
  base01: '#2c2421',
  base02: '#68615e',
  base03: '#766e6b',
  base04: '#9c9491',
  base05: '#a8a19f',
  base06: '#e6e2e0',
  base07: '#f1efee',
  base08: '#f22c40',
  base09: '#df5320',
  base0A: '#d5911a',
  base0B: '#5ab738',
  base0C: '#00ad9c',
  base0D: '#407ee7',
  base0E: '#6666ea',
  base0F: '#c33ff3'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/atelier-heath.js":
/*!******************************************************!*\
  !*** ../../node_modules/base16/lib/atelier-heath.js ***!
  \******************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'atelier heath',
  author: 'bram de haan (http://atelierbram.github.io/syntax-highlighting/atelier-schemes/heath)',
  base00: '#1b181b',
  base01: '#292329',
  base02: '#695d69',
  base03: '#776977',
  base04: '#9e8f9e',
  base05: '#ab9bab',
  base06: '#d8cad8',
  base07: '#f7f3f7',
  base08: '#ca402b',
  base09: '#a65926',
  base0A: '#bb8a35',
  base0B: '#379a37',
  base0C: '#159393',
  base0D: '#516aec',
  base0E: '#7b59c0',
  base0F: '#cc33cc'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/atelier-lakeside.js":
/*!*********************************************************!*\
  !*** ../../node_modules/base16/lib/atelier-lakeside.js ***!
  \*********************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'atelier lakeside',
  author: 'bram de haan (http://atelierbram.github.io/syntax-highlighting/atelier-schemes/lakeside/)',
  base00: '#161b1d',
  base01: '#1f292e',
  base02: '#516d7b',
  base03: '#5a7b8c',
  base04: '#7195a8',
  base05: '#7ea2b4',
  base06: '#c1e4f6',
  base07: '#ebf8ff',
  base08: '#d22d72',
  base09: '#935c25',
  base0A: '#8a8a0f',
  base0B: '#568c3b',
  base0C: '#2d8f6f',
  base0D: '#257fad',
  base0E: '#5d5db1',
  base0F: '#b72dd2'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/atelier-seaside.js":
/*!********************************************************!*\
  !*** ../../node_modules/base16/lib/atelier-seaside.js ***!
  \********************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'atelier seaside',
  author: 'bram de haan (http://atelierbram.github.io/syntax-highlighting/atelier-schemes/seaside/)',
  base00: '#131513',
  base01: '#242924',
  base02: '#5e6e5e',
  base03: '#687d68',
  base04: '#809980',
  base05: '#8ca68c',
  base06: '#cfe8cf',
  base07: '#f0fff0',
  base08: '#e6193c',
  base09: '#87711d',
  base0A: '#c3c322',
  base0B: '#29a329',
  base0C: '#1999b3',
  base0D: '#3d62f5',
  base0E: '#ad2bee',
  base0F: '#e619c3'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/bespin.js":
/*!***********************************************!*\
  !*** ../../node_modules/base16/lib/bespin.js ***!
  \***********************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'bespin',
  author: 'jan t. sott',
  base00: '#28211c',
  base01: '#36312e',
  base02: '#5e5d5c',
  base03: '#666666',
  base04: '#797977',
  base05: '#8a8986',
  base06: '#9d9b97',
  base07: '#baae9e',
  base08: '#cf6a4c',
  base09: '#cf7d34',
  base0A: '#f9ee98',
  base0B: '#54be0d',
  base0C: '#afc4db',
  base0D: '#5ea6ea',
  base0E: '#9b859d',
  base0F: '#937121'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/brewer.js":
/*!***********************************************!*\
  !*** ../../node_modules/base16/lib/brewer.js ***!
  \***********************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'brewer',
  author: 'timothée poisot (http://github.com/tpoisot)',
  base00: '#0c0d0e',
  base01: '#2e2f30',
  base02: '#515253',
  base03: '#737475',
  base04: '#959697',
  base05: '#b7b8b9',
  base06: '#dadbdc',
  base07: '#fcfdfe',
  base08: '#e31a1c',
  base09: '#e6550d',
  base0A: '#dca060',
  base0B: '#31a354',
  base0C: '#80b1d3',
  base0D: '#3182bd',
  base0E: '#756bb1',
  base0F: '#b15928'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/bright.js":
/*!***********************************************!*\
  !*** ../../node_modules/base16/lib/bright.js ***!
  \***********************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'bright',
  author: 'chris kempson (http://chriskempson.com)',
  base00: '#000000',
  base01: '#303030',
  base02: '#505050',
  base03: '#b0b0b0',
  base04: '#d0d0d0',
  base05: '#e0e0e0',
  base06: '#f5f5f5',
  base07: '#ffffff',
  base08: '#fb0120',
  base09: '#fc6d24',
  base0A: '#fda331',
  base0B: '#a1c659',
  base0C: '#76c7b7',
  base0D: '#6fb3d2',
  base0E: '#d381c3',
  base0F: '#be643c'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/chalk.js":
/*!**********************************************!*\
  !*** ../../node_modules/base16/lib/chalk.js ***!
  \**********************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'chalk',
  author: 'chris kempson (http://chriskempson.com)',
  base00: '#151515',
  base01: '#202020',
  base02: '#303030',
  base03: '#505050',
  base04: '#b0b0b0',
  base05: '#d0d0d0',
  base06: '#e0e0e0',
  base07: '#f5f5f5',
  base08: '#fb9fb1',
  base09: '#eda987',
  base0A: '#ddb26f',
  base0B: '#acc267',
  base0C: '#12cfc0',
  base0D: '#6fc2ef',
  base0E: '#e1a3ee',
  base0F: '#deaf8f'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/codeschool.js":
/*!***************************************************!*\
  !*** ../../node_modules/base16/lib/codeschool.js ***!
  \***************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'codeschool',
  author: 'brettof86',
  base00: '#232c31',
  base01: '#1c3657',
  base02: '#2a343a',
  base03: '#3f4944',
  base04: '#84898c',
  base05: '#9ea7a6',
  base06: '#a7cfa3',
  base07: '#b5d8f6',
  base08: '#2a5491',
  base09: '#43820d',
  base0A: '#a03b1e',
  base0B: '#237986',
  base0C: '#b02f30',
  base0D: '#484d79',
  base0E: '#c59820',
  base0F: '#c98344'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/colors.js":
/*!***********************************************!*\
  !*** ../../node_modules/base16/lib/colors.js ***!
  \***********************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'colors',
  author: 'mrmrs (http://clrs.cc)',
  base00: '#111111',
  base01: '#333333',
  base02: '#555555',
  base03: '#777777',
  base04: '#999999',
  base05: '#bbbbbb',
  base06: '#dddddd',
  base07: '#ffffff',
  base08: '#ff4136',
  base09: '#ff851b',
  base0A: '#ffdc00',
  base0B: '#2ecc40',
  base0C: '#7fdbff',
  base0D: '#0074d9',
  base0E: '#b10dc9',
  base0F: '#85144b'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/default.js":
/*!************************************************!*\
  !*** ../../node_modules/base16/lib/default.js ***!
  \************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'default',
  author: 'chris kempson (http://chriskempson.com)',
  base00: '#181818',
  base01: '#282828',
  base02: '#383838',
  base03: '#585858',
  base04: '#b8b8b8',
  base05: '#d8d8d8',
  base06: '#e8e8e8',
  base07: '#f8f8f8',
  base08: '#ab4642',
  base09: '#dc9656',
  base0A: '#f7ca88',
  base0B: '#a1b56c',
  base0C: '#86c1b9',
  base0D: '#7cafc2',
  base0E: '#ba8baf',
  base0F: '#a16946'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/eighties.js":
/*!*************************************************!*\
  !*** ../../node_modules/base16/lib/eighties.js ***!
  \*************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'eighties',
  author: 'chris kempson (http://chriskempson.com)',
  base00: '#2d2d2d',
  base01: '#393939',
  base02: '#515151',
  base03: '#747369',
  base04: '#a09f93',
  base05: '#d3d0c8',
  base06: '#e8e6df',
  base07: '#f2f0ec',
  base08: '#f2777a',
  base09: '#f99157',
  base0A: '#ffcc66',
  base0B: '#99cc99',
  base0C: '#66cccc',
  base0D: '#6699cc',
  base0E: '#cc99cc',
  base0F: '#d27b53'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/embers.js":
/*!***********************************************!*\
  !*** ../../node_modules/base16/lib/embers.js ***!
  \***********************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'embers',
  author: 'jannik siebert (https://github.com/janniks)',
  base00: '#16130F',
  base01: '#2C2620',
  base02: '#433B32',
  base03: '#5A5047',
  base04: '#8A8075',
  base05: '#A39A90',
  base06: '#BEB6AE',
  base07: '#DBD6D1',
  base08: '#826D57',
  base09: '#828257',
  base0A: '#6D8257',
  base0B: '#57826D',
  base0C: '#576D82',
  base0D: '#6D5782',
  base0E: '#82576D',
  base0F: '#825757'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/flat.js":
/*!*********************************************!*\
  !*** ../../node_modules/base16/lib/flat.js ***!
  \*********************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'flat',
  author: 'chris kempson (http://chriskempson.com)',
  base00: '#2C3E50',
  base01: '#34495E',
  base02: '#7F8C8D',
  base03: '#95A5A6',
  base04: '#BDC3C7',
  base05: '#e0e0e0',
  base06: '#f5f5f5',
  base07: '#ECF0F1',
  base08: '#E74C3C',
  base09: '#E67E22',
  base0A: '#F1C40F',
  base0B: '#2ECC71',
  base0C: '#1ABC9C',
  base0D: '#3498DB',
  base0E: '#9B59B6',
  base0F: '#be643c'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/google.js":
/*!***********************************************!*\
  !*** ../../node_modules/base16/lib/google.js ***!
  \***********************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'google',
  author: 'seth wright (http://sethawright.com)',
  base00: '#1d1f21',
  base01: '#282a2e',
  base02: '#373b41',
  base03: '#969896',
  base04: '#b4b7b4',
  base05: '#c5c8c6',
  base06: '#e0e0e0',
  base07: '#ffffff',
  base08: '#CC342B',
  base09: '#F96A38',
  base0A: '#FBA922',
  base0B: '#198844',
  base0C: '#3971ED',
  base0D: '#3971ED',
  base0E: '#A36AC7',
  base0F: '#3971ED'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/grayscale.js":
/*!**************************************************!*\
  !*** ../../node_modules/base16/lib/grayscale.js ***!
  \**************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'grayscale',
  author: 'alexandre gavioli (https://github.com/alexx2/)',
  base00: '#101010',
  base01: '#252525',
  base02: '#464646',
  base03: '#525252',
  base04: '#ababab',
  base05: '#b9b9b9',
  base06: '#e3e3e3',
  base07: '#f7f7f7',
  base08: '#7c7c7c',
  base09: '#999999',
  base0A: '#a0a0a0',
  base0B: '#8e8e8e',
  base0C: '#868686',
  base0D: '#686868',
  base0E: '#747474',
  base0F: '#5e5e5e'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/greenscreen.js":
/*!****************************************************!*\
  !*** ../../node_modules/base16/lib/greenscreen.js ***!
  \****************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'green screen',
  author: 'chris kempson (http://chriskempson.com)',
  base00: '#001100',
  base01: '#003300',
  base02: '#005500',
  base03: '#007700',
  base04: '#009900',
  base05: '#00bb00',
  base06: '#00dd00',
  base07: '#00ff00',
  base08: '#007700',
  base09: '#009900',
  base0A: '#007700',
  base0B: '#00bb00',
  base0C: '#005500',
  base0D: '#009900',
  base0E: '#00bb00',
  base0F: '#005500'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/harmonic.js":
/*!*************************************************!*\
  !*** ../../node_modules/base16/lib/harmonic.js ***!
  \*************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'harmonic16',
  author: 'jannik siebert (https://github.com/janniks)',
  base00: '#0b1c2c',
  base01: '#223b54',
  base02: '#405c79',
  base03: '#627e99',
  base04: '#aabcce',
  base05: '#cbd6e2',
  base06: '#e5ebf1',
  base07: '#f7f9fb',
  base08: '#bf8b56',
  base09: '#bfbf56',
  base0A: '#8bbf56',
  base0B: '#56bf8b',
  base0C: '#568bbf',
  base0D: '#8b56bf',
  base0E: '#bf568b',
  base0F: '#bf5656'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/hopscotch.js":
/*!**************************************************!*\
  !*** ../../node_modules/base16/lib/hopscotch.js ***!
  \**************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'hopscotch',
  author: 'jan t. sott',
  base00: '#322931',
  base01: '#433b42',
  base02: '#5c545b',
  base03: '#797379',
  base04: '#989498',
  base05: '#b9b5b8',
  base06: '#d5d3d5',
  base07: '#ffffff',
  base08: '#dd464c',
  base09: '#fd8b19',
  base0A: '#fdcc59',
  base0B: '#8fc13e',
  base0C: '#149b93',
  base0D: '#1290bf',
  base0E: '#c85e7c',
  base0F: '#b33508'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/index.js":
/*!**********************************************!*\
  !*** ../../node_modules/base16/lib/index.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";


exports.__esModule = true;

function _interopRequire(obj) { return obj && obj.__esModule ? obj['default'] : obj; }

var _threezerotwofour = __webpack_require__(/*! ./threezerotwofour */ "../../node_modules/base16/lib/threezerotwofour.js");

exports.threezerotwofour = _interopRequire(_threezerotwofour);

var _apathy = __webpack_require__(/*! ./apathy */ "../../node_modules/base16/lib/apathy.js");

exports.apathy = _interopRequire(_apathy);

var _ashes = __webpack_require__(/*! ./ashes */ "../../node_modules/base16/lib/ashes.js");

exports.ashes = _interopRequire(_ashes);

var _atelierDune = __webpack_require__(/*! ./atelier-dune */ "../../node_modules/base16/lib/atelier-dune.js");

exports.atelierDune = _interopRequire(_atelierDune);

var _atelierForest = __webpack_require__(/*! ./atelier-forest */ "../../node_modules/base16/lib/atelier-forest.js");

exports.atelierForest = _interopRequire(_atelierForest);

var _atelierHeath = __webpack_require__(/*! ./atelier-heath */ "../../node_modules/base16/lib/atelier-heath.js");

exports.atelierHeath = _interopRequire(_atelierHeath);

var _atelierLakeside = __webpack_require__(/*! ./atelier-lakeside */ "../../node_modules/base16/lib/atelier-lakeside.js");

exports.atelierLakeside = _interopRequire(_atelierLakeside);

var _atelierSeaside = __webpack_require__(/*! ./atelier-seaside */ "../../node_modules/base16/lib/atelier-seaside.js");

exports.atelierSeaside = _interopRequire(_atelierSeaside);

var _bespin = __webpack_require__(/*! ./bespin */ "../../node_modules/base16/lib/bespin.js");

exports.bespin = _interopRequire(_bespin);

var _brewer = __webpack_require__(/*! ./brewer */ "../../node_modules/base16/lib/brewer.js");

exports.brewer = _interopRequire(_brewer);

var _bright = __webpack_require__(/*! ./bright */ "../../node_modules/base16/lib/bright.js");

exports.bright = _interopRequire(_bright);

var _chalk = __webpack_require__(/*! ./chalk */ "../../node_modules/base16/lib/chalk.js");

exports.chalk = _interopRequire(_chalk);

var _codeschool = __webpack_require__(/*! ./codeschool */ "../../node_modules/base16/lib/codeschool.js");

exports.codeschool = _interopRequire(_codeschool);

var _colors = __webpack_require__(/*! ./colors */ "../../node_modules/base16/lib/colors.js");

exports.colors = _interopRequire(_colors);

var _default = __webpack_require__(/*! ./default */ "../../node_modules/base16/lib/default.js");

exports["default"] = _interopRequire(_default);

var _eighties = __webpack_require__(/*! ./eighties */ "../../node_modules/base16/lib/eighties.js");

exports.eighties = _interopRequire(_eighties);

var _embers = __webpack_require__(/*! ./embers */ "../../node_modules/base16/lib/embers.js");

exports.embers = _interopRequire(_embers);

var _flat = __webpack_require__(/*! ./flat */ "../../node_modules/base16/lib/flat.js");

exports.flat = _interopRequire(_flat);

var _google = __webpack_require__(/*! ./google */ "../../node_modules/base16/lib/google.js");

exports.google = _interopRequire(_google);

var _grayscale = __webpack_require__(/*! ./grayscale */ "../../node_modules/base16/lib/grayscale.js");

exports.grayscale = _interopRequire(_grayscale);

var _greenscreen = __webpack_require__(/*! ./greenscreen */ "../../node_modules/base16/lib/greenscreen.js");

exports.greenscreen = _interopRequire(_greenscreen);

var _harmonic = __webpack_require__(/*! ./harmonic */ "../../node_modules/base16/lib/harmonic.js");

exports.harmonic = _interopRequire(_harmonic);

var _hopscotch = __webpack_require__(/*! ./hopscotch */ "../../node_modules/base16/lib/hopscotch.js");

exports.hopscotch = _interopRequire(_hopscotch);

var _isotope = __webpack_require__(/*! ./isotope */ "../../node_modules/base16/lib/isotope.js");

exports.isotope = _interopRequire(_isotope);

var _marrakesh = __webpack_require__(/*! ./marrakesh */ "../../node_modules/base16/lib/marrakesh.js");

exports.marrakesh = _interopRequire(_marrakesh);

var _mocha = __webpack_require__(/*! ./mocha */ "../../node_modules/base16/lib/mocha.js");

exports.mocha = _interopRequire(_mocha);

var _monokai = __webpack_require__(/*! ./monokai */ "../../node_modules/base16/lib/monokai.js");

exports.monokai = _interopRequire(_monokai);

var _ocean = __webpack_require__(/*! ./ocean */ "../../node_modules/base16/lib/ocean.js");

exports.ocean = _interopRequire(_ocean);

var _paraiso = __webpack_require__(/*! ./paraiso */ "../../node_modules/base16/lib/paraiso.js");

exports.paraiso = _interopRequire(_paraiso);

var _pop = __webpack_require__(/*! ./pop */ "../../node_modules/base16/lib/pop.js");

exports.pop = _interopRequire(_pop);

var _railscasts = __webpack_require__(/*! ./railscasts */ "../../node_modules/base16/lib/railscasts.js");

exports.railscasts = _interopRequire(_railscasts);

var _shapeshifter = __webpack_require__(/*! ./shapeshifter */ "../../node_modules/base16/lib/shapeshifter.js");

exports.shapeshifter = _interopRequire(_shapeshifter);

var _solarized = __webpack_require__(/*! ./solarized */ "../../node_modules/base16/lib/solarized.js");

exports.solarized = _interopRequire(_solarized);

var _summerfruit = __webpack_require__(/*! ./summerfruit */ "../../node_modules/base16/lib/summerfruit.js");

exports.summerfruit = _interopRequire(_summerfruit);

var _tomorrow = __webpack_require__(/*! ./tomorrow */ "../../node_modules/base16/lib/tomorrow.js");

exports.tomorrow = _interopRequire(_tomorrow);

var _tube = __webpack_require__(/*! ./tube */ "../../node_modules/base16/lib/tube.js");

exports.tube = _interopRequire(_tube);

var _twilight = __webpack_require__(/*! ./twilight */ "../../node_modules/base16/lib/twilight.js");

exports.twilight = _interopRequire(_twilight);

/***/ }),

/***/ "../../node_modules/base16/lib/isotope.js":
/*!************************************************!*\
  !*** ../../node_modules/base16/lib/isotope.js ***!
  \************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'isotope',
  author: 'jan t. sott',
  base00: '#000000',
  base01: '#404040',
  base02: '#606060',
  base03: '#808080',
  base04: '#c0c0c0',
  base05: '#d0d0d0',
  base06: '#e0e0e0',
  base07: '#ffffff',
  base08: '#ff0000',
  base09: '#ff9900',
  base0A: '#ff0099',
  base0B: '#33ff00',
  base0C: '#00ffff',
  base0D: '#0066ff',
  base0E: '#cc00ff',
  base0F: '#3300ff'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/marrakesh.js":
/*!**************************************************!*\
  !*** ../../node_modules/base16/lib/marrakesh.js ***!
  \**************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'marrakesh',
  author: 'alexandre gavioli (http://github.com/alexx2/)',
  base00: '#201602',
  base01: '#302e00',
  base02: '#5f5b17',
  base03: '#6c6823',
  base04: '#86813b',
  base05: '#948e48',
  base06: '#ccc37a',
  base07: '#faf0a5',
  base08: '#c35359',
  base09: '#b36144',
  base0A: '#a88339',
  base0B: '#18974e',
  base0C: '#75a738',
  base0D: '#477ca1',
  base0E: '#8868b3',
  base0F: '#b3588e'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/mocha.js":
/*!**********************************************!*\
  !*** ../../node_modules/base16/lib/mocha.js ***!
  \**********************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'mocha',
  author: 'chris kempson (http://chriskempson.com)',
  base00: '#3B3228',
  base01: '#534636',
  base02: '#645240',
  base03: '#7e705a',
  base04: '#b8afad',
  base05: '#d0c8c6',
  base06: '#e9e1dd',
  base07: '#f5eeeb',
  base08: '#cb6077',
  base09: '#d28b71',
  base0A: '#f4bc87',
  base0B: '#beb55b',
  base0C: '#7bbda4',
  base0D: '#8ab3b5',
  base0E: '#a89bb9',
  base0F: '#bb9584'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/monokai.js":
/*!************************************************!*\
  !*** ../../node_modules/base16/lib/monokai.js ***!
  \************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'monokai',
  author: 'wimer hazenberg (http://www.monokai.nl)',
  base00: '#272822',
  base01: '#383830',
  base02: '#49483e',
  base03: '#75715e',
  base04: '#a59f85',
  base05: '#f8f8f2',
  base06: '#f5f4f1',
  base07: '#f9f8f5',
  base08: '#f92672',
  base09: '#fd971f',
  base0A: '#f4bf75',
  base0B: '#a6e22e',
  base0C: '#a1efe4',
  base0D: '#66d9ef',
  base0E: '#ae81ff',
  base0F: '#cc6633'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/ocean.js":
/*!**********************************************!*\
  !*** ../../node_modules/base16/lib/ocean.js ***!
  \**********************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'ocean',
  author: 'chris kempson (http://chriskempson.com)',
  base00: '#2b303b',
  base01: '#343d46',
  base02: '#4f5b66',
  base03: '#65737e',
  base04: '#a7adba',
  base05: '#c0c5ce',
  base06: '#dfe1e8',
  base07: '#eff1f5',
  base08: '#bf616a',
  base09: '#d08770',
  base0A: '#ebcb8b',
  base0B: '#a3be8c',
  base0C: '#96b5b4',
  base0D: '#8fa1b3',
  base0E: '#b48ead',
  base0F: '#ab7967'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/paraiso.js":
/*!************************************************!*\
  !*** ../../node_modules/base16/lib/paraiso.js ***!
  \************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'paraiso',
  author: 'jan t. sott',
  base00: '#2f1e2e',
  base01: '#41323f',
  base02: '#4f424c',
  base03: '#776e71',
  base04: '#8d8687',
  base05: '#a39e9b',
  base06: '#b9b6b0',
  base07: '#e7e9db',
  base08: '#ef6155',
  base09: '#f99b15',
  base0A: '#fec418',
  base0B: '#48b685',
  base0C: '#5bc4bf',
  base0D: '#06b6ef',
  base0E: '#815ba4',
  base0F: '#e96ba8'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/pop.js":
/*!********************************************!*\
  !*** ../../node_modules/base16/lib/pop.js ***!
  \********************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'pop',
  author: 'chris kempson (http://chriskempson.com)',
  base00: '#000000',
  base01: '#202020',
  base02: '#303030',
  base03: '#505050',
  base04: '#b0b0b0',
  base05: '#d0d0d0',
  base06: '#e0e0e0',
  base07: '#ffffff',
  base08: '#eb008a',
  base09: '#f29333',
  base0A: '#f8ca12',
  base0B: '#37b349',
  base0C: '#00aabb',
  base0D: '#0e5a94',
  base0E: '#b31e8d',
  base0F: '#7a2d00'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/railscasts.js":
/*!***************************************************!*\
  !*** ../../node_modules/base16/lib/railscasts.js ***!
  \***************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'railscasts',
  author: 'ryan bates (http://railscasts.com)',
  base00: '#2b2b2b',
  base01: '#272935',
  base02: '#3a4055',
  base03: '#5a647e',
  base04: '#d4cfc9',
  base05: '#e6e1dc',
  base06: '#f4f1ed',
  base07: '#f9f7f3',
  base08: '#da4939',
  base09: '#cc7833',
  base0A: '#ffc66d',
  base0B: '#a5c261',
  base0C: '#519f50',
  base0D: '#6d9cbe',
  base0E: '#b6b3eb',
  base0F: '#bc9458'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/shapeshifter.js":
/*!*****************************************************!*\
  !*** ../../node_modules/base16/lib/shapeshifter.js ***!
  \*****************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'shapeshifter',
  author: 'tyler benziger (http://tybenz.com)',
  base00: '#000000',
  base01: '#040404',
  base02: '#102015',
  base03: '#343434',
  base04: '#555555',
  base05: '#ababab',
  base06: '#e0e0e0',
  base07: '#f9f9f9',
  base08: '#e92f2f',
  base09: '#e09448',
  base0A: '#dddd13',
  base0B: '#0ed839',
  base0C: '#23edda',
  base0D: '#3b48e3',
  base0E: '#f996e2',
  base0F: '#69542d'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/solarized.js":
/*!**************************************************!*\
  !*** ../../node_modules/base16/lib/solarized.js ***!
  \**************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'solarized',
  author: 'ethan schoonover (http://ethanschoonover.com/solarized)',
  base00: '#002b36',
  base01: '#073642',
  base02: '#586e75',
  base03: '#657b83',
  base04: '#839496',
  base05: '#93a1a1',
  base06: '#eee8d5',
  base07: '#fdf6e3',
  base08: '#dc322f',
  base09: '#cb4b16',
  base0A: '#b58900',
  base0B: '#859900',
  base0C: '#2aa198',
  base0D: '#268bd2',
  base0E: '#6c71c4',
  base0F: '#d33682'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/summerfruit.js":
/*!****************************************************!*\
  !*** ../../node_modules/base16/lib/summerfruit.js ***!
  \****************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'summerfruit',
  author: 'christopher corley (http://cscorley.github.io/)',
  base00: '#151515',
  base01: '#202020',
  base02: '#303030',
  base03: '#505050',
  base04: '#B0B0B0',
  base05: '#D0D0D0',
  base06: '#E0E0E0',
  base07: '#FFFFFF',
  base08: '#FF0086',
  base09: '#FD8900',
  base0A: '#ABA800',
  base0B: '#00C918',
  base0C: '#1faaaa',
  base0D: '#3777E6',
  base0E: '#AD00A1',
  base0F: '#cc6633'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/threezerotwofour.js":
/*!*********************************************************!*\
  !*** ../../node_modules/base16/lib/threezerotwofour.js ***!
  \*********************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'threezerotwofour',
  author: 'jan t. sott (http://github.com/idleberg)',
  base00: '#090300',
  base01: '#3a3432',
  base02: '#4a4543',
  base03: '#5c5855',
  base04: '#807d7c',
  base05: '#a5a2a2',
  base06: '#d6d5d4',
  base07: '#f7f7f7',
  base08: '#db2d20',
  base09: '#e8bbd0',
  base0A: '#fded02',
  base0B: '#01a252',
  base0C: '#b5e4f4',
  base0D: '#01a0e4',
  base0E: '#a16a94',
  base0F: '#cdab53'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/tomorrow.js":
/*!*************************************************!*\
  !*** ../../node_modules/base16/lib/tomorrow.js ***!
  \*************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'tomorrow',
  author: 'chris kempson (http://chriskempson.com)',
  base00: '#1d1f21',
  base01: '#282a2e',
  base02: '#373b41',
  base03: '#969896',
  base04: '#b4b7b4',
  base05: '#c5c8c6',
  base06: '#e0e0e0',
  base07: '#ffffff',
  base08: '#cc6666',
  base09: '#de935f',
  base0A: '#f0c674',
  base0B: '#b5bd68',
  base0C: '#8abeb7',
  base0D: '#81a2be',
  base0E: '#b294bb',
  base0F: '#a3685a'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/tube.js":
/*!*********************************************!*\
  !*** ../../node_modules/base16/lib/tube.js ***!
  \*********************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'london tube',
  author: 'jan t. sott',
  base00: '#231f20',
  base01: '#1c3f95',
  base02: '#5a5758',
  base03: '#737171',
  base04: '#959ca1',
  base05: '#d9d8d8',
  base06: '#e7e7e8',
  base07: '#ffffff',
  base08: '#ee2e24',
  base09: '#f386a1',
  base0A: '#ffd204',
  base0B: '#00853e',
  base0C: '#85cebc',
  base0D: '#009ddc',
  base0E: '#98005d',
  base0F: '#b06110'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/base16/lib/twilight.js":
/*!*************************************************!*\
  !*** ../../node_modules/base16/lib/twilight.js ***!
  \*************************************************/
/***/ ((module, exports) => {

"use strict";


exports.__esModule = true;
exports["default"] = {
  scheme: 'twilight',
  author: 'david hart (http://hart-dev.com)',
  base00: '#1e1e1e',
  base01: '#323537',
  base02: '#464b50',
  base03: '#5f5a60',
  base04: '#838184',
  base05: '#a7a7a7',
  base06: '#c3c3c3',
  base07: '#ffffff',
  base08: '#cf6a4c',
  base09: '#cda869',
  base0A: '#f9ee98',
  base0B: '#8f9d6a',
  base0C: '#afc4db',
  base0D: '#7587a6',
  base0E: '#9b859d',
  base0F: '#9b703f'
};
module.exports = exports['default'];

/***/ }),

/***/ "../../node_modules/compute-gcd/lib/index.js":
/*!***************************************************!*\
  !*** ../../node_modules/compute-gcd/lib/index.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


// MODULES //

var isArray = __webpack_require__( /*! validate.io-array */ "../../node_modules/validate.io-array/lib/index.js" ),
	isIntegerArray = __webpack_require__( /*! validate.io-integer-array */ "../../node_modules/validate.io-integer-array/lib/index.js" ),
	isFunction = __webpack_require__( /*! validate.io-function */ "../../node_modules/validate.io-function/lib/index.js" );


// VARIABLES //

var MAXINT = Math.pow( 2, 31 ) - 1;


// FUNCTIONS //

/**
* FUNCTION: gcd( a, b )
*	Computes the greatest common divisor of two integers `a` and `b`, using the binary GCD algorithm.
*
* @param {Number} a - integer
* @param {Number} b - integer
* @returns {Number} greatest common divisor
*/
function gcd( a, b ) {
	var k = 1,
		t;
	// Simple cases:
	if ( a === 0 ) {
		return b;
	}
	if ( b === 0 ) {
		return a;
	}
	// Reduce `a` and/or `b` to odd numbers and keep track of the greatest power of 2 dividing both `a` and `b`...
	while ( a%2 === 0 && b%2 === 0 ) {
		a = a / 2; // right shift
		b = b / 2; // right shift
		k = k * 2; // left shift
	}
	// Reduce `a` to an odd number...
	while ( a%2 === 0 ) {
		a = a / 2; // right shift
	}
	// Henceforth, `a` is always odd...
	while ( b ) {
		// Remove all factors of 2 in `b`, as they are not common...
		while ( b%2 === 0 ) {
			b = b / 2; // right shift
		}
		// `a` and `b` are both odd. Swap values such that `b` is the larger of the two values, and then set `b` to the difference (which is even)...
		if ( a > b ) {
			t = b;
			b = a;
			a = t;
		}
		b = b - a; // b=0 iff b=a
	}
	// Restore common factors of 2...
	return k * a;
} // end FUNCTION gcd()

/**
* FUNCTION: bitwise( a, b )
*	Computes the greatest common divisor of two integers `a` and `b`, using the binary GCD algorithm and bitwise operations.
*
* @param {Number} a - safe integer
* @param {Number} b - safe integer
* @returns {Number} greatest common divisor
*/
function bitwise( a, b ) {
	var k = 0,
		t;
	// Simple cases:
	if ( a === 0 ) {
		return b;
	}
	if ( b === 0 ) {
		return a;
	}
	// Reduce `a` and/or `b` to odd numbers and keep track of the greatest power of 2 dividing both `a` and `b`...
	while ( (a & 1) === 0 && (b & 1) === 0 ) {
		a >>>= 1; // right shift
		b >>>= 1; // right shift
		k++;
	}
	// Reduce `a` to an odd number...
	while ( (a & 1) === 0 ) {
		a >>>= 1; // right shift
	}
	// Henceforth, `a` is always odd...
	while ( b ) {
		// Remove all factors of 2 in `b`, as they are not common...
		while ( (b & 1) === 0 ) {
			b >>>= 1; // right shift
		}
		// `a` and `b` are both odd. Swap values such that `b` is the larger of the two values, and then set `b` to the difference (which is even)...
		if ( a > b ) {
			t = b;
			b = a;
			a = t;
		}
		b = b - a; // b=0 iff b=a
	}
	// Restore common factors of 2...
	return a << k;
} // end FUNCTION bitwise()


// GREATEST COMMON DIVISOR //

/**
* FUNCTION: compute( arr[, clbk] )
*	Computes the greatest common divisor.
*
* @param {Number[]|Number} arr - input array of integers
* @param {Function|Number} [clbk] - accessor function for accessing array values
* @returns {Number|Null} greatest common divisor or null
*/
function compute() {
	var nargs = arguments.length,
		args,
		clbk,
		arr,
		len,
		a, b,
		i;

	// Copy the input arguments to an array...
	args = new Array( nargs );
	for ( i = 0; i < nargs; i++ ) {
		args[ i ] = arguments[ i ];
	}
	// Have we been provided with integer arguments?
	if ( isIntegerArray( args ) ) {
		if ( nargs === 2 ) {
			a = args[ 0 ];
			b = args[ 1 ];
			if ( a < 0 ) {
				a = -a;
			}
			if ( b < 0 ) {
				b = -b;
			}
			if ( a <= MAXINT && b <= MAXINT ) {
				return bitwise( a, b );
			} else {
				return gcd( a, b );
			}
		}
		arr = args;
	}
	// If not integers, ensure the first argument is an array...
	else if ( !isArray( args[ 0 ] ) ) {
		throw new TypeError( 'gcd()::invalid input argument. Must provide an array of integers. Value: `' + args[ 0 ] + '`.' );
	}
	// Have we been provided with more than one argument? If so, ensure that the accessor argument is a function...
	else if ( nargs > 1 ) {
		arr = args[ 0 ];
		clbk = args[ 1 ];
		if ( !isFunction( clbk ) ) {
			throw new TypeError( 'gcd()::invalid input argument. Accessor must be a function. Value: `' + clbk + '`.' );
		}
	}
	// We have been provided an array...
	else {
		arr = args[ 0 ];
	}
	len = arr.length;

	// Check if a sufficient number of values have been provided...
	if ( len < 2 ) {
		return null;
	}
	// If an accessor is provided, extract the array values...
	if ( clbk ) {
		a = new Array( len );
		for ( i = 0; i < len; i++ ) {
			a[ i ] = clbk( arr[ i ], i );
		}
		arr = a;
	}
	// Given an input array, ensure all array values are integers...
	if ( nargs < 3 ) {
		if ( !isIntegerArray( arr ) ) {
			throw new TypeError( 'gcd()::invalid input argument. Accessed array values must be integers. Value: `' + arr + '`.' );
		}
	}
	// Convert any negative integers to positive integers...
	for ( i = 0; i < len; i++ ) {
		a = arr[ i ];
		if ( a < 0 ) {
			arr[ i ] = -a;
		}
	}
	// Exploit the fact that the gcd is an associative function...
	a = arr[ 0 ];
	for ( i = 1; i < len; i++ ) {
		b = arr[ i ];
		if ( b <= MAXINT && a <= MAXINT ) {
			a = bitwise( a, b );
		} else {
			a = gcd( a, b );
		}
	}
	return a;
} // end FUNCTION compute()


// EXPORTS //

module.exports = compute;


/***/ }),

/***/ "../../node_modules/compute-lcm/lib/index.js":
/*!***************************************************!*\
  !*** ../../node_modules/compute-lcm/lib/index.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


// MODULES //

var gcd = __webpack_require__( /*! compute-gcd */ "../../node_modules/compute-gcd/lib/index.js" ),
	isArray = __webpack_require__( /*! validate.io-array */ "../../node_modules/validate.io-array/lib/index.js" ),
	isIntegerArray = __webpack_require__( /*! validate.io-integer-array */ "../../node_modules/validate.io-integer-array/lib/index.js" ),
	isFunction = __webpack_require__( /*! validate.io-function */ "../../node_modules/validate.io-function/lib/index.js" );


// LEAST COMMON MULTIPLE //

/**
* FUNCTION: lcm( arr[, clbk] )
*	Computes the least common multiple (lcm).
*
* @param {Number[]|Number} arr - input array of integers
* @param {Function|Number} [accessor] - accessor function for accessing array values
* @returns {Number|Null} least common multiple or null
*/
function lcm() {
	var nargs = arguments.length,
		args,
		clbk,
		arr,
		len,
		a, b,
		i;

	// Copy the input arguments to an array...
	args = new Array( nargs );
	for ( i = 0; i < nargs; i++ ) {
		args[ i ] = arguments[ i ];
	}
	// Have we been provided with integer arguments?
	if ( isIntegerArray( args ) ) {
		if ( nargs === 2 ) {
			a = args[ 0 ];
			b = args[ 1 ];
			if ( a < 0 ) {
				a = -a;
			}
			if ( b < 0 ) {
				b = -b;
			}
			if ( a === 0 || b === 0 ) {
				return 0;
			}
			return ( a/gcd(a,b) ) * b;
		}
		arr = args;
	}
	// If not integers, ensure that the first argument is an array...
	else if ( !isArray( args[ 0 ] ) ) {
		throw new TypeError( 'lcm()::invalid input argument. Must provide an array of integers. Value: `' + args[ 0 ] + '`.' );
	}
	// Have we been provided with more than one argument? If so, ensure that the accessor argument is a function...
	else if ( nargs > 1 ) {
		arr = args[ 0 ];
		clbk = args[ 1 ];
		if ( !isFunction( clbk ) ) {
			throw new TypeError( 'lcm()::invalid input argument. Accessor must be a function. Value: `' + clbk + '`.' );
		}
	}
	// We have been provided an array...
	else {
		arr = args[ 0 ];
	}
	len = arr.length;

	// Check if a sufficient number of values have been provided...
	if ( len < 2 ) {
		return null;
	}
	// If an accessor is provided, extract the array values...
	if ( clbk ) {
		a = new Array( len );
		for ( i = 0; i < len; i++ ) {
			a[ i ] = clbk( arr[ i ], i );
		}
		arr = a;
	}
	// Given an input array, ensure all array values are integers...
	if ( nargs < 3 ) {
		if ( !isIntegerArray( arr ) ) {
			throw new TypeError( 'lcm()::invalid input argument. Accessed array values must be integers. Value: `' + arr + '`.' );
		}
	}
	// Convert any negative integers to positive integers...
	for ( i = 0; i < len; i++ ) {
		a = arr[ i ];
		if ( a < 0 ) {
			arr[ i ] = -a;
		}
	}
	// Exploit the fact that the lcm is an associative function...
	a = arr[ 0 ];
	for ( i = 1; i < len; i++ ) {
		b = arr[ i ];
		if ( a === 0 || b === 0 ) {
			return 0;
		}
		a = ( a/gcd(a,b) ) * b;
	}
	return a;
} // end FUNCTION lcm()


// EXPORTS //

module.exports = lcm;


/***/ }),

/***/ "../../node_modules/core-js/library/fn/get-iterator.js":
/*!*************************************************************!*\
  !*** ../../node_modules/core-js/library/fn/get-iterator.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ../modules/web.dom.iterable */ "../../node_modules/core-js/library/modules/web.dom.iterable.js");
__webpack_require__(/*! ../modules/es6.string.iterator */ "../../node_modules/core-js/library/modules/es6.string.iterator.js");
module.exports = __webpack_require__(/*! ../modules/core.get-iterator */ "../../node_modules/core-js/library/modules/core.get-iterator.js");


/***/ }),

/***/ "../../node_modules/core-js/library/fn/is-iterable.js":
/*!************************************************************!*\
  !*** ../../node_modules/core-js/library/fn/is-iterable.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ../modules/web.dom.iterable */ "../../node_modules/core-js/library/modules/web.dom.iterable.js");
__webpack_require__(/*! ../modules/es6.string.iterator */ "../../node_modules/core-js/library/modules/es6.string.iterator.js");
module.exports = __webpack_require__(/*! ../modules/core.is-iterable */ "../../node_modules/core-js/library/modules/core.is-iterable.js");


/***/ }),

/***/ "../../node_modules/core-js/library/fn/number/is-safe-integer.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/core-js/library/fn/number/is-safe-integer.js ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ../../modules/es6.number.is-safe-integer */ "../../node_modules/core-js/library/modules/es6.number.is-safe-integer.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "../../node_modules/core-js/library/modules/_core.js").Number.isSafeInteger;


/***/ }),

/***/ "../../node_modules/core-js/library/fn/object/assign.js":
/*!**************************************************************!*\
  !*** ../../node_modules/core-js/library/fn/object/assign.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ../../modules/es6.object.assign */ "../../node_modules/core-js/library/modules/es6.object.assign.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "../../node_modules/core-js/library/modules/_core.js").Object.assign;


/***/ }),

/***/ "../../node_modules/core-js/library/fn/object/create.js":
/*!**************************************************************!*\
  !*** ../../node_modules/core-js/library/fn/object/create.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ../../modules/es6.object.create */ "../../node_modules/core-js/library/modules/es6.object.create.js");
var $Object = (__webpack_require__(/*! ../../modules/_core */ "../../node_modules/core-js/library/modules/_core.js").Object);
module.exports = function create(P, D) {
  return $Object.create(P, D);
};


/***/ }),

/***/ "../../node_modules/core-js/library/fn/object/get-own-property-names.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/core-js/library/fn/object/get-own-property-names.js ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ../../modules/es6.object.get-own-property-names */ "../../node_modules/core-js/library/modules/es6.object.get-own-property-names.js");
var $Object = (__webpack_require__(/*! ../../modules/_core */ "../../node_modules/core-js/library/modules/_core.js").Object);
module.exports = function getOwnPropertyNames(it) {
  return $Object.getOwnPropertyNames(it);
};


/***/ }),

/***/ "../../node_modules/core-js/library/fn/object/keys.js":
/*!************************************************************!*\
  !*** ../../node_modules/core-js/library/fn/object/keys.js ***!
  \************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ../../modules/es6.object.keys */ "../../node_modules/core-js/library/modules/es6.object.keys.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "../../node_modules/core-js/library/modules/_core.js").Object.keys;


/***/ }),

/***/ "../../node_modules/core-js/library/fn/object/set-prototype-of.js":
/*!************************************************************************!*\
  !*** ../../node_modules/core-js/library/fn/object/set-prototype-of.js ***!
  \************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ../../modules/es6.object.set-prototype-of */ "../../node_modules/core-js/library/modules/es6.object.set-prototype-of.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "../../node_modules/core-js/library/modules/_core.js").Object.setPrototypeOf;


/***/ }),

/***/ "../../node_modules/core-js/library/fn/symbol/index.js":
/*!*************************************************************!*\
  !*** ../../node_modules/core-js/library/fn/symbol/index.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ../../modules/es6.symbol */ "../../node_modules/core-js/library/modules/es6.symbol.js");
__webpack_require__(/*! ../../modules/es6.object.to-string */ "../../node_modules/core-js/library/modules/es6.object.to-string.js");
__webpack_require__(/*! ../../modules/es7.symbol.async-iterator */ "../../node_modules/core-js/library/modules/es7.symbol.async-iterator.js");
__webpack_require__(/*! ../../modules/es7.symbol.observable */ "../../node_modules/core-js/library/modules/es7.symbol.observable.js");
module.exports = __webpack_require__(/*! ../../modules/_core */ "../../node_modules/core-js/library/modules/_core.js").Symbol;


/***/ }),

/***/ "../../node_modules/core-js/library/fn/symbol/iterator.js":
/*!****************************************************************!*\
  !*** ../../node_modules/core-js/library/fn/symbol/iterator.js ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

__webpack_require__(/*! ../../modules/es6.string.iterator */ "../../node_modules/core-js/library/modules/es6.string.iterator.js");
__webpack_require__(/*! ../../modules/web.dom.iterable */ "../../node_modules/core-js/library/modules/web.dom.iterable.js");
module.exports = (__webpack_require__(/*! ../../modules/_wks-ext */ "../../node_modules/core-js/library/modules/_wks-ext.js").f)('iterator');


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_a-function.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_a-function.js ***!
  \*****************************************************************/
/***/ ((module) => {

module.exports = function (it) {
  if (typeof it != 'function') throw TypeError(it + ' is not a function!');
  return it;
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_add-to-unscopables.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_add-to-unscopables.js ***!
  \*************************************************************************/
/***/ ((module) => {

module.exports = function () { /* empty */ };


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_an-object.js":
/*!****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_an-object.js ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isObject = __webpack_require__(/*! ./_is-object */ "../../node_modules/core-js/library/modules/_is-object.js");
module.exports = function (it) {
  if (!isObject(it)) throw TypeError(it + ' is not an object!');
  return it;
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_array-includes.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_array-includes.js ***!
  \*********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// false -> Array#indexOf
// true  -> Array#includes
var toIObject = __webpack_require__(/*! ./_to-iobject */ "../../node_modules/core-js/library/modules/_to-iobject.js");
var toLength = __webpack_require__(/*! ./_to-length */ "../../node_modules/core-js/library/modules/_to-length.js");
var toAbsoluteIndex = __webpack_require__(/*! ./_to-absolute-index */ "../../node_modules/core-js/library/modules/_to-absolute-index.js");
module.exports = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIObject($this);
    var length = toLength(O.length);
    var index = toAbsoluteIndex(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare
    if (IS_INCLUDES && el != el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare
      if (value != value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) if (IS_INCLUDES || index in O) {
      if (O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_classof.js":
/*!**************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_classof.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// getting tag from 19.1.3.6 Object.prototype.toString()
var cof = __webpack_require__(/*! ./_cof */ "../../node_modules/core-js/library/modules/_cof.js");
var TAG = __webpack_require__(/*! ./_wks */ "../../node_modules/core-js/library/modules/_wks.js")('toStringTag');
// ES3 wrong here
var ARG = cof(function () { return arguments; }()) == 'Arguments';

// fallback for IE11 Script Access Denied error
var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (e) { /* empty */ }
};

module.exports = function (it) {
  var O, T, B;
  return it === undefined ? 'Undefined' : it === null ? 'Null'
    // @@toStringTag case
    : typeof (T = tryGet(O = Object(it), TAG)) == 'string' ? T
    // builtinTag case
    : ARG ? cof(O)
    // ES3 arguments fallback
    : (B = cof(O)) == 'Object' && typeof O.callee == 'function' ? 'Arguments' : B;
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_cof.js":
/*!**********************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_cof.js ***!
  \**********************************************************/
/***/ ((module) => {

var toString = {}.toString;

module.exports = function (it) {
  return toString.call(it).slice(8, -1);
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_core.js":
/*!***********************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_core.js ***!
  \***********************************************************/
/***/ ((module) => {

var core = module.exports = { version: '2.6.12' };
if (typeof __e == 'number') __e = core; // eslint-disable-line no-undef


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_ctx.js":
/*!**********************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_ctx.js ***!
  \**********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// optional / simple context binding
var aFunction = __webpack_require__(/*! ./_a-function */ "../../node_modules/core-js/library/modules/_a-function.js");
module.exports = function (fn, that, length) {
  aFunction(fn);
  if (that === undefined) return fn;
  switch (length) {
    case 1: return function (a) {
      return fn.call(that, a);
    };
    case 2: return function (a, b) {
      return fn.call(that, a, b);
    };
    case 3: return function (a, b, c) {
      return fn.call(that, a, b, c);
    };
  }
  return function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_defined.js":
/*!**************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_defined.js ***!
  \**************************************************************/
/***/ ((module) => {

// 7.2.1 RequireObjectCoercible(argument)
module.exports = function (it) {
  if (it == undefined) throw TypeError("Can't call method on  " + it);
  return it;
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_descriptors.js":
/*!******************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_descriptors.js ***!
  \******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Thank's IE8 for his funny defineProperty
module.exports = !__webpack_require__(/*! ./_fails */ "../../node_modules/core-js/library/modules/_fails.js")(function () {
  return Object.defineProperty({}, 'a', { get: function () { return 7; } }).a != 7;
});


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_dom-create.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_dom-create.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var isObject = __webpack_require__(/*! ./_is-object */ "../../node_modules/core-js/library/modules/_is-object.js");
var document = (__webpack_require__(/*! ./_global */ "../../node_modules/core-js/library/modules/_global.js").document);
// typeof document.createElement is 'object' in old IE
var is = isObject(document) && isObject(document.createElement);
module.exports = function (it) {
  return is ? document.createElement(it) : {};
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_enum-bug-keys.js":
/*!********************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_enum-bug-keys.js ***!
  \********************************************************************/
/***/ ((module) => {

// IE 8- don't enum bug keys
module.exports = (
  'constructor,hasOwnProperty,isPrototypeOf,propertyIsEnumerable,toLocaleString,toString,valueOf'
).split(',');


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_enum-keys.js":
/*!****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_enum-keys.js ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// all enumerable object keys, includes symbols
var getKeys = __webpack_require__(/*! ./_object-keys */ "../../node_modules/core-js/library/modules/_object-keys.js");
var gOPS = __webpack_require__(/*! ./_object-gops */ "../../node_modules/core-js/library/modules/_object-gops.js");
var pIE = __webpack_require__(/*! ./_object-pie */ "../../node_modules/core-js/library/modules/_object-pie.js");
module.exports = function (it) {
  var result = getKeys(it);
  var getSymbols = gOPS.f;
  if (getSymbols) {
    var symbols = getSymbols(it);
    var isEnum = pIE.f;
    var i = 0;
    var key;
    while (symbols.length > i) if (isEnum.call(it, key = symbols[i++])) result.push(key);
  } return result;
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_export.js":
/*!*************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_export.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(/*! ./_global */ "../../node_modules/core-js/library/modules/_global.js");
var core = __webpack_require__(/*! ./_core */ "../../node_modules/core-js/library/modules/_core.js");
var ctx = __webpack_require__(/*! ./_ctx */ "../../node_modules/core-js/library/modules/_ctx.js");
var hide = __webpack_require__(/*! ./_hide */ "../../node_modules/core-js/library/modules/_hide.js");
var has = __webpack_require__(/*! ./_has */ "../../node_modules/core-js/library/modules/_has.js");
var PROTOTYPE = 'prototype';

var $export = function (type, name, source) {
  var IS_FORCED = type & $export.F;
  var IS_GLOBAL = type & $export.G;
  var IS_STATIC = type & $export.S;
  var IS_PROTO = type & $export.P;
  var IS_BIND = type & $export.B;
  var IS_WRAP = type & $export.W;
  var exports = IS_GLOBAL ? core : core[name] || (core[name] = {});
  var expProto = exports[PROTOTYPE];
  var target = IS_GLOBAL ? global : IS_STATIC ? global[name] : (global[name] || {})[PROTOTYPE];
  var key, own, out;
  if (IS_GLOBAL) source = name;
  for (key in source) {
    // contains in native
    own = !IS_FORCED && target && target[key] !== undefined;
    if (own && has(exports, key)) continue;
    // export native or passed
    out = own ? target[key] : source[key];
    // prevent global pollution for namespaces
    exports[key] = IS_GLOBAL && typeof target[key] != 'function' ? source[key]
    // bind timers to global for call from export context
    : IS_BIND && own ? ctx(out, global)
    // wrap global constructors for prevent change them in library
    : IS_WRAP && target[key] == out ? (function (C) {
      var F = function (a, b, c) {
        if (this instanceof C) {
          switch (arguments.length) {
            case 0: return new C();
            case 1: return new C(a);
            case 2: return new C(a, b);
          } return new C(a, b, c);
        } return C.apply(this, arguments);
      };
      F[PROTOTYPE] = C[PROTOTYPE];
      return F;
    // make static versions for prototype methods
    })(out) : IS_PROTO && typeof out == 'function' ? ctx(Function.call, out) : out;
    // export proto methods to core.%CONSTRUCTOR%.methods.%NAME%
    if (IS_PROTO) {
      (exports.virtual || (exports.virtual = {}))[key] = out;
      // export proto methods to core.%CONSTRUCTOR%.prototype.%NAME%
      if (type & $export.R && expProto && !expProto[key]) hide(expProto, key, out);
    }
  }
};
// type bitmap
$export.F = 1;   // forced
$export.G = 2;   // global
$export.S = 4;   // static
$export.P = 8;   // proto
$export.B = 16;  // bind
$export.W = 32;  // wrap
$export.U = 64;  // safe
$export.R = 128; // real proto method for `library`
module.exports = $export;


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_fails.js":
/*!************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_fails.js ***!
  \************************************************************/
/***/ ((module) => {

module.exports = function (exec) {
  try {
    return !!exec();
  } catch (e) {
    return true;
  }
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_global.js":
/*!*************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_global.js ***!
  \*************************************************************/
/***/ ((module) => {

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var global = module.exports = typeof window != 'undefined' && window.Math == Math
  ? window : typeof self != 'undefined' && self.Math == Math ? self
  // eslint-disable-next-line no-new-func
  : Function('return this')();
if (typeof __g == 'number') __g = global; // eslint-disable-line no-undef


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_has.js":
/*!**********************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_has.js ***!
  \**********************************************************/
/***/ ((module) => {

var hasOwnProperty = {}.hasOwnProperty;
module.exports = function (it, key) {
  return hasOwnProperty.call(it, key);
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_hide.js":
/*!***********************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_hide.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var dP = __webpack_require__(/*! ./_object-dp */ "../../node_modules/core-js/library/modules/_object-dp.js");
var createDesc = __webpack_require__(/*! ./_property-desc */ "../../node_modules/core-js/library/modules/_property-desc.js");
module.exports = __webpack_require__(/*! ./_descriptors */ "../../node_modules/core-js/library/modules/_descriptors.js") ? function (object, key, value) {
  return dP.f(object, key, createDesc(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_html.js":
/*!***********************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_html.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var document = (__webpack_require__(/*! ./_global */ "../../node_modules/core-js/library/modules/_global.js").document);
module.exports = document && document.documentElement;


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_ie8-dom-define.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_ie8-dom-define.js ***!
  \*********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = !__webpack_require__(/*! ./_descriptors */ "../../node_modules/core-js/library/modules/_descriptors.js") && !__webpack_require__(/*! ./_fails */ "../../node_modules/core-js/library/modules/_fails.js")(function () {
  return Object.defineProperty(__webpack_require__(/*! ./_dom-create */ "../../node_modules/core-js/library/modules/_dom-create.js")('div'), 'a', { get: function () { return 7; } }).a != 7;
});


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_iobject.js":
/*!**************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_iobject.js ***!
  \**************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// fallback for non-array-like ES3 and non-enumerable old V8 strings
var cof = __webpack_require__(/*! ./_cof */ "../../node_modules/core-js/library/modules/_cof.js");
// eslint-disable-next-line no-prototype-builtins
module.exports = Object('z').propertyIsEnumerable(0) ? Object : function (it) {
  return cof(it) == 'String' ? it.split('') : Object(it);
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_is-array.js":
/*!***************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_is-array.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// 7.2.2 IsArray(argument)
var cof = __webpack_require__(/*! ./_cof */ "../../node_modules/core-js/library/modules/_cof.js");
module.exports = Array.isArray || function isArray(arg) {
  return cof(arg) == 'Array';
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_is-integer.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_is-integer.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// 20.1.2.3 Number.isInteger(number)
var isObject = __webpack_require__(/*! ./_is-object */ "../../node_modules/core-js/library/modules/_is-object.js");
var floor = Math.floor;
module.exports = function isInteger(it) {
  return !isObject(it) && isFinite(it) && floor(it) === it;
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_is-object.js":
/*!****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_is-object.js ***!
  \****************************************************************/
/***/ ((module) => {

module.exports = function (it) {
  return typeof it === 'object' ? it !== null : typeof it === 'function';
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_iter-create.js":
/*!******************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_iter-create.js ***!
  \******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var create = __webpack_require__(/*! ./_object-create */ "../../node_modules/core-js/library/modules/_object-create.js");
var descriptor = __webpack_require__(/*! ./_property-desc */ "../../node_modules/core-js/library/modules/_property-desc.js");
var setToStringTag = __webpack_require__(/*! ./_set-to-string-tag */ "../../node_modules/core-js/library/modules/_set-to-string-tag.js");
var IteratorPrototype = {};

// 25.1.2.1.1 %IteratorPrototype%[@@iterator]()
__webpack_require__(/*! ./_hide */ "../../node_modules/core-js/library/modules/_hide.js")(IteratorPrototype, __webpack_require__(/*! ./_wks */ "../../node_modules/core-js/library/modules/_wks.js")('iterator'), function () { return this; });

module.exports = function (Constructor, NAME, next) {
  Constructor.prototype = create(IteratorPrototype, { next: descriptor(1, next) });
  setToStringTag(Constructor, NAME + ' Iterator');
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_iter-define.js":
/*!******************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_iter-define.js ***!
  \******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var LIBRARY = __webpack_require__(/*! ./_library */ "../../node_modules/core-js/library/modules/_library.js");
var $export = __webpack_require__(/*! ./_export */ "../../node_modules/core-js/library/modules/_export.js");
var redefine = __webpack_require__(/*! ./_redefine */ "../../node_modules/core-js/library/modules/_redefine.js");
var hide = __webpack_require__(/*! ./_hide */ "../../node_modules/core-js/library/modules/_hide.js");
var Iterators = __webpack_require__(/*! ./_iterators */ "../../node_modules/core-js/library/modules/_iterators.js");
var $iterCreate = __webpack_require__(/*! ./_iter-create */ "../../node_modules/core-js/library/modules/_iter-create.js");
var setToStringTag = __webpack_require__(/*! ./_set-to-string-tag */ "../../node_modules/core-js/library/modules/_set-to-string-tag.js");
var getPrototypeOf = __webpack_require__(/*! ./_object-gpo */ "../../node_modules/core-js/library/modules/_object-gpo.js");
var ITERATOR = __webpack_require__(/*! ./_wks */ "../../node_modules/core-js/library/modules/_wks.js")('iterator');
var BUGGY = !([].keys && 'next' in [].keys()); // Safari has buggy iterators w/o `next`
var FF_ITERATOR = '@@iterator';
var KEYS = 'keys';
var VALUES = 'values';

var returnThis = function () { return this; };

module.exports = function (Base, NAME, Constructor, next, DEFAULT, IS_SET, FORCED) {
  $iterCreate(Constructor, NAME, next);
  var getMethod = function (kind) {
    if (!BUGGY && kind in proto) return proto[kind];
    switch (kind) {
      case KEYS: return function keys() { return new Constructor(this, kind); };
      case VALUES: return function values() { return new Constructor(this, kind); };
    } return function entries() { return new Constructor(this, kind); };
  };
  var TAG = NAME + ' Iterator';
  var DEF_VALUES = DEFAULT == VALUES;
  var VALUES_BUG = false;
  var proto = Base.prototype;
  var $native = proto[ITERATOR] || proto[FF_ITERATOR] || DEFAULT && proto[DEFAULT];
  var $default = $native || getMethod(DEFAULT);
  var $entries = DEFAULT ? !DEF_VALUES ? $default : getMethod('entries') : undefined;
  var $anyNative = NAME == 'Array' ? proto.entries || $native : $native;
  var methods, key, IteratorPrototype;
  // Fix native
  if ($anyNative) {
    IteratorPrototype = getPrototypeOf($anyNative.call(new Base()));
    if (IteratorPrototype !== Object.prototype && IteratorPrototype.next) {
      // Set @@toStringTag to native iterators
      setToStringTag(IteratorPrototype, TAG, true);
      // fix for some old engines
      if (!LIBRARY && typeof IteratorPrototype[ITERATOR] != 'function') hide(IteratorPrototype, ITERATOR, returnThis);
    }
  }
  // fix Array#{values, @@iterator}.name in V8 / FF
  if (DEF_VALUES && $native && $native.name !== VALUES) {
    VALUES_BUG = true;
    $default = function values() { return $native.call(this); };
  }
  // Define iterator
  if ((!LIBRARY || FORCED) && (BUGGY || VALUES_BUG || !proto[ITERATOR])) {
    hide(proto, ITERATOR, $default);
  }
  // Plug for library
  Iterators[NAME] = $default;
  Iterators[TAG] = returnThis;
  if (DEFAULT) {
    methods = {
      values: DEF_VALUES ? $default : getMethod(VALUES),
      keys: IS_SET ? $default : getMethod(KEYS),
      entries: $entries
    };
    if (FORCED) for (key in methods) {
      if (!(key in proto)) redefine(proto, key, methods[key]);
    } else $export($export.P + $export.F * (BUGGY || VALUES_BUG), NAME, methods);
  }
  return methods;
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_iter-step.js":
/*!****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_iter-step.js ***!
  \****************************************************************/
/***/ ((module) => {

module.exports = function (done, value) {
  return { value: value, done: !!done };
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_iterators.js":
/*!****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_iterators.js ***!
  \****************************************************************/
/***/ ((module) => {

module.exports = {};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_library.js":
/*!**************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_library.js ***!
  \**************************************************************/
/***/ ((module) => {

module.exports = true;


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_meta.js":
/*!***********************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_meta.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var META = __webpack_require__(/*! ./_uid */ "../../node_modules/core-js/library/modules/_uid.js")('meta');
var isObject = __webpack_require__(/*! ./_is-object */ "../../node_modules/core-js/library/modules/_is-object.js");
var has = __webpack_require__(/*! ./_has */ "../../node_modules/core-js/library/modules/_has.js");
var setDesc = (__webpack_require__(/*! ./_object-dp */ "../../node_modules/core-js/library/modules/_object-dp.js").f);
var id = 0;
var isExtensible = Object.isExtensible || function () {
  return true;
};
var FREEZE = !__webpack_require__(/*! ./_fails */ "../../node_modules/core-js/library/modules/_fails.js")(function () {
  return isExtensible(Object.preventExtensions({}));
});
var setMeta = function (it) {
  setDesc(it, META, { value: {
    i: 'O' + ++id, // object ID
    w: {}          // weak collections IDs
  } });
};
var fastKey = function (it, create) {
  // return primitive with prefix
  if (!isObject(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
  if (!has(it, META)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return 'F';
    // not necessary to add metadata
    if (!create) return 'E';
    // add missing metadata
    setMeta(it);
  // return object ID
  } return it[META].i;
};
var getWeak = function (it, create) {
  if (!has(it, META)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible(it)) return true;
    // not necessary to add metadata
    if (!create) return false;
    // add missing metadata
    setMeta(it);
  // return hash weak collections IDs
  } return it[META].w;
};
// add metadata on freeze-family methods calling
var onFreeze = function (it) {
  if (FREEZE && meta.NEED && isExtensible(it) && !has(it, META)) setMeta(it);
  return it;
};
var meta = module.exports = {
  KEY: META,
  NEED: false,
  fastKey: fastKey,
  getWeak: getWeak,
  onFreeze: onFreeze
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_object-assign.js":
/*!********************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_object-assign.js ***!
  \********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

// 19.1.2.1 Object.assign(target, source, ...)
var DESCRIPTORS = __webpack_require__(/*! ./_descriptors */ "../../node_modules/core-js/library/modules/_descriptors.js");
var getKeys = __webpack_require__(/*! ./_object-keys */ "../../node_modules/core-js/library/modules/_object-keys.js");
var gOPS = __webpack_require__(/*! ./_object-gops */ "../../node_modules/core-js/library/modules/_object-gops.js");
var pIE = __webpack_require__(/*! ./_object-pie */ "../../node_modules/core-js/library/modules/_object-pie.js");
var toObject = __webpack_require__(/*! ./_to-object */ "../../node_modules/core-js/library/modules/_to-object.js");
var IObject = __webpack_require__(/*! ./_iobject */ "../../node_modules/core-js/library/modules/_iobject.js");
var $assign = Object.assign;

// should work with symbols and should have deterministic property order (V8 bug)
module.exports = !$assign || __webpack_require__(/*! ./_fails */ "../../node_modules/core-js/library/modules/_fails.js")(function () {
  var A = {};
  var B = {};
  // eslint-disable-next-line no-undef
  var S = Symbol();
  var K = 'abcdefghijklmnopqrst';
  A[S] = 7;
  K.split('').forEach(function (k) { B[k] = k; });
  return $assign({}, A)[S] != 7 || Object.keys($assign({}, B)).join('') != K;
}) ? function assign(target, source) { // eslint-disable-line no-unused-vars
  var T = toObject(target);
  var aLen = arguments.length;
  var index = 1;
  var getSymbols = gOPS.f;
  var isEnum = pIE.f;
  while (aLen > index) {
    var S = IObject(arguments[index++]);
    var keys = getSymbols ? getKeys(S).concat(getSymbols(S)) : getKeys(S);
    var length = keys.length;
    var j = 0;
    var key;
    while (length > j) {
      key = keys[j++];
      if (!DESCRIPTORS || isEnum.call(S, key)) T[key] = S[key];
    }
  } return T;
} : $assign;


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_object-create.js":
/*!********************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_object-create.js ***!
  \********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
var anObject = __webpack_require__(/*! ./_an-object */ "../../node_modules/core-js/library/modules/_an-object.js");
var dPs = __webpack_require__(/*! ./_object-dps */ "../../node_modules/core-js/library/modules/_object-dps.js");
var enumBugKeys = __webpack_require__(/*! ./_enum-bug-keys */ "../../node_modules/core-js/library/modules/_enum-bug-keys.js");
var IE_PROTO = __webpack_require__(/*! ./_shared-key */ "../../node_modules/core-js/library/modules/_shared-key.js")('IE_PROTO');
var Empty = function () { /* empty */ };
var PROTOTYPE = 'prototype';

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var createDict = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = __webpack_require__(/*! ./_dom-create */ "../../node_modules/core-js/library/modules/_dom-create.js")('iframe');
  var i = enumBugKeys.length;
  var lt = '<';
  var gt = '>';
  var iframeDocument;
  iframe.style.display = 'none';
  (__webpack_require__(/*! ./_html */ "../../node_modules/core-js/library/modules/_html.js").appendChild)(iframe);
  iframe.src = 'javascript:'; // eslint-disable-line no-script-url
  // createDict = iframe.contentWindow.Object;
  // html.removeChild(iframe);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(lt + 'script' + gt + 'document.F=Object' + lt + '/script' + gt);
  iframeDocument.close();
  createDict = iframeDocument.F;
  while (i--) delete createDict[PROTOTYPE][enumBugKeys[i]];
  return createDict();
};

module.exports = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    Empty[PROTOTYPE] = anObject(O);
    result = new Empty();
    Empty[PROTOTYPE] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO] = O;
  } else result = createDict();
  return Properties === undefined ? result : dPs(result, Properties);
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_object-dp.js":
/*!****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_object-dp.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var anObject = __webpack_require__(/*! ./_an-object */ "../../node_modules/core-js/library/modules/_an-object.js");
var IE8_DOM_DEFINE = __webpack_require__(/*! ./_ie8-dom-define */ "../../node_modules/core-js/library/modules/_ie8-dom-define.js");
var toPrimitive = __webpack_require__(/*! ./_to-primitive */ "../../node_modules/core-js/library/modules/_to-primitive.js");
var dP = Object.defineProperty;

exports.f = __webpack_require__(/*! ./_descriptors */ "../../node_modules/core-js/library/modules/_descriptors.js") ? Object.defineProperty : function defineProperty(O, P, Attributes) {
  anObject(O);
  P = toPrimitive(P, true);
  anObject(Attributes);
  if (IE8_DOM_DEFINE) try {
    return dP(O, P, Attributes);
  } catch (e) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw TypeError('Accessors not supported!');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_object-dps.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_object-dps.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var dP = __webpack_require__(/*! ./_object-dp */ "../../node_modules/core-js/library/modules/_object-dp.js");
var anObject = __webpack_require__(/*! ./_an-object */ "../../node_modules/core-js/library/modules/_an-object.js");
var getKeys = __webpack_require__(/*! ./_object-keys */ "../../node_modules/core-js/library/modules/_object-keys.js");

module.exports = __webpack_require__(/*! ./_descriptors */ "../../node_modules/core-js/library/modules/_descriptors.js") ? Object.defineProperties : function defineProperties(O, Properties) {
  anObject(O);
  var keys = getKeys(Properties);
  var length = keys.length;
  var i = 0;
  var P;
  while (length > i) dP.f(O, P = keys[i++], Properties[P]);
  return O;
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_object-gopd.js":
/*!******************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_object-gopd.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

var pIE = __webpack_require__(/*! ./_object-pie */ "../../node_modules/core-js/library/modules/_object-pie.js");
var createDesc = __webpack_require__(/*! ./_property-desc */ "../../node_modules/core-js/library/modules/_property-desc.js");
var toIObject = __webpack_require__(/*! ./_to-iobject */ "../../node_modules/core-js/library/modules/_to-iobject.js");
var toPrimitive = __webpack_require__(/*! ./_to-primitive */ "../../node_modules/core-js/library/modules/_to-primitive.js");
var has = __webpack_require__(/*! ./_has */ "../../node_modules/core-js/library/modules/_has.js");
var IE8_DOM_DEFINE = __webpack_require__(/*! ./_ie8-dom-define */ "../../node_modules/core-js/library/modules/_ie8-dom-define.js");
var gOPD = Object.getOwnPropertyDescriptor;

exports.f = __webpack_require__(/*! ./_descriptors */ "../../node_modules/core-js/library/modules/_descriptors.js") ? gOPD : function getOwnPropertyDescriptor(O, P) {
  O = toIObject(O);
  P = toPrimitive(P, true);
  if (IE8_DOM_DEFINE) try {
    return gOPD(O, P);
  } catch (e) { /* empty */ }
  if (has(O, P)) return createDesc(!pIE.f.call(O, P), O[P]);
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_object-gopn-ext.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_object-gopn-ext.js ***!
  \**********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window
var toIObject = __webpack_require__(/*! ./_to-iobject */ "../../node_modules/core-js/library/modules/_to-iobject.js");
var gOPN = (__webpack_require__(/*! ./_object-gopn */ "../../node_modules/core-js/library/modules/_object-gopn.js").f);
var toString = {}.toString;

var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames
  ? Object.getOwnPropertyNames(window) : [];

var getWindowNames = function (it) {
  try {
    return gOPN(it);
  } catch (e) {
    return windowNames.slice();
  }
};

module.exports.f = function getOwnPropertyNames(it) {
  return windowNames && toString.call(it) == '[object Window]' ? getWindowNames(it) : gOPN(toIObject(it));
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_object-gopn.js":
/*!******************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_object-gopn.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

// 19.1.2.7 / 15.2.3.4 Object.getOwnPropertyNames(O)
var $keys = __webpack_require__(/*! ./_object-keys-internal */ "../../node_modules/core-js/library/modules/_object-keys-internal.js");
var hiddenKeys = (__webpack_require__(/*! ./_enum-bug-keys */ "../../node_modules/core-js/library/modules/_enum-bug-keys.js").concat)('length', 'prototype');

exports.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return $keys(O, hiddenKeys);
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_object-gops.js":
/*!******************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_object-gops.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, exports) => {

exports.f = Object.getOwnPropertySymbols;


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_object-gpo.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_object-gpo.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// 19.1.2.9 / 15.2.3.2 Object.getPrototypeOf(O)
var has = __webpack_require__(/*! ./_has */ "../../node_modules/core-js/library/modules/_has.js");
var toObject = __webpack_require__(/*! ./_to-object */ "../../node_modules/core-js/library/modules/_to-object.js");
var IE_PROTO = __webpack_require__(/*! ./_shared-key */ "../../node_modules/core-js/library/modules/_shared-key.js")('IE_PROTO');
var ObjectProto = Object.prototype;

module.exports = Object.getPrototypeOf || function (O) {
  O = toObject(O);
  if (has(O, IE_PROTO)) return O[IE_PROTO];
  if (typeof O.constructor == 'function' && O instanceof O.constructor) {
    return O.constructor.prototype;
  } return O instanceof Object ? ObjectProto : null;
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_object-keys-internal.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_object-keys-internal.js ***!
  \***************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var has = __webpack_require__(/*! ./_has */ "../../node_modules/core-js/library/modules/_has.js");
var toIObject = __webpack_require__(/*! ./_to-iobject */ "../../node_modules/core-js/library/modules/_to-iobject.js");
var arrayIndexOf = __webpack_require__(/*! ./_array-includes */ "../../node_modules/core-js/library/modules/_array-includes.js")(false);
var IE_PROTO = __webpack_require__(/*! ./_shared-key */ "../../node_modules/core-js/library/modules/_shared-key.js")('IE_PROTO');

module.exports = function (object, names) {
  var O = toIObject(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) if (key != IE_PROTO) has(O, key) && result.push(key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (has(O, key = names[i++])) {
    ~arrayIndexOf(result, key) || result.push(key);
  }
  return result;
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_object-keys.js":
/*!******************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_object-keys.js ***!
  \******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// 19.1.2.14 / 15.2.3.14 Object.keys(O)
var $keys = __webpack_require__(/*! ./_object-keys-internal */ "../../node_modules/core-js/library/modules/_object-keys-internal.js");
var enumBugKeys = __webpack_require__(/*! ./_enum-bug-keys */ "../../node_modules/core-js/library/modules/_enum-bug-keys.js");

module.exports = Object.keys || function keys(O) {
  return $keys(O, enumBugKeys);
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_object-pie.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_object-pie.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, exports) => {

exports.f = {}.propertyIsEnumerable;


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_object-sap.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_object-sap.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// most Object methods by ES6 should accept primitives
var $export = __webpack_require__(/*! ./_export */ "../../node_modules/core-js/library/modules/_export.js");
var core = __webpack_require__(/*! ./_core */ "../../node_modules/core-js/library/modules/_core.js");
var fails = __webpack_require__(/*! ./_fails */ "../../node_modules/core-js/library/modules/_fails.js");
module.exports = function (KEY, exec) {
  var fn = (core.Object || {})[KEY] || Object[KEY];
  var exp = {};
  exp[KEY] = exec(fn);
  $export($export.S + $export.F * fails(function () { fn(1); }), 'Object', exp);
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_property-desc.js":
/*!********************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_property-desc.js ***!
  \********************************************************************/
/***/ ((module) => {

module.exports = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_redefine.js":
/*!***************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_redefine.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! ./_hide */ "../../node_modules/core-js/library/modules/_hide.js");


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_set-proto.js":
/*!****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_set-proto.js ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Works with __proto__ only. Old v8 can't work with null proto objects.
/* eslint-disable no-proto */
var isObject = __webpack_require__(/*! ./_is-object */ "../../node_modules/core-js/library/modules/_is-object.js");
var anObject = __webpack_require__(/*! ./_an-object */ "../../node_modules/core-js/library/modules/_an-object.js");
var check = function (O, proto) {
  anObject(O);
  if (!isObject(proto) && proto !== null) throw TypeError(proto + ": can't set as prototype!");
};
module.exports = {
  set: Object.setPrototypeOf || ('__proto__' in {} ? // eslint-disable-line
    function (test, buggy, set) {
      try {
        set = __webpack_require__(/*! ./_ctx */ "../../node_modules/core-js/library/modules/_ctx.js")(Function.call, (__webpack_require__(/*! ./_object-gopd */ "../../node_modules/core-js/library/modules/_object-gopd.js").f)(Object.prototype, '__proto__').set, 2);
        set(test, []);
        buggy = !(test instanceof Array);
      } catch (e) { buggy = true; }
      return function setPrototypeOf(O, proto) {
        check(O, proto);
        if (buggy) O.__proto__ = proto;
        else set(O, proto);
        return O;
      };
    }({}, false) : undefined),
  check: check
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_set-to-string-tag.js":
/*!************************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_set-to-string-tag.js ***!
  \************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var def = (__webpack_require__(/*! ./_object-dp */ "../../node_modules/core-js/library/modules/_object-dp.js").f);
var has = __webpack_require__(/*! ./_has */ "../../node_modules/core-js/library/modules/_has.js");
var TAG = __webpack_require__(/*! ./_wks */ "../../node_modules/core-js/library/modules/_wks.js")('toStringTag');

module.exports = function (it, tag, stat) {
  if (it && !has(it = stat ? it : it.prototype, TAG)) def(it, TAG, { configurable: true, value: tag });
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_shared-key.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_shared-key.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var shared = __webpack_require__(/*! ./_shared */ "../../node_modules/core-js/library/modules/_shared.js")('keys');
var uid = __webpack_require__(/*! ./_uid */ "../../node_modules/core-js/library/modules/_uid.js");
module.exports = function (key) {
  return shared[key] || (shared[key] = uid(key));
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_shared.js":
/*!*************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_shared.js ***!
  \*************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var core = __webpack_require__(/*! ./_core */ "../../node_modules/core-js/library/modules/_core.js");
var global = __webpack_require__(/*! ./_global */ "../../node_modules/core-js/library/modules/_global.js");
var SHARED = '__core-js_shared__';
var store = global[SHARED] || (global[SHARED] = {});

(module.exports = function (key, value) {
  return store[key] || (store[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: core.version,
  mode: __webpack_require__(/*! ./_library */ "../../node_modules/core-js/library/modules/_library.js") ? 'pure' : 'global',
  copyright: '© 2020 Denis Pushkarev (zloirock.ru)'
});


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_string-at.js":
/*!****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_string-at.js ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toInteger = __webpack_require__(/*! ./_to-integer */ "../../node_modules/core-js/library/modules/_to-integer.js");
var defined = __webpack_require__(/*! ./_defined */ "../../node_modules/core-js/library/modules/_defined.js");
// true  -> String#at
// false -> String#codePointAt
module.exports = function (TO_STRING) {
  return function (that, pos) {
    var s = String(defined(that));
    var i = toInteger(pos);
    var l = s.length;
    var a, b;
    if (i < 0 || i >= l) return TO_STRING ? '' : undefined;
    a = s.charCodeAt(i);
    return a < 0xd800 || a > 0xdbff || i + 1 === l || (b = s.charCodeAt(i + 1)) < 0xdc00 || b > 0xdfff
      ? TO_STRING ? s.charAt(i) : a
      : TO_STRING ? s.slice(i, i + 2) : (a - 0xd800 << 10) + (b - 0xdc00) + 0x10000;
  };
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_to-absolute-index.js":
/*!************************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_to-absolute-index.js ***!
  \************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var toInteger = __webpack_require__(/*! ./_to-integer */ "../../node_modules/core-js/library/modules/_to-integer.js");
var max = Math.max;
var min = Math.min;
module.exports = function (index, length) {
  index = toInteger(index);
  return index < 0 ? max(index + length, 0) : min(index, length);
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_to-integer.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_to-integer.js ***!
  \*****************************************************************/
/***/ ((module) => {

// 7.1.4 ToInteger
var ceil = Math.ceil;
var floor = Math.floor;
module.exports = function (it) {
  return isNaN(it = +it) ? 0 : (it > 0 ? floor : ceil)(it);
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_to-iobject.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_to-iobject.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// to indexed object, toObject with fallback for non-array-like ES3 strings
var IObject = __webpack_require__(/*! ./_iobject */ "../../node_modules/core-js/library/modules/_iobject.js");
var defined = __webpack_require__(/*! ./_defined */ "../../node_modules/core-js/library/modules/_defined.js");
module.exports = function (it) {
  return IObject(defined(it));
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_to-length.js":
/*!****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_to-length.js ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// 7.1.15 ToLength
var toInteger = __webpack_require__(/*! ./_to-integer */ "../../node_modules/core-js/library/modules/_to-integer.js");
var min = Math.min;
module.exports = function (it) {
  return it > 0 ? min(toInteger(it), 0x1fffffffffffff) : 0; // pow(2, 53) - 1 == 9007199254740991
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_to-object.js":
/*!****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_to-object.js ***!
  \****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// 7.1.13 ToObject(argument)
var defined = __webpack_require__(/*! ./_defined */ "../../node_modules/core-js/library/modules/_defined.js");
module.exports = function (it) {
  return Object(defined(it));
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_to-primitive.js":
/*!*******************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_to-primitive.js ***!
  \*******************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// 7.1.1 ToPrimitive(input [, PreferredType])
var isObject = __webpack_require__(/*! ./_is-object */ "../../node_modules/core-js/library/modules/_is-object.js");
// instead of the ES6 spec version, we didn't implement @@toPrimitive case
// and the second argument - flag - preferred type is a string
module.exports = function (it, S) {
  if (!isObject(it)) return it;
  var fn, val;
  if (S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  if (typeof (fn = it.valueOf) == 'function' && !isObject(val = fn.call(it))) return val;
  if (!S && typeof (fn = it.toString) == 'function' && !isObject(val = fn.call(it))) return val;
  throw TypeError("Can't convert object to primitive value");
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_uid.js":
/*!**********************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_uid.js ***!
  \**********************************************************/
/***/ ((module) => {

var id = 0;
var px = Math.random();
module.exports = function (key) {
  return 'Symbol('.concat(key === undefined ? '' : key, ')_', (++id + px).toString(36));
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_wks-define.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_wks-define.js ***!
  \*****************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var global = __webpack_require__(/*! ./_global */ "../../node_modules/core-js/library/modules/_global.js");
var core = __webpack_require__(/*! ./_core */ "../../node_modules/core-js/library/modules/_core.js");
var LIBRARY = __webpack_require__(/*! ./_library */ "../../node_modules/core-js/library/modules/_library.js");
var wksExt = __webpack_require__(/*! ./_wks-ext */ "../../node_modules/core-js/library/modules/_wks-ext.js");
var defineProperty = (__webpack_require__(/*! ./_object-dp */ "../../node_modules/core-js/library/modules/_object-dp.js").f);
module.exports = function (name) {
  var $Symbol = core.Symbol || (core.Symbol = LIBRARY ? {} : global.Symbol || {});
  if (name.charAt(0) != '_' && !(name in $Symbol)) defineProperty($Symbol, name, { value: wksExt.f(name) });
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_wks-ext.js":
/*!**************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_wks-ext.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

exports.f = __webpack_require__(/*! ./_wks */ "../../node_modules/core-js/library/modules/_wks.js");


/***/ }),

/***/ "../../node_modules/core-js/library/modules/_wks.js":
/*!**********************************************************!*\
  !*** ../../node_modules/core-js/library/modules/_wks.js ***!
  \**********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var store = __webpack_require__(/*! ./_shared */ "../../node_modules/core-js/library/modules/_shared.js")('wks');
var uid = __webpack_require__(/*! ./_uid */ "../../node_modules/core-js/library/modules/_uid.js");
var Symbol = (__webpack_require__(/*! ./_global */ "../../node_modules/core-js/library/modules/_global.js").Symbol);
var USE_SYMBOL = typeof Symbol == 'function';

var $exports = module.exports = function (name) {
  return store[name] || (store[name] =
    USE_SYMBOL && Symbol[name] || (USE_SYMBOL ? Symbol : uid)('Symbol.' + name));
};

$exports.store = store;


/***/ }),

/***/ "../../node_modules/core-js/library/modules/core.get-iterator-method.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/core.get-iterator-method.js ***!
  \******************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var classof = __webpack_require__(/*! ./_classof */ "../../node_modules/core-js/library/modules/_classof.js");
var ITERATOR = __webpack_require__(/*! ./_wks */ "../../node_modules/core-js/library/modules/_wks.js")('iterator');
var Iterators = __webpack_require__(/*! ./_iterators */ "../../node_modules/core-js/library/modules/_iterators.js");
module.exports = (__webpack_require__(/*! ./_core */ "../../node_modules/core-js/library/modules/_core.js").getIteratorMethod) = function (it) {
  if (it != undefined) return it[ITERATOR]
    || it['@@iterator']
    || Iterators[classof(it)];
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/core.get-iterator.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/core.get-iterator.js ***!
  \***********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var anObject = __webpack_require__(/*! ./_an-object */ "../../node_modules/core-js/library/modules/_an-object.js");
var get = __webpack_require__(/*! ./core.get-iterator-method */ "../../node_modules/core-js/library/modules/core.get-iterator-method.js");
module.exports = (__webpack_require__(/*! ./_core */ "../../node_modules/core-js/library/modules/_core.js").getIterator) = function (it) {
  var iterFn = get(it);
  if (typeof iterFn != 'function') throw TypeError(it + ' is not iterable!');
  return anObject(iterFn.call(it));
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/core.is-iterable.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/core.is-iterable.js ***!
  \**********************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var classof = __webpack_require__(/*! ./_classof */ "../../node_modules/core-js/library/modules/_classof.js");
var ITERATOR = __webpack_require__(/*! ./_wks */ "../../node_modules/core-js/library/modules/_wks.js")('iterator');
var Iterators = __webpack_require__(/*! ./_iterators */ "../../node_modules/core-js/library/modules/_iterators.js");
module.exports = (__webpack_require__(/*! ./_core */ "../../node_modules/core-js/library/modules/_core.js").isIterable) = function (it) {
  var O = Object(it);
  return O[ITERATOR] !== undefined
    || '@@iterator' in O
    // eslint-disable-next-line no-prototype-builtins
    || Iterators.hasOwnProperty(classof(O));
};


/***/ }),

/***/ "../../node_modules/core-js/library/modules/es6.array.iterator.js":
/*!************************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/es6.array.iterator.js ***!
  \************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var addToUnscopables = __webpack_require__(/*! ./_add-to-unscopables */ "../../node_modules/core-js/library/modules/_add-to-unscopables.js");
var step = __webpack_require__(/*! ./_iter-step */ "../../node_modules/core-js/library/modules/_iter-step.js");
var Iterators = __webpack_require__(/*! ./_iterators */ "../../node_modules/core-js/library/modules/_iterators.js");
var toIObject = __webpack_require__(/*! ./_to-iobject */ "../../node_modules/core-js/library/modules/_to-iobject.js");

// 22.1.3.4 Array.prototype.entries()
// 22.1.3.13 Array.prototype.keys()
// 22.1.3.29 Array.prototype.values()
// 22.1.3.30 Array.prototype[@@iterator]()
module.exports = __webpack_require__(/*! ./_iter-define */ "../../node_modules/core-js/library/modules/_iter-define.js")(Array, 'Array', function (iterated, kind) {
  this._t = toIObject(iterated); // target
  this._i = 0;                   // next index
  this._k = kind;                // kind
// 22.1.5.2.1 %ArrayIteratorPrototype%.next()
}, function () {
  var O = this._t;
  var kind = this._k;
  var index = this._i++;
  if (!O || index >= O.length) {
    this._t = undefined;
    return step(1);
  }
  if (kind == 'keys') return step(0, index);
  if (kind == 'values') return step(0, O[index]);
  return step(0, [index, O[index]]);
}, 'values');

// argumentsList[@@iterator] is %ArrayProto_values% (9.4.4.6, 9.4.4.7)
Iterators.Arguments = Iterators.Array;

addToUnscopables('keys');
addToUnscopables('values');
addToUnscopables('entries');


/***/ }),

/***/ "../../node_modules/core-js/library/modules/es6.number.is-safe-integer.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/es6.number.is-safe-integer.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

// 20.1.2.5 Number.isSafeInteger(number)
var $export = __webpack_require__(/*! ./_export */ "../../node_modules/core-js/library/modules/_export.js");
var isInteger = __webpack_require__(/*! ./_is-integer */ "../../node_modules/core-js/library/modules/_is-integer.js");
var abs = Math.abs;

$export($export.S, 'Number', {
  isSafeInteger: function isSafeInteger(number) {
    return isInteger(number) && abs(number) <= 0x1fffffffffffff;
  }
});


/***/ }),

/***/ "../../node_modules/core-js/library/modules/es6.object.assign.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/es6.object.assign.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

// 19.1.3.1 Object.assign(target, source)
var $export = __webpack_require__(/*! ./_export */ "../../node_modules/core-js/library/modules/_export.js");

$export($export.S + $export.F, 'Object', { assign: __webpack_require__(/*! ./_object-assign */ "../../node_modules/core-js/library/modules/_object-assign.js") });


/***/ }),

/***/ "../../node_modules/core-js/library/modules/es6.object.create.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/es6.object.create.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

var $export = __webpack_require__(/*! ./_export */ "../../node_modules/core-js/library/modules/_export.js");
// 19.1.2.2 / 15.2.3.5 Object.create(O [, Properties])
$export($export.S, 'Object', { create: __webpack_require__(/*! ./_object-create */ "../../node_modules/core-js/library/modules/_object-create.js") });


/***/ }),

/***/ "../../node_modules/core-js/library/modules/es6.object.get-own-property-names.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/es6.object.get-own-property-names.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

// 19.1.2.7 Object.getOwnPropertyNames(O)
__webpack_require__(/*! ./_object-sap */ "../../node_modules/core-js/library/modules/_object-sap.js")('getOwnPropertyNames', function () {
  return (__webpack_require__(/*! ./_object-gopn-ext */ "../../node_modules/core-js/library/modules/_object-gopn-ext.js").f);
});


/***/ }),

/***/ "../../node_modules/core-js/library/modules/es6.object.keys.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/es6.object.keys.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

// 19.1.2.14 Object.keys(O)
var toObject = __webpack_require__(/*! ./_to-object */ "../../node_modules/core-js/library/modules/_to-object.js");
var $keys = __webpack_require__(/*! ./_object-keys */ "../../node_modules/core-js/library/modules/_object-keys.js");

__webpack_require__(/*! ./_object-sap */ "../../node_modules/core-js/library/modules/_object-sap.js")('keys', function () {
  return function keys(it) {
    return $keys(toObject(it));
  };
});


/***/ }),

/***/ "../../node_modules/core-js/library/modules/es6.object.set-prototype-of.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/es6.object.set-prototype-of.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

// 19.1.3.19 Object.setPrototypeOf(O, proto)
var $export = __webpack_require__(/*! ./_export */ "../../node_modules/core-js/library/modules/_export.js");
$export($export.S, 'Object', { setPrototypeOf: (__webpack_require__(/*! ./_set-proto */ "../../node_modules/core-js/library/modules/_set-proto.js").set) });


/***/ }),

/***/ "../../node_modules/core-js/library/modules/es6.object.to-string.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/es6.object.to-string.js ***!
  \**************************************************************************/
/***/ (() => {



/***/ }),

/***/ "../../node_modules/core-js/library/modules/es6.string.iterator.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/es6.string.iterator.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

var $at = __webpack_require__(/*! ./_string-at */ "../../node_modules/core-js/library/modules/_string-at.js")(true);

// 21.1.3.27 String.prototype[@@iterator]()
__webpack_require__(/*! ./_iter-define */ "../../node_modules/core-js/library/modules/_iter-define.js")(String, 'String', function (iterated) {
  this._t = String(iterated); // target
  this._i = 0;                // next index
// 21.1.5.2.1 %StringIteratorPrototype%.next()
}, function () {
  var O = this._t;
  var index = this._i;
  var point;
  if (index >= O.length) return { value: undefined, done: true };
  point = $at(O, index);
  this._i += point.length;
  return { value: point, done: false };
});


/***/ }),

/***/ "../../node_modules/core-js/library/modules/es6.symbol.js":
/*!****************************************************************!*\
  !*** ../../node_modules/core-js/library/modules/es6.symbol.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {

"use strict";

// ECMAScript 6 symbols shim
var global = __webpack_require__(/*! ./_global */ "../../node_modules/core-js/library/modules/_global.js");
var has = __webpack_require__(/*! ./_has */ "../../node_modules/core-js/library/modules/_has.js");
var DESCRIPTORS = __webpack_require__(/*! ./_descriptors */ "../../node_modules/core-js/library/modules/_descriptors.js");
var $export = __webpack_require__(/*! ./_export */ "../../node_modules/core-js/library/modules/_export.js");
var redefine = __webpack_require__(/*! ./_redefine */ "../../node_modules/core-js/library/modules/_redefine.js");
var META = (__webpack_require__(/*! ./_meta */ "../../node_modules/core-js/library/modules/_meta.js").KEY);
var $fails = __webpack_require__(/*! ./_fails */ "../../node_modules/core-js/library/modules/_fails.js");
var shared = __webpack_require__(/*! ./_shared */ "../../node_modules/core-js/library/modules/_shared.js");
var setToStringTag = __webpack_require__(/*! ./_set-to-string-tag */ "../../node_modules/core-js/library/modules/_set-to-string-tag.js");
var uid = __webpack_require__(/*! ./_uid */ "../../node_modules/core-js/library/modules/_uid.js");
var wks = __webpack_require__(/*! ./_wks */ "../../node_modules/core-js/library/modules/_wks.js");
var wksExt = __webpack_require__(/*! ./_wks-ext */ "../../node_modules/core-js/library/modules/_wks-ext.js");
var wksDefine = __webpack_require__(/*! ./_wks-define */ "../../node_modules/core-js/library/modules/_wks-define.js");
var enumKeys = __webpack_require__(/*! ./_enum-keys */ "../../node_modules/core-js/library/modules/_enum-keys.js");
var isArray = __webpack_require__(/*! ./_is-array */ "../../node_modules/core-js/library/modules/_is-array.js");
var anObject = __webpack_require__(/*! ./_an-object */ "../../node_modules/core-js/library/modules/_an-object.js");
var isObject = __webpack_require__(/*! ./_is-object */ "../../node_modules/core-js/library/modules/_is-object.js");
var toObject = __webpack_require__(/*! ./_to-object */ "../../node_modules/core-js/library/modules/_to-object.js");
var toIObject = __webpack_require__(/*! ./_to-iobject */ "../../node_modules/core-js/library/modules/_to-iobject.js");
var toPrimitive = __webpack_require__(/*! ./_to-primitive */ "../../node_modules/core-js/library/modules/_to-primitive.js");
var createDesc = __webpack_require__(/*! ./_property-desc */ "../../node_modules/core-js/library/modules/_property-desc.js");
var _create = __webpack_require__(/*! ./_object-create */ "../../node_modules/core-js/library/modules/_object-create.js");
var gOPNExt = __webpack_require__(/*! ./_object-gopn-ext */ "../../node_modules/core-js/library/modules/_object-gopn-ext.js");
var $GOPD = __webpack_require__(/*! ./_object-gopd */ "../../node_modules/core-js/library/modules/_object-gopd.js");
var $GOPS = __webpack_require__(/*! ./_object-gops */ "../../node_modules/core-js/library/modules/_object-gops.js");
var $DP = __webpack_require__(/*! ./_object-dp */ "../../node_modules/core-js/library/modules/_object-dp.js");
var $keys = __webpack_require__(/*! ./_object-keys */ "../../node_modules/core-js/library/modules/_object-keys.js");
var gOPD = $GOPD.f;
var dP = $DP.f;
var gOPN = gOPNExt.f;
var $Symbol = global.Symbol;
var $JSON = global.JSON;
var _stringify = $JSON && $JSON.stringify;
var PROTOTYPE = 'prototype';
var HIDDEN = wks('_hidden');
var TO_PRIMITIVE = wks('toPrimitive');
var isEnum = {}.propertyIsEnumerable;
var SymbolRegistry = shared('symbol-registry');
var AllSymbols = shared('symbols');
var OPSymbols = shared('op-symbols');
var ObjectProto = Object[PROTOTYPE];
var USE_NATIVE = typeof $Symbol == 'function' && !!$GOPS.f;
var QObject = global.QObject;
// Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173
var setter = !QObject || !QObject[PROTOTYPE] || !QObject[PROTOTYPE].findChild;

// fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687
var setSymbolDesc = DESCRIPTORS && $fails(function () {
  return _create(dP({}, 'a', {
    get: function () { return dP(this, 'a', { value: 7 }).a; }
  })).a != 7;
}) ? function (it, key, D) {
  var protoDesc = gOPD(ObjectProto, key);
  if (protoDesc) delete ObjectProto[key];
  dP(it, key, D);
  if (protoDesc && it !== ObjectProto) dP(ObjectProto, key, protoDesc);
} : dP;

var wrap = function (tag) {
  var sym = AllSymbols[tag] = _create($Symbol[PROTOTYPE]);
  sym._k = tag;
  return sym;
};

var isSymbol = USE_NATIVE && typeof $Symbol.iterator == 'symbol' ? function (it) {
  return typeof it == 'symbol';
} : function (it) {
  return it instanceof $Symbol;
};

var $defineProperty = function defineProperty(it, key, D) {
  if (it === ObjectProto) $defineProperty(OPSymbols, key, D);
  anObject(it);
  key = toPrimitive(key, true);
  anObject(D);
  if (has(AllSymbols, key)) {
    if (!D.enumerable) {
      if (!has(it, HIDDEN)) dP(it, HIDDEN, createDesc(1, {}));
      it[HIDDEN][key] = true;
    } else {
      if (has(it, HIDDEN) && it[HIDDEN][key]) it[HIDDEN][key] = false;
      D = _create(D, { enumerable: createDesc(0, false) });
    } return setSymbolDesc(it, key, D);
  } return dP(it, key, D);
};
var $defineProperties = function defineProperties(it, P) {
  anObject(it);
  var keys = enumKeys(P = toIObject(P));
  var i = 0;
  var l = keys.length;
  var key;
  while (l > i) $defineProperty(it, key = keys[i++], P[key]);
  return it;
};
var $create = function create(it, P) {
  return P === undefined ? _create(it) : $defineProperties(_create(it), P);
};
var $propertyIsEnumerable = function propertyIsEnumerable(key) {
  var E = isEnum.call(this, key = toPrimitive(key, true));
  if (this === ObjectProto && has(AllSymbols, key) && !has(OPSymbols, key)) return false;
  return E || !has(this, key) || !has(AllSymbols, key) || has(this, HIDDEN) && this[HIDDEN][key] ? E : true;
};
var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(it, key) {
  it = toIObject(it);
  key = toPrimitive(key, true);
  if (it === ObjectProto && has(AllSymbols, key) && !has(OPSymbols, key)) return;
  var D = gOPD(it, key);
  if (D && has(AllSymbols, key) && !(has(it, HIDDEN) && it[HIDDEN][key])) D.enumerable = true;
  return D;
};
var $getOwnPropertyNames = function getOwnPropertyNames(it) {
  var names = gOPN(toIObject(it));
  var result = [];
  var i = 0;
  var key;
  while (names.length > i) {
    if (!has(AllSymbols, key = names[i++]) && key != HIDDEN && key != META) result.push(key);
  } return result;
};
var $getOwnPropertySymbols = function getOwnPropertySymbols(it) {
  var IS_OP = it === ObjectProto;
  var names = gOPN(IS_OP ? OPSymbols : toIObject(it));
  var result = [];
  var i = 0;
  var key;
  while (names.length > i) {
    if (has(AllSymbols, key = names[i++]) && (IS_OP ? has(ObjectProto, key) : true)) result.push(AllSymbols[key]);
  } return result;
};

// 19.4.1.1 Symbol([description])
if (!USE_NATIVE) {
  $Symbol = function Symbol() {
    if (this instanceof $Symbol) throw TypeError('Symbol is not a constructor!');
    var tag = uid(arguments.length > 0 ? arguments[0] : undefined);
    var $set = function (value) {
      if (this === ObjectProto) $set.call(OPSymbols, value);
      if (has(this, HIDDEN) && has(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
      setSymbolDesc(this, tag, createDesc(1, value));
    };
    if (DESCRIPTORS && setter) setSymbolDesc(ObjectProto, tag, { configurable: true, set: $set });
    return wrap(tag);
  };
  redefine($Symbol[PROTOTYPE], 'toString', function toString() {
    return this._k;
  });

  $GOPD.f = $getOwnPropertyDescriptor;
  $DP.f = $defineProperty;
  (__webpack_require__(/*! ./_object-gopn */ "../../node_modules/core-js/library/modules/_object-gopn.js").f) = gOPNExt.f = $getOwnPropertyNames;
  (__webpack_require__(/*! ./_object-pie */ "../../node_modules/core-js/library/modules/_object-pie.js").f) = $propertyIsEnumerable;
  $GOPS.f = $getOwnPropertySymbols;

  if (DESCRIPTORS && !__webpack_require__(/*! ./_library */ "../../node_modules/core-js/library/modules/_library.js")) {
    redefine(ObjectProto, 'propertyIsEnumerable', $propertyIsEnumerable, true);