"use strict";
(self["webpackChunk_elyra_pipeline_editor_extension"] = self["webpackChunk_elyra_pipeline_editor_extension"] || []).push([["vendors-node_modules_elyra_pipeline-services_dist_index_js"],{

/***/ "../../node_modules/@elyra/pipeline-services/dist/index.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/index.js ***!
  \*****************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
__exportStar(__webpack_require__(/*! ./migration */ "../../node_modules/@elyra/pipeline-services/dist/migration/index.js"), exports);
__exportStar(__webpack_require__(/*! ./validation */ "../../node_modules/@elyra/pipeline-services/dist/validation/index.js"), exports);


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/errors/index.js":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/errors/index.js ***!
  \**********************************************************************************/
/***/ (function(__unused_webpack_module, exports) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ComponentNotFoundError = void 0;
var ComponentNotFoundError = /** @class */ (function (_super) {
    __extends(ComponentNotFoundError, _super);
    function ComponentNotFoundError() {
        var _this = 
        /* istanbul ignore next */
        _super.call(this, "Component not found in any catalogue") || this;
        Object.setPrototypeOf(_this, ComponentNotFoundError.prototype);
        return _this;
    }
    return ComponentNotFoundError;
}(Error));
exports.ComponentNotFoundError = ComponentNotFoundError;


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/index.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/index.js ***!
  \***************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.migrate = void 0;
var immer_1 = __importDefault(__webpack_require__(/*! immer */ "../../node_modules/immer/dist/index.js"));
var migrateV1_1 = __importDefault(__webpack_require__(/*! ./migrateV1 */ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV1/index.js"));
var migrateV2_1 = __importDefault(__webpack_require__(/*! ./migrateV2 */ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV2/index.js"));
var migrateV3_1 = __importDefault(__webpack_require__(/*! ./migrateV3 */ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV3/index.js"));
var migrateV4_1 = __importDefault(__webpack_require__(/*! ./migrateV4 */ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV4/index.js"));
var migrateV5_1 = __importDefault(__webpack_require__(/*! ./migrateV5 */ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV5/index.js"));
var migrateV6_1 = __importDefault(__webpack_require__(/*! ./migrateV6 */ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV6/index.js"));
var migrateV7_1 = __importDefault(__webpack_require__(/*! ./migrateV7 */ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV7/index.js"));
var migrateV8_1 = __importDefault(__webpack_require__(/*! ./migrateV8 */ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV8/index.js"));
var utils_1 = __webpack_require__(/*! ./utils */ "../../node_modules/@elyra/pipeline-services/dist/migration/utils/index.js");
__exportStar(__webpack_require__(/*! ./errors */ "../../node_modules/@elyra/pipeline-services/dist/migration/errors/index.js"), exports);
function migrate(pipelineJSON, setNodePathsRelativeToPipelineV2) {
    return immer_1.default(pipelineJSON, function (draft) {
        var _a, _b;
        var version = (_b = (_a = draft.pipelines[0].app_data) === null || _a === void 0 ? void 0 : _a.version) !== null && _b !== void 0 ? _b : 0;
        if (version < 1) {
            console.debug("migrating pipeline from v0 to v1");
            migrateV1_1.default(draft);
        }
        if (version < 2) {
            console.debug("migrating pipeline from v1 to v2");
            migrateV2_1.default(draft, setNodePathsRelativeToPipelineV2);
        }
        if (version < 3) {
            console.debug("migrating pipeline from v2 to v3");
            migrateV3_1.default(draft);
        }
        if (version < 4) {
            console.debug("migrating pipeline from v3 to v4");
            migrateV4_1.default(draft);
        }
        if (version < 5) {
            console.debug("migrating pipeline from v4 to v5");
            migrateV5_1.default(draft);
        }
        // Note: starting with v8 the palette changed, so we now use
        // a copy of the palette as it was at v7 to migrate to v6/v7
        if (version < 6) {
            console.debug("migrating pipeline from v5 to v6");
            migrateV6_1.default(draft, utils_1.mockPaletteV7);
        }
        if (version < 7) {
            console.debug("migrating pipeline from v6 to v7");
            migrateV7_1.default(draft, utils_1.mockPaletteV7);
        }
        if (version < 8) {
            console.debug("migrating pipeline from v7 to v8");
            migrateV8_1.default(draft);
        }
    });
}
exports.migrate = migrate;


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV1/index.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/migrateV1/index.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var hasAppdataField = function (node, fieldName) {
    var _a;
    return !!((_a = node.app_data) === null || _a === void 0 ? void 0 : _a.hasOwnProperty(fieldName));
};
var deleteAppdataField = function (node, fieldName) {
    if (hasAppdataField(node, fieldName)) {
        delete node.app_data[fieldName];
    }
};
var renameAppdataField = function (node, currentFieldName, newFieldName) {
    if (hasAppdataField(node, currentFieldName)) {
        node.app_data[newFieldName] = node.app_data[currentFieldName];
        deleteAppdataField(node, currentFieldName);
    }
};
function migrate(pipeline) {
    var e_1, _a;
    renameAppdataField(pipeline.pipelines[0], "title", "name");
    deleteAppdataField(pipeline.pipelines[0], "export");
    deleteAppdataField(pipeline.pipelines[0], "export_format");
    deleteAppdataField(pipeline.pipelines[0], "export_path");
    try {
        for (var _b = __values(pipeline.pipelines[0].nodes), _c = _b.next(); !_c.done; _c = _b.next()) {
            var node = _c.value;
            if (node.type === "pipeline_node") {
                node.type = "execution_node";
            }
            node.op = "execute-notebook-node";
            renameAppdataField(node, "notebook", "filename");
            renameAppdataField(node, "artifact", "filename");
            renameAppdataField(node, "docker_image", "runtime_image");
            renameAppdataField(node, "image", "runtime_image");
            renameAppdataField(node, "vars", "env_vars");
            renameAppdataField(node, "file_dependencies", "dependencies");
            renameAppdataField(node, "recursive_dependencies", "include_subdirectories");
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_1) throw e_1.error; }
    }
    if (pipeline.pipelines[0].app_data) {
        pipeline.pipelines[0].app_data.version = 1;
    }
    else {
        pipeline.pipelines[0].app_data = { version: 1 };
    }
    return pipeline;
}
exports["default"] = migrate;


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV2/index.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/migrateV2/index.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var path_1 = __importDefault(__webpack_require__(/*! path */ "../../node_modules/path-browserify/index.js"));
// NOTE: technically a pipeline can have a missing app_data field however, if
// this is really an Elyra v1 pipeline, it should be guaranteed to have app_data
// otherwise we wouldn't know this is a v1 pipeline.
function migrate(pipeline, setNodePathsRelativeToPipelineV2) {
    var e_1, _a;
    if (setNodePathsRelativeToPipelineV2) {
        pipeline.pipelines[0] = setNodePathsRelativeToPipelineV2(pipeline.pipelines[0]);
    }
    else {
        try {
            for (var _b = __values(pipeline.pipelines[0].nodes), _c = _b.next(); !_c.done; _c = _b.next()) {
                var node = _c.value;
                if (node.app_data) {
                    // If setNodePathsRelativeToPipeline is not given then just set
                    // filename to the basename and the user will have to update the correct
                    // path in node properties
                    node.app_data.filename = path_1.default.basename(node.app_data.filename);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    pipeline.pipelines[0].app_data.version = 2;
    return pipeline;
}
exports["default"] = migrate;


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV3/index.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/migrateV3/index.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
// NOTE: technically a pipeline can have a missing app_data field however, if
// this is really an Elyra v2 pipeline, it should be guaranteed to have app_data
// otherwise we wouldn't know this is a v2 pipeline.
function migrate(pipeline) {
    // No-Op this is to disable old versions of Elyra
    // to see a pipeline with Python Script nodes
    pipeline.pipelines[0].app_data.version = 3;
    return pipeline;
}
exports["default"] = migrate;


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV4/index.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/migrateV4/index.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
function migrate(pipelineFlow) {
    var e_1, _a, e_2, _b;
    var _c, _d, _e;
    try {
        for (var _f = __values(pipelineFlow.pipelines), _g = _f.next(); !_g.done; _g = _f.next()) {
            var pipeline = _g.value;
            try {
                for (var _h = (e_2 = void 0, __values(pipeline.nodes)), _j = _h.next(); !_j.done; _j = _h.next()) {
                    var node = _j.value;
                    if (node.type === "execution_node") {
                        node.app_data = {
                            label: (_d = (_c = node.app_data.ui_data) === null || _c === void 0 ? void 0 : _c.label) !== null && _d !== void 0 ? _d : "",
                            component_parameters: node.app_data,
                            ui_data: (_e = node.app_data.ui_data) !== null && _e !== void 0 ? _e : {},
                        };
                        delete node.app_data.component_parameters.ui_data;
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_j && !_j.done && (_b = _h.return)) _b.call(_h);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_g && !_g.done && (_a = _f.return)) _a.call(_f);
        }
        finally { if (e_1) throw e_1.error; }
    }
    pipelineFlow.pipelines[0].app_data.version = 4;
    return pipelineFlow;
}
exports["default"] = migrate;


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV5/index.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/migrateV5/index.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var opMap = {
    "run-notebook-using-papermill": "run_notebook_using_papermill_Runnotebookusingpapermill",
    "filter-text": "filter_text_using_shell_and_grep_Filtertext",
    "bash-operator_BashOperator": "bash_operator_BashOperator",
    "email-operator_EmailOperator": "email_operator_EmailOperator",
    "http-operator_SimpleHttpOperator": "http_operator_SimpleHttpOperator",
    "spark-sql-operator_SparkSqlOperator": "spark_sql_operator_SparkSqlOperator",
    "spark-submit-operator_SparkSubmitOperator": "spark_submit_operator_SparkSubmitOperator",
    "slack-operator_SlackAPIPostOperator": "slack_operator_SlackAPIPostOperator",
};
function migrate(pipelineFlow) {
    var e_1, _a, e_2, _b;
    try {
        for (var _c = __values(pipelineFlow.pipelines), _d = _c.next(); !_d.done; _d = _c.next()) {
            var pipeline = _d.value;
            try {
                for (var _e = (e_2 = void 0, __values(pipeline.nodes)), _f = _e.next(); !_f.done; _f = _e.next()) {
                    var node = _f.value;
                    var newOp = opMap[node.op];
                    if (newOp) {
                        node.op = newOp;
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
        }
        finally { if (e_1) throw e_1.error; }
    }
    pipelineFlow.pipelines[0].app_data.version = 5;
    return pipelineFlow;
}
exports["default"] = migrate;


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV6/index.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/migrateV6/index.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.opMap = void 0;
var path_1 = __importDefault(__webpack_require__(/*! path */ "../../node_modules/path-browserify/index.js"));
var errors_1 = __webpack_require__(/*! ../errors */ "../../node_modules/@elyra/pipeline-services/dist/migration/errors/index.js");
exports.opMap = {
    run_notebook_using_papermill_Runnotebookusingpapermill: "elyra-kfp-examples-catalog:61e6f4141f65",
    filter_text_using_shell_and_grep_Filtertext: "elyra-kfp-examples-catalog:737915b826e9",
    component_Downloaddata: "elyra-kfp-examples-catalog:a08014f9252f",
    component_Calculatedatahash: "elyra-kfp-examples-catalog:d68ec7fcdf46",
    bash_operator_BashOperator: "elyra-airflow-examples-catalog:3a55d015ea96",
    email_operator_EmailOperator: "elyra-airflow-examples-catalog:a043648d3897",
    http_operator_SimpleHttpOperator: "elyra-airflow-examples-catalog:b94cd49692e2",
    spark_sql_operator_SparkSqlOperator: "elyra-airflow-examples-catalog:3b639742748f",
    spark_submit_operator_SparkSubmitOperator: "elyra-airflow-examples-catalog:b29c25ec8bd6",
    slack_operator_SlackAPIPostOperator: "elyra-airflow-examples-catalog:16a204f716a2",
};
var runtimeTypeMap = {
    kfp: "KUBEFLOW_PIPELINES",
    airflow: "APACHE_AIRFLOW",
};
function migrate(pipelineFlow, palette) {
    var e_1, _a, e_2, _b, e_3, _c;
    var _d;
    var paletteNodes = [];
    try {
        for (var _e = __values((palette === null || palette === void 0 ? void 0 : palette.categories) || []), _f = _e.next(); !_f.done; _f = _e.next()) {
            var c = _f.value;
            if (c.node_types) {
                paletteNodes.push.apply(paletteNodes, __spread(c.node_types));
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_f && !_f.done && (_a = _e.return)) _a.call(_e);
        }
        finally { if (e_1) throw e_1.error; }
    }
    // Add runtime type based on previous runtime property
    pipelineFlow.pipelines[0].app_data.runtime_type =
        runtimeTypeMap[pipelineFlow.pipelines[0].app_data.runtime];
    delete pipelineFlow.pipelines[0].app_data.runtime;
    try {
        for (var _g = __values(pipelineFlow.pipelines), _h = _g.next(); !_h.done; _h = _g.next()) {
            var pipeline = _h.value;
            var _loop_1 = function (node) {
                var newOp = exports.opMap[node.op];
                if (newOp) {
                    // update op string
                    node.op = newOp;
                    // update component_source from string to json
                    var opParts = newOp.split(":");
                    var catalog_type = opParts[0];
                    var component_ref = {};
                    component_ref["component-id"] = path_1.default.basename(node.app_data.component_source);
                    // handle the two cases where the filename changed
                    if (component_ref["component-id"] === "component.yaml") {
                        switch (opParts[1]) {
                            case "a08014f9252f":
                                component_ref["component-id"] = "download_data.yaml";
                                break;
                            case "d68ec7fcdf46":
                                component_ref["component-id"] = "calculate_hash.yaml";
                        }
                    }
                    node.app_data.component_source = JSON.stringify({
                        catalog_type: catalog_type,
                        component_ref: component_ref,
                    });
                    // update format of values that have switch to using OneOfControl
                    // running this inside the if since only those nodes use OneOfControl
                    // only running on airflow components since kfp migration is handled in v7
                    if (pipelineFlow.pipelines[0].app_data.runtime_type === "APACHE_AIRFLOW") {
                        var nodePropertiesSchema = paletteNodes.find(function (n) { return n.op === node.op; });
                        if (nodePropertiesSchema === undefined) {
                            throw new errors_1.ComponentNotFoundError();
                        }
                        var propertyDefs_1 = nodePropertiesSchema.app_data.properties.uihints.parameter_info;
                        Object.keys((_d = node.app_data.component_parameters) !== null && _d !== void 0 ? _d : {}).forEach(function (key) {
                            var _a;
                            var propDef = propertyDefs_1.find(function (p) { return p.parameter_ref === "elyra_" + key; });
                            if ((propDef === null || propDef === void 0 ? void 0 : propDef.custom_control_id) === "OneOfControl") {
                                var activeControl = Object.keys(propDef.data.controls).find(function (c) { return c !== "NestedEnumControl"; }) || "";
                                node.app_data.component_parameters[key] = (_a = {
                                        activeControl: activeControl
                                    },
                                    _a[activeControl] = node.app_data.component_parameters[key],
                                    _a);
                            }
                        });
                    }
                }
            };
            try {
                for (var _j = (e_3 = void 0, __values(pipeline.nodes)), _k = _j.next(); !_k.done; _k = _j.next()) {
                    var node = _k.value;
                    _loop_1(node);
                }
            }
            catch (e_3_1) { e_3 = { error: e_3_1 }; }
            finally {
                try {
                    if (_k && !_k.done && (_c = _j.return)) _c.call(_j);
                }
                finally { if (e_3) throw e_3.error; }
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (_h && !_h.done && (_b = _g.return)) _b.call(_g);
        }
        finally { if (e_2) throw e_2.error; }
    }
    pipelineFlow.pipelines[0].app_data.version = 6;
    return pipelineFlow;
}
exports["default"] = migrate;


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV7/index.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/migrateV7/index.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var errors_1 = __webpack_require__(/*! ../errors */ "../../node_modules/@elyra/pipeline-services/dist/migration/errors/index.js");
var migrateV6_1 = __webpack_require__(/*! ../migrateV6 */ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV6/index.js");
function migrate(pipelineFlow, palette) {
    var e_1, _a, e_2, _b, e_3, _c;
    var _d;
    var paletteNodes = [];
    try {
        for (var _e = __values((palette === null || palette === void 0 ? void 0 : palette.categories) || []), _f = _e.next(); !_f.done; _f = _e.next()) {
            var c = _f.value;
            if (c.node_types) {
                paletteNodes.push.apply(paletteNodes, __spread(c.node_types));
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_f && !_f.done && (_a = _e.return)) _a.call(_e);
        }
        finally { if (e_1) throw e_1.error; }
    }
    var validOps = Object.values(migrateV6_1.opMap);
    if (pipelineFlow.pipelines[0].app_data.runtime_type === "KUBEFLOW_PIPELINES") {
        try {
            for (var _g = __values(pipelineFlow.pipelines), _h = _g.next(); !_h.done; _h = _g.next()) {
                var pipeline = _h.value;
                var _loop_1 = function (node) {
                    // Only run on valid node ops as migrated in v6
                    if (validOps.includes(node.op)) {
                        // update format of inputvalue properties to using OneOfControl format
                        var nodePropertiesSchema = paletteNodes.find(function (n) { return n.op === node.op; });
                        if (nodePropertiesSchema === undefined) {
                            throw new errors_1.ComponentNotFoundError();
                        }
                        var propertyDefs_1 = nodePropertiesSchema.app_data.properties.uihints.parameter_info;
                        Object.keys((_d = node.app_data.component_parameters) !== null && _d !== void 0 ? _d : {}).forEach(function (key) {
                            var _a;
                            var propDef = propertyDefs_1.find(function (p) { return p.parameter_ref === "elyra_" + key; });
                            if ((propDef === null || propDef === void 0 ? void 0 : propDef.custom_control_id) === "OneOfControl") {
                                var activeControl = Object.keys(propDef.data.controls).find(function (c) { return c !== "NestedEnumControl"; }) || "";
                                node.app_data.component_parameters[key] = (_a = {
                                        activeControl: activeControl
                                    },
                                    _a[activeControl] = node.app_data.component_parameters[key],
                                    _a);
                            }
                        });
                    }
                };
                try {
                    for (var _j = (e_3 = void 0, __values(pipeline.nodes)), _k = _j.next(); !_k.done; _k = _j.next()) {
                        var node = _k.value;
                        _loop_1(node);
                    }
                }
                catch (e_3_1) { e_3 = { error: e_3_1 }; }
                finally {
                    try {
                        if (_k && !_k.done && (_c = _j.return)) _c.call(_j);
                    }
                    finally { if (e_3) throw e_3.error; }
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_h && !_h.done && (_b = _g.return)) _b.call(_g);
            }
            finally { if (e_2) throw e_2.error; }
        }
    }
    pipelineFlow.pipelines[0].app_data.version = 7;
    return pipelineFlow;
}
exports["default"] = migrate;


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/migrateV8/index.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/migrateV8/index.js ***!
  \*************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
var widgetMap = {
    BooleanControl: "boolean",
    NumberControl: "number",
    NestedEnumControl: "inputpath",
    StringControl: "string",
};
var regexMap = {
    env_vars: /(?<env_var>\w+)=?(?<value>[^,]*?)(?= \w+=|$)/,
    mounted_volumes: /(?<path>[\w/]+)=?(?<pvc_name>[^,]*?)(?= \w+=|$)/,
    kubernetes_pod_annotations: /(?<key>\w+)=?(?<value>[^,]*?)(?= \w+=|$)/,
    kubernetes_secrets: /(?<env_var>\w+)=?(?<name>[^:,\n\]]*):?(?<key>[^,]*?)(?= \w+=|$)/,
    kubernetes_tolerations: /\w+=(?<key>.*?):(?<operator>[^,]*?):(?<value>[^,]*?):(?<effect>[^,]*?)(?= \w+=|$)/,
};
function migrate(pipelineFlow) {
    var e_1, _a;
    var _b, _c, _d, _e, _f;
    var _loop_1 = function (pipeline) {
        var e_2, _a;
        Object.keys((_d = (_c = (_b = pipeline.app_data) === null || _b === void 0 ? void 0 : _b.properties) === null || _c === void 0 ? void 0 : _c.pipeline_defaults) !== null && _d !== void 0 ? _d : {}).forEach(function (key) {
            var e_3, _a;
            // Update KeyValue arrays to dict arrays
            if (Object.keys(regexMap).includes(key)) {
                var new_items = [];
                try {
                    for (var _b = (e_3 = void 0, __values(pipeline.app_data.properties.pipeline_defaults[key])), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var item = _c.value;
                        var dict = item.match(regexMap[key]).groups;
                        new_items.push(dict);
                    }
                }
                catch (e_3_1) { e_3 = { error: e_3_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_3) throw e_3.error; }
                }
                pipeline.app_data.properties.pipeline_defaults[key] = new_items;
            }
        });
        var _loop_2 = function (node) {
            Object.keys((_f = (_e = node.app_data) === null || _e === void 0 ? void 0 : _e.component_parameters) !== null && _f !== void 0 ? _f : {}).forEach(function (key) {
                var e_4, _a;
                var _b, _c;
                // Update oneOf format
                var activeControl = (_b = node.app_data.component_parameters[key]) === null || _b === void 0 ? void 0 : _b.activeControl;
                if (activeControl) {
                    node.app_data.component_parameters[key] = {
                        widget: widgetMap[activeControl],
                        value: node.app_data.component_parameters[key][activeControl],
                    };
                }
                // Update inputpath format
                var propKeys = Object.keys((_c = node.app_data.component_parameters[key]) !== null && _c !== void 0 ? _c : {});
                if (propKeys.length === 2 &&
                    propKeys.includes("option") &&
                    propKeys.includes("value")) {
                    node.app_data.component_parameters[key] = {
                        widget: "inputpath",
                        value: node.app_data.component_parameters[key],
                    };
                }
                // Update KeyValue arrays to dict arrays
                if (Object.keys(regexMap).includes(key) &&
                    Array.isArray(node.app_data.component_parameters[key])) {
                    var new_items = [];
                    try {
                        for (var _d = (e_4 = void 0, __values(node.app_data.component_parameters[key])), _e = _d.next(); !_e.done; _e = _d.next()) {
                            var item = _e.value;
                            var dict = item.match(regexMap[key]).groups;
                            new_items.push(dict);
                        }
                    }
                    catch (e_4_1) { e_4 = { error: e_4_1 }; }
                    finally {
                        try {
                            if (_e && !_e.done && (_a = _d.return)) _a.call(_d);
                        }
                        finally { if (e_4) throw e_4.error; }
                    }
                    node.app_data.component_parameters[key] = new_items;
                }
            });
        };
        try {
            for (var _b = (e_2 = void 0, __values(pipeline.nodes)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var node = _c.value;
                _loop_2(node);
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_2) throw e_2.error; }
        }
    };
    try {
        for (var _g = __values(pipelineFlow.pipelines), _h = _g.next(); !_h.done; _h = _g.next()) {
            var pipeline = _h.value;
            _loop_1(pipeline);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_h && !_h.done && (_a = _g.return)) _a.call(_g);
        }
        finally { if (e_1) throw e_1.error; }
    }
    pipelineFlow.pipelines[0].app_data.version = 8;
    return pipelineFlow;
}
exports["default"] = migrate;


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/migration/utils/index.js":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/migration/utils/index.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.mockPaletteV7 = void 0;
// mock palette created by copying palette content as it was prior
// to pipeline v8
exports.mockPaletteV7 = {
    version: "3.0",
    categories: [
        {
            id: "Elyra",
            label: "Elyra",
            node_types: [
                {
                    op: "execute-notebook-node",
                    description: "Run notebook file",
                    id: "notebook",
                    image: "data:image/svg+xml;utf8,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2216%22%20viewBox%3D%220%200%2022%2022%22%3E%0A%20%20%3Cg%20class%3D%22jp-icon-warn0%20jp-icon-selectable%22%20fill%3D%22%23EF6C00%22%3E%0A%20%20%20%20%3Cpath%20d%3D%22M18.7%203.3v15.4H3.3V3.3h15.4m1.5-1.5H1.8v18.3h18.3l.1-18.3z%22%2F%3E%0A%20%20%20%20%3Cpath%20d%3D%22M16.5%2016.5l-5.4-4.3-5.6%204.3v-11h11z%22%2F%3E%0A%20%20%3C%2Fg%3E%0A%3C%2Fsvg%3E%0A",
                    label: "Notebook",
                    type: "execution_node",
                    inputs: [
                        {
                            id: "inPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Input Port",
                                },
                            },
                        },
                    ],
                    outputs: [
                        {
                            id: "outPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Output Port",
                                },
                            },
                        },
                    ],
                    parameters: {},
                    app_data: {
                        extensions: [".ipynb"],
                        parameter_refs: {
                            filehandler: "filename",
                        },
                        image: "data:image/svg+xml;utf8,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2216%22%20viewBox%3D%220%200%2022%2022%22%3E%0A%20%20%3Cg%20class%3D%22jp-icon-warn0%20jp-icon-selectable%22%20fill%3D%22%23EF6C00%22%3E%0A%20%20%20%20%3Cpath%20d%3D%22M18.7%203.3v15.4H3.3V3.3h15.4m1.5-1.5H1.8v18.3h18.3l.1-18.3z%22%2F%3E%0A%20%20%20%20%3Cpath%20d%3D%22M16.5%2016.5l-5.4-4.3-5.6%204.3v-11h11z%22%2F%3E%0A%20%20%3C%2Fg%3E%0A%3C%2Fsvg%3E%0A",
                        ui_data: {
                            description: "Run notebook file",
                            label: "Notebook",
                            image: "data:image/svg+xml;utf8,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2216%22%20viewBox%3D%220%200%2022%2022%22%3E%0A%20%20%3Cg%20class%3D%22jp-icon-warn0%20jp-icon-selectable%22%20fill%3D%22%23EF6C00%22%3E%0A%20%20%20%20%3Cpath%20d%3D%22M18.7%203.3v15.4H3.3V3.3h15.4m1.5-1.5H1.8v18.3h18.3l.1-18.3z%22%2F%3E%0A%20%20%20%20%3Cpath%20d%3D%22M16.5%2016.5l-5.4-4.3-5.6%204.3v-11h11z%22%2F%3E%0A%20%20%3C%2Fg%3E%0A%3C%2Fsvg%3E%0A",
                            x_pos: 0,
                            y_pos: 0,
                        },
                        properties: {
                            current_parameters: {
                                label: "",
                                elyra_filename: "",
                                elyra_runtime_image: "",
                                elyra_cpu: null,
                                elyra_gpu: null,
                                elyra_memory: null,
                                elyra_outputs: [],
                                elyra_env_vars: [],
                                elyra_dependencies: [],
                                elyra_include_subdirectories: false,
                            },
                            parameters: [
                                {
                                    id: "label",
                                },
                                {
                                    id: "elyra_filename",
                                },
                                {
                                    id: "elyra_runtime_image",
                                },
                                {
                                    id: "elyra_cpu",
                                },
                                {
                                    id: "elyra_gpu",
                                },
                                {
                                    id: "elyra_memory",
                                },
                                {
                                    id: "elyra_dependencies",
                                },
                                {
                                    id: "elyra_include_subdirectories",
                                },
                                {
                                    id: "elyra_env_vars",
                                },
                                {
                                    id: "elyra_outputs",
                                },
                            ],
                            uihints: {
                                id: "nodeProperties",
                                parameter_info: [
                                    {
                                        parameter_ref: "label",
                                        control: "custom",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Label",
                                        },
                                        description: {
                                            default: "A custom label for the node.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                    {
                                        parameter_ref: "elyra_filename",
                                        control: "custom",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Filename",
                                        },
                                        description: {
                                            default: "The path to the Notebook.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            format: "file",
                                            required: true,
                                            extensions: [".ipynb"],
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_runtime_image",
                                        control: "custom",
                                        custom_control_id: "EnumControl",
                                        label: {
                                            default: "Runtime Image",
                                        },
                                        description: {
                                            default: "Docker image used as execution environment.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            items: [],
                                            required: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_cpu",
                                        control: "custom",
                                        custom_control_id: "NumberControl",
                                        label: {
                                            default: "CPU",
                                        },
                                        description: {
                                            default: "For CPU-intensive workloads, you can choose more than 1 CPU (e.g. 1.5).",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            minimum: 0,
                                            maximum: 99,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_gpu",
                                        control: "custom",
                                        custom_control_id: "NumberControl",
                                        label: {
                                            default: "GPU",
                                        },
                                        description: {
                                            default: "For GPU-intensive workloads, you can choose more than 1 GPU. Must be an integer.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            minimum: 0,
                                            maximum: 99,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_memory",
                                        control: "custom",
                                        custom_control_id: "NumberControl",
                                        label: {
                                            default: "RAM(GB)",
                                        },
                                        description: {
                                            default: "The total amount of RAM specified.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            minimum: 0,
                                            maximum: 99,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_dependencies",
                                        control: "custom",
                                        custom_control_id: "StringArrayControl",
                                        label: {
                                            default: "File Dependencies",
                                        },
                                        description: {
                                            default: "Local file dependencies that need to be copied to remote execution environment.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            placeholder: "*.py",
                                            format: "file",
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_include_subdirectories",
                                        control: "custom",
                                        custom_control_id: "BooleanControl",
                                        label: {
                                            default: "Include Subdirectories",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            description: "Recursively include subdirectories when submitting a pipeline (This may increase submission time).",
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_env_vars",
                                        control: "custom",
                                        custom_control_id: "StringArrayControl",
                                        label: {
                                            default: "Environment Variables",
                                        },
                                        description: {
                                            default: "Environment variables to be set on the execution environment.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            placeholder: "env_var=VALUE",
                                            canRefresh: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_outputs",
                                        control: "custom",
                                        custom_control_id: "StringArrayControl",
                                        label: {
                                            default: "Output Files",
                                        },
                                        description: {
                                            default: "Files generated during execution that will become available to all subsequent pipeline steps.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            placeholder: "*.csv",
                                        },
                                    },
                                ],
                                group_info: [
                                    {
                                        id: "nodeGroupInfo",
                                        type: "panels",
                                        group_info: [
                                            {
                                                id: "label",
                                                type: "controls",
                                                parameter_refs: ["label"],
                                            },
                                            {
                                                id: "elyra_filename",
                                                type: "controls",
                                                parameter_refs: ["elyra_filename"],
                                            },
                                            {
                                                id: "elyra_runtime_image",
                                                type: "controls",
                                                parameter_refs: ["elyra_runtime_image"],
                                            },
                                            {
                                                id: "elyra_resources",
                                                type: "controls",
                                                parameter_refs: [
                                                    "elyra_cpu",
                                                    "elyra_gpu",
                                                    "elyra_memory",
                                                ],
                                            },
                                            {
                                                id: "elyra_dependencies",
                                                type: "controls",
                                                parameter_refs: ["elyra_dependencies"],
                                            },
                                            {
                                                id: "elyra_include_subdirectories",
                                                type: "controls",
                                                parameter_refs: ["elyra_include_subdirectories"],
                                            },
                                            {
                                                id: "elyra_env_vars",
                                                type: "controls",
                                                parameter_refs: ["elyra_env_vars"],
                                            },
                                            {
                                                id: "elyra_outputs",
                                                type: "controls",
                                                parameter_refs: ["elyra_outputs"],
                                            },
                                        ],
                                    },
                                ],
                            },
                            resources: {},
                        },
                    },
                },
                {
                    op: "execute-python-node",
                    description: "Run Python script",
                    id: "python-script",
                    image: "data:image/svg+xml;utf8,%3Csvg%20width%3D%2232%22%20height%3D%2232%22%20viewBox%3D%220%200%20238%20237%22%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20xmlns%3Axlink%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2Fxlink%22%20overflow%3D%22hidden%22%3E%0A%20%20%20%20%3Cdefs%3E%0A%20%20%20%20%20%20%20%20%3CclipPath%20id%3D%22clip0%22%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%3Cpath%20d%3D%22M706-314%20944-314%20944-77%20706-77Z%22%20fill-rule%3D%22evenodd%22%20clip-rule%3D%22evenodd%22%2F%3E%0A%20%20%20%20%20%20%20%20%3C%2FclipPath%3E%0A%20%20%20%20%3C%2Fdefs%3E%0A%20%20%20%20%3Cg%20clip-path%3D%22url(%23clip0)%22%20transform%3D%22translate(-706%20314)%22%3E%0A%20%20%20%20%20%20%20%20%3Cpath%20d%3D%22M792.441-295.763C786.496-295.763%20781.697-290.979%20781.697-285.062%20781.697-279.166%20786.496-274.382%20792.441-274.382%20798.365-274.382%20803.184-279.166%20803.184-285.062%20803.184-290.979%20798.365-295.763%20792.441-295.763ZM823.472-312.998C833.277-313.043%20843.484-312.329%20853.336-310.724%20868.899-308.185%20882-296.728%20882-281.516L882-228.072C882-212.398%20869.282-199.557%20853.336-199.557L796.03-199.557C776.58-199.557%20760.189-183.169%20760.189-164.641L760.189-139%20740.485-139C723.817-139%20714.114-150.877%20710.037-167.494%20704.538-189.82%20704.772-203.124%20710.037-224.505%20714.602-243.159%20729.189-253%20745.857-253L767.365-253%20824.693-253%20824.693-260.134%20767.365-260.134%20767.365-281.516C767.365-297.715%20771.76-306.527%20796.03-310.724%20804.268-312.151%20813.668-312.953%20823.472-312.998Z%22%20fill%3D%22%23366A96%22%20fill-rule%3D%22evenodd%22%2F%3E%0A%20%20%20%20%20%20%20%20%3Cpath%20d%3D%22M857.377-117.071C851.466-117.071%20846.655-112.267%20846.655-106.348%20846.655-100.406%20851.466-95.6026%20857.377-95.6026%20863.31-95.6026%20868.099-100.406%20868.099-106.348%20868.099-112.267%20863.31-117.071%20857.377-117.071ZM889.563-253%20911.007-253C927.662-253%20935.502-240.696%20939.614-224.39%20945.334-201.743%20945.589-184.804%20939.614-167.148%20933.828-150%20927.642-138.539%20911.007-138.539L882.402-138.539%20825.211-138.539%20825.211-131.375%20882.402-131.375%20882.402-109.908C882.402-93.6435%20868.205-85.4055%20853.796-81.2973%20832.12-75.1034%20814.722-76.0513%20796.606-81.2973%20781.476-85.6801%20768-94.6332%20768-109.908L768-163.568C768-179.01%20780.947-192.199%20796.606-192.199L853.796-192.199C872.846-192.199%20889.563-208.568%20889.563-227.971Z%22%20fill%3D%22%23FFC836%22%20fill-rule%3D%22evenodd%22%2F%3E%0A%20%20%20%20%3C%2Fg%3E%0A%3C%2Fsvg%3E%0A",
                    label: "Python Script",
                    type: "execution_node",
                    inputs: [
                        {
                            id: "inPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Input Port",
                                },
                            },
                        },
                    ],
                    outputs: [
                        {
                            id: "outPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Output Port",
                                },
                            },
                        },
                    ],
                    parameters: {},
                    app_data: {
                        extensions: [".py"],
                        parameter_refs: {
                            filehandler: "filename",
                        },
                        image: "data:image/svg+xml;utf8,%3Csvg%20width%3D%2232%22%20height%3D%2232%22%20viewBox%3D%220%200%20238%20237%22%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20xmlns%3Axlink%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2Fxlink%22%20overflow%3D%22hidden%22%3E%0A%20%20%20%20%3Cdefs%3E%0A%20%20%20%20%20%20%20%20%3CclipPath%20id%3D%22clip0%22%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%3Cpath%20d%3D%22M706-314%20944-314%20944-77%20706-77Z%22%20fill-rule%3D%22evenodd%22%20clip-rule%3D%22evenodd%22%2F%3E%0A%20%20%20%20%20%20%20%20%3C%2FclipPath%3E%0A%20%20%20%20%3C%2Fdefs%3E%0A%20%20%20%20%3Cg%20clip-path%3D%22url(%23clip0)%22%20transform%3D%22translate(-706%20314)%22%3E%0A%20%20%20%20%20%20%20%20%3Cpath%20d%3D%22M792.441-295.763C786.496-295.763%20781.697-290.979%20781.697-285.062%20781.697-279.166%20786.496-274.382%20792.441-274.382%20798.365-274.382%20803.184-279.166%20803.184-285.062%20803.184-290.979%20798.365-295.763%20792.441-295.763ZM823.472-312.998C833.277-313.043%20843.484-312.329%20853.336-310.724%20868.899-308.185%20882-296.728%20882-281.516L882-228.072C882-212.398%20869.282-199.557%20853.336-199.557L796.03-199.557C776.58-199.557%20760.189-183.169%20760.189-164.641L760.189-139%20740.485-139C723.817-139%20714.114-150.877%20710.037-167.494%20704.538-189.82%20704.772-203.124%20710.037-224.505%20714.602-243.159%20729.189-253%20745.857-253L767.365-253%20824.693-253%20824.693-260.134%20767.365-260.134%20767.365-281.516C767.365-297.715%20771.76-306.527%20796.03-310.724%20804.268-312.151%20813.668-312.953%20823.472-312.998Z%22%20fill%3D%22%23366A96%22%20fill-rule%3D%22evenodd%22%2F%3E%0A%20%20%20%20%20%20%20%20%3Cpath%20d%3D%22M857.377-117.071C851.466-117.071%20846.655-112.267%20846.655-106.348%20846.655-100.406%20851.466-95.6026%20857.377-95.6026%20863.31-95.6026%20868.099-100.406%20868.099-106.348%20868.099-112.267%20863.31-117.071%20857.377-117.071ZM889.563-253%20911.007-253C927.662-253%20935.502-240.696%20939.614-224.39%20945.334-201.743%20945.589-184.804%20939.614-167.148%20933.828-150%20927.642-138.539%20911.007-138.539L882.402-138.539%20825.211-138.539%20825.211-131.375%20882.402-131.375%20882.402-109.908C882.402-93.6435%20868.205-85.4055%20853.796-81.2973%20832.12-75.1034%20814.722-76.0513%20796.606-81.2973%20781.476-85.6801%20768-94.6332%20768-109.908L768-163.568C768-179.01%20780.947-192.199%20796.606-192.199L853.796-192.199C872.846-192.199%20889.563-208.568%20889.563-227.971Z%22%20fill%3D%22%23FFC836%22%20fill-rule%3D%22evenodd%22%2F%3E%0A%20%20%20%20%3C%2Fg%3E%0A%3C%2Fsvg%3E%0A",
                        ui_data: {
                            description: "Run Python script",
                            label: "Python Script",
                            image: "data:image/svg+xml;utf8,%3Csvg%20width%3D%2232%22%20height%3D%2232%22%20viewBox%3D%220%200%20238%20237%22%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20xmlns%3Axlink%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2Fxlink%22%20overflow%3D%22hidden%22%3E%0A%20%20%20%20%3Cdefs%3E%0A%20%20%20%20%20%20%20%20%3CclipPath%20id%3D%22clip0%22%3E%0A%20%20%20%20%20%20%20%20%20%20%20%20%3Cpath%20d%3D%22M706-314%20944-314%20944-77%20706-77Z%22%20fill-rule%3D%22evenodd%22%20clip-rule%3D%22evenodd%22%2F%3E%0A%20%20%20%20%20%20%20%20%3C%2FclipPath%3E%0A%20%20%20%20%3C%2Fdefs%3E%0A%20%20%20%20%3Cg%20clip-path%3D%22url(%23clip0)%22%20transform%3D%22translate(-706%20314)%22%3E%0A%20%20%20%20%20%20%20%20%3Cpath%20d%3D%22M792.441-295.763C786.496-295.763%20781.697-290.979%20781.697-285.062%20781.697-279.166%20786.496-274.382%20792.441-274.382%20798.365-274.382%20803.184-279.166%20803.184-285.062%20803.184-290.979%20798.365-295.763%20792.441-295.763ZM823.472-312.998C833.277-313.043%20843.484-312.329%20853.336-310.724%20868.899-308.185%20882-296.728%20882-281.516L882-228.072C882-212.398%20869.282-199.557%20853.336-199.557L796.03-199.557C776.58-199.557%20760.189-183.169%20760.189-164.641L760.189-139%20740.485-139C723.817-139%20714.114-150.877%20710.037-167.494%20704.538-189.82%20704.772-203.124%20710.037-224.505%20714.602-243.159%20729.189-253%20745.857-253L767.365-253%20824.693-253%20824.693-260.134%20767.365-260.134%20767.365-281.516C767.365-297.715%20771.76-306.527%20796.03-310.724%20804.268-312.151%20813.668-312.953%20823.472-312.998Z%22%20fill%3D%22%23366A96%22%20fill-rule%3D%22evenodd%22%2F%3E%0A%20%20%20%20%20%20%20%20%3Cpath%20d%3D%22M857.377-117.071C851.466-117.071%20846.655-112.267%20846.655-106.348%20846.655-100.406%20851.466-95.6026%20857.377-95.6026%20863.31-95.6026%20868.099-100.406%20868.099-106.348%20868.099-112.267%20863.31-117.071%20857.377-117.071ZM889.563-253%20911.007-253C927.662-253%20935.502-240.696%20939.614-224.39%20945.334-201.743%20945.589-184.804%20939.614-167.148%20933.828-150%20927.642-138.539%20911.007-138.539L882.402-138.539%20825.211-138.539%20825.211-131.375%20882.402-131.375%20882.402-109.908C882.402-93.6435%20868.205-85.4055%20853.796-81.2973%20832.12-75.1034%20814.722-76.0513%20796.606-81.2973%20781.476-85.6801%20768-94.6332%20768-109.908L768-163.568C768-179.01%20780.947-192.199%20796.606-192.199L853.796-192.199C872.846-192.199%20889.563-208.568%20889.563-227.971Z%22%20fill%3D%22%23FFC836%22%20fill-rule%3D%22evenodd%22%2F%3E%0A%20%20%20%20%3C%2Fg%3E%0A%3C%2Fsvg%3E%0A",
                            x_pos: 0,
                            y_pos: 0,
                        },
                        properties: {
                            current_parameters: {
                                label: "",
                                elyra_filename: "",
                                elyra_runtime_image: "",
                                elyra_cpu: null,
                                elyra_gpu: null,
                                elyra_memory: null,
                                elyra_outputs: [],
                                elyra_env_vars: [],
                                elyra_dependencies: [],
                                elyra_include_subdirectories: false,
                            },
                            parameters: [
                                {
                                    id: "label",
                                },
                                {
                                    id: "elyra_filename",
                                },
                                {
                                    id: "elyra_runtime_image",
                                },
                                {
                                    id: "elyra_cpu",
                                },
                                {
                                    id: "elyra_gpu",
                                },
                                {
                                    id: "elyra_memory",
                                },
                                {
                                    id: "elyra_dependencies",
                                },
                                {
                                    id: "elyra_include_subdirectories",
                                },
                                {
                                    id: "elyra_env_vars",
                                },
                                {
                                    id: "elyra_outputs",
                                },
                            ],
                            uihints: {
                                id: "nodeProperties",
                                parameter_info: [
                                    {
                                        parameter_ref: "label",
                                        control: "custom",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Label",
                                        },
                                        description: {
                                            default: "A custom label for the node.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                    {
                                        parameter_ref: "elyra_filename",
                                        control: "custom",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Filename",
                                        },
                                        description: {
                                            default: "The path to the Python Script.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            format: "file",
                                            required: true,
                                            extensions: [".py"],
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_runtime_image",
                                        control: "custom",
                                        custom_control_id: "EnumControl",
                                        label: {
                                            default: "Runtime Image",
                                        },
                                        description: {
                                            default: "Docker image used as execution environment.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            items: [],
                                            required: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_cpu",
                                        control: "custom",
                                        custom_control_id: "NumberControl",
                                        label: {
                                            default: "CPU",
                                        },
                                        description: {
                                            default: "For CPU-intensive workloads, you can choose more than 1 CPU (e.g. 1.5).",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            minimum: 0,
                                            maximum: 99,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_gpu",
                                        control: "custom",
                                        custom_control_id: "NumberControl",
                                        label: {
                                            default: "GPU",
                                        },
                                        description: {
                                            default: "For GPU-intensive workloads, you can choose more than 1 GPU. Must be an integer.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            minimum: 0,
                                            maximum: 99,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_memory",
                                        control: "custom",
                                        custom_control_id: "NumberControl",
                                        label: {
                                            default: "RAM(GB)",
                                        },
                                        description: {
                                            default: "The total amount of RAM specified.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            minimum: 0,
                                            maximum: 99,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_dependencies",
                                        control: "custom",
                                        custom_control_id: "StringArrayControl",
                                        label: {
                                            default: "File Dependencies",
                                        },
                                        description: {
                                            default: "Local file dependencies that need to be copied to remote execution environment.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            placeholder: "*.py",
                                            format: "file",
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_include_subdirectories",
                                        control: "custom",
                                        custom_control_id: "BooleanControl",
                                        label: {
                                            default: "Include Subdirectories",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            description: "Recursively include subdirectories when submitting a pipeline (This may increase submission time).",
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_env_vars",
                                        control: "custom",
                                        custom_control_id: "StringArrayControl",
                                        label: {
                                            default: "Environment Variables",
                                        },
                                        description: {
                                            default: "Environment variables to be set on the execution environment.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            placeholder: "env_var=VALUE",
                                            canRefresh: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_outputs",
                                        control: "custom",
                                        custom_control_id: "StringArrayControl",
                                        label: {
                                            default: "Output Files",
                                        },
                                        description: {
                                            default: "Files generated during execution that will become available to all subsequent pipeline steps.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            placeholder: "*.csv",
                                        },
                                    },
                                ],
                                group_info: [
                                    {
                                        id: "nodeGroupInfo",
                                        type: "panels",
                                        group_info: [
                                            {
                                                id: "label",
                                                type: "controls",
                                                parameter_refs: ["label"],
                                            },
                                            {
                                                id: "elyra_filename",
                                                type: "controls",
                                                parameter_refs: ["elyra_filename"],
                                            },
                                            {
                                                id: "elyra_runtime_image",
                                                type: "controls",
                                                parameter_refs: ["elyra_runtime_image"],
                                            },
                                            {
                                                id: "elyra_resources",
                                                type: "controls",
                                                parameter_refs: [
                                                    "elyra_cpu",
                                                    "elyra_gpu",
                                                    "elyra_memory",
                                                ],
                                            },
                                            {
                                                id: "elyra_dependencies",
                                                type: "controls",
                                                parameter_refs: ["elyra_dependencies"],
                                            },
                                            {
                                                id: "elyra_include_subdirectories",
                                                type: "controls",
                                                parameter_refs: ["elyra_include_subdirectories"],
                                            },
                                            {
                                                id: "elyra_env_vars",
                                                type: "controls",
                                                parameter_refs: ["elyra_env_vars"],
                                            },
                                            {
                                                id: "elyra_outputs",
                                                type: "controls",
                                                parameter_refs: ["elyra_outputs"],
                                            },
                                        ],
                                    },
                                ],
                            },
                            resources: {},
                        },
                    },
                },
                {
                    op: "execute-r-node",
                    description: "Run R script",
                    id: "r-script",
                    image: "data:image/svg+xml;utf8,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20xmlns%3Axlink%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2Fxlink%22%20preserveAspectRatio%3D%22xMidYMid%22%20width%3D%2232%22%20height%3D%2232%22%20viewBox%3D%220%200%20724%20561%22%3E%0A%20%20%3Cdefs%3E%0A%20%20%20%20%3ClinearGradient%20id%3D%22gradientFill-1%22%20x1%3D%220%22%20x2%3D%221%22%20y1%3D%220%22%20y2%3D%221%22%20gradientUnits%3D%22objectBoundingBox%22%20spreadMethod%3D%22pad%22%3E%0A%20%20%20%20%20%20%3Cstop%20offset%3D%220%22%20stop-color%3D%22rgb(203%2C206%2C208)%22%20stop-opacity%3D%221%22%2F%3E%0A%20%20%20%20%20%20%3Cstop%20offset%3D%221%22%20stop-color%3D%22rgb(132%2C131%2C139)%22%20stop-opacity%3D%221%22%2F%3E%0A%20%20%20%20%3C%2FlinearGradient%3E%0A%20%20%20%20%3ClinearGradient%20id%3D%22gradientFill-2%22%20x1%3D%220%22%20x2%3D%221%22%20y1%3D%220%22%20y2%3D%221%22%20gradientUnits%3D%22objectBoundingBox%22%20spreadMethod%3D%22pad%22%3E%0A%20%20%20%20%20%20%3Cstop%20offset%3D%220%22%20stop-color%3D%22rgb(39%2C109%2C195)%22%20stop-opacity%3D%221%22%2F%3E%0A%20%20%20%20%20%20%3Cstop%20offset%3D%221%22%20stop-color%3D%22rgb(22%2C92%2C170)%22%20stop-opacity%3D%221%22%2F%3E%0A%20%20%20%20%3C%2FlinearGradient%3E%0A%20%20%3C%2Fdefs%3E%0A%20%20%3Cpath%20d%3D%22M361.453%2C485.937%20C162.329%2C485.937%200.906%2C377.828%200.906%2C244.469%20C0.906%2C111.109%20162.329%2C3.000%20361.453%2C3.000%20C560.578%2C3.000%20722.000%2C111.109%20722.000%2C244.469%20C722.000%2C377.828%20560.578%2C485.937%20361.453%2C485.937%20ZM416.641%2C97.406%20C265.289%2C97.406%20142.594%2C171.314%20142.594%2C262.484%20C142.594%2C353.654%20265.289%2C427.562%20416.641%2C427.562%20C567.992%2C427.562%20679.687%2C377.033%20679.687%2C262.484%20C679.687%2C147.971%20567.992%2C97.406%20416.641%2C97.406%20Z%22%20fill%3D%22url(%23gradientFill-1)%22%20fill-rule%3D%22evenodd%22%2F%3E%0A%20%20%3Cpath%20d%3D%22M550.000%2C377.000%20C550.000%2C377.000%20571.822%2C383.585%20584.500%2C390.000%20C588.899%2C392.226%20596.510%2C396.668%20602.000%2C402.500%20C607.378%2C408.212%20610.000%2C414.000%20610.000%2C414.000%20L696.000%2C559.000%20L557.000%2C559.062%20L492.000%2C437.000%20C492.000%2C437.000%20478.690%2C414.131%20470.500%2C407.500%20C463.668%2C401.969%20460.755%2C400.000%20454.000%2C400.000%20C449.298%2C400.000%20420.974%2C400.000%20420.974%2C400.000%20L421.000%2C558.974%20L298.000%2C559.026%20L298.000%2C152.938%20L545.000%2C152.938%20C545.000%2C152.938%20657.500%2C154.967%20657.500%2C262.000%20C657.500%2C369.033%20550.000%2C377.000%20550.000%2C377.000%20ZM496.500%2C241.024%20L422.037%2C240.976%20L422.000%2C310.026%20L496.500%2C310.002%20C496.500%2C310.002%20531.000%2C309.895%20531.000%2C274.877%20C531.000%2C239.155%20496.500%2C241.024%20496.500%2C241.024%20Z%22%20fill%3D%22url(%23gradientFill-2)%22%20fill-rule%3D%22evenodd%22%2F%3E%0A%3C%2Fsvg%3E%0A",
                    label: "R Script",
                    type: "execution_node",
                    inputs: [
                        {
                            id: "inPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Input Port",
                                },
                            },
                        },
                    ],
                    outputs: [
                        {
                            id: "outPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Output Port",
                                },
                            },
                        },
                    ],
                    parameters: {},
                    app_data: {
                        extensions: [".r"],
                        parameter_refs: {
                            filehandler: "filename",
                        },
                        image: "data:image/svg+xml;utf8,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20xmlns%3Axlink%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2Fxlink%22%20preserveAspectRatio%3D%22xMidYMid%22%20width%3D%2232%22%20height%3D%2232%22%20viewBox%3D%220%200%20724%20561%22%3E%0A%20%20%3Cdefs%3E%0A%20%20%20%20%3ClinearGradient%20id%3D%22gradientFill-1%22%20x1%3D%220%22%20x2%3D%221%22%20y1%3D%220%22%20y2%3D%221%22%20gradientUnits%3D%22objectBoundingBox%22%20spreadMethod%3D%22pad%22%3E%0A%20%20%20%20%20%20%3Cstop%20offset%3D%220%22%20stop-color%3D%22rgb(203%2C206%2C208)%22%20stop-opacity%3D%221%22%2F%3E%0A%20%20%20%20%20%20%3Cstop%20offset%3D%221%22%20stop-color%3D%22rgb(132%2C131%2C139)%22%20stop-opacity%3D%221%22%2F%3E%0A%20%20%20%20%3C%2FlinearGradient%3E%0A%20%20%20%20%3ClinearGradient%20id%3D%22gradientFill-2%22%20x1%3D%220%22%20x2%3D%221%22%20y1%3D%220%22%20y2%3D%221%22%20gradientUnits%3D%22objectBoundingBox%22%20spreadMethod%3D%22pad%22%3E%0A%20%20%20%20%20%20%3Cstop%20offset%3D%220%22%20stop-color%3D%22rgb(39%2C109%2C195)%22%20stop-opacity%3D%221%22%2F%3E%0A%20%20%20%20%20%20%3Cstop%20offset%3D%221%22%20stop-color%3D%22rgb(22%2C92%2C170)%22%20stop-opacity%3D%221%22%2F%3E%0A%20%20%20%20%3C%2FlinearGradient%3E%0A%20%20%3C%2Fdefs%3E%0A%20%20%3Cpath%20d%3D%22M361.453%2C485.937%20C162.329%2C485.937%200.906%2C377.828%200.906%2C244.469%20C0.906%2C111.109%20162.329%2C3.000%20361.453%2C3.000%20C560.578%2C3.000%20722.000%2C111.109%20722.000%2C244.469%20C722.000%2C377.828%20560.578%2C485.937%20361.453%2C485.937%20ZM416.641%2C97.406%20C265.289%2C97.406%20142.594%2C171.314%20142.594%2C262.484%20C142.594%2C353.654%20265.289%2C427.562%20416.641%2C427.562%20C567.992%2C427.562%20679.687%2C377.033%20679.687%2C262.484%20C679.687%2C147.971%20567.992%2C97.406%20416.641%2C97.406%20Z%22%20fill%3D%22url(%23gradientFill-1)%22%20fill-rule%3D%22evenodd%22%2F%3E%0A%20%20%3Cpath%20d%3D%22M550.000%2C377.000%20C550.000%2C377.000%20571.822%2C383.585%20584.500%2C390.000%20C588.899%2C392.226%20596.510%2C396.668%20602.000%2C402.500%20C607.378%2C408.212%20610.000%2C414.000%20610.000%2C414.000%20L696.000%2C559.000%20L557.000%2C559.062%20L492.000%2C437.000%20C492.000%2C437.000%20478.690%2C414.131%20470.500%2C407.500%20C463.668%2C401.969%20460.755%2C400.000%20454.000%2C400.000%20C449.298%2C400.000%20420.974%2C400.000%20420.974%2C400.000%20L421.000%2C558.974%20L298.000%2C559.026%20L298.000%2C152.938%20L545.000%2C152.938%20C545.000%2C152.938%20657.500%2C154.967%20657.500%2C262.000%20C657.500%2C369.033%20550.000%2C377.000%20550.000%2C377.000%20ZM496.500%2C241.024%20L422.037%2C240.976%20L422.000%2C310.026%20L496.500%2C310.002%20C496.500%2C310.002%20531.000%2C309.895%20531.000%2C274.877%20C531.000%2C239.155%20496.500%2C241.024%20496.500%2C241.024%20Z%22%20fill%3D%22url(%23gradientFill-2)%22%20fill-rule%3D%22evenodd%22%2F%3E%0A%3C%2Fsvg%3E%0A",
                        ui_data: {
                            description: "Run R script",
                            label: "R Script",
                            image: "data:image/svg+xml;utf8,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20xmlns%3Axlink%3D%22http%3A%2F%2Fwww.w3.org%2F1999%2Fxlink%22%20preserveAspectRatio%3D%22xMidYMid%22%20width%3D%2232%22%20height%3D%2232%22%20viewBox%3D%220%200%20724%20561%22%3E%0A%20%20%3Cdefs%3E%0A%20%20%20%20%3ClinearGradient%20id%3D%22gradientFill-1%22%20x1%3D%220%22%20x2%3D%221%22%20y1%3D%220%22%20y2%3D%221%22%20gradientUnits%3D%22objectBoundingBox%22%20spreadMethod%3D%22pad%22%3E%0A%20%20%20%20%20%20%3Cstop%20offset%3D%220%22%20stop-color%3D%22rgb(203%2C206%2C208)%22%20stop-opacity%3D%221%22%2F%3E%0A%20%20%20%20%20%20%3Cstop%20offset%3D%221%22%20stop-color%3D%22rgb(132%2C131%2C139)%22%20stop-opacity%3D%221%22%2F%3E%0A%20%20%20%20%3C%2FlinearGradient%3E%0A%20%20%20%20%3ClinearGradient%20id%3D%22gradientFill-2%22%20x1%3D%220%22%20x2%3D%221%22%20y1%3D%220%22%20y2%3D%221%22%20gradientUnits%3D%22objectBoundingBox%22%20spreadMethod%3D%22pad%22%3E%0A%20%20%20%20%20%20%3Cstop%20offset%3D%220%22%20stop-color%3D%22rgb(39%2C109%2C195)%22%20stop-opacity%3D%221%22%2F%3E%0A%20%20%20%20%20%20%3Cstop%20offset%3D%221%22%20stop-color%3D%22rgb(22%2C92%2C170)%22%20stop-opacity%3D%221%22%2F%3E%0A%20%20%20%20%3C%2FlinearGradient%3E%0A%20%20%3C%2Fdefs%3E%0A%20%20%3Cpath%20d%3D%22M361.453%2C485.937%20C162.329%2C485.937%200.906%2C377.828%200.906%2C244.469%20C0.906%2C111.109%20162.329%2C3.000%20361.453%2C3.000%20C560.578%2C3.000%20722.000%2C111.109%20722.000%2C244.469%20C722.000%2C377.828%20560.578%2C485.937%20361.453%2C485.937%20ZM416.641%2C97.406%20C265.289%2C97.406%20142.594%2C171.314%20142.594%2C262.484%20C142.594%2C353.654%20265.289%2C427.562%20416.641%2C427.562%20C567.992%2C427.562%20679.687%2C377.033%20679.687%2C262.484%20C679.687%2C147.971%20567.992%2C97.406%20416.641%2C97.406%20Z%22%20fill%3D%22url(%23gradientFill-1)%22%20fill-rule%3D%22evenodd%22%2F%3E%0A%20%20%3Cpath%20d%3D%22M550.000%2C377.000%20C550.000%2C377.000%20571.822%2C383.585%20584.500%2C390.000%20C588.899%2C392.226%20596.510%2C396.668%20602.000%2C402.500%20C607.378%2C408.212%20610.000%2C414.000%20610.000%2C414.000%20L696.000%2C559.000%20L557.000%2C559.062%20L492.000%2C437.000%20C492.000%2C437.000%20478.690%2C414.131%20470.500%2C407.500%20C463.668%2C401.969%20460.755%2C400.000%20454.000%2C400.000%20C449.298%2C400.000%20420.974%2C400.000%20420.974%2C400.000%20L421.000%2C558.974%20L298.000%2C559.026%20L298.000%2C152.938%20L545.000%2C152.938%20C545.000%2C152.938%20657.500%2C154.967%20657.500%2C262.000%20C657.500%2C369.033%20550.000%2C377.000%20550.000%2C377.000%20ZM496.500%2C241.024%20L422.037%2C240.976%20L422.000%2C310.026%20L496.500%2C310.002%20C496.500%2C310.002%20531.000%2C309.895%20531.000%2C274.877%20C531.000%2C239.155%20496.500%2C241.024%20496.500%2C241.024%20Z%22%20fill%3D%22url(%23gradientFill-2)%22%20fill-rule%3D%22evenodd%22%2F%3E%0A%3C%2Fsvg%3E%0A",
                            x_pos: 0,
                            y_pos: 0,
                        },
                        properties: {
                            current_parameters: {
                                label: "",
                                elyra_filename: "",
                                elyra_runtime_image: "",
                                elyra_cpu: null,
                                elyra_gpu: null,
                                elyra_memory: null,
                                elyra_outputs: [],
                                elyra_env_vars: [],
                                elyra_dependencies: [],
                                elyra_include_subdirectories: false,
                            },
                            parameters: [
                                {
                                    id: "label",
                                },
                                {
                                    id: "elyra_filename",
                                },
                                {
                                    id: "elyra_runtime_image",
                                },
                                {
                                    id: "elyra_cpu",
                                },
                                {
                                    id: "elyra_gpu",
                                },
                                {
                                    id: "elyra_memory",
                                },
                                {
                                    id: "elyra_dependencies",
                                },
                                {
                                    id: "elyra_include_subdirectories",
                                },
                                {
                                    id: "elyra_env_vars",
                                },
                                {
                                    id: "elyra_outputs",
                                },
                            ],
                            uihints: {
                                id: "nodeProperties",
                                parameter_info: [
                                    {
                                        parameter_ref: "label",
                                        control: "custom",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Label",
                                        },
                                        description: {
                                            default: "A custom label for the node.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                    {
                                        parameter_ref: "elyra_filename",
                                        control: "custom",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Filename",
                                        },
                                        description: {
                                            default: "The path to the R Script.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            format: "file",
                                            required: true,
                                            extensions: [".r"],
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_runtime_image",
                                        control: "custom",
                                        custom_control_id: "EnumControl",
                                        label: {
                                            default: "Runtime Image",
                                        },
                                        description: {
                                            default: "Docker image used as execution environment.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            items: [],
                                            required: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_cpu",
                                        control: "custom",
                                        custom_control_id: "NumberControl",
                                        label: {
                                            default: "CPU",
                                        },
                                        description: {
                                            default: "For CPU-intensive workloads, you can choose more than 1 CPU (e.g. 1.5).",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            minimum: 0,
                                            maximum: 99,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_gpu",
                                        control: "custom",
                                        custom_control_id: "NumberControl",
                                        label: {
                                            default: "GPU",
                                        },
                                        description: {
                                            default: "For GPU-intensive workloads, you can choose more than 1 GPU. Must be an integer.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            minimum: 0,
                                            maximum: 99,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_memory",
                                        control: "custom",
                                        custom_control_id: "NumberControl",
                                        label: {
                                            default: "RAM(GB)",
                                        },
                                        description: {
                                            default: "The total amount of RAM specified.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            minimum: 0,
                                            maximum: 99,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_dependencies",
                                        control: "custom",
                                        custom_control_id: "StringArrayControl",
                                        label: {
                                            default: "File Dependencies",
                                        },
                                        description: {
                                            default: "Local file dependencies that need to be copied to remote execution environment.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            placeholder: "*.py",
                                            format: "file",
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_include_subdirectories",
                                        control: "custom",
                                        custom_control_id: "BooleanControl",
                                        label: {
                                            default: "Include Subdirectories",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            description: "Recursively include subdirectories when submitting a pipeline (This may increase submission time).",
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_env_vars",
                                        control: "custom",
                                        custom_control_id: "StringArrayControl",
                                        label: {
                                            default: "Environment Variables",
                                        },
                                        description: {
                                            default: "Environment variables to be set on the execution environment.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            placeholder: "env_var=VALUE",
                                            canRefresh: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_outputs",
                                        control: "custom",
                                        custom_control_id: "StringArrayControl",
                                        label: {
                                            default: "Output Files",
                                        },
                                        description: {
                                            default: "Files generated during execution that will become available to all subsequent pipeline steps.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            placeholder: "*.csv",
                                        },
                                    },
                                ],
                                group_info: [
                                    {
                                        id: "nodeGroupInfo",
                                        type: "panels",
                                        group_info: [
                                            {
                                                id: "label",
                                                type: "controls",
                                                parameter_refs: ["label"],
                                            },
                                            {
                                                id: "elyra_filename",
                                                type: "controls",
                                                parameter_refs: ["elyra_filename"],
                                            },
                                            {
                                                id: "elyra_runtime_image",
                                                type: "controls",
                                                parameter_refs: ["elyra_runtime_image"],
                                            },
                                            {
                                                id: "elyra_resources",
                                                type: "controls",
                                                parameter_refs: [
                                                    "elyra_cpu",
                                                    "elyra_gpu",
                                                    "elyra_memory",
                                                ],
                                            },
                                            {
                                                id: "elyra_dependencies",
                                                type: "controls",
                                                parameter_refs: ["elyra_dependencies"],
                                            },
                                            {
                                                id: "elyra_include_subdirectories",
                                                type: "controls",
                                                parameter_refs: ["elyra_include_subdirectories"],
                                            },
                                            {
                                                id: "elyra_env_vars",
                                                type: "controls",
                                                parameter_refs: ["elyra_env_vars"],
                                            },
                                            {
                                                id: "elyra_outputs",
                                                type: "controls",
                                                parameter_refs: ["elyra_outputs"],
                                            },
                                        ],
                                    },
                                ],
                            },
                            resources: {},
                        },
                    },
                },
            ],
            image: "/static/elyra/pipeline-flow.svg",
        },
        {
            id: "kfp-examples",
            label: "kfp-examples",
            node_types: [
                {
                    op: "elyra-kfp-examples-catalog:d68ec7fcdf46",
                    description: "",
                    id: "elyra-kfp-examples-catalog:d68ec7fcdf46",
                    image: "/static/elyra/kubeflow.svg",
                    label: "Calculate data hash",
                    runtime_type: "KUBEFLOW_PIPELINES",
                    type: "execution_node",
                    inputs: [
                        {
                            id: "inPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Input Port",
                                },
                            },
                        },
                    ],
                    outputs: [
                        {
                            id: "outPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Output Port",
                                },
                            },
                        },
                    ],
                    parameters: {},
                    app_data: {
                        image: "/static/elyra/kubeflow.svg",
                        ui_data: {
                            description: "",
                            label: "Calculate data hash",
                            image: "/static/elyra/kubeflow.svg",
                            x_pos: 0,
                            y_pos: 0,
                        },
                        properties: {
                            current_parameters: {
                                label: "",
                                elyra_data: "None",
                                elyra_hash_algorithm: {
                                    activeControl: "StringControl",
                                    StringControl: "SHA256",
                                },
                                elyra_output_hash: "",
                                component_source: "{'catalog_type': 'elyra-kfp-examples-catalog', 'component_ref': {'component-id': 'calculate_hash.yaml'}}",
                            },
                            parameters: [
                                {
                                    id: "label",
                                },
                                {
                                    id: "elyra_data",
                                },
                                {
                                    id: "elyra_hash_algorithm",
                                },
                                {
                                    id: "elyra_output_hash",
                                },
                                {
                                    id: "component_source",
                                },
                            ],
                            uihints: {
                                id: "nodeProperties",
                                parameter_info: [
                                    {
                                        parameter_ref: "label",
                                        control: "custom",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Label",
                                        },
                                        description: {
                                            default: "A custom label for the node.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                    {
                                        parameter_ref: "elyra_data",
                                        control: "custom",
                                        custom_control_id: "NestedEnumControl",
                                        label: {
                                            default: "Data",
                                        },
                                        description: {
                                            default: "",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            format: "inputpath",
                                            required: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_hash_algorithm",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "Hash algorithm",
                                        },
                                        description: {
                                            default: "Hash algorithm to use. Supported values are MD5, SHA1, SHA256, SHA512, SHA3 (type: String)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_output_hash",
                                        control: "readonly",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Hash",
                                        },
                                        description: {
                                            default: "This is an output of this component. (type: string)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            format: "outputpath",
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "component_source",
                                        control: "readonly",
                                        label: {
                                            default: "Component Source",
                                        },
                                        description: {
                                            default: "Unique information used to identify this component.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                ],
                                group_info: [
                                    {
                                        id: "nodeGroupInfo",
                                        type: "panels",
                                        group_info: [
                                            {
                                                id: "label",
                                                type: "controls",
                                                parameter_refs: ["label"],
                                            },
                                            {
                                                id: "elyra_data",
                                                type: "controls",
                                                parameter_refs: ["elyra_data"],
                                            },
                                            {
                                                id: "elyra_hash_algorithm",
                                                type: "controls",
                                                parameter_refs: ["elyra_hash_algorithm"],
                                            },
                                            {
                                                id: "elyra_output_hash",
                                                type: "controls",
                                                parameter_refs: ["elyra_output_hash"],
                                            },
                                            {
                                                id: "component_source",
                                                type: "controls",
                                                parameter_refs: ["component_source"],
                                            },
                                        ],
                                    },
                                ],
                            },
                            resources: {},
                        },
                    },
                },
                {
                    op: "elyra-kfp-examples-catalog:a08014f9252f",
                    description: "",
                    id: "elyra-kfp-examples-catalog:a08014f9252f",
                    image: "/static/elyra/kubeflow.svg",
                    label: "Download data",
                    runtime_type: "KUBEFLOW_PIPELINES",
                    type: "execution_node",
                    inputs: [
                        {
                            id: "inPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Input Port",
                                },
                            },
                        },
                    ],
                    outputs: [
                        {
                            id: "outPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Output Port",
                                },
                            },
                        },
                    ],
                    parameters: {},
                    app_data: {
                        image: "/static/elyra/kubeflow.svg",
                        ui_data: {
                            description: "",
                            label: "Download data",
                            image: "/static/elyra/kubeflow.svg",
                            x_pos: 0,
                            y_pos: 0,
                        },
                        properties: {
                            current_parameters: {
                                label: "",
                                elyra_url: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_curl_options: {
                                    activeControl: "StringControl",
                                    StringControl: "--location",
                                },
                                elyra_output_data: "",
                                component_source: "{'catalog_type': 'elyra-kfp-examples-catalog', 'component_ref': {'component-id': 'download_data.yaml'}}",
                            },
                            parameters: [
                                {
                                    id: "label",
                                },
                                {
                                    id: "elyra_url",
                                },
                                {
                                    id: "elyra_curl_options",
                                },
                                {
                                    id: "elyra_output_data",
                                },
                                {
                                    id: "component_source",
                                },
                            ],
                            uihints: {
                                id: "nodeProperties",
                                parameter_info: [
                                    {
                                        parameter_ref: "label",
                                        control: "custom",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Label",
                                        },
                                        description: {
                                            default: "A custom label for the node.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                    {
                                        parameter_ref: "elyra_url",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "Url",
                                        },
                                        description: {
                                            default: "(type: URI)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_curl_options",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "curl options",
                                        },
                                        description: {
                                            default: "Additional options given to the curl program. See https://curl.haxx.se/docs/manpage.html (type: string)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_output_data",
                                        control: "readonly",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Data",
                                        },
                                        description: {
                                            default: "This is an output of this component. (type: string)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            format: "outputpath",
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "component_source",
                                        control: "readonly",
                                        label: {
                                            default: "Component Source",
                                        },
                                        description: {
                                            default: "Unique information used to identify this component.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                ],
                                group_info: [
                                    {
                                        id: "nodeGroupInfo",
                                        type: "panels",
                                        group_info: [
                                            {
                                                id: "label",
                                                type: "controls",
                                                parameter_refs: ["label"],
                                            },
                                            {
                                                id: "elyra_url",
                                                type: "controls",
                                                parameter_refs: ["elyra_url"],
                                            },
                                            {
                                                id: "elyra_curl_options",
                                                type: "controls",
                                                parameter_refs: ["elyra_curl_options"],
                                            },
                                            {
                                                id: "elyra_output_data",
                                                type: "controls",
                                                parameter_refs: ["elyra_output_data"],
                                            },
                                            {
                                                id: "component_source",
                                                type: "controls",
                                                parameter_refs: ["component_source"],
                                            },
                                        ],
                                    },
                                ],
                            },
                            resources: {},
                        },
                    },
                },
                {
                    op: "elyra-kfp-examples-catalog:737915b826e9",
                    description: "Filter input text according to the given regex pattern using shell and grep.",
                    id: "elyra-kfp-examples-catalog:737915b826e9",
                    image: "/static/elyra/kubeflow.svg",
                    label: "Filter text",
                    runtime_type: "KUBEFLOW_PIPELINES",
                    type: "execution_node",
                    inputs: [
                        {
                            id: "inPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Input Port",
                                },
                            },
                        },
                    ],
                    outputs: [
                        {
                            id: "outPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Output Port",
                                },
                            },
                        },
                    ],
                    parameters: {},
                    app_data: {
                        image: "/static/elyra/kubeflow.svg",
                        ui_data: {
                            description: "Filter input text according to the given regex pattern using shell and grep.",
                            label: "Filter text",
                            image: "/static/elyra/kubeflow.svg",
                            x_pos: 0,
                            y_pos: 0,
                        },
                        properties: {
                            current_parameters: {
                                component_description: "Filter input text according to the given regex pattern using shell and grep.",
                                label: "",
                                elyra_text: "None",
                                elyra_pattern: {
                                    activeControl: "StringControl",
                                    StringControl: ".*",
                                },
                                elyra_output_filtered_text: "",
                                component_source: "{'catalog_type': 'elyra-kfp-examples-catalog', 'component_ref': {'component-id': 'filter_text_using_shell_and_grep.yaml'}}",
                            },
                            parameters: [
                                {
                                    id: "component_description",
                                },
                                {
                                    id: "label",
                                },
                                {
                                    id: "elyra_text",
                                },
                                {
                                    id: "elyra_pattern",
                                },
                                {
                                    id: "elyra_output_filtered_text",
                                },
                                {
                                    id: "component_source",
                                },
                            ],
                            uihints: {
                                id: "nodeProperties",
                                parameter_info: [
                                    {
                                        parameter_ref: "component_description",
                                        control: "readonly",
                                        label: {
                                            default: "Component Description",
                                        },
                                        description: {
                                            default: " ",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "label",
                                        control: "custom",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Label",
                                        },
                                        description: {
                                            default: "A custom label for the node.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                    {
                                        parameter_ref: "elyra_text",
                                        control: "custom",
                                        custom_control_id: "NestedEnumControl",
                                        label: {
                                            default: "Text",
                                        },
                                        description: {
                                            default: "Path to file to be filtered",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            format: "inputpath",
                                            required: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_pattern",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "Pattern",
                                        },
                                        description: {
                                            default: "Regex pattern (type: string)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_output_filtered_text",
                                        control: "readonly",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Filtered text",
                                        },
                                        description: {
                                            default: "This is an output of this component. (type: string)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            format: "outputpath",
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "component_source",
                                        control: "readonly",
                                        label: {
                                            default: "Component Source",
                                        },
                                        description: {
                                            default: "Unique information used to identify this component.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                ],
                                group_info: [
                                    {
                                        id: "nodeGroupInfo",
                                        type: "panels",
                                        group_info: [
                                            {
                                                id: "component_description",
                                                type: "controls",
                                                parameter_refs: ["component_description"],
                                            },
                                            {
                                                id: "label",
                                                type: "controls",
                                                parameter_refs: ["label"],
                                            },
                                            {
                                                id: "elyra_text",
                                                type: "controls",
                                                parameter_refs: ["elyra_text"],
                                            },
                                            {
                                                id: "elyra_pattern",
                                                type: "controls",
                                                parameter_refs: ["elyra_pattern"],
                                            },
                                            {
                                                id: "elyra_output_filtered_text",
                                                type: "controls",
                                                parameter_refs: ["elyra_output_filtered_text"],
                                            },
                                            {
                                                id: "component_source",
                                                type: "controls",
                                                parameter_refs: ["component_source"],
                                            },
                                        ],
                                    },
                                ],
                            },
                            resources: {},
                        },
                    },
                },
                {
                    op: "elyra-kfp-examples-catalog:61e6f4141f65",
                    description: "Run Jupyter notebook using papermill. The notebook will receive the parameter values passed to it as well as the INPUT_DATA_PATH and OUTPUT_DATA_PATH variables that will be set to the input data path (if provided) and directory for the optional output data.",
                    id: "elyra-kfp-examples-catalog:61e6f4141f65",
                    image: "/static/elyra/kubeflow.svg",
                    label: "Run notebook using papermill",
                    runtime_type: "KUBEFLOW_PIPELINES",
                    type: "execution_node",
                    inputs: [
                        {
                            id: "inPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Input Port",
                                },
                            },
                        },
                    ],
                    outputs: [
                        {
                            id: "outPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Output Port",
                                },
                            },
                        },
                    ],
                    parameters: {},
                    app_data: {
                        image: "/static/elyra/kubeflow.svg",
                        ui_data: {
                            description: "Run Jupyter notebook using papermill. The notebook will receive the parameter values passed to it as well as the INPUT_DATA_PATH and OUTPUT_DATA_PATH variables that will be set to the input data path (if provided) and directory for the optional output data.",
                            label: "Run notebook using papermill",
                            image: "/static/elyra/kubeflow.svg",
                            x_pos: 0,
                            y_pos: 0,
                        },
                        properties: {
                            current_parameters: {
                                component_description: "Run Jupyter notebook using papermill. The notebook will receive the parameter values passed to it as well as the INPUT_DATA_PATH and OUTPUT_DATA_PATH variables that will be set to the input data path (if provided) and directory for the optional output data.",
                                label: "",
                                elyra_notebook: "None",
                                elyra_parameters: {
                                    activeControl: "StringControl",
                                    StringControl: "{}",
                                },
                                elyra_packages_to_install: {
                                    activeControl: "StringControl",
                                    StringControl: "[]",
                                },
                                elyra_input_data: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_output_notebook: "",
                                elyra_output_output_data: "",
                                component_source: "{'catalog_type': 'elyra-kfp-examples-catalog', 'component_ref': {'component-id': 'run_notebook_using_papermill.yaml'}}",
                            },
                            parameters: [
                                {
                                    id: "component_description",
                                },
                                {
                                    id: "label",
                                },
                                {
                                    id: "elyra_notebook",
                                },
                                {
                                    id: "elyra_parameters",
                                },
                                {
                                    id: "elyra_packages_to_install",
                                },
                                {
                                    id: "elyra_input_data",
                                },
                                {
                                    id: "elyra_output_notebook",
                                },
                                {
                                    id: "elyra_output_output_data",
                                },
                                {
                                    id: "component_source",
                                },
                            ],
                            uihints: {
                                id: "nodeProperties",
                                parameter_info: [
                                    {
                                        parameter_ref: "component_description",
                                        control: "readonly",
                                        label: {
                                            default: "Component Description",
                                        },
                                        description: {
                                            default: " ",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "label",
                                        control: "custom",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Label",
                                        },
                                        description: {
                                            default: "A custom label for the node.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                    {
                                        parameter_ref: "elyra_notebook",
                                        control: "custom",
                                        custom_control_id: "NestedEnumControl",
                                        label: {
                                            default: "Notebook",
                                        },
                                        description: {
                                            default: "Required. Notebook to execute.",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            format: "inputpath",
                                            required: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_parameters",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "Parameters",
                                        },
                                        description: {
                                            default: "Map with notebook parameter values. (type: JsonObject)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_packages_to_install",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "Packages to install",
                                        },
                                        description: {
                                            default: "Python packages to install (type: JsonArray)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "list",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_input_data",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "Input data",
                                        },
                                        description: {
                                            default: "Optional data that can be passed to notebook. In notebook, the INPUT_DATA_PATH variable will point to the data (if passed). (type: string)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_output_notebook",
                                        control: "readonly",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Notebook",
                                        },
                                        description: {
                                            default: "This is an output of this component. Executed notebook. (type: JupyterNotebook)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            format: "outputpath",
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_output_output_data",
                                        control: "readonly",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Output data",
                                        },
                                        description: {
                                            default: "This is an output of this component. Directory with any output data. In notebook, the OUTPUT_DATA_PATH variable will point to this directory, so that the notebook can write output data there. (type: string)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            format: "outputpath",
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "component_source",
                                        control: "readonly",
                                        label: {
                                            default: "Component Source",
                                        },
                                        description: {
                                            default: "Unique information used to identify this component.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                ],
                                group_info: [
                                    {
                                        id: "nodeGroupInfo",
                                        type: "panels",
                                        group_info: [
                                            {
                                                id: "component_description",
                                                type: "controls",
                                                parameter_refs: ["component_description"],
                                            },
                                            {
                                                id: "label",
                                                type: "controls",
                                                parameter_refs: ["label"],
                                            },
                                            {
                                                id: "elyra_notebook",
                                                type: "controls",
                                                parameter_refs: ["elyra_notebook"],
                                            },
                                            {
                                                id: "elyra_parameters",
                                                type: "controls",
                                                parameter_refs: ["elyra_parameters"],
                                            },
                                            {
                                                id: "elyra_packages_to_install",
                                                type: "controls",
                                                parameter_refs: ["elyra_packages_to_install"],
                                            },
                                            {
                                                id: "elyra_input_data",
                                                type: "controls",
                                                parameter_refs: ["elyra_input_data"],
                                            },
                                            {
                                                id: "elyra_output_notebook",
                                                type: "controls",
                                                parameter_refs: ["elyra_output_notebook"],
                                            },
                                            {
                                                id: "elyra_output_output_data",
                                                type: "controls",
                                                parameter_refs: ["elyra_output_output_data"],
                                            },
                                            {
                                                id: "component_source",
                                                type: "controls",
                                                parameter_refs: ["component_source"],
                                            },
                                        ],
                                    },
                                ],
                            },
                            resources: {},
                        },
                    },
                },
            ],
            image: "/static/elyra/kubeflow.svg",
        },
        {
            id: "airflow-examples",
            label: "airflow-examples",
            node_types: [
                {
                    op: "elyra-airflow-examples-catalog:3a55d015ea96",
                    description: "",
                    id: "elyra-airflow-examples-catalog:3a55d015ea96",
                    image: "/static/elyra/airflow.svg",
                    label: "BashOperator",
                    runtime_type: "APACHE_AIRFLOW",
                    type: "execution_node",
                    inputs: [
                        {
                            id: "inPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Input Port",
                                },
                            },
                        },
                    ],
                    outputs: [
                        {
                            id: "outPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Output Port",
                                },
                            },
                        },
                    ],
                    parameters: {},
                    app_data: {
                        image: "/static/elyra/airflow.svg",
                        ui_data: {
                            description: "",
                            label: "BashOperator",
                            image: "/static/elyra/airflow.svg",
                            x_pos: 0,
                            y_pos: 0,
                        },
                        properties: {
                            current_parameters: {
                                label: "",
                                elyra_bash_command: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_xcom_push: {
                                    activeControl: "BooleanControl",
                                    BooleanControl: false,
                                },
                                elyra_env: {
                                    activeControl: "StringControl",
                                    StringControl: "{}",
                                },
                                elyra_output_encoding: {
                                    activeControl: "StringControl",
                                    StringControl: "utf-8",
                                },
                                component_source: "{'catalog_type': 'elyra-airflow-examples-catalog', 'component_ref': {'component-id': 'bash_operator.py'}}",
                            },
                            parameters: [
                                {
                                    id: "label",
                                },
                                {
                                    id: "elyra_bash_command",
                                },
                                {
                                    id: "elyra_xcom_push",
                                },
                                {
                                    id: "elyra_env",
                                },
                                {
                                    id: "elyra_output_encoding",
                                },
                                {
                                    id: "component_source",
                                },
                            ],
                            uihints: {
                                id: "nodeProperties",
                                parameter_info: [
                                    {
                                        parameter_ref: "label",
                                        control: "custom",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Label",
                                        },
                                        description: {
                                            default: "A custom label for the node.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                    {
                                        parameter_ref: "elyra_bash_command",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "bash_command",
                                        },
                                        description: {
                                            default: "The command, set of commands or reference to a        bash script (must be '.sh') to be executed. (templated) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_xcom_push",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "xcom_push",
                                        },
                                        description: {
                                            default: "If xcom_push is True, the last line written to stdout        will also be pushed to an XCom when the bash command completes. (type: bool)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                BooleanControl: {
                                                    label: "Please select or deselect the checkbox :",
                                                    format: "boolean",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_env",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "env",
                                        },
                                        description: {
                                            default: "If env is not None, it must be a mapping that defines the        environment variables for the new process; these are used instead        of inheriting the current process environment, which is the default        behavior. (templated) (type: dict)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "dictionary",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_output_encoding",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "output_encoding",
                                        },
                                        description: {
                                            default: "Output encoding of bash command (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "component_source",
                                        control: "readonly",
                                        label: {
                                            default: "Component Source",
                                        },
                                        description: {
                                            default: "Unique information used to identify this component.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                ],
                                group_info: [
                                    {
                                        id: "nodeGroupInfo",
                                        type: "panels",
                                        group_info: [
                                            {
                                                id: "label",
                                                type: "controls",
                                                parameter_refs: ["label"],
                                            },
                                            {
                                                id: "elyra_bash_command",
                                                type: "controls",
                                                parameter_refs: ["elyra_bash_command"],
                                            },
                                            {
                                                id: "elyra_xcom_push",
                                                type: "controls",
                                                parameter_refs: ["elyra_xcom_push"],
                                            },
                                            {
                                                id: "elyra_env",
                                                type: "controls",
                                                parameter_refs: ["elyra_env"],
                                            },
                                            {
                                                id: "elyra_output_encoding",
                                                type: "controls",
                                                parameter_refs: ["elyra_output_encoding"],
                                            },
                                            {
                                                id: "component_source",
                                                type: "controls",
                                                parameter_refs: ["component_source"],
                                            },
                                        ],
                                    },
                                ],
                            },
                            resources: {},
                        },
                    },
                },
                {
                    op: "elyra-airflow-examples-catalog:a043648d3897",
                    description: "",
                    id: "elyra-airflow-examples-catalog:a043648d3897",
                    image: "/static/elyra/airflow.svg",
                    label: "EmailOperator",
                    runtime_type: "APACHE_AIRFLOW",
                    type: "execution_node",
                    inputs: [
                        {
                            id: "inPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Input Port",
                                },
                            },
                        },
                    ],
                    outputs: [
                        {
                            id: "outPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Output Port",
                                },
                            },
                        },
                    ],
                    parameters: {},
                    app_data: {
                        image: "/static/elyra/airflow.svg",
                        ui_data: {
                            description: "",
                            label: "EmailOperator",
                            image: "/static/elyra/airflow.svg",
                            x_pos: 0,
                            y_pos: 0,
                        },
                        properties: {
                            current_parameters: {
                                label: "",
                                elyra_to: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_subject: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_html_content: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_files: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_cc: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_bcc: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_mime_subtype: {
                                    activeControl: "StringControl",
                                    StringControl: "mixed",
                                },
                                elyra_mime_charset: {
                                    activeControl: "StringControl",
                                    StringControl: "us_ascii",
                                },
                                component_source: "{'catalog_type': 'elyra-airflow-examples-catalog', 'component_ref': {'component-id': 'email_operator.py'}}",
                            },
                            parameters: [
                                {
                                    id: "label",
                                },
                                {
                                    id: "elyra_to",
                                },
                                {
                                    id: "elyra_subject",
                                },
                                {
                                    id: "elyra_html_content",
                                },
                                {
                                    id: "elyra_files",
                                },
                                {
                                    id: "elyra_cc",
                                },
                                {
                                    id: "elyra_bcc",
                                },
                                {
                                    id: "elyra_mime_subtype",
                                },
                                {
                                    id: "elyra_mime_charset",
                                },
                                {
                                    id: "component_source",
                                },
                            ],
                            uihints: {
                                id: "nodeProperties",
                                parameter_info: [
                                    {
                                        parameter_ref: "label",
                                        control: "custom",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Label",
                                        },
                                        description: {
                                            default: "A custom label for the node.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                    {
                                        parameter_ref: "elyra_to",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "to",
                                        },
                                        description: {
                                            default: "list of emails to send the email to. (templated) (type: list or string (comma or semicolon delimited))",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "list",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_subject",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "subject",
                                        },
                                        description: {
                                            default: "subject line for the email. (templated) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_html_content",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "html_content",
                                        },
                                        description: {
                                            default: "content of the email, html markup        is allowed. (templated) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_files",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "files",
                                        },
                                        description: {
                                            default: "file names to attach in email (type: list)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "list",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_cc",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "cc",
                                        },
                                        description: {
                                            default: "list of recipients to be added in CC field (type: list or string (comma or semicolon delimited))",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "list",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_bcc",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "bcc",
                                        },
                                        description: {
                                            default: "list of recipients to be added in BCC field (type: list or string (comma or semicolon delimited))",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "list",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_mime_subtype",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "mime_subtype",
                                        },
                                        description: {
                                            default: "MIME sub content type (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_mime_charset",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "mime_charset",
                                        },
                                        description: {
                                            default: "character set parameter added to the Content-Type        header. (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "component_source",
                                        control: "readonly",
                                        label: {
                                            default: "Component Source",
                                        },
                                        description: {
                                            default: "Unique information used to identify this component.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                ],
                                group_info: [
                                    {
                                        id: "nodeGroupInfo",
                                        type: "panels",
                                        group_info: [
                                            {
                                                id: "label",
                                                type: "controls",
                                                parameter_refs: ["label"],
                                            },
                                            {
                                                id: "elyra_to",
                                                type: "controls",
                                                parameter_refs: ["elyra_to"],
                                            },
                                            {
                                                id: "elyra_subject",
                                                type: "controls",
                                                parameter_refs: ["elyra_subject"],
                                            },
                                            {
                                                id: "elyra_html_content",
                                                type: "controls",
                                                parameter_refs: ["elyra_html_content"],
                                            },
                                            {
                                                id: "elyra_files",
                                                type: "controls",
                                                parameter_refs: ["elyra_files"],
                                            },
                                            {
                                                id: "elyra_cc",
                                                type: "controls",
                                                parameter_refs: ["elyra_cc"],
                                            },
                                            {
                                                id: "elyra_bcc",
                                                type: "controls",
                                                parameter_refs: ["elyra_bcc"],
                                            },
                                            {
                                                id: "elyra_mime_subtype",
                                                type: "controls",
                                                parameter_refs: ["elyra_mime_subtype"],
                                            },
                                            {
                                                id: "elyra_mime_charset",
                                                type: "controls",
                                                parameter_refs: ["elyra_mime_charset"],
                                            },
                                            {
                                                id: "component_source",
                                                type: "controls",
                                                parameter_refs: ["component_source"],
                                            },
                                        ],
                                    },
                                ],
                            },
                            resources: {},
                        },
                    },
                },
                {
                    op: "elyra-airflow-examples-catalog:b94cd49692e2",
                    description: "",
                    id: "elyra-airflow-examples-catalog:b94cd49692e2",
                    image: "/static/elyra/airflow.svg",
                    label: "SimpleHttpOperator",
                    runtime_type: "APACHE_AIRFLOW",
                    type: "execution_node",
                    inputs: [
                        {
                            id: "inPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Input Port",
                                },
                            },
                        },
                    ],
                    outputs: [
                        {
                            id: "outPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Output Port",
                                },
                            },
                        },
                    ],
                    parameters: {},
                    app_data: {
                        image: "/static/elyra/airflow.svg",
                        ui_data: {
                            description: "",
                            label: "SimpleHttpOperator",
                            image: "/static/elyra/airflow.svg",
                            x_pos: 0,
                            y_pos: 0,
                        },
                        properties: {
                            current_parameters: {
                                label: "",
                                elyra_endpoint: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_method: {
                                    activeControl: "StringControl",
                                    StringControl: "POST",
                                },
                                elyra_data: {
                                    activeControl: "StringControl",
                                    StringControl: "{}",
                                },
                                elyra_headers: {
                                    activeControl: "StringControl",
                                    StringControl: "{}",
                                },
                                elyra_response_check: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_extra_options: {
                                    activeControl: "StringControl",
                                    StringControl: "{}",
                                },
                                elyra_xcom_push: {
                                    activeControl: "BooleanControl",
                                    BooleanControl: false,
                                },
                                elyra_http_conn_id: {
                                    activeControl: "StringControl",
                                    StringControl: "http_default",
                                },
                                elyra_log_response: {
                                    activeControl: "BooleanControl",
                                    BooleanControl: false,
                                },
                                component_source: "{'catalog_type': 'elyra-airflow-examples-catalog', 'component_ref': {'component-id': 'http_operator.py'}}",
                            },
                            parameters: [
                                {
                                    id: "label",
                                },
                                {
                                    id: "elyra_endpoint",
                                },
                                {
                                    id: "elyra_method",
                                },
                                {
                                    id: "elyra_data",
                                },
                                {
                                    id: "elyra_headers",
                                },
                                {
                                    id: "elyra_response_check",
                                },
                                {
                                    id: "elyra_extra_options",
                                },
                                {
                                    id: "elyra_xcom_push",
                                },
                                {
                                    id: "elyra_http_conn_id",
                                },
                                {
                                    id: "elyra_log_response",
                                },
                                {
                                    id: "component_source",
                                },
                            ],
                            uihints: {
                                id: "nodeProperties",
                                parameter_info: [
                                    {
                                        parameter_ref: "label",
                                        control: "custom",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Label",
                                        },
                                        description: {
                                            default: "A custom label for the node.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                    {
                                        parameter_ref: "elyra_endpoint",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "endpoint",
                                        },
                                        description: {
                                            default: "The relative part of the full url. (templated) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_method",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "method",
                                        },
                                        description: {
                                            default: "The HTTP method to use, default = 'POST' (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_data",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "data",
                                        },
                                        description: {
                                            default: "The data to pass. POST-data in POST/PUT and params        in the URL for a GET request. (templated) (type: For POST/PUT, depends on the content-type parameter,        for GET a dictionary of key/value string pairs)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "dictionary",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_headers",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "headers",
                                        },
                                        description: {
                                            default: "The HTTP headers to be added to the GET request (type: a dictionary of string key/value pairs)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "dictionary",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_response_check",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "response_check",
                                        },
                                        description: {
                                            default: "A check against the 'requests' response object.        Returns True for 'pass' and False otherwise. (type: A lambda or defined function.)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_extra_options",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "extra_options",
                                        },
                                        description: {
                                            default: "Extra options for the 'requests' library, see the        'requests' documentation (options to modify timeout, ssl, etc.) (type: A dictionary of options, where key is string and value        depends on the option that's being modified.)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "dictionary",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_xcom_push",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "xcom_push",
                                        },
                                        description: {
                                            default: "Push the response to Xcom (default: False).        If xcom_push is True, response of an HTTP request will also        be pushed to an XCom. (type: bool)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                BooleanControl: {
                                                    label: "Please select or deselect the checkbox :",
                                                    format: "boolean",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_http_conn_id",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "http_conn_id",
                                        },
                                        description: {
                                            default: "The connection to run the operator against (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_log_response",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "log_response",
                                        },
                                        description: {
                                            default: "Log the response (default: False) (type: bool)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                BooleanControl: {
                                                    label: "Please select or deselect the checkbox :",
                                                    format: "boolean",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "component_source",
                                        control: "readonly",
                                        label: {
                                            default: "Component Source",
                                        },
                                        description: {
                                            default: "Unique information used to identify this component.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                ],
                                group_info: [
                                    {
                                        id: "nodeGroupInfo",
                                        type: "panels",
                                        group_info: [
                                            {
                                                id: "label",
                                                type: "controls",
                                                parameter_refs: ["label"],
                                            },
                                            {
                                                id: "elyra_endpoint",
                                                type: "controls",
                                                parameter_refs: ["elyra_endpoint"],
                                            },
                                            {
                                                id: "elyra_method",
                                                type: "controls",
                                                parameter_refs: ["elyra_method"],
                                            },
                                            {
                                                id: "elyra_data",
                                                type: "controls",
                                                parameter_refs: ["elyra_data"],
                                            },
                                            {
                                                id: "elyra_headers",
                                                type: "controls",
                                                parameter_refs: ["elyra_headers"],
                                            },
                                            {
                                                id: "elyra_response_check",
                                                type: "controls",
                                                parameter_refs: ["elyra_response_check"],
                                            },
                                            {
                                                id: "elyra_extra_options",
                                                type: "controls",
                                                parameter_refs: ["elyra_extra_options"],
                                            },
                                            {
                                                id: "elyra_xcom_push",
                                                type: "controls",
                                                parameter_refs: ["elyra_xcom_push"],
                                            },
                                            {
                                                id: "elyra_http_conn_id",
                                                type: "controls",
                                                parameter_refs: ["elyra_http_conn_id"],
                                            },
                                            {
                                                id: "elyra_log_response",
                                                type: "controls",
                                                parameter_refs: ["elyra_log_response"],
                                            },
                                            {
                                                id: "component_source",
                                                type: "controls",
                                                parameter_refs: ["component_source"],
                                            },
                                        ],
                                    },
                                ],
                            },
                            resources: {},
                        },
                    },
                },
                {
                    op: "elyra-airflow-examples-catalog:16a204f716a2",
                    description: "",
                    id: "elyra-airflow-examples-catalog:16a204f716a2",
                    image: "/static/elyra/airflow.svg",
                    label: "SlackAPIPostOperator",
                    runtime_type: "APACHE_AIRFLOW",
                    type: "execution_node",
                    inputs: [
                        {
                            id: "inPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Input Port",
                                },
                            },
                        },
                    ],
                    outputs: [
                        {
                            id: "outPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Output Port",
                                },
                            },
                        },
                    ],
                    parameters: {},
                    app_data: {
                        image: "/static/elyra/airflow.svg",
                        ui_data: {
                            description: "",
                            label: "SlackAPIPostOperator",
                            image: "/static/elyra/airflow.svg",
                            x_pos: 0,
                            y_pos: 0,
                        },
                        properties: {
                            current_parameters: {
                                label: "",
                                elyra_slack_conn_id: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_token: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_api_params: {
                                    activeControl: "StringControl",
                                    StringControl: "{}",
                                },
                                elyra_channel: {
                                    activeControl: "StringControl",
                                    StringControl: "#general",
                                },
                                elyra_username: {
                                    activeControl: "StringControl",
                                    StringControl: "Airflow",
                                },
                                elyra_text: {
                                    activeControl: "StringControl",
                                    StringControl: "No message has been set. Here is a cat video instead https://www.youtube.com/watch?v=J---aiyznGQ",
                                },
                                elyra_icon_url: {
                                    activeControl: "StringControl",
                                    StringControl: "https://raw.githubusercontent.com/apache/airflow/master/airflow/www/static/pin_100.png",
                                },
                                elyra_attachments: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_blocks: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                component_source: "{'catalog_type': 'elyra-airflow-examples-catalog', 'component_ref': {'component-id': 'slack_operator.py'}}",
                            },
                            parameters: [
                                {
                                    id: "label",
                                },
                                {
                                    id: "elyra_slack_conn_id",
                                },
                                {
                                    id: "elyra_token",
                                },
                                {
                                    id: "elyra_api_params",
                                },
                                {
                                    id: "elyra_channel",
                                },
                                {
                                    id: "elyra_username",
                                },
                                {
                                    id: "elyra_text",
                                },
                                {
                                    id: "elyra_icon_url",
                                },
                                {
                                    id: "elyra_attachments",
                                },
                                {
                                    id: "elyra_blocks",
                                },
                                {
                                    id: "component_source",
                                },
                            ],
                            uihints: {
                                id: "nodeProperties",
                                parameter_info: [
                                    {
                                        parameter_ref: "label",
                                        control: "custom",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Label",
                                        },
                                        description: {
                                            default: "A custom label for the node.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                    {
                                        parameter_ref: "elyra_slack_conn_id",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "slack_conn_id",
                                        },
                                        description: {
                                            default: "Slack connection ID which its password is Slack API token (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_token",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "token",
                                        },
                                        description: {
                                            default: "Slack API token (https://api.slack.com/web) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_api_params",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "api_params",
                                        },
                                        description: {
                                            default: "API Method call parameters (https://api.slack.com/methods) (type: dict)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "dictionary",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_channel",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "channel",
                                        },
                                        description: {
                                            default: "channel in which to post message on slack name (#general) or        ID (C12318391). (templated) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_username",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "username",
                                        },
                                        description: {
                                            default: "Username that airflow will be posting to Slack as. (templated) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_text",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "text",
                                        },
                                        description: {
                                            default: "message to send to slack. (templated) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_icon_url",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "icon_url",
                                        },
                                        description: {
                                            default: "url to icon used for this message (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_attachments",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "attachments",
                                        },
                                        description: {
                                            default: "extra formatting details. (templated)        - see https://api.slack.com/docs/attachments. (type: list of hashes)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "list",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_blocks",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "blocks",
                                        },
                                        description: {
                                            default: "extra block layouts. (templated)        - see https://api.slack.com/reference/block-kit/blocks. (type: list of hashes)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "list",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "component_source",
                                        control: "readonly",
                                        label: {
                                            default: "Component Source",
                                        },
                                        description: {
                                            default: "Unique information used to identify this component.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                ],
                                group_info: [
                                    {
                                        id: "nodeGroupInfo",
                                        type: "panels",
                                        group_info: [
                                            {
                                                id: "label",
                                                type: "controls",
                                                parameter_refs: ["label"],
                                            },
                                            {
                                                id: "elyra_slack_conn_id",
                                                type: "controls",
                                                parameter_refs: ["elyra_slack_conn_id"],
                                            },
                                            {
                                                id: "elyra_token",
                                                type: "controls",
                                                parameter_refs: ["elyra_token"],
                                            },
                                            {
                                                id: "elyra_api_params",
                                                type: "controls",
                                                parameter_refs: ["elyra_api_params"],
                                            },
                                            {
                                                id: "elyra_channel",
                                                type: "controls",
                                                parameter_refs: ["elyra_channel"],
                                            },
                                            {
                                                id: "elyra_username",
                                                type: "controls",
                                                parameter_refs: ["elyra_username"],
                                            },
                                            {
                                                id: "elyra_text",
                                                type: "controls",
                                                parameter_refs: ["elyra_text"],
                                            },
                                            {
                                                id: "elyra_icon_url",
                                                type: "controls",
                                                parameter_refs: ["elyra_icon_url"],
                                            },
                                            {
                                                id: "elyra_attachments",
                                                type: "controls",
                                                parameter_refs: ["elyra_attachments"],
                                            },
                                            {
                                                id: "elyra_blocks",
                                                type: "controls",
                                                parameter_refs: ["elyra_blocks"],
                                            },
                                            {
                                                id: "component_source",
                                                type: "controls",
                                                parameter_refs: ["component_source"],
                                            },
                                        ],
                                    },
                                ],
                            },
                            resources: {},
                        },
                    },
                },
                {
                    op: "elyra-airflow-examples-catalog:3b639742748f",
                    description: "",
                    id: "elyra-airflow-examples-catalog:3b639742748f",
                    image: "/static/elyra/airflow.svg",
                    label: "SparkSqlOperator",
                    runtime_type: "APACHE_AIRFLOW",
                    type: "execution_node",
                    inputs: [
                        {
                            id: "inPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Input Port",
                                },
                            },
                        },
                    ],
                    outputs: [
                        {
                            id: "outPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Output Port",
                                },
                            },
                        },
                    ],
                    parameters: {},
                    app_data: {
                        image: "/static/elyra/airflow.svg",
                        ui_data: {
                            description: "",
                            label: "SparkSqlOperator",
                            image: "/static/elyra/airflow.svg",
                            x_pos: 0,
                            y_pos: 0,
                        },
                        properties: {
                            current_parameters: {
                                label: "",
                                elyra_sql: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_conf: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_conn_id: {
                                    activeControl: "StringControl",
                                    StringControl: "spark_sql_default",
                                },
                                elyra_total_executor_cores: {
                                    activeControl: "NumberControl",
                                    NumberControl: 0,
                                },
                                elyra_executor_cores: {
                                    activeControl: "NumberControl",
                                    NumberControl: 0,
                                },
                                elyra_executor_memory: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_keytab: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_principal: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_master: {
                                    activeControl: "StringControl",
                                    StringControl: "yarn",
                                },
                                elyra_name: {
                                    activeControl: "StringControl",
                                    StringControl: "default-name",
                                },
                                elyra_num_executors: {
                                    activeControl: "NumberControl",
                                    NumberControl: 0,
                                },
                                elyra_verbose: {
                                    activeControl: "BooleanControl",
                                    BooleanControl: true,
                                },
                                elyra_yarn_queue: {
                                    activeControl: "StringControl",
                                    StringControl: "default",
                                },
                                component_source: "{'catalog_type': 'elyra-airflow-examples-catalog', 'component_ref': {'component-id': 'spark_sql_operator.py'}}",
                            },
                            parameters: [
                                {
                                    id: "label",
                                },
                                {
                                    id: "elyra_sql",
                                },
                                {
                                    id: "elyra_conf",
                                },
                                {
                                    id: "elyra_conn_id",
                                },
                                {
                                    id: "elyra_total_executor_cores",
                                },
                                {
                                    id: "elyra_executor_cores",
                                },
                                {
                                    id: "elyra_executor_memory",
                                },
                                {
                                    id: "elyra_keytab",
                                },
                                {
                                    id: "elyra_principal",
                                },
                                {
                                    id: "elyra_master",
                                },
                                {
                                    id: "elyra_name",
                                },
                                {
                                    id: "elyra_num_executors",
                                },
                                {
                                    id: "elyra_verbose",
                                },
                                {
                                    id: "elyra_yarn_queue",
                                },
                                {
                                    id: "component_source",
                                },
                            ],
                            uihints: {
                                id: "nodeProperties",
                                parameter_info: [
                                    {
                                        parameter_ref: "label",
                                        control: "custom",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Label",
                                        },
                                        description: {
                                            default: "A custom label for the node.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                    {
                                        parameter_ref: "elyra_sql",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "sql",
                                        },
                                        description: {
                                            default: "The SQL query to execute. (templated) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: true,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_conf",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "conf",
                                        },
                                        description: {
                                            default: "arbitrary Spark configuration property (type: str (format: PROP=VALUE))",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_conn_id",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "conn_id",
                                        },
                                        description: {
                                            default: "connection_id string (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_total_executor_cores",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "total_executor_cores",
                                        },
                                        description: {
                                            default: "(Standalone & Mesos only) Total cores for all        executors (Default: all the available cores on the worker) (type: int)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                NumberControl: {
                                                    label: "Please enter a number value :",
                                                    format: "number",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_executor_cores",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "executor_cores",
                                        },
                                        description: {
                                            default: "(Standalone & YARN only) Number of cores per        executor (Default: 2) (type: int)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                NumberControl: {
                                                    label: "Please enter a number value :",
                                                    format: "number",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_executor_memory",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "executor_memory",
                                        },
                                        description: {
                                            default: "Memory per executor (e.g. 1000M, 2G) (Default: 1G) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_keytab",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "keytab",
                                        },
                                        description: {
                                            default: "Full path to the file that contains the keytab (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_principal",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "principal",
                                        },
                                        description: {
                                            default: "(type: string)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_master",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "master",
                                        },
                                        description: {
                                            default: "spark://host:port, mesos://host:port, yarn, or local (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_name",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "name",
                                        },
                                        description: {
                                            default: "Name of the job (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_num_executors",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "num_executors",
                                        },
                                        description: {
                                            default: "Number of executors to launch (type: int)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                NumberControl: {
                                                    label: "Please enter a number value :",
                                                    format: "number",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_verbose",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "verbose",
                                        },
                                        description: {
                                            default: "Whether to pass the verbose flag to spark-sql (type: bool)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                BooleanControl: {
                                                    label: "Please select or deselect the checkbox :",
                                                    format: "boolean",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_yarn_queue",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "yarn_queue",
                                        },
                                        description: {
                                            default: "The YARN queue to submit to (Default: 'default') (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "component_source",
                                        control: "readonly",
                                        label: {
                                            default: "Component Source",
                                        },
                                        description: {
                                            default: "Unique information used to identify this component.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                ],
                                group_info: [
                                    {
                                        id: "nodeGroupInfo",
                                        type: "panels",
                                        group_info: [
                                            {
                                                id: "label",
                                                type: "controls",
                                                parameter_refs: ["label"],
                                            },
                                            {
                                                id: "elyra_sql",
                                                type: "controls",
                                                parameter_refs: ["elyra_sql"],
                                            },
                                            {
                                                id: "elyra_conf",
                                                type: "controls",
                                                parameter_refs: ["elyra_conf"],
                                            },
                                            {
                                                id: "elyra_conn_id",
                                                type: "controls",
                                                parameter_refs: ["elyra_conn_id"],
                                            },
                                            {
                                                id: "elyra_total_executor_cores",
                                                type: "controls",
                                                parameter_refs: ["elyra_total_executor_cores"],
                                            },
                                            {
                                                id: "elyra_executor_cores",
                                                type: "controls",
                                                parameter_refs: ["elyra_executor_cores"],
                                            },
                                            {
                                                id: "elyra_executor_memory",
                                                type: "controls",
                                                parameter_refs: ["elyra_executor_memory"],
                                            },
                                            {
                                                id: "elyra_keytab",
                                                type: "controls",
                                                parameter_refs: ["elyra_keytab"],
                                            },
                                            {
                                                id: "elyra_principal",
                                                type: "controls",
                                                parameter_refs: ["elyra_principal"],
                                            },
                                            {
                                                id: "elyra_master",
                                                type: "controls",
                                                parameter_refs: ["elyra_master"],
                                            },
                                            {
                                                id: "elyra_name",
                                                type: "controls",
                                                parameter_refs: ["elyra_name"],
                                            },
                                            {
                                                id: "elyra_num_executors",
                                                type: "controls",
                                                parameter_refs: ["elyra_num_executors"],
                                            },
                                            {
                                                id: "elyra_verbose",
                                                type: "controls",
                                                parameter_refs: ["elyra_verbose"],
                                            },
                                            {
                                                id: "elyra_yarn_queue",
                                                type: "controls",
                                                parameter_refs: ["elyra_yarn_queue"],
                                            },
                                            {
                                                id: "component_source",
                                                type: "controls",
                                                parameter_refs: ["component_source"],
                                            },
                                        ],
                                    },
                                ],
                            },
                            resources: {},
                        },
                    },
                },
                {
                    op: "elyra-airflow-examples-catalog:b29c25ec8bd6",
                    description: "",
                    id: "elyra-airflow-examples-catalog:b29c25ec8bd6",
                    image: "/static/elyra/airflow.svg",
                    label: "SparkSubmitOperator",
                    runtime_type: "APACHE_AIRFLOW",
                    type: "execution_node",
                    inputs: [
                        {
                            id: "inPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Input Port",
                                },
                            },
                        },
                    ],
                    outputs: [
                        {
                            id: "outPort",
                            app_data: {
                                ui_data: {
                                    cardinality: {
                                        min: 0,
                                        max: -1,
                                    },
                                    label: "Output Port",
                                },
                            },
                        },
                    ],
                    parameters: {},
                    app_data: {
                        image: "/static/elyra/airflow.svg",
                        ui_data: {
                            description: "",
                            label: "SparkSubmitOperator",
                            image: "/static/elyra/airflow.svg",
                            x_pos: 0,
                            y_pos: 0,
                        },
                        properties: {
                            current_parameters: {
                                label: "",
                                elyra_application: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_conf: {
                                    activeControl: "StringControl",
                                    StringControl: "{}",
                                },
                                elyra_conn_id: {
                                    activeControl: "StringControl",
                                    StringControl: "spark_default",
                                },
                                elyra_files: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_py_files: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_archives: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_driver_class_path: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_jars: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_java_class: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_packages: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_exclude_packages: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_repositories: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_total_executor_cores: {
                                    activeControl: "NumberControl",
                                    NumberControl: 0,
                                },
                                elyra_executor_cores: {
                                    activeControl: "NumberControl",
                                    NumberControl: 0,
                                },
                                elyra_executor_memory: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_driver_memory: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_keytab: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_principal: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_proxy_user: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_name: {
                                    activeControl: "StringControl",
                                    StringControl: "airflow-spark",
                                },
                                elyra_num_executors: {
                                    activeControl: "NumberControl",
                                    NumberControl: 0,
                                },
                                elyra_status_poll_interval: {
                                    activeControl: "NumberControl",
                                    NumberControl: 1,
                                },
                                elyra_application_args: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                elyra_env_vars: {
                                    activeControl: "StringControl",
                                    StringControl: "{}",
                                },
                                elyra_verbose: {
                                    activeControl: "BooleanControl",
                                    BooleanControl: false,
                                },
                                elyra_spark_binary: {
                                    activeControl: "StringControl",
                                    StringControl: "",
                                },
                                component_source: "{'catalog_type': 'elyra-airflow-examples-catalog', 'component_ref': {'component-id': 'spark_submit_operator.py'}}",
                            },
                            parameters: [
                                {
                                    id: "label",
                                },
                                {
                                    id: "elyra_application",
                                },
                                {
                                    id: "elyra_conf",
                                },
                                {
                                    id: "elyra_conn_id",
                                },
                                {
                                    id: "elyra_files",
                                },
                                {
                                    id: "elyra_py_files",
                                },
                                {
                                    id: "elyra_archives",
                                },
                                {
                                    id: "elyra_driver_class_path",
                                },
                                {
                                    id: "elyra_jars",
                                },
                                {
                                    id: "elyra_java_class",
                                },
                                {
                                    id: "elyra_packages",
                                },
                                {
                                    id: "elyra_exclude_packages",
                                },
                                {
                                    id: "elyra_repositories",
                                },
                                {
                                    id: "elyra_total_executor_cores",
                                },
                                {
                                    id: "elyra_executor_cores",
                                },
                                {
                                    id: "elyra_executor_memory",
                                },
                                {
                                    id: "elyra_driver_memory",
                                },
                                {
                                    id: "elyra_keytab",
                                },
                                {
                                    id: "elyra_principal",
                                },
                                {
                                    id: "elyra_proxy_user",
                                },
                                {
                                    id: "elyra_name",
                                },
                                {
                                    id: "elyra_num_executors",
                                },
                                {
                                    id: "elyra_status_poll_interval",
                                },
                                {
                                    id: "elyra_application_args",
                                },
                                {
                                    id: "elyra_env_vars",
                                },
                                {
                                    id: "elyra_verbose",
                                },
                                {
                                    id: "elyra_spark_binary",
                                },
                                {
                                    id: "component_source",
                                },
                            ],
                            uihints: {
                                id: "nodeProperties",
                                parameter_info: [
                                    {
                                        parameter_ref: "label",
                                        control: "custom",
                                        custom_control_id: "StringControl",
                                        label: {
                                            default: "Label",
                                        },
                                        description: {
                                            default: "A custom label for the node.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                    {
                                        parameter_ref: "elyra_application",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "application",
                                        },
                                        description: {
                                            default: "The application that submitted as a job, either jar or py file. (templated) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_conf",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "conf",
                                        },
                                        description: {
                                            default: "Arbitrary Spark configuration properties (templated) (type: dict)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "dictionary",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_conn_id",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "conn_id",
                                        },
                                        description: {
                                            default: "The connection id as configured in Airflow administration. When an                    invalid connection_id is supplied, it will default to yarn. (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_files",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "files",
                                        },
                                        description: {
                                            default: "Upload additional files to the executor running the job, separated by a                  comma. Files will be placed in the working directory of each executor.                  For example, serialized objects. (templated) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_py_files",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "py_files",
                                        },
                                        description: {
                                            default: "Additional python files used by the job, can be .zip, .egg or .py. (templated) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_archives",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "archives",
                                        },
                                        description: {
                                            default: "(type: string)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_driver_class_path",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "driver_class_path",
                                        },
                                        description: {
                                            default: "Additional, driver-specific, classpath settings. (templated) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_jars",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "jars",
                                        },
                                        description: {
                                            default: "Submit additional jars to upload and place them in executor classpath. (templated) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_java_class",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "java_class",
                                        },
                                        description: {
                                            default: "the main class of the Java application (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_packages",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "packages",
                                        },
                                        description: {
                                            default: "Comma-separated list of maven coordinates of jars to include on the                     driver and executor classpaths. (templated) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_exclude_packages",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "exclude_packages",
                                        },
                                        description: {
                                            default: "Comma-separated list of maven coordinates of jars to exclude                             while resolving the dependencies provided in 'packages' (templated) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_repositories",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "repositories",
                                        },
                                        description: {
                                            default: "Comma-separated list of additional remote repositories to search                         for the maven coordinates given with 'packages' (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_total_executor_cores",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "total_executor_cores",
                                        },
                                        description: {
                                            default: "(Standalone & Mesos only) Total cores for all executors                                 (Default: all the available cores on the worker) (type: int)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                NumberControl: {
                                                    label: "Please enter a number value :",
                                                    format: "number",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_executor_cores",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "executor_cores",
                                        },
                                        description: {
                                            default: "(Standalone & YARN only) Number of cores per executor (Default: 2) (type: int)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                NumberControl: {
                                                    label: "Please enter a number value :",
                                                    format: "number",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_executor_memory",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "executor_memory",
                                        },
                                        description: {
                                            default: "Memory per executor (e.g. 1000M, 2G) (Default: 1G) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_driver_memory",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "driver_memory",
                                        },
                                        description: {
                                            default: "Memory allocated to the driver (e.g. 1000M, 2G) (Default: 1G) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_keytab",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "keytab",
                                        },
                                        description: {
                                            default: "Full path to the file that contains the keytab (templated) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_principal",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "principal",
                                        },
                                        description: {
                                            default: "The name of the kerberos principal used for keytab (templated) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_proxy_user",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "proxy_user",
                                        },
                                        description: {
                                            default: "User to impersonate when submitting the application (templated) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_name",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "name",
                                        },
                                        description: {
                                            default: "Name of the job (default airflow-spark). (templated) (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_num_executors",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "num_executors",
                                        },
                                        description: {
                                            default: "Number of executors to launch (type: int)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                NumberControl: {
                                                    label: "Please enter a number value :",
                                                    format: "number",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_status_poll_interval",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "status_poll_interval",
                                        },
                                        description: {
                                            default: "Seconds to wait between polls of driver status in cluster        mode (Default: 1) (type: int)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                NumberControl: {
                                                    label: "Please enter a number value :",
                                                    format: "number",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_application_args",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "application_args",
                                        },
                                        description: {
                                            default: "Arguments for the application being submitted (templated) (type: list)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "list",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_env_vars",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "env_vars",
                                        },
                                        description: {
                                            default: "Environment variables for spark-submit. It supports yarn and k8s mode too. (templated) (type: dict)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "dictionary",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_verbose",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "verbose",
                                        },
                                        description: {
                                            default: "Whether to pass the verbose flag to spark-submit process for debugging (type: bool)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                BooleanControl: {
                                                    label: "Please select or deselect the checkbox :",
                                                    format: "boolean",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "elyra_spark_binary",
                                        control: "custom",
                                        custom_control_id: "OneOfControl",
                                        label: {
                                            default: "spark_binary",
                                        },
                                        description: {
                                            default: "The command to use for spark submit.                         Some distros may use spark2-submit. (type: str)",
                                            placement: "on_panel",
                                        },
                                        data: {
                                            controls: {
                                                StringControl: {
                                                    label: "Please enter a string value :",
                                                    format: "string",
                                                },
                                                NestedEnumControl: {
                                                    label: "Please select an output from a parent :",
                                                    format: "inputpath",
                                                    allownooptions: false,
                                                },
                                            },
                                            required: false,
                                        },
                                    },
                                    {
                                        parameter_ref: "component_source",
                                        control: "readonly",
                                        label: {
                                            default: "Component Source",
                                        },
                                        description: {
                                            default: "Unique information used to identify this component.",
                                            placement: "on_panel",
                                        },
                                        data: {},
                                    },
                                ],
                                group_info: [
                                    {
                                        id: "nodeGroupInfo",
                                        type: "panels",
                                        group_info: [
                                            {
                                                id: "label",
                                                type: "controls",
                                                parameter_refs: ["label"],
                                            },
                                            {
                                                id: "elyra_application",
                                                type: "controls",
                                                parameter_refs: ["elyra_application"],
                                            },
                                            {
                                                id: "elyra_conf",
                                                type: "controls",
                                                parameter_refs: ["elyra_conf"],
                                            },
                                            {
                                                id: "elyra_conn_id",
                                                type: "controls",
                                                parameter_refs: ["elyra_conn_id"],
                                            },
                                            {
                                                id: "elyra_files",
                                                type: "controls",
                                                parameter_refs: ["elyra_files"],
                                            },
                                            {
                                                id: "elyra_py_files",
                                                type: "controls",
                                                parameter_refs: ["elyra_py_files"],
                                            },
                                            {
                                                id: "elyra_archives",
                                                type: "controls",
                                                parameter_refs: ["elyra_archives"],
                                            },
                                            {
                                                id: "elyra_driver_class_path",
                                                type: "controls",
                                                parameter_refs: ["elyra_driver_class_path"],
                                            },
                                            {
                                                id: "elyra_jars",
                                                type: "controls",
                                                parameter_refs: ["elyra_jars"],
                                            },
                                            {
                                                id: "elyra_java_class",
                                                type: "controls",
                                                parameter_refs: ["elyra_java_class"],
                                            },
                                            {
                                                id: "elyra_packages",
                                                type: "controls",
                                                parameter_refs: ["elyra_packages"],
                                            },
                                            {
                                                id: "elyra_exclude_packages",
                                                type: "controls",
                                                parameter_refs: ["elyra_exclude_packages"],
                                            },
                                            {
                                                id: "elyra_repositories",
                                                type: "controls",
                                                parameter_refs: ["elyra_repositories"],
                                            },
                                            {
                                                id: "elyra_total_executor_cores",
                                                type: "controls",
                                                parameter_refs: ["elyra_total_executor_cores"],
                                            },
                                            {
                                                id: "elyra_executor_cores",
                                                type: "controls",
                                                parameter_refs: ["elyra_executor_cores"],
                                            },
                                            {
                                                id: "elyra_executor_memory",
                                                type: "controls",
                                                parameter_refs: ["elyra_executor_memory"],
                                            },
                                            {
                                                id: "elyra_driver_memory",
                                                type: "controls",
                                                parameter_refs: ["elyra_driver_memory"],
                                            },
                                            {
                                                id: "elyra_keytab",
                                                type: "controls",
                                                parameter_refs: ["elyra_keytab"],
                                            },
                                            {
                                                id: "elyra_principal",
                                                type: "controls",
                                                parameter_refs: ["elyra_principal"],
                                            },
                                            {
                                                id: "elyra_proxy_user",
                                                type: "controls",
                                                parameter_refs: ["elyra_proxy_user"],
                                            },
                                            {
                                                id: "elyra_name",
                                                type: "controls",
                                                parameter_refs: ["elyra_name"],
                                            },
                                            {
                                                id: "elyra_num_executors",
                                                type: "controls",
                                                parameter_refs: ["elyra_num_executors"],
                                            },
                                            {
                                                id: "elyra_status_poll_interval",
                                                type: "controls",
                                                parameter_refs: ["elyra_status_poll_interval"],
                                            },
                                            {
                                                id: "elyra_application_args",
                                                type: "controls",
                                                parameter_refs: ["elyra_application_args"],
                                            },
                                            {
                                                id: "elyra_env_vars",
                                                type: "controls",
                                                parameter_refs: ["elyra_env_vars"],
                                            },
                                            {
                                                id: "elyra_verbose",
                                                type: "controls",
                                                parameter_refs: ["elyra_verbose"],
                                            },
                                            {
                                                id: "elyra_spark_binary",
                                                type: "controls",
                                                parameter_refs: ["elyra_spark_binary"],
                                            },
                                            {
                                                id: "component_source",
                                                type: "controls",
                                                parameter_refs: ["component_source"],
                                            },
                                        ],
                                    },
                                ],
                            },
                            resources: {},
                        },
                    },
                },
            ],
            image: "/static/elyra/airflow.svg",
        },
    ],
};


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/check-circular-references/index.js":
/*!******************************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/check-circular-references/index.js ***!
  \******************************************************************************************************/
/***/ (function(__unused_webpack_module, exports) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.checkCircularReferences = void 0;
var TIMEOUT = 3000;
function checkCircularReferences(links) {
    var e_1, _a, e_2, _b;
    var startTime = Date.now();
    // filter out comment links.
    links = links.filter(function (l) { return l.type !== "commentLink"; });
    // organize links into easily indexable map:
    // {srcNodeId: link[]}
    var linkMap = {};
    try {
        for (var links_1 = __values(links), links_1_1 = links_1.next(); !links_1_1.done; links_1_1 = links_1.next()) {
            var l = links_1_1.value;
            if (linkMap[l.srcNodeId] === undefined) {
                linkMap[l.srcNodeId] = [];
            }
            linkMap[l.srcNodeId].push(l);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (links_1_1 && !links_1_1.done && (_a = links_1.return)) _a.call(links_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    var orderedChain = [];
    var taintedLinks = new Set();
    var seen = new Set();
    var stack = [];
    var _loop_1 = function (l) {
        if (seen.has(l.id)) {
            return "continue";
        }
        seen.add(l.id);
        orderedChain = [];
        orderedChain.push(l.id);
        var linksToVisit = linkMap[l.trgNodeId];
        if (linksToVisit === undefined) {
            return "continue";
        }
        stack.push.apply(stack, __spread(linksToVisit));
        var forkStack = [];
        var chainLength = orderedChain.length;
        forkStack.push.apply(forkStack, __spread(linksToVisit.map(function () { return chainLength; })));
        var _loop_2 = function () {
            var e_3, _a;
            forkStack.pop();
            var l_1 = stack.pop(); // we should be gauranteed an item.
            seen.add(l_1.id);
            var seenLinkIndex = orderedChain.indexOf(l_1.id);
            // We hit a link we've already seen in the chain. This means there is a
            // cycle from the seen link to the end of the chain.
            if (seenLinkIndex > -1) {
                try {
                    for (var _b = (e_3 = void 0, __values(orderedChain.slice(seenLinkIndex))), _c = _b.next(); !_c.done; _c = _b.next()) {
                        var item = _c.value;
                        taintedLinks.add(item);
                    }
                }
                catch (e_3_1) { e_3 = { error: e_3_1 }; }
                finally {
                    try {
                        if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                    }
                    finally { if (e_3) throw e_3.error; }
                }
                // This is completely useless, but it makes me feel better that this is
                // here.
                var position = forkStack.slice(-1).pop();
                if (position !== undefined) {
                    orderedChain = orderedChain.slice(0, position);
                }
                return "continue";
            }
            orderedChain.push(l_1.id);
            var linksToVisit_1 = linkMap[l_1.trgNodeId];
            // We reached the end of a chain.
            if (linksToVisit_1 === undefined) {
                // This is 100% necessary unlike the other example.
                var position = forkStack.slice(-1).pop();
                if (position !== undefined) {
                    orderedChain = orderedChain.slice(0, position);
                }
                return "continue";
            }
            // Uncharted teritory, add it to the stack to be explored.
            stack.push.apply(stack, __spread(linksToVisit_1));
            var chainLength_1 = orderedChain.length;
            forkStack.push.apply(forkStack, __spread(linksToVisit_1.map(function () { return chainLength_1; })));
        };
        while (stack.length > 0 && Date.now() - startTime < TIMEOUT) {
            _loop_2();
        }
    };
    try {
        for (var links_2 = __values(links), links_2_1 = links_2.next(); !links_2_1.done; links_2_1 = links_2.next()) {
            var l = links_2_1.value;
            _loop_1(l);
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (links_2_1 && !links_2_1.done && (_b = links_2.return)) _b.call(links_2);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return __spread(taintedLinks);
}
exports.checkCircularReferences = checkCircularReferences;
exports["default"] = checkCircularReferences;


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/index.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/index.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.validate = exports.getNodeProblems = exports.getPipelineProblems = exports.getLinkProblems = void 0;
var jsonc_parser_1 = __webpack_require__(/*! jsonc-parser */ "../../node_modules/jsonc-parser/lib/esm/main.js");
var check_circular_references_1 = __importDefault(__webpack_require__(/*! ./check-circular-references */ "../../node_modules/@elyra/pipeline-services/dist/validation/check-circular-references/index.js"));
var utils_1 = __webpack_require__(/*! ./utils */ "../../node_modules/@elyra/pipeline-services/dist/validation/utils.js");
var validators_1 = __webpack_require__(/*! ./validators */ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/index.js");
function getLinkProblems(pipeline) {
    var e_1, _a;
    var links = utils_1.getLinks(pipeline);
    var taintedLinks = check_circular_references_1.default(links);
    var problems = [];
    var _loop_1 = function (linkID) {
        // linkID should be guaranteed to be found.
        var link = links.find(function (l) { return l.id === linkID; });
        var source = utils_1.findNode(pipeline, link.srcNodeId);
        var target = utils_1.findNode(pipeline, link.trgNodeId);
        problems.push({
            message: "The connection between nodes '" + source.app_data.ui_data.label + "' and '" + target.app_data.ui_data.label + "' is part of a circular reference.",
            path: __spread(link.path, ["id"]),
            info: {
                type: "circularReference",
                pipelineID: pipeline.id,
                linkID: linkID,
            },
        });
    };
    try {
        for (var taintedLinks_1 = __values(taintedLinks), taintedLinks_1_1 = taintedLinks_1.next(); !taintedLinks_1_1.done; taintedLinks_1_1 = taintedLinks_1.next()) {
            var linkID = taintedLinks_1_1.value;
            _loop_1(linkID);
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (taintedLinks_1_1 && !taintedLinks_1_1.done && (_a = taintedLinks_1.return)) _a.call(taintedLinks_1);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return problems;
}
exports.getLinkProblems = getLinkProblems;
// TODO: Update this to validate the new schema format
function getPropertyValidationErrors(prop, value) {
    var _a, _b, _c, _d;
    var errorMessages = [];
    switch (prop.custom_control_id) {
        case "EnumControl":
            var enumValidators = validators_1.getEnumValidators(prop.data);
            errorMessages = validators_1.getErrorMessages(value, enumValidators);
            break;
        case "NestedEnumControl":
            var nestedEnumValidators = validators_1.getNestedEnumValidators(prop.data);
            errorMessages = ((_a = prop.data) === null || _a === void 0 ? void 0 : _a.required) ? validators_1.getErrorMessages(value, nestedEnumValidators)
                : [];
            break;
        case "NumberControl":
            var trimmedNumber = ((_b = value === null || value === void 0 ? void 0 : value.toString()) !== null && _b !== void 0 ? _b : "").trim();
            if (!((_c = prop.data) === null || _c === void 0 ? void 0 : _c.required) && trimmedNumber === "") {
                break;
            }
            var numberValidators = validators_1.getNumberValidators(prop.data);
            errorMessages = validators_1.getErrorMessages(trimmedNumber, numberValidators);
            break;
        case "StringArrayControl":
            var stringArrayValidators = validators_1.getStringArrayValidators(prop.data);
            errorMessages = validators_1.getErrorMessages(value !== null && value !== void 0 ? value : [], stringArrayValidators);
            break;
        case "StringControl":
            var trimmedString = (value !== null && value !== void 0 ? value : "").trim();
            if (!((_d = prop.data) === null || _d === void 0 ? void 0 : _d.required) && trimmedString === "") {
                break;
            }
            var stringValidators = validators_1.getStringValidators(prop.data);
            errorMessages = validators_1.getErrorMessages(trimmedString, stringValidators);
            break;
    }
    return errorMessages;
}
function getPipelineProblems(pipeline, pipelineProperties) {
    var _a, _b, _c, _d, _e, _f;
    var problems = [];
    for (var fieldName in (_a = pipelineProperties === null || pipelineProperties === void 0 ? void 0 : pipelineProperties.properties) !== null && _a !== void 0 ? _a : []) {
        // If the property isn't in the json, report the error one level higher.
        var path = ["pipeline", "0", "app_data"];
        if (((_b = pipeline.app_data) === null || _b === void 0 ? void 0 : _b[fieldName]) !== undefined) {
            path.push(pipelineProperties[fieldName]);
        }
        var prop = pipelineProperties.properties[fieldName];
        // this should be safe because a boolean can't be required
        // otherwise we would need to check strings for undefined or empty string
        // NOTE: 0 is also falsy, but we don't have any number inputs right now?
        // TODO: We should update this to do type checking.
        var value = utils_1.getValue((_c = pipeline.app_data) === null || _c === void 0 ? void 0 : _c.properties, fieldName, (_e = (_d = pipeline.app_data) === null || _d === void 0 ? void 0 : _d.properties) === null || _e === void 0 ? void 0 : _e.pipeline_defaults);
        if (((_f = prop.data) === null || _f === void 0 ? void 0 : _f.required) && !value) {
            problems.push({
                message: "The pipeline property '" + prop.title + "' is required.",
                path: path,
                info: {
                    type: "missingProperty",
                    pipelineID: pipeline.id,
                    // do not strip elyra here, we need to differentiate between pipeline_defaults still.
                    property: fieldName,
                },
            });
        }
        var errorMessages = getPropertyValidationErrors(prop, value);
        if (errorMessages[0] !== undefined) {
            problems.push({
                message: "The pipeline property '" + prop.title + "' is invalid: " + errorMessages[0],
                path: path,
                info: {
                    type: "invalidProperty",
                    pipelineID: pipeline.id,
                    // do not strip elyra here, we need to differentiate between pipeline_defaults still.
                    property: fieldName,
                    message: errorMessages[0],
                },
            });
        }
    }
    return problems;
}
exports.getPipelineProblems = getPipelineProblems;
function getNodeProblems(pipeline, nodeDefinitions) {
    var e_2, _a;
    var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
    var nodes = utils_1.getNodes(pipeline);
    var problems = [];
    var _loop_2 = function (n, node) {
        if (node.type !== "execution_node") {
            return "continue";
        }
        var nodeDef = nodeDefinitions.find(function (n) { return n.op === node.op; });
        if (nodeDef === undefined) {
            problems.push({
                message: "The component '" + node.op + "' cannot be found.",
                path: ["nodes", n],
                info: {
                    type: "missingComponent",
                    pipelineID: pipeline.id,
                    nodeID: node.id,
                    op: node.op,
                },
            });
            return "continue";
        }
        var nodeProperties = (_d = (_c = (_b = nodeDef.app_data.properties) === null || _b === void 0 ? void 0 : _b.properties) === null || _c === void 0 ? void 0 : _c.component_parameters) === null || _d === void 0 ? void 0 : _d.properties;
        for (var fieldName in nodeProperties !== null && nodeProperties !== void 0 ? nodeProperties : []) {
            var prop = nodeProperties[fieldName];
            // If the property isn't in the json, report the error one level higher.
            var path = ["nodes", n, "app_data"];
            if (((_e = node.app_data.component_parameters) === null || _e === void 0 ? void 0 : _e[fieldName]) !== undefined) {
                path.push(prop.parameter_ref);
            }
            // this should be safe because a boolean can't be required
            // otherwise we would need to check strings for undefined or empty string
            // NOTE: 0 is also falsy, but we don't have any number inputs right now?
            // TODO: We should update this to do type checking.
            var value = utils_1.getValue((_f = node.app_data.component_parameters) !== null && _f !== void 0 ? _f : {}, fieldName, (_h = (_g = pipeline.app_data) === null || _g === void 0 ? void 0 : _g.properties) === null || _h === void 0 ? void 0 : _h.pipeline_defaults);
            var component_parameters = (_l = (_k = (_j = nodeDef.app_data.properties) === null || _j === void 0 ? void 0 : _j.properties) === null || _k === void 0 ? void 0 : _k.component_parameters) !== null && _l !== void 0 ? _l : {};
            if ((_m = component_parameters.required) === null || _m === void 0 ? void 0 : _m.includes(fieldName)) {
                if (!value || ((value === null || value === void 0 ? void 0 : value.widget) && (!value.value || value.value === ""))) {
                    problems.push({
                        message: "The property '" + prop.title + "' on node '" + node.app_data.ui_data.label + "' is required.",
                        path: path,
                        info: {
                            type: "missingProperty",
                            pipelineID: pipeline.id,
                            nodeID: node.id,
                            property: fieldName,
                        },
                    });
                }
            }
            var errorMessages = getPropertyValidationErrors(prop, value);
            if (errorMessages[0] !== undefined) {
                problems.push({
                    message: "The property '" + prop.title + "' on node '" + node.app_data.ui_data.label + "' is invalid: " + errorMessages[0],
                    path: path,
                    info: {
                        type: "invalidProperty",
                        pipelineID: pipeline.id,
                        nodeID: node.id,
                        // do not strip elyra here, we need to differentiate between component_parameters still.
                        property: prop.parameter_ref,
                        message: errorMessages[0],
                    },
                });
            }
        }
    };
    try {
        for (var _o = __values(nodes.entries()), _p = _o.next(); !_p.done; _p = _o.next()) {
            var _q = __read(_p.value, 2), n = _q[0], node = _q[1];
            _loop_2(n, node);
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (_p && !_p.done && (_a = _o.return)) _a.call(_o);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return problems;
}
exports.getNodeProblems = getNodeProblems;
function validate(pipeline, nodeDefinitions, pipelineProperties) {
    var e_3, _a;
    var pipelineTreeRoot = jsonc_parser_1.parseTree(pipeline);
    if (pipelineTreeRoot === undefined) {
        return [];
    }
    var pipelineJSON = JSON.parse(pipeline);
    var problems = [];
    var _loop_3 = function (p, pipeline_1) {
        var partials = [];
        partials.push.apply(partials, __spread(getPipelineProblems(pipeline_1, pipelineProperties)));
        partials.push.apply(partials, __spread(getLinkProblems(pipeline_1)));
        partials.push.apply(partials, __spread(getNodeProblems(pipeline_1, nodeDefinitions)));
        problems.push.apply(problems, __spread(partials.map(function (partial) {
            var path = partial.path, rest = __rest(partial, ["path"]);
            var location = jsonc_parser_1.findNodeAtLocation(pipelineTreeRoot, __spread([
                "pipelines",
                p
            ], path));
            return __assign(__assign({}, rest), { severity: 1, range: utils_1.rangeForLocation(location) });
        })));
    };
    try {
        for (var _b = __values(pipelineJSON.pipelines.entries()), _c = _b.next(); !_c.done; _c = _b.next()) {
            var _d = __read(_c.value, 2), p = _d[0], pipeline_1 = _d[1];
            _loop_3(p, pipeline_1);
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_3) throw e_3.error; }
    }
    return problems;
}
exports.validate = validate;
__exportStar(__webpack_require__(/*! ./validators */ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/index.js"), exports);
__exportStar(__webpack_require__(/*! ./types */ "../../node_modules/@elyra/pipeline-services/dist/validation/types.js"), exports);


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/types.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/types.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/utils.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/utils.js ***!
  \****************************************************************************/
/***/ (function(__unused_webpack_module, exports) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getValue = exports.rangeForLocation = exports.findNode = exports.getNodes = exports.getLinks = void 0;
function getLinks(pipeline) {
    var e_1, _a, e_2, _b, e_3, _c;
    var _d, _e;
    var links = [];
    try {
        for (var _f = __values(pipeline.nodes.entries()), _g = _f.next(); !_g.done; _g = _f.next()) {
            var _h = __read(_g.value, 2), n = _h[0], node = _h[1];
            try {
                for (var _j = (e_2 = void 0, __values((_e = (_d = node.inputs) === null || _d === void 0 ? void 0 : _d.entries()) !== null && _e !== void 0 ? _e : [])), _k = _j.next(); !_k.done; _k = _j.next()) {
                    var _l = __read(_k.value, 2), i = _l[0], input = _l[1];
                    if (input.links !== undefined) {
                        try {
                            for (var _m = (e_3 = void 0, __values(input.links.entries())), _o = _m.next(); !_o.done; _o = _m.next()) {
                                var _p = __read(_o.value, 2), l = _p[0], link = _p[1];
                                if (findNode(pipeline, link.node_id_ref) !== undefined) {
                                    links.push({
                                        id: link.id,
                                        trgNodeId: node.id,
                                        srcNodeId: link.node_id_ref,
                                        // TODO: handle link type
                                        type: "",
                                        path: ["nodes", n, "inputs", i, "links", l],
                                    });
                                }
                            }
                        }
                        catch (e_3_1) { e_3 = { error: e_3_1 }; }
                        finally {
                            try {
                                if (_o && !_o.done && (_c = _m.return)) _c.call(_m);
                            }
                            finally { if (e_3) throw e_3.error; }
                        }
                    }
                }
            }
            catch (e_2_1) { e_2 = { error: e_2_1 }; }
            finally {
                try {
                    if (_k && !_k.done && (_b = _j.return)) _b.call(_j);
                }
                finally { if (e_2) throw e_2.error; }
            }
        }
    }
    catch (e_1_1) { e_1 = { error: e_1_1 }; }
    finally {
        try {
            if (_g && !_g.done && (_a = _f.return)) _a.call(_f);
        }
        finally { if (e_1) throw e_1.error; }
    }
    return links;
}
exports.getLinks = getLinks;
function getNodes(pipeline) {
    return pipeline.nodes;
}
exports.getNodes = getNodes;
function findNode(pipeline, id) {
    return pipeline.nodes.find(function (node) { return node.id === id; });
}
exports.findNode = findNode;
function rangeForLocation(location) {
    var _a, _b, _c, _d;
    var offset = (_b = (_a = location === null || location === void 0 ? void 0 : location.parent) === null || _a === void 0 ? void 0 : _a.offset) !== null && _b !== void 0 ? _b : 0;
    var length = ((_d = (_c = location === null || location === void 0 ? void 0 : location.parent) === null || _c === void 0 ? void 0 : _c.colonOffset) !== null && _d !== void 0 ? _d : 0) - offset;
    return { offset: offset, length: length };
}
exports.rangeForLocation = rangeForLocation;
function getValue(app_data, key, pipelineDefaults) {
    var _a, _b, _c;
    return ((_c = (_b = (_a = app_data === null || app_data === void 0 ? void 0 : app_data.component_parameters) === null || _a === void 0 ? void 0 : _a[key]) !== null && _b !== void 0 ? _b : pipelineDefaults === null || pipelineDefaults === void 0 ? void 0 : pipelineDefaults[key]) !== null && _c !== void 0 ? _c : app_data[key]);
}
exports.getValue = getValue;


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/enum-validators.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/validators/enum-validators.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getEnumValidators = void 0;
function getEnumValidators(_a) {
    var required = _a.required, pipeline_default = _a.pipeline_default;
    var validators = [
        {
            enabled: required === true,
            isValid: function (value) {
                return value !== undefined || !!pipeline_default;
            },
        },
    ];
    return validators;
}
exports.getEnumValidators = getEnumValidators;


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/index.js":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/validators/index.js ***!
  \***************************************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getErrorMessages = void 0;
function getErrorMessages(value, validators) {
    return validators
        .filter(function (v) { return v.enabled && !v.isValid(value); })
        .map(function (v) { return v.message; });
}
exports.getErrorMessages = getErrorMessages;
__exportStar(__webpack_require__(/*! ./string-validators */ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/string-validators.js"), exports);
__exportStar(__webpack_require__(/*! ./number-validators */ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/number-validators.js"), exports);
__exportStar(__webpack_require__(/*! ./string-array-validators */ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/string-array-validators.js"), exports);
__exportStar(__webpack_require__(/*! ./enum-validators */ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/enum-validators.js"), exports);
__exportStar(__webpack_require__(/*! ./nested-enum-validators */ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/nested-enum-validators.js"), exports);


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/nested-enum-validators.js":
/*!********************************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/validators/nested-enum-validators.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getNestedEnumValidators = void 0;
function getNestedEnumValidators(_a) {
    var data = _a.data, allownooptions = _a.allownooptions, required = _a.required;
    var validators = [
        {
            enabled: required === true,
            isValid: function (value) { return value !== undefined; },
        },
        {
            enabled: data !== undefined,
            isValid: function (value) {
                var _a;
                var selected = data.find(function (item) { return item.value === (value === null || value === void 0 ? void 0 : value.value); });
                var option = (_a = selected === null || selected === void 0 ? void 0 : selected.options) === null || _a === void 0 ? void 0 : _a.find(function (item) { return item.value === (value === null || value === void 0 ? void 0 : value.option); });
                return !!selected && (allownooptions || !!option);
            },
            message: "Value must be a valid option",
        },
    ];
    return validators;
}
exports.getNestedEnumValidators = getNestedEnumValidators;


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/number-validators.js":
/*!***************************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/validators/number-validators.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getNumberValidators = void 0;
function getNumberValidators(_a) {
    var type = _a.type, multipleOf = _a.multipleOf, minimum = _a.minimum, maximum = _a.maximum, exclusiveMinimum = _a.exclusiveMinimum, exclusiveMaximum = _a.exclusiveMaximum, required = _a.required;
    // JSON schema allows `exclusive min/max` to be a boolean to indicate min/max
    // are exclusive or a number.
    var exclusiveMax;
    var exclusiveMin;
    if (typeof exclusiveMaximum === "boolean") {
        exclusiveMax = exclusiveMaximum ? maximum : undefined;
    }
    else {
        exclusiveMax = exclusiveMaximum;
    }
    if (typeof exclusiveMinimum === "boolean") {
        exclusiveMin = exclusiveMinimum ? minimum : undefined;
    }
    else {
        exclusiveMin = exclusiveMinimum;
    }
    var isNumber = function (value) { return !isNaN(+value) && !isNaN(parseFloat(value)); };
    var validators = [
        {
            enabled: required === true,
            isValid: function (value) { return value !== ""; },
        },
        {
            enabled: true,
            isValid: function (value) { return value === "" || isNumber(value); },
            message: "Value must be a number.",
        },
        {
            enabled: exclusiveMax !== undefined &&
                (maximum === undefined || exclusiveMax <= maximum),
            isValid: function (value) { return +value < exclusiveMax; },
            message: "Value must be strictly less than " + exclusiveMax + ".",
        },
        {
            enabled: exclusiveMin !== undefined &&
                (minimum === undefined || exclusiveMin >= minimum),
            isValid: function (value) { return +value > exclusiveMin; },
            message: "Value must be strictly greater than " + exclusiveMin + ".",
        },
        {
            enabled: maximum !== undefined &&
                (exclusiveMax === undefined || exclusiveMax > maximum),
            isValid: function (value) { return +value <= maximum; },
            message: "Value must be less than or equal to " + maximum + ".",
        },
        {
            enabled: minimum !== undefined &&
                (exclusiveMin === undefined || exclusiveMin < minimum),
            isValid: function (value) { return +value >= minimum; },
            message: "Value must be greater than or equal to " + minimum + ".",
        },
        {
            enabled: multipleOf !== undefined,
            isValid: function (value) { return +value % multipleOf === 0; },
            message: "Value must be a multiple of " + multipleOf + ".",
        },
        {
            enabled: type === "integer",
            // check if the string includes a decimal to prevent something like "10.0"
            isValid: function (value) { return +value % 1 === 0 && !value.includes("."); },
            message: "Value must be an integer.",
        },
    ];
    return validators;
}
exports.getNumberValidators = getNumberValidators;


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/string-array-validators.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/validators/string-array-validators.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getStringArrayValidators = void 0;
var isKeyValueFormat = function (item) {
    var parts = item.split("=");
    return parts.length >= 2 && parts[0] !== "";
};
function getStringArrayValidators(_a) {
    var uniqueItems = _a.uniqueItems, minItems = _a.minItems, maxItems = _a.maxItems, keyValueEntries = _a.keyValueEntries;
    var validators = [
        {
            enabled: uniqueItems === true,
            isValid: function (value) { return new Set(value).size === value.length; },
            message: "Array has duplicate items.",
        },
        {
            enabled: minItems !== undefined,
            isValid: function (value) { return value.length < minItems; },
            message: "Array must have at least " + minItems + " items.",
        },
        {
            enabled: maxItems !== undefined,
            isValid: function (value) { return value.length < maxItems; },
            message: "Array must have at most " + maxItems + " items.",
        },
        {
            enabled: keyValueEntries === true,
            isValid: function (value) {
                return !value.some(function (item) { return !isKeyValueFormat(item); });
            },
            message: "Array items must be in key=value format.",
        },
    ];
    return validators;
}
exports.getStringArrayValidators = getStringArrayValidators;


/***/ }),

/***/ "../../node_modules/@elyra/pipeline-services/dist/validation/validators/string-validators.js":
/*!***************************************************************************************************!*\
  !*** ../../node_modules/@elyra/pipeline-services/dist/validation/validators/string-validators.js ***!
  \***************************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {


/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getStringValidators = void 0;
function getStringValidators(_a) {
    var required = _a.required, pattern = _a.pattern, patternErrorMessage = _a.patternErrorMessage, maxLength = _a.maxLength, minLength = _a.minLength, format = _a.format;
    var validators = [
        {
            enabled: required === true,
            isValid: function (value) { return value !== ""; },
        },
        {
            enabled: maxLength !== undefined,
            isValid: function (value) { return value.length <= maxLength; },
            message: "Value must be " + maxLength + " or fewer characters long.",
        },
        {
            enabled: minLength !== undefined,
            isValid: function (value) { return value.length >= minLength; },
            message: "Value must be " + minLength + " or more characters long.",
        },
        {
            enabled: pattern !== undefined,
            isValid: function (value) { return new RegExp(pattern).test(value); },
            message: patternErrorMessage !== null && patternErrorMessage !== void 0 ? patternErrorMessage : "Value must match regex `" + pattern + "`.",
        },
        // We don't have any format validation yet, but when we do they will go here
        {
            enabled: format === "file",
            isValid: function () { return true; },
        },
    ];
    return validators;
}
exports.getStringValidators = getStringValidators;


/***/ }),

/***/ "../../node_modules/jsonc-parser/lib/esm/impl/edit.js":
/*!************************************************************!*\
  !*** ../../node_modules/jsonc-parser/lib/esm/impl/edit.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   applyEdit: () => (/* binding */ applyEdit),
/* harmony export */   isWS: () => (/* binding */ isWS),
/* harmony export */   removeProperty: () => (/* binding */ removeProperty),
/* harmony export */   setProperty: () => (/* binding */ setProperty)
/* harmony export */ });
/* harmony import */ var _format__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./format */ "../../node_modules/jsonc-parser/lib/esm/impl/format.js");
/* harmony import */ var _parser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parser */ "../../node_modules/jsonc-parser/lib/esm/impl/parser.js");
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/



function removeProperty(text, path, options) {
    return setProperty(text, path, void 0, options);
}
function setProperty(text, originalPath, value, options) {
    const path = originalPath.slice();
    const errors = [];
    const root = (0,_parser__WEBPACK_IMPORTED_MODULE_1__.parseTree)(text, errors);
    let parent = void 0;
    let lastSegment = void 0;
    while (path.length > 0) {
        lastSegment = path.pop();
        parent = (0,_parser__WEBPACK_IMPORTED_MODULE_1__.findNodeAtLocation)(root, path);
        if (parent === void 0 && value !== void 0) {
            if (typeof lastSegment === 'string') {
                value = { [lastSegment]: value };
            }
            else {
                value = [value];
            }
        }
        else {
            break;
        }
    }
    if (!parent) {
        // empty document
        if (value === void 0) { // delete
            throw new Error('Can not delete in empty document');
        }
        return withFormatting(text, { offset: root ? root.offset : 0, length: root ? root.length : 0, content: JSON.stringify(value) }, options);
    }
    else if (parent.type === 'object' && typeof lastSegment === 'string' && Array.isArray(parent.children)) {
        const existing = (0,_parser__WEBPACK_IMPORTED_MODULE_1__.findNodeAtLocation)(parent, [lastSegment]);
        if (existing !== void 0) {
            if (value === void 0) { // delete
                if (!existing.parent) {
                    throw new Error('Malformed AST');
                }
                const propertyIndex = parent.children.indexOf(existing.parent);
                let removeBegin;
                let removeEnd = existing.parent.offset + existing.parent.length;
                if (propertyIndex > 0) {
                    // remove the comma of the previous node
                    let previous = parent.children[propertyIndex - 1];
                    removeBegin = previous.offset + previous.length;
                }
                else {
                    removeBegin = parent.offset + 1;
                    if (parent.children.length > 1) {
                        // remove the comma of the next node
                        let next = parent.children[1];
                        removeEnd = next.offset;
                    }
                }
                return withFormatting(text, { offset: removeBegin, length: removeEnd - removeBegin, content: '' }, options);
            }
            else {
                // set value of existing property
                return withFormatting(text, { offset: existing.offset, length: existing.length, content: JSON.stringify(value) }, options);
            }
        }
        else {
            if (value === void 0) { // delete
                return []; // property does not exist, nothing to do
            }
            const newProperty = `${JSON.stringify(lastSegment)}: ${JSON.stringify(value)}`;
            const index = options.getInsertionIndex ? options.getInsertionIndex(parent.children.map(p => p.children[0].value)) : parent.children.length;
            let edit;
            if (index > 0) {
                let previous = parent.children[index - 1];
                edit = { offset: previous.offset + previous.length, length: 0, content: ',' + newProperty };
            }
            else if (parent.children.length === 0) {
                edit = { offset: parent.offset + 1, length: 0, content: newProperty };
            }
            else {
                edit = { offset: parent.offset + 1, length: 0, content: newProperty + ',' };
            }
            return withFormatting(text, edit, options);
        }
    }
    else if (parent.type === 'array' && typeof lastSegment === 'number' && Array.isArray(parent.children)) {
        const insertIndex = lastSegment;
        if (insertIndex === -1) {
            // Insert
            const newProperty = `${JSON.stringify(value)}`;
            let edit;
            if (parent.children.length === 0) {
                edit = { offset: parent.offset + 1, length: 0, content: newProperty };
            }
            else {
                const previous = parent.children[parent.children.length - 1];
                edit = { offset: previous.offset + previous.length, length: 0, content: ',' + newProperty };
            }
            return withFormatting(text, edit, options);
        }
        else if (value === void 0 && parent.children.length >= 0) {
            // Removal
            const removalIndex = lastSegment;
            const toRemove = parent.children[removalIndex];
            let edit;
            if (parent.children.length === 1) {
                // only item
                edit = { offset: parent.offset + 1, length: parent.length - 2, content: '' };
            }
            else if (parent.children.length - 1 === removalIndex) {
                // last item
                let previous = parent.children[removalIndex - 1];
                let offset = previous.offset + previous.length;
                let parentEndOffset = parent.offset + parent.length;
                edit = { offset, length: parentEndOffset - 2 - offset, content: '' };
            }
            else {
                edit = { offset: toRemove.offset, length: parent.children[removalIndex + 1].offset - toRemove.offset, content: '' };
            }
            return withFormatting(text, edit, options);
        }
        else if (value !== void 0) {
            let edit;
            const newProperty = `${JSON.stringify(value)}`;
            if (!options.isArrayInsertion && parent.children.length > lastSegment) {
                const toModify = parent.children[lastSegment];
                edit = { offset: toModify.offset, length: toModify.length, content: newProperty };
            }
            else if (parent.children.length === 0 || lastSegment === 0) {
                edit = { offset: parent.offset + 1, length: 0, content: parent.children.length === 0 ? newProperty : newProperty + ',' };
            }
            else {
                const index = lastSegment > parent.children.length ? parent.children.length : lastSegment;
                const previous = parent.children[index - 1];
                edit = { offset: previous.offset + previous.length, length: 0, content: ',' + newProperty };
            }
            return withFormatting(text, edit, options);
        }
        else {
            throw new Error(`Can not ${value === void 0 ? 'remove' : (options.isArrayInsertion ? 'insert' : 'modify')} Array index ${insertIndex} as length is not sufficient`);
        }
    }
    else {
        throw new Error(`Can not add ${typeof lastSegment !== 'number' ? 'index' : 'property'} to parent of type ${parent.type}`);
    }
}
function withFormatting(text, edit, options) {
    if (!options.formattingOptions) {
        return [edit];
    }
    // apply the edit
    let newText = applyEdit(text, edit);
    // format the new text
    let begin = edit.offset;
    let end = edit.offset + edit.content.length;
    if (edit.length === 0 || edit.content.length === 0) { // insert or remove
        while (begin > 0 && !(0,_format__WEBPACK_IMPORTED_MODULE_0__.isEOL)(newText, begin - 1)) {
            begin--;
        }
        while (end < newText.length && !(0,_format__WEBPACK_IMPORTED_MODULE_0__.isEOL)(newText, end)) {
            end++;
        }
    }
    const edits = (0,_format__WEBPACK_IMPORTED_MODULE_0__.format)(newText, { offset: begin, length: end - begin }, { ...options.formattingOptions, keepLines: false });
    // apply the formatting edits and track the begin and end offsets of the changes
    for (let i = edits.length - 1; i >= 0; i--) {
        const edit = edits[i];
        newText = applyEdit(newText, edit);
        begin = Math.min(begin, edit.offset);
        end = Math.max(end, edit.offset + edit.length);
        end += edit.content.length - edit.length;
    }
    // create a single edit with all changes
    const editLength = text.length - (newText.length - end) - begin;
    return [{ offset: begin, length: editLength, content: newText.substring(begin, end) }];
}
function applyEdit(text, edit) {
    return text.substring(0, edit.offset) + edit.content + text.substring(edit.offset + edit.length);
}
function isWS(text, offset) {
    return '\r\n \t'.indexOf(text.charAt(offset)) !== -1;
}


/***/ }),

/***/ "../../node_modules/jsonc-parser/lib/esm/impl/format.js":
/*!**************************************************************!*\
  !*** ../../node_modules/jsonc-parser/lib/esm/impl/format.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   format: () => (/* binding */ format),
/* harmony export */   isEOL: () => (/* binding */ isEOL)
/* harmony export */ });
/* harmony import */ var _scanner__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./scanner */ "../../node_modules/jsonc-parser/lib/esm/impl/scanner.js");
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/


function format(documentText, range, options) {
    let initialIndentLevel;
    let formatText;
    let formatTextStart;
    let rangeStart;
    let rangeEnd;
    if (range) {
        rangeStart = range.offset;
        rangeEnd = rangeStart + range.length;
        formatTextStart = rangeStart;
        while (formatTextStart > 0 && !isEOL(documentText, formatTextStart - 1)) {
            formatTextStart--;
        }
        let endOffset = rangeEnd;
        while (endOffset < documentText.length && !isEOL(documentText, endOffset)) {
            endOffset++;
        }
        formatText = documentText.substring(formatTextStart, endOffset);
        initialIndentLevel = computeIndentLevel(formatText, options);
    }
    else {
        formatText = documentText;
        initialIndentLevel = 0;
        formatTextStart = 0;
        rangeStart = 0;
        rangeEnd = documentText.length;
    }
    const eol = getEOL(options, documentText);
    let numberLineBreaks = 0;
    let indentLevel = 0;
    let indentValue;
    if (options.insertSpaces) {
        indentValue = repeat(' ', options.tabSize || 4);
    }
    else {
        indentValue = '\t';
    }
    let scanner = (0,_scanner__WEBPACK_IMPORTED_MODULE_0__.createScanner)(formatText, false);
    let hasError = false;
    function newLinesAndIndent() {
        if (numberLineBreaks > 1) {
            return repeat(eol, numberLineBreaks) + repeat(indentValue, initialIndentLevel + indentLevel);
        }
        else {
            return eol + repeat(indentValue, initialIndentLevel + indentLevel);
        }
    }
    function scanNext() {
        let token = scanner.scan();
        numberLineBreaks = 0;
        while (token === 15 /* SyntaxKind.Trivia */ || token === 14 /* SyntaxKind.LineBreakTrivia */) {
            if (token === 14 /* SyntaxKind.LineBreakTrivia */ && options.keepLines) {
                numberLineBreaks += 1;
            }
            else if (token === 14 /* SyntaxKind.LineBreakTrivia */) {
                numberLineBreaks = 1;
            }
            token = scanner.scan();
        }
        hasError = token === 16 /* SyntaxKind.Unknown */ || scanner.getTokenError() !== 0 /* ScanError.None */;
        return token;
    }
    const editOperations = [];
    function addEdit(text, startOffset, endOffset) {
        if (!hasError && (!range || (startOffset < rangeEnd && endOffset > rangeStart)) && documentText.substring(startOffset, endOffset) !== text) {
            editOperations.push({ offset: startOffset, length: endOffset - startOffset, content: text });
        }
    }
    let firstToken = scanNext();
    if (options.keepLines && numberLineBreaks > 0) {
        addEdit(repeat(eol, numberLineBreaks), 0, 0);
    }
    if (firstToken !== 17 /* SyntaxKind.EOF */) {
        let firstTokenStart = scanner.getTokenOffset() + formatTextStart;
        let initialIndent = repeat(indentValue, initialIndentLevel);
        addEdit(initialIndent, formatTextStart, firstTokenStart);
    }
    while (firstToken !== 17 /* SyntaxKind.EOF */) {
        let firstTokenEnd = scanner.getTokenOffset() + scanner.getTokenLength() + formatTextStart;
        let secondToken = scanNext();
        let replaceContent = '';
        let needsLineBreak = false;
        while (numberLineBreaks === 0 && (secondToken === 12 /* SyntaxKind.LineCommentTrivia */ || secondToken === 13 /* SyntaxKind.BlockCommentTrivia */)) {
            let commentTokenStart = scanner.getTokenOffset() + formatTextStart;
            addEdit(' ', firstTokenEnd, commentTokenStart);
            firstTokenEnd = scanner.getTokenOffset() + scanner.getTokenLength() + formatTextStart;
            needsLineBreak = secondToken === 12 /* SyntaxKind.LineCommentTrivia */;
            replaceContent = needsLineBreak ? newLinesAndIndent() : '';
            secondToken = scanNext();
        }
        if (secondToken === 2 /* SyntaxKind.CloseBraceToken */) {
            if (firstToken !== 1 /* SyntaxKind.OpenBraceToken */) {
                indentLevel--;
            }
            ;
            if (options.keepLines && numberLineBreaks > 0 || !options.keepLines && firstToken !== 1 /* SyntaxKind.OpenBraceToken */) {
                replaceContent = newLinesAndIndent();
            }
            else if (options.keepLines) {
                replaceContent = ' ';
            }
        }
        else if (secondToken === 4 /* SyntaxKind.CloseBracketToken */) {
            if (firstToken !== 3 /* SyntaxKind.OpenBracketToken */) {
                indentLevel--;
            }
            ;
            if (options.keepLines && numberLineBreaks > 0 || !options.keepLines && firstToken !== 3 /* SyntaxKind.OpenBracketToken */) {
                replaceContent = newLinesAndIndent();
            }
            else if (options.keepLines) {
                replaceContent = ' ';
            }
        }
        else {
            switch (firstToken) {
                case 3 /* SyntaxKind.OpenBracketToken */:
                case 1 /* SyntaxKind.OpenBraceToken */:
                    indentLevel++;
                    if (options.keepLines && numberLineBreaks > 0 || !options.keepLines) {
                        replaceContent = newLinesAndIndent();
                    }
                    else {
                        replaceContent = ' ';
                    }
                    break;
                case 5 /* SyntaxKind.CommaToken */:
                    if (options.keepLines && numberLineBreaks > 0 || !options.keepLines) {
                        replaceContent = newLinesAndIndent();
                    }
                    else {
                        replaceContent = ' ';
                    }
                    break;
                case 12 /* SyntaxKind.LineCommentTrivia */:
                    replaceContent = newLinesAndIndent();
                    break;
                case 13 /* SyntaxKind.BlockCommentTrivia */:
                    if (numberLineBreaks > 0) {
                        replaceContent = newLinesAndIndent();
                    }
                    else if (!needsLineBreak) {
                        replaceContent = ' ';
                    }
                    break;
                case 6 /* SyntaxKind.ColonToken */:
                    if (options.keepLines && numberLineBreaks > 0) {
                        replaceContent = newLinesAndIndent();
                    }
                    else if (!needsLineBreak) {
                        replaceContent = ' ';
                    }
                    break;
                case 10 /* SyntaxKind.StringLiteral */:
                    if (options.keepLines && numberLineBreaks > 0) {
                        replaceContent = newLinesAndIndent();
                    }
                    else if (secondToken === 6 /* SyntaxKind.ColonToken */ && !needsLineBreak) {
                        replaceContent = '';
                    }
                    break;
                case 7 /* SyntaxKind.NullKeyword */:
                case 8 /* SyntaxKind.TrueKeyword */:
                case 9 /* SyntaxKind.FalseKeyword */:
                case 11 /* SyntaxKind.NumericLiteral */:
                case 2 /* SyntaxKind.CloseBraceToken */:
                case 4 /* SyntaxKind.CloseBracketToken */:
                    if (options.keepLines && numberLineBreaks > 0) {
                        replaceContent = newLinesAndIndent();
                    }
                    else {
                        if ((secondToken === 12 /* SyntaxKind.LineCommentTrivia */ || secondToken === 13 /* SyntaxKind.BlockCommentTrivia */) && !needsLineBreak) {
                            replaceContent = ' ';
                        }
                        else if (secondToken !== 5 /* SyntaxKind.CommaToken */ && secondToken !== 17 /* SyntaxKind.EOF */) {
                            hasError = true;
                        }
                    }
                    break;
                case 16 /* SyntaxKind.Unknown */:
                    hasError = true;
                    break;
            }
            if (numberLineBreaks > 0 && (secondToken === 12 /* SyntaxKind.LineCommentTrivia */ || secondToken === 13 /* SyntaxKind.BlockCommentTrivia */)) {
                replaceContent = newLinesAndIndent();
            }
        }
        if (secondToken === 17 /* SyntaxKind.EOF */) {
            if (options.keepLines && numberLineBreaks > 0) {
                replaceContent = newLinesAndIndent();
            }
            else {
                replaceContent = options.insertFinalNewline ? eol : '';
            }
        }
        const secondTokenStart = scanner.getTokenOffset() + formatTextStart;
        addEdit(replaceContent, firstTokenEnd, secondTokenStart);
        firstToken = secondToken;
    }
    return editOperations;
}
function repeat(s, count) {
    let result = '';
    for (let i = 0; i < count; i++) {
        result += s;
    }
    return result;
}
function computeIndentLevel(content, options) {
    let i = 0;
    let nChars = 0;
    const tabSize = options.tabSize || 4;
    while (i < content.length) {
        let ch = content.charAt(i);
        if (ch === ' ') {
            nChars++;
        }
        else if (ch === '\t') {
            nChars += tabSize;
        }
        else {
            break;
        }
        i++;
    }
    return Math.floor(nChars / tabSize);
}
function getEOL(options, text) {
    for (let i = 0; i < text.length; i++) {
        const ch = text.charAt(i);
        if (ch === '\r') {
            if (i + 1 < text.length && text.charAt(i + 1) === '\n') {
                return '\r\n';
            }
            return '\r';
        }
        else if (ch === '\n') {
            return '\n';
        }
    }
    return (options && options.eol) || '\n';
}
function isEOL(text, offset) {
    return '\r\n'.indexOf(text.charAt(offset)) !== -1;
}


/***/ }),

/***/ "../../node_modules/jsonc-parser/lib/esm/impl/parser.js":
/*!**************************************************************!*\
  !*** ../../node_modules/jsonc-parser/lib/esm/impl/parser.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   contains: () => (/* binding */ contains),
/* harmony export */   findNodeAtLocation: () => (/* binding */ findNodeAtLocation),
/* harmony export */   findNodeAtOffset: () => (/* binding */ findNodeAtOffset),
/* harmony export */   getLocation: () => (/* binding */ getLocation),
/* harmony export */   getNodePath: () => (/* binding */ getNodePath),
/* harmony export */   getNodeType: () => (/* binding */ getNodeType),
/* harmony export */   getNodeValue: () => (/* binding */ getNodeValue),
/* harmony export */   parse: () => (/* binding */ parse),
/* harmony export */   parseTree: () => (/* binding */ parseTree),
/* harmony export */   stripComments: () => (/* binding */ stripComments),
/* harmony export */   visit: () => (/* binding */ visit)
/* harmony export */ });
/* harmony import */ var _scanner__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./scanner */ "../../node_modules/jsonc-parser/lib/esm/impl/scanner.js");
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/


var ParseOptions;
(function (ParseOptions) {
    ParseOptions.DEFAULT = {
        allowTrailingComma: false
    };
})(ParseOptions || (ParseOptions = {}));
/**
 * For a given offset, evaluate the location in the JSON document. Each segment in the location path is either a property name or an array index.
 */
function getLocation(text, position) {
    const segments = []; // strings or numbers
    const earlyReturnException = new Object();
    let previousNode = undefined;
    const previousNodeInst = {
        value: {},
        offset: 0,
        length: 0,
        type: 'object',
        parent: undefined
    };
    let isAtPropertyKey = false;
    function setPreviousNode(value, offset, length, type) {
        previousNodeInst.value = value;
        previousNodeInst.offset = offset;
        previousNodeInst.length = length;
        previousNodeInst.type = type;
        previousNodeInst.colonOffset = undefined;
        previousNode = previousNodeInst;
    }
    try {
        visit(text, {
            onObjectBegin: (offset, length) => {
                if (position <= offset) {
                    throw earlyReturnException;
                }
                previousNode = undefined;
                isAtPropertyKey = position > offset;
                segments.push(''); // push a placeholder (will be replaced)
            },
            onObjectProperty: (name, offset, length) => {
                if (position < offset) {
                    throw earlyReturnException;
                }
                setPreviousNode(name, offset, length, 'property');
                segments[segments.length - 1] = name;
                if (position <= offset + length) {
                    throw earlyReturnException;
                }
            },
            onObjectEnd: (offset, length) => {
                if (position <= offset) {
                    throw earlyReturnException;
                }
                previousNode = undefined;
                segments.pop();
            },
            onArrayBegin: (offset, length) => {
                if (position <= offset) {
                    throw earlyReturnException;
                }
                previousNode = undefined;
                segments.push(0);
            },
            onArrayEnd: (offset, length) => {
                if (position <= offset) {
                    throw earlyReturnException;
                }
                previousNode = undefined;
                segments.pop();
            },
            onLiteralValue: (value, offset, length) => {
                if (position < offset) {
                    throw earlyReturnException;
                }
                setPreviousNode(value, offset, length, getNodeType(value));
                if (position <= offset + length) {
                    throw earlyReturnException;
                }
            },
            onSeparator: (sep, offset, length) => {
                if (position <= offset) {
                    throw earlyReturnException;
                }
                if (sep === ':' && previousNode && previousNode.type === 'property') {
                    previousNode.colonOffset = offset;
                    isAtPropertyKey = false;
                    previousNode = undefined;
                }
                else if (sep === ',') {
                    const last = segments[segments.length - 1];
                    if (typeof last === 'number') {
                        segments[segments.length - 1] = last + 1;
                    }
                    else {
                        isAtPropertyKey = true;
                        segments[segments.length - 1] = '';
                    }
                    previousNode = undefined;
                }
            }
        });
    }
    catch (e) {
        if (e !== earlyReturnException) {
            throw e;
        }
    }
    return {
        path: segments,
        previousNode,
        isAtPropertyKey,
        matches: (pattern) => {
            let k = 0;
            for (let i = 0; k < pattern.length && i < segments.length; i++) {
                if (pattern[k] === segments[i] || pattern[k] === '*') {
                    k++;
                }
                else if (pattern[k] !== '**') {
                    return false;
                }
            }
            return k === pattern.length;
        }
    };
}
/**
 * Parses the given text and returns the object the JSON content represents. On invalid input, the parser tries to be as fault tolerant as possible, but still return a result.
 * Therefore always check the errors list to find out if the input was valid.
 */
function parse(text, errors = [], options = ParseOptions.DEFAULT) {
    let currentProperty = null;
    let currentParent = [];
    const previousParents = [];
    function onValue(value) {
        if (Array.isArray(currentParent)) {
            currentParent.push(value);
        }
        else if (currentProperty !== null) {
            currentParent[currentProperty] = value;
        }
    }
    const visitor = {
        onObjectBegin: () => {
            const object = {};
            onValue(object);
            previousParents.push(currentParent);
            currentParent = object;
            currentProperty = null;
        },
        onObjectProperty: (name) => {
            currentProperty = name;
        },
        onObjectEnd: () => {
            currentParent = previousParents.pop();
        },
        onArrayBegin: () => {
            const array = [];
            onValue(array);
            previousParents.push(currentParent);
            currentParent = array;
            currentProperty = null;
        },
        onArrayEnd: () => {
            currentParent = previousParents.pop();
        },
        onLiteralValue: onValue,
        onError: (error, offset, length) => {
            errors.push({ error, offset, length });
        }
    };
    visit(text, visitor, options);
    return currentParent[0];
}
/**
 * Parses the given text and returns a tree representation the JSON content. On invalid input, the parser tries to be as fault tolerant as possible, but still return a result.
 */
function parseTree(text, errors = [], options = ParseOptions.DEFAULT) {
    let currentParent = { type: 'array', offset: -1, length: -1, children: [], parent: undefined }; // artificial root
    function ensurePropertyComplete(endOffset) {
        if (currentParent.type === 'property') {
            currentParent.length = endOffset - currentParent.offset;
            currentParent = currentParent.parent;
        }
    }
    function onValue(valueNode) {
        currentParent.children.push(valueNode);
        return valueNode;
    }
    const visitor = {
        onObjectBegin: (offset) => {
            currentParent = onValue({ type: 'object', offset, length: -1, parent: currentParent, children: [] });
        },
        onObjectProperty: (name, offset, length) => {
            currentParent = onValue({ type: 'property', offset, length: -1, parent: currentParent, children: [] });
            currentParent.children.push({ type: 'string', value: name, offset, length, parent: currentParent });
        },
        onObjectEnd: (offset, length) => {
            ensurePropertyComplete(offset + length); // in case of a missing value for a property: make sure property is complete
            currentParent.length = offset + length - currentParent.offset;
            currentParent = currentParent.parent;
            ensurePropertyComplete(offset + length);
        },
        onArrayBegin: (offset, length) => {
            currentParent = onValue({ type: 'array', offset, length: -1, parent: currentParent, children: [] });
        },
        onArrayEnd: (offset, length) => {
            currentParent.length = offset + length - currentParent.offset;
            currentParent = currentParent.parent;
            ensurePropertyComplete(offset + length);
        },
        onLiteralValue: (value, offset, length) => {
            onValue({ type: getNodeType(value), offset, length, parent: currentParent, value });
            ensurePropertyComplete(offset + length);
        },
        onSeparator: (sep, offset, length) => {
            if (currentParent.type === 'property') {
                if (sep === ':') {
                    currentParent.colonOffset = offset;
                }
                else if (sep === ',') {
                    ensurePropertyComplete(offset);
                }
            }
        },
        onError: (error, offset, length) => {
            errors.push({ error, offset, length });
        }
    };
    visit(text, visitor, options);
    const result = currentParent.children[0];
    if (result) {
        delete result.parent;
    }
    return result;
}
/**
 * Finds the node at the given path in a JSON DOM.
 */
function findNodeAtLocation(root, path) {
    if (!root) {
        return undefined;
    }
    let node = root;
    for (let segment of path) {
        if (typeof segment === 'string') {
            if (node.type !== 'object' || !Array.isArray(node.children)) {
                return undefined;
            }
            let found = false;
            for (const propertyNode of node.children) {
                if (Array.isArray(propertyNode.children) && propertyNode.children[0].value === segment && propertyNode.children.length === 2) {
                    node = propertyNode.children[1];
                    found = true;
                    break;
                }
            }
            if (!found) {
                return undefined;
            }
        }
        else {
            const index = segment;
            if (node.type !== 'array' || index < 0 || !Array.isArray(node.children) || index >= node.children.length) {
                return undefined;
            }
            node = node.children[index];
        }
    }
    return node;
}
/**
 * Gets the JSON path of the given JSON DOM node
 */
function getNodePath(node) {
    if (!node.parent || !node.parent.children) {
        return [];
    }
    const path = getNodePath(node.parent);
    if (node.parent.type === 'property') {
        const key = node.parent.children[0].value;
        path.push(key);
    }
    else if (node.parent.type === 'array') {
        const index = node.parent.children.indexOf(node);
        if (index !== -1) {
            path.push(index);
        }
    }
    return path;
}
/**
 * Evaluates the JavaScript object of the given JSON DOM node
 */
function getNodeValue(node) {
    switch (node.type) {
        case 'array':
            return node.children.map(getNodeValue);
        case 'object':
            const obj = Object.create(null);
            for (let prop of node.children) {
                const valueNode = prop.children[1];
                if (valueNode) {
                    obj[prop.children[0].value] = getNodeValue(valueNode);
                }
            }
            return obj;
        case 'null':
        case 'string':
        case 'number':
        case 'boolean':
            return node.value;
        default:
            return undefined;
    }
}
function contains(node, offset, includeRightBound = false) {
    return (offset >= node.offset && offset < (node.offset + node.length)) || includeRightBound && (offset === (node.offset + node.length));
}
/**
 * Finds the most inner node at the given offset. If includeRightBound is set, also finds nodes that end at the given offset.
 */
function findNodeAtOffset(node, offset, includeRightBound = false) {
    if (contains(node, offset, includeRightBound)) {
        const children = node.children;
        if (Array.isArray(children)) {
            for (let i = 0; i < children.length && children[i].offset <= offset; i++) {
                const item = findNodeAtOffset(children[i], offset, includeRightBound);
                if (item) {
                    return item;
                }
            }
        }
        return node;
    }
    return undefined;
}
/**
 * Parses the given text and invokes the visitor functions for each object, array and literal reached.
 */
function visit(text, visitor, options = ParseOptions.DEFAULT) {
    const _scanner = (0,_scanner__WEBPACK_IMPORTED_MODULE_0__.createScanner)(text, false);
    // Important: Only pass copies of this to visitor functions to prevent accidental modification, and
    // to not affect visitor functions which stored a reference to a previous JSONPath
    const _jsonPath = [];
    function toNoArgVisit(visitFunction) {
        return visitFunction ? () => visitFunction(_scanner.getTokenOffset(), _scanner.getTokenLength(), _scanner.getTokenStartLine(), _scanner.getTokenStartCharacter()) : () => true;
    }
    function toNoArgVisitWithPath(visitFunction) {
        return visitFunction ? () => visitFunction(_scanner.getTokenOffset(), _scanner.getTokenLength(), _scanner.getTokenStartLine(), _scanner.getTokenStartCharacter(), () => _jsonPath.slice()) : () => true;
    }
    function toOneArgVisit(visitFunction) {
        return visitFunction ? (arg) => visitFunction(arg, _scanner.getTokenOffset(), _scanner.getTokenLength(), _scanner.getTokenStartLine(), _scanner.getTokenStartCharacter()) : () => true;
    }
    function toOneArgVisitWithPath(visitFunction) {
        return visitFunction ? (arg) => visitFunction(arg, _scanner.getTokenOffset(), _scanner.getTokenLength(), _scanner.getTokenStartLine(), _scanner.getTokenStartCharacter(), () => _jsonPath.slice()) : () => true;
    }
    const onObjectBegin = toNoArgVisitWithPath(visitor.onObjectBegin), onObjectProperty = toOneArgVisitWithPath(visitor.onObjectProperty), onObjectEnd = toNoArgVisit(visitor.onObjectEnd), onArrayBegin = toNoArgVisitWithPath(visitor.onArrayBegin), onArrayEnd = toNoArgVisit(visitor.onArrayEnd), onLiteralValue = toOneArgVisitWithPath(visitor.onLiteralValue), onSeparator = toOneArgVisit(visitor.onSeparator), onComment = toNoArgVisit(visitor.onComment), onError = toOneArgVisit(visitor.onError);
    const disallowComments = options && options.disallowComments;
    const allowTrailingComma = options && options.allowTrailingComma;
    function scanNext() {
        while (true) {
            const token = _scanner.scan();
            switch (_scanner.getTokenError()) {
                case 4 /* ScanError.InvalidUnicode */:
                    handleError(14 /* ParseErrorCode.InvalidUnicode */);
                    break;
                case 5 /* ScanError.InvalidEscapeCharacter */:
                    handleError(15 /* ParseErrorCode.InvalidEscapeCharacter */);
                    break;
                case 3 /* ScanError.UnexpectedEndOfNumber */:
                    handleError(13 /* ParseErrorCode.UnexpectedEndOfNumber */);
                    break;
                case 1 /* ScanError.UnexpectedEndOfComment */:
                    if (!disallowComments) {
                        handleError(11 /* ParseErrorCode.UnexpectedEndOfComment */);
                    }
                    break;
                case 2 /* ScanError.UnexpectedEndOfString */:
                    handleError(12 /* ParseErrorCode.UnexpectedEndOfString */);
                    break;
                case 6 /* ScanError.InvalidCharacter */:
                    handleError(16 /* ParseErrorCode.InvalidCharacter */);
                    break;
            }
            switch (token) {
                case 12 /* SyntaxKind.LineCommentTrivia */:
                case 13 /* SyntaxKind.BlockCommentTrivia */:
                    if (disallowComments) {
                        handleError(10 /* ParseErrorCode.InvalidCommentToken */);
                    }
                    else {
                        onComment();
                    }
                    break;
                case 16 /* SyntaxKind.Unknown */:
                    handleError(1 /* ParseErrorCode.InvalidSymbol */);
                    break;
                case 15 /* SyntaxKind.Trivia */:
                case 14 /* SyntaxKind.LineBreakTrivia */:
                    break;
                default:
                    return token;
            }
        }
    }
    function handleError(error, skipUntilAfter = [], skipUntil = []) {
        onError(error);
        if (skipUntilAfter.length + skipUntil.length > 0) {
            let token = _scanner.getToken();
            while (token !== 17 /* SyntaxKind.EOF */) {
                if (skipUntilAfter.indexOf(token) !== -1) {
                    scanNext();
                    break;
                }
                else if (skipUntil.indexOf(token) !== -1) {
                    break;
                }
                token = scanNext();
            }
        }
    }
    function parseString(isValue) {
        const value = _scanner.getTokenValue();
        if (isValue) {
            onLiteralValue(value);
        }
        else {
            onObjectProperty(value);
            // add property name afterwards
            _jsonPath.push(value);
        }
        scanNext();
        return true;
    }
    function parseLiteral() {
        switch (_scanner.getToken()) {
            case 11 /* SyntaxKind.NumericLiteral */:
                const tokenValue = _scanner.getTokenValue();
                let value = Number(tokenValue);
                if (isNaN(value)) {
                    handleError(2 /* ParseErrorCode.InvalidNumberFormat */);
                    value = 0;
                }
                onLiteralValue(value);
                break;
            case 7 /* SyntaxKind.NullKeyword */:
                onLiteralValue(null);
                break;
            case 8 /* SyntaxKind.TrueKeyword */:
                onLiteralValue(true);
                break;
            case 9 /* SyntaxKind.FalseKeyword */:
                onLiteralValue(false);
                break;
            default:
                return false;
        }
        scanNext();
        return true;
    }
    function parseProperty() {
        if (_scanner.getToken() !== 10 /* SyntaxKind.StringLiteral */) {
            handleError(3 /* ParseErrorCode.PropertyNameExpected */, [], [2 /* SyntaxKind.CloseBraceToken */, 5 /* SyntaxKind.CommaToken */]);
            return false;
        }
        parseString(false);
        if (_scanner.getToken() === 6 /* SyntaxKind.ColonToken */) {
            onSeparator(':');
            scanNext(); // consume colon
            if (!parseValue()) {
                handleError(4 /* ParseErrorCode.ValueExpected */, [], [2 /* SyntaxKind.CloseBraceToken */, 5 /* SyntaxKind.CommaToken */]);
            }
        }
        else {
            handleError(5 /* ParseErrorCode.ColonExpected */, [], [2 /* SyntaxKind.CloseBraceToken */, 5 /* SyntaxKind.CommaToken */]);
        }
        _jsonPath.pop(); // remove processed property name
        return true;
    }
    function parseObject() {
        onObjectBegin();
        scanNext(); // consume open brace
        let needsComma = false;
        while (_scanner.getToken() !== 2 /* SyntaxKind.CloseBraceToken */ && _scanner.getToken() !== 17 /* SyntaxKind.EOF */) {
            if (_scanner.getToken() === 5 /* SyntaxKind.CommaToken */) {
                if (!needsComma) {
                    handleError(4 /* ParseErrorCode.ValueExpected */, [], []);
                }
                onSeparator(',');
                scanNext(); // consume comma
                if (_scanner.getToken() === 2 /* SyntaxKind.CloseBraceToken */ && allowTrailingComma) {
                    break;
                }
            }
            else if (needsComma) {
                handleError(6 /* ParseErrorCode.CommaExpected */, [], []);
            }
            if (!parseProperty()) {
                handleError(4 /* ParseErrorCode.ValueExpected */, [], [2 /* SyntaxKind.CloseBraceToken */, 5 /* SyntaxKind.CommaToken */]);
            }
            needsComma = true;
        }
        onObjectEnd();
        if (_scanner.getToken() !== 2 /* SyntaxKind.CloseBraceToken */) {
            handleError(7 /* ParseErrorCode.CloseBraceExpected */, [2 /* SyntaxKind.CloseBraceToken */], []);
        }
        else {
            scanNext(); // consume close brace
        }
        return true;
    }
    function parseArray() {
        onArrayBegin();
        scanNext(); // consume open bracket
        let isFirstElement = true;
        let needsComma = false;
        while (_scanner.getToken() !== 4 /* SyntaxKind.CloseBracketToken */ && _scanner.getToken() !== 17 /* SyntaxKind.EOF */) {
            if (_scanner.getToken() === 5 /* SyntaxKind.CommaToken */) {
                if (!needsComma) {
                    handleError(4 /* ParseErrorCode.ValueExpected */, [], []);
                }
                onSeparator(',');
                scanNext(); // consume comma
                if (_scanner.getToken() === 4 /* SyntaxKind.CloseBracketToken */ && allowTrailingComma) {
                    break;
                }
            }
            else if (needsComma) {
                handleError(6 /* ParseErrorCode.CommaExpected */, [], []);
            }
            if (isFirstElement) {
                _jsonPath.push(0);
                isFirstElement = false;
            }
            else {
                _jsonPath[_jsonPath.length - 1]++;
            }
            if (!parseValue()) {
                handleError(4 /* ParseErrorCode.ValueExpected */, [], [4 /* SyntaxKind.CloseBracketToken */, 5 /* SyntaxKind.CommaToken */]);
            }
            needsComma = true;
        }
        onArrayEnd();
        if (!isFirstElement) {
            _jsonPath.pop(); // remove array index
        }
        if (_scanner.getToken() !== 4 /* SyntaxKind.CloseBracketToken */) {
            handleError(8 /* ParseErrorCode.CloseBracketExpected */, [4 /* SyntaxKind.CloseBracketToken */], []);
        }
        else {
            scanNext(); // consume close bracket
        }
        return true;
    }
    function parseValue() {
        switch (_scanner.getToken()) {
            case 3 /* SyntaxKind.OpenBracketToken */:
                return parseArray();
            case 1 /* SyntaxKind.OpenBraceToken */:
                return parseObject();
            case 10 /* SyntaxKind.StringLiteral */:
                return parseString(true);
            default:
                return parseLiteral();
        }
    }
    scanNext();
    if (_scanner.getToken() === 17 /* SyntaxKind.EOF */) {
        if (options.allowEmptyContent) {
            return true;
        }
        handleError(4 /* ParseErrorCode.ValueExpected */, [], []);
        return false;
    }
    if (!parseValue()) {
        handleError(4 /* ParseErrorCode.ValueExpected */, [], []);
        return false;
    }
    if (_scanner.getToken() !== 17 /* SyntaxKind.EOF */) {
        handleError(9 /* ParseErrorCode.EndOfFileExpected */, [], []);
    }
    return true;
}
/**
 * Takes JSON with JavaScript-style comments and remove
 * them. Optionally replaces every none-newline character
 * of comments with a replaceCharacter
 */
function stripComments(text, replaceCh) {
    let _scanner = (0,_scanner__WEBPACK_IMPORTED_MODULE_0__.createScanner)(text), parts = [], kind, offset = 0, pos;
    do {
        pos = _scanner.getPosition();
        kind = _scanner.scan();
        switch (kind) {
            case 12 /* SyntaxKind.LineCommentTrivia */:
            case 13 /* SyntaxKind.BlockCommentTrivia */:
            case 17 /* SyntaxKind.EOF */:
                if (offset !== pos) {
                    parts.push(text.substring(offset, pos));
                }
                if (replaceCh !== undefined) {
                    parts.push(_scanner.getTokenValue().replace(/[^\r\n]/g, replaceCh));
                }
                offset = _scanner.getPosition();
                break;
        }
    } while (kind !== 17 /* SyntaxKind.EOF */);
    return parts.join('');
}
function getNodeType(value) {
    switch (typeof value) {
        case 'boolean': return 'boolean';
        case 'number': return 'number';
        case 'string': return 'string';
        case 'object': {
            if (!value) {
                return 'null';
            }
            else if (Array.isArray(value)) {
                return 'array';
            }
            return 'object';
        }
        default: return 'null';
    }
}


/***/ }),

/***/ "../../node_modules/jsonc-parser/lib/esm/impl/scanner.js":
/*!***************************************************************!*\
  !*** ../../node_modules/jsonc-parser/lib/esm/impl/scanner.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createScanner: () => (/* binding */ createScanner)
/* harmony export */ });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

/**
 * Creates a JSON scanner on the given text.
 * If ignoreTrivia is set, whitespaces or comments are ignored.
 */
function createScanner(text, ignoreTrivia = false) {
    const len = text.length;
    let pos = 0, value = '', tokenOffset = 0, token = 16 /* SyntaxKind.Unknown */, lineNumber = 0, lineStartOffset = 0, tokenLineStartOffset = 0, prevTokenLineStartOffset = 0, scanError = 0 /* ScanError.None */;
    function scanHexDigits(count, exact) {
        let digits = 0;
        let value = 0;
        while (digits < count || !exact) {
            let ch = text.charCodeAt(pos);
            if (ch >= 48 /* CharacterCodes._0 */ && ch <= 57 /* CharacterCodes._9 */) {
                value = value * 16 + ch - 48 /* CharacterCodes._0 */;
            }
            else if (ch >= 65 /* CharacterCodes.A */ && ch <= 70 /* CharacterCodes.F */) {
                value = value * 16 + ch - 65 /* CharacterCodes.A */ + 10;
            }
            else if (ch >= 97 /* CharacterCodes.a */ && ch <= 102 /* CharacterCodes.f */) {
                value = value * 16 + ch - 97 /* CharacterCodes.a */ + 10;
            }
            else {
                break;
            }
            pos++;
            digits++;
        }
        if (digits < count) {
            value = -1;
        }
        return value;
    }
    function setPosition(newPosition) {
        pos = newPosition;
        value = '';
        tokenOffset = 0;
        token = 16 /* SyntaxKind.Unknown */;
        scanError = 0 /* ScanError.None */;
    }
    function scanNumber() {
        let start = pos;
        if (text.charCodeAt(pos) === 48 /* CharacterCodes._0 */) {
            pos++;
        }
        else {
            pos++;
            while (pos < text.length && isDigit(text.charCodeAt(pos))) {
                pos++;
            }
        }
        if (pos < text.length && text.charCodeAt(pos) === 46 /* CharacterCodes.dot */) {
            pos++;
            if (pos < text.length && isDigit(text.charCodeAt(pos))) {
                pos++;
                while (pos < text.length && isDigit(text.charCodeAt(pos))) {
                    pos++;
                }
            }
            else {
                scanError = 3 /* ScanError.UnexpectedEndOfNumber */;
                return text.substring(start, pos);
            }
        }
        let end = pos;
        if (pos < text.length && (text.charCodeAt(pos) === 69 /* CharacterCodes.E */ || text.charCodeAt(pos) === 101 /* CharacterCodes.e */)) {
            pos++;
            if (pos < text.length && text.charCodeAt(pos) === 43 /* CharacterCodes.plus */ || text.charCodeAt(pos) === 45 /* CharacterCodes.minus */) {
                pos++;
            }
            if (pos < text.length && isDigit(text.charCodeAt(pos))) {
                pos++;
                while (pos < text.length && isDigit(text.charCodeAt(pos))) {
                    pos++;
                }
                end = pos;
            }
            else {
                scanError = 3 /* ScanError.UnexpectedEndOfNumber */;
            }
        }
        return text.substring(start, end);
    }
    function scanString() {
        let result = '', start = pos;
        while (true) {
            if (pos >= len) {
                result += text.substring(start, pos);
                scanError = 2 /* ScanError.UnexpectedEndOfString */;
                break;
            }
            const ch = text.charCodeAt(pos);
            if (ch === 34 /* CharacterCodes.doubleQuote */) {
                result += text.substring(start, pos);
                pos++;
                break;
            }
            if (ch === 92 /* CharacterCodes.backslash */) {
                result += text.substring(start, pos);
                pos++;
                if (pos >= len) {
                    scanError = 2 /* ScanError.UnexpectedEndOfString */;
                    break;
                }
                const ch2 = text.charCodeAt(pos++);
                switch (ch2) {
                    case 34 /* CharacterCodes.doubleQuote */:
                        result += '\"';
                        break;
                    case 92 /* CharacterCodes.backslash */:
                        result += '\\';
                        break;
                    case 47 /* CharacterCodes.slash */:
                        result += '/';
                        break;
                    case 98 /* CharacterCodes.b */:
                        result += '\b';
                        break;
                    case 102 /* CharacterCodes.f */:
                        result += '\f';
                        break;
                    case 110 /* CharacterCodes.n */:
                        result += '\n';
                        break;
                    case 114 /* CharacterCodes.r */:
                        result += '\r';
                        break;
                    case 116 /* CharacterCodes.t */:
                        result += '\t';
                        break;
                    case 117 /* CharacterCodes.u */:
                        const ch3 = scanHexDigits(4, true);
                        if (ch3 >= 0) {
                            result += String.fromCharCode(ch3);
                        }
                        else {
                            scanError = 4 /* ScanError.InvalidUnicode */;
                        }
                        break;
                    default:
                        scanError = 5 /* ScanError.InvalidEscapeCharacter */;
                }
                start = pos;
                continue;
            }
            if (ch >= 0 && ch <= 0x1f) {
                if (isLineBreak(ch)) {
                    result += text.substring(start, pos);
                    scanError = 2 /* ScanError.UnexpectedEndOfString */;
                    break;
                }
                else {
                    scanError = 6 /* ScanError.InvalidCharacter */;
                    // mark as error but continue with string
                }
            }
            pos++;
        }
        return result;
    }
    function scanNext() {
        value = '';
        scanError = 0 /* ScanError.None */;
        tokenOffset = pos;
        lineStartOffset = lineNumber;
        prevTokenLineStartOffset = tokenLineStartOffset;
        if (pos >= len) {
            // at the end
            tokenOffset = len;
            return token = 17 /* SyntaxKind.EOF */;
        }
        let code = text.charCodeAt(pos);
        // trivia: whitespace
        if (isWhiteSpace(code)) {
            do {
                pos++;
                value += String.fromCharCode(code);
                code = text.charCodeAt(pos);
            } while (isWhiteSpace(code));
            return token = 15 /* SyntaxKind.Trivia */;
        }
        // trivia: newlines
        if (isLineBreak(code)) {
            pos++;
            value += String.fromCharCode(code);
            if (code === 13 /* CharacterCodes.carriageReturn */ && text.charCodeAt(pos) === 10 /* CharacterCodes.lineFeed */) {
                pos++;
                value += '\n';
            }
            lineNumber++;
            tokenLineStartOffset = pos;
            return token = 14 /* SyntaxKind.LineBreakTrivia */;
        }
        switch (code) {
            // tokens: []{}:,
            case 123 /* CharacterCodes.openBrace */:
                pos++;
                return token = 1 /* SyntaxKind.OpenBraceToken */;
            case 125 /* CharacterCodes.closeBrace */:
                pos++;
                return token = 2 /* SyntaxKind.CloseBraceToken */;
            case 91 /* CharacterCodes.openBracket */:
                pos++;
                return token = 3 /* SyntaxKind.OpenBracketToken */;
            case 93 /* CharacterCodes.closeBracket */:
                pos++;
                return token = 4 /* SyntaxKind.CloseBracketToken */;
            case 58 /* CharacterCodes.colon */:
                pos++;
                return token = 6 /* SyntaxKind.ColonToken */;
            case 44 /* CharacterCodes.comma */:
                pos++;
                return token = 5 /* SyntaxKind.CommaToken */;
            // strings
            case 34 /* CharacterCodes.doubleQuote */:
                pos++;
                value = scanString();
                return token = 10 /* SyntaxKind.StringLiteral */;
            // comments
            case 47 /* CharacterCodes.slash */:
                const start = pos - 1;
                // Single-line comment
                if (text.charCodeAt(pos + 1) === 47 /* CharacterCodes.slash */) {
                    pos += 2;
                    while (pos < len) {
                        if (isLineBreak(text.charCodeAt(pos))) {
                            break;
                        }
                        pos++;
                    }
                    value = text.substring(start, pos);
                    return token = 12 /* SyntaxKind.LineCommentTrivia */;
                }
                // Multi-line comment
                if (text.charCodeAt(pos + 1) === 42 /* CharacterCodes.asterisk */) {
                    pos += 2;
                    const safeLength = len - 1; // For lookahead.
                    let commentClosed = false;
                    while (pos < safeLength) {
                        const ch = text.charCodeAt(pos);
                        if (ch === 42 /* CharacterCodes.asterisk */ && text.charCodeAt(pos + 1) === 47 /* CharacterCodes.slash */) {
                            pos += 2;
                            commentClosed = true;
                            break;
                        }
                        pos++;
                        if (isLineBreak(ch)) {
                            if (ch === 13 /* CharacterCodes.carriageReturn */ && text.charCodeAt(pos) === 10 /* CharacterCodes.lineFeed */) {
                                pos++;
                            }
                            lineNumber++;
                            tokenLineStartOffset = pos;
                        }
                    }
                    if (!commentClosed) {
                        pos++;
                        scanError = 1 /* ScanError.UnexpectedEndOfComment */;
                    }
                    value = text.substring(start, pos);
                    return token = 13 /* SyntaxKind.BlockCommentTrivia */;
                }
                // just a single slash
                value += String.fromCharCode(code);
                pos++;
                return token = 16 /* SyntaxKind.Unknown */;
            // numbers
            case 45 /* CharacterCodes.minus */:
                value += String.fromCharCode(code);
                pos++;
                if (pos === len || !isDigit(text.charCodeAt(pos))) {
                    return token = 16 /* SyntaxKind.Unknown */;
                }
            // found a minus, followed by a number so
            // we fall through to proceed with scanning
            // numbers
            case 48 /* CharacterCodes._0 */:
            case 49 /* CharacterCodes._1 */:
            case 50 /* CharacterCodes._2 */:
            case 51 /* CharacterCodes._3 */:
            case 52 /* CharacterCodes._4 */:
            case 53 /* CharacterCodes._5 */:
            case 54 /* CharacterCodes._6 */:
            case 55 /* CharacterCodes._7 */:
            case 56 /* CharacterCodes._8 */:
            case 57 /* CharacterCodes._9 */:
                value += scanNumber();
                return token = 11 /* SyntaxKind.NumericLiteral */;
            // literals and unknown symbols
            default:
                // is a literal? Read the full word.
                while (pos < len && isUnknownContentCharacter(code)) {
                    pos++;
                    code = text.charCodeAt(pos);
                }
                if (tokenOffset !== pos) {
                    value = text.substring(tokenOffset, pos);
                    // keywords: true, false, null
                    switch (value) {
                        case 'true': return token = 8 /* SyntaxKind.TrueKeyword */;
                        case 'false': return token = 9 /* SyntaxKind.FalseKeyword */;
                        case 'null': return token = 7 /* SyntaxKind.NullKeyword */;
                    }
                    return token = 16 /* SyntaxKind.Unknown */;
                }
                // some
                value += String.fromCharCode(code);
                pos++;
                return token = 16 /* SyntaxKind.Unknown */;
        }
    }
    function isUnknownContentCharacter(code) {
        if (isWhiteSpace(code) || isLineBreak(code)) {
            return false;
        }
        switch (code) {
            case 125 /* CharacterCodes.closeBrace */:
            case 93 /* CharacterCodes.closeBracket */:
            case 123 /* CharacterCodes.openBrace */:
            case 91 /* CharacterCodes.openBracket */:
            case 34 /* CharacterCodes.doubleQuote */:
            case 58 /* CharacterCodes.colon */:
            case 44 /* CharacterCodes.comma */:
            case 47 /* CharacterCodes.slash */:
                return false;
        }
        return true;
    }
    function scanNextNonTrivia() {
        let result;
        do {
            result = scanNext();
        } while (result >= 12 /* SyntaxKind.LineCommentTrivia */ && result <= 15 /* SyntaxKind.Trivia */);
        return result;
    }
    return {
        setPosition: setPosition,
        getPosition: () => pos,
        scan: ignoreTrivia ? scanNextNonTrivia : scanNext,
        getToken: () => token,
        getTokenValue: () => value,
        getTokenOffset: () => tokenOffset,
        getTokenLength: () => pos - tokenOffset,
        getTokenStartLine: () => lineStartOffset,
        getTokenStartCharacter: () => tokenOffset - prevTokenLineStartOffset,
        getTokenError: () => scanError,
    };
}
function isWhiteSpace(ch) {
    return ch === 32 /* CharacterCodes.space */ || ch === 9 /* CharacterCodes.tab */;
}
function isLineBreak(ch) {
    return ch === 10 /* CharacterCodes.lineFeed */ || ch === 13 /* CharacterCodes.carriageReturn */;
}
function isDigit(ch) {
    return ch >= 48 /* CharacterCodes._0 */ && ch <= 57 /* CharacterCodes._9 */;
}
var CharacterCodes;
(function (CharacterCodes) {
    CharacterCodes[CharacterCodes["lineFeed"] = 10] = "lineFeed";
    CharacterCodes[CharacterCodes["carriageReturn"] = 13] = "carriageReturn";
    CharacterCodes[CharacterCodes["space"] = 32] = "space";
    CharacterCodes[CharacterCodes["_0"] = 48] = "_0";
    CharacterCodes[CharacterCodes["_1"] = 49] = "_1";
    CharacterCodes[CharacterCodes["_2"] = 50] = "_2";
    CharacterCodes[CharacterCodes["_3"] = 51] = "_3";
    CharacterCodes[CharacterCodes["_4"] = 52] = "_4";
    CharacterCodes[CharacterCodes["_5"] = 53] = "_5";
    CharacterCodes[CharacterCodes["_6"] = 54] = "_6";
    CharacterCodes[CharacterCodes["_7"] = 55] = "_7";
    CharacterCodes[CharacterCodes["_8"] = 56] = "_8";
    CharacterCodes[CharacterCodes["_9"] = 57] = "_9";
    CharacterCodes[CharacterCodes["a"] = 97] = "a";
    CharacterCodes[CharacterCodes["b"] = 98] = "b";
    CharacterCodes[CharacterCodes["c"] = 99] = "c";
    CharacterCodes[CharacterCodes["d"] = 100] = "d";
    CharacterCodes[CharacterCodes["e"] = 101] = "e";
    CharacterCodes[CharacterCodes["f"] = 102] = "f";
    CharacterCodes[CharacterCodes["g"] = 103] = "g";
    CharacterCodes[CharacterCodes["h"] = 104] = "h";
    CharacterCodes[CharacterCodes["i"] = 105] = "i";
    CharacterCodes[CharacterCodes["j"] = 106] = "j";
    CharacterCodes[CharacterCodes["k"] = 107] = "k";
    CharacterCodes[CharacterCodes["l"] = 108] = "l";
    CharacterCodes[CharacterCodes["m"] = 109] = "m";
    CharacterCodes[CharacterCodes["n"] = 110] = "n";
    CharacterCodes[CharacterCodes["o"] = 111] = "o";
    CharacterCodes[CharacterCodes["p"] = 112] = "p";
    CharacterCodes[CharacterCodes["q"] = 113] = "q";
    CharacterCodes[CharacterCodes["r"] = 114] = "r";
    CharacterCodes[CharacterCodes["s"] = 115] = "s";
    CharacterCodes[CharacterCodes["t"] = 116] = "t";
    CharacterCodes[CharacterCodes["u"] = 117] = "u";
    CharacterCodes[CharacterCodes["v"] = 118] = "v";
    CharacterCodes[CharacterCodes["w"] = 119] = "w";
    CharacterCodes[CharacterCodes["x"] = 120] = "x";
    CharacterCodes[CharacterCodes["y"] = 121] = "y";
    CharacterCodes[CharacterCodes["z"] = 122] = "z";
    CharacterCodes[CharacterCodes["A"] = 65] = "A";
    CharacterCodes[CharacterCodes["B"] = 66] = "B";
    CharacterCodes[CharacterCodes["C"] = 67] = "C";
    CharacterCodes[CharacterCodes["D"] = 68] = "D";
    CharacterCodes[CharacterCodes["E"] = 69] = "E";
    CharacterCodes[CharacterCodes["F"] = 70] = "F";
    CharacterCodes[CharacterCodes["G"] = 71] = "G";
    CharacterCodes[CharacterCodes["H"] = 72] = "H";
    CharacterCodes[CharacterCodes["I"] = 73] = "I";
    CharacterCodes[CharacterCodes["J"] = 74] = "J";
    CharacterCodes[CharacterCodes["K"] = 75] = "K";
    CharacterCodes[CharacterCodes["L"] = 76] = "L";
    CharacterCodes[CharacterCodes["M"] = 77] = "M";
    CharacterCodes[CharacterCodes["N"] = 78] = "N";
    CharacterCodes[CharacterCodes["O"] = 79] = "O";
    CharacterCodes[CharacterCodes["P"] = 80] = "P";
    CharacterCodes[CharacterCodes["Q"] = 81] = "Q";
    CharacterCodes[CharacterCodes["R"] = 82] = "R";
    CharacterCodes[CharacterCodes["S"] = 83] = "S";
    CharacterCodes[CharacterCodes["T"] = 84] = "T";
    CharacterCodes[CharacterCodes["U"] = 85] = "U";
    CharacterCodes[CharacterCodes["V"] = 86] = "V";
    CharacterCodes[CharacterCodes["W"] = 87] = "W";
    CharacterCodes[CharacterCodes["X"] = 88] = "X";
    CharacterCodes[CharacterCodes["Y"] = 89] = "Y";
    CharacterCodes[CharacterCodes["Z"] = 90] = "Z";
    CharacterCodes[CharacterCodes["asterisk"] = 42] = "asterisk";
    CharacterCodes[CharacterCodes["backslash"] = 92] = "backslash";
    CharacterCodes[CharacterCodes["closeBrace"] = 125] = "closeBrace";
    CharacterCodes[CharacterCodes["closeBracket"] = 93] = "closeBracket";
    CharacterCodes[CharacterCodes["colon"] = 58] = "colon";
    CharacterCodes[CharacterCodes["comma"] = 44] = "comma";
    CharacterCodes[CharacterCodes["dot"] = 46] = "dot";
    CharacterCodes[CharacterCodes["doubleQuote"] = 34] = "doubleQuote";
    CharacterCodes[CharacterCodes["minus"] = 45] = "minus";
    CharacterCodes[CharacterCodes["openBrace"] = 123] = "openBrace";
    CharacterCodes[CharacterCodes["openBracket"] = 91] = "openBracket";
    CharacterCodes[CharacterCodes["plus"] = 43] = "plus";
    CharacterCodes[CharacterCodes["slash"] = 47] = "slash";
    CharacterCodes[CharacterCodes["formFeed"] = 12] = "formFeed";
    CharacterCodes[CharacterCodes["tab"] = 9] = "tab";
})(CharacterCodes || (CharacterCodes = {}));


/***/ }),

/***/ "../../node_modules/jsonc-parser/lib/esm/main.js":
/*!*******************************************************!*\
  !*** ../../node_modules/jsonc-parser/lib/esm/main.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ParseErrorCode: () => (/* binding */ ParseErrorCode),
/* harmony export */   ScanError: () => (/* binding */ ScanError),
/* harmony export */   SyntaxKind: () => (/* binding */ SyntaxKind),
/* harmony export */   applyEdits: () => (/* binding */ applyEdits),
/* harmony export */   createScanner: () => (/* binding */ createScanner),
/* harmony export */   findNodeAtLocation: () => (/* binding */ findNodeAtLocation),
/* harmony export */   findNodeAtOffset: () => (/* binding */ findNodeAtOffset),
/* harmony export */   format: () => (/* binding */ format),
/* harmony export */   getLocation: () => (/* binding */ getLocation),
/* harmony export */   getNodePath: () => (/* binding */ getNodePath),
/* harmony export */   getNodeValue: () => (/* binding */ getNodeValue),
/* harmony export */   modify: () => (/* binding */ modify),
/* harmony export */   parse: () => (/* binding */ parse),
/* harmony export */   parseTree: () => (/* binding */ parseTree),
/* harmony export */   printParseErrorCode: () => (/* binding */ printParseErrorCode),
/* harmony export */   stripComments: () => (/* binding */ stripComments),
/* harmony export */   visit: () => (/* binding */ visit)
/* harmony export */ });
/* harmony import */ var _impl_format__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./impl/format */ "../../node_modules/jsonc-parser/lib/esm/impl/format.js");
/* harmony import */ var _impl_edit__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./impl/edit */ "../../node_modules/jsonc-parser/lib/esm/impl/edit.js");
/* harmony import */ var _impl_scanner__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./impl/scanner */ "../../node_modules/jsonc-parser/lib/esm/impl/scanner.js");
/* harmony import */ var _impl_parser__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./impl/parser */ "../../node_modules/jsonc-parser/lib/esm/impl/parser.js");
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/





/**
 * Creates a JSON scanner on the given text.
 * If ignoreTrivia is set, whitespaces or comments are ignored.
 */
const createScanner = _impl_scanner__WEBPACK_IMPORTED_MODULE_2__.createScanner;
var ScanError;
(function (ScanError) {
    ScanError[ScanError["None"] = 0] = "None";
    ScanError[ScanError["UnexpectedEndOfComment"] = 1] = "UnexpectedEndOfComment";
    ScanError[ScanError["UnexpectedEndOfString"] = 2] = "UnexpectedEndOfString";
    ScanError[ScanError["UnexpectedEndOfNumber"] = 3] = "UnexpectedEndOfNumber";
    ScanError[ScanError["InvalidUnicode"] = 4] = "InvalidUnicode";
    ScanError[ScanError["InvalidEscapeCharacter"] = 5] = "InvalidEscapeCharacter";
    ScanError[ScanError["InvalidCharacter"] = 6] = "InvalidCharacter";
})(ScanError || (ScanError = {}));
var SyntaxKind;
(function (SyntaxKind) {
    SyntaxKind[SyntaxKind["OpenBraceToken"] = 1] = "OpenBraceToken";
    SyntaxKind[SyntaxKind["CloseBraceToken"] = 2] = "CloseBraceToken";
    SyntaxKind[SyntaxKind["OpenBracketToken"] = 3] = "OpenBracketToken";
    SyntaxKind[SyntaxKind["CloseBracketToken"] = 4] = "CloseBracketToken";
    SyntaxKind[SyntaxKind["CommaToken"] = 5] = "CommaToken";
    SyntaxKind[SyntaxKind["ColonToken"] = 6] = "ColonToken";
    SyntaxKind[SyntaxKind["NullKeyword"] = 7] = "NullKeyword";
    SyntaxKind[SyntaxKind["TrueKeyword"] = 8] = "TrueKeyword";
    SyntaxKind[SyntaxKind["FalseKeyword"] = 9] = "FalseKeyword";
    SyntaxKind[SyntaxKind["StringLiteral"] = 10] = "StringLiteral";
    SyntaxKind[SyntaxKind["NumericLiteral"] = 11] = "NumericLiteral";
    SyntaxKind[SyntaxKind["LineCommentTrivia"] = 12] = "LineCommentTrivia";
    SyntaxKind[SyntaxKind["BlockCommentTrivia"] = 13] = "BlockCommentTrivia";
    SyntaxKind[SyntaxKind["LineBreakTrivia"] = 14] = "LineBreakTrivia";
    SyntaxKind[SyntaxKind["Trivia"] = 15] = "Trivia";
    SyntaxKind[SyntaxKind["Unknown"] = 16] = "Unknown";
    SyntaxKind[SyntaxKind["EOF"] = 17] = "EOF";
})(SyntaxKind || (SyntaxKind = {}));
/**
 * For a given offset, evaluate the location in the JSON document. Each segment in the location path is either a property name or an array index.
 */
const getLocation = _impl_parser__WEBPACK_IMPORTED_MODULE_3__.getLocation;
/**
 * Parses the given text and returns the object the JSON content represents. On invalid input, the parser tries to be as fault tolerant as possible, but still return a result.
 * Therefore, always check the errors list to find out if the input was valid.
 */
const parse = _impl_parser__WEBPACK_IMPORTED_MODULE_3__.parse;
/**
 * Parses the given text and returns a tree representation the JSON content. On invalid input, the parser tries to be as fault tolerant as possible, but still return a result.
 */
const parseTree = _impl_parser__WEBPACK_IMPORTED_MODULE_3__.parseTree;
/**
 * Finds the node at the given path in a JSON DOM.
 */
const findNodeAtLocation = _impl_parser__WEBPACK_IMPORTED_MODULE_3__.findNodeAtLocation;
/**
 * Finds the innermost node at the given offset. If includeRightBound is set, also finds nodes that end at the given offset.
 */
const findNodeAtOffset = _impl_parser__WEBPACK_IMPORTED_MODULE_3__.findNodeAtOffset;
/**
 * Gets the JSON path of the given JSON DOM node
 */
const getNodePath = _impl_parser__WEBPACK_IMPORTED_MODULE_3__.getNodePath;
/**
 * Evaluates the JavaScript object of the given JSON DOM node
 */
const getNodeValue = _impl_parser__WEBPACK_IMPORTED_MODULE_3__.getNodeValue;
/**
 * Parses the given text and invokes the visitor functions for each object, array and literal reached.
 */
const visit = _impl_parser__WEBPACK_IMPORTED_MODULE_3__.visit;
/**
 * Takes JSON with JavaScript-style comments and remove
 * them. Optionally replaces every none-newline character
 * of comments with a replaceCharacter
 */
const stripComments = _impl_parser__WEBPACK_IMPORTED_MODULE_3__.stripComments;
var ParseErrorCode;
(function (ParseErrorCode) {
    ParseErrorCode[ParseErrorCode["InvalidSymbol"] = 1] = "InvalidSymbol";
    ParseErrorCode[ParseErrorCode["InvalidNumberFormat"] = 2] = "InvalidNumberFormat";
    ParseErrorCode[ParseErrorCode["PropertyNameExpected"] = 3] = "PropertyNameExpected";
    ParseErrorCode[ParseErrorCode["ValueExpected"] = 4] = "ValueExpected";
    ParseErrorCode[ParseErrorCode["ColonExpected"] = 5] = "ColonExpected";
    ParseErrorCode[ParseErrorCode["CommaExpected"] = 6] = "CommaExpected";
    ParseErrorCode[ParseErrorCode["CloseBraceExpected"] = 7] = "CloseBraceExpected";
    ParseErrorCode[ParseErrorCode["CloseBracketExpected"] = 8] = "CloseBracketExpected";
    ParseErrorCode[ParseErrorCode["EndOfFileExpected"] = 9] = "EndOfFileExpected";
    ParseErrorCode[ParseErrorCode["InvalidCommentToken"] = 10] = "InvalidCommentToken";
    ParseErrorCode[ParseErrorCode["UnexpectedEndOfComment"] = 11] = "UnexpectedEndOfComment";
    ParseErrorCode[ParseErrorCode["UnexpectedEndOfString"] = 12] = "UnexpectedEndOfString";
    ParseErrorCode[ParseErrorCode["UnexpectedEndOfNumber"] = 13] = "UnexpectedEndOfNumber";
    ParseErrorCode[ParseErrorCode["InvalidUnicode"] = 14] = "InvalidUnicode";
    ParseErrorCode[ParseErrorCode["InvalidEscapeCharacter"] = 15] = "InvalidEscapeCharacter";
    ParseErrorCode[ParseErrorCode["InvalidCharacter"] = 16] = "InvalidCharacter";
})(ParseErrorCode || (ParseErrorCode = {}));
function printParseErrorCode(code) {
    switch (code) {
        case 1 /* ParseErrorCode.InvalidSymbol */: return 'InvalidSymbol';
        case 2 /* ParseErrorCode.InvalidNumberFormat */: return 'InvalidNumberFormat';
        case 3 /* ParseErrorCode.PropertyNameExpected */: return 'PropertyNameExpected';
        case 4 /* ParseErrorCode.ValueExpected */: return 'ValueExpected';
        case 5 /* ParseErrorCode.ColonExpected */: return 'ColonExpected';
        case 6 /* ParseErrorCode.CommaExpected */: return 'CommaExpected';
        case 7 /* ParseErrorCode.CloseBraceExpected */: return 'CloseBraceExpected';
        case 8 /* ParseErrorCode.CloseBracketExpected */: return 'CloseBracketExpected';
        case 9 /* ParseErrorCode.EndOfFileExpected */: return 'EndOfFileExpected';
        case 10 /* ParseErrorCode.InvalidCommentToken */: return 'InvalidCommentToken';
        case 11 /* ParseErrorCode.UnexpectedEndOfComment */: return 'UnexpectedEndOfComment';
        case 12 /* ParseErrorCode.UnexpectedEndOfString */: return 'UnexpectedEndOfString';
        case 13 /* ParseErrorCode.UnexpectedEndOfNumber */: return 'UnexpectedEndOfNumber';
        case 14 /* ParseErrorCode.InvalidUnicode */: return 'InvalidUnicode';
        case 15 /* ParseErrorCode.InvalidEscapeCharacter */: return 'InvalidEscapeCharacter';
        case 16 /* ParseErrorCode.InvalidCharacter */: return 'InvalidCharacter';
    }
    return '<unknown ParseErrorCode>';
}
/**
 * Computes the edit operations needed to format a JSON document.
 *
 * @param documentText The input text
 * @param range The range to format or `undefined` to format the full content
 * @param options The formatting options
 * @returns The edit operations describing the formatting changes to the original document following the format described in {@linkcode EditResult}.
 * To apply the edit operations to the input, use {@linkcode applyEdits}.
 */
function format(documentText, range, options) {
    return _impl_format__WEBPACK_IMPORTED_MODULE_0__.format(documentText, range, options);
}
/**
 * Computes the edit operations needed to modify a value in the JSON document.
 *
 * @param documentText The input text
 * @param path The path of the value to change. The path represents either to the document root, a property or an array item.
 * If the path points to an non-existing property or item, it will be created.
 * @param value The new value for the specified property or item. If the value is undefined,
 * the property or item will be removed.
 * @param options Options
 * @returns The edit operations describing the changes to the original document, following the format described in {@linkcode EditResult}.
 * To apply the edit operations to the input, use {@linkcode applyEdits}.
 */
function modify(text, path, value, options) {
    return _impl_edit__WEBPACK_IMPORTED_MODULE_1__.setProperty(text, path, value, options);
}
/**
 * Applies edits to an input string.
 * @param text The input text
 * @param edits Edit operations following the format described in {@linkcode EditResult}.
 * @returns The text with the applied edits.
 * @throws An error if the edit operations are not well-formed as described in {@linkcode EditResult}.
 */
function applyEdits(text, edits) {
    let sortedEdits = edits.slice(0).sort((a, b) => {
        const diff = a.offset - b.offset;
        if (diff === 0) {
            return a.length - b.length;
        }
        return diff;
    });
    let lastModifiedOffset = text.length;
    for (let i = sortedEdits.length - 1; i >= 0; i--) {
        let e = sortedEdits[i];
        if (e.offset + e.length <= lastModifiedOffset) {
            text = _impl_edit__WEBPACK_IMPORTED_MODULE_1__.applyEdit(text, e);
        }
        else {
            throw new Error('Overlapping edit');
        }
        lastModifiedOffset = e.offset;
    }
    return text;
}


/***/ })

}]);
//# sourceMappingURL=vendors-node_modules_elyra_pipeline-services_dist_index_js.f08fda933be0b90f8087.js.map