"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClassicLoadBalancerTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use a classic ELB as an alias record target.
 *
 * @stability stable
 */
class ClassicLoadBalancerTarget {
    /**
     * @stability stable
     */
    constructor(loadBalancer) {
        this.loadBalancer = loadBalancer;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record, _zone) {
        return {
            hostedZoneId: this.loadBalancer.loadBalancerCanonicalHostedZoneNameId,
            dnsName: `dualstack.${this.loadBalancer.loadBalancerDnsName}`,
        };
    }
}
exports.ClassicLoadBalancerTarget = ClassicLoadBalancerTarget;
_a = JSII_RTTI_SYMBOL_1;
ClassicLoadBalancerTarget[_a] = { fqn: "@aws-cdk/aws-route53-targets.ClassicLoadBalancerTarget", version: "1.131.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xhc3NpYy1sb2FkLWJhbGFuY2VyLXRhcmdldC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNsYXNzaWMtbG9hZC1iYWxhbmNlci10YXJnZXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7OztBQUlBLE1BQWEseUJBQXlCOzs7O0lBQ3BDLFlBQTZCLFlBQThCO1FBQTlCLGlCQUFZLEdBQVosWUFBWSxDQUFrQjtJQUMzRCxDQUFDOzs7Ozs7SUFFTSxJQUFJLENBQUMsT0FBMkIsRUFBRSxLQUEyQjtRQUNsRSxPQUFPO1lBQ0wsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZLENBQUMscUNBQXFDO1lBQ3JFLE9BQU8sRUFBRSxhQUFhLElBQUksQ0FBQyxZQUFZLENBQUMsbUJBQW1CLEVBQUU7U0FDOUQsQ0FBQztJQUNKLENBQUM7O0FBVEgsOERBVUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBlbGIgZnJvbSAnQGF3cy1jZGsvYXdzLWVsYXN0aWNsb2FkYmFsYW5jaW5nJztcbmltcG9ydCAqIGFzIHJvdXRlNTMgZnJvbSAnQGF3cy1jZGsvYXdzLXJvdXRlNTMnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBDbGFzc2ljTG9hZEJhbGFuY2VyVGFyZ2V0IGltcGxlbWVudHMgcm91dGU1My5JQWxpYXNSZWNvcmRUYXJnZXQge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGxvYWRCYWxhbmNlcjogZWxiLkxvYWRCYWxhbmNlcikge1xuICB9XG5cbiAgcHVibGljIGJpbmQoX3JlY29yZDogcm91dGU1My5JUmVjb3JkU2V0LCBfem9uZT86IHJvdXRlNTMuSUhvc3RlZFpvbmUpOiByb3V0ZTUzLkFsaWFzUmVjb3JkVGFyZ2V0Q29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgaG9zdGVkWm9uZUlkOiB0aGlzLmxvYWRCYWxhbmNlci5sb2FkQmFsYW5jZXJDYW5vbmljYWxIb3N0ZWRab25lTmFtZUlkLFxuICAgICAgZG5zTmFtZTogYGR1YWxzdGFjay4ke3RoaXMubG9hZEJhbGFuY2VyLmxvYWRCYWxhbmNlckRuc05hbWV9YCxcbiAgICB9O1xuICB9XG59XG4iXX0=