"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticBeanstalkEnvironmentEndpointTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
/**
 * Use an Elastic Beanstalk environment URL as an alias record target. E.g. mysampleenvironment.xyz.us-east-1.elasticbeanstalk.com.
 *
 * Only supports Elastic Beanstalk environments created after 2016 that have a regional endpoint.
 *
 * @stability stable
 */
class ElasticBeanstalkEnvironmentEndpointTarget {
    /**
     * @stability stable
     */
    constructor(environmentEndpoint) {
        this.environmentEndpoint = environmentEndpoint;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record, _zone) {
        if (cdk.Token.isUnresolved(this.environmentEndpoint)) {
            throw new Error('Cannot use an EBS alias as `environmentEndpoint`. You must find your EBS environment endpoint via the AWS console. See the Elastic Beanstalk developer guide: https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/customdomains.html');
        }
        const dnsName = this.environmentEndpoint;
        const region = cdk.Fn.select(2, cdk.Fn.split('.', dnsName));
        const { ebsEnvEndpointHostedZoneId: hostedZoneId } = region_info_1.RegionInfo.get(region);
        if (!hostedZoneId || !dnsName) {
            throw new Error(`Elastic Beanstalk environment target is not supported for the "${region}" region.`);
        }
        return {
            hostedZoneId,
            dnsName,
        };
    }
}
exports.ElasticBeanstalkEnvironmentEndpointTarget = ElasticBeanstalkEnvironmentEndpointTarget;
_a = JSII_RTTI_SYMBOL_1;
ElasticBeanstalkEnvironmentEndpointTarget[_a] = { fqn: "@aws-cdk/aws-route53-targets.ElasticBeanstalkEnvironmentEndpointTarget", version: "1.131.0" };
//# sourceMappingURL=data:application/json;base64,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