"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalAcceleratorTarget = exports.GlobalAcceleratorDomainTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use a Global Accelerator domain name as an alias record target.
 *
 * @stability stable
 */
class GlobalAcceleratorDomainTarget {
    /**
     * Create an Alias Target for a Global Accelerator domain name.
     *
     * @stability stable
     */
    constructor(acceleratorDomainName) {
        this.acceleratorDomainName = acceleratorDomainName;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record, _zone) {
        return {
            hostedZoneId: GlobalAcceleratorTarget.GLOBAL_ACCELERATOR_ZONE_ID,
            dnsName: this.acceleratorDomainName,
        };
    }
}
exports.GlobalAcceleratorDomainTarget = GlobalAcceleratorDomainTarget;
_a = JSII_RTTI_SYMBOL_1;
GlobalAcceleratorDomainTarget[_a] = { fqn: "@aws-cdk/aws-route53-targets.GlobalAcceleratorDomainTarget", version: "1.131.0" };
/**
 * The hosted zone Id if using an alias record in Route53.
 *
 * This value never changes.
 * Ref: https://docs.aws.amazon.com/general/latest/gr/global_accelerator.html
 *
 * @stability stable
 */
GlobalAcceleratorDomainTarget.GLOBAL_ACCELERATOR_ZONE_ID = 'Z2BJ6XQ5FK7U4H';
/**
 * Use a Global Accelerator instance domain name as an alias record target.
 *
 * @stability stable
 */
class GlobalAcceleratorTarget extends GlobalAcceleratorDomainTarget {
    /**
     * Create an Alias Target for a Global Accelerator instance.
     *
     * @stability stable
     */
    constructor(accelerator) {
        super(accelerator.dnsName);
    }
}
exports.GlobalAcceleratorTarget = GlobalAcceleratorTarget;
_b = JSII_RTTI_SYMBOL_1;
GlobalAcceleratorTarget[_b] = { fqn: "@aws-cdk/aws-route53-targets.GlobalAcceleratorTarget", version: "1.131.0" };
//# sourceMappingURL=data:application/json;base64,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