"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancerTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use an ELBv2 as an alias record target.
 *
 * @stability stable
 */
class LoadBalancerTarget {
    /**
     * @stability stable
     */
    constructor(loadBalancer) {
        this.loadBalancer = loadBalancer;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record, _zone) {
        return {
            hostedZoneId: this.loadBalancer.loadBalancerCanonicalHostedZoneId,
            dnsName: `dualstack.${this.loadBalancer.loadBalancerDnsName}`,
        };
    }
}
exports.LoadBalancerTarget = LoadBalancerTarget;
_a = JSII_RTTI_SYMBOL_1;
LoadBalancerTarget[_a] = { fqn: "@aws-cdk/aws-route53-targets.LoadBalancerTarget", version: "1.131.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9hZC1iYWxhbmNlci10YXJnZXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsb2FkLWJhbGFuY2VyLXRhcmdldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7O0FBSUEsTUFBYSxrQkFBa0I7Ozs7SUFDN0IsWUFBNkIsWUFBbUM7UUFBbkMsaUJBQVksR0FBWixZQUFZLENBQXVCO0lBQ2hFLENBQUM7Ozs7OztJQUVNLElBQUksQ0FBQyxPQUEyQixFQUFFLEtBQTJCO1FBQ2xFLE9BQU87WUFDTCxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxpQ0FBaUM7WUFDakUsT0FBTyxFQUFFLGFBQWEsSUFBSSxDQUFDLFlBQVksQ0FBQyxtQkFBbUIsRUFBRTtTQUM5RCxDQUFDO0lBQ0osQ0FBQzs7QUFUSCxnREFVQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGVsYnYyIGZyb20gJ0Bhd3MtY2RrL2F3cy1lbGFzdGljbG9hZGJhbGFuY2luZ3YyJztcbmltcG9ydCAqIGFzIHJvdXRlNTMgZnJvbSAnQGF3cy1jZGsvYXdzLXJvdXRlNTMnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgTG9hZEJhbGFuY2VyVGFyZ2V0IGltcGxlbWVudHMgcm91dGU1My5JQWxpYXNSZWNvcmRUYXJnZXQge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGxvYWRCYWxhbmNlcjogZWxidjIuSUxvYWRCYWxhbmNlclYyKSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChfcmVjb3JkOiByb3V0ZTUzLklSZWNvcmRTZXQsIF96b25lPzogcm91dGU1My5JSG9zdGVkWm9uZSk6IHJvdXRlNTMuQWxpYXNSZWNvcmRUYXJnZXRDb25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBob3N0ZWRab25lSWQ6IHRoaXMubG9hZEJhbGFuY2VyLmxvYWRCYWxhbmNlckNhbm9uaWNhbEhvc3RlZFpvbmVJZCxcbiAgICAgIGRuc05hbWU6IGBkdWFsc3RhY2suJHt0aGlzLmxvYWRCYWxhbmNlci5sb2FkQmFsYW5jZXJEbnNOYW1lfWAsXG4gICAgfTtcbiAgfVxufVxuIl19