"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolDomainTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudfront_target_1 = require("./cloudfront-target");
/**
 * Use a user pool domain as an alias record target.
 *
 * @stability stable
 */
class UserPoolDomainTarget {
    /**
     * @stability stable
     */
    constructor(domain) {
        this.domain = domain;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record, _zone) {
        return {
            dnsName: this.domain.cloudFrontDomainName,
            hostedZoneId: cloudfront_target_1.CloudFrontTarget.getHostedZoneId(this.domain),
        };
    }
}
exports.UserPoolDomainTarget = UserPoolDomainTarget;
_a = JSII_RTTI_SYMBOL_1;
UserPoolDomainTarget[_a] = { fqn: "@aws-cdk/aws-route53-targets.UserPoolDomainTarget", version: "1.131.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXNlcnBvb2wtZG9tYWluLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidXNlcnBvb2wtZG9tYWluLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBRUEsMkRBQXVEOzs7Ozs7QUFHdkQsTUFBYSxvQkFBb0I7Ozs7SUFDL0IsWUFBNkIsTUFBc0I7UUFBdEIsV0FBTSxHQUFOLE1BQU0sQ0FBZ0I7SUFDbkQsQ0FBQzs7Ozs7O0lBRU0sSUFBSSxDQUFDLE9BQW1CLEVBQUUsS0FBbUI7UUFDbEQsT0FBTztZQUNMLE9BQU8sRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLG9CQUFvQjtZQUN6QyxZQUFZLEVBQUUsb0NBQWdCLENBQUMsZUFBZSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUM7U0FDNUQsQ0FBQztJQUNKLENBQUM7O0FBVEgsb0RBVUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBVc2VyUG9vbERvbWFpbiB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1jb2duaXRvJztcbmltcG9ydCB7IEFsaWFzUmVjb3JkVGFyZ2V0Q29uZmlnLCBJQWxpYXNSZWNvcmRUYXJnZXQsIElIb3N0ZWRab25lLCBJUmVjb3JkU2V0IH0gZnJvbSAnQGF3cy1jZGsvYXdzLXJvdXRlNTMnO1xuaW1wb3J0IHsgQ2xvdWRGcm9udFRhcmdldCB9IGZyb20gJy4vY2xvdWRmcm9udC10YXJnZXQnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFVzZXJQb29sRG9tYWluVGFyZ2V0IGltcGxlbWVudHMgSUFsaWFzUmVjb3JkVGFyZ2V0IHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBkb21haW46IFVzZXJQb29sRG9tYWluKSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChfcmVjb3JkOiBJUmVjb3JkU2V0LCBfem9uZT86IElIb3N0ZWRab25lKTogQWxpYXNSZWNvcmRUYXJnZXRDb25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBkbnNOYW1lOiB0aGlzLmRvbWFpbi5jbG91ZEZyb250RG9tYWluTmFtZSxcbiAgICAgIGhvc3RlZFpvbmVJZDogQ2xvdWRGcm9udFRhcmdldC5nZXRIb3N0ZWRab25lSWQodGhpcy5kb21haW4pLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==