# This file is part of daf_butler.
#
# Developed for the LSST Data Management System.
# This product includes software developed by the LSST Project
# (http://www.lsst.org).
# See the COPYRIGHT file at the top-level directory of this distribution
# for details of code ownership.
#
# This software is dual licensed under the GNU General Public License and also
# under a 3-clause BSD license. Recipients may choose which of these licenses
# to use; please see the files gpl-3.0.txt and/or bsd_license.txt,
# respectively.  If you choose the GPL option then the following text applies
# (but note that there is still no warranty even if you opt for BSD instead):
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

__all__ = ("DatasetTypeError", "RegistryError")

# The classes in this file exist only for backwards compatibility.  New
# exception types should not inherit from these.


class RegistryError(Exception):
    """Base class for many exception classes produced by Registry methods.

    Notes
    -----
    The client code that needs to handle exceptions generated by the Registry
    methods can catch this class or one of its many subclasses as described by
    the particular method documentation. While most of the Registry methods
    should only raise the exceptions of this type, it is hard to guarantee
    that they will never raise other exception types. If the client needs to
    handle all possible exceptions, then it should also catch a standard
    `Exception` type as well. Additionally, some Registry methods can be
    explicitly documented to raise exceptions outside this class hierarchy.
    """


class DatasetTypeError(RegistryError):
    """Exception raised for problems with dataset types."""
