def factorial_recursion(n: int) -> int:
  """
  Алгоритм рекурсивного нахождения факториала числа.
  
  Описание: вычисляет произведение всех целых чисел
  от 1 до заданного числа n (n!).
  
  Оптимизация: для маленьких значений n.
  
  Применение: в комбинаторике, при расчете вероятностей, 
  в математических вычислениях.
  """
  if n == 0 or n == 1:
    return 1
  
  return n * factorial_recursion(n - 1)


def factorial_iterative(n: int) -> int:
  """
  Алгоритм рекурсивного нахождения факториала числа.
  
  Описание: вычисляет произведение всех целых чисел
  от 1 до заданного числа n (n!).
  
  Оптимизация: для больших значений n.
  
  Применение: в комбинаторике, при расчете вероятностей, 
  в математических вычислениях.
  """
  result: int = 1
  
  for i in range(1, n + 1):
    result *= i
  
  return result