import pickle
import os

this_dir, this_filename = os.path.split(__file__)
data_path = os.path.join(this_dir, 'el_GR.pickle')


greek_corpus = pickle.load(open(data_path, 'rb'))



SG = 'sg'
PL = 'pl'
NOM = 'nom'
GEN = 'gen'
ACC = 'acc'
VOC = 'voc'
MASC = 'masc'
FEM = 'fem'
NEUT = 'neut'
ND = 'nd'


forms_with_alternatives = ('ακόμη', 'ακόμα', 'και', 'κι', 'τίποτα', 'τίποτε')
dictionary_with_alt = {'ακόμη': 'ακόμα', 'και': 'κι', 'τίποτα': 'τίποτε'}

irregular_comparatives = {'καλό': 'καλύτερος/άριστος',
                          'κακό': 'χειρότερος,ήσσων/χείριστος,ήκιστος',
                          'απλό': 'απλούστερος/απλούστατος',
                          'μεγάλο': 'μεγαλύτερος/μέγιστος',
                          'πολύ': 'περισσότερος/-',
                          'λίγο': 'λιγότερος/ελάχιστος',
                          'μέγα': 'μεγαλύτερος/μέγιστος',
                          'πρώτο': 'πρωτύτερος/πρώτιστος',
                        'ταχύ': 'ταχύτερος/ταχύτατος,τάχιστος'}

irregular_comparative_adverbs = {'κακό': 'χειρότερα,ήσσον,ήττον/κάκιστα,ήκιστα',
                                 'καλό': 'καλύτερα,κάλλιον,κάλλιο/άριστα',
                                 'λίγο': 'λιγότερο/ελάχιστα', 'πολύ': 'περισσότερο/-'}

irregular_adv = {
'νωρίς': {'comp_adv': 'νωρίτερα/'}, 'άνω': {'comp_adv': 'ανώτερα/ανώτατα', 'comp': 'ανώτερος/ανώτατος'},
    'κάτω': {'comp_adv': 'κατώτεαρα/κατώτατα', 'comp': 'κατώτερος/κατώτατος'}}



adj_basic_template = {'sg':{
                    'masc':{
                        'nom': '',
                        'gen': '',
                        'acc': '',
                        'voc': ''
                    },
                    'fem':{
                        'nom': '',
                        'gen': '',
                        'acc': '',
                        'voc': ''},
                    'neut': {
                        'nom': '',
                        'gen': '',
                        'acc': '',
                        'voc': ''}
                    },
              'pl': {
                  'masc': {
                        'nom': '',
                        'gen': '',
                        'acc': '',
                        'voc': ''},
                  'fem': {
                      'nom': '',
                      'gen': '',
                      'acc': '',
                      'voc': ''
                  },
                  'neut': {
                      'nom': '',
                      'gen': '',
                      'acc': '',
                      'voc': ''
                  }
              }}

feminine_h_eis = ('γύρη', 'κύστη', 'παλισάνδρη', 'πίστη', 'τίγρη', 'πόλη')

feminine_os = ('άμμος', 'οδός', 'διάλεκτος', 'είσοδος', 'έξοδος', 'κάθοδος', 'λεωφόρος',
               'νήσος', 'παράγραφος', 'πρόοδος', 'περίοδος', 'χερσόνησος', 'ψήφος',
               'αεροσυνοδός', 'ακταιωρός', 'ατραπός', 'δοκός', 'επωδός', 'βάλανος', 'θαλαμηγός', 'σποδός', 'λίθος',
               'άβυσσος', 'Aειπάρθενος', 'άκανθος', 'άκατος', 'άλυσος', 'άμπελος', 'άνοδος', 'κιβωτός', 'στενωπός',
               'κόπρος', 'ασβεστοκάμινος', 'άσβεστος', 'άσφαλτος', 'ατμάκατος', 'άτρακτος', 'σιδηροδοκός', 'τροφός',
               'φηγός', 'άμμος', 'άρκτος', 'βάτος', 'Bίβλος', 'βίβλος', 'κανηφόρος', 'κανονιοφόρος', 'νηπιαγωγός',
               'βρεφοδόχος', 'γνάθος', 'δέλτος', 'δρόσος', 'ζωοφόρος', 'ζωφόρος', 'Θεοτόκος', 'πλίνθος', 'Ρόδος',
               'σορός', 'λέμβος', 'λαιμητόμος', 'λέμφος', 'λουτροφόρος', 'νηπιοκόμος', 'νήσος', 'νόσος', 'παρθένος',
               'ράβδος', 'σαρκοφάγος', 'σκευοφόρος', 'τεφροδόχος', 'τριτοτόκος', 'χοηφόρος', 'ψάμμος', 'ψηφοδόχος',
               'ψήφος', 'βάρβιτος', 'βάσανος', 'βενζινάκατος', 'Διακαινήσιμος', 'διάκεντρος', 'διάλεκτος', 'διάμεσος',
               'διάμετρος', 'διέξοδος', 'δικάσιμος', 'δίοδος', 'δωδεκάδελτος', 'εγκύκλιος', 'είσοδος', 'έλαφος', 'έξοδος',
               'επάνοδος', 'επέτειος', 'έρημος', 'έφοδος', 'ημισέληνος', 'ιερόδουλος', 'κάθετος', 'κάθοδος', 'κάμηλος',
               'κυπάρισσος', 'ημιδιάμετρος', 'ημιπερίοδος', 'ήπειρος', 'ίνδικτος', 'κάμινος', 'κέραμος', 'κλιμακτήριος',
               'λέκιθος', 'λήκυθος', 'μεγαλόνησος', 'μέθοδος', 'μεθόριος', 'μεσόφωνος', 'οκτώηχος', 'οπτόπλινθος',
               'Παμμακάριστος', 'Πανάχραντος', 'πανσέληνος', 'παράγραφος', 'παράγωγος', 'παρακαμπτήριος', 'παράμετρος',
               'πάροδος', 'Πεντάτευχος', 'πεντηκόντορος', 'περίμετρος', 'περίοδος', 'περίπολος', 'πισσάσφαλτος',
               'προβατοκάμηλος', 'πρόοδος', 'πρόσοδος', 'πύελος', 'πυραυλάκατος', 'σεληνάκατος', 'σταφιδάμπελος',
               'στρουθοκάμηλος', 'σύγκλητος', 'σύνοδος', 'τήβεννος', 'τορπιλάκατος', 'ύαλος', 'ύπαιθρος', 'υπερλεωφόρος',
               'υφήλιος', 'υψικάμινος', 'χερσόνησος', 'ωμόπλινθος')


feminine_or_masc = ('καπνοδόχος', 'άργιλος', 'τάφρος', 'κρύσταλλος', 'περιβαλλοντολόγος', 'απόστροφος', 'γιατρός',
                    'μηχανικός', 'ηθοποιός', 'νηπιαγογός', 'δικιγόρος',)

# should there be added language names on ika?

plur_tant_neut = ('Χριστούγεννα', 'χριστούγεννα', 'νιάτα', 'βαλκάνια', 'Ιωάννινα', 'Γιάννενα', 'Γιάννινα')

aklita_gender = {'μαδιάμ': 'fem', 'μωάμεθ': 'masc', 'μάνατζερ': 'masc', 'σερ': 'masc', 'σεφ': 'masc',
                 'ντετέκτιβ': 'masc', 'ντεντέκτιβ': 'masc', 'ρεπόρτερ': 'masc', 'πλαζ': 'fem',
                 'σεζόν': 'fem', 'σπεσιαλιτέ': 'fem', 'ρεσεψιόν': 'fem'}

irregular_nouns = {'σέβας': {'nom_sg': 'σέβας', 'nom_pl': 'σέβη', 'gen_sg': '', 'gender': 'neut'},
                  'σέλας': {'nom_sg': 'σέλας', 'nom_pl': 'σέλατα,σέλαα', 'gen_sg': 'σέλατος,σέλαος', 'gender': 'neut'},
                  'δείλι': {'nom_sg': 'δείλι', 'nom_pl': '', 'gen_sg': '', 'gender': 'neut'},
                  'Πάσχα': {'nom_sg': 'Πάσχα', 'nom_pl': '', 'gen_sg': '', 'gender': 'neut'},
                  'δόρυ': {'nom_sg': 'δόρυ', 'nom_pl': 'δόρατα', 'gen_sg': 'δόρατος', 'gender': 'neut'},
                  'ήμισυ': {'nom_sg': 'ήμισυ', 'nom_pl': '', 'gen_sg': 'ημίσεος', 'gender': 'neut'},
                  'γης': {'nom_sg': 'γης', 'nom_pl': 'γαίες', 'gen_sg': 'γης', 'gender': 'fem'},
                  'γη': {'nom_sg': 'γη', 'nom_pl': 'γαίες', 'gen_sg': 'γης', 'gender': 'fem'}
                   }

diploklita = {'βράχος': 'βράχοι,βράχια', 'λαιμός': 'λαιμοί,λαιμά',
              'λόγος': 'λόγοι,λόγια', 'πλούτος': ',πλούτη',
              'σανός': ',σανά', 'χρόνος': 'χρόνοι,χρόνια',
              'καπνός': 'καπνοί,καπνά', 'νιότη': ',νιάτα'}

aklita_num_alternatives = {'εφτά': 'επτά', 'οχτώ': 'οκτώ', 'εννιά': 'εννέα', 'δεκαέξι': 'δεκάξι',
                                     'δεκαοχτώ': 'δεκαοκτώ', 'δεκαεννιά': 'δεκαεννέα', 'δεκαεφτά': 'δεκαεπτά'}






EGO_STRONG = {
    'sg':
        {ND: {
            NOM: 'εγώ',
            GEN: 'εμένα',
            ACC: 'εμένα,μένα',
            }
        },
    'pl':
        {ND: {
            NOM: 'εμείς',
            GEN: 'εμάς,ημών',
            ACC: 'εμάς,μας',
            }
        }
}

EGO_WEAK = {

    'sg': {
        ND: {
            NOM: '',
            GEN: 'μου',
            ACC: 'με',
            }},
    'pl': {
        ND: {
            NOM: '',
            GEN: 'μας',
            ACC: 'μας',
            }
        }


}

ESU_STRONG = {

    'sg': {
        ND: {
        NOM: 'εσύ',
        GEN: 'εσένα',
        ACC: 'εσένα,σένα',
    }},
    'pl':
        {ND: {
        NOM: 'εσείς',
        GEN: 'εσάς,υμών',
        ACC: 'εσάς',
    }
    }
}

ESU_WEAK = {

    'sg': {  ND: {
        NOM: '',
        GEN: 'σου',
        ACC: 'σε',
    }},
    'pl': {ND: {
        NOM: '',
        GEN: 'σας',
        ACC: 'σας',
    }
    }
}

AUTOS_STRONG = {

        'sg': {
            MASC: {
                NOM: 'αυτός',
                GEN: 'αυτού',
                ACC: 'αυτόν,αυτό',
                },
            FEM: {
                NOM: 'αυτή',
                GEN: 'αυτής',
                ACC: 'αυτήν,αυτή',
                },
            NEUT: {
                NOM: 'αυτό',
                GEN: 'αυτού',
                ACC: 'αυτό',
                }},
        'pl': {MASC: {
                NOM: 'αυτοί',
                GEN: 'αυτών',
                ACC: 'αυτούς',
                    },
                FEM: {
                    NOM: 'αυτές',
                    GEN: 'αυτών',
                    ACC: 'αυτές,αυτάς',
                    },
                NEUT: {
                    NOM: 'αυτά',
                    GEN: 'αυτών',
                    ACC: 'αυτά',
                    }
        }
        }

AUTOS_WEAK = {
    'sg': {
        MASC: {
            NOM: 'τος',
            GEN: 'του',
            ACC: 'τον',
        },
        FEM: {
            NOM: 'τη',
            GEN: 'της',
            ACC: 'την,τη',
        },
        NEUT: {
            NOM: 'το',
            GEN: 'του',
            ACC: 'το',
        }},
    'pl': {MASC: {
        NOM: 'τοι',
        GEN: 'τους',
        ACC: 'τους',
    },
        FEM: {
            NOM: 'τες',
            GEN: 'τους',
            ACC: 'τες,τις',
        },
        NEUT: {
            NOM: 'τα',
            GEN: 'τους',
            ACC: 'τα',
        }
    }
}


TIS = {

        'sg': {
            MASC: {
                NOM: 'τις',
                GEN: 'τίνος',
                ACC: 'τίνα',
            },
            FEM: {
                NOM: 'τις',
                GEN: 'τίνος',
                ACC: 'τίνα',
            },
            NEUT: {
                NOM: 'τι',
                GEN: 'τίνος',
                ACC: 'τι',
            }},
        'pl': {
            MASC: {
                NOM: 'τίνες',
                GEN: 'τίνων',
                ACC: 'τίνας',
            },
            FEM: {
                NOM: 'τίνες',
                GEN: 'τίνων',
                ACC: 'τίνας'
            },
            NEUT: {
                NOM: 'τίνα',
                GEN: 'τίνων',
                ACC: 'τίνα'
            }
        }
        }


OSTIS = {

        'sg': {
            MASC: {
                NOM: 'όστις',
                GEN: 'ούτινος,ότου',
                ACC: 'όντινα',
            },
            FEM: {
                NOM: 'ήτις',
                GEN: 'ήστινος',
                ACC: 'ήντίνα',
            },
            NEUT: {
                NOM: 'ότι',
                GEN: 'ούτινος,ότου',
                ACC: 'ότι',
            }},
        'pl': {
            MASC: {
                NOM: 'οίτινες',
                GEN: 'ώντινων',
                ACC: 'ούστινας',
            },
            FEM: {
                NOM: 'αίτινες',
                GEN: 'ώντινων',
                ACC: 'άστινας'
            },
            NEUT: {
                NOM: 'άτινα,άττα',
                GEN: 'ώντινων',
                ACC: 'άτινα,άττα'
            }
        }
        }

OSPER = {
        'sg': {
            MASC: {
                NOM: 'όσπερ',
                GEN: 'ούπερ',
                ACC: 'όνπερ',
            },
            FEM: {
                NOM: 'ήπερ',
                GEN: 'ήσπερ',
                ACC: 'ήνπερ',
            },
            NEUT: {
                NOM: 'όπερ',
                GEN: 'ούπερ',
                ACC: 'όπερ',
            }},
        'pl': {
            MASC: {
                NOM: 'οίπερ',
                GEN: 'ώνπερ',
                ACC: 'ούσπερ',
            },
            FEM: {
                NOM: 'αίπερ',
                GEN: 'ώνπερ',
                ACC: 'άσπερ'
            },
            NEUT: {
                NOM: 'άπερ',
                GEN: 'ώνπερ',
                ACC: 'άπερ'
            }
        }
        }


EAUTO = {
    'sg': {'gen': 'εαυτού',
           'acc': 'εαυτόν'},
    'pl': {
     'gen': 'εαυτών',
     'acc': 'εαυτούς'
    }
}


irregular_active_roots = \
    [['ανεβαίν', 'ανέβ,ανεβ'], ['κατεβαίν', 'κατέβ,κατεβ'], ['βάλλ', 'βάλ'], ['λαμβάν', 'λάβ'], ['βάζ', 'βάσ'], ['βάζ', 'βάλ'], ['βγάζ', 'βγάλ'], ['λαβαίν', 'λάβ'], ['αγγέλν','αγγείλ'], ['αγγέλλ', 'αγγείλ'], ['στάν', 'στήσ'], ['σταίν', 'στήσ'], ['πίπτ', 'πέσ'], ['φέρν', 'φέρ'], ['φεύγ','φύγ'], ['άγ', 'αγάγ'], ['γέρν', 'γεράσ'], ['πάσχ', 'πάθ'], ['σέρν', 'σύρ'], ['τέμν', 'τμήσ'], ['εφιστ', 'επιστήσ'], ['καθιστ', 'καταστήσ'], ['λανθάν', 'λάθ'], ['λαγχάνω', 'λάχ'], ['λαχαίν', 'λάχ'], ['αίρν', 'άρ'], ['αίρ', 'άρ'], ['δίν', 'δώσ'], ['δίδ', 'δώσ'], ['μέν', 'μείν'], ['στέλν', 'στείλ'], ['στέλλ', 'στείλ'], ['πλέν', 'πλύν'], ['βαίν', 'β'], ['βγαίν', 'βγ'], ['αυξάν', 'αυξήσ'], ['μεθ', 'μεθύσ'], ['σπέρν', 'σπείρ'], ['αλίσκ', 'αλώσ'], ['μπαίν', 'μπ'], ['μην', 'μηνύσ'], ['πλέ', 'πλεύσ'], ['πνέ', 'πνεύσ'], ['ρέ', 'ρεύσ'], ['βρίσκ', 'βρ'], ['πίν', 'πι'], ['τρώ', 'φά'], ['λέ', 'π'], ['λέγ', 'π,λέξ'], ['τρώγ', 'φάγ'], ['δέρν', 'δείρ'], ['κλίν', 'κλίν'], ['κάν', 'κάν'], ['μαθαίν', 'μάθ'], ['παθαίν', 'πάθ'],  ['πεθαίν', 'πεθάν'], ['βλέπ', 'δ,ιδ'], ['θνήσκ', 'θάν'], ['τείν', 'τείν'], ['πέφτ', 'πέσ'], ['πέπτ', 'πέσ'], ['πηγαίν', 'πά'], ['τυχαίν', 'τύχ'], ['πετυχαίν', 'πετύχ'], ['τυγχάν', 'τύχ'], ['άσχ', 'ασχέσ'], ['τρέφ', 'θρέψ'], ['ελαύν', 'ελάσ'], ['κρέμ', 'κρεμάσ'], ['ευρίσκ', 'εύρ'], ['έχ', 'άσχ'], ['έλκ', 'έλκυσ'], ['θαρρ', 'θαρρέψ'], ['χέ', 'χύσ'], ['νιστ', 'στήσ'], ['ιστάν', 'αστήσ'], ['δεικνύ', 'δείξ'], ['μειγνύ', 'μείξ'], ['ρηγνύ', 'ρήξ'], ['γιγνώσκ', 'γνώσ'], ['πηγνύ', 'πήξ'], ['τρώ', 'φά,φάγ'], ['τρώγ', 'φά,φάγ']]

irregular_passive_roots = \
    [['βάλλ', 'βληθ'], ['βάζ', 'βαλθ'], ['βγάζ', 'βγαλθ'], ['λαμβάν', 'ληφθ'], ['λαβαίν', 'ληφθ'], ['ρήγνυ', 'ραγ,ρηχθ'], ['ρηγνύ', 'ραγ,ρηχθ'], ['αίρν', 'αρθ'], ['γράφ', 'γραφ,γραφτ'], ['αίρ', 'αρθ'], ['δέρν', 'δαρθ'], ['άσχ', 'ασχεθ'], ['καλ', 'κληθ'], ['εύχ', 'ευχηθ'], ['δίν', 'δοθ'], ['δίδ', 'δοθ'],['υπόσχ', 'υποσχεθ'], ['κόπτ', 'κοπ'], ['κόβ', 'κοπ'], ['ακού', 'ακουστ'], ['στέλν', 'σταλθ,σταλ'], ['στέλλ', 'σταλθ,σταλ'], ['πλέν', 'πλυθ'], ['έρχ', 'έλθ,έρθ,`ρθ,`λθ'], ['κάθ', 'καθίσ,κάτσ'], ['γίν', 'γίν'], ['καί', 'κα'], ['στέκ', 'σταθ'], ['στήν', 'σταθ'], ['οφείλ', 'οφεληθ'], ['πνίγ', 'πνιγ,πνιχτ'], ['θέτ', 'τεθ'], ['βλέπ','ιδωθ'], ['λέγ', 'ειπωθ,ιπωθ,λεγ'], ['τείν', 'ταθ'], ['φαίν', 'φαν'], ['σέρν', 'συρθ'], ['αυξάν', 'αυξηθ'], ['σπέρν', 'σπαρθ'], ['αλίσκ', 'αλωθ'], ['τρέφ', 'τραφ'], ['τέμν', 'τμηθ'], ['κρέμ', 'κρεμαστ'], ['βρίσκ', 'βρεθ'], ['τρώ', 'φαγωθ'], ['λέ', 'ειπωθ'], ['τρώγ', 'φαγωθ'], ['αφήν', 'αφεθ'], ['τρέπ', 'τραπ'], ['στρέφ', 'στραφ'], ['τίθε', 'τεθ'], ['προτίθε', 'προτεθ'], ['σέβ', 'σεβαστ'], ['χαίρ', 'χαρ'], ['λέγ', 'λεγ'], ['επαφίε', 'επαφεθ'], ['ρήγνυ', 'ραγ'], ['ίστ', 'αστ'], ['θίστ', 'ταστ'], ['έλκ', 'ελκυστ'], ['χέ', 'χυσθ'], ['νιστ', 'σταθ'], ['ελαύν', 'ελαθ'], ['ιστάν', 'ασταθ'], ['δεικνύ', 'δειχθ'], ['δείκνυ', 'δειχθ'], ['μειγνύ', 'μειχθ'], ['γιγνώσκ', 'γνωσθ'], ['πηγνύ', 'παγ'], ['ενδείκνυ', 'ενδειχθ'], ['ευρίσκ', 'ευρεθ'], ['τρώ', 'φαγωθ'], ['τρώγ', 'φαγωθ']]


irregular_passive_perfect_participles = {'αγανακτώ': 'αγανακτισμένος', 'αποτυχαίνω': 'αποτυχημένος', 'αγαπάω': 'αγαπημένος', 'αγωνίζομαι': 'αγωνισμένος', 'δυστυχώ': 'δυστυχισμένος', 'ευτυχώ': 'ευτυχισμένος', 'θυμώνω': 'θυμωμένος', 'αγοράζω': 'αγορασμένος', 'αφαιρώ': 'αφηρημένος', 'αισθάνομαι': 'αισθαμένος', 'ακολουθώ': 'ακολουθημένος', 'ακούω': 'ακουσμένος', 'αλλάζω': 'αλλαγμένος', 'ανάβω': 'αναμμένος', 'αναγκάζω': 'αναγκασμένος', 'ανήκω': None, 'δίνω': 'δοσμένος', 'κάθομαι': 'καθισμένος', 'καίω': 'καμένος', 'κλαίω': 'κλαμένος', 'προβάλλω': 'προβεβλημένος,προβλημένος', 'τρώω': 'φαγωμένος', 'στρέφω': 'στραμμένος', 'ανοίγω': 'ανοιγμένος',  'αξίζω': None, 'απαγορεύω': 'απαγορευμένος', 'απαντάω': 'απαντημένος', 'αποκτώ': 'αποκτημένος', 'απορώ': None, 'αποτελούμαι': 'αποτελεσμένος', 'αποφασίζω': 'αποφασισμένος', 'αργώ': None, 'αρέσω': None, 'βρέχω': 'βρεγμένος', 'αρχίζω': None, 'αστειεύομαι': None, 'αφήνω': 'αφημένος', 'βάζω': 'βαλμένος', 'βάφω': 'βαμμένος', 'βαριέμαι': 'βαρεμένος', 'βγάζω': 'βγαλμένος', 'βγαίνω': None, 'βιάζομαι': 'βιασμένος', 'βλέπω': 'ιδωμένος', 'βοηθάω': 'βοηθημένος', 'βρίσκω': None, 'βράζω': 'βρασμένος', 'γδύνω': 'γδυμένος', 'γελάω': 'γελασμένος', 'γεμίζω': 'γεμισμένος', 'γεννάω': 'γεννημένος', 'γίνομαι': 'γινωμένος', 'γκρινιάζω': None, 'γράφω': 'γραμμένος', 'γυρίζω': 'γυρισμένος', 'δανείζω': 'δανεισμένος', 'δείχνω': 'δειγμένος', 'δένω': 'δεμένος', 'δέχομαι': 'δεχτός, δεκτός', 'διαβάζω': 'διαβασμένος', 'διαλέγω': 'διαλεγμένος', 'διαμαρτύρομαι': 'διαμαρτυρημένος', 'διαφωνώ': None, 'διηγούμαι': 'διηγημένος', 'διορθώνω': 'διορθωμένος', 'διψάω': 'διψασμένος', 'διώχνω': 'διωγμένος', 'δοκιμάζω': 'δοκιμασμένος', 'δουλεύω': None, 'είμαι': None, 'εκφράζω': 'εκφρασμένος', 'ελπίζω': None, 'εμφανίζομαι': 'εμφανισμένος', 'ενδιαφέρομαι': None, 'εξηγώ': 'εξηγημένος', 'εξαφανίζομαι': 'εξαφανισμένος', 'επηρεάζω': 'επηρεασμένος', 'επιτρέπω': 'επιτετραμμένος', 'έρχομαι': None, 'ετοιμάζω': 'ετοιμασμένος', 'εύχομαι': None, 'έχω': None, 'ζεσταίνω': 'ζεσταμένος', 'ζηλεύω': 'ζηλεμένος', 'ζητάω': 'ζητημένος', 'ζω': 'βιωμένος', 'θέλω': None, 'θυμάμαι': 'θυμημένος', 'καθαρίζω': 'καθαρισμένος', 'καλώ': 'καλεσμένος', 'καπνίζω': None, 'καταλαβαίνω': None, 'καταστρέφω': 'κατεστραμμένος', 'κατεβάζω': 'κατεβασμένος', 'κατεβαίνω': None, 'κερνάω': 'κερασμένος', 'κλείνω': 'κλεισμένος', 'κόβω': 'κομμένος', 'κοιμάμαι': 'κοιμισμένος', 'κοιτάζω': 'κοιταγμένος', 'κουράζω': 'κουρασμένος', 'κρατάω': 'κρατημένος', 'κρύβω': 'κρυμμένος', 'λέω': 'ειπωμένος', 'λείπω': None, 'λύνω': 'λυμένος', 'λυπάμαι': 'λυπημένος', 'μαγειρεύω': 'μαγειρεμένος', 'μαζεύω': 'μαζεμένος', 'μαθαίνω': 'μαθημένος', 'μιμούμαι': None, 'μένω': None, 'μοιάζω': None, 'μοιράζω': 'μοιρασμένος', 'μπαίνω': None, 'μπορώ': None, 'νικάω': 'νικημένος', 'νοιάζομαι': 'νοιασμένος', 'νομίζω': None, 'ντρέπομαι': None, 'ντύνω': 'ντυμένος', 'ξαπλώνω': 'ξαπλωμένος', 'ξεκινάω': 'ξεκινημένος', 'ξέρω': None, 'ξεχνάω': 'ξεχασμένος', 'ξυπνάω': 'ξυπνημένος', 'ξυρίζω': 'ξυρισμένος', 'οδηγώ': 'οδηγημένος', 'ονειρεύομαι': 'ονειρεμένος', 'ονομάζω': 'ονομασμένος', 'οφείλω': None, 'παθαίνω': 'πεθαμένος', 'παίζω': None, 'παίρνω': 'παρμένος', 'παντρεύομαι': 'παντρεμένος', 'παραγγέλνω': None, 'παραπονιέμαι': 'παραπονεμένος', 'παριστάνω': None, 'πεθαίνω': 'παθημένος', 'πείθω': 'πεπεισμένος', 'πεινάω': 'πεινασμένος', 'περιμένω': None, 'περνάω': 'περασμένος', 'περπατάω': 'περπατημένος', 'πετυχαίνω': 'πετυχημένος', 'πετάω': 'πεταγμένος', 'πέφτω': 'πεσμένος', 'πηγαίνω': None, 'πιάνω': 'πιασμένος', 'πιέζω': 'πιεσμένος', 'πίνω': 'πιωμένος', 'πιστεύω': None, 'πλένω': 'πλυμένος', 'πληρώνω': 'πληρωμένος', 'πονάω': 'πονεμένος', 'πουλάω': 'πουλημένος', 'πρέπει': None, 'πρόκειται': None, 'προκύπτω': None, 'προσθέτω': 'προστεθειμένος', 'προσέχω': None, 'προσποιούμαι': 'προσποιημένος', 'προτείνω': 'προτεταμένος', 'προτιμάω': 'προτιμημένος', 'ράβω': 'ραμμένος', 'ρίχνω': 'ριγμένος', 'ρωτάω': 'ρωτημένος', 'σβήνω': 'σβησμένος', 'σέβομαι': 'σεβασμένος', 'σηκώνω': 'σηκωμένος', 'σημαίνω': None, 'σκεπάζω': 'σκεπασμένος', 'σκέφτομαι': None, 'σκοτώνω': 'σκοτωμένος', 'σκουπίζω': 'σκουπισμένος', 'σπουδάζω': 'σπουδασμένος', 'στέλνω': 'σταλμένος', 'στενοχωριέμαι': 'στενοχωρημένος', 'συμμετέχω': None, 'συμπεριφέρομαι': None, 'συμφωνώ': 'συμφωνημένος', 'στηρίζω': 'στηριγμένος', 'συνηθίζω': 'συνηθισμένος', 'συστήνω': 'συστημένος', 'σώζω': 'σωσμένος', 'ταξιδεύω': None, 'τρελαίνομαι': 'τρελαμένος', 'τρέχω': None, 'υπάρχω': None, 'υποπτεύομαι': None, 'υπόσχομαι': 'υποσχεμένος', 'υποφέρω': 'υποσχεμένος', 'υποψιάζομαι': 'υποψιασμένος', 'φαίνομαι': None, 'φαντάζομαι': 'φαντασμένος', 'φέρνω': 'φερμένος', 'φεύγω': None, 'φοβάμαι': None, 'φοράω': 'φορεμένος', 'φταίω': 'φοβημένος', 'φτάνω': None, 'φτιάχνω': 'φτιαγμένος', 'φωνάζω': None, 'χαίρομαι': 'χαρούμενος', 'χαλάω': None, 'χάνω': 'χαμένος', 'χρειάζομαι': None, 'χρησιμοποιώ': 'χρησιμοποιημένος', 'χρωστάω': None, 'χτυπάω': 'χτυπημένος', 'χωράω': None, 'ψάχνω': 'ψαγμένος', 'ωφελώ': 'ωφελημένος'}


irregular_active_aorists = {'βαίνω': 'βηκα', 'μπαίνω': 'μπήκα', 'βγαίνω': 'βγήκα', 'βρίσκω': 'βρήκα', 'πηγαίνω': 'πήγα', 'παίρνω': 'πήρα', 'λέω': 'είπα', 'λέγω': 'είπα', 'πίνω': 'ήπια', 'τρώω': 'έφαγα', 'τρώγω': 'έφαγα', 'βλέπω': 'είδα'}

irregular_passive_aorists = {'λέω': 'ειπώθηκα', 'λέγω': 'ειπώθηκα', 'βλέπω': 'ειδώθηκα'}


deponens_with_active_perf_forms = ['έρχομαι', 'κάθομαι', 'γίνομαι']


irregular_imperative_forms = {
    'σηκωθ': {'sg': {'sec': 'σήκω'}},
    'ακού': {'sg': {'sec': 'άκου'}},
    'ακούσ': {'sg': {'sec': 'άκου'}},
    'ανεβ': {'sg': {'sec': 'ανέβα'}},
    'κατεβ': {'sg': {'sec': 'κατέβα'}},
    "φύγ": {'sg': {'sec': 'φεύγα'}, 'pl': {'sec': 'φευγάτε'}},
    "τρέξ": {'sg': {'sec': 'τρέχα'}, 'pl': {'sed': 'τρεχάτε'}},
    "πλύν": {'pl': {'sec': 'πλύντε'}},
    "πά": {'sg': {'sec': 'πήγαινε'}, 'pl': {'sec': 'πηγαίνετε'}},
    "έρθ": {'sg': {'sec': 'έλα'}, 'pl': {'sec': 'ελάτε'}},
    "έλθ": {'sg': {'sec': 'έλα'}, 'pl': {'sec': 'ελάτε'}},
}


conjugations = {
'eimai': {'sg': {'pri': ['είμαι'], 'sec': ['είσαι'], 'ter': ['είναι']}, 'pl': {'pri': ['είμαστε'], 'sec': ['είστε', 'είσαστε'], 'ter': ['είναι']}},
'eimai_paratatikos':  {'sg': {'pri': ['ήμουν', 'ήμουνα'], 'sec': ['ησουν', 'ήσουνα'], 'ter': ['ήταν', 'ήτανε']}, 'pl': {'pri': ['ήμαστε', 'ήμασταν'], 'sec': ['ήσαστε', 'ήσασταν'], 'ter': ['ήταν', 'ήτανε']}},
'con1_act': {'sg': {'pri': ['ω'], 'sec': ['εις'], 'ter': ['ει']}, 'pl': {'pri': ['ουμε'], 'sec': ['ετε'], 'ter': ['ουν', 'ουνε']}},
'con2a_act': {'sg': {'pri': ['ώ', 'άω'], 'sec': ['άς'], 'ter': ['ά', 'άει']}, 'pl': {'pri': ['ούμε', 'άμε'], 'sec': ['άτε'], 'ter': ['άνε', 'άν', 'ούν', 'ούνε']}},
'con2b_act': {'sg': {'pri': ['ώ'], 'sec': ['είς'], 'ter': ['εί']}, 'pl': {'pri': ['ούμε'], 'sec': ['είτε'], 'ter': ['ούνε', 'ούν']}},
'con2c_act': {'sg': {'pri': ['ω'], 'sec': ['ς'], 'ter': ['ει']}, 'pl': {'pri': ['με'], 'sec': ['τε'], 'ter': ['νε', 'ν']}},
'con2d_act': {'sg': {'pri': ['ώ'], 'sec': ['οίς'], 'ter': ['οί']}, 'pl': {'pri': ['ούμε', 'ούμεν'], 'sec': ['οίτε', 'ούτε'], 'ter': ['ούνε', 'ούν']}},
'con1_act_modal': {'sg': {'ter': ['ει']}},
'con2_act_modal': {'sg': {'ter': ['εί']}},

'con1_pass': {'sg': {'pri': ['ομαι'], 'sec': ['εσαι'], 'ter': ['εται']}, 'pl': {'pri': ['όμαστε'], 'sec': ['εστε', 'όσαστε'], 'ter': ['ονται']}},
'con2a_pass': {'sg': {'pri': ['ιέμαι'], 'sec': ['ιέσαι'], 'ter': ['ιέται']}, 'pl': {'pri': ['ιόμαστε', 'ιούμαστε'], 'sec': ['ιέστε', 'ιόσαστε'], 'ter': ['ιούνται', 'ιόνται']}},
'con2ab_pass': {'sg': {'pri': ['ώμαι'], 'sec': ['άσαι'], 'ter': ['άται']}, 'pl': {'pri': ['όμαστε'], 'sec': ['άστε'],
                                                                                  'ter': ['ώνται']}},

'con2b_pass': {'sg': {'pri': ['ούμαι'], 'sec': ['είσαι'], 'ter': ['είται']}, 'pl': {'pri': ['ούμαστε', 'ούμεθα'], 'sec': ['είστε', 'είσθε'], 'ter': ['ούνται']}},
'con2c_pass': {'sg': {'pri': ['άμαι'], 'sec': ['άσαι'], 'ter': ['άται']}, 'pl': {'pri': ['όμαστε'], 'sec': ['άστε', 'όσαστε'], 'ter': ['ούνται']}},
'con2sa_pass': {'sg': {'pri': ['ούμαι'], 'sec': ['ούσαι'], 'ter': ['ούται']}, 'pl': {'pri': ['ούμεθα'], 'sec': ['ούσθε'],
                                                                                 'ter': ['ούνται']}},
'con2d_pass': {'sg': {'pri': ['μαι'], 'sec': ['σαι'], 'ter': ['ται']}, 'pl': {'pri': ['μεθα'], 'sec': ['στε'],
                                                                                 'ter': ['νται']}},
'con2e_pass': {'sg': {'pri': ['αμαι'], 'sec': ['ασαι'], 'ter': ['αται']}, 'pl': {'pri': ['άμεθα', 'όμαστε'],
                                                                                 'sec': ['ασθε', 'άστε'],
                                                                                 'ter': ['ανται']}},

'aor_act': {'sg': {'pri': ['α'], 'sec': ['ες'], 'ter': ['ε']}, 'pl': {'pri': ['αμε'], 'sec': ['ατε'], 'ter': ['αν', 'ανε']}},
'arch_pass_aor' :{'sg': {'pri': ['ην'], 'sec': ['ης'], 'ter': ['η']}, 'pl': {'pri': ['ημεν'], 'sec': ['ητε'], 'ter': ['ησαν']}},
'parat2_act': {'sg': {'pri': ['α'], 'sec': ['ες'], 'ter': ['ε']}, 'pl': {'pri': ['αμε'], 'sec': ['ατε'], 'ter': ['αν', 'ανε']}},
'parat_act_modal': {'sg':{'ter': ['ε']}},
'parat1_pass': {'sg': {'pri': ['όμουν', 'όμουνα'], 'sec': ['όσουν', 'όσουνα'], 'ter': ['όταν', 'ότανε']}, 'pl': {'pri': ['όμασταν', 'όμαστε'], 'sec': ['όσασταν', 'όσαστε'], 'ter': ['ονταν', 'όντουσαν']}},
'parat2a_pass': {'sg': {'pri': ['ιόμουν', 'ιόμουνα'], 'sec': ['ιόσουν', 'ιόσουνα'], 'ter': ['ιόταν', 'ιότανε']}, 'pl': {'pri': ['ιόμασταν', 'ιόμαστε'], 'sec': ['ιόσασταν', 'ιόσαστε'], 'ter': ['ιούνταν', 'ιόνταν', 'ιόντουσαν']}},
'parat2b_pass': {'sg': {'pri': ['ούμουν'], 'sec': ['ούσουν'], 'ter': ['είτο', 'ούνταν', 'ούντανε']}, 'pl': {'pri': ['ούμασταν', 'ούμαστε'], 'sec': ['ούσασταν', 'ούσαστε'], 'ter': ['ούνταν', 'ούντο', 'ούντανε']}},
'parat2b_pass_logia' : {'sg': {'pri': ['ούμην'], 'sec': ['είσο'], 'ter': ['είτο']}, 'pl': {'pri': ['ούμεθα'], 'sec': ['είσθε'], 'ter': ['ούντο']}},
'parat2c_pass': {'sg': {'pri': ['όμουν', 'όμουνα'], 'sec': ['όσουν', 'όσουνα'], 'ter': ['όταν', 'ότανε']}, 'pl': {'pri': ['όμασταν', 'όμαστε'], 'sec': ['όσασταν', 'όσαστε'], 'ter': ['ούνταν', 'όντουσαν']}},
'parat2d_pass': {'sg': {'pri': ['όμουν', 'έμην'], 'sec': ['όσουν', 'εσο'], 'ter': ['όταν', 'ετο']},
                 'pl': {'pri': ['όμασταν', 'έμεθα'], 'sec': ['όσασταν', 'εσθε'], 'ter': ['ούνταν', 'εντο']}},
'parat2e_pass': {'sg': {'pri': ['άμην'], 'sec': ['ασο'], 'ter': ['ατο']}, 'pl': {'pri': ['άμεθα', 'όμαστε', 'όμασταν'],
                                                                                 'sec': ['ασθε', 'άστε', 'όσασταν',
                                                                                         'όσαστε'],
                                                                                 'ter': ['αντο']}},

'imper_act_cont_1': {'sg': {'sec': ['ε']}, 'pl':{ 'sec':['ετε'] }},
'imper_act_eimai': {'sg': {'ter': ['έστω']}},
'imper_act_cont_2a': {'sg': {'sec': ['α', 'αγε']}, 'pl':{ 'sec':['άτε'] }},
'imper_act_cont_2b': {'sg': {'sec': ['ει']}, 'pl':{ 'sec':['είτε'] }},
'imper_act_cont_2d': {'sg': {'sec': ['ου']}, 'pl': {'sec':['ούτε', 'οίτε']}},
'imper_act_cont_2c': {'sg': {'sec': ['γε']}, 'pl':{ 'sec':['γετε', 'τε']}},
'imper_pass_cont_2d': {'sg': {'sec': ['σο']}, 'pl': {'sec': ['σθε']}},
'imper_pass_cont_2e': {'sg': {'sec': ['σο']}, 'pl': {'sec': ['σθε']}},
'imper_pass_cont_1': {'pl':{ 'sec': ['εστε']}},
'imper_pass_cont_2a': {'pl':{ 'sec': ['ιέστε']}},
'imper_pass_cont_2b': {'pl':{ 'sec': ['είστε']}},
'imper_pass_cont_2c': {'pl':{ 'sec': ['άστε']}},

'imper_act_aor_a': {'sg': {'sec': ['ε']}, 'pl': {'sec':['τε']}},
'imper_act_aor_b': {'sg': {'sec': ['ε']}, 'pl': { 'sec':['ετε'] }},
'imper_act_aor_c': {'sg': {'sec': ['ες']}, 'pl': {'sec':['έστε', 'είτε']}},
'imper_act_aor_ca':{'sg': {'sec': ['α']}, 'pl': {'sec':['είτε']}},
'imper_pass_aor_a': {'sg': {'sec': ['ου']}, 'pl':{ 'sec':['είτε']}},
'imper_pass_aor_b': { 'pl':{ 'sec':['είτε']} },
'present_active_part_1': {'nd': {'nd': ['οντας']}},
'present_active_eimai': {'nd': {'nd': ['όντας']}},
'present_active_part_2c': {'nd': {'nd': ['γοντας']}},
'present_active_part_2': {'nd': {'nd': ['ώντας']}},
'present_passive_part_1': {'sg': {'nd': ['όμενος']}},
'present_passive_part_2a': {'sg': {'nd': ['ώμενος']}},
'present_passive_part_2ab': {'sg': {'nd': ['ώμενος']}},
'present_passive_part_2b': {'sg': {'nd': ['ούμενος']}},
'present_passive_part_2d': {'sg': {'nd': ['έμενος']}},
'present_passive_part_2e': {'sg': {'nd': ['μενος']}},
'past_passive_part': {'sg': {'nd': ['μένος']}},
'modal': None
}

"""UNUSED"""

greek_pers_pronouns = [

    ['εγώ', ['εγώ', 'ppron12:sg:nom:m.f.n:pri:akc']],
    ['μου', ['εγώ', 'ppron12:sg:gen:m.f.n:pri:nakc:npraep']],
    ['εμένα', ['εγώ', 'ppron12:sg:gen.acc:m.f.n:pri:akc:npraep']],
    ['μένα', ['εγώ', 'ppron12:sg:acc:m.f.n:pri:akc:praep']],
    ['με', ['εγώ', 'ppron12:sg:acc:m.f.n:pri:nakc:npraep']],
    ['εμείς', ['εμείς', 'ppron12:pl:nom:m.f.n:pri:akc']],
    ['εμάς', ['εμείς', 'ppron12:pl:gen.acc:m.f.n:pri:akc:npraep']],
    ['μας', ['εμείς', 'ppron12:pl:gen.acc:m.f.n:pri:akc:praep']],
    ['μας', ['εμείς', 'ppron12:pl:gen.acc:m.f.n:pri:nakc:npraep']],

    ['εσύ', ['εσύ', 'ppron12:sg:nom:m.f.n:sec:akc']],
    ['σου', ['εσύ', 'ppron12:sg:gen:m.f.n:sec:nakc:npraep']],
    ['εσένα', ['εσύ', 'ppron12:sg:gen.acc:m.f.n:sec:akc:npraep']],
    ['σένα', ['εσύ', 'ppron12:sg:acc:m.f.n:sec:akc:praep']],
    ['σε', ['εσύ', 'ppron12:sg:acc:m.f.n:sec:nakc:npraep']],

    ['εσείς', ['εσείς', 'ppron12:pl:nom:m.f.n:sec:akc']],
    ['εσάς', ['εσείς', 'ppron12:pl:gen.acc:m.f.n:sec:akc:npraep']],

    ['σας', ['εσείς', 'ppron12:pl:acc:m.f.n:sec:akc:praep']],

    ['σας', ['εσείς', 'ppron12:pl:gen.acc:m.f.n:sec:nakc:npraep']],

    # nom
    ['αυτός', ['αυτός', 'ppron3:sg:nom:m:ter:akc']],
    ['τoς', ['αυτός', 'ppron3:sg:nom:m:ter:nakc']],
    ['το', ['αυτός', 'ppron3:sg:nom.acc:n:ter:nakc:npraep']],
    ['αυτό', ['αυτός', 'ppron3:sg:nom.acc:n:ter:akc']],
    ['αυτή', ['αυτός', 'ppron3:sg:nom.acc:f:ter:akc']],
    ['τή', ['αυτός', 'ppron3:sg:nom.acc:f:ter:nakc']],
    # gen
    ['αυτού', ['αυτός', 'ppron3:pl:gen:n.m:ter:akc:praep:npraep']],
    ['του', ['αυτός', 'ppron3:sg:gen:n.m:ter:nakc:npraep']],

    ['αυτής', ['αυτός', 'ppron3:sg:gen:f:ter:akc']],
    ['της', ['αυτός', 'ppron3:sg:gen:f:ter:nakc:npraep']],
    # acc
    ['αυτόν', ['αυτός', 'ppron3:sg:acc:m:ter:akc:npraep:praep']],
    ['αυτήν', ['αυτός', 'ppron3:sg:acc:f:ter:akc']],
    ['τήν', ['αυτός', 'ppron3:sg:acc:f:ter:nakc:npraep']],
    ['τον', ['αυτός', 'ppron3:sg:gen:n:ter:nakc:npraep']],

    # nom
    ['αυτοί', ['αυτός', 'ppron3:pl:nom:m:ter:akc']],
    ['αυτές', ['αυτός', 'ppron3:pl:nom.acc:f:ter:akc']],
    ['τοι', ['αυτός', 'ppron3:pl:nom:m:ter:nakc']],
    ['τες', ['αυτός', 'ppron3:pl:nom:f:ter:nakc']],
    ['τα', ['αυτός', 'ppron3:pl:nom.acc:n:ter:nakc:npraep']],
    ['αυτά', ['αυτός', 'ppron3:pl:nom.acc:n:ter:akc']],

    # gen
    ['αυτών', ['αυτός', 'ppron3:pl:gen:m.f.n:ter:akc']],
    ['τους', ['αυτός', 'ppron3:pl:gen:m.f.n:ter:nakc:npraep']],

    # acc
    ['τους', ['αυτός', 'ppron3:pl:acc:m:ter:nakc:npraep']],
    ['αυτούς', ['αυτός', 'ppron3:pl:acc:m:ter:akc']],
    ['τις', ['αυτός', 'ppron3:pl:acc:f:ter:nakc:npraep']],
    ['τες', ['αυτός', 'ppron3:pl:acc:f:ter:nakc:npraep']],

]


quant = ['δύο,δυο', 'έξι', 'δέκα', 'ένας/μία/ένα', 'επτά,εφτά', 'οχτώ,οκτώ', 'δεκαεφτά,δεκαεπτά', 'δεκαοχτώ,δεκαοκτώ',
         'εκατόν,εκατό', 'εννέα,εννιά', 'μηδέν', 'πέντε',
         'τρεις/τρία', 'δεκάξι,δεκαέξι', 'δώδεκα', 'είκοσι', 'ένδεκα,έντεκα', 'εξήντα', 'ογδόντα', 'πενήντα',
         'σαράντα', 'τριάντα', 'ενάμισης/μιάμιση/ενάμισι', 'ενενήντα', 'τέσσερις/τέσσερα', 'δεκαεννέα,δεκαεννιά','δεκαπέντε',
         'δεκατρείς/δεκατρία', 'εβδομήντα', 'δεκατέσσερις/δεκατέσσερα']

quant_adj =['έκτος', 'διπλός', 'ένατος', 'όγδοος', 'πρώτος', 'πέμπτος', 'τρίτος', 'δέκατος', 'έβδομος', 'εξαπλός',
            'τριπλός', 'δεκαπλός', 'δεύτερος', 'εικοστός', 'επταπλός', 'τέταρτος', 'διπλάσιος', 'δωδέκατος',
            'εκατοστός', 'ενδέκατος', 'εξηκοστός', 'πενταπλός', 'τετραπλός', 'χιλιοστός', 'εξαπλάσιος', 'τριακοστός',
            'τριπλάσιος', 'δεκαπλάσιος', 'ενενηκοστός', 'επταπλάσιος', 'ογδοηκοστός', 'διακοσιοστός', 'εβδομηκοστός',
            'εξακοσιοστός', 'πενταπλάσιος', 'τετραπλάσιος', 'εικοσαπλάσιος', 'ενδεκαπλάσιος', 'τεσσαρακοστός',
            'τριακοσιοστός', 'τετρακοσιοστός', 'εκατομμυριοστός', 'εκατονταπλάσιος']

quant_noun = ['δυάδα', 'εξάδα', 'δεκάδα', 'οκτάδα', 'τριάδα', 'μυριάδα', 'πεντάδα', 'τετράδα', 'χιλιάδα',
              'δωδεκάδα', 'εικοσάδα', 'εικοσαριά', 'εκατοντάδα', 'εκατομμύριο', 'δισεκατομμύριο', 'τρισεκατομμύριο',
              'τετρακισεκατομμύριο', 'πεντακισεκατομμύριο', 'δυάδα', 'εξάδα', 'δεκάδα', 'οκτάδα', 'τριάδα', 'μυριάδα',
              'πεντάδα', 'τετράδα', 'χιλιάδα', 'δωδεκάδα', 'εικοσάδα', 'εικοσαριά', 'εκατοντάδα', 'δισεκατομμύριο',
              'εκατομμύριο', 'τρισεκατομμύριο']

hundreds = ['διακόσια', 'τριακόσια', 'τετρακόσια', 'πεντακόσια', 'εξακόσια', 'εφτακόσια,επτακόσια', 'οχτακόσια', 'εννιακόσια', 'χίλια']

alternative_syllables = {'οκτ': 'οχτ', 'επτ':'εφτ'}
