import { UserPoolDomain } from '@aws-cdk/aws-cognito';
import { AliasRecordTargetConfig, IAliasRecordTarget, IRecordSet } from '@aws-cdk/aws-route53';
/**
 * Use a user pool domain as an alias record target.
 *
 * @stability stable
 */
export declare class UserPoolDomainTarget implements IAliasRecordTarget {
    private readonly domain;
    /**
     * @stability stable
     */
    constructor(domain: UserPoolDomain);
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record: IRecordSet): AliasRecordTargetConfig;
}
