"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolDomainTarget = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudfront_target_1 = require("./cloudfront-target");
/**
 * Use a user pool domain as an alias record target.
 *
 * @stability stable
 */
class UserPoolDomainTarget {
    /**
     * @stability stable
     */
    constructor(domain) {
        this.domain = domain;
    }
    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     *
     * @stability stable
     */
    bind(_record) {
        return {
            dnsName: this.domain.cloudFrontDomainName,
            hostedZoneId: cloudfront_target_1.CloudFrontTarget.getHostedZoneId(this.domain),
        };
    }
}
exports.UserPoolDomainTarget = UserPoolDomainTarget;
_a = JSII_RTTI_SYMBOL_1;
UserPoolDomainTarget[_a] = { fqn: "@aws-cdk/aws-route53-targets.UserPoolDomainTarget", version: "1.102.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXNlcnBvb2wtZG9tYWluLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidXNlcnBvb2wtZG9tYWluLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBRUEsMkRBQXVEOzs7Ozs7QUFLdkQsTUFBYSxvQkFBb0I7Ozs7SUFDL0IsWUFBNkIsTUFBc0I7UUFBdEIsV0FBTSxHQUFOLE1BQU0sQ0FBZ0I7SUFDbkQsQ0FBQzs7Ozs7O0lBRU0sSUFBSSxDQUFDLE9BQW1CO1FBQzdCLE9BQU87WUFDTCxPQUFPLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxvQkFBb0I7WUFDekMsWUFBWSxFQUFFLG9DQUFnQixDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDO1NBQzVELENBQUM7SUFDSixDQUFDOztBQVRILG9EQVVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVXNlclBvb2xEb21haW4gfSBmcm9tICdAYXdzLWNkay9hd3MtY29nbml0byc7XG5pbXBvcnQgeyBBbGlhc1JlY29yZFRhcmdldENvbmZpZywgSUFsaWFzUmVjb3JkVGFyZ2V0LCBJUmVjb3JkU2V0IH0gZnJvbSAnQGF3cy1jZGsvYXdzLXJvdXRlNTMnO1xuaW1wb3J0IHsgQ2xvdWRGcm9udFRhcmdldCB9IGZyb20gJy4vY2xvdWRmcm9udC10YXJnZXQnO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFVzZXJQb29sRG9tYWluVGFyZ2V0IGltcGxlbWVudHMgSUFsaWFzUmVjb3JkVGFyZ2V0IHtcbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBkb21haW46IFVzZXJQb29sRG9tYWluKSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChfcmVjb3JkOiBJUmVjb3JkU2V0KTogQWxpYXNSZWNvcmRUYXJnZXRDb25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBkbnNOYW1lOiB0aGlzLmRvbWFpbi5jbG91ZEZyb250RG9tYWluTmFtZSxcbiAgICAgIGhvc3RlZFpvbmVJZDogQ2xvdWRGcm9udFRhcmdldC5nZXRIb3N0ZWRab25lSWQodGhpcy5kb21haW4pLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==