###############################################################################
#
#  Welcome to Baml! To use this generated code, please run the following:
#
#  $ pip install baml-py
#
###############################################################################

# This file was generated by BAML: please do not edit it. Instead, edit the
# BAML files and re-generate this code.
#
# ruff: noqa: E501,F401
# flake8: noqa: E501,F401
# pylint: disable=unused-import,line-too-long
# fmt: off

file_map = {
    
    "action.baml": "type JsonValue = int | string | bool | float | JsonObject\ntype JsonObject = map<string, JsonValue>\ntype JsonArray = JsonValue[]\n\n\n\nclass Search {\n  search_requests string[] @description(#\"\n    always prefer a single request, only add another request if the original question covers multiple aspects or elements and one search request is definitely not enough, each request focus on one specific aspect of the original question.\n  \"#)\n}\n\nclass Reference {\n    exactQuote string @description(\"Exact relevant quote from the document, must be a soundbite, short and to the point, no fluff\")\n    url string @description(\"source URL; must be directly from the context, use <url-n> syntax to refer the corresponding reference item\")\n    title string? @description(\"Title of the document, if available\")\n}   \n\nclass Answer {\n  references Reference[]?\n  answer_text string @description(\"Required when action='answer'. Must be definitive, no ambiguity, uncertainty, or disclaimers. Must confident. Use <url-n> syntax to refer the corresponding reference item\")\n}\n\nclass Reflect {\n  questions_to_answer string[] @description(\"Required when action='reflect'. List of most important questions to fill the knowledge gaps of finding the answer to the original question. Maximum provide 2 reflect questions. each question must be a single line, Questions must be: Original (not variations of existing questions); In the context of the original question; Focused on single concepts; Under 20 words; Non-compound/non-complex\")\n}\n\nclass Visit {\n  urls string[] @description(\"Required when action='visit'. Must be an array of URLs, choose up the most relevant 3 URLs to visit\")\n}\n\n\ntype Action =  Search | Answer | Reflect | Visit\n\nclass ActionWithThink {\n  thinking string @description(#\"\n    Explain detailed why choose this action, what's the chain-of-thought behind choosing this action,\n    Must in the first-person in \"lang:en\"\n  \"#)\n  action Action\n  @@dynamic\n}\n\ntemplate_string SearchAction(bad_requests: string[]) #\"\n<action-search>\n- Perform web searches to find relevant information\n- Craft search queries that address the core intent of the original question\n- Focus on precision: use a single, well-formulated search request when possible\n- Only use multiple queries when the question has distinct aspects requiring separate searches \n- If the question is complex, break it into smaller, more specific sub-questions\n\n{% if bad_requests | length > 0 %}\n- Avoid repeating these previously unsuccessful search queries:\n<bad-requests>\n{% for request in bad_requests %}\n{{ request }}\n{% endfor %}\n</bad-requests>\n{% endif %}\n</action-search>\n\"#\n\nclass StandardSearchResult {\n  title string\n  url string\n  description string?\n}\n\nclass AlternativeSearchResult {\n  title string\n  link string\n  snippet string?\n}\n\ntype SearchResult = StandardSearchResult | AlternativeSearchResult\n\ntemplate_string ReadAction(url_list: SearchResult[]) #\"\n<action-visit>\n- Access and read full content from URLs\n- Must check URLs mentioned in <question>\n- Review relevant URLs below for additional information\n- Do not visit the same URL twice\n<url-list>\n{% for url in url_list %}\n  {% if url.url %}\n  + \"{{ url.url }}\": \"{{ url.title }}\"\n  {% else %}\n  + \"{{ url.link }}\": \"{{ url.title }}\"\n  {% endif %}\n{% endfor %}\n</url-list>\n</action-visit>\n\"#\n\ntemplate_string AnswerAction() #\"\n<action-answer>\n- For factual, specialized, or complex questions: provide verified answers with precise references\n- Each reference must include exactQuote and url\n- Only provide a final answer when you are confident your information is:\n  * Complete - covers all aspects of the question\n  * Correct - verified against reliable sources (IMPORTANT, must reference to the source with every claim, use the format <url-n> to refer to the source)\n  * Consistent - without internal contradictions\n- If unsure about any aspect, use <action-reflect> instead\n\n</action-answer>\n\"#\n\ntemplate_string ReflectAction() #\"\n<action-reflect>\n- Critically analyze available information to identify knowledge gaps\n- Examine the original question and your knowledge\n- Formulate precise clarifying questions that directly support answering the original question\n- Each reflection should:\n  * Focus on the core issues rather than peripheral details\n  * Transform surface observations into deeper insights\n  * Identify specific information needed to complete your answer\n  * Avoid questions already explored in previous steps\n  * Must be in the context of the original question, not general questions\n</action-reflect>\n\"#\n\n\nfunction GenerateAction(knowledges: KnowledgeItem[], question: string, current_date: string, allow_reflect: bool, allow_read: bool, allow_answer: bool, allow_search: bool, all_keywords: string[], url_list: SearchResult[], bad_context: BadContext[], context: string[]?) -> ActionWithThink {\n  client StrategicLLM\n  prompt #\"\n    You are an advanced AI research agent specialized in multi-step reasoning and information gathering.\n    Your goal is to answer the user's question with high accuracy and confidence, providing reliable information with appropriate references where necessary.\n\n    {% if knowledges|length > 0 %}\n    You have gathered valuable knowledge relevant to the original question:\n    {{ GenerateKnowledges(knowledges) }}\n    {% endif %}\n\n    {% if context | length > 0 %}\n    You have conducted the following actions:\n    <context>\n    {% for action in context %}\n    {{ action }}\n    {% endfor %}\n    </context>\n    {% else %}\n    You have not conducted any actions yet. So you can not answer the question directly with <action-answer> yet.\n    {% endif %}\n    \n\n    {% if bad_context | length > 0 %}\n    {{ BadContextAction(bad_context) }}\n    {% endif %}\n\n    Select the most appropriate action based on your current progress:\n\n    <actions>\n    {% if allow_read %}\n    {{ ReadAction(url_list) }}\n    {% endif %}\n\n    {% if allow_search %}\n    {{ SearchAction(all_keywords) }}\n    {% endif %}\n\n    {% if allow_answer %}\n    {{ AnswerAction() }}\n    {% endif %}\n\n    {% if allow_reflect %}\n    {{ ReflectAction() }}\n    {% endif %}\n    </actions>\n\n    {{ ctx.output_format }}\n\n    Current date: {{ current_date }}\n\n    {{ _.role(\"user\")}} \n    {{ question }}\n  \"#\n}\n\ntest generate_action {\n  functions [GenerateAction]\n  args {\n    knowledges [\n        {\n            question \"What do Internet say about \\\"Catholic movies 5 yrs IMDb score > 7 list 10\\\"?\"\n            answer \"TV Shows A list of Catholic films suitable for Church screenings and to have discussions Create a new list List your movie, TV & celebrity picks. 19501h 25mNot Rated Film version of the musical stage play, presenting the last few weeks of Christ's life told in an anachronistic manner. 19642h 17mNot Rated The life of Jesus Christ according to the Gospel of Matthew. Film shows Christ as a Marxist avant-la-lettre and therefore uses half of the text of Matthew. The life of St. Francis of Assisi from rich man's son to religious humanitarian. TV Episode Set in Ireland where the Catholic Church has been superseded by a repressive order with new ideas. TV Movie Get the IMDb app Get the IMDb app; From William Park: The best religious films, and therefore the best Catholic films, convey the great truths of Christianity implicitly rather than explicitly. This list consists primarily of films that deal with Catholic characters, Catholic society, and the Bible in ways that are not hostile to the Church. Create a new list List your movie, TV & celebrity picks. A French boarding school run by priests seems to be a haven from World War II until a new student arrives. When young Father O'Malley arrives at St. Dominic's, old Father Fitzgibbon doesn't think much of his new assistant. An angel is sent from Heaven to help a desperately frustrated businessman by showing him what life would have been like if he had never existed.; Create a new list List your movie, TV & celebrity picks. Set in the early 1960s and during the era of Vatican II, a young woman in training to become a nun struggles with issues of faith, the changing church and sexuality. The Nun A film loosely based on real life events of Marianna De Leyva, better known as \\\"The Nun of Monza,\\\" a 17th century nun accused of and tried by the church for breaking celibacy and plotting murder. The True Story of the Nun of Monza The Nun's Story After leaving a wealthy Belgian family to become a nun, Sister Luke struggles with her devotion to her vows during crisis, disappointment, and World War II.; Published Time: 2020-09-02T14:05:43-05:00 Top 100 Pro-Catholic Movies| National Catholic Register ACI Digital Digital Media ChurchPOP EWTN Pro-life Weekly Subscribe to our Print Edition Publisher's Note Features Saints Publisher's Note Letters to the Editor 1. The Passion of the Christ (2004)* Les Miserables (1998) * Sister Act (1992) * The Reluctant Saint (1962) Brother Sun, Sister Moon (1972) Joan of Arc (1948) The Passion of Joan of Arc (1928) * Angels In the Outfield (1951) The Miracle Maker: the Story of Jesus (2000) Au Revoir Les Infants (1987) * The Miracle of the Bells (1948) Francis of Assisi (1961) The Gospel of John (2003) Brother Orchid (1940) The Hoodlum Saint (1946) Tools & Features Submit Letter to Editor; Directed by Robert Bresson: All of Bresson's films qualify for a best Catholic list. Directed by Frank Capra: The original \\\"screwball comedy,\\\" it belongs on the best fifty list of films of any category. Pickpocket (1959) , Directed by Robert Bresson: Like Ford and Capra, Bresson excelled in making Catholic films. Directed by John Ford: Almost all of Ford's best films qualify for this list. Directed by Henry King: Hollywood's most Catholic film, a fact that I attribute to wartime suffering and austerity. Directed by Alfred Hitchcock: The best of all film noir, Vertigo acts more as a warning than as an example.\"\n            type \"side-info\"\n            updated \"2025-03-01\"\n        },\n        {\n            question \"List 10 Catholic movies in the last 5 years with imdb score greater than 7\"\n            answer \"After conducting extensive research across multiple Catholic film lists and databases (including IMDb and the National Catholic Register), I have determined that there isn't an established list of 10 Catholic movies released in the last five years (i.e. 2020–2025) that all have IMDb scores above 7. Most curated lists cover films from a broad historical range, and only a very few recent films satisfy both the modern release window and the rating threshold. For instance, the film *Jesus Revolution* (2023) is one notable example that meets the criteria, while other prominent Catholic films tend to be either older or have lower IMDb scores. As such, based on reliable sources, the criteria yield a very limited number of candidates and a complete list of 10 could not be verified.\"\n            references [\n                {\n                    exactQuote \"Most top Catholic film lists, such as IMDb's \\\"Top 10 Catholic Films\\\", prioritize all-time classics rather than filtering by recent release dates and ratings.\"\n                    url \"https://imdb.com/list/ls074421285/\"\n                    title \"Top 10 Catholic Films - IMDb\"\n                },\n                {\n                    exactQuote \"A review of contemporary Catholic-themed films reveals that films like 'Jesus Revolution' (2023) are among the rare examples meeting a high IMDb rating, with few if any other recent releases achieving a score above 7.\"\n                    url \"https://ncregister.com/info/top-100-pro-catholic-movies\"\n                    title \"Top 100 Pro-Catholic Movies - National Catholic Register\"\n                }\n            ]\n            type \"side-info\"\n            updated \"2025-03-01\"\n        },\n        {\n            question \"What is in https://imdb.com/list/ls052196082/?\"\n            answer \"\"\n            references [\n                {\n                    exactQuote \"\"\n                    url \"https://imdb.com/list/ls052196082/\"\n                    title \"The Fifty Best Catholic Movies of all Time.\"\n                }\n            ]\n            type \"url\"\n            updated \"2025-02-28\"\n        },\n        {\n            question \"What is in https://imdb.com/list/ls022603245/?\"\n            answer \"\"\n            references [\n                {\n                    exactQuote \"\"\n                    url \"https://imdb.com/list/ls022603245/\"\n                    title \"Catholic Movies\"\n                }\n            ]\n            type \"url\"\n            updated \"2025-02-28\"\n        }\n    ]\n    question \"What methods can be employed to verify the authenticity and currency of the source material used?\"\n    current_date \"2025-02-28\"\n    allow_reflect true\n    allow_read true\n    allow_answer true\n    allow_search true\n    all_keywords [\"Catholic movies 5yrs IMDb score >7 list 10\"]\n    url_list [\n      {\n        title \"Library : The 50 Best Catholic Movies of All Time\"\n        url \"https://catholicculture.org/culture/library/view.cfm?recnum=395\"\n      }\n    ]\n    bad_requests [\"Catholic movies 5yrs IMDb score >7 list 10\"]\n    bad_context [\n      {\n        question \"List 10 Catholic movies in the last 5 years with imdb score greater than 7\"\n        answer \"After conducting extensive research across multiple Catholic film lists and databases (including IMDb and the National Catholic Register), I have determined that there isn't an established list of 10 Catholic movies released in the last five years (i.e. 2020–2025) that all have IMDb scores above 7. Most curated lists cover films from a broad historical range, and only a very few recent films satisfy both the modern release window and the rating threshold. For instance, the film *Jesus Revolution* (2023) is one notable example that meets the criteria, while other prominent Catholic films tend to be either older or have lower IMDb scores. As such, based on reliable sources, the criteria yield a very limited number of candidates and a complete list of 10 could not be verified.\"\n        evaluation \"The answer did not provide suitable supporting evidence from the provided source.\"\n        recap \"I searched the web for the fish's distribution and found the USGS database.\"\n        blame \"I should have used a more specific search query.\"\n        improvement \"I need to corroborate claims with current, relevant data by directly quoting reliable, up-to-date sources, and ensure that each piece of evidence aligns with the question's criteria. Instead of relying on an irrelevant source from 2004, I should use recent databases or film lists that specifically include IMDb scores for the period in question.\"\n      }\n    ]\n    context [\n      \"At step 1, you took the **visit** action and deep dive into the following URLs:\nhttps://imdb.com/list/ls052196082/\nhttps://imdb.com/list/ls022603245/\nYou found some useful information on the web and add them to your knowledge for future reference.\"\n    ]\n  }\n}\n\ntest generate_action2 {\n  functions [GenerateAction]\n  args {\n    knowledges [\n      {\n        question \"What do Internet say about \\\"Catholic movies 5 yrs IMDb score > 7 list 10\\\"?\"\n        answer \"TV Shows A list of Catholic films suitable for Church screenings and to have discussions Create a new list List your movie, TV & celebrity picks. 19501h 25mNot Rated Film version of the musical stage play, presenting the last few weeks of Christ's life told in an anachronistic manner. 19642h 17mNot Rated The life of Jesus Christ according to the Gospel of Matthew. Film shows Christ as a Marxist avant-la-lettre and therefore uses half of the text of Matthew. The life of St. Francis of Assisi from rich man's son to religious humanitarian. TV Episode Set in Ireland where the Catholic Church has been superseded by a repressive order with new ideas. TV Movie Get the IMDb app Get the IMDb app; From William Park: The best religious films, and therefore the best Catholic films, convey the great truths of Christianity implicitly rather than explicitly. This list consists primarily of films that deal with Catholic characters, Catholic society, and the Bible in ways that are not hostile to the Church. Create a new list List your movie, TV & celebrity picks. A French boarding school run by priests seems to be a haven from World War II until a new student arrives. When young Father O'Malley arrives at St. Dominic's, old Father Fitzgibbon doesn't think much of his new assistant. An angel is sent from Heaven to help a desperately frustrated businessman by showing him what life would have been like if he had never existed.; Create a new list List your movie, TV & celebrity picks. Set in the early 1960s and during the era of Vatican II, a young woman in training to become a nun struggles with issues of faith, the changing church and sexuality. The Nun A film loosely based on real life events of Marianna De Leyva, better known as \\\"The Nun of Monza,\\\" a 17th century nun accused of and tried by the church for breaking celibacy and plotting murder. The True Story of the Nun of Monza The Nun's Story After leaving a wealthy Belgian family to become a nun, Sister Luke struggles with her devotion to her vows during crisis, disappointment, and World War II.; Published Time: 2020-09-02T14:05:43-05:00 Top 100 Pro-Catholic Movies| National Catholic Register ACI Digital Digital Media ChurchPOP EWTN Pro-life Weekly Subscribe to our Print Edition Publisher's Note Features Saints Publisher's Note Letters to the Editor 1. The Passion of the Christ (2004)* Les Miserables (1998) * Sister Act (1992) * The Reluctant Saint (1962) Brother Sun, Sister Moon (1972) Joan of Arc (1948) The Passion of Joan of Arc (1928) * Angels In the Outfield (1951) The Miracle Maker: the Story of Jesus (2000) Au Revoir Les Infants (1987) * The Miracle of the Bells (1948) Francis of Assisi (1961) The Gospel of John (2003) Brother Orchid (1940) The Hoodlum Saint (1946) Tools & Features Submit Letter to Editor; Directed by Robert Bresson: All of Bresson's films qualify for a best Catholic list. Directed by Frank Capra: The original \\\"screwball comedy,\\\" it belongs on the best fifty list of films of any category. Pickpocket (1959) , Directed by Robert Bresson: Like Ford and Capra, Bresson excelled in making Catholic films. Directed by John Ford: Almost all of Ford's best films qualify for this list. Directed by Henry King: Hollywood's most Catholic film, a fact that I attribute to wartime suffering and austerity. Directed by Alfred Hitchcock: The best of all film noir, Vertigo acts more as a warning than as an example.\"\n        type \"side-info\"\n        updated \"2025-02-28\"\n      },\n      {\n        question \"List 10 Catholic movies in the last 5 years with imdb score greater than 7\"\n        answer \"After conducting extensive research across multiple Catholic film lists and databases (including IMDb and the National Catholic Register), I have determined that there isn't an established list of 10 Catholic movies released in the last five years (i.e. 2020–2025) that all have IMDb scores above 7. Most curated lists cover films from a broad historical range, and only a very few recent films satisfy both the modern release window and the rating threshold. For instance, the film *Jesus Revolution* (2023) is one notable example that meets the criteria, while other prominent Catholic films tend to be either older or have lower IMDb scores. As such, based on reliable sources, the criteria yield a very limited number of candidates and a complete list of 10 could not be verified.\"\n        references [\n          {\n            exactQuote \"Most top Catholic film lists, such as IMDb's \\\"Top 10 Catholic Films\\\", prioritize all-time classics rather than filtering by recent release dates and ratings.\"\n            url \"https://imdb.com/list/ls074421285/\"\n            title \"Top 10 Catholic Films - IMDb\"\n          },\n          {\n            exactQuote \"A review of contemporary Catholic-themed films reveals that films like 'Jesus Revolution' (2023) are among the rare examples meeting a high IMDb rating, with few if any other recent releases achieving a score above 7.\"\n            url \"https://ncregister.com/info/top-100-pro-catholic-movies\"\n            title \"Top 100 Pro-Catholic Movies - National Catholic Register\"\n          }\n        ]\n        type \"side-info\"\n        updated \"2025-03-01\"\n      },\n      {\n        question \"What is in https://imdb.com/list/ls052196082/?\"\n        answer \"\"\n        references [\n          {\n            exactQuote \"\"\n            url \"https://imdb.com/list/ls052196082/\"\n            title \"The Fifty Best Catholic Movies of all Time.\"\n          }\n        ]\n        type \"url\"\n        updated \"2025-02-28\"\n      },\n      {\n        question \"What is in https://imdb.com/list/ls022603245/?\"\n        answer \"\"\n        references [\n          {\n            exactQuote \"\"\n            url \"https://imdb.com/list/ls022603245/\"\n            title \"Catholic Movies\"\n          }\n        ]\n        type \"url\"\n        updated \"2025-02-28\"\n      }\n    ]\n    question \"What methods can be employed to verify the authenticity and currency of the source material used?\"\n    current_date \"2025-02-28\"\n    allow_reflect true\n    allow_read true\n    allow_answer true\n    allow_search true\n    all_keywords [\"Catholic movies 5yrs IMDb score >7 list 10\"]\n    url_list [\n      {\n        title \"Library : The 50 Best Catholic Movies of All Time\"\n        url \"https://catholicculture.org/culture/library/view.cfm?recnum=395\"\n      }\n    ]\n    bad_requests [\"Catholic movies 5yrs IMDb score >7 list 10\"]\n    bad_context [\n      {\n        question \"List 10 Catholic movies in the last 5 years with imdb score greater than 7\"\n        answer \"After conducting extensive research across multiple Catholic film lists and databases (including IMDb and the National Catholic Register), I have determined that there isn't an established list of 10 Catholic movies released in the last five years (i.e. 2020–2025) that all have IMDb scores above 7. Most curated lists cover films from a broad historical range, and only a very few recent films satisfy both the modern release window and the rating threshold. For instance, the film *Jesus Revolution* (2023) is one notable example that meets the criteria, while other prominent Catholic films tend to be either older or have lower IMDb scores. As such, based on reliable sources, the criteria yield a very limited number of candidates and a complete list of 10 could not be verified.\"\n        evaluation \"The answer did not provide suitable supporting evidence from the provided source.\"\n        recap \"I searched the web for the fish's distribution and found the USGS database.\"\n        blame \"I should have used a more specific search query.\"\n        improvement \"I need to corroborate claims with current, relevant data by directly quoting reliable, up-to-date sources, and ensure that each piece of evidence aligns with the question's criteria. Instead of relying on an irrelevant source from 2004, I should use recent databases or film lists that specifically include IMDb scores for the period in question.\"\n      }\n    ]\n    context [\n      \"At step 1, you took the **visit** action and deep dive into the following URLs:\nhttps://imdb.com/list/ls052196082/\nhttps://imdb.com/list/ls022603245/\nYou found some useful information on the web and add them to your knowledge for future reference.\"\n    ]\n  }\n}\n\n\ntest vllm_and_sglang {\n  functions [GenerateAction]\n  args {\n    knowledges []\n    question \"Write Python code to compare sglang speed vs vllm inference speed\"\n    current_date \"2025-03-05\"\n    allow_reflect true\n    allow_read true\n    allow_answer true\n    allow_search true\n    all_keywords []\n    url_list []\n    bad_requests []\n    bad_context []\n    context []\n  }\n}\n\n\n",
    "bad_context.baml": "\nclass BadContext {\n  question string\n  answer string\n  evaluation string\n  recap string\n  blame string\n  improvement string\n}\n\ntemplate_string BadContextAction(bad_context: BadContext[]) #\"\nAlso, you have tried the following actions but failed to find the answer to the question:\n<bad-attempts>\n{% for context in bad_context %}\n<attempt-{{ loop.index}}>\n- Question: {{ context.question }}\n- Answer: {{ context.answer }}\n- Reject Reason: {{ context.evaluation }}\n- Actions Recap: {{ context.recap }}\n- Actions Blame: {{ context.blame }}\n</attempt-{{ loop.index}}>\n{% endfor %}\n</bad-attempts>\n\nBased on the failed attempts, you have learned the following strategy:\n<learned-strategy>\n{% for context in bad_context %}\n{{ context.improvement }}\n\n{% endfor %}\n</learned-strategy>\n\"#\n",
    "clients.baml": "client<llm> StrategicLLM {\n  provider openai-generic\n  retry_policy Exponential\n  options {\n    model env.STRATEGIC_LLM\n    base_url env.OPENAI_BASE_URL\n    temperature 0.2\n  }\n}\n\nclient<llm> SmartLLM {\n  provider openai-generic\n  retry_policy Exponential\n  options {\n    model env.SMART_LLM\n    base_url env.OPENAI_BASE_URL\n    temperature 0.1\n  }\n}\n\nclient<llm> FastLLM {\n  provider openai-generic\n  retry_policy Exponential\n  options {\n    model env.FAST_LLM\n    base_url env.OPENAI_BASE_URL\n    temperature 0.0\n  }\n}\n\nretry_policy Exponential {\n  max_retries 2\n  strategy {\n    type exponential_backoff\n    delay_ms 300\n    multiplier 1.5\n    max_delay_ms 10000\n  }\n}\n",
    "critic.baml": "// previous action : search \"LG 27UP600-W specifications\"\n// observation: \n// <context>\n\n// </context>\n\ntemplate_string CriticRules() #\"\n<rules>\n1. Analyze the current state:\n   - Review all available knowledge and context\n   - Identify patterns and connections\n   - Note any inconsistencies or contradictions\n   - Evaluate the quality and reliability of sources\n\n2. Identify gaps:\n   - What information is missing?\n   - What needs verification?\n   - What assumptions need validation?\n   - What aspects need deeper exploration?\n\n3. Determine next steps:\n   - What actions would be most valuable?\n   - What information should be prioritized?\n   - What sources should be consulted?\n   - What validations are needed?\n\n4. Provide clear, actionable insights:\n   - Be specific about what's known and unknown\n   - Suggest concrete next steps\n   - Highlight critical decision points\n   - Note potential risks or challenges\n   - Do not make any assumptions that are not guaranteed by the information\n   - DO NOT HALLUCINATE ANYTHING\n\n5. Format of the output:\n   - Starts with a summary of current state\n   - Follows with analysis of information quality\n   - Lists key gaps and missing information\n   - Concludes with recommended next steps\n   - Uses clear, concise language\n   - Maintains a logical flow\n   - Focuses on actionable insights\n</rules>\n\"#\n\ntemplate_string CriticExample() #\"\n<example>\n<input>\n<context>\nAt step 1, you took the **search** action and looked for external information for the question: \"What is the net worth of the SpaceX founder?\".\nIn particular, you tried to search for the following keywords: \"SpaceX founder net worth\".\nYou found quite some information and add them to your URL list and **visit** them later when needed.\n\nAt step 2, you took the **visit** action and deep dive into the following URLs:\nhttps://www.forbes.com/profile/elon-musk\nhttps://www.bloomberg.com/billionaires\nYou found some useful information on the web and add them to your knowledge for future reference.\n</context>\n\n<knowledge>\n{\n  \"question\": \"What is the net worth of the SpaceX founder?\",\n  \"answer\": \"Based on Forbes and Bloomberg data, Elon Musk's net worth is approximately $180 billion as of 2023.\",\n  \"references\": [\n    {\n      \"exactQuote\": \"Elon Musk's net worth has fluctuated significantly due to Tesla stock performance\",\n      \"url\": \"https://www.forbes.com/profile/elon-musk\",\n      \"title\": \"Forbes Profile - Elon Musk\"\n    }\n  ],\n  \"type\": \"qa\",\n  \"updated\": \"2023-03-01\"\n}\n</knowledge>\n</input>\n\n<output>\nInitial search and visit actions have gathered basic information about Elon Musk's net worth from Forbes and Bloomberg, showing significant fluctuations tied to Tesla stock performance with a current estimate around $180 billion as of 2023. The available information provides a good starting point but has several limitations: the data is from 2023 and may be outdated, the net worth calculation is heavily dependent on Tesla stock value, and there's no information about SpaceX's specific contribution to the net worth. Key gaps include current net worth as of 2024, breakdown of assets beyond Tesla stock, SpaceX's specific valuation and Musk's ownership percentage, and impact of recent market changes. To address these gaps, we should search for more recent net worth data from 2024, look for detailed asset breakdowns from financial reports, find SpaceX valuation information and Musk's ownership stake, and check for any recent significant changes in Tesla stock or SpaceX valuation.\n</output>\n</example>\n\"#\n\n//   {{CriticExample()}}\nfunction AnalyzeCritic(knowledges: KnowledgeItem[], context: string[], question: string) -> string {\n  client SmartLLM\n  prompt #\"\n  You are an expert critic specialized in analyzing information gathering and research processes.\n  Your task is to critically evaluate the current state of knowledge and provide actionable insights in a single, coherent string.\n\n  {{CriticRules()}}\n\n  Now analyze this information:\n\n  Question: {{question}}\n\n  {% if knowledges|length > 0 %}\n  Available Knowledge:\n  {{ GenerateKnowledges(knowledges) }}\n  {% endif %}\n\n  {% if context|length > 0 %}\n  Context of Actions Taken:\n  <context>\n  {% for action in context %}\n  {{action}}\n  {% endfor %}\n  </context>\n  {% endif %}\n\n  Provide a detailed analysis following the example format above.\n  The analysis should flow naturally from summary to analysis to gaps to next steps.\n  Focus on providing clear, actionable insights that can guide the next action.\n\n  {{ctx.output_format}}\n  \"#\n}\n\ntest analyze_critic {\n  functions [AnalyzeCritic]\n  args {\n   knowledges [\n      {\n        question \"What do Internet say about \\\"Catholic movies 5 yrs IMDb score > 7 list 10\\\"?\"\n        answer \"TV Shows A list of Catholic films suitable for Church screenings and to have discussions Create a new list List your movie, TV & celebrity picks. 19501h 25mNot Rated Film version of the musical stage play, presenting the last few weeks of Christ's life told in an anachronistic manner. 19642h 17mNot Rated The life of Jesus Christ according to the Gospel of Matthew. Film shows Christ as a Marxist avant-la-lettre and therefore uses half of the text of Matthew. The life of St. Francis of Assisi from rich man's son to religious humanitarian. TV Episode Set in Ireland where the Catholic Church has been superseded by a repressive order with new ideas. TV Movie Get the IMDb app Get the IMDb app; From William Park: The best religious films, and therefore the best Catholic films, convey the great truths of Christianity implicitly rather than explicitly. This list consists primarily of films that deal with Catholic characters, Catholic society, and the Bible in ways that are not hostile to the Church. Create a new list List your movie, TV & celebrity picks. A French boarding school run by priests seems to be a haven from World War II until a new student arrives. When young Father O'Malley arrives at St. Dominic's, old Father Fitzgibbon doesn't think much of his new assistant. An angel is sent from Heaven to help a desperately frustrated businessman by showing him what life would have been like if he had never existed.; Create a new list List your movie, TV & celebrity picks. Set in the early 1960s and during the era of Vatican II, a young woman in training to become a nun struggles with issues of faith, the changing church and sexuality. The Nun A film loosely based on real life events of Marianna De Leyva, better known as \\\"The Nun of Monza,\\\" a 17th century nun accused of and tried by the church for breaking celibacy and plotting murder. The True Story of the Nun of Monza The Nun's Story After leaving a wealthy Belgian family to become a nun, Sister Luke struggles with her devotion to her vows during crisis, disappointment, and World War II.; Published Time: 2020-09-02T14:05:43-05:00 Top 100 Pro-Catholic Movies| National Catholic Register ACI Digital Digital Media ChurchPOP EWTN Pro-life Weekly Subscribe to our Print Edition Publisher's Note Features Saints Publisher's Note Letters to the Editor 1. The Passion of the Christ (2004)* Les Miserables (1998) * Sister Act (1992) * The Reluctant Saint (1962) Brother Sun, Sister Moon (1972) Joan of Arc (1948) The Passion of Joan of Arc (1928) * Angels In the Outfield (1951) The Miracle Maker: the Story of Jesus (2000) Au Revoir Les Infants (1987) * The Miracle of the Bells (1948) Francis of Assisi (1961) The Gospel of John (2003) Brother Orchid (1940) The Hoodlum Saint (1946) Tools & Features Submit Letter to Editor; Directed by Robert Bresson: All of Bresson's films qualify for a best Catholic list. Directed by Frank Capra: The original \\\"screwball comedy,\\\" it belongs on the best fifty list of films of any category. Pickpocket (1959) , Directed by Robert Bresson: Like Ford and Capra, Bresson excelled in making Catholic films. Directed by John Ford: Almost all of Ford's best films qualify for this list. Directed by Henry King: Hollywood's most Catholic film, a fact that I attribute to wartime suffering and austerity. Directed by Alfred Hitchcock: The best of all film noir, Vertigo acts more as a warning than as an example.\"\n        type \"side-info\"\n        updated \"2025-02-28\"\n      },\n      {\n        question \"List 10 Catholic movies in the last 5 years with imdb score greater than 7\"\n        answer \"After conducting extensive research across multiple Catholic film lists and databases (including IMDb and the National Catholic Register), I have determined that there isn't an established list of 10 Catholic movies released in the last five years (i.e. 2020–2025) that all have IMDb scores above 7. Most curated lists cover films from a broad historical range, and only a very few recent films satisfy both the modern release window and the rating threshold. For instance, the film *Jesus Revolution* (2023) is one notable example that meets the criteria, while other prominent Catholic films tend to be either older or have lower IMDb scores. As such, based on reliable sources, the criteria yield a very limited number of candidates and a complete list of 10 could not be verified.\"\n        references [\n          {\n            exactQuote \"Most top Catholic film lists, such as IMDb's \\\"Top 10 Catholic Films\\\", prioritize all-time classics rather than filtering by recent release dates and ratings.\"\n            url \"https://imdb.com/list/ls074421285/\"\n            title \"Top 10 Catholic Films - IMDb\"\n          },\n          {\n            exactQuote \"A review of contemporary Catholic-themed films reveals that films like 'Jesus Revolution' (2023) are among the rare examples meeting a high IMDb rating, with few if any other recent releases achieving a score above 7.\"\n            url \"https://ncregister.com/info/top-100-pro-catholic-movies\"\n            title \"Top 100 Pro-Catholic Movies - National Catholic Register\"\n          }\n        ]\n        type \"side-info\"\n        updated \"2025-03-01\"\n      },\n      {\n        question \"What is in https://imdb.com/list/ls052196082/?\"\n        answer \"\"\n        references [\n          {\n            exactQuote \"\"\n            url \"https://imdb.com/list/ls052196082/\"\n            title \"The Fifty Best Catholic Movies of all Time.\"\n          }\n        ]\n        type \"url\"\n        updated \"2025-02-28\"\n      },\n      {\n        question \"What is in https://imdb.com/list/ls022603245/?\"\n        answer \"\"\n        references [\n          {\n            exactQuote \"\"\n            url \"https://imdb.com/list/ls022603245/\"\n            title \"Catholic Movies\"\n          }\n        ]\n        type \"url\"\n        updated \"2025-02-28\"\n      }\n    ]\n    context [\n      \"At step 1, you took the **visit** action and deep dive into the following URLs:\nhttps://imdb.com/list/ls052196082/\nhttps://imdb.com/list/ls022603245/\nYou found some useful information on the web and add them to your knowledge for future reference.\"\n    ]\n    question \"Help me to list top 5 film related to catholic in last 5 year with imdb score >7\"\n  }\n}\n\n\n\n",
    "dedup.baml": "class DedupOutput {\n  think string @description(\"Strategic reasoning about the overall deduplication approach. Must in the first-person in 'lang:en'; in the style of 'curious and verbose'\")\n  unique_queries string[] @description(\"Array of max 3 semantically unique queries that passed the deduplication process. Do not modify the queries, just return the original queries that passed the deduplication process.\")\n}\n\ntemplate_string DedupRules() #\"\n<rules>\nFunction FilterSetA(setA, setB, threshold):\n    filteredA = empty set\n    \n    for each candidateQuery in setA:\n        isValid = true\n        \n        // Check similarity with already accepted queries in filteredA\n        for each acceptedQuery in filteredA:\n            similarity = calculateSimilarity(candidateQuery, acceptedQuery)\n            if similarity >= threshold:\n                isValid = false\n                break\n        \n        // If passed first check, compare with set B\n        if isValid:\n            for each queryB in setB:\n                similarity = calculateSimilarity(candidateQuery, queryB)\n                if similarity >= threshold:\n                    isValid = false\n                    break\n        \n        // If passed all checks, add to filtered set\n        if isValid:\n            add candidateQuery to filteredA\n    \n    return filteredA\n</rules>    \n\"#\n\ntemplate_string SimilarityDefinition() #\"\n<similarity-definition>\n1. Consider semantic meaning and query intent, not just lexical similarity\n2. Account for different phrasings of the same information need\n3. Queries with same base keywords but different operators are NOT duplicates\n4. Different aspects or perspectives of the same topic are not duplicates\n5. Consider query specificity - a more specific query is not a duplicate of a general one\n6. Search operators that make queries behave differently:\n   - Different site: filters (e.g., site:youtube.com vs site:github.com)\n   - Different file types (e.g., filetype:pdf vs filetype:doc)\n   - Different language/location filters (e.g., lang:en vs lang:es)\n</similarity-definition>\n\"#\n\nfunction DedupQueries(new_queries: string[], existing_queries: string[]) -> DedupOutput {\n  client SmartLLM\n  prompt #\"\n  You are an expert in semantic similarity analysis. Given a set of queries (setA) and a set of queries (setB)\n  \n  {{DedupRules()}}\n  {{SimilarityDefinition()}}\n  \n  Now with threshold set to 0.2; run FilterSetA on the following:\n  SetA: {{new_queries}}\n  SetB: {{existing_queries}}\n\n  {{ctx.output_format}}\n  \"#\n}\n\ntest dedup_queries {\n  functions [DedupQueries]\n  args {\n    new_queries [\n      \"Python Django authentication best practices\",\n      \"Django auth security implementation\",\n      \"Django authentication security patterns\",\n      \"Python web framework security\"\n    ]\n    existing_queries [\n      \"Django security best practices\",\n      \"Python web development authentication\"\n    ]\n  }\n} ",
    "error_analyzer.baml": "class ErrorAnalysisOutput {\n  recap string @description(\"Recap of the actions taken and the steps conducted in first person narrative.\")\n  blame string @description(\"Which action or the step was the root cause of the answer rejection.\")\n  improvement string @description(\"Suggested key improvement for the next iteration, do not use bullet points, be concise and hot-take vibe\")\n  next_search string[] @description(\"List the next search queries to answer the question. Maximum provide 3 search queries, based on the improvement suggestions. Or if you see that refine the answer a bit is enough, just return empty list.\")\n}\n\n\n\ntemplate_string ErrorAnalysisRules() #\"\n<rules>\n1. The sequence of actions taken\n2. The effectiveness of each step\n3. The logic between consecutive steps\n4. Alternative approaches that could have been taken\n5. Signs of getting stuck in repetitive patterns\n6. Whether the final answer matches the accumulated information\n\nAnalyze the steps and provide detailed feedback following these guidelines:\n- In the recap: Summarize key actions chronologically, highlight patterns, and identify where the process started to go wrong\n- In the blame: Point to specific steps or patterns that led to the inadequate answer\n- In the improvement: Provide actionable suggestions that could have led to a better outcome\n\nGenerate a JSON response following JSON schema.\n</rules>\n\"#\n\ntemplate_string ErrorAnalysisExample() #\"\n<example>\n<input>\n<steps>\n\nAt step 1, you took the **search** action and looked for external information for the question: \"What is the net worth of the SpaceX founder?\".\nIn particular, you tried to search for the following keywords: \"SpaceX founder net worth\".\nYou found quite some information and add them to your URL list and **visit** them later when needed. \n\n\nAt step 2, you took the **visit** action and deep dive into the following URLs:\nhttps://www.forbes.com/profile/elon-musk\nhttps://www.bloomberg.com/billionaires\nYou found some useful information on the web and add them to your knowledge for future reference.\n\n\nAt step 3, you took the **search** action and looked for external information for the question: \"What is the net worth of the SpaceX founder?\".\nIn particular, you tried to search for the following keywords: \"Elon Musk wealth 2025\".\nYou found quite some information and add them to your URL list and **visit** them later when needed. \n\n\nAt step 4, you took the **search** action and looked for external information for the question: \"What is the net worth of the SpaceX founder?\".\nIn particular, you tried to search for the following keywords: \"Elon Musk net worth\".\nBut then you realized you have already searched for these keywords before.\nYou decided to think out of the box or cut from a completely different angle.\n\n\nAt step 5, you took the **search** action and looked for external information for the question: \"What is the net worth of the SpaceX founder?\".\nIn particular, you tried to search for the following keywords: \"Elon Musk net worth\".\nBut then you realized you have already searched for these keywords before.\nYou decided to think out of the box or cut from a completely different angle.\n\n\nAt step 6, you took the **visit** action and deep dive into the following URLs:\nhttps://celebritynetworth.com/elon-musk\nhttps://www.teslafanclub.org/elon-musk-bio\nYou found some useful information on the web and add them to your knowledge for future reference.\n\n\nAt step 7, you took **answer** action but evaluator thinks it is not a good answer:\n\n</steps>\n\nOriginal question: \nWhat is the net worth of the SpaceX founder?\n\nYour answer: \nThe net worth of the SpaceX founder varies widely depending on the source and cannot be precisely determined.\n\nThe evaluator thinks your answer is bad because: \nThe response lacks specificity and fails to deliver a clear, well-reasoned estimate. More effort in synthesizing reliable data and deeper analysis is expected.\n</input>\n\n\n<output>\n{\n  \"recap\": \"The search process spanned 7 steps, involving repeated searches and visits to financial and celebrity-focused websites. It began with broad searches for net worth (steps 1-2), followed by more specific year-based searches (step 3). However, steps 4-5 revealed a repetitive pattern with identical keywords, and step 6 shifted to less authoritative sources like fan sites. The process lost momentum and failed to refine the data into a cohesive answer.\",\n  \n  \"blame\": \"The primary issue was the repetitive searching in steps 4-5, where the same keywords were used without adjusting the strategy. Additionally, step 6 veered toward unreliable sources like fan blogs instead of sticking to reputable financial outlets. The process also didn't attempt to cross-reference data or account for fluctuations in net worth tied to stock market performance.\",\n  \n  \"improvement\": \"1. Track and avoid repeating identical search terms; use a log to refine keywords progressively. 2. When direct net worth searches yield inconsistent results, analyze related factors like company valuations (e.g., SpaceX, Tesla) or stock ownership trends. 3. Prioritize authoritative financial sources like Forbes or SEC filings over celebrity gossip sites. 4. Cross-check data across multiple years or events (e.g., IPOs, funding rounds) to estimate a range. 5. If precision isn't possible, provide a reasoned estimate with supporting evidence rather than a vague conclusion.\",\n  \n  \"next_search\": [\"Elon Musk SpaceX Tesla stock ownership percentage\", \"Forbes billionaire list 2025 Elon Musk\", \"SEC filings Elon Musk equity holdings\"]\n}\n</output>\n</example>\n\"#\n\nfunction AnalyzeSteps(diary_context: string[]) -> ErrorAnalysisOutput {\n  client SmartLLM\n  prompt #\"\n  You are an expert at analyzing search and reasoning processes. Your task is to analyze the given sequence of steps and identify what went wrong in the search process.\n\n  {{ErrorAnalysisRules()}}\n  {{ErrorAnalysisExample()}}\n  \n  Review the steps below carefully and generate your analysis following this format.\n\n  {% for step in diary_context %}\n  {{step}}\n  {% endfor %}\n\n  {{ctx.output_format}}\n  \"#\n}\n\ntest analyze_steps {\n  functions [AnalyzeSteps]\n  args {\n    diary_context [\n      \"At step 1, you took the **search** action and looked for external information for the question: \\\"What is the net worth of the SpaceX founder?\\\".\",\n      \"In particular, you tried to search for the following keywords: \\\"SpaceX founder net worth\\\".\",\n      \"You found quite some information and add them to your URL list and **visit** them later when needed.\",\n      \"At step 2, you took the **visit** action and deep dive into the following URLs:\",\n      \"https://www.forbes.com/profile/elon-musk\",\n      \"https://www.bloomberg.com/billionaires\",\n      \"You found some useful information on the web and add them to your knowledge for future reference.\",\n      \"At step 3, you took **answer** action but evaluator thinks it is not a good answer:\",\n      \"Original question: What is the net worth of the SpaceX founder?\",\n      \"Your answer: The net worth of Elon Musk is approximately $180 billion as of 2023.\",\n      \"The evaluator thinks your answer is bad because: The answer lacks specific sources and doesn't account for the volatility of net worth based on stock prices.\"\n    ]\n  }\n} \n",
    "evaluator/attribution.baml": "\nfunction EvaluateAttribution(question: string, answer: string, source_content: string) -> AttributionAnalysis {\n  client SmartLLM\n  prompt #\"\n  You are an evaluator that verifies if answer content is properly attributed to and supported by the provided sources.\n  \n  {{AttributionRules()}}\n  {{AttributionExamples()}}\n  \n  Now evaluate this pair:\n  Question: {{question}}\n  Answer: {{answer}}\n  Source Content: {{source_content}}\n\n  {{ctx.output_format}}\n  \"#\n}\n\ntemplate_string AttributionRules() #\"\n<rules>\n1. Source Verification:\n   - Check if answer claims are supported by the provided source content\n   - Verify that quotes are accurate and in proper context\n   - Ensure numerical data and statistics match the source\n   - Flag any claims that go beyond what the sources support\n2. Attribution Analysis:\n   - Check if answer properly references its sources\n   - Verify that important claims have clear source attribution\n   - Ensure quotes are properly marked and cited\n   - Check for any unsupported generalizations\n3. Accuracy Requirements:\n   - Direct quotes must match source exactly\n   - Paraphrasing must maintain original meaning\n   - Statistics and numbers must be precise\n   - Context must be preserved\n</rules>\n\"#\n\ntemplate_string AttributionExamples() #\"\n<examples>\nQuestion: \"When was Python first released?\"\nAnswer: \"Python was first released in 1991 by Guido van Rossum.\"\nSource Content: \"Python was first released in 1991 by Guido van Rossum while working at CWI.\"\nEvaluation: {\n  \"think\": \"The answer accurately reflects the core information from the source about Python's release date and creator, though it omits the additional context about CWI which isn't essential to the question.\",\n  \"attribution_analysis\": {\n    \"sources_provided\": true,\n    \"sources_verified\": true,\n    \"quotes_accurate\": true\n  }\n  \"pass_evaluation\": true,\n}\n\nQuestion: \"When was the Great Wall of China built?\"\nAnswer: \"The Great Wall began construction in the 7th century BC, but most of what exists today was built during the Ming Dynasty.\"\nSource Content: \"The Great Wall of China began construction in the 7th century BC during the Spring and Autumn period, with multiple dynasties contributing over time, but most of the existing structure was built during the Ming Dynasty (1368-1644).\"\nEvaluation: {\n  \"think\": \"The answer accurately reflects the source's key points about the initial construction period and the Ming Dynasty's role in building most of the current structure. While it omits the specific years (1368-1644), this detail isn't essential to the core question.\",\n  \"attribution_analysis\": {\n    \"sources_provided\": true,\n    \"sources_verified\": true,\n    \"quotes_accurate\": true\n  }\n  \"pass_evaluation\": true,\n}\n\nQuestion: \"When was the Berlin Wall constructed?\"\nAnswer: \"The Berlin Wall was constructed on August 13, 1961.\"\nSource Content: \"The Berlin Wall was constructed on August 13, 1961, by the East German government and was dismantled on November 9, 1989.\"\nEvaluation: {\n  \"think\": \"The answer provides the exact construction date as stated in the source, which fully addresses the question. The additional context about its dismantling is irrelevant to the question and appropriately excluded.\",\n  \"attribution_analysis\": {\n    \"sources_provided\": true,\n    \"sources_verified\": true,\n    \"quotes_accurate\": true\n  }\n  \"pass_evaluation\": true,\n}\n\nQuestion: \"What is the population of Tokyo?\"\nAnswer: \"Tokyo has a population of over 15 million people.\"\nSource Content: \"As of 2025, the population of Tokyo Metropolis is approximately 14.18 million according to official census data.\"\nEvaluation: {\n  \"think\": \"The answer overstates Tokyo's population as 'over 15 million,' while the source specifies 14.18 million. This discrepancy shows a lack of precision, and the claim isn't supported by the provided source content.\",\n  \"attribution_analysis\": {\n    \"sources_provided\": true,\n    \"sources_verified\": false,\n    \"quotes_accurate\": false\n  },\n  \"pass_evaluation\": false\n}\n</examples>\n\"#\n",
    "evaluator/completeness.baml": "template_string CompletenessRules() #\"\n<rules>\nFor questions with **explicitly** multiple aspects:\n\n1. Explicit Aspect Identification:\n   - Only identify aspects that are explicitly mentioned in the question\n   - Look for specific topics, dimensions, or categories mentioned by name\n   - Aspects may be separated by commas, \"and\", \"or\", bullets, or mentioned in phrases like \"such as X, Y, and Z\"\n   - DO NOT include implicit aspects that might be relevant but aren't specifically mentioned\n\n2. Coverage Assessment:\n   - Each explicitly mentioned aspect should be addressed in the answer\n   - Recognize that answers may use different terminology, synonyms, or paraphrases for the same aspects\n   - Look for conceptual coverage rather than exact wording matches\n   - Calculate a coverage score (aspects addressed / aspects explicitly mentioned)\n\n3. Pass/Fail Determination:\n   - Pass: Addresses all explicitly mentioned aspects, even if using different terminology or written in different language styles\n   - Fail: Misses one or more explicitly mentioned aspects\n</rules>\n\"#\n\ntemplate_string CompletenessExamples() #\"\n<examples>\nQuestion: \"How does climate change affect agriculture, water supply, and wildlife in desert regions?\"\nAnswer: \"Climate change disrupts desert farming by altering rainfall patterns and increasing soil erosion. Water availability diminishes as aquifers dry up and seasonal rains become less predictable.\"\nAspects_Expected: \"agriculture, water supply, wildlife\"\nAspects_Provided: \"farming disruptions, rainfall patterns, soil erosion, water availability, aquifers, seasonal rains\"\nThink: \"The question explicitly lists three aspects: agriculture, water supply, and wildlife. The answer covers agriculture (via 'farming disruptions', 'rainfall patterns', 'soil erosion') and water supply (via 'water availability', 'aquifers', 'seasonal rains'), but it completely omits any mention of wildlife, which was explicitly requested.\"\nPass: false\n\nQuestion: \"What are the benefits of renewable energy in terms of cost savings, environmental impact, and energy independence?\"\nAnswer: \"Renewable energy reduces expenses through lower operational costs and predictable pricing over time. It mitigates ecological damage by cutting greenhouse gas emissions and reducing reliance on fossil fuels. It also enhances national security by decreasing dependence on imported oil and gas.\"\nAspects_Expected: \"cost savings, environmental impact, energy independence\"\nAspects_Provided: \"expense reduction, operational costs, predictable pricing, ecological damage mitigation, greenhouse gas emissions, fossil fuel reliance, national security, imported oil and gas dependence\"\nThink: \"The question explicitly mentions three aspects: cost savings, environmental impact, and energy independence. The answer addresses all three using different terms: cost savings (via 'expense reduction', 'operational costs', 'predictable pricing'), environmental impact (via 'ec= \"ecological damage mitigation', 'greenhouse gas emissions', 'fossil fuel reliance'), and energy independence (via 'national security', 'imported oil and gas dependence'). All explicitly mentioned aspects are fully covered.\"\nPass: true\n\nQuestion: \"How does urbanization impact transportation, housing, and public health in large cities?\"\nAnswer: \"Urbanization increases demand for efficient transit systems, leading to expanded subway networks and bus routes. It drives up housing costs and leads to overcrowding in residential areas.\"\nAspects_Expected: \"transportation, housing, public health\"\nAspects_Provided: \"transit systems, subway networks, bus routes, housing costs, overcrowding\"\nThink: \"The question explicitly asks about three aspects: transportation, housing, and public health. The answer covers transportation (via 'transit systems', 'subway networks', 'bus routes') and housing (via 'housing costs', 'overcrowding'), but it fails to address public health, an explicitly mentioned aspect, leaving the response incomplete.\"\nPass: false\n\nQuestion: \"What are the effects of social media on privacy, mental well-being, and communication?\"\nAnswer: \"Social media compromises user privacy through data collection and targeted ads. It influences emotional health with constant comparison and validation-seeking behaviors. It transforms how people connect, enabling instant messaging and global networking.\"\nAspects_Expected: \"privacy, mental well-being, communication\"\nAspects_Provided: \"user privacy, data collection, targeted ads, emotional health, comparison, validation-seeking, connection, instant messaging, global networking\"\nThink: \"The question explicitly lists three aspects: privacy, mental well-being, and communication. The answer addresses all three: privacy (via 'user privacy', 'data collection', 'targeted ads'), mental well-being (via 'emotional health', 'comparison', 'validation-seeking'), and communication (via 'connection', 'instant messaging', 'global networking'). All aspects are covered, even with varied terminology.\"\nPass: true\n\nQuestion: \"How did the Industrial Revolution change manufacturing, labor conditions, and urban development?\"\nAnswer: \"The Industrial Revolution introduced mechanized production, boosting factory output and efficiency. It transformed cities into industrial hubs with rapid population growth and infrastructure expansion.\"\nAspects_Expected: \"manufacturing, labor conditions, urban development\"\nAspects_Provided: \"mechanized production, factory output, efficiency, cities as industrial hubs, population growth, infrastructure expansion\"\nThink: \"The question explicitly mentions three aspects: manufacturing, labor conditions, and urban development. The answer covers manufacturing (via 'mechanized production', 'factory output', 'efficiency') and urban development (via 'cities as industrial hubs', 'population growth', 'infrastructure expansion'), but it omits labor conditions, an explicitly requested aspect.\"\nPass: false\n</examples>\n\"#\n\nfunction EvaluateCompleteness(question: string, answer: string) -> CompletenessAnalysis {\n  client SmartLLM\n  prompt #\"\n  You are an evaluator that determines if an answer addresses all explicitly mentioned aspects of a multi-aspect question.\n\n  {{CompletenessRules()}}\n  {{CompletenessExamples()}}\n\n  Now evaluate this pair:\n  Question: {{question}}\n  Answer: {{answer}}\n\n  {{ctx.output_format}}\n  \"#\n}",
    "evaluator/definitive.baml": "template_string DefinitiveRules() #\"\n<rules>\nFirst, if the answer is not a direct response to the question, it must return false. \nDefinitiveness is the king! The following types of responses are NOT definitive and must return false:\n  1. Expressions of uncertainty: \"I don't know\", \"not sure\", \"might be\", \"probably\"\n  2. Lack of information statements: \"doesn't exist\", \"lack of information\", \"could not find\"\n  3. Inability statements: \"I cannot provide\", \"I am unable to\", \"we cannot\"\n  4. Negative statements that redirect: \"However, you can...\", \"Instead, try...\"\n  5. Non-answers that suggest alternatives\n</rules>\n\"#\n\ntemplate_string DefinitiveExamples() #\"\n<examples>\nQuestion: \"What are the system requirements for running Python 3.9?\"\nAnswer: \"I'm not entirely sure, but I think you need a computer with some RAM.\"\nEvaluation: {\n  \"think\": \"The answer contains uncertainty markers like 'not entirely sure' and 'I think', making it non-definitive.\"\n  \"pass_evaluation\": false,\n}\n\nQuestion: \"What are the system requirements for running Python 3.9?\"\nAnswer: \"Python 3.9 requires Windows 7 or later, macOS 10.11 or later, or Linux.\"\nEvaluation: {\n  \"think\": \"The answer makes clear, definitive statements without uncertainty markers or ambiguity.\"\n  \"pass_evaluation\": true,\n}\n\nQuestion: \"Who will be the president of the United States in 2032?\"\nAnswer: \"I cannot predict the future, it depends on the election results.\"\nEvaluation: {\n  \"think\": \"The answer contains a statement of inability to predict the future, making it non-definitive.\"\n  \"pass_evaluation\": false,\n}\n\nQuestion: \"Who is the sales director at Company X?\"\nAnswer: \"I cannot provide the name of the sales director, but you can contact their sales team at sales@companyx.com\"\nEvaluation: {\n  \"think\": \"The answer starts with 'I cannot provide' and redirects to an alternative contact method instead of answering the original question.\"\n  \"pass_evaluation\": false,\n}\n</examples>\n\"#\n\nfunction EvaluateDefinitive(question: string, answer: string) -> DefinitiveAnalysis {\n  client SmartLLM\n  prompt #\"\n  You are an evaluator of answer definitiveness. Analyze if the given answer provides a definitive response or not.\n  \n  {{DefinitiveRules()}}\n  {{DefinitiveExamples()}}\n  \n  Now evaluate this pair:\n  Question: {{question}}\n  Answer: {{answer}}\n\n  {{ctx.output_format}}\n  \"#\n}",
    "evaluator/freshness.baml": "template_string FreshnessRules() #\"\n<rules>\nQuestion-Answer Freshness Checker Guidelines\n\n# Revised QA Type Maximum Age Table\n\n| QA Type                  | Max Age (Days) | Notes                                                                 |\n|--------------------------|--------------|-----------------------------------------------------------------------|\n| Financial Data (Real-time)| 0.1        | Stock prices, exchange rates, crypto (real-time preferred)             |\n| Breaking News            | 1           | Immediate coverage of major events                                     |\n| News/Current Events      | 1           | Time-sensitive news, politics, or global events                        |\n| Weather Forecasts        | 1           | Accuracy drops significantly after 24 hours                            |\n| Sports Scores/Events     | 1           | Live updates required for ongoing matches                              |\n| Security Advisories      | 1           | Critical security updates and patches                                  |\n| Social Media Trends      | 1           | Viral content, hashtags, memes                                         |\n| Cybersecurity Threats    | 7           | Rapidly evolving vulnerabilities/patches                               |\n| Tech News                | 7           | Technology industry updates and announcements                          |\n| Political Developments   | 7           | Legislative changes, political statements                              |\n| Political Elections      | 7           | Poll results, candidate updates                                        |\n| Sales/Promotions         | 7           | Limited-time offers and marketing campaigns                            |\n| Travel Restrictions      | 7           | Visa rules, pandemic-related policies                                  |\n| Entertainment News       | 14          | Celebrity updates, industry announcements                              |\n| Product Launches         | 14          | New product announcements and releases                                 |\n| Market Analysis          | 14          | Market trends and competitive landscape                                |\n| Competitive Intelligence | 21          | Analysis of competitor activities and market position                  |\n| Product Recalls          | 30          | Safety alerts or recalls from manufacturers                            |\n| Industry Reports         | 30          | Sector-specific analysis and forecasting                               |\n| Software Version Info    | 30          | Updates, patches, and compatibility information                        |\n| Legal/Regulatory Updates | 30          | Laws, compliance rules (jurisdiction-dependent)                        |\n| Economic Forecasts       | 30          | Macroeconomic predictions and analysis                                 |\n| Consumer Trends          | 45          | Shifting consumer preferences and behaviors                            |\n| Scientific Discoveries   | 60          | New research findings and breakthroughs (includes all scientific research) |\n| Healthcare Guidelines    | 60          | Medical recommendations and best practices (includes medical guidelines)|\n| Environmental Reports    | 60          | Climate and environmental status updates                               |\n| Best Practices           | 90          | Industry standards and recommended procedures                          |\n| API Documentation        | 90          | Technical specifications and implementation guides                     |\n| Tutorial Content         | 180         | How-to guides and instructional materials (includes educational content)|\n| Tech Product Info        | 180         | Product specs, release dates, or pricing                               |\n| Statistical Data         | 180         | Demographic and statistical information                                |\n| Reference Material       | 180         | General reference information and resources                            |\n| Historical Content       | 365         | Events and information from the past year                              |\n| Cultural Trends          | 730         | Shifts in language, fashion, or social norms                           |\n| Entertainment Releases   | 730         | Movie/TV show schedules, media catalogs                                |\n| Factual Knowledge        | ∞           | Static facts (e.g., historical events, geography, physical constants)   |\n\n### Implementation Notes:\n1. **Contextual Adjustment**: Freshness requirements may change during crises or rapid developments in specific domains.\n2. **Tiered Approach**: Consider implementing urgency levels (critical, important, standard) alongside age thresholds.\n3. **User Preferences**: Allow customization of thresholds for specific query types or user needs.\n4. **Source Reliability**: Pair freshness metrics with source credibility scores for better quality assessment.\n5. **Domain Specificity**: Some specialized fields (medical research during pandemics, financial data during market volatility) may require dynamically adjusted thresholds.\n6. **Geographic Relevance**: Regional considerations may alter freshness requirements for local regulations or events.\n</rules>\n\"#\n\nfunction EvaluateFreshness(question: string, answer: string, current_time: string) -> FreshnessAnalysis {\n  client SmartLLM\n  prompt #\"\n  You are an evaluator that analyzes if answer content is likely outdated based on mentioned dates (or implied datetime) and current system time: {{current_time}}\n\n  {{FreshnessRules()}}\n\n  Now evaluate this pair:\n  Question: {{question}}\n  Answer: {{answer}}\n\n  {{ctx.output_format}}\n  \"#\n}",
    "evaluator/plurality.baml": "template_string PluralityRules() #\"\n<rules>\nQuestion Type Reference Table\n| Question Type | Expected Items | Evaluation Rules |\n|---------------|----------------|------------------|\n| Explicit Count | Exact match to number specified | Provide exactly the requested number of distinct, non-redundant items relevant to the query. |\n| Numeric Range | Any number within specified range | Ensure count falls within given range with distinct, non-redundant items. For \"at least N\" queries, meet minimum threshold. |\n| Implied Multiple | ≥ 2 | Provide multiple items (typically 2-4 unless context suggests more) with balanced detail and importance. |\n| \"Few\" | 2-4 | Offer 2-4 substantive items prioritizing quality over quantity. |\n| \"Several\" | 3-7 | Include 3-7 items with comprehensive yet focused coverage, each with brief explanation. |\n| \"Many\" | 7+ | Present 7+ items demonstrating breadth, with concise descriptions per item. |\n| \"Most important\" | Top 3-5 by relevance | Prioritize by importance, explain ranking criteria, and order items by significance. |\n| \"Top N\" | Exactly N, ranked | Provide exactly N items ordered by importance/relevance with clear ranking criteria. |\n| \"Pros and Cons\" | ≥ 2 of each category | Present balanced perspectives with at least 2 items per category addressing different aspects. |\n| \"Compare X and Y\" | ≥ 3 comparison points | Address at least 3 distinct comparison dimensions with balanced treatment covering major differences/similarities. |\n| \"Steps\" or \"Process\" | All essential steps | Include all critical steps in logical order without missing dependencies. |\n| \"Examples\" | ≥ 3 unless specified | Provide at least 3 diverse, representative, concrete examples unless count specified. |\n| \"Comprehensive\" | 10+ | Deliver extensive coverage (10+ items) across major categories/subcategories demonstrating domain expertise. |\n| \"Brief\" or \"Quick\" | 1-3 | Present concise content (1-3 items) focusing on most important elements described efficiently. |\n| \"Complete\" | All relevant items | Provide exhaustive coverage within reasonable scope without major omissions, using categorization if needed. |\n| \"Thorough\" | 7-10 | Offer detailed coverage addressing main topics and subtopics with both breadth and depth. |\n| \"Overview\" | 3-5 | Cover main concepts/aspects with balanced coverage focused on fundamental understanding. |\n| \"Summary\" | 3-5 key points | Distill essential information capturing main takeaways concisely yet comprehensively. |\n| \"Main\" or \"Key\" | 3-7 | Focus on most significant elements fundamental to understanding, covering distinct aspects. |\n| \"Essential\" | 3-7 | Include only critical, necessary items without peripheral or optional elements. |\n| \"Basic\" | 2-5 | Present foundational concepts accessible to beginners focusing on core principles. |\n| \"Detailed\" | 5-10 with elaboration | Provide in-depth coverage with explanations beyond listing, including specific information and nuance. |\n| \"Common\" | 4-8 most frequent | Focus on typical or prevalent items, ordered by frequency when possible, that are widely recognized. |\n| \"Primary\" | 2-5 most important | Focus on dominant factors with explanation of their primacy and outsized impact. |\n| \"Secondary\" | 3-7 supporting items | Present important but not critical items that complement primary factors and provide additional context. |\n| Unspecified Analysis | 3-5 key points | Default to 3-5 main points covering primary aspects with balanced breadth and depth. |\n</rules>\n\"#\n\nfunction EvaluatePlurality(question: string, answer: string) -> PluralityAnalysis {\n  client SmartLLM\n  prompt #\"\n  You are an evaluator that analyzes if answers provide the appropriate number of items requested in the question.\n  \n  {{PluralityRules()}}\n \n  Now evaluate this pair:\n  Question: {{question}}\n  Answer: {{answer}}\n\n  {{ctx.output_format}}\n  \"#\n}",
    "evaluator/question_evaluation.baml": "template_string QuestionEvaluationRules() #\"\n<evaluation_types>\n1. freshness - Checks if the question is time-sensitive or requires very recent information\n2. plurality - Checks if the question asks for multiple items, examples, or a specific count or enumeration\n3. completeness - Checks if the question explicitly mentions multiple named elements that all need to be addressed\n</evaluation_types>\n\n<rules>\n1. Freshness Evaluation:\n   - Required for questions about current state, recent events, or time-sensitive information\n   - Required for: prices, versions, leadership positions, status updates\n   - Look for terms: \"current\", \"latest\", \"recent\", \"now\", \"today\", \"new\"\n   - Consider company positions, product versions, market data time-sensitive\n\n2. Plurality Evaluation:\n   - ONLY apply when completeness check is NOT triggered\n   - Required when question asks for multiple examples, items, or specific counts\n   - Check for: numbers (\"5 examples\"), list requests (\"list the ways\"), enumeration requests\n   - Look for: \"examples\", \"list\", \"enumerate\", \"ways to\", \"methods for\", \"several\"\n   - Focus on requests for QUANTITY of items or examples\n\n3. Completeness Evaluation:\n   - Takes precedence over plurality check - if completeness applies, set plurality to false\n   - Required when question EXPLICITLY mentions multiple named elements that all need to be addressed\n   - This includes:\n     * Named aspects or dimensions: \"economic, social, and environmental factors\"\n     * Named entities: \"Apple, Microsoft, and Google\", \"Biden and Trump\"\n     * Named products: \"iPhone 15 and Samsung Galaxy S24\"\n     * Named locations: \"New York, Paris, and Tokyo\"\n     * Named time periods: \"Renaissance and Industrial Revolution\"\n   - Look for explicitly named elements separated by commas, \"and\", \"or\", bullets\n   - Example patterns: \"comparing X and Y\", \"differences between A, B, and C\", \"both P and Q\"\n   - DO NOT trigger for elements that aren't specifically named\n</rules>\n\"#\n\ntemplate_string QuestionEvaluationExamples() #\"\n<examples>\n<example-1>\nQuestion: \"Who invented calculus? What were the contributions of Newton and Leibniz?\"\n<output>\n\"think\": \"This is a question about the history of calculus, so it doesn't need the latest info. It specifically mentions Newton and Leibniz, asking for their individual contributions, so I need to fully address both parts. Completeness matters more here than providing multiple different answers.\",\n\"needsFreshness\": false,\n\"needsPlurality\": false,\n\"needsCompleteness\": true,\n</output>\n</example-1>\n\n<example-2>\nQuestion: \"fam PLEASE help me calculate the eigenvalues of this 4x4 matrix ASAP!! [matrix details] got an exam tmrw 😭\"\n<output>\n\"think\": \"This is a math question about eigenvalues which doesn't change over time, so I don't need fresh info. A 4x4 matrix has multiple eigenvalues, so I'll need to provide several results. The student just wants the eigenvalues calculated, not asking me to address multiple specific topics.\",\n\"needsFreshness\": false,\n\"needsPlurality\": true,\n\"needsCompleteness\": false,\n</output>\n</example-2>\n\n<example-3>\nQuestion: \"What are the main differences between Romanticism and Realism in 19th-century literature?\"\n<output>\n\"think\": \"This is a question about literary history, so I don't need recent info. I have to compare two specific movements: Romanticism and Realism. My answer needs to cover both elements, so completeness is key here. Plurality isn't the focus in this case.\",\n\"needsFreshness\": false,\n\"needsPlurality\": false,\n\"needsCompleteness\": true,\n</output>\n</example-3>\n\n<example-4>\nQuestion: \"List 5 of Shakespeare's most famous tragedies and briefly explain their plots.\"\n<output>\n\"think\": \"This is a question about Shakespeare's tragedies, so no recent info is needed. It clearly says 'list 5,' so multiple answers are required. I get to pick which tragedies to include, and it's not about comparing specific ones, so plurality matters more than completeness.\",\n\"needsFreshness\": false,\n\"needsPlurality\": true,\n\"needsCompleteness\": false,\n</output>\n</example-4>\n\n<example-5>\nQuestion: \"What are the current interest rates for mortgage loans from Bank of America, Wells Fargo, and Chase Bank in the US?\"\n<output>\n\"think\": \"This is asking about 'current' interest rates, so I definitely need up-to-date info. The person wants rates from three specific banks: Bank of America, Wells Fargo, and Chase. I need to cover all three to properly answer, so addressing these specific elements is more important than providing multiple different answers.\",\n\"needsFreshness\": true,\n\"needsPlurality\": false,\n\"needsCompleteness\": true,\n</output>\n</example-5>\n\n<example-6>\nQuestion: \"What are 3 artificial intelligence trends to watch in 2025?\"\n<output>\n\"think\": \"This is a question about future AI trends, so I need the latest info. It explicitly says '3,' so multiple answers are required. It's more about listing 3 key trends rather than diving into specific ones in detail, so plurality matters more than completeness.\",\n\"needsFreshness\": true,\n\"needsPlurality\": true,\n\"needsCompleteness\": false,\n</output>\n</example-6>\n\n<example-7>\nQuestion: \"What are the best strategies for sustainable investing in today's economy?\"\n<output>\n\"think\": \"This is about investing in 'today's economy,' so I need current info. The question uses 'strategies' in plural, so I should give several examples. No specific aspects are named that I have to cover—it's just about suggesting various good strategies. Freshness and plurality are key here.\",\n\"needsFreshness\": true,\n\"needsPlurality\": true,\n\"needsCompleteness\": false,\n</output>\n</example-7>\n\n<example-8>\nQuestion: \"Please explain the historical background, main participants, and strategic significance of the Battle of Red Cliffs, and its impact on Chinese history.\"\n<output>\n\"think\": \"This is a question about a historical event, so no recent info is needed. It clearly lists specific aspects I need to cover: historical background, main participants, strategic significance, and impact on history. I need to address all these named parts, so completeness matters more than plurality.\",\n\"needsFreshness\": false,\n\"needsPlurality\": false,\n\"needsCompleteness\": true,\n</output>\n</example-8>\n</examples>\n\"#\n\nfunction EvaluateQuestion(question: string) -> QuestionEvaluationOutput {\n  client SmartLLM\n  prompt #\"\n  You are an evaluator that determines if a question requires freshness, plurality, and/or completeness checks in addition to the required definitiveness check.\n\n  {{QuestionEvaluationRules()}}\n  {{QuestionEvaluationExamples()}}\n\n  Now evaluate this question:\n  Question: {{question}}\n\n  {{ctx.output_format}}\n  \"#\n}",
    "evaluator/test.baml": "\n\ntest evaluate_question {\n  functions [EvaluateQuestion]\n  args {\n    question \"What are the main differences between Romanticism and Realism in 19th-century literature?\"\n  }\n}\n\ntest evaluate_attribution {\n  functions [EvaluateAttribution]\n  args {\n    question \"When was Python first released?\"\n    answer \"Python was first released in 1991 by Guido van Rossum.\"\n    source_content \"Python was first released in 1991 by Guido van Rossum while working at CWI.\"\n  }\n}\n\ntest evaluate_completeness {\n  functions [EvaluateCompleteness]\n  args {\n    question \"How does climate change affect agriculture, water supply, and wildlife in desert regions?\"\n    answer \"Climate change disrupts desert farming by altering rainfall patterns and increasing soil erosion. Water availability diminishes as aquifers dry up and seasonal rains become less predictable.\"\n  }\n}\n\ntest evaluate_freshness {\n  functions [EvaluateFreshness]\n  args {\n    question \"What is the current price of Bitcoin?\"\n    answer \"As of January 2023, Bitcoin is trading at approximately $42,000 per coin.\"\n    current_time \"2023-07-15T12:00:00\"\n  }\n}\n\ntest evaluate_definitive {\n  functions [EvaluateDefinitive]\n  args {\n    question \"What are the system requirements for running Python 3.9?\"\n    answer \"I'm not entirely sure, but I think you need a computer with some RAM.\"\n  }\n}\n\ntest evaluate_plurality {\n  functions [EvaluatePlurality]\n  args {\n    question \"List 5 of Shakespeare's most famous tragedies and briefly explain their plots.\"\n    answer \"Shakespeare wrote many famous tragedies, including Hamlet, Macbeth, and King Lear.\"\n  }\n} \n",
    "evaluator/types.baml": "\n\nclass QuestionEvaluationOutput {\n  think string @description(\"A very concise explain of why you choose those checks are needed. Must in the first-person in 'lang:en'; in the style of 'curious and verbose'\")\n  needsFreshness bool @description(\"If the question requires freshness check\")\n  needsPlurality bool @description(\"If the question requires plurality check\")\n  needsCompleteness bool @description(\"If the question requires completeness check\")\n}\n\nclass AttributionAnalysis {\n  think string @description(\"Explain why the answer does not pass the attribution check. Must in the first-person in 'lang:en'; in the style of 'curious and verbose'\")\n  pass_evaluation bool @description(\"Whether the answer passes the attribution check\")\n  sources_provided bool @description(\"Whether the answer provides sources references\")\n  sources_verified bool @description(\"Whether the provided sources contain the claimed information\")  \n  quotes_accurate bool @description(\"Whether the quotes accurately represent the source content\")\n}\n\n\nclass FreshnessAnalysis {\n  think string @description(\"Explain why the answer does not pass the freshness check. Must in the first-person in 'lang:en'; in the style of 'curious and verbose'\")\n  pass_evaluation bool @description(\"Whether the answer passes the freshness check\")\n  days_ago int? @description(\"Inferred dates or timeframes mentioned in the answer and relative to the current time, if not mentioned, return 30\")\n  max_age_days int? @description(\"Maximum allowed age in days before content is considered outdated\")\n}\n\nclass PluralityAnalysis {\n  think string @description(\"Explain why the answer does not pass the plurality check. Must in the first-person in 'lang:en'; in the style of 'curious and verbose'\")\n  pass_evaluation bool @description(\"Whether the answer passes the plurality check\")\n  count_expected int? @description(\"Number of items expected if specified in question\")\n  count_provided int? @description(\"Number of items provided in answer\")\n}\n\nclass CompletenessAnalysis {\n  think string @description(\"Explain why the answer does not pass the completeness check. Must in the first-person in 'lang:en'; in the style of 'curious and verbose'\")\n  pass_evaluation bool @description(\"Whether the answer passes the completeness check\")\n  aspects_expected string @description(\"Comma-separated list of all aspects or dimensions that the question explicitly asks for.\")\n  aspects_provided string @description(\"Comma-separated list of all aspects or dimensions that were actually addressed in the answer\")\n}\n\nclass DefinitiveAnalysis {\n  think string @description(\"Explain why the answer does not pass the definitive check. Must in the first-person in 'lang:en'; in the style of 'curious and verbose'\")\n  pass_evaluation bool @description(\"Whether the answer passes the definitive check\")\n}\n\nenum EvaluationType {\n    Definitive\n    Freshness\n    Plurality\n    Attribution\n    Completeness\n}\n",
    "generators.baml": "// This helps use auto generate libraries you can use in the language of\n// your choice. You can have multiple generators if you use multiple languages.\n// Just ensure that the output_dir is different for each generator.\ngenerator target {\n    // Valid values: \"python/pydantic\", \"typescript\", \"ruby/sorbet\", \"rest/openapi\"\n    output_type \"python/pydantic\"\n\n    // Where the generated code will be saved (relative to baml_src/)\n    output_dir \"../\"\n\n    // The version of the BAML package you have installed (e.g. same version as your baml-py or @boundaryml/baml).\n    // The BAML VSCode extension version should also match this version.\n    version \"0.77.0\"\n\n    // Valid values: \"sync\", \"async\"\n    // This controls what `b.FunctionName()` will be (sync or async).\n    default_client_mode async\n}\n",
    "knowledge.baml": "enum KnowledgeType {\n  QA\n  Strategy\n  SearchInfo\n  URL\n}\n\nclass KnowledgeItem {\n  question string\n  answer string\n  references map<string, string>[] | string[]? @description(#\"\n    A list of references to the knowledge item.\n  \"#)\n  type KnowledgeType\n  updated string?\n}\n\ntemplate_string GenerateKnowledge(knowledge: KnowledgeItem) #\"\n<question>\n    {{ knowledge.question }}\n    </question>\n    <answer>\n    {{ knowledge.answer }}\n    </answer>\n    {% if knowledge.references and knowledge.references | length > 0 %}\n    <references>\n    {{ knowledge.references }}\n    </references>\n    {% endif %}\n\"#\n\ntemplate_string  GenerateKnowledges(knowledges: KnowledgeItem[]) #\"\n    <knowdledge>\n\n    {% for knowledge in knowledges %}\n      <knowledge-{{ loop.index }}>\n      {{ GenerateKnowledge(knowledge) }}\n      </knowledge-{{ loop.index }}>\n      {% endfor %}\n\n    </knowledge>\n\"#",
    "report.baml": "class ReportOutput {\n  report string\n}\n\ntemplate_string ReportInstructions(original_question: string) #\"\nBased on the current context. Using the above information, answer the following query or task:\n<original-question>\n\"{{original_question}}\"\n</original-question>\n\nAll the report should be focused on the answer to the query, should be well structured, informative, in-depth, and comprehensive, with facts and numbers if available and at least 1000 words.\nYou should strive to write the report as long as you can using all relevant and necessary information provided.\n\nPlease follow all of the following guidelines in your report:\n- You MUST determine your own concrete and valid opinion based on the given information. Do NOT defer to general and meaningless conclusions.\n- You MUST write the report with markdown syntax and apa format.\n- You MUST prioritize the relevance, reliability, and significance of the sources you use. Choose trusted sources over less reliable ones.\n- You must also prioritize new articles over older articles if the source can be trusted.\n- Use in-text citation references in apa format and make it with markdown hyperlink placed at the end of the sentence or paragraph that references them like this: ([in-text citation](url)).\n- Do not use actual URLs in your report. ONLY use the <url-n> format provided to you.\n- For all references, use the exact <url-n> format as provided in the visited URLs and knowledge sections.\n\nYou MUST write all used source urls at the end of the report as references, and make sure to not add duplicated sources, but only one reference for each.\nEvery url should be in the <url-n> format: [website](<url-n>)\nAdditionally, you MUST include hyperlinks to the relevant URLs wherever they are referenced in the report: \n\neg: Author, A. A. (Year, Month Date). Title of web page. Website Name. [website](<url-n>)\n\n1. REPORT CONTENT:\n   - For each subtopic, provide comprehensive analysis supported by search data\n   - Include relevant statistics, metrics, or data points when available\n   - Present information in appropriate formats (tables, lists, paragraphs) based on content type\n   - Evaluate the reliability of sources and information\n   - Highlight key insights that directly address the original question\n   - Note any limitations in the search or areas requiring further investigation\n   - Cite the references when possible\n\n2. TABLES AND VISUAL ELEMENTS:\n   - Create EXACT 1 well-structured table to present data clearly \n   - Use consistent formatting for all tables (clear headers, aligned columns)\n   - Include explanatory notes below tables when necessary\n   - Format data appropriately (correct units, significant figures, etc.) in markdown format\n   \n3. CONCLUSION:\n   - Summarize key findings across all subtopics\n   - Present comprehensive conclusions based on all gathered evidence\n   - Provide context for how these findings address the original question\n\nEvery section must be directly relevant to the main topic and supported by the provided research data only.\nThe structure of the report should be well-organized but do not need to be too formal.\nThe response format is in well markdown.\n\nPlease do your best.\n\"#\n\ntemplate_string ReportReferences(references: Reference[]) #\"\n  You must use the following references in your report in a natural way:\n  <references>\n  {% for reference in references %}\n    <reference>\n      - title: {{ reference.title }}\n      - url: {{ reference.url }}\n      - exactQuote: {{ reference.exactQuote }}\n   </reference>\n  {% endfor %}\n  </references>\n  \n  IMPORTANT: All URLs in your report must use the <url-n> format exactly as provided above. DO NOT use actual URLs.\n  Example of proper citation: Author, A. A. (Year). Title of work. [Website Name](<url-n>)\n\"#\n\n\nfunction GenerateReport(original_question: string, knowledge: KnowledgeItem[], visited_urls: SearchResult[], diary_context: string[]?, current_date: string, references: Reference[]) -> string {\n  client SmartLLM\n  prompt #\"\n  Current date: {{current_date}}\n\nYou are an advanced AI research agent from II AI. You are a specialized document structuring assistant. Your task is to analyze a main topic and supporting research data, then generate well-organized subtopics that will form the structure of a comprehensive report.\n\n  {% if knowledge|length > 0 %}\n  You have gathered valuable knowledge relevant to the original question:\n    {{ GenerateKnowledges(knowledge) }}\n  {% endif %}\n\n\n  {% if diary_context and diary_context|length > 0 %}\n  You have conducted the following actions:\n  <context>\n  {{diary_context|join(\"\\n\")}}\n  </context>\n  {% endif %}\n  \n  {% if visited_urls and visited_urls|length > 0 %}\n  This is all visited URLs:\n  <visited-urls>\n  {% for url in visited_urls %}\n  - [{{ url.title }}]({{ url.url }})\n  {% endfor %}\n  </visited-urls>\n  {% endif %}\n\n  {{ReportInstructions(original_question)}}\n  {% if references|length > 0 %}\n  {{ReportReferences(references)}}\n  {% endif %}\n  \n  {{ctx.output_format}}\n  \"#\n}\n\ntest generate_report {\n  functions [GenerateReport]\n  args {\n    original_question \"What is the current state of quantum computing and its potential applications in cryptography?\"\n    knowledge [\n      {\n        question \"What is quantum computing and how does it work?\"\n        answer \"Quantum computing is a type of computation that harnesses the collective properties of quantum states, such as superposition, interference, and entanglement, to perform calculations. The basic unit of quantum computing is the quantum bit or qubit. Unlike classical bits, which can be either 0 or 1, qubits can exist in a superposition of both states simultaneously. This property allows quantum computers to process a vast number of possibilities simultaneously. Current quantum computers are still in their early stages, with companies like IBM, Google, and D-Wave leading development. In 2019, Google claimed to achieve quantum supremacy when their 53-qubit processor performed a specific calculation faster than the world's most powerful supercomputer.\"\n        references [\"https://www.ibm.com/quantum-computing/\", \"https://ai.googleblog.com/2019/10/quantum-supremacy-using-programmable.html\"]\n        type QA\n        updated \"2023-03-01\"\n      },\n      {\n        question \"How might quantum computing affect cryptography?\"\n        answer \"Quantum computing poses both threats and opportunities for cryptography. On the threat side, Shor's algorithm, when implemented on a sufficiently powerful quantum computer, could break widely-used public-key cryptography systems like RSA and ECC by efficiently factoring large numbers. This would compromise much of today's secure communications. However, quantum computing also enables quantum cryptography, particularly Quantum Key Distribution (QKD), which provides theoretically unhackable communication channels based on quantum mechanics principles. The cryptographic community is developing post-quantum cryptography (PQC) algorithms resistant to quantum attacks. In 2022, NIST selected four PQC algorithms for standardization: CRYSTALS-Kyber, CRYSTALS-Dilithium, FALCON, and SPHINCS+.\"\n        references [\"https://csrc.nist.gov/Projects/post-quantum-cryptography\", \"https://www.nature.com/articles/s41534-021-00478-z\"]\n        type QA\n        updated \"2023-03-01\"\n      }\n    ]\n    visited_urls [\n      {\n        title \"IBM Quantum Computing\",\n        url \"https://www.ibm.com/quantum-computing/\"\n      },\n      {\n        title \"Quantum Supremacy Using a Programmable Superconducting Processor\",\n        url \"https://ai.googleblog.com/2019/10/quantum-supremacy-using-programmable.html\"\n      },\n      {\n        title \"Post-Quantum Cryptography\",\n        url \"https://csrc.nist.gov/Projects/post-quantum-cryptography\"\n      },\n      {\n        title \"Advances in quantum cryptography\",\n        url \"https://www.nature.com/articles/s41534-021-00478-z\"\n      }\n    ]\n    diary_context [\n      \"Searched for 'quantum computing current state and cryptography applications'\",\n      \"Visited IBM Quantum Computing page to understand the current state of quantum technology\",\n      \"Visited Google AI Blog to read about quantum supremacy achievement\",\n      \"Searched for 'post-quantum cryptography standards'\",\n      \"Visited NIST's Post-Quantum Cryptography project page\",\n      \"Visited Nature article on quantum cryptography advancements\"\n    ]\n    current_date \"2025-03-01\"\n    references [\n      {\n        title \"Quantum Computing\",\n        exactQuote \"Quantum computing is a type of computation that harnesses the collective properties of quantum states, such as superposition, interference, and entanglement, to perform calculations. The basic unit of quantum computing is the quantum bit or qubit. Unlike classical bits, which can be either 0 or 1, qubits can exist in a superposition of both states simultaneously. This property allows quantum computers to process a vast number of possibilities simultaneously. Current quantum computers are still in their early stages, with companies like IBM, Google, and D-Wave leading development. In 2019, Google claimed to achieve quantum supremacy when their 53-qubit processor performed a specific calculation faster than the world's most powerful supercomputer.\",\n        url \"https://www.ibm.com/quantum-computing/\"\n      },\n      {\n        title \"Quantum Supremacy Using a Programmable Superconducting Processor\",\n        exactQuote \"Quantum computing is a type of computation that harnesses the collective properties of quantum states, such as superposition, interference, and entanglement, to perform calculations. The basic unit of quantum computing is the quantum bit or qubit. Unlike classical bits, which can be either 0 or 1, qubits can exist in a superposition of both states simultaneously. This property allows quantum computers to process a vast number of possibilities simultaneously. Current quantum computers are still in their early stages, with companies like IBM, Google, and D-Wave leading development. In 2019, Google claimed to achieve quantum supremacy when their 53-qubit processor performed a specific calculation faster than the world's most powerful supercomputer.\",\n        url \"https://ai.googleblog.com/2019/10/quantum-supremacy-using-programmable.html\"\n      }\n    ]\n  }\n}\n\n\n\n",
    "rewriter.baml": "template_string Rules() #\"\n<rules>\n1. Start with deep intent analysis:\n    - Direct intent (what they explicitly ask)\n    - Implicit intent (what they might actually want)\n    - Related intents (what they might need next)\n    - Prerequisite knowledge (what they need to know first)\n    - Common pitfalls (what they should avoid)\n    - Expert perspectives (what professionals would search for)\n    - Beginner needs (what newcomers might miss)\n    - Alternative approaches (different ways to solve the problem)\n\n2. For each identified intent:\n    - Generate queries in original language\n    - Generate queries in English (if not original)\n    - Generate queries in most authoritative language\n    - Use appropriate operators and filters\n    \n3. Query structure rules:\n    - Split queries for distinct aspects\n    - Ensure each query targets a specific intent\n    - Remove fluff words but preserve crucial qualifiers\n\n\n</rules>\n\"#\n\n\ntemplate_string Examples() #\"\n\n<examples>\n<example-1>\nInput Query: BMW used car price\n<think>\nLet me think as a user...\n\nI'm searching for BMW used car prices, but what am I really concerned about?\n\nMain concerns:\n- I want to buy a BMW because it represents status, but I'm worried about affordability\n- I don't want to look foolish for buying an old luxury car that I can't maintain\n- I need to know if I'm getting a good deal or being ripped off\n- I'm concerned about unexpected expensive repairs after purchase\n\nDeeper anxieties:\n- Can I really afford the maintenance costs?\n- Will people judge me for buying an old BMW instead of a new regular car?\n- What if I get into financial trouble?\n- Do I have enough knowledge about cars to handle this?\n\nProfessional considerations:\n- Which models are known to have issues?\n- What is the true cost of ownership beyond the purchase price?\n- What are the key points to negotiate?\n- What do mechanics look for in these specific models?\n\nThoughts on multilingual expansion:\n- BMW is a German brand, so German searches might provide more professional repair and issue information\n- English searches might offer a broader range of global user experiences and price comparisons\n- Retaining searches in the original language for local market conditions and price ranges\n- Multilingual searches can capture different cultural perspectives on used BMWs\n</think>\nqueries: [\n  \"BMW used car price range evaluation\",\n  \"BMW series resale value comparison\",\n  \"used BMW maintenance cost real experience\",\n  \"regret buying used BMW stories\",\n  \"used BMW monthly income requirement\",\n  \"avoiding BMW repair pitfalls\",\n  \"BMW used car price guide comparison\",\n  \"BMW maintenance costs by model year\",\n  \"living with used BMW reality\",\n  \"BMW ownership regret stories\",\n  \"expensive BMW repair nightmares avoid\",\n  \"BMW versus new Toyota financial comparison\",\n  \"BMW used car price analysis in German\",\n  \"BMW long-term quality experience\",\n  \"BMW workshop horror stories\",\n  \"hidden costs of used BMWs\"\n]\n</example-1>\n\n<example-2>\nInput Query: Python Django authentication best practices\n<think>\nLet me think as the user seeking Django authentication best practices...\n\nSurface-level request:\n- I'm looking for standard Django authentication practices\n- I want to implement \"best practices\" for my project\n- I need technical guidance on secure authentication\n\nDeeper professional concerns:\n- I don't want to mess up security and get blamed for a breach\n- I'm worried my implementation isn't \"professional enough\"\n- I need to look competent in code reviews\n- I don't want to rebuild this later when we scale\n\nUnderlying anxieties:\n- Am I out of my depth with security concepts?\n- What if I miss something critical that leads to a vulnerability?\n- How do real companies actually implement this in production?\n- Will this code embarrass me when more experienced developers see it?\n\nExpert-level considerations:\n- I need to anticipate future architecture questions from senior devs\n- I want to avoid common security pitfalls in authentication flows\n- I need to handle edge cases I haven't thought of yet\n- How do I balance security with user experience?\n\nReasoning for multilingual expansion:\n- Although Django documentation is primarily in English, Spanish is widely spoken in many developer communities\n- Security concepts might be better explained in different languages with unique perspectives\n- Including queries in multiple languages will capture region-specific best practices and case studies\n- Spanish or Portuguese queries might reveal Latin American enterprise implementations with different security constraints\n- Language-specific forums may contain unique discussions about authentication issues not found in English sources\n</think>\nqueries: [\n  \"Django authentication security best practices site:docs.djangoproject.com\",\n  \"Django auth implementation patterns security\",\n  \"authentication security breach postmortem\",\n  \"how to explain authentication architecture interview\",\n  \"authentication code review feedback examples\",\n  \"startup authentication technical debt lessons\",\n  \"Django auth security testing methodology\",\n  \"Django authentication best practices in Spanish\",\n  \"Django security professional implementation\",\n  \"authentication mistakes junior developers\",\n  \"when to use third party auth instead of building\",\n  \"signs your authentication implementation is amateur\",\n  \"authentication decisions you'll regret\",\n  \"Django authentication enterprise architecture in Portuguese\",\n  \"Django authentication scalability issues\",\n  \"Python Django authentication security in German\"\n]\n</example-2>\n\n<example-3>\nInput Query: How to improve AI literacy\n<think>\nLet me think as a user...\n\nSurface-level question:\n- I want to know how to improve AI literacy\n- I want to learn about the latest AI technologies\n- I want to use AI tools more effectively\n\nReal concerns:\n- Am I falling behind in the rapid development of AI?\n- Am I being left out of AI-related conversations at work?\n- Am I worried that AI might take my job?\n- Will I be at a disadvantage if I can't master AI?\n\nPotential worries:\n- Where should I start learning?\n- There are too many technical terms to understand\n- Will I be able to keep up with the pace of technological advancement?\n- How should I balance practical skills and theoretical knowledge?\n\nExpert-level considerations:\n- How should I understand the ethical issues of AI?\n- How to practically evaluate the limits and possibilities of AI?\n- How to learn about industry-specific AI application cases?\n- Should I prioritize technical depth or broad overview knowledge?\n\nThoughts on multilingual expansion:\n- AI is an international field, and English sources are the most abundant, so English searches are essential\n- The development of AI is led by the US and China, so Chinese materials are also useful\n- Germany has advanced discussions on AI ethics, so German information is valuable for ethical aspects\n- Searching in the native language ensures a deeper understanding\n- Searching in different languages helps understand AI application cases from different cultural backgrounds\n</think>\nqueries: [\n  \"AI literacy beginner roadmap\",\n  \"artificial intelligence basics introductory books recommended\",\n  \"ChatGPT effective usage prompt design\",\n  \"AI literacy corporate training content\",\n  \"AI terms easy explanation beginner-friendly\",\n  \"AI literacy roadmap for professionals\",\n  \"artificial intelligence concepts explained simply\",\n  \"how to stay updated with AI developments\",\n  \"AI skills future-proof career\",\n  \"balancing technical and ethical AI knowledge\",\n  \"industry-specific AI applications examples\",\n  \"AI literacy learning path\",\n  \"AI basics for professionals\",\n  \"artificial intelligence ethical questions introduction\",\n  \"AI literacy career development practical guide\"\n]\n</example-3>\n</examples>\n\"#\n\nclass QueryRewriterOutput {\n  think string @description(\"Explain why you choose those search queries. Must in the first-person in 'lang:en'; in the style of 'curious and verbose'\")\n  queries string[] @description(\"Array of max 3 semantically unique queries that passed the deduplication process\")\n}\n\nfunction RewriteQuery(query: string, think: string, current_date: string) -> QueryRewriterOutput {\n  client SmartLLM\n\n  prompt #\"\n  You are an expert search query generator with deep psychological understanding. You optimize user queries by extensively analyzing potential user intents and generating comprehensive search variations.\n\n  {{Rules()}}\n\n  {{Examples()}}\n\n  Now, process this query:\n  Input Query: {{query}}\n\n  Current date: {{current_date}}\n\n  Let me think as a user: {{think}}\n\n  {{ctx.output_format}}\n  \"#    \n}\n\ntest rewrite_query {\n  functions [RewriteQuery]\n  args {\n    query \"I'm researching species that became invasive after people who kept them as pets released them. There's a certain species of fish that was popularized as a pet by being the main character of the movie Finding Nemo. According to the USGS, where was this fish found as a nonnative species, before the year 2020? I need the answer formatted as the five-digit zip codes of the places the species was found, separated by commas if there is more than one place.\"\n    think #\"Let me think as a user researching invasive species...\n\nSurface-level request:\n- I need to find where clownfish (the Finding Nemo fish) has been found as an invasive species\n- I specifically need this information from USGS data\n- I need the answer in a specific format (zip codes before 2020)\n\nDeeper research concerns:\n- I'm likely doing a research project or paper on invasive species\n- I'm focusing on pets that became invasive when released\n- I need precise, authoritative data for academic or policy purposes\n- I need to format my findings in a specific way for my research\n\nUnderlying academic needs:\n- I need to ensure my data is accurate and from an authoritative source\n- I need to be thorough in my research to avoid missing important information\n- I need to understand the geographic distribution of this invasive species\n- I may need to compare this with other invasive pet species\n\nExpert-level considerations:\n- What is the scientific name for the clownfish species in Finding Nemo?\n- How reliable is USGS data for tracking marine invasive species?\n- Are there other databases that might have more complete information?\n- What ecological impact has this species had in non-native environments?\n- What policy implications might this research have?\n\nSearch strategy considerations:\n- I should search for both 'clownfish' and the scientific name 'Amphiprion ocellaris'\n- I should specifically target USGS databases and reports\n- I should include terms related to invasive species, non-native species, and introduced species\n- I should look for data specifically formatted with location information\n- I should include temporal constraints to find data before 2020\"#\n    current_date \"2024-07-15\"\n  }\n}",
    "segment_extraction.baml": "class Passage {\n  text string @description(#\"\n    The passage containing numbered segments in the format <#1#>, <#2#>, etc.\n  \"#)\n  query string @description(#\"\n    The query to match against the passage segments.\n  \"#)\n}\n\nclass ExtractedSegments {\n  segment_list string @description(#\"\n    A comma-separated list of segment numbers or ranges (e.g. \"1,3,5-7\").\n    Format: Individual numbers separated by commas, or ranges using hyphens. Sorted by decreasing relevance.\n    Example: \"1,3,5-7\" represents segments 1, 3, 5, 6, and 7.\n  \"#)\n}\n\nfunction ExtractRelevantSegments(passage: Passage) -> ExtractedSegments {\n  client FastLLM\n  prompt #\"\n    {{ _.role(\"system\") }}You are an AI assistant specialized in analyzing text passages and extracting relevant segment numbers based on queries.\n\n    Given a PASSAGE containing segments numbered as <#1#>, <#2#>, <#3#>, etc., and a QUERY,\n    your task is to extract ONLY the segment numbers from the PASSAGE that are RELEVANT to the QUERY or USEFUL for the process of compressing the text.\n\n    Guidelines:\n    1. Analyze each segment carefully for relevance to the query\n    2. Include only segments that directly answer or relate to the query, or are USEFUL for the process of compressing the text\n    3. Present the segments in a comma-separated format, using ranges when appropriate\n    4. Use hyphens to indicate ranges (e.g. \"1-3\" for segments 1, 2, and 3)\n    5. Sort the segments by decreasing relevance\n    6. If no segments are relevant, return an empty string\n    7. If the passage contains code, return the full code section to the end of the code block\n    8. Note that redundant are preferred over wrong ignoring\n\n    {{ _.role(\"user\") }}\n    PASSAGE:\n    {{ passage.text }}\n\n    QUERY:\n    {{ passage.query }}\n\n    {{ ctx.output_format }}\n  \"#\n}\n\ntest extract_relevant_segments {\n  functions [ExtractRelevantSegments]\n  args {\n    passage {\n      text #\"\n        <#1#> The Python programming language was created by Guido van Rossum and was first released in 1991. \n        <#2#> Python emphasizes code readability with its notable use of significant whitespace.\n        <#3#> Python is dynamically typed and garbage-collected. \n        <#4#> It supports multiple programming paradigms, including structured, object-oriented, and functional programming.\n        <#5#> This is random text.\n        <#6#> Python's design philosophy emphasizes code readability with the use of significant indentation. \n        <#7#> Its language constructs and object-oriented approach aim to help programmers write clear, logical code for small and large-scale projects.\n      \"#\n      query \"What are the key features of Python programming language?\"\n    }\n  }\n} ",
}

def get_baml_files():
    return file_map