###############################################################################
#
#  Welcome to Baml! To use this generated code, please run the following:
#
#  $ pip install baml-py
#
###############################################################################

# This file was generated by BAML: please do not edit it. Instead, edit the
# BAML files and re-generate this code.
#
# ruff: noqa: E501,F401
# flake8: noqa: E501,F401
# pylint: disable=unused-import,line-too-long
# fmt: off
import baml_py
from enum import Enum
from pydantic import BaseModel, ConfigDict
from typing import Dict, Generic, List, Optional, TypeVar, Union, Literal

from . import types
from .types import Checked, Check

###############################################################################
#
#  These types are used for streaming, for when an instance of a type
#  is still being built up and any of its fields is not yet fully available.
#
###############################################################################

T = TypeVar('T')
class StreamState(BaseModel, Generic[T]):
    value: T
    state: Literal["Pending", "Incomplete", "Complete"]


class ActionWithThink(BaseModel):
    model_config = ConfigDict(extra='allow')
    thinking: Optional[str] = None
    action: Optional[Union["Search", "Answer", "Reflect", "Visit"]] = None

class AlternativeSearchResult(BaseModel):
    title: Optional[str] = None
    link: Optional[str] = None
    snippet: Optional[str] = None

class Answer(BaseModel):
    references: Optional[List["Reference"]] = None
    answer_text: Optional[str] = None

class AttributionAnalysis(BaseModel):
    think: Optional[str] = None
    pass_evaluation: Optional[bool] = None
    sources_provided: Optional[bool] = None
    sources_verified: Optional[bool] = None
    quotes_accurate: Optional[bool] = None

class BadContext(BaseModel):
    question: Optional[str] = None
    answer: Optional[str] = None
    evaluation: Optional[str] = None
    recap: Optional[str] = None
    blame: Optional[str] = None
    improvement: Optional[str] = None

class CompletenessAnalysis(BaseModel):
    think: Optional[str] = None
    pass_evaluation: Optional[bool] = None
    aspects_expected: Optional[str] = None
    aspects_provided: Optional[str] = None

class DedupOutput(BaseModel):
    think: Optional[str] = None
    unique_queries: List[str]

class DefinitiveAnalysis(BaseModel):
    think: Optional[str] = None
    pass_evaluation: Optional[bool] = None

class ErrorAnalysisOutput(BaseModel):
    recap: Optional[str] = None
    blame: Optional[str] = None
    improvement: Optional[str] = None
    next_search: List[str]

class ExtractedSegments(BaseModel):
    segment_list: Optional[str] = None

class FreshnessAnalysis(BaseModel):
    think: Optional[str] = None
    pass_evaluation: Optional[bool] = None
    days_ago: Optional[int] = None
    max_age_days: Optional[int] = None

class KnowledgeItem(BaseModel):
    question: Optional[str] = None
    answer: Optional[str] = None
    references: Optional[Union[List[Dict[str, Optional[str]]], Optional[List[str]]]] = None
    type: Optional[types.KnowledgeType] = None
    updated: Optional[str] = None

class Passage(BaseModel):
    text: Optional[str] = None
    query: Optional[str] = None

class PluralityAnalysis(BaseModel):
    think: Optional[str] = None
    pass_evaluation: Optional[bool] = None
    count_expected: Optional[int] = None
    count_provided: Optional[int] = None

class QueryRewriterOutput(BaseModel):
    think: Optional[str] = None
    queries: List[str]

class QuestionEvaluationOutput(BaseModel):
    think: Optional[str] = None
    needsFreshness: Optional[bool] = None
    needsPlurality: Optional[bool] = None
    needsCompleteness: Optional[bool] = None

class Reference(BaseModel):
    exactQuote: Optional[str] = None
    url: Optional[str] = None
    title: Optional[str] = None

class Reflect(BaseModel):
    questions_to_answer: List[str]

class ReportOutput(BaseModel):
    report: Optional[str] = None

class Search(BaseModel):
    search_requests: List[str]

class StandardSearchResult(BaseModel):
    title: Optional[str] = None
    url: Optional[str] = None
    description: Optional[str] = None

class Visit(BaseModel):
    urls: List[str]
