import { Construct } from '@aws-cdk/cdk';
import { IPrincipal, Policy } from './policy';
import { PolicyPrincipal, PolicyStatement } from './policy-document';
import { User } from './user';
export interface GroupProps {
    /**
     * A name for the IAM group. For valid values, see the GroupName parameter
     * for the CreateGroup action in the IAM API Reference. If you don't specify
     * a name, AWS CloudFormation generates a unique physical ID and uses that
     * ID for the group name.
     *
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     *
     * @default Generated by CloudFormation (recommended)
     */
    readonly groupName?: string;
    /**
     * A list of ARNs for managed policies associated with group.
     * @default No managed policies.
     */
    readonly managedPolicyArns?: any[];
    /**
     * The path to the group. For more information about paths, see [IAM
     * Identifiers](http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
     * in the IAM User Guide.
     */
    readonly path?: string;
}
export declare class Group extends Construct implements IPrincipal {
    /**
     * The runtime name of this group.
     */
    readonly groupName: string;
    /**
     * The ARN of this group.
     */
    readonly groupArn: string;
    /**
     * An "AWS" policy principal that represents this group.
     */
    readonly principal: PolicyPrincipal;
    private readonly managedPolicies;
    private readonly attachedPolicies;
    private defaultPolicy?;
    constructor(scope: Construct, id: string, props?: GroupProps);
    /**
     * Attaches a managed policy to this group.
     * @param arn The ARN of the managed policy to attach.
     */
    attachManagedPolicy(arn: string): void;
    /**
     * Attaches a policy to this group.
     * @param policy The policy to attach.
     */
    attachInlinePolicy(policy: Policy): void;
    /**
     * Adds a user to this group.
     */
    addUser(user: User): void;
    /**
     * Adds an IAM statement to the default policy.
     */
    addToPolicy(statement: PolicyStatement): void;
}
