import { Construct } from '@aws-cdk/cdk';
import { Group } from './group';
import { IPrincipal, Policy } from './policy';
import { PolicyPrincipal, PolicyStatement } from './policy-document';
export interface UserProps {
    /**
     * Groups to add this user to. You can also use `addToGroup` to add this
     * user to a group.
     */
    readonly groups?: Group[];
    /**
     * A list of ARNs for managed policies attacherd to this user.
     * You can use `addManagedPolicy(arn)` to attach a managed policy to this user.
     * @default No managed policies.
     */
    readonly managedPolicyArns?: any[];
    /**
     * The path for the user name. For more information about paths, see IAM
     * Identifiers in the IAM User Guide.
     */
    readonly path?: string;
    /**
     * A name for the IAM user. For valid values, see the UserName parameter for
     * the CreateUser action in the IAM API Reference. If you don't specify a
     * name, AWS CloudFormation generates a unique physical ID and uses that ID
     * for the user name.
     *
     * If you specify a name, you cannot perform updates that require
     * replacement of this resource. You can perform updates that require no or
     * some interruption. If you must replace the resource, specify a new name.
     *
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     *
     * @default Generated by CloudFormation (recommended)
     */
    readonly userName?: string;
    /**
     * The password for the user. This is required so the user can access the
     * AWS Management Console.
     *
     * @default User won't be able to access the management console without a password.
     */
    readonly password?: string;
    /**
     * Specifies whether the user is required to set a new password the next
     * time the user logs in to the AWS Management Console.
     *
     * If this is set to 'true', you must also specify "initialPassword".
     *
     * @default false
     */
    readonly passwordResetRequired?: boolean;
}
export declare class User extends Construct implements IPrincipal {
    /**
     * An attribute that represents the user name.
     */
    readonly userName: string;
    /**
     * An attribute that represents the user's ARN.
     */
    readonly userArn: string;
    /**
     * Returns the ARN of this user.
     */
    readonly principal: PolicyPrincipal;
    private readonly groups;
    private readonly managedPolicyArns;
    private readonly attachedPolicies;
    private defaultPolicy?;
    constructor(scope: Construct, id: string, props?: UserProps);
    /**
     * Adds this user to a group.
     */
    addToGroup(group: Group): void;
    /**
     * Attaches a managed policy to the user.
     * @param arn The ARN of the managed policy to attach.
     */
    attachManagedPolicy(arn: string): void;
    /**
     * Attaches a policy to this user.
     */
    attachInlinePolicy(policy: Policy): void;
    /**
     * Adds an IAM statement to the default policy.
     */
    addToPolicy(statement: PolicyStatement): void;
    private parseLoginProfile;
}
