"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdk = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
class ExampleConstruct extends cdk.Construct {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        const user = new lib_1.User(this, 'MyUser', { password: '1234' });
        const group = new lib_1.Group(this, 'MyGroup');
        const policy = new lib_1.Policy(this, 'MyPolicy');
        policy.attachToUser(user);
        group.attachInlinePolicy(policy);
        /// !hide
    }
}
exports.ExampleConstruct = ExampleConstruct;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXhhbXBsZS5hdHRhY2hpbmcubGl0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZXhhbXBsZS5hdHRhY2hpbmcubGl0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsb0NBQXFDO0FBQ3JDLGdDQUE2QztBQUU3QyxNQUFhLGdCQUFpQixTQUFRLEdBQUcsQ0FBQyxTQUFTO0lBQ2pELFlBQVksS0FBb0IsRUFBRSxFQUFVO1FBQzFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsU0FBUztRQUNULE1BQU0sSUFBSSxHQUFHLElBQUksVUFBSSxDQUFDLElBQUksRUFBRSxRQUFRLEVBQUUsRUFBRSxRQUFRLEVBQUUsTUFBTSxFQUFFLENBQUMsQ0FBQztRQUM1RCxNQUFNLEtBQUssR0FBRyxJQUFJLFdBQUssQ0FBQyxJQUFJLEVBQUUsU0FBUyxDQUFDLENBQUM7UUFFekMsTUFBTSxNQUFNLEdBQUcsSUFBSSxZQUFNLENBQUMsSUFBSSxFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBQzVDLE1BQU0sQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDMUIsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ2pDLFNBQVM7SUFDWCxDQUFDO0NBQ0Y7QUFiRCw0Q0FhQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBjZGsgPSByZXF1aXJlKCdAYXdzLWNkay9jZGsnKTtcbmltcG9ydCB7IEdyb3VwLCBQb2xpY3ksIFVzZXIgfSBmcm9tICcuLi9saWInO1xuXG5leHBvcnQgY2xhc3MgRXhhbXBsZUNvbnN0cnVjdCBleHRlbmRzIGNkay5Db25zdHJ1Y3Qge1xuICBjb25zdHJ1Y3RvcihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICAvLy8gIXNob3dcbiAgICBjb25zdCB1c2VyID0gbmV3IFVzZXIodGhpcywgJ015VXNlcicsIHsgcGFzc3dvcmQ6ICcxMjM0JyB9KTtcbiAgICBjb25zdCBncm91cCA9IG5ldyBHcm91cCh0aGlzLCAnTXlHcm91cCcpO1xuXG4gICAgY29uc3QgcG9saWN5ID0gbmV3IFBvbGljeSh0aGlzLCAnTXlQb2xpY3knKTtcbiAgICBwb2xpY3kuYXR0YWNoVG9Vc2VyKHVzZXIpO1xuICAgIGdyb3VwLmF0dGFjaElubGluZVBvbGljeShwb2xpY3kpO1xuICAgIC8vLyAhaGlkZVxuICB9XG59Il19