"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/cdk");
const iam = require("../lib");
module.exports = {
    'automatic exports are created when attributes are referneced across stacks'(test) {
        // GIVEN
        const stackWithUser = new cdk.Stack();
        const stackWithGroup = new cdk.Stack();
        const user = new iam.User(stackWithUser, 'User');
        const group = new iam.Group(stackWithGroup, 'Group');
        // WHEN
        group.addUser(user);
        //
        // `group.addUser` adds the group to the user resource definition, so we expect
        // that an automatic export will be created for the group and the user's stack
        // to use ImportValue to import it.
        // note that order of "expect"s matters. we first need to synthesize the user's
        // stack so that the cross stack reference will be reported and only then the
        // group's stack. in the real world, App will take care of this.
        //
        // THEN
        assert_1.expect(stackWithUser).toMatch({
            Resources: {
                User00B015A1: {
                    Type: "AWS::IAM::User",
                    Properties: {
                        Groups: [{ "Fn::ImportValue": "Stack:ExportsOutputRefGroupC77FDACD8CF7DD5B" }]
                    }
                }
            }
        });
        assert_1.expect(stackWithGroup).toMatch({
            Outputs: {
                ExportsOutputRefGroupC77FDACD8CF7DD5B: {
                    Value: { Ref: "GroupC77FDACD" },
                    Export: { Name: "Stack:ExportsOutputRefGroupC77FDACD8CF7DD5B" }
                }
            },
            Resources: {
                GroupC77FDACD: {
                    Type: "AWS::IAM::Group"
                }
            }
        });
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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