"use strict";
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
module.exports = {
    'default group'(test) {
        const app = new cdk_1.App();
        const stack = new cdk_1.Stack(app, 'MyStack');
        new lib_1.Group(stack, 'MyGroup');
        test.deepEqual(app.synthesizeStack(stack.name).template, {
            Resources: { MyGroupCBA54B1B: { Type: 'AWS::IAM::Group' } }
        });
        test.done();
    },
    'users can be added to the group either via `user.addToGroup` or `group.addUser`'(test) {
        const app = new cdk_1.App();
        const stack = new cdk_1.Stack(app, 'MyStack');
        const group = new lib_1.Group(stack, 'MyGroup');
        const user1 = new lib_1.User(stack, 'User1');
        const user2 = new lib_1.User(stack, 'User2');
        user1.addToGroup(group);
        group.addUser(user2);
        test.deepEqual(app.synthesizeStack(stack.name).template, { Resources: { MyGroupCBA54B1B: { Type: 'AWS::IAM::Group' },
                User1E278A736: { Type: 'AWS::IAM::User',
                    Properties: { Groups: [{ Ref: 'MyGroupCBA54B1B' }] } },
                User21F1486D1: { Type: 'AWS::IAM::User',
                    Properties: { Groups: [{ Ref: 'MyGroupCBA54B1B' }] } } } });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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