"use strict";
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
module.exports = {
    'default user'(test) {
        const app = new cdk_1.App();
        const stack = new cdk_1.Stack(app, 'MyStack');
        new lib_1.User(stack, 'MyUser');
        test.deepEqual(app.synthesizeStack(stack.name).template, {
            Resources: { MyUserDC45028B: { Type: 'AWS::IAM::User' } }
        });
        test.done();
    },
    'default user with password'(test) {
        const app = new cdk_1.App();
        const stack = new cdk_1.Stack(app, 'MyStack');
        new lib_1.User(stack, 'MyUser', {
            password: '1234'
        });
        test.deepEqual(app.synthesizeStack(stack.name).template, { Resources: { MyUserDC45028B: { Type: 'AWS::IAM::User',
                    Properties: { LoginProfile: { Password: '1234' } } } } });
        test.done();
    },
    'fails if reset password is required but no password is set'(test) {
        const app = new cdk_1.App();
        const stack = new cdk_1.Stack(app, 'MyStack');
        test.throws(() => new lib_1.User(stack, 'MyUser', { passwordResetRequired: true }));
        test.done();
    }
};
//# sourceMappingURL=data:application/json;base64,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