# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.27
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import date
from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr


class ArchiveDocument(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    id: Optional[StrictInt] = Field(
        None, description="Archive document unique identifier."
    )
    var_date: Optional[date] = Field(
        None, alias="date", description="Archive document date."
    )
    description: Optional[StrictStr] = Field(
        None, description="Archive Document description."
    )
    attachment_url: Optional[StrictStr] = Field(
        None,
        description="[Temporary] [Read Only] Absolute url of the attached file. Authomatically set if a valid attachment token is passed via POST /archive or PUT /archive/{documentId}.",
    )
    category: Optional[StrictStr] = Field(
        None, description="Archive document category."
    )
    attachment_token: Optional[StrictStr] = Field(
        None,
        description="[Write Only]  [Required] Attachment token returned by POST /archive/attachment. Used to attach the file already uploaded.",
    )
    __properties = [
        "id",
        "date",
        "description",
        "attachment_url",
        "category",
        "attachment_token",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ArchiveDocument:
        """Create an instance of ArchiveDocument from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(
            by_alias=True,
            exclude={
                "attachment_url",
            },
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ArchiveDocument:
        """Create an instance of ArchiveDocument from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ArchiveDocument.parse_obj(obj)

        _obj = ArchiveDocument.parse_obj(
            {
                "id": obj.get("id") if obj.get("id") is not None else None,
                "var_date": obj.get("date") if obj.get("date") is not None else None,
                "description": obj.get("description")
                if obj.get("description") is not None
                else None,
                "attachment_url": obj.get("attachment_url")
                if obj.get("attachment_url") is not None
                else None,
                "category": obj.get("category")
                if obj.get("category") is not None
                else None,
                "attachment_token": obj.get("attachment_token")
                if obj.get("attachment_token") is not None
                else None,
            }
        )
        return _obj
