# coding: utf-8

"""
    Fatture in Cloud API v2 - API Reference

    Connect your software with Fatture in Cloud, the invoicing platform chosen by more than 500.000 businesses in Italy.   The Fatture in Cloud API is based on REST, and makes possible to interact with the user related data prior authorization via OAuth2 protocol.  # noqa: E501

    The version of the OpenAPI document: 2.0.27
    Contact: info@fattureincloud.it
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr
from fattureincloud_python_sdk.models.vat_type import VatType


class ReceivedDocumentItemsListItem(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    id: Optional[StrictInt] = Field(None, description="Unique identifier.")
    product_id: Optional[StrictInt] = Field(
        None, description="Unique identifier of the product"
    )
    code: Optional[StrictStr] = Field(None, description="Product code.")
    name: Optional[StrictStr] = Field(None, description="Product name.")
    measure: Optional[StrictStr] = Field(None, description="Product measure.")
    net_price: Optional[StrictFloat] = Field(None, description="Product net price.")
    category: Optional[StrictStr] = Field(None, description="Product category.")
    qty: Optional[StrictFloat] = Field(None, description="Product quantity.")
    vat: Optional[VatType] = None
    stock: Optional[StrictFloat] = Field(None, description="Number of items in stock")
    __properties = [
        "id",
        "product_id",
        "code",
        "name",
        "measure",
        "net_price",
        "category",
        "qty",
        "vat",
        "stock",
    ]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ReceivedDocumentItemsListItem:
        """Create an instance of ReceivedDocumentItemsListItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True, exclude={}, exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of vat
        if self.vat:
            _dict["vat"] = self.vat.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ReceivedDocumentItemsListItem:
        """Create an instance of ReceivedDocumentItemsListItem from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ReceivedDocumentItemsListItem.parse_obj(obj)

        _obj = ReceivedDocumentItemsListItem.parse_obj(
            {
                "id": obj.get("id") if obj.get("id") is not None else None,
                "product_id": obj.get("product_id")
                if obj.get("product_id") is not None
                else None,
                "code": obj.get("code") if obj.get("code") is not None else None,
                "name": obj.get("name") if obj.get("name") is not None else None,
                "measure": obj.get("measure")
                if obj.get("measure") is not None
                else None,
                "net_price": float(obj.get("net_price"))
                if obj.get("net_price") is not None
                else None,
                "category": obj.get("category")
                if obj.get("category") is not None
                else None,
                "qty": float(obj.get("qty")) if obj.get("qty") is not None else None,
                "vat": VatType.from_dict(obj.get("vat"))
                if obj.get("vat") is not None
                else None,
                "stock": float(obj.get("stock"))
                if obj.get("stock") is not None
                else None,
            }
        )
        return _obj
