/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.clustering;

import java.util.LinkedList;
import java.util.List;

class Image {
    public List<double[]> features = new LinkedList<double[]>();
    public String identifier;
    public float[] localFeatureHistogram = null;
    private final int QUANT_MAX_HISTOGRAM = 256;

    Image(String identifier, List<double[]> features) {
        this.features.addAll(features);
        this.identifier = identifier;
    }

    public float[] getLocalFeatureHistogram() {
        return this.localFeatureHistogram;
    }

    public void setLocalFeatureHistogram(float[] localFeatureHistogram) {
        this.localFeatureHistogram = localFeatureHistogram;
    }

    public void initHistogram(int bins) {
        this.localFeatureHistogram = new float[bins];
        for (int i = 0; i < this.localFeatureHistogram.length; ++i) {
            this.localFeatureHistogram[i] = 0.0f;
        }
    }

    public void normalizeFeatureHistogram() {
        int i;
        float max = 0.0f;
        for (i = 0; i < this.localFeatureHistogram.length; ++i) {
            max = Math.max(this.localFeatureHistogram[i], max);
        }
        for (i = 0; i < this.localFeatureHistogram.length; ++i) {
            this.localFeatureHistogram[i] = this.localFeatureHistogram[i] * 256.0f / max;
        }
    }

    public void printHistogram() {
        for (int i = 0; i < this.localFeatureHistogram.length; ++i) {
            System.out.print(this.localFeatureHistogram[i] + " ");
        }
        System.out.println("");
    }
}

