/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.utils.MetricsUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class PHOG
implements LireFeature {
    static ColorConvertOp grayscale = new ColorConvertOp(ColorSpace.getInstance(1003), null);
    int[] tmp255 = new int[]{255};
    int[] tmp128 = new int[]{128};
    int[] tmp000 = new int[]{0};
    int[] tmpPixel = new int[]{0};
    int tmp;
    double thresholdLow = 60.0;
    double thresholdHigh = 100.0;
    public static int bins = 30;
    double[] tmpHistogram;
    byte[] histogram = new byte[bins + 4 * bins + 16 * bins];
    private double quantizationFactor = 15.0;

    @Override
    public void extract(BufferedImage bimg) {
        int i;
        int y;
        int x;
        int y2;
        int x2;
        double[][] gx = null;
        double[][] gy = null;
        BufferedImage gray = grayscale.filter(bimg, new BufferedImage(bimg.getWidth(), bimg.getHeight(), 10));
        gx = new double[gray.getWidth()][gray.getHeight()];
        gy = new double[gray.getWidth()][gray.getHeight()];
        PHOG.sobelFilter(gray, gx, gy);
        int width = gray.getWidth();
        int height = gray.getHeight();
        double[][] gd = new double[width][height];
        double[][] gm = new double[width][height];
        for (x2 = 0; x2 < width; ++x2) {
            for (y2 = 0; y2 < height; ++y2) {
                gd[x2][y2] = gx[x2][y2] != 0.0 ? Math.atan(gy[x2][y2] / gx[x2][y2]) : 1.5707963267948966;
                gm[x2][y2] = Math.sqrt(gy[x2][y2] * gy[x2][y2] + gx[x2][y2] * gx[x2][y2]);
            }
        }
        for (x2 = 0; x2 < width; ++x2) {
            gray.getRaster().setPixel(x2, 0, new int[]{255});
            gray.getRaster().setPixel(x2, height - 1, new int[]{255});
        }
        for (int y3 = 0; y3 < height; ++y3) {
            gray.getRaster().setPixel(0, y3, new int[]{255});
            gray.getRaster().setPixel(width - 1, y3, new int[]{255});
        }
        for (x2 = 1; x2 < width - 1; ++x2) {
            for (y2 = 1; y2 < height - 1; ++y2) {
                if (gd[x2][y2] < 0.39269908169872414 && gd[x2][y2] >= -0.39269908169872414) {
                    if (gm[x2][y2] > gm[x2 + 1][y2] && gm[x2][y2] > gm[x2 - 1][y2]) {
                        this.setPixel(x2, y2, gray, gm[x2][y2]);
                        continue;
                    }
                    gray.getRaster().setPixel(x2, y2, this.tmp255);
                    continue;
                }
                if (gd[x2][y2] < 1.1780972450961724 && gd[x2][y2] >= 0.39269908169872414) {
                    if (gm[x2][y2] > gm[x2 - 1][y2 - 1] && gm[x2][y2] > gm[x2 + 1][y2 + 1]) {
                        this.setPixel(x2, y2, gray, gm[x2][y2]);
                        continue;
                    }
                    gray.getRaster().setPixel(x2, y2, this.tmp255);
                    continue;
                }
                if (gd[x2][y2] < -1.1780972450961724 || gd[x2][y2] >= 1.1780972450961724) {
                    if (gm[x2][y2] > gm[x2][y2 + 1] && gm[x2][y2] > gm[x2][y2 - 1]) {
                        this.setPixel(x2, y2, gray, gm[x2][y2]);
                        continue;
                    }
                    gray.getRaster().setPixel(x2, y2, this.tmp255);
                    continue;
                }
                if (gd[x2][y2] < -0.39269908169872414 && gd[x2][y2] >= -1.1780972450961724) {
                    if (gm[x2][y2] > gm[x2 + 1][y2 - 1] && gm[x2][y2] > gm[x2 - 1][y2 + 1]) {
                        this.setPixel(x2, y2, gray, gm[x2][y2]);
                        continue;
                    }
                    gray.getRaster().setPixel(x2, y2, this.tmp255);
                    continue;
                }
                gray.getRaster().setPixel(x2, y2, this.tmp255);
            }
        }
        int[] tmp = new int[]{0};
        for (x = 1; x < width - 1; ++x) {
            for (y = 1; y < height - 1; ++y) {
                if (gray.getRaster().getPixel(x, y, tmp)[0] >= 50) continue;
                this.trackWeakOnes(x, y, gray);
            }
        }
        for (x = 2; x < width - 2; ++x) {
            for (y = 2; y < height - 2; ++y) {
                if (gray.getRaster().getPixel(x, y, tmp)[0] <= 50) continue;
                gray.getRaster().setPixel(x, y, this.tmp255);
            }
        }
        this.tmpHistogram = new double[bins + 4 * bins + 16 * bins];
        System.arraycopy(this.getHistogram(0, 0, width, height, gray, gd), 0, this.tmpHistogram, 0, bins);
        System.arraycopy(this.getHistogram(0, 0, width / 2, height / 2, gray, gd), 0, this.tmpHistogram, bins, bins);
        System.arraycopy(this.getHistogram(width / 2, 0, width / 2, height / 2, gray, gd), 0, this.tmpHistogram, 2 * bins, bins);
        System.arraycopy(this.getHistogram(0, height / 2, width / 2, height / 2, gray, gd), 0, this.tmpHistogram, 3 * bins, bins);
        System.arraycopy(this.getHistogram(width / 2, height / 2, width / 2, height / 2, gray, gd), 0, this.tmpHistogram, 4 * bins, bins);
        int wstep = width / 4;
        int hstep = height / 4;
        int binPos = 5;
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                System.arraycopy(this.getHistogram(i * wstep, j * hstep, wstep, hstep, gray, gd), 0, this.tmpHistogram, binPos * bins, bins);
                ++binPos;
            }
        }
        for (i = 0; i < this.tmpHistogram.length; ++i) {
            this.histogram[i] = (byte)this.tmpHistogram[i];
        }
    }

    private double[] getHistogram(int startX, int startY, int width, int height, BufferedImage gray, double[][] gd) {
        int i;
        int[] tmp = new int[]{0};
        double[] result = new double[bins];
        double actual = 0.0;
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = 0.0;
        }
        for (int x = startX; x < startX + width; ++x) {
            for (int y = startY; y < startY + height; ++y) {
                int bin;
                if (gray.getRaster().getPixel(x, y, tmp)[0] >= 50) continue;
                actual = (gd[x][y] / Math.PI + 0.5) * (double)bins;
                if (actual == Math.floor(actual)) {
                    bin = (int)Math.floor(actual);
                    if (bin == bins) {
                        bin = 0;
                    }
                    int n = bin;
                    result[n] = result[n] + 1.0;
                    continue;
                }
                bin = (int)Math.floor(actual);
                if (bin == bins) {
                    bin = 0;
                }
                int n = bin;
                result[n] = result[n] + (actual - Math.floor(actual));
                bin = (int)Math.ceil(actual);
                if (bin == bins) {
                    bin = 0;
                }
                int n2 = bin;
                result[n2] = result[n2] + (Math.ceil(actual) - actual);
            }
        }
        double max = 0.0;
        for (i = 0; i < result.length; ++i) {
            max = Math.max(result[i], max);
        }
        if (max > 0.0) {
            for (i = 0; i < result.length; ++i) {
                result[i] = Math.floor(this.quantizationFactor * result[i] / max);
                result[i] = Math.min(this.quantizationFactor, result[i]);
            }
        }
        return result;
    }

    private void trackWeakOnes(int x, int y, BufferedImage gray) {
        for (int xx = x - 1; xx <= x + 1; ++xx) {
            for (int yy = y - 1; yy <= y + 1; ++yy) {
                if (!this.isWeak(xx, yy, gray)) continue;
                gray.getRaster().setPixel(xx, yy, this.tmp000);
                this.trackWeakOnes(xx, yy, gray);
            }
        }
    }

    private boolean isWeak(int x, int y, BufferedImage gray) {
        return gray.getRaster().getPixel(x, y, this.tmpPixel)[0] > 0 && gray.getRaster().getPixel(x, y, this.tmpPixel)[0] < 255;
    }

    private void setPixel(int x, int y, BufferedImage gray, double v) {
        if (v > this.thresholdLow) {
            gray.getRaster().setPixel(x, y, this.tmp000);
        } else if (v > this.thresholdHigh) {
            gray.getRaster().setPixel(x, y, this.tmp128);
        } else {
            gray.getRaster().setPixel(x, y, this.tmp255);
        }
    }

    private static void sobelFilter(BufferedImage gray, double[][] gx, double[][] gy) {
        int x;
        int[] tmp = new int[4];
        int tmpSumX = 0;
        int tmpSumY = 0;
        for (x = 1; x < gray.getWidth() - 1; ++x) {
            for (int y = 1; y < gray.getHeight() - 1; ++y) {
                tmpSumX = 0;
                tmpSumY = 0;
                int pix = gray.getRaster().getPixel(x - 1, y - 1, tmp)[0];
                tmpSumX += pix;
                tmpSumY += pix;
                pix = gray.getRaster().getPixel(x - 1, y, tmp)[0];
                tmpSumX += 2 * pix;
                pix = gray.getRaster().getPixel(x - 1, y + 1, tmp)[0];
                tmpSumX += pix;
                tmpSumY -= pix;
                pix = gray.getRaster().getPixel(x + 1, y - 1, tmp)[0];
                tmpSumX -= pix;
                tmpSumY += pix;
                pix = gray.getRaster().getPixel(x + 1, y, tmp)[0];
                tmpSumX -= 2 * pix;
                pix = gray.getRaster().getPixel(x + 1, y + 1, tmp)[0];
                tmpSumY -= pix;
                gx[x][y] = tmpSumX -= pix;
                tmpSumY += 2 * gray.getRaster().getPixel(x, y - 1, tmp)[0];
                gy[x][y] = tmpSumY -= 2 * gray.getRaster().getPixel(x, y + 1, tmp)[0];
            }
        }
        for (x = 0; x < gray.getWidth(); ++x) {
            gx[x][0] = 0.0;
            gx[x][gray.getHeight() - 1] = 0.0;
            gy[x][0] = 0.0;
            gy[x][gray.getHeight() - 1] = 0.0;
        }
        for (int y = 0; y < gray.getHeight(); ++y) {
            gx[0][y] = 0.0;
            gx[gray.getWidth() - 1][y] = 0.0;
            gy[0][y] = 0.0;
            gy[gray.getWidth() - 1][y] = 0.0;
        }
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        byte[] result = new byte[this.histogram.length / 2];
        for (int i = 0; i < result.length; ++i) {
            this.tmp = this.histogram[i << 1] << 4;
            this.tmp |= this.histogram[(i << 1) + 1];
            result[i] = (byte)(this.tmp - 128);
        }
        return result;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.setByteArrayRepresentation(in, 0, in.length);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.tmp = in[i + offset] + 128;
            this.histogram[(i << 1) + 1] = (byte)(this.tmp & 0xF);
            this.histogram[i << 1] = (byte)(this.tmp >> 4);
        }
    }

    @Override
    public double[] getDoubleHistogram() {
        return SerializationUtils.castToDoubleArray(this.histogram);
    }

    @Override
    public float getDistance(LireFeature feature) {
        return (float)MetricsUtils.distL1(this.histogram, ((PHOG)feature).histogram);
    }

    @Override
    public String getStringRepresentation() {
        return null;
    }

    @Override
    public void setStringRepresentation(String s) {
    }

    @Override
    public String getFeatureName() {
        return "PHOG";
    }

    @Override
    public String getFieldName() {
        return "featPHOG";
    }
}

