/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.bovw;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.ProgressMonitor;
import net.semanticmetadata.lire.clustering.Cluster;
import net.semanticmetadata.lire.clustering.KMeans;
import net.semanticmetadata.lire.clustering.ParallelKMeans;
import net.semanticmetadata.lire.imageanalysis.Histogram;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.utils.LuceneUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.Bits;

public abstract class LocalFeatureHistogramBuilder {
    IndexReader reader;
    private int numDocsForVocabulary = 100;
    private int numClusters = 512;
    private Cluster[] clusters = null;
    DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance();
    private ProgressMonitor pm = null;
    protected String localFeatureFieldName = "featureSurf";
    protected String visualWordsFieldName = "featureSurfHistogramVWords";
    protected String localFeatureHistFieldName = "featureSURFHistogram";
    protected String clusterFile = "./clusters.dat";
    public static boolean DELETE_LOCAL_FEATURES = true;
    private boolean useParallelClustering = true;

    public LocalFeatureHistogramBuilder(IndexReader reader) {
        this.reader = reader;
    }

    public LocalFeatureHistogramBuilder(IndexReader reader, int numDocsForVocabulary) {
        this.reader = reader;
        this.numDocsForVocabulary = numDocsForVocabulary;
    }

    public LocalFeatureHistogramBuilder(IndexReader reader, int numDocsForVocabulary, int numClusters) {
        this.numDocsForVocabulary = numDocsForVocabulary;
        this.numClusters = numClusters;
        this.reader = reader;
    }

    public void index() throws IOException {
        this.df.setMaximumFractionDigits(3);
        HashSet<Integer> docIDs = this.selectVocabularyDocs();
        KMeans k = this.useParallelClustering ? new ParallelKMeans(this.numClusters) : new KMeans(this.numClusters);
        LinkedList<double[]> features = new LinkedList<double[]>();
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)this.reader);
        for (int nextDoc : docIDs) {
            if (this.reader.hasDeletions() && !liveDocs.get(nextDoc)) continue;
            Document d = this.reader.document(nextDoc);
            features.clear();
            IndexableField[] fields = d.getFields(this.localFeatureFieldName);
            String file = d.getValues("descriptorImageIdentifier")[0];
            for (int j = 0; j < fields.length; ++j) {
                LireFeature f = this.getFeatureInstance();
                f.setByteArrayRepresentation(fields[j].binaryValue().bytes, fields[j].binaryValue().offset, fields[j].binaryValue().length);
                features.add(((Histogram)((Object)f)).descriptor);
            }
            k.addImage(file, features);
        }
        if (this.pm != null) {
            this.pm.setProgress(5);
            this.pm.setNote("Starting clustering");
        }
        if (k.getFeatureCount() < this.numClusters) {
            throw new UnsupportedOperationException("Only " + features.size() + " features found to cluster in " + this.numClusters + ". Try to use less clusters or more images.");
        }
        System.out.println("k.getFeatureCount() = " + k.getFeatureCount());
        System.out.println("Starting clustering ...");
        k.init();
        System.out.println("Step.");
        double time = System.currentTimeMillis();
        double laststress = k.clusteringStep();
        if (this.pm != null) {
            this.pm.setProgress(8);
            this.pm.setNote("Step 1 finished");
        }
        System.out.println(this.getDuration(time) + " -> Next step.");
        time = System.currentTimeMillis();
        double newStress = k.clusteringStep();
        if (this.pm != null) {
            this.pm.setProgress(11);
            this.pm.setNote("Step 2 finished");
        }
        double threshold = Math.max(20.0, (double)k.getFeatureCount() / 1000.0);
        System.out.println("Threshold = " + threshold);
        int cstep = 3;
        while (Math.abs(newStress - laststress) > threshold) {
            System.out.println(this.getDuration(time) + " -> Next step. Stress difference ~ |" + (int)newStress + " - " + (int)laststress + "| = " + this.df.format(Math.abs(newStress - laststress)));
            time = System.currentTimeMillis();
            laststress = newStress;
            newStress = k.clusteringStep();
            if (this.pm != null) {
                this.pm.setProgress(cstep * 3 + 5);
                this.pm.setNote("Step " + cstep + " finished");
            }
            ++cstep;
        }
        this.clusters = k.getClusters();
        Cluster.writeClusters(this.clusters, this.clusterFile);
        System.out.println("Creating histograms ...");
        time = System.currentTimeMillis();
        int[] tmpHist = new int[this.numClusters];
        IndexWriter iw = LuceneUtils.createIndexWriter(((DirectoryReader)this.reader).directory(), true, LuceneUtils.AnalyzerType.WhitespaceAnalyzer, 256.0);
        if (this.pm != null) {
            this.pm.setProgress(50);
            this.pm.setNote("Clustering finished");
        }
        LinkedList<Thread> threads = new LinkedList<Thread>();
        int numThreads = 4;
        int step = this.reader.maxDoc() / numThreads;
        for (int part = 0; part < numThreads; ++part) {
            Indexer indexer = null;
            indexer = part < numThreads - 1 ? new Indexer(part * step, (part + 1) * step, iw, null) : new Indexer(part * step, this.reader.maxDoc(), iw, this.pm);
            Thread t = new Thread(indexer);
            threads.add(t);
            t.start();
        }
        for (Thread next : threads) {
            try {
                next.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.pm != null) {
            this.pm.setProgress(95);
            this.pm.setNote("Indexing finished, optimizing index now.");
        }
        System.out.println(this.getDuration(time));
        iw.commit();
        iw.forceMerge(1);
        iw.close();
        if (this.pm != null) {
            this.pm.setProgress(100);
            this.pm.setNote("Indexing & optimization finished");
            this.pm.close();
        }
        System.out.println("Finished.");
    }

    public void indexMissing() throws IOException {
        this.clusters = Cluster.readClusters(this.clusterFile);
        System.out.println("Creating histograms ...");
        int[] tmpHist = new int[this.numClusters];
        LireFeature f = this.getFeatureInstance();
        IndexWriter iw = LuceneUtils.createIndexWriter(((DirectoryReader)this.reader).directory(), false, LuceneUtils.AnalyzerType.WhitespaceAnalyzer);
        for (int i = 0; i < this.reader.maxDoc(); ++i) {
            for (int j = 0; j < tmpHist.length; ++j) {
                tmpHist[j] = 0;
            }
            Document d = this.reader.document(i);
            if (d.getValues(this.visualWordsFieldName) != null && d.getValues(this.visualWordsFieldName).length != 0) continue;
            IndexableField[] fields = d.getFields(this.localFeatureFieldName);
            for (int j = 0; j < fields.length; ++j) {
                f.setByteArrayRepresentation(fields[j].binaryValue().bytes, fields[j].binaryValue().offset, fields[j].binaryValue().length);
                int n = this.clusterForFeature((Histogram)((Object)f));
                tmpHist[n] = tmpHist[n] + 1;
            }
            this.normalize(tmpHist);
            d.add((IndexableField)new TextField(this.visualWordsFieldName, this.arrayToVisualWordString(tmpHist), Field.Store.YES));
            d.add((IndexableField)new StringField(this.localFeatureHistFieldName, SerializationUtils.arrayToString(tmpHist), Field.Store.YES));
            iw.updateDocument(new Term("descriptorImageIdentifier", d.getValues("descriptorImageIdentifier")[0]), (Iterable)d);
        }
        iw.commit();
        iw.close();
        System.out.println("Finished.");
    }

    public Document getVisualWords(Document d) throws IOException {
        this.clusters = Cluster.readClusters(this.clusterFile);
        int[] tmpHist = new int[this.clusters.length];
        LireFeature f = this.getFeatureInstance();
        IndexableField[] fields = d.getFields(this.localFeatureFieldName);
        for (int j = 0; j < fields.length; ++j) {
            f.setByteArrayRepresentation(fields[j].binaryValue().bytes, fields[j].binaryValue().offset, fields[j].binaryValue().length);
            int n = this.clusterForFeature((Histogram)((Object)f));
            tmpHist[n] = tmpHist[n] + 1;
        }
        this.normalize(tmpHist);
        d.add((IndexableField)new TextField(this.visualWordsFieldName, this.arrayToVisualWordString(tmpHist), Field.Store.YES));
        d.add((IndexableField)new StringField(this.localFeatureHistFieldName, SerializationUtils.arrayToString(tmpHist), Field.Store.YES));
        d.removeFields(this.localFeatureFieldName);
        return d;
    }

    private void normalize(int[] histogram) {
        int i;
        int max = 0;
        for (i = 0; i < histogram.length; ++i) {
            max = Math.max(max, histogram[i]);
        }
        for (i = 0; i < histogram.length; ++i) {
            histogram[i] = (int)Math.floor((double)histogram[i] * 15.0 / (double)max);
        }
    }

    private int clusterForFeature(Histogram f) {
        double distance = this.clusters[0].getDistance(f);
        int result = 0;
        for (int i = 1; i < this.clusters.length; ++i) {
            double tmp = this.clusters[i].getDistance(f);
            if (!(tmp < distance)) continue;
            distance = tmp;
            result = i;
        }
        return result;
    }

    private String arrayToVisualWordString(int[] hist) {
        StringBuilder sb = new StringBuilder(1024);
        for (int i = 0; i < hist.length; ++i) {
            int visualWordIndex = hist[i];
            for (int j = 0; j < visualWordIndex; ++j) {
                sb.append('v');
                sb.append(i);
                sb.append(' ');
            }
        }
        return sb.toString();
    }

    private HashSet<Integer> selectVocabularyDocs() throws IOException {
        int loopCount = 0;
        float maxDocs = this.reader.maxDoc();
        int capacity = (int)Math.min((float)this.numDocsForVocabulary, maxDocs - 5.0f);
        if (capacity < 0) {
            capacity = (int)(maxDocs / 2.0f);
        }
        HashSet<Integer> result = new HashSet<Integer>(capacity);
        LinkedList<Integer> docCandidates = new LinkedList<Integer>();
        int i = 0;
        while ((float)i < maxDocs) {
            docCandidates.add(i);
            ++i;
        }
        for (int r = 0; r < capacity; ++r) {
            int tmpDocNumber;
            boolean worksFine = false;
            do {
                int tmpIndex = (int)Math.floor(Math.random() * (double)docCandidates.size());
                tmpDocNumber = (Integer)docCandidates.get(tmpIndex);
                docCandidates.remove(tmpIndex);
            } while (!(worksFine = this.reader.document(tmpDocNumber) != null && !result.contains(tmpDocNumber)));
            result.add(tmpDocNumber);
            if (loopCount++ <= capacity * 100) continue;
            throw new UnsupportedOperationException("Could not get the documents, maybe there are not enough documents in the index?");
        }
        return result;
    }

    protected abstract LireFeature getFeatureInstance();

    private String getDuration(double time) {
        double min = ((double)System.currentTimeMillis() - time) / 60000.0;
        double sec = (min - Math.floor(min)) * 60.0;
        return String.format("%02d:%02d", (int)min, (int)sec);
    }

    public void setProgressMonitor(ProgressMonitor pm) {
        this.pm = pm;
    }

    public boolean getUseParallelClustering() {
        return this.useParallelClustering;
    }

    public void setUseParallelClustering(boolean useParallelClustering) {
        this.useParallelClustering = useParallelClustering;
    }

    private class Indexer
    implements Runnable {
        int start;
        int end;
        IndexWriter iw;
        ProgressMonitor pm = null;

        private Indexer(int start, int end, IndexWriter iw, ProgressMonitor pm) {
            this.start = start;
            this.end = end;
            this.iw = iw;
            this.pm = pm;
        }

        @Override
        public void run() {
            int[] tmpHist = new int[LocalFeatureHistogramBuilder.this.numClusters];
            LireFeature f = LocalFeatureHistogramBuilder.this.getFeatureInstance();
            for (int i = this.start; i < this.end; ++i) {
                try {
                    for (int j = 0; j < tmpHist.length; ++j) {
                        tmpHist[j] = 0;
                    }
                    Document d = LocalFeatureHistogramBuilder.this.reader.document(i);
                    IndexableField[] fields = d.getFields(LocalFeatureHistogramBuilder.this.localFeatureFieldName);
                    d.removeField(LocalFeatureHistogramBuilder.this.visualWordsFieldName);
                    d.removeField(LocalFeatureHistogramBuilder.this.localFeatureHistFieldName);
                    for (int j = 0; j < fields.length; ++j) {
                        f.setByteArrayRepresentation(fields[j].binaryValue().bytes, fields[j].binaryValue().offset, fields[j].binaryValue().length);
                        int n = LocalFeatureHistogramBuilder.this.clusterForFeature((Histogram)((Object)f));
                        tmpHist[n] = tmpHist[n] + 1;
                    }
                    LocalFeatureHistogramBuilder.this.normalize(tmpHist);
                    d.add((IndexableField)new TextField(LocalFeatureHistogramBuilder.this.visualWordsFieldName, LocalFeatureHistogramBuilder.this.arrayToVisualWordString(tmpHist), Field.Store.YES));
                    d.add((IndexableField)new StringField(LocalFeatureHistogramBuilder.this.localFeatureHistFieldName, SerializationUtils.arrayToString(tmpHist), Field.Store.YES));
                    if (DELETE_LOCAL_FEATURES) {
                        d.removeFields(LocalFeatureHistogramBuilder.this.localFeatureFieldName);
                    }
                    this.iw.updateDocument(new Term("descriptorImageIdentifier", d.getValues("descriptorImageIdentifier")[0]), (Iterable)d);
                    if (this.pm == null) continue;
                    double len = this.end - this.start;
                    double percent = (double)(i - this.start) / len * 45.0 + 50.0;
                    this.pm.setProgress((int)percent);
                    this.pm.setNote("Creating visual words, ~" + (int)percent + "% finished");
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

