/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.filters;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import net.semanticmetadata.lire.utils.ImageUtils;

public class CannyEdgeDetector {
    static ConvolveOp gaussian = new ConvolveOp(new Kernel(5, 5, ImageUtils.makeGaussianKernel(5, 1.4f)));
    static ColorConvertOp grayscale = new ColorConvertOp(ColorSpace.getInstance(1003), null);
    int[] tmp255 = new int[]{255};
    int[] tmp128 = new int[]{128};
    int[] tmp000 = new int[]{0};
    int[] tmpPixel = new int[]{0};
    double thresholdLow = 60.0;
    double thresholdHigh = 100.0;
    BufferedImage bimg;

    public CannyEdgeDetector(BufferedImage image, double thresholdHigh, double thresholdLow) {
        this.bimg = image;
        this.thresholdHigh = thresholdHigh;
        this.thresholdLow = thresholdLow;
    }

    public CannyEdgeDetector(BufferedImage bimg) {
        this.bimg = bimg;
    }

    public BufferedImage filter() {
        int y;
        int x;
        int y2;
        int x2;
        BufferedImage gray = grayscale.filter(this.bimg, null);
        gray = gaussian.filter(gray, null);
        double[][] gx = this.sobelFilterX(gray);
        double[][] gy = this.sobelFilterY(gray);
        int width = gray.getWidth();
        int height = gray.getHeight();
        double[][] gd = new double[width][height];
        double[][] gm = new double[width][height];
        for (x2 = 0; x2 < width; ++x2) {
            for (y2 = 0; y2 < height; ++y2) {
                gd[x2][y2] = gx[x2][y2] != 0.0 ? Math.atan(gy[x2][y2] / gx[x2][y2]) : 1.5707963267948966;
                gm[x2][y2] = Math.sqrt(gy[x2][y2] * gy[x2][y2] + gx[x2][y2] * gx[x2][y2]);
            }
        }
        for (x2 = 0; x2 < width; ++x2) {
            gray.getRaster().setPixel(x2, 0, new int[]{255});
            gray.getRaster().setPixel(x2, height - 1, new int[]{255});
        }
        for (int y3 = 0; y3 < height; ++y3) {
            gray.getRaster().setPixel(0, y3, new int[]{255});
            gray.getRaster().setPixel(width - 1, y3, new int[]{255});
        }
        for (x2 = 1; x2 < width - 1; ++x2) {
            for (y2 = 1; y2 < height - 1; ++y2) {
                if (gd[x2][y2] < 0.39269908169872414 && gd[x2][y2] >= -0.39269908169872414) {
                    if (gm[x2][y2] > gm[x2 + 1][y2] && gm[x2][y2] > gm[x2 - 1][y2]) {
                        this.setPixel(x2, y2, gray, gm[x2][y2]);
                        continue;
                    }
                    gray.getRaster().setPixel(x2, y2, this.tmp255);
                    continue;
                }
                if (gd[x2][y2] < 1.1780972450961724 && gd[x2][y2] >= 0.39269908169872414) {
                    if (gm[x2][y2] > gm[x2 - 1][y2 - 1] && gm[x2][y2] > gm[x2 + 1][y2 + 1]) {
                        this.setPixel(x2, y2, gray, gm[x2][y2]);
                        continue;
                    }
                    gray.getRaster().setPixel(x2, y2, this.tmp255);
                    continue;
                }
                if (gd[x2][y2] < -1.1780972450961724 || gd[x2][y2] >= 1.1780972450961724) {
                    if (gm[x2][y2] > gm[x2][y2 + 1] && gm[x2][y2] > gm[x2][y2 - 1]) {
                        this.setPixel(x2, y2, gray, gm[x2][y2]);
                        continue;
                    }
                    gray.getRaster().setPixel(x2, y2, this.tmp255);
                    continue;
                }
                if (gd[x2][y2] < -0.39269908169872414 && gd[x2][y2] >= -1.1780972450961724) {
                    if (gm[x2][y2] > gm[x2 + 1][y2 - 1] && gm[x2][y2] > gm[x2 - 1][y2 + 1]) {
                        this.setPixel(x2, y2, gray, gm[x2][y2]);
                        continue;
                    }
                    gray.getRaster().setPixel(x2, y2, this.tmp255);
                    continue;
                }
                gray.getRaster().setPixel(x2, y2, this.tmp255);
            }
        }
        int[] tmp = new int[]{0};
        for (x = 1; x < width - 1; ++x) {
            for (y = 1; y < height - 1; ++y) {
                if (gray.getRaster().getPixel(x, y, tmp)[0] >= 50) continue;
                this.trackWeakOnes(x, y, gray);
            }
        }
        for (x = 2; x < width - 2; ++x) {
            for (y = 2; y < height - 2; ++y) {
                if (gray.getRaster().getPixel(x, y, tmp)[0] <= 50) continue;
                gray.getRaster().setPixel(x, y, this.tmp255);
            }
        }
        return gray;
    }

    private void trackWeakOnes(int x, int y, BufferedImage gray) {
        for (int xx = x - 1; xx <= x + 1; ++xx) {
            for (int yy = y - 1; yy <= y + 1; ++yy) {
                if (!this.isWeak(xx, yy, gray)) continue;
                gray.getRaster().setPixel(xx, yy, this.tmp000);
                this.trackWeakOnes(xx, yy, gray);
            }
        }
    }

    private boolean isWeak(int x, int y, BufferedImage gray) {
        return gray.getRaster().getPixel(x, y, this.tmpPixel)[0] > 0 && gray.getRaster().getPixel(x, y, this.tmpPixel)[0] < 255;
    }

    private void setPixel(int x, int y, BufferedImage gray, double v) {
        if (v > this.thresholdLow) {
            gray.getRaster().setPixel(x, y, this.tmp000);
        } else if (v > this.thresholdHigh) {
            gray.getRaster().setPixel(x, y, this.tmp128);
        } else {
            gray.getRaster().setPixel(x, y, this.tmp255);
        }
    }

    private double[][] sobelFilterX(BufferedImage gray) {
        int x;
        double[][] result = new double[gray.getWidth()][gray.getHeight()];
        int[] tmp = new int[1];
        for (x = 1; x < gray.getWidth() - 1; ++x) {
            for (int y = 1; y < gray.getHeight() - 1; ++y) {
                int tmpSum = 0;
                tmpSum += gray.getRaster().getPixel(x - 1, y - 1, tmp)[0];
                tmpSum += 2 * gray.getRaster().getPixel(x - 1, y, tmp)[0];
                tmpSum += gray.getRaster().getPixel(x - 1, y + 1, tmp)[0];
                tmpSum -= gray.getRaster().getPixel(x + 1, y - 1, tmp)[0];
                tmpSum -= 2 * gray.getRaster().getPixel(x + 1, y, tmp)[0];
                result[x][y] = tmpSum -= gray.getRaster().getPixel(x + 1, y + 1, tmp)[0];
            }
        }
        for (x = 0; x < gray.getWidth(); ++x) {
            result[x][0] = 0.0;
            result[x][gray.getHeight() - 1] = 0.0;
        }
        for (int y = 0; y < gray.getHeight(); ++y) {
            result[0][y] = 0.0;
            result[gray.getWidth() - 1][y] = 0.0;
        }
        return result;
    }

    private double[][] sobelFilterY(BufferedImage gray) {
        int x;
        double[][] result = new double[gray.getWidth()][gray.getHeight()];
        int[] tmp = new int[1];
        int tmpSum = 0;
        for (x = 1; x < gray.getWidth() - 1; ++x) {
            for (int y = 1; y < gray.getHeight() - 1; ++y) {
                tmpSum = 0;
                tmpSum += gray.getRaster().getPixel(x - 1, y - 1, tmp)[0];
                tmpSum += 2 * gray.getRaster().getPixel(x, y - 1, tmp)[0];
                tmpSum += gray.getRaster().getPixel(x + 1, y - 1, tmp)[0];
                tmpSum -= gray.getRaster().getPixel(x - 1, y + 1, tmp)[0];
                tmpSum -= 2 * gray.getRaster().getPixel(x, y + 1, tmp)[0];
                result[x][y] = tmpSum -= gray.getRaster().getPixel(x + 1, y + 1, tmp)[0];
            }
        }
        for (x = 0; x < gray.getWidth(); ++x) {
            result[x][0] = 0.0;
            result[x][gray.getHeight() - 1] = 0.0;
        }
        for (int y = 0; y < gray.getHeight(); ++y) {
            result[0][y] = 0.0;
            result[gray.getWidth() - 1][y] = 0.0;
        }
        return result;
    }
}

