/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.filters;

public class DecimateDownSampler {
    private final int width;
    private final int height;
    private final int stride;
    private final int offset;
    private final int factor;

    public DecimateDownSampler(int width, int height) {
        this(width, height, width, 0, 2);
    }

    public DecimateDownSampler(int width, int height, int factor) {
        this(width, height, width, 0, factor);
    }

    public DecimateDownSampler(int width, int height, int stride, int offset, int factor) {
        if (height < 8) {
            throw new IllegalArgumentException("The height must be at least 8");
        }
        if (width < 8) {
            throw new IllegalArgumentException("The width must be at least 8");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("The offset must be at least 0");
        }
        if (stride < width) {
            throw new IllegalArgumentException("The stride must be at least as big as the width");
        }
        if (factor < 2) {
            throw new IllegalArgumentException("This implementation only supports a scaling factor greater than or equal to 2");
        }
        this.height = height;
        this.width = width;
        this.stride = stride;
        this.offset = offset;
        this.factor = factor;
    }

    public void subSampleHorizontal(int[] input, int[] output) {
        int w = this.width;
        int inc = this.factor;
        int st = this.stride;
        int iOffs = this.offset;
        int oOffs = 0;
        for (int j = this.height; j > 0; --j) {
            int end = iOffs + w;
            for (int i = iOffs; i < end; i += inc) {
                output[oOffs++] = input[i];
            }
            iOffs += st;
        }
    }

    public void subSampleVertical(int[] input, int[] output) {
        int w = this.width;
        int inc = this.factor;
        int stn = this.stride * inc;
        int iOffs = this.offset;
        int oOffs = 0;
        for (int j = this.height; j > 0; j -= inc) {
            System.arraycopy(input, iOffs, output, oOffs, w);
            iOffs += stn;
        }
    }

    public void subSample(int[] input, int[] output) {
        int w = this.width;
        int inc = this.factor;
        int stn = this.stride * inc;
        int iOffs = this.offset;
        int oOffs = 0;
        for (int j = this.height; j > 0; j -= inc) {
            int end = iOffs + w;
            for (int i = iOffs; i < end; i += inc) {
                output[oOffs++] = input[i];
            }
            iOffs += stn;
        }
    }

    public boolean supportsScalingFactor(int factor) {
        return factor >= 2;
    }
}

