/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.filters;

import net.semanticmetadata.lire.imageanalysis.filters.DecimateDownSampler;
import net.semanticmetadata.lire.imageanalysis.filters.IndexedIntArray;

public final class FastBilateralFilter {
    private final int width;
    private final int height;
    private final int stride;
    private final int downSampling;
    private final int radius;
    private final float[] box;
    private final float[][] jk;
    private final float[] wk;
    private final float[] grayscale;
    private final int[] colors;
    private final int[] buffer1;
    private final int[] buffer2;
    private final int channels;

    public FastBilateralFilter(int width, int height, float sigmaR, float sigmaD) {
        this(width, height, width, sigmaR, sigmaD, 4, 3, 3);
    }

    public FastBilateralFilter(int width, int height, int stride, float sigmaR, float sigmaD) {
        this(width, height, stride, sigmaR, sigmaD, 4, 3, 3);
    }

    public FastBilateralFilter(int width, int height, int stride, float sigmaR, float sigmaD, int rangeSampling, int downSampling, int channels) {
        if (height < 8) {
            throw new IllegalArgumentException("The height must be at least 8");
        }
        if (width < 8) {
            throw new IllegalArgumentException("The width must be at least 8");
        }
        if (stride < 8) {
            throw new IllegalArgumentException("The stride must be at least 8");
        }
        if (downSampling < 0 || downSampling > 3) {
            throw new IllegalArgumentException("The down sampling factor must be in [0..3]");
        }
        if (rangeSampling < 1 || downSampling > 5) {
            throw new IllegalArgumentException("The range sampling factor must be in [1..5]");
        }
        if (sigmaR < 1.0f && sigmaR > 32.0f) {
            throw new IllegalArgumentException("The range sigma must be in [1..32]");
        }
        if (sigmaD < 1.0f && sigmaD > 32.0f) {
            throw new IllegalArgumentException("The distance sigma must be in [1..32]");
        }
        if (channels < 1 || channels > 3) {
            throw new IllegalArgumentException("The number of image channels must be in [1..3]");
        }
        this.height = height;
        this.width = width;
        this.stride = stride;
        int adjust = (1 << downSampling) - 1;
        int scaledH = height + adjust >> downSampling;
        int scaledW = width + adjust >> downSampling;
        this.box = new float[scaledW * scaledH];
        this.jk = new float[][]{new float[scaledW * scaledH], new float[scaledW * scaledH]};
        this.wk = new float[scaledW * scaledH];
        this.channels = channels;
        this.downSampling = downSampling;
        this.grayscale = new float[rangeSampling];
        this.radius = (int)((2.0f * sigmaD * (float)Math.min(scaledW, scaledH) + 1.0f) / 2.0f);
        this.buffer1 = new int[scaledH * scaledW];
        this.buffer2 = new int[scaledH * scaledW];
        this.colors = new int[256];
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = (int)(256.0 * Math.exp(-((float)(i * i)) / (2.0f * sigmaR * sigmaR)));
        }
    }

    private static void gaussianRecursiveX(float[] od, float[] id, int w, int h, float a0, float a1, float a2, float a3, float b1, float b2, float coefp, float coefn) {
        int offs = 0;
        for (int y = 0; y < h; ++y) {
            float yn;
            float xn;
            float yb;
            float xp = id[offs];
            float yp = yb = coefp * xp;
            for (int x = 0; x < w; ++x) {
                float yc;
                float xc = id[offs + x];
                od[offs + x] = yc = a0 * xc + a1 * xp - b1 * yp - b2 * yb;
                xp = xc;
                yb = yp;
                yp = yc;
            }
            float xa = xn = id[offs + w - 1];
            float ya = yn = coefn * xn;
            for (int x = w - 1; x >= 0; --x) {
                float xc = id[offs + x];
                float yc = a2 * xn + a3 * xa - b1 * yn - b2 * ya;
                int n = offs + x;
                od[n] = od[n] + yc;
                xa = xn;
                xn = xc;
                ya = yn;
                yn = yc;
            }
            offs += w;
        }
    }

    private static void gaussianRecursiveY(float[] od, float[] id, int w, int h, float a0, float a1, float a2, float a3, float b1, float b2, float coefp, float coefn) {
        for (int x = 0; x < w; ++x) {
            float yn;
            float xn;
            float yb;
            int offs = 0;
            float xp = id[x];
            float yp = yb = coefp * xp;
            for (int y = 0; y < h; ++y) {
                float yc;
                float xc = id[offs + x];
                od[offs + x] = yc = a0 * xc + a1 * xp - b1 * yp - b2 * yb;
                xp = xc;
                yb = yp;
                yp = yc;
                offs += w;
            }
            offs = (h - 1) * w;
            float xa = xn = id[offs + x];
            float ya = yn = coefn * xn;
            for (int y = h - 1; y >= 0; --y) {
                float xc = id[offs + x];
                float yc = a2 * xn + a3 * xa - b1 * yn - b2 * ya;
                int n = offs + x;
                od[n] = od[n] + yc;
                xa = xn;
                xn = xc;
                ya = yn;
                yn = yc;
                offs -= w;
            }
        }
    }

    private static void gaussianRecursive(float[] image, float[] temp, int w, int h, float sigma) {
        float k;
        float nsigma = sigma < 0.1f ? 0.1f : sigma;
        float alpha = 1.695f / nsigma;
        float ema = (float)Math.exp(-alpha);
        float ema2 = (float)Math.exp(-2.0f * alpha);
        float b1 = -2.0f * ema;
        float b2 = ema2;
        float a0 = k = (1.0f - ema) * (1.0f - ema) / (1.0f + 2.0f * alpha * ema - ema2);
        float a1 = k * (alpha - 1.0f) * ema;
        float a2 = k * (alpha + 1.0f) * ema;
        float a3 = -k * ema2;
        float coefp = (a0 + a1) / (1.0f + b1 + b2);
        float coefn = (a2 + a3) / (1.0f + b1 + b2);
        FastBilateralFilter.gaussianRecursiveX(temp, image, w, h, a0, a1, a2, a3, b1, b2, coefp, coefn);
        FastBilateralFilter.gaussianRecursiveY(image, temp, w, h, a0, a1, a2, a3, b1, b2, coefp, coefn);
    }

    private static float interpolateLinearXY(float[] image, float x, float y, int w) {
        int x0 = (int)x;
        int xt = x0 + 1;
        int y0 = (int)y;
        float dx = x - (float)x0;
        float dy = y - (float)y0;
        float dx1 = 1.0f - dx;
        float dy1 = 1.0f - dy;
        float d00 = dx1 * dy1;
        float d0t = dx * dy1;
        float dt0 = dx1 * dy;
        float dtt = dx * dy;
        int offs0 = y0 * w;
        int offst = offs0 + w;
        return d00 * image[offs0 + x0] + d0t * image[offs0 + xt] + dt0 * image[offst + x0] + dtt * image[offst + xt];
    }

    private static float interpolateLinearXY2(float[] image1, float[] image2, float alpha, float x, float y, int w) {
        int x0 = (int)x;
        int xt = x0 + 1;
        int y0 = (int)y;
        float dx = x - (float)x0;
        float dy = y - (float)y0;
        float dx1 = 1.0f - dx;
        float dy1 = 1.0f - dy;
        float d00 = dx1 * dy1;
        float d0t = dx * dy1;
        float dt0 = dx1 * dy;
        float dtt = dx * dy;
        int offs0 = y0 * w;
        int offst = offs0 + w;
        float res1 = d00 * image1[offs0 + x0] + d0t * image1[offs0 + xt] + dt0 * image1[offst + x0] + dtt * image1[offst + xt];
        float res2 = d00 * image2[offs0 + x0] + d0t * image2[offs0 + xt] + dt0 * image2[offst + x0] + dtt * image2[offst + xt];
        return alpha * res1 + (1.0f - alpha) * res2;
    }

    public boolean apply(IndexedIntArray source, IndexedIntArray destination) {
        int[] src = source.array;
        int[] dst = destination.array;
        int srcIdx = source.index;
        int dstIdx = destination.index;
        int[] buf1 = this.buffer1;
        float[] wk_ = this.wk;
        int ds = this.downSampling;
        int scaledH = this.height >> ds;
        int scaledW = this.width >> ds;
        int len = src.length;
        int[] buf2 = src;
        if (ds > 0) {
            buf2 = this.buffer2;
            int xx = srcIdx % this.stride;
            int yy = srcIdx / this.stride;
            int ww = this.width + xx < this.stride ? this.width : this.stride - xx;
            int hh = (this.height + yy) * this.stride <= len ? this.height : this.height - yy;
            DecimateDownSampler sampler = new DecimateDownSampler(ww, hh, this.stride, srcIdx, 1 << ds);
            sampler.subSample(src, buf2);
        } else if (srcIdx != 0 || this.stride != this.width) {
            buf2 = this.buffer2;
            int iOffs = srcIdx;
            int oOffs = dstIdx;
            for (int y = this.height; y > 0; --y) {
                System.arraycopy(src, iOffs, buf2, oOffs, this.width);
                iOffs += this.stride;
                oOffs += this.width;
            }
        }
        for (int channel = 0; channel < this.channels; ++channel) {
            int shift = channel << 3;
            int min = 255;
            int max = 0;
            for (int i = 0; i < buf1.length; ++i) {
                int val = buf2[i] >> shift & 0xFF;
                max -= max - val >> 31 & max - val;
                min += val - min >> 31 & val - min;
                buf1[i] = val;
            }
            float fmin = min;
            float fmax = max;
            int maxGrayIdx = this.grayscale.length - 1;
            this.grayscale[0] = fmin;
            this.grayscale[maxGrayIdx] = fmax;
            float delta = fmax - fmin + 0.01f;
            for (int i = 1; i < maxGrayIdx; ++i) {
                this.grayscale[i] = (float)min + (float)i * (delta / (float)maxGrayIdx);
            }
            int jk_idx0 = 0;
            int jk_idx1 = 1;
            float[] jk_ = this.jk[0];
            float shift_inv = 1.0f / (float)(1 << ds);
            float delta_scale = (float)maxGrayIdx / delta;
            for (int grayRangeIdx = 0; grayRangeIdx <= maxGrayIdx; ++grayRangeIdx) {
                int offs = 0;
                float gray = this.grayscale[grayRangeIdx];
                for (int y = 0; y < scaledH; ++y) {
                    int end = offs + scaledW;
                    for (int x = offs; x < end; ++x) {
                        int val = buf1[x] & 0xFF;
                        int colorIdx = (int)(Math.abs(gray - (float)val) + 0.5f);
                        int color = this.colors[colorIdx];
                        jk_[x] = color * val;
                        wk_[x] = color;
                    }
                    offs += scaledW;
                }
                FastBilateralFilter.gaussianRecursive(jk_, this.box, scaledW, scaledH, this.radius);
                FastBilateralFilter.gaussianRecursive(wk_, this.box, scaledW, scaledH, this.radius);
                int scaledSize = scaledW * scaledH;
                float maxW = scaledW - 2;
                float maxH = scaledH - 2;
                int w = this.width;
                for (int n = 0; n < scaledSize; ++n) {
                    int n2 = n;
                    jk_[n2] = jk_[n2] / wk_[n];
                }
                if (grayRangeIdx != 0) {
                    int iOffs = srcIdx;
                    int oOffs = dstIdx;
                    float[] jk0 = this.jk[jk_idx0];
                    float[] jk1 = this.jk[jk_idx1];
                    for (int y = 0; y < this.height; ++y) {
                        float ys = Math.min((float)y * shift_inv, maxH);
                        int endX = iOffs + w < len ? w : len - iOffs;
                        for (int x = 0; x < endX; ++x) {
                            int val = src[iOffs + x] >> shift & 0xFF;
                            float kf = (float)(val - min) * delta_scale;
                            int k = (int)kf;
                            if (k == grayRangeIdx - 1) {
                                float alpha = (float)(k + 1) - kf;
                                float xs = Math.min((float)x * shift_inv, maxW);
                                int val2 = (int)FastBilateralFilter.interpolateLinearXY2(jk0, jk1, alpha, xs, ys, scaledW);
                                int n = oOffs + x;
                                dst[n] = dst[n] & ~(255 << shift);
                                int n3 = oOffs + x;
                                dst[n3] = dst[n3] | (val2 & 0xFF) << shift;
                                continue;
                            }
                            if (grayRangeIdx != maxGrayIdx || k != grayRangeIdx) continue;
                            float xs = Math.min((float)x * shift_inv, maxW);
                            int val2 = (int)(FastBilateralFilter.interpolateLinearXY(jk1, xs, ys, scaledW) + 0.5f);
                            int n = oOffs + x;
                            dst[n] = dst[n] & ~(255 << shift);
                            int n4 = oOffs + x;
                            dst[n4] = dst[n4] | (val2 & 0xFF) << shift;
                        }
                        oOffs += this.stride;
                        if ((iOffs += this.stride) >= len) break;
                    }
                    jk_idx1 = jk_idx0;
                    jk_idx0 = 1 - jk_idx1;
                }
                jk_ = this.jk[jk_idx1];
            }
        }
        return true;
    }
}

