/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.mser;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import net.semanticmetadata.lire.imageanalysis.mser.BoundaryPixel;
import net.semanticmetadata.lire.imageanalysis.mser.ImagePoint;

public class ImageMask {
    protected static int NO_ACCESS = 0;
    protected static int ACCESS = 1;
    protected static int VISITED = 2;
    int[] pixels;
    int[] accessible;
    BufferedImage image;

    public ImageMask(BufferedImage image) {
        this.image = image;
        int[] pixels = new int[image.getHeight() * image.getWidth()];
        WritableRaster ip = image.getRaster();
        int[] p = new int[3];
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                pixels[this.getIndex((int)x, (int)y)] = ip.getPixel(x, y, p)[0];
            }
        }
        this.pixels = pixels;
        this.accessible = new int[pixels.length];
        for (int i = 0; i < this.accessible.length; ++i) {
            this.accessible[i] = NO_ACCESS;
        }
    }

    public boolean hasAccess(int idx) {
        return this.accessible[idx] == ACCESS;
    }

    public boolean getAccess(int idx) {
        if (idx < this.accessible.length && this.accessible[idx] == NO_ACCESS) {
            this.accessible[idx] = ACCESS;
            return true;
        }
        return false;
    }

    public int getValue(int idx) {
        return this.pixels[idx];
    }

    public int getX(int idx) {
        return ImageMask.getX(idx, this.image.getWidth());
    }

    public int getY(int idx) {
        return ImageMask.getY(idx, this.image.getWidth());
    }

    public int getIndex(int x, int y) {
        return ImageMask.getIndex(x, y, this.image.getWidth());
    }

    public ImagePoint getImagePoint(int index) {
        return new ImagePoint(index, this.getX(index), this.getY(index));
    }

    public BoundaryPixel getBoundaryPixel(int index) {
        return new BoundaryPixel(this.getImagePoint(index), this.image.getWidth(), this.image.getHeight());
    }

    public static int getX(int idx, int imageWidth) {
        return idx % imageWidth;
    }

    public static int getY(int idx, int imageWidth) {
        return idx / imageWidth;
    }

    public static int getIndex(int x, int y, int imageWidth) {
        return y * imageWidth + x;
    }
}

