/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.mser;

import java.util.Stack;
import net.semanticmetadata.lire.imageanalysis.mser.BoundaryPixel;

public class MSERHeap {
    boolean[] bitmask;
    Stack<BoundaryPixel>[] stacks;

    public MSERHeap(int levels) {
        this.bitmask = new boolean[levels];
        this.stacks = new Stack[levels];
        for (int i = 0; i < levels; ++i) {
            this.bitmask[i] = false;
            this.stacks[i] = new Stack();
        }
    }

    public BoundaryPixel pop() {
        for (int i = 0; i < this.bitmask.length; ++i) {
            if (!this.bitmask[i]) continue;
            BoundaryPixel pix = this.stacks[i].pop();
            this.bitmask[i] = !this.stacks[i].empty();
            return pix;
        }
        return null;
    }

    public void push(BoundaryPixel e, int greyValue) {
        if (!this.bitmask[greyValue]) {
            this.bitmask[greyValue] = true;
        }
        this.stacks[greyValue].push(e);
    }
}

