/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.impl;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import net.semanticmetadata.lire.AbstractDocumentBuilder;
import net.semanticmetadata.lire.imageanalysis.AutoColorCorrelogram;
import net.semanticmetadata.lire.imageanalysis.BinaryPatternsPyramid;
import net.semanticmetadata.lire.imageanalysis.CEDD;
import net.semanticmetadata.lire.imageanalysis.ColorLayout;
import net.semanticmetadata.lire.imageanalysis.EdgeHistogram;
import net.semanticmetadata.lire.imageanalysis.FCTH;
import net.semanticmetadata.lire.imageanalysis.Gabor;
import net.semanticmetadata.lire.imageanalysis.JCD;
import net.semanticmetadata.lire.imageanalysis.JpegCoefficientHistogram;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.imageanalysis.LocalBinaryPatterns;
import net.semanticmetadata.lire.imageanalysis.LuminanceLayout;
import net.semanticmetadata.lire.imageanalysis.OpponentHistogram;
import net.semanticmetadata.lire.imageanalysis.PHOG;
import net.semanticmetadata.lire.imageanalysis.RotationInvariantLocalBinaryPatterns;
import net.semanticmetadata.lire.imageanalysis.ScalableColor;
import net.semanticmetadata.lire.imageanalysis.SimpleColorHistogram;
import net.semanticmetadata.lire.imageanalysis.Tamura;
import net.semanticmetadata.lire.imageanalysis.joint.JointHistogram;
import net.semanticmetadata.lire.indexing.hashing.BitSampling;
import net.semanticmetadata.lire.indexing.hashing.LocalitySensitiveHashing;
import net.semanticmetadata.lire.utils.ImageUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;

public class GenericDocumentBuilder
extends AbstractDocumentBuilder {
    private boolean hashingEnabled = false;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    public static final int MAX_IMAGE_DIMENSION = 1024;
    Class<? extends LireFeature> descriptorClass;
    String fieldName;
    static final Mode DEFAULT_MODE = Mode.Fast;
    Mode currentMode = DEFAULT_MODE;
    protected HashingMode hashingMode = HashingMode.BitSampling;
    public static HashMap<Class, String> fieldForClass = new HashMap();
    public static HashMap<String, Class> classForField = new HashMap();
    public static final String HASH_FIELD_SUFFIX = "_hash";

    public GenericDocumentBuilder(Class<? extends LireFeature> descriptorClass, String fieldName) {
        this.descriptorClass = descriptorClass;
        this.fieldName = fieldName;
    }

    public GenericDocumentBuilder(Class<? extends LireFeature> descriptorClass) {
        this.descriptorClass = descriptorClass;
        this.fieldName = fieldForClass.get(descriptorClass);
        if (this.fieldName == null) {
            try {
                this.fieldName = descriptorClass.newInstance().getFieldName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public GenericDocumentBuilder(Class<? extends LireFeature> descriptorClass, boolean hashing, HashingMode mode) {
        this.descriptorClass = descriptorClass;
        this.fieldName = fieldForClass.get(descriptorClass);
        this.hashingMode = mode;
        if (this.fieldName == null) {
            try {
                this.fieldName = descriptorClass.newInstance().getFieldName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.hashingEnabled = hashing;
    }

    public GenericDocumentBuilder(Class<? extends LireFeature> descriptorClass, boolean hashing) {
        this.descriptorClass = descriptorClass;
        this.fieldName = fieldForClass.get(descriptorClass);
        if (this.fieldName == null) {
            try {
                this.fieldName = descriptorClass.newInstance().getFieldName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.hashingEnabled = hashing;
    }

    public GenericDocumentBuilder(Class<? extends LireFeature> descriptorClass, String fieldName, boolean hashing) {
        this.descriptorClass = descriptorClass;
        this.fieldName = fieldName;
        this.hashingEnabled = hashing;
    }

    public GenericDocumentBuilder(Class<? extends LireFeature> descriptorClass, String fieldName, Mode mode) {
        this.descriptorClass = descriptorClass;
        this.fieldName = fieldName;
        this.currentMode = mode;
    }

    @Override
    public Field[] createDescriptorFields(BufferedImage image) {
        Field[] result = this.hashingEnabled ? new Field[2] : new Field[1];
        String featureString = "";
        assert (image != null);
        BufferedImage bimg = image;
        if (Math.max(image.getHeight(), image.getWidth()) > 1024) {
            bimg = ImageUtils.scaleImage(image, 1024);
        }
        Object doc = null;
        try {
            this.logger.finer("Starting extraction from image [" + this.descriptorClass.getName() + "].");
            LireFeature lireFeature = null;
            lireFeature = this.descriptorClass.newInstance();
            lireFeature.extract(bimg);
            this.logger.fine("Extraction finished [" + this.descriptorClass.getName() + "].");
            result[0] = new StoredField(this.fieldName, lireFeature.getByteArrayRepresentation());
            if (this.hashingEnabled) {
                if (lireFeature.getDoubleHistogram().length <= 3100) {
                    int[] hashes = this.hashingMode == HashingMode.BitSampling ? BitSampling.generateHashes(lireFeature.getDoubleHistogram()) : LocalitySensitiveHashing.generateHashes(lireFeature.getDoubleHistogram());
                    result[1] = new TextField(this.fieldName + HASH_FIELD_SUFFIX, SerializationUtils.arrayToString(hashes), Field.Store.YES);
                } else {
                    System.err.println("Could not create hashes, feature vector too long: " + lireFeature.getDoubleHistogram().length + " (" + lireFeature.getClass().getName() + ")");
                }
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Document createDocument(BufferedImage image, String identifier) {
        assert (image != null);
        Document doc = new Document();
        if (identifier != null) {
            doc.add((IndexableField)new StringField("descriptorImageIdentifier", identifier, Field.Store.YES));
        }
        Field[] fields = this.createDescriptorFields(image);
        for (int i = 0; i < fields.length; ++i) {
            doc.add((IndexableField)fields[i]);
        }
        return doc;
    }

    static {
        try {
            BitSampling.readHashFunctions();
        }
        catch (IOException e) {
            System.err.println("Could not read hashes from file when first creating a GenericDocumentBuilder instance.");
            e.printStackTrace();
        }
        fieldForClass.put(AutoColorCorrelogram.class, "featureAutoColorCorrelogram");
        fieldForClass.put(BinaryPatternsPyramid.class, "feat_bpp");
        fieldForClass.put(CEDD.class, "featureCEDD");
        fieldForClass.put(SimpleColorHistogram.class, "featureColorHistogram");
        fieldForClass.put(ColorLayout.class, "descriptorColorLayout");
        fieldForClass.put(EdgeHistogram.class, "descriptorEdgeHistogram");
        fieldForClass.put(FCTH.class, "featureFCTH");
        fieldForClass.put(Gabor.class, "featureGabor");
        fieldForClass.put(JCD.class, "featureJCD");
        fieldForClass.put(JointHistogram.class, "featureJointHist");
        fieldForClass.put(JpegCoefficientHistogram.class, "featureJpegCoeffs");
        fieldForClass.put(LocalBinaryPatterns.class, "featLBP");
        fieldForClass.put(LuminanceLayout.class, "featLumLay");
        fieldForClass.put(OpponentHistogram.class, "featOpHist");
        fieldForClass.put(PHOG.class, "featPHOG");
        fieldForClass.put(RotationInvariantLocalBinaryPatterns.class, "featRILBP");
        fieldForClass.put(ScalableColor.class, "descriptorScalableColor");
        fieldForClass.put(Tamura.class, "featureTAMURA");
        classForField.put("featureAutoColorCorrelogram", AutoColorCorrelogram.class);
        classForField.put("feat_bpp", BinaryPatternsPyramid.class);
        classForField.put("featureCEDD", CEDD.class);
        classForField.put("featureColorHistogram", SimpleColorHistogram.class);
        classForField.put("descriptorColorLayout", ColorLayout.class);
        classForField.put("descriptorEdgeHistogram", EdgeHistogram.class);
        classForField.put("featureFCTH", FCTH.class);
        classForField.put("featureGabor", Gabor.class);
        classForField.put("featureJCD", JCD.class);
        classForField.put("featureJointHist", JointHistogram.class);
        classForField.put("featureJpegCoeffs", JpegCoefficientHistogram.class);
        classForField.put("featLBP", LocalBinaryPatterns.class);
        classForField.put("featLumLay", LuminanceLayout.class);
        classForField.put("featOpHist", OpponentHistogram.class);
        classForField.put("featPHOG", PHOG.class);
        classForField.put("featRILBP", RotationInvariantLocalBinaryPatterns.class);
        classForField.put("descriptorScalableColor", ScalableColor.class);
        classForField.put("featureTAMURA", Tamura.class);
    }

    public static enum Mode {
        Fast,
        Slow;

    }

    static enum HashingMode {
        BitSampling,
        LSH;

    }
}

