/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.impl;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.semanticmetadata.lire.AbstractImageSearcher;
import net.semanticmetadata.lire.ImageDuplicates;
import net.semanticmetadata.lire.ImageSearchHits;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.impl.SimpleImageDuplicates;
import net.semanticmetadata.lire.impl.SimpleImageSearchHits;
import net.semanticmetadata.lire.impl.SimpleResult;
import net.semanticmetadata.lire.utils.ImageUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.util.Bits;

public class GenericFastImageSearcher
extends AbstractImageSearcher {
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    Class<?> descriptorClass;
    String fieldName;
    private LireFeature cachedInstance = null;
    private boolean isCaching = false;
    private LinkedList<byte[]> featureCache;
    private IndexReader reader;
    private int maxHits = 10;
    protected TreeSet<SimpleResult> docs;
    private float maxDistance;

    public GenericFastImageSearcher(int maxHits, Class<?> descriptorClass, String fieldName) {
        this.maxHits = maxHits;
        this.docs = new TreeSet();
        this.descriptorClass = descriptorClass;
        this.fieldName = fieldName;
        try {
            this.cachedInstance = (LireFeature)this.descriptorClass.newInstance();
        }
        catch (InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher (" + descriptorClass.getName() + "): " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher (" + descriptorClass.getName() + "): " + e.getMessage());
        }
        this.init();
    }

    public GenericFastImageSearcher(int maxHits, Class<?> descriptorClass) {
        this.maxHits = maxHits;
        this.docs = new TreeSet();
        this.descriptorClass = descriptorClass;
        try {
            this.cachedInstance = (LireFeature)this.descriptorClass.newInstance();
        }
        catch (InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher (" + descriptorClass.getName() + "): " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher (" + descriptorClass.getName() + "): " + e.getMessage());
        }
        this.fieldName = this.cachedInstance.getFieldName();
        this.init();
    }

    private void init() {
        if (this.isCaching && this.reader != null) {
            int docs = this.reader.numDocs();
            this.featureCache = new LinkedList();
            try {
                for (int i = 0; i < docs; ++i) {
                    Document d = this.reader.document(i);
                    this.cachedInstance.setByteArrayRepresentation(d.getField((String)this.fieldName).binaryValue().bytes, d.getField((String)this.fieldName).binaryValue().offset, d.getField((String)this.fieldName).binaryValue().length);
                    this.featureCache.add(this.cachedInstance.getByteArrayRepresentation());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public GenericFastImageSearcher(int maxHits, Class<?> descriptorClass, String fieldName, boolean isCaching, IndexReader reader) {
        this.isCaching = isCaching;
        this.maxHits = maxHits;
        this.docs = new TreeSet();
        this.descriptorClass = descriptorClass;
        this.fieldName = fieldName;
        try {
            this.cachedInstance = (LireFeature)this.descriptorClass.newInstance();
        }
        catch (InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher (" + descriptorClass.getName() + "): " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher (" + descriptorClass.getName() + "): " + e.getMessage());
        }
        this.reader = reader;
        this.init();
    }

    public GenericFastImageSearcher(int maxHits, Class<?> descriptorClass, boolean isCaching, IndexReader reader) {
        this.isCaching = isCaching;
        this.maxHits = maxHits;
        this.docs = new TreeSet();
        this.descriptorClass = descriptorClass;
        try {
            this.cachedInstance = (LireFeature)this.descriptorClass.newInstance();
        }
        catch (InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher (" + descriptorClass.getName() + "): " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher (" + descriptorClass.getName() + "): " + e.getMessage());
        }
        this.reader = reader;
        this.fieldName = this.cachedInstance.getFieldName();
        this.init();
    }

    @Override
    public ImageSearchHits search(BufferedImage image, IndexReader reader) throws IOException {
        this.logger.finer("Starting extraction.");
        LireFeature lireFeature = null;
        SimpleImageSearchHits searchHits = null;
        try {
            lireFeature = (LireFeature)this.descriptorClass.newInstance();
            BufferedImage bimg = image;
            if (Math.max(image.getHeight(), image.getWidth()) > 1024) {
                bimg = ImageUtils.scaleImage(image, 1024);
            }
            lireFeature.extract(bimg);
            this.logger.fine("Extraction from image finished");
            float maxDistance = this.findSimilar(reader, lireFeature);
            searchHits = new SimpleImageSearchHits(this.docs, maxDistance);
        }
        catch (InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        return searchHits;
    }

    protected float findSimilar(IndexReader reader, LireFeature lireFeature) throws IOException {
        this.maxDistance = -1.0f;
        this.docs.clear();
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
        int docs = reader.numDocs();
        if (!this.isCaching) {
            for (int i = 0; i < docs; ++i) {
                if (reader.hasDeletions() && !liveDocs.get(i)) continue;
                Document d = reader.document(i);
                float tmpDistance = this.getDistance(d, lireFeature);
                assert (tmpDistance >= 0.0f);
                if (this.maxDistance < 0.0f) {
                    this.maxDistance = tmpDistance;
                }
                if (this.docs.size() < this.maxHits) {
                    this.docs.add(new SimpleResult(tmpDistance, d, i));
                    if (!(tmpDistance > this.maxDistance)) continue;
                    this.maxDistance = tmpDistance;
                    continue;
                }
                if (!(tmpDistance < this.maxDistance)) continue;
                this.docs.remove(this.docs.last());
                this.docs.add(new SimpleResult(tmpDistance, d, i));
                this.maxDistance = this.docs.last().getDistance();
            }
        } else {
            int count = 0;
            Iterator iterator = this.featureCache.iterator();
            while (iterator.hasNext()) {
                this.cachedInstance.setByteArrayRepresentation((byte[])iterator.next());
                if (reader.hasDeletions() && !liveDocs.get(count)) {
                    ++count;
                    continue;
                }
                float tmpDistance = lireFeature.getDistance(this.cachedInstance);
                assert (tmpDistance >= 0.0f);
                if (this.maxDistance < 0.0f) {
                    this.maxDistance = tmpDistance;
                }
                if (this.docs.size() < this.maxHits) {
                    this.docs.add(new SimpleResult(tmpDistance, reader.document(count), count));
                    if (tmpDistance > this.maxDistance) {
                        this.maxDistance = tmpDistance;
                    }
                } else if (tmpDistance < this.maxDistance) {
                    this.docs.remove(this.docs.last());
                    this.docs.add(new SimpleResult(tmpDistance, reader.document(count), count));
                    this.maxDistance = this.docs.last().getDistance();
                }
                ++count;
            }
        }
        return this.maxDistance;
    }

    protected float getDistance(Document document, LireFeature lireFeature) {
        if (document.getField(this.fieldName).binaryValue() != null && document.getField((String)this.fieldName).binaryValue().length > 0) {
            this.cachedInstance.setByteArrayRepresentation(document.getField((String)this.fieldName).binaryValue().bytes, document.getField((String)this.fieldName).binaryValue().offset, document.getField((String)this.fieldName).binaryValue().length);
            return lireFeature.getDistance(this.cachedInstance);
        }
        this.logger.warning("No feature stored in this document! (" + this.descriptorClass.getName() + ")");
        return 0.0f;
    }

    @Override
    public ImageSearchHits search(Document doc, IndexReader reader) throws IOException {
        SimpleImageSearchHits searchHits = null;
        try {
            LireFeature lireFeature = (LireFeature)this.descriptorClass.newInstance();
            if (doc.getField(this.fieldName).binaryValue() != null && doc.getField((String)this.fieldName).binaryValue().length > 0) {
                lireFeature.setByteArrayRepresentation(doc.getField((String)this.fieldName).binaryValue().bytes, doc.getField((String)this.fieldName).binaryValue().offset, doc.getField((String)this.fieldName).binaryValue().length);
            }
            float maxDistance = this.findSimilar(reader, lireFeature);
            searchHits = new SimpleImageSearchHits(this.docs, maxDistance);
        }
        catch (InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        return searchHits;
    }

    @Override
    public ImageDuplicates findDuplicates(IndexReader reader) throws IOException {
        SimpleImageDuplicates simpleImageDuplicates = null;
        try {
            Document doc = reader.document(0);
            LireFeature lireFeature = (LireFeature)this.descriptorClass.newInstance();
            if (doc.getField(this.fieldName).binaryValue() != null && doc.getField((String)this.fieldName).binaryValue().length > 0) {
                lireFeature.setByteArrayRepresentation(doc.getField((String)this.fieldName).binaryValue().bytes, doc.getField((String)this.fieldName).binaryValue().offset, doc.getField((String)this.fieldName).binaryValue().length);
            }
            HashMap duplicates = new HashMap();
            Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
            int docs = reader.numDocs();
            int numDuplicates = 0;
            for (int i = 0; i < docs; ++i) {
                if (reader.hasDeletions() && !liveDocs.get(i)) continue;
                Document d = reader.document(i);
                float distance = this.getDistance(d, lireFeature);
                if (!duplicates.containsKey(Float.valueOf(distance))) {
                    duplicates.put(Float.valueOf(distance), new LinkedList());
                } else {
                    ++numDuplicates;
                }
                ((List)duplicates.get(Float.valueOf(distance))).add(d.getField("descriptorImageIdentifier").stringValue());
            }
            if (numDuplicates == 0) {
                return null;
            }
            LinkedList<List<String>> results = new LinkedList<List<String>>();
            Iterator i$ = duplicates.keySet().iterator();
            while (i$.hasNext()) {
                float f = ((Float)i$.next()).floatValue();
                if (((List)duplicates.get(Float.valueOf(f))).size() <= 1) continue;
                results.add((List<String>)duplicates.get(Float.valueOf(f)));
            }
            simpleImageDuplicates = new SimpleImageDuplicates(results);
        }
        catch (InstantiationException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error instantiating class for generic image searcher: " + e.getMessage());
        }
        return simpleImageDuplicates;
    }

    public String toString() {
        return "GenericSearcher using " + this.descriptorClass.getName();
    }
}

