/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.impl;

import java.awt.image.BufferedImage;
import java.util.List;
import net.semanticmetadata.lire.AbstractDocumentBuilder;
import net.semanticmetadata.lire.imageanalysis.mser.MSER;
import net.semanticmetadata.lire.imageanalysis.mser.MSERFeature;
import net.semanticmetadata.lire.utils.ImageUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;

public class MSERDocumentBuilder
extends AbstractDocumentBuilder {
    private MSER extractor = new MSER();

    @Override
    public Field[] createDescriptorFields(BufferedImage image) {
        throw new UnsupportedOperationException("createDescriptorFields(BufferedImage image) not implemented for MSER!");
    }

    @Override
    public Document createDocument(BufferedImage image, String identifier) {
        Document doc = null;
        try {
            BufferedImage image1 = this.convertImageToGrey(image);
            List<MSERFeature> features = this.extractor.computeMSERFeatures(image1);
            ImageUtils.invertImage(image1);
            features.addAll(this.extractor.computeMSERFeatures(image1));
            doc = new Document();
            if (features.size() < 1) {
                System.err.println("No MSER features found for " + identifier);
            }
            for (MSERFeature f : features) {
                boolean skip = false;
                int j = 0;
                if (j < f.descriptor.length && Double.isNaN(f.descriptor[j])) {
                    skip = true;
                }
                if (skip) continue;
                doc.add((IndexableField)new StoredField("featureMSER", f.getByteArrayRepresentation()));
            }
            if (identifier != null) {
                doc.add((IndexableField)new StringField("descriptorImageIdentifier", identifier, Field.Store.YES));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    public BufferedImage convertImageToGrey(BufferedImage image) {
        BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        result.getGraphics().drawImage(image, 0, 0, null);
        return result;
    }
}

